/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

// Protobuf Java Version: 3.25.3
package com.google.storage.v2;

/**
 *
 *
 * <pre>
 * The result of a call to Buckets.ListBuckets
 * </pre>
 *
 * Protobuf type {@code google.storage.v2.ListBucketsResponse}
 */
public final class ListBucketsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.v2.ListBucketsResponse)
    ListBucketsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListBucketsResponse.newBuilder() to construct.
  private ListBucketsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListBucketsResponse() {
    buckets_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListBucketsResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_ListBucketsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_ListBucketsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.v2.ListBucketsResponse.class,
            com.google.storage.v2.ListBucketsResponse.Builder.class);
  }

  public static final int BUCKETS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.storage.v2.Bucket> buckets_;
  /**
   *
   *
   * <pre>
   * The list of items.
   * </pre>
   *
   * <code>repeated .google.storage.v2.Bucket buckets = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.storage.v2.Bucket> getBucketsList() {
    return buckets_;
  }
  /**
   *
   *
   * <pre>
   * The list of items.
   * </pre>
   *
   * <code>repeated .google.storage.v2.Bucket buckets = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.storage.v2.BucketOrBuilder> getBucketsOrBuilderList() {
    return buckets_;
  }
  /**
   *
   *
   * <pre>
   * The list of items.
   * </pre>
   *
   * <code>repeated .google.storage.v2.Bucket buckets = 1;</code>
   */
  @java.lang.Override
  public int getBucketsCount() {
    return buckets_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of items.
   * </pre>
   *
   * <code>repeated .google.storage.v2.Bucket buckets = 1;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket getBuckets(int index) {
    return buckets_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of items.
   * </pre>
   *
   * <code>repeated .google.storage.v2.Bucket buckets = 1;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.BucketOrBuilder getBucketsOrBuilder(int index) {
    return buckets_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextPageToken_ = "";
  /**
   *
   *
   * <pre>
   * The continuation token, used to page through large result sets. Provide
   * this value in a subsequent request to return the next page of results.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The continuation token, used to page through large result sets. Provide
   * this value in a subsequent request to return the next page of results.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < buckets_.size(); i++) {
      output.writeMessage(1, buckets_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nextPageToken_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < buckets_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, buckets_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nextPageToken_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.storage.v2.ListBucketsResponse)) {
      return super.equals(obj);
    }
    com.google.storage.v2.ListBucketsResponse other =
        (com.google.storage.v2.ListBucketsResponse) obj;

    if (!getBucketsList().equals(other.getBucketsList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getBucketsCount() > 0) {
      hash = (37 * hash) + BUCKETS_FIELD_NUMBER;
      hash = (53 * hash) + getBucketsList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.v2.ListBucketsResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.ListBucketsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.ListBucketsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.ListBucketsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.ListBucketsResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.ListBucketsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.ListBucketsResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.ListBucketsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.ListBucketsResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.ListBucketsResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.ListBucketsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.ListBucketsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.storage.v2.ListBucketsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The result of a call to Buckets.ListBuckets
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.ListBucketsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.v2.ListBucketsResponse)
      com.google.storage.v2.ListBucketsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_ListBucketsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_ListBucketsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.ListBucketsResponse.class,
              com.google.storage.v2.ListBucketsResponse.Builder.class);
    }

    // Construct using com.google.storage.v2.ListBucketsResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (bucketsBuilder_ == null) {
        buckets_ = java.util.Collections.emptyList();
      } else {
        buckets_ = null;
        bucketsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      nextPageToken_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_ListBucketsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.storage.v2.ListBucketsResponse getDefaultInstanceForType() {
      return com.google.storage.v2.ListBucketsResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.v2.ListBucketsResponse build() {
      com.google.storage.v2.ListBucketsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.v2.ListBucketsResponse buildPartial() {
      com.google.storage.v2.ListBucketsResponse result =
          new com.google.storage.v2.ListBucketsResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.storage.v2.ListBucketsResponse result) {
      if (bucketsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          buckets_ = java.util.Collections.unmodifiableList(buckets_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.buckets_ = buckets_;
      } else {
        result.buckets_ = bucketsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.storage.v2.ListBucketsResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.nextPageToken_ = nextPageToken_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.storage.v2.ListBucketsResponse) {
        return mergeFrom((com.google.storage.v2.ListBucketsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.storage.v2.ListBucketsResponse other) {
      if (other == com.google.storage.v2.ListBucketsResponse.getDefaultInstance()) return this;
      if (bucketsBuilder_ == null) {
        if (!other.buckets_.isEmpty()) {
          if (buckets_.isEmpty()) {
            buckets_ = other.buckets_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureBucketsIsMutable();
            buckets_.addAll(other.buckets_);
          }
          onChanged();
        }
      } else {
        if (!other.buckets_.isEmpty()) {
          if (bucketsBuilder_.isEmpty()) {
            bucketsBuilder_.dispose();
            bucketsBuilder_ = null;
            buckets_ = other.buckets_;
            bitField0_ = (bitField0_ & ~0x00000001);
            bucketsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getBucketsFieldBuilder()
                    : null;
          } else {
            bucketsBuilder_.addAllMessages(other.buckets_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.storage.v2.Bucket m =
                    input.readMessage(com.google.storage.v2.Bucket.parser(), extensionRegistry);
                if (bucketsBuilder_ == null) {
                  ensureBucketsIsMutable();
                  buckets_.add(m);
                } else {
                  bucketsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                nextPageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.storage.v2.Bucket> buckets_ =
        java.util.Collections.emptyList();

    private void ensureBucketsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        buckets_ = new java.util.ArrayList<com.google.storage.v2.Bucket>(buckets_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.storage.v2.Bucket,
            com.google.storage.v2.Bucket.Builder,
            com.google.storage.v2.BucketOrBuilder>
        bucketsBuilder_;

    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket buckets = 1;</code>
     */
    public java.util.List<com.google.storage.v2.Bucket> getBucketsList() {
      if (bucketsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(buckets_);
      } else {
        return bucketsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket buckets = 1;</code>
     */
    public int getBucketsCount() {
      if (bucketsBuilder_ == null) {
        return buckets_.size();
      } else {
        return bucketsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket buckets = 1;</code>
     */
    public com.google.storage.v2.Bucket getBuckets(int index) {
      if (bucketsBuilder_ == null) {
        return buckets_.get(index);
      } else {
        return bucketsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket buckets = 1;</code>
     */
    public Builder setBuckets(int index, com.google.storage.v2.Bucket value) {
      if (bucketsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBucketsIsMutable();
        buckets_.set(index, value);
        onChanged();
      } else {
        bucketsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket buckets = 1;</code>
     */
    public Builder setBuckets(int index, com.google.storage.v2.Bucket.Builder builderForValue) {
      if (bucketsBuilder_ == null) {
        ensureBucketsIsMutable();
        buckets_.set(index, builderForValue.build());
        onChanged();
      } else {
        bucketsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket buckets = 1;</code>
     */
    public Builder addBuckets(com.google.storage.v2.Bucket value) {
      if (bucketsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBucketsIsMutable();
        buckets_.add(value);
        onChanged();
      } else {
        bucketsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket buckets = 1;</code>
     */
    public Builder addBuckets(int index, com.google.storage.v2.Bucket value) {
      if (bucketsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBucketsIsMutable();
        buckets_.add(index, value);
        onChanged();
      } else {
        bucketsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket buckets = 1;</code>
     */
    public Builder addBuckets(com.google.storage.v2.Bucket.Builder builderForValue) {
      if (bucketsBuilder_ == null) {
        ensureBucketsIsMutable();
        buckets_.add(builderForValue.build());
        onChanged();
      } else {
        bucketsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket buckets = 1;</code>
     */
    public Builder addBuckets(int index, com.google.storage.v2.Bucket.Builder builderForValue) {
      if (bucketsBuilder_ == null) {
        ensureBucketsIsMutable();
        buckets_.add(index, builderForValue.build());
        onChanged();
      } else {
        bucketsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket buckets = 1;</code>
     */
    public Builder addAllBuckets(
        java.lang.Iterable<? extends com.google.storage.v2.Bucket> values) {
      if (bucketsBuilder_ == null) {
        ensureBucketsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, buckets_);
        onChanged();
      } else {
        bucketsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket buckets = 1;</code>
     */
    public Builder clearBuckets() {
      if (bucketsBuilder_ == null) {
        buckets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        bucketsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket buckets = 1;</code>
     */
    public Builder removeBuckets(int index) {
      if (bucketsBuilder_ == null) {
        ensureBucketsIsMutable();
        buckets_.remove(index);
        onChanged();
      } else {
        bucketsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket buckets = 1;</code>
     */
    public com.google.storage.v2.Bucket.Builder getBucketsBuilder(int index) {
      return getBucketsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket buckets = 1;</code>
     */
    public com.google.storage.v2.BucketOrBuilder getBucketsOrBuilder(int index) {
      if (bucketsBuilder_ == null) {
        return buckets_.get(index);
      } else {
        return bucketsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket buckets = 1;</code>
     */
    public java.util.List<? extends com.google.storage.v2.BucketOrBuilder>
        getBucketsOrBuilderList() {
      if (bucketsBuilder_ != null) {
        return bucketsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(buckets_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket buckets = 1;</code>
     */
    public com.google.storage.v2.Bucket.Builder addBucketsBuilder() {
      return getBucketsFieldBuilder().addBuilder(com.google.storage.v2.Bucket.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket buckets = 1;</code>
     */
    public com.google.storage.v2.Bucket.Builder addBucketsBuilder(int index) {
      return getBucketsFieldBuilder()
          .addBuilder(index, com.google.storage.v2.Bucket.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of items.
     * </pre>
     *
     * <code>repeated .google.storage.v2.Bucket buckets = 1;</code>
     */
    public java.util.List<com.google.storage.v2.Bucket.Builder> getBucketsBuilderList() {
      return getBucketsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.storage.v2.Bucket,
            com.google.storage.v2.Bucket.Builder,
            com.google.storage.v2.BucketOrBuilder>
        getBucketsFieldBuilder() {
      if (bucketsBuilder_ == null) {
        bucketsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.storage.v2.Bucket,
                com.google.storage.v2.Bucket.Builder,
                com.google.storage.v2.BucketOrBuilder>(
                buckets_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        buckets_ = null;
      }
      return bucketsBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * The continuation token, used to page through large result sets. Provide
     * this value in a subsequent request to return the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The continuation token, used to page through large result sets. Provide
     * this value in a subsequent request to return the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The continuation token, used to page through large result sets. Provide
     * this value in a subsequent request to return the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The continuation token, used to page through large result sets. Provide
     * this value in a subsequent request to return the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {
      nextPageToken_ = getDefaultInstance().getNextPageToken();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The continuation token, used to page through large result sets. Provide
     * this value in a subsequent request to return the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.v2.ListBucketsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.storage.v2.ListBucketsResponse)
  private static final com.google.storage.v2.ListBucketsResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.storage.v2.ListBucketsResponse();
  }

  public static com.google.storage.v2.ListBucketsResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListBucketsResponse> PARSER =
      new com.google.protobuf.AbstractParser<ListBucketsResponse>() {
        @java.lang.Override
        public ListBucketsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListBucketsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListBucketsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.v2.ListBucketsResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
