/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

// Protobuf Java Version: 3.25.8
package com.google.storage.v2;

/**
 *
 *
 * <pre>
 * A bucket.
 * </pre>
 *
 * Protobuf type {@code google.storage.v2.Bucket}
 */
public final class Bucket extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket)
    BucketOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Bucket.newBuilder() to construct.
  private Bucket(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Bucket() {
    name_ = "";
    bucketId_ = "";
    etag_ = "";
    project_ = "";
    location_ = "";
    locationType_ = "";
    storageClass_ = "";
    rpo_ = "";
    acl_ = java.util.Collections.emptyList();
    defaultObjectAcl_ = java.util.Collections.emptyList();
    cors_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Bucket();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.v2.StorageProto.internal_static_google_storage_v2_Bucket_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 15:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_Bucket_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.v2.Bucket.class, com.google.storage.v2.Bucket.Builder.class);
  }

  public interface BillingOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Billing)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. When set to true, Requester Pays is enabled for this bucket.
     * </pre>
     *
     * <code>bool requester_pays = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requesterPays.
     */
    boolean getRequesterPays();
  }

  /**
   *
   *
   * <pre>
   * Billing properties of a bucket.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.Billing}
   */
  public static final class Billing extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Billing)
      BillingOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Billing.newBuilder() to construct.
    private Billing(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Billing() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Billing();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Billing_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Billing_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.Billing.class,
              com.google.storage.v2.Bucket.Billing.Builder.class);
    }

    public static final int REQUESTER_PAYS_FIELD_NUMBER = 1;
    private boolean requesterPays_ = false;

    /**
     *
     *
     * <pre>
     * Optional. When set to true, Requester Pays is enabled for this bucket.
     * </pre>
     *
     * <code>bool requester_pays = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requesterPays.
     */
    @java.lang.Override
    public boolean getRequesterPays() {
      return requesterPays_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (requesterPays_ != false) {
        output.writeBool(1, requesterPays_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (requesterPays_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, requesterPays_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.Billing)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.Billing other = (com.google.storage.v2.Bucket.Billing) obj;

      if (getRequesterPays() != other.getRequesterPays()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + REQUESTER_PAYS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRequesterPays());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Billing parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Billing parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Billing parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.Billing prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Billing properties of a bucket.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.Billing}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Billing)
        com.google.storage.v2.Bucket.BillingOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Billing_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Billing_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.Billing.class,
                com.google.storage.v2.Bucket.Billing.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.Billing.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        requesterPays_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Billing_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Billing getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.Billing.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Billing build() {
        com.google.storage.v2.Bucket.Billing result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Billing buildPartial() {
        com.google.storage.v2.Bucket.Billing result =
            new com.google.storage.v2.Bucket.Billing(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.storage.v2.Bucket.Billing result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.requesterPays_ = requesterPays_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.Billing) {
          return mergeFrom((com.google.storage.v2.Bucket.Billing) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.Billing other) {
        if (other == com.google.storage.v2.Bucket.Billing.getDefaultInstance()) return this;
        if (other.getRequesterPays() != false) {
          setRequesterPays(other.getRequesterPays());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  requesterPays_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean requesterPays_;

      /**
       *
       *
       * <pre>
       * Optional. When set to true, Requester Pays is enabled for this bucket.
       * </pre>
       *
       * <code>bool requester_pays = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The requesterPays.
       */
      @java.lang.Override
      public boolean getRequesterPays() {
        return requesterPays_;
      }

      /**
       *
       *
       * <pre>
       * Optional. When set to true, Requester Pays is enabled for this bucket.
       * </pre>
       *
       * <code>bool requester_pays = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The requesterPays to set.
       * @return This builder for chaining.
       */
      public Builder setRequesterPays(boolean value) {

        requesterPays_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. When set to true, Requester Pays is enabled for this bucket.
       * </pre>
       *
       * <code>bool requester_pays = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRequesterPays() {
        bitField0_ = (bitField0_ & ~0x00000001);
        requesterPays_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Billing)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Billing)
    private static final com.google.storage.v2.Bucket.Billing DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Billing();
    }

    public static com.google.storage.v2.Bucket.Billing getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Billing> PARSER =
        new com.google.protobuf.AbstractParser<Billing>() {
          @java.lang.Override
          public Billing parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Billing> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Billing> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.Billing getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CorsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Cors)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. The list of Origins eligible to receive CORS response headers.
     * See [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
     * Note: "*" is permitted in the list of origins, and means "any Origin".
     * </pre>
     *
     * <code>repeated string origin = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the origin.
     */
    java.util.List<java.lang.String> getOriginList();

    /**
     *
     *
     * <pre>
     * Optional. The list of Origins eligible to receive CORS response headers.
     * See [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
     * Note: "*" is permitted in the list of origins, and means "any Origin".
     * </pre>
     *
     * <code>repeated string origin = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of origin.
     */
    int getOriginCount();

    /**
     *
     *
     * <pre>
     * Optional. The list of Origins eligible to receive CORS response headers.
     * See [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
     * Note: "*" is permitted in the list of origins, and means "any Origin".
     * </pre>
     *
     * <code>repeated string origin = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The origin at the given index.
     */
    java.lang.String getOrigin(int index);

    /**
     *
     *
     * <pre>
     * Optional. The list of Origins eligible to receive CORS response headers.
     * See [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
     * Note: "*" is permitted in the list of origins, and means "any Origin".
     * </pre>
     *
     * <code>repeated string origin = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the origin at the given index.
     */
    com.google.protobuf.ByteString getOriginBytes(int index);

    /**
     *
     *
     * <pre>
     * Optional. The list of HTTP methods on which to include CORS response
     * headers,
     * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
     * methods, and means "any method".
     * </pre>
     *
     * <code>repeated string method = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the method.
     */
    java.util.List<java.lang.String> getMethodList();

    /**
     *
     *
     * <pre>
     * Optional. The list of HTTP methods on which to include CORS response
     * headers,
     * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
     * methods, and means "any method".
     * </pre>
     *
     * <code>repeated string method = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of method.
     */
    int getMethodCount();

    /**
     *
     *
     * <pre>
     * Optional. The list of HTTP methods on which to include CORS response
     * headers,
     * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
     * methods, and means "any method".
     * </pre>
     *
     * <code>repeated string method = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The method at the given index.
     */
    java.lang.String getMethod(int index);

    /**
     *
     *
     * <pre>
     * Optional. The list of HTTP methods on which to include CORS response
     * headers,
     * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
     * methods, and means "any method".
     * </pre>
     *
     * <code>repeated string method = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the method at the given index.
     */
    com.google.protobuf.ByteString getMethodBytes(int index);

    /**
     *
     *
     * <pre>
     * Optional. The list of HTTP headers other than the
     * [https://www.w3.org/TR/cors/#simple-response-header][simple response
     * headers] to give permission for the user-agent to share across domains.
     * </pre>
     *
     * <code>repeated string response_header = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the responseHeader.
     */
    java.util.List<java.lang.String> getResponseHeaderList();

    /**
     *
     *
     * <pre>
     * Optional. The list of HTTP headers other than the
     * [https://www.w3.org/TR/cors/#simple-response-header][simple response
     * headers] to give permission for the user-agent to share across domains.
     * </pre>
     *
     * <code>repeated string response_header = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of responseHeader.
     */
    int getResponseHeaderCount();

    /**
     *
     *
     * <pre>
     * Optional. The list of HTTP headers other than the
     * [https://www.w3.org/TR/cors/#simple-response-header][simple response
     * headers] to give permission for the user-agent to share across domains.
     * </pre>
     *
     * <code>repeated string response_header = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The responseHeader at the given index.
     */
    java.lang.String getResponseHeader(int index);

    /**
     *
     *
     * <pre>
     * Optional. The list of HTTP headers other than the
     * [https://www.w3.org/TR/cors/#simple-response-header][simple response
     * headers] to give permission for the user-agent to share across domains.
     * </pre>
     *
     * <code>repeated string response_header = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the responseHeader at the given index.
     */
    com.google.protobuf.ByteString getResponseHeaderBytes(int index);

    /**
     *
     *
     * <pre>
     * Optional. The value, in seconds, to return in the
     * [https://www.w3.org/TR/cors/#access-control-max-age-response-header][Access-Control-Max-Age
     * header] used in preflight responses.
     * </pre>
     *
     * <code>int32 max_age_seconds = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The maxAgeSeconds.
     */
    int getMaxAgeSeconds();
  }

  /**
   *
   *
   * <pre>
   * Cross-Origin Response sharing (CORS) properties for a bucket.
   * For more on Cloud Storage and CORS, see
   * https://cloud.google.com/storage/docs/cross-origin.
   * For more on CORS in general, see https://tools.ietf.org/html/rfc6454.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.Cors}
   */
  public static final class Cors extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Cors)
      CorsOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Cors.newBuilder() to construct.
    private Cors(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Cors() {
      origin_ = com.google.protobuf.LazyStringArrayList.emptyList();
      method_ = com.google.protobuf.LazyStringArrayList.emptyList();
      responseHeader_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Cors();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Cors_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Cors_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.Cors.class,
              com.google.storage.v2.Bucket.Cors.Builder.class);
    }

    public static final int ORIGIN_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList origin_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * Optional. The list of Origins eligible to receive CORS response headers.
     * See [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
     * Note: "*" is permitted in the list of origins, and means "any Origin".
     * </pre>
     *
     * <code>repeated string origin = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the origin.
     */
    public com.google.protobuf.ProtocolStringList getOriginList() {
      return origin_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of Origins eligible to receive CORS response headers.
     * See [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
     * Note: "*" is permitted in the list of origins, and means "any Origin".
     * </pre>
     *
     * <code>repeated string origin = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of origin.
     */
    public int getOriginCount() {
      return origin_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of Origins eligible to receive CORS response headers.
     * See [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
     * Note: "*" is permitted in the list of origins, and means "any Origin".
     * </pre>
     *
     * <code>repeated string origin = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The origin at the given index.
     */
    public java.lang.String getOrigin(int index) {
      return origin_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of Origins eligible to receive CORS response headers.
     * See [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
     * Note: "*" is permitted in the list of origins, and means "any Origin".
     * </pre>
     *
     * <code>repeated string origin = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the origin at the given index.
     */
    public com.google.protobuf.ByteString getOriginBytes(int index) {
      return origin_.getByteString(index);
    }

    public static final int METHOD_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList method_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * Optional. The list of HTTP methods on which to include CORS response
     * headers,
     * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
     * methods, and means "any method".
     * </pre>
     *
     * <code>repeated string method = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the method.
     */
    public com.google.protobuf.ProtocolStringList getMethodList() {
      return method_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of HTTP methods on which to include CORS response
     * headers,
     * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
     * methods, and means "any method".
     * </pre>
     *
     * <code>repeated string method = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of method.
     */
    public int getMethodCount() {
      return method_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of HTTP methods on which to include CORS response
     * headers,
     * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
     * methods, and means "any method".
     * </pre>
     *
     * <code>repeated string method = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The method at the given index.
     */
    public java.lang.String getMethod(int index) {
      return method_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of HTTP methods on which to include CORS response
     * headers,
     * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
     * methods, and means "any method".
     * </pre>
     *
     * <code>repeated string method = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the method at the given index.
     */
    public com.google.protobuf.ByteString getMethodBytes(int index) {
      return method_.getByteString(index);
    }

    public static final int RESPONSE_HEADER_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList responseHeader_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * Optional. The list of HTTP headers other than the
     * [https://www.w3.org/TR/cors/#simple-response-header][simple response
     * headers] to give permission for the user-agent to share across domains.
     * </pre>
     *
     * <code>repeated string response_header = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the responseHeader.
     */
    public com.google.protobuf.ProtocolStringList getResponseHeaderList() {
      return responseHeader_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of HTTP headers other than the
     * [https://www.w3.org/TR/cors/#simple-response-header][simple response
     * headers] to give permission for the user-agent to share across domains.
     * </pre>
     *
     * <code>repeated string response_header = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of responseHeader.
     */
    public int getResponseHeaderCount() {
      return responseHeader_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of HTTP headers other than the
     * [https://www.w3.org/TR/cors/#simple-response-header][simple response
     * headers] to give permission for the user-agent to share across domains.
     * </pre>
     *
     * <code>repeated string response_header = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The responseHeader at the given index.
     */
    public java.lang.String getResponseHeader(int index) {
      return responseHeader_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of HTTP headers other than the
     * [https://www.w3.org/TR/cors/#simple-response-header][simple response
     * headers] to give permission for the user-agent to share across domains.
     * </pre>
     *
     * <code>repeated string response_header = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the responseHeader at the given index.
     */
    public com.google.protobuf.ByteString getResponseHeaderBytes(int index) {
      return responseHeader_.getByteString(index);
    }

    public static final int MAX_AGE_SECONDS_FIELD_NUMBER = 4;
    private int maxAgeSeconds_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. The value, in seconds, to return in the
     * [https://www.w3.org/TR/cors/#access-control-max-age-response-header][Access-Control-Max-Age
     * header] used in preflight responses.
     * </pre>
     *
     * <code>int32 max_age_seconds = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The maxAgeSeconds.
     */
    @java.lang.Override
    public int getMaxAgeSeconds() {
      return maxAgeSeconds_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < origin_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, origin_.getRaw(i));
      }
      for (int i = 0; i < method_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, method_.getRaw(i));
      }
      for (int i = 0; i < responseHeader_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, responseHeader_.getRaw(i));
      }
      if (maxAgeSeconds_ != 0) {
        output.writeInt32(4, maxAgeSeconds_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < origin_.size(); i++) {
          dataSize += computeStringSizeNoTag(origin_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getOriginList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < method_.size(); i++) {
          dataSize += computeStringSizeNoTag(method_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getMethodList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < responseHeader_.size(); i++) {
          dataSize += computeStringSizeNoTag(responseHeader_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getResponseHeaderList().size();
      }
      if (maxAgeSeconds_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, maxAgeSeconds_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.Cors)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.Cors other = (com.google.storage.v2.Bucket.Cors) obj;

      if (!getOriginList().equals(other.getOriginList())) return false;
      if (!getMethodList().equals(other.getMethodList())) return false;
      if (!getResponseHeaderList().equals(other.getResponseHeaderList())) return false;
      if (getMaxAgeSeconds() != other.getMaxAgeSeconds()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getOriginCount() > 0) {
        hash = (37 * hash) + ORIGIN_FIELD_NUMBER;
        hash = (53 * hash) + getOriginList().hashCode();
      }
      if (getMethodCount() > 0) {
        hash = (37 * hash) + METHOD_FIELD_NUMBER;
        hash = (53 * hash) + getMethodList().hashCode();
      }
      if (getResponseHeaderCount() > 0) {
        hash = (37 * hash) + RESPONSE_HEADER_FIELD_NUMBER;
        hash = (53 * hash) + getResponseHeaderList().hashCode();
      }
      hash = (37 * hash) + MAX_AGE_SECONDS_FIELD_NUMBER;
      hash = (53 * hash) + getMaxAgeSeconds();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Cors parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Cors parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Cors parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.Cors prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Cross-Origin Response sharing (CORS) properties for a bucket.
     * For more on Cloud Storage and CORS, see
     * https://cloud.google.com/storage/docs/cross-origin.
     * For more on CORS in general, see https://tools.ietf.org/html/rfc6454.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.Cors}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Cors)
        com.google.storage.v2.Bucket.CorsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Cors_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Cors_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.Cors.class,
                com.google.storage.v2.Bucket.Cors.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.Cors.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        origin_ = com.google.protobuf.LazyStringArrayList.emptyList();
        method_ = com.google.protobuf.LazyStringArrayList.emptyList();
        responseHeader_ = com.google.protobuf.LazyStringArrayList.emptyList();
        maxAgeSeconds_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Cors_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Cors getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.Cors.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Cors build() {
        com.google.storage.v2.Bucket.Cors result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Cors buildPartial() {
        com.google.storage.v2.Bucket.Cors result = new com.google.storage.v2.Bucket.Cors(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.storage.v2.Bucket.Cors result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          origin_.makeImmutable();
          result.origin_ = origin_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          method_.makeImmutable();
          result.method_ = method_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          responseHeader_.makeImmutable();
          result.responseHeader_ = responseHeader_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.maxAgeSeconds_ = maxAgeSeconds_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.Cors) {
          return mergeFrom((com.google.storage.v2.Bucket.Cors) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.Cors other) {
        if (other == com.google.storage.v2.Bucket.Cors.getDefaultInstance()) return this;
        if (!other.origin_.isEmpty()) {
          if (origin_.isEmpty()) {
            origin_ = other.origin_;
            bitField0_ |= 0x00000001;
          } else {
            ensureOriginIsMutable();
            origin_.addAll(other.origin_);
          }
          onChanged();
        }
        if (!other.method_.isEmpty()) {
          if (method_.isEmpty()) {
            method_ = other.method_;
            bitField0_ |= 0x00000002;
          } else {
            ensureMethodIsMutable();
            method_.addAll(other.method_);
          }
          onChanged();
        }
        if (!other.responseHeader_.isEmpty()) {
          if (responseHeader_.isEmpty()) {
            responseHeader_ = other.responseHeader_;
            bitField0_ |= 0x00000004;
          } else {
            ensureResponseHeaderIsMutable();
            responseHeader_.addAll(other.responseHeader_);
          }
          onChanged();
        }
        if (other.getMaxAgeSeconds() != 0) {
          setMaxAgeSeconds(other.getMaxAgeSeconds());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureOriginIsMutable();
                  origin_.add(s);
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureMethodIsMutable();
                  method_.add(s);
                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureResponseHeaderIsMutable();
                  responseHeader_.add(s);
                  break;
                } // case 26
              case 32:
                {
                  maxAgeSeconds_ = input.readInt32();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList origin_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureOriginIsMutable() {
        if (!origin_.isModifiable()) {
          origin_ = new com.google.protobuf.LazyStringArrayList(origin_);
        }
        bitField0_ |= 0x00000001;
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of Origins eligible to receive CORS response headers.
       * See [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
       * Note: "*" is permitted in the list of origins, and means "any Origin".
       * </pre>
       *
       * <code>repeated string origin = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the origin.
       */
      public com.google.protobuf.ProtocolStringList getOriginList() {
        origin_.makeImmutable();
        return origin_;
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of Origins eligible to receive CORS response headers.
       * See [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
       * Note: "*" is permitted in the list of origins, and means "any Origin".
       * </pre>
       *
       * <code>repeated string origin = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of origin.
       */
      public int getOriginCount() {
        return origin_.size();
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of Origins eligible to receive CORS response headers.
       * See [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
       * Note: "*" is permitted in the list of origins, and means "any Origin".
       * </pre>
       *
       * <code>repeated string origin = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The origin at the given index.
       */
      public java.lang.String getOrigin(int index) {
        return origin_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of Origins eligible to receive CORS response headers.
       * See [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
       * Note: "*" is permitted in the list of origins, and means "any Origin".
       * </pre>
       *
       * <code>repeated string origin = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the origin at the given index.
       */
      public com.google.protobuf.ByteString getOriginBytes(int index) {
        return origin_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of Origins eligible to receive CORS response headers.
       * See [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
       * Note: "*" is permitted in the list of origins, and means "any Origin".
       * </pre>
       *
       * <code>repeated string origin = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index to set the value at.
       * @param value The origin to set.
       * @return This builder for chaining.
       */
      public Builder setOrigin(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOriginIsMutable();
        origin_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of Origins eligible to receive CORS response headers.
       * See [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
       * Note: "*" is permitted in the list of origins, and means "any Origin".
       * </pre>
       *
       * <code>repeated string origin = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The origin to add.
       * @return This builder for chaining.
       */
      public Builder addOrigin(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOriginIsMutable();
        origin_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of Origins eligible to receive CORS response headers.
       * See [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
       * Note: "*" is permitted in the list of origins, and means "any Origin".
       * </pre>
       *
       * <code>repeated string origin = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param values The origin to add.
       * @return This builder for chaining.
       */
      public Builder addAllOrigin(java.lang.Iterable<java.lang.String> values) {
        ensureOriginIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, origin_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of Origins eligible to receive CORS response headers.
       * See [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
       * Note: "*" is permitted in the list of origins, and means "any Origin".
       * </pre>
       *
       * <code>repeated string origin = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOrigin() {
        origin_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of Origins eligible to receive CORS response headers.
       * See [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
       * Note: "*" is permitted in the list of origins, and means "any Origin".
       * </pre>
       *
       * <code>repeated string origin = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes of the origin to add.
       * @return This builder for chaining.
       */
      public Builder addOriginBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureOriginIsMutable();
        origin_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList method_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureMethodIsMutable() {
        if (!method_.isModifiable()) {
          method_ = new com.google.protobuf.LazyStringArrayList(method_);
        }
        bitField0_ |= 0x00000002;
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of HTTP methods on which to include CORS response
       * headers,
       * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
       * methods, and means "any method".
       * </pre>
       *
       * <code>repeated string method = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the method.
       */
      public com.google.protobuf.ProtocolStringList getMethodList() {
        method_.makeImmutable();
        return method_;
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of HTTP methods on which to include CORS response
       * headers,
       * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
       * methods, and means "any method".
       * </pre>
       *
       * <code>repeated string method = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of method.
       */
      public int getMethodCount() {
        return method_.size();
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of HTTP methods on which to include CORS response
       * headers,
       * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
       * methods, and means "any method".
       * </pre>
       *
       * <code>repeated string method = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The method at the given index.
       */
      public java.lang.String getMethod(int index) {
        return method_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of HTTP methods on which to include CORS response
       * headers,
       * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
       * methods, and means "any method".
       * </pre>
       *
       * <code>repeated string method = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the method at the given index.
       */
      public com.google.protobuf.ByteString getMethodBytes(int index) {
        return method_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of HTTP methods on which to include CORS response
       * headers,
       * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
       * methods, and means "any method".
       * </pre>
       *
       * <code>repeated string method = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index to set the value at.
       * @param value The method to set.
       * @return This builder for chaining.
       */
      public Builder setMethod(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMethodIsMutable();
        method_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of HTTP methods on which to include CORS response
       * headers,
       * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
       * methods, and means "any method".
       * </pre>
       *
       * <code>repeated string method = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The method to add.
       * @return This builder for chaining.
       */
      public Builder addMethod(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMethodIsMutable();
        method_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of HTTP methods on which to include CORS response
       * headers,
       * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
       * methods, and means "any method".
       * </pre>
       *
       * <code>repeated string method = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param values The method to add.
       * @return This builder for chaining.
       */
      public Builder addAllMethod(java.lang.Iterable<java.lang.String> values) {
        ensureMethodIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, method_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of HTTP methods on which to include CORS response
       * headers,
       * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
       * methods, and means "any method".
       * </pre>
       *
       * <code>repeated string method = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMethod() {
        method_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of HTTP methods on which to include CORS response
       * headers,
       * (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
       * methods, and means "any method".
       * </pre>
       *
       * <code>repeated string method = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes of the method to add.
       * @return This builder for chaining.
       */
      public Builder addMethodBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureMethodIsMutable();
        method_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList responseHeader_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureResponseHeaderIsMutable() {
        if (!responseHeader_.isModifiable()) {
          responseHeader_ = new com.google.protobuf.LazyStringArrayList(responseHeader_);
        }
        bitField0_ |= 0x00000004;
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of HTTP headers other than the
       * [https://www.w3.org/TR/cors/#simple-response-header][simple response
       * headers] to give permission for the user-agent to share across domains.
       * </pre>
       *
       * <code>repeated string response_header = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the responseHeader.
       */
      public com.google.protobuf.ProtocolStringList getResponseHeaderList() {
        responseHeader_.makeImmutable();
        return responseHeader_;
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of HTTP headers other than the
       * [https://www.w3.org/TR/cors/#simple-response-header][simple response
       * headers] to give permission for the user-agent to share across domains.
       * </pre>
       *
       * <code>repeated string response_header = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of responseHeader.
       */
      public int getResponseHeaderCount() {
        return responseHeader_.size();
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of HTTP headers other than the
       * [https://www.w3.org/TR/cors/#simple-response-header][simple response
       * headers] to give permission for the user-agent to share across domains.
       * </pre>
       *
       * <code>repeated string response_header = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The responseHeader at the given index.
       */
      public java.lang.String getResponseHeader(int index) {
        return responseHeader_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of HTTP headers other than the
       * [https://www.w3.org/TR/cors/#simple-response-header][simple response
       * headers] to give permission for the user-agent to share across domains.
       * </pre>
       *
       * <code>repeated string response_header = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the responseHeader at the given index.
       */
      public com.google.protobuf.ByteString getResponseHeaderBytes(int index) {
        return responseHeader_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of HTTP headers other than the
       * [https://www.w3.org/TR/cors/#simple-response-header][simple response
       * headers] to give permission for the user-agent to share across domains.
       * </pre>
       *
       * <code>repeated string response_header = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index to set the value at.
       * @param value The responseHeader to set.
       * @return This builder for chaining.
       */
      public Builder setResponseHeader(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResponseHeaderIsMutable();
        responseHeader_.set(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of HTTP headers other than the
       * [https://www.w3.org/TR/cors/#simple-response-header][simple response
       * headers] to give permission for the user-agent to share across domains.
       * </pre>
       *
       * <code>repeated string response_header = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The responseHeader to add.
       * @return This builder for chaining.
       */
      public Builder addResponseHeader(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResponseHeaderIsMutable();
        responseHeader_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of HTTP headers other than the
       * [https://www.w3.org/TR/cors/#simple-response-header][simple response
       * headers] to give permission for the user-agent to share across domains.
       * </pre>
       *
       * <code>repeated string response_header = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param values The responseHeader to add.
       * @return This builder for chaining.
       */
      public Builder addAllResponseHeader(java.lang.Iterable<java.lang.String> values) {
        ensureResponseHeaderIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, responseHeader_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of HTTP headers other than the
       * [https://www.w3.org/TR/cors/#simple-response-header][simple response
       * headers] to give permission for the user-agent to share across domains.
       * </pre>
       *
       * <code>repeated string response_header = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearResponseHeader() {
        responseHeader_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of HTTP headers other than the
       * [https://www.w3.org/TR/cors/#simple-response-header][simple response
       * headers] to give permission for the user-agent to share across domains.
       * </pre>
       *
       * <code>repeated string response_header = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes of the responseHeader to add.
       * @return This builder for chaining.
       */
      public Builder addResponseHeaderBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureResponseHeaderIsMutable();
        responseHeader_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private int maxAgeSeconds_;

      /**
       *
       *
       * <pre>
       * Optional. The value, in seconds, to return in the
       * [https://www.w3.org/TR/cors/#access-control-max-age-response-header][Access-Control-Max-Age
       * header] used in preflight responses.
       * </pre>
       *
       * <code>int32 max_age_seconds = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The maxAgeSeconds.
       */
      @java.lang.Override
      public int getMaxAgeSeconds() {
        return maxAgeSeconds_;
      }

      /**
       *
       *
       * <pre>
       * Optional. The value, in seconds, to return in the
       * [https://www.w3.org/TR/cors/#access-control-max-age-response-header][Access-Control-Max-Age
       * header] used in preflight responses.
       * </pre>
       *
       * <code>int32 max_age_seconds = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The maxAgeSeconds to set.
       * @return This builder for chaining.
       */
      public Builder setMaxAgeSeconds(int value) {

        maxAgeSeconds_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The value, in seconds, to return in the
       * [https://www.w3.org/TR/cors/#access-control-max-age-response-header][Access-Control-Max-Age
       * header] used in preflight responses.
       * </pre>
       *
       * <code>int32 max_age_seconds = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxAgeSeconds() {
        bitField0_ = (bitField0_ & ~0x00000008);
        maxAgeSeconds_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Cors)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Cors)
    private static final com.google.storage.v2.Bucket.Cors DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Cors();
    }

    public static com.google.storage.v2.Bucket.Cors getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Cors> PARSER =
        new com.google.protobuf.AbstractParser<Cors>() {
          @java.lang.Override
          public Cors parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Cors> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Cors> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.Cors getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface EncryptionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Encryption)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. The name of the Cloud KMS key that will be used to encrypt
     * objects inserted into this bucket, if no encryption method is specified.
     * </pre>
     *
     * <code>
     * string default_kms_key = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The defaultKmsKey.
     */
    java.lang.String getDefaultKmsKey();

    /**
     *
     *
     * <pre>
     * Optional. The name of the Cloud KMS key that will be used to encrypt
     * objects inserted into this bucket, if no encryption method is specified.
     * </pre>
     *
     * <code>
     * string default_kms_key = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for defaultKmsKey.
     */
    com.google.protobuf.ByteString getDefaultKmsKeyBytes();

    /**
     *
     *
     * <pre>
     * Optional. If omitted, then new objects with GMEK encryption-type is
     * allowed. If set, then new objects created in this bucket must comply with
     * enforcement config. Changing this has no effect on existing objects; it
     * applies to new objects only.
     * </pre>
     *
     * <code>
     * optional .google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig google_managed_encryption_enforcement_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the googleManagedEncryptionEnforcementConfig field is set.
     */
    boolean hasGoogleManagedEncryptionEnforcementConfig();

    /**
     *
     *
     * <pre>
     * Optional. If omitted, then new objects with GMEK encryption-type is
     * allowed. If set, then new objects created in this bucket must comply with
     * enforcement config. Changing this has no effect on existing objects; it
     * applies to new objects only.
     * </pre>
     *
     * <code>
     * optional .google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig google_managed_encryption_enforcement_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The googleManagedEncryptionEnforcementConfig.
     */
    com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
        getGoogleManagedEncryptionEnforcementConfig();

    /**
     *
     *
     * <pre>
     * Optional. If omitted, then new objects with GMEK encryption-type is
     * allowed. If set, then new objects created in this bucket must comply with
     * enforcement config. Changing this has no effect on existing objects; it
     * applies to new objects only.
     * </pre>
     *
     * <code>
     * optional .google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig google_managed_encryption_enforcement_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfigOrBuilder
        getGoogleManagedEncryptionEnforcementConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. If omitted, then new objects with CMEK encryption-type is
     * allowed. If set, then new objects created in this bucket must comply with
     * enforcement config. Changing this has no effect on existing objects; it
     * applies to new objects only.
     * </pre>
     *
     * <code>
     * optional .google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig customer_managed_encryption_enforcement_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the customerManagedEncryptionEnforcementConfig field is set.
     */
    boolean hasCustomerManagedEncryptionEnforcementConfig();

    /**
     *
     *
     * <pre>
     * Optional. If omitted, then new objects with CMEK encryption-type is
     * allowed. If set, then new objects created in this bucket must comply with
     * enforcement config. Changing this has no effect on existing objects; it
     * applies to new objects only.
     * </pre>
     *
     * <code>
     * optional .google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig customer_managed_encryption_enforcement_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The customerManagedEncryptionEnforcementConfig.
     */
    com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
        getCustomerManagedEncryptionEnforcementConfig();

    /**
     *
     *
     * <pre>
     * Optional. If omitted, then new objects with CMEK encryption-type is
     * allowed. If set, then new objects created in this bucket must comply with
     * enforcement config. Changing this has no effect on existing objects; it
     * applies to new objects only.
     * </pre>
     *
     * <code>
     * optional .google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig customer_managed_encryption_enforcement_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfigOrBuilder
        getCustomerManagedEncryptionEnforcementConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. If omitted, then new objects with CSEK encryption-type is
     * allowed. If set, then new objects created in this bucket must comply with
     * enforcement config. Changing this has no effect on existing objects; it
     * applies to new objects only.
     * </pre>
     *
     * <code>
     * optional .google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig customer_supplied_encryption_enforcement_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the customerSuppliedEncryptionEnforcementConfig field is set.
     */
    boolean hasCustomerSuppliedEncryptionEnforcementConfig();

    /**
     *
     *
     * <pre>
     * Optional. If omitted, then new objects with CSEK encryption-type is
     * allowed. If set, then new objects created in this bucket must comply with
     * enforcement config. Changing this has no effect on existing objects; it
     * applies to new objects only.
     * </pre>
     *
     * <code>
     * optional .google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig customer_supplied_encryption_enforcement_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The customerSuppliedEncryptionEnforcementConfig.
     */
    com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig
        getCustomerSuppliedEncryptionEnforcementConfig();

    /**
     *
     *
     * <pre>
     * Optional. If omitted, then new objects with CSEK encryption-type is
     * allowed. If set, then new objects created in this bucket must comply with
     * enforcement config. Changing this has no effect on existing objects; it
     * applies to new objects only.
     * </pre>
     *
     * <code>
     * optional .google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig customer_supplied_encryption_enforcement_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfigOrBuilder
        getCustomerSuppliedEncryptionEnforcementConfigOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * Encryption properties of a bucket.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.Encryption}
   */
  public static final class Encryption extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Encryption)
      EncryptionOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Encryption.newBuilder() to construct.
    private Encryption(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Encryption() {
      defaultKmsKey_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Encryption();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Encryption_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Encryption_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.Encryption.class,
              com.google.storage.v2.Bucket.Encryption.Builder.class);
    }

    public interface GoogleManagedEncryptionEnforcementConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Restriction mode for google-managed encryption for new objects within
       * the bucket. Valid values are: "NotRestricted", "FullyRestricted".
       * If `NotRestricted` or unset, creation of new objects with
       * google-managed encryption is allowed.
       * If `FullyRestricted`, new objects can't be created using google-managed
       * encryption.
       * </pre>
       *
       * <code>optional string restriction_mode = 3;</code>
       *
       * @return Whether the restrictionMode field is set.
       */
      boolean hasRestrictionMode();

      /**
       *
       *
       * <pre>
       * Restriction mode for google-managed encryption for new objects within
       * the bucket. Valid values are: "NotRestricted", "FullyRestricted".
       * If `NotRestricted` or unset, creation of new objects with
       * google-managed encryption is allowed.
       * If `FullyRestricted`, new objects can't be created using google-managed
       * encryption.
       * </pre>
       *
       * <code>optional string restriction_mode = 3;</code>
       *
       * @return The restrictionMode.
       */
      java.lang.String getRestrictionMode();

      /**
       *
       *
       * <pre>
       * Restriction mode for google-managed encryption for new objects within
       * the bucket. Valid values are: "NotRestricted", "FullyRestricted".
       * If `NotRestricted` or unset, creation of new objects with
       * google-managed encryption is allowed.
       * If `FullyRestricted`, new objects can't be created using google-managed
       * encryption.
       * </pre>
       *
       * <code>optional string restriction_mode = 3;</code>
       *
       * @return The bytes for restrictionMode.
       */
      com.google.protobuf.ByteString getRestrictionModeBytes();

      /**
       *
       *
       * <pre>
       * Time from which the config was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       *
       * @return Whether the effectiveTime field is set.
       */
      boolean hasEffectiveTime();

      /**
       *
       *
       * <pre>
       * Time from which the config was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       *
       * @return The effectiveTime.
       */
      com.google.protobuf.Timestamp getEffectiveTime();

      /**
       *
       *
       * <pre>
       * Time from which the config was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       */
      com.google.protobuf.TimestampOrBuilder getEffectiveTimeOrBuilder();
    }

    /**
     *
     *
     * <pre>
     * Google Managed Encryption (GMEK) enforcement config of a bucket.
     * </pre>
     *
     * Protobuf type {@code
     * google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig}
     */
    public static final class GoogleManagedEncryptionEnforcementConfig
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig)
        GoogleManagedEncryptionEnforcementConfigOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use GoogleManagedEncryptionEnforcementConfig.newBuilder() to construct.
      private GoogleManagedEncryptionEnforcementConfig(
          com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private GoogleManagedEncryptionEnforcementConfig() {
        restrictionMode_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new GoogleManagedEncryptionEnforcementConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Encryption_GoogleManagedEncryptionEnforcementConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Encryption_GoogleManagedEncryptionEnforcementConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
                    .class,
                com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
                    .Builder.class);
      }

      private int bitField0_;
      public static final int RESTRICTION_MODE_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private volatile java.lang.Object restrictionMode_ = "";

      /**
       *
       *
       * <pre>
       * Restriction mode for google-managed encryption for new objects within
       * the bucket. Valid values are: "NotRestricted", "FullyRestricted".
       * If `NotRestricted` or unset, creation of new objects with
       * google-managed encryption is allowed.
       * If `FullyRestricted`, new objects can't be created using google-managed
       * encryption.
       * </pre>
       *
       * <code>optional string restriction_mode = 3;</code>
       *
       * @return Whether the restrictionMode field is set.
       */
      @java.lang.Override
      public boolean hasRestrictionMode() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Restriction mode for google-managed encryption for new objects within
       * the bucket. Valid values are: "NotRestricted", "FullyRestricted".
       * If `NotRestricted` or unset, creation of new objects with
       * google-managed encryption is allowed.
       * If `FullyRestricted`, new objects can't be created using google-managed
       * encryption.
       * </pre>
       *
       * <code>optional string restriction_mode = 3;</code>
       *
       * @return The restrictionMode.
       */
      @java.lang.Override
      public java.lang.String getRestrictionMode() {
        java.lang.Object ref = restrictionMode_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          restrictionMode_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Restriction mode for google-managed encryption for new objects within
       * the bucket. Valid values are: "NotRestricted", "FullyRestricted".
       * If `NotRestricted` or unset, creation of new objects with
       * google-managed encryption is allowed.
       * If `FullyRestricted`, new objects can't be created using google-managed
       * encryption.
       * </pre>
       *
       * <code>optional string restriction_mode = 3;</code>
       *
       * @return The bytes for restrictionMode.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getRestrictionModeBytes() {
        java.lang.Object ref = restrictionMode_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          restrictionMode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int EFFECTIVE_TIME_FIELD_NUMBER = 2;
      private com.google.protobuf.Timestamp effectiveTime_;

      /**
       *
       *
       * <pre>
       * Time from which the config was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       *
       * @return Whether the effectiveTime field is set.
       */
      @java.lang.Override
      public boolean hasEffectiveTime() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Time from which the config was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       *
       * @return The effectiveTime.
       */
      @java.lang.Override
      public com.google.protobuf.Timestamp getEffectiveTime() {
        return effectiveTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : effectiveTime_;
      }

      /**
       *
       *
       * <pre>
       * Time from which the config was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       */
      @java.lang.Override
      public com.google.protobuf.TimestampOrBuilder getEffectiveTimeOrBuilder() {
        return effectiveTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : effectiveTime_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(2, getEffectiveTime());
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, restrictionMode_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEffectiveTime());
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, restrictionMode_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig)) {
          return super.equals(obj);
        }
        com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig other =
            (com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig) obj;

        if (hasRestrictionMode() != other.hasRestrictionMode()) return false;
        if (hasRestrictionMode()) {
          if (!getRestrictionMode().equals(other.getRestrictionMode())) return false;
        }
        if (hasEffectiveTime() != other.hasEffectiveTime()) return false;
        if (hasEffectiveTime()) {
          if (!getEffectiveTime().equals(other.getEffectiveTime())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasRestrictionMode()) {
          hash = (37 * hash) + RESTRICTION_MODE_FIELD_NUMBER;
          hash = (53 * hash) + getRestrictionMode().hashCode();
        }
        if (hasEffectiveTime()) {
          hash = (37 * hash) + EFFECTIVE_TIME_FIELD_NUMBER;
          hash = (53 * hash) + getEffectiveTime().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Google Managed Encryption (GMEK) enforcement config of a bucket.
       * </pre>
       *
       * Protobuf type {@code
       * google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig)
          com.google.storage.v2.Bucket.Encryption
              .GoogleManagedEncryptionEnforcementConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Encryption_GoogleManagedEncryptionEnforcementConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Encryption_GoogleManagedEncryptionEnforcementConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
                      .class,
                  com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
                      .Builder.class);
        }

        // Construct using
        // com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getEffectiveTimeFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          restrictionMode_ = "";
          effectiveTime_ = null;
          if (effectiveTimeBuilder_ != null) {
            effectiveTimeBuilder_.dispose();
            effectiveTimeBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Encryption_GoogleManagedEncryptionEnforcementConfig_descriptor;
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
            getDefaultInstanceForType() {
          return com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
            build() {
          com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
            buildPartial() {
          com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig result =
              new com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
                result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.restrictionMode_ = restrictionMode_;
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.effectiveTime_ =
                effectiveTimeBuilder_ == null ? effectiveTime_ : effectiveTimeBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig) {
            return mergeFrom(
                (com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
                other) {
          if (other
              == com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
                  .getDefaultInstance()) return this;
          if (other.hasRestrictionMode()) {
            restrictionMode_ = other.restrictionMode_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasEffectiveTime()) {
            mergeEffectiveTime(other.getEffectiveTime());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 18:
                  {
                    input.readMessage(
                        getEffectiveTimeFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    restrictionMode_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object restrictionMode_ = "";

        /**
         *
         *
         * <pre>
         * Restriction mode for google-managed encryption for new objects within
         * the bucket. Valid values are: "NotRestricted", "FullyRestricted".
         * If `NotRestricted` or unset, creation of new objects with
         * google-managed encryption is allowed.
         * If `FullyRestricted`, new objects can't be created using google-managed
         * encryption.
         * </pre>
         *
         * <code>optional string restriction_mode = 3;</code>
         *
         * @return Whether the restrictionMode field is set.
         */
        public boolean hasRestrictionMode() {
          return ((bitField0_ & 0x00000001) != 0);
        }

        /**
         *
         *
         * <pre>
         * Restriction mode for google-managed encryption for new objects within
         * the bucket. Valid values are: "NotRestricted", "FullyRestricted".
         * If `NotRestricted` or unset, creation of new objects with
         * google-managed encryption is allowed.
         * If `FullyRestricted`, new objects can't be created using google-managed
         * encryption.
         * </pre>
         *
         * <code>optional string restriction_mode = 3;</code>
         *
         * @return The restrictionMode.
         */
        public java.lang.String getRestrictionMode() {
          java.lang.Object ref = restrictionMode_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            restrictionMode_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Restriction mode for google-managed encryption for new objects within
         * the bucket. Valid values are: "NotRestricted", "FullyRestricted".
         * If `NotRestricted` or unset, creation of new objects with
         * google-managed encryption is allowed.
         * If `FullyRestricted`, new objects can't be created using google-managed
         * encryption.
         * </pre>
         *
         * <code>optional string restriction_mode = 3;</code>
         *
         * @return The bytes for restrictionMode.
         */
        public com.google.protobuf.ByteString getRestrictionModeBytes() {
          java.lang.Object ref = restrictionMode_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            restrictionMode_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Restriction mode for google-managed encryption for new objects within
         * the bucket. Valid values are: "NotRestricted", "FullyRestricted".
         * If `NotRestricted` or unset, creation of new objects with
         * google-managed encryption is allowed.
         * If `FullyRestricted`, new objects can't be created using google-managed
         * encryption.
         * </pre>
         *
         * <code>optional string restriction_mode = 3;</code>
         *
         * @param value The restrictionMode to set.
         * @return This builder for chaining.
         */
        public Builder setRestrictionMode(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          restrictionMode_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Restriction mode for google-managed encryption for new objects within
         * the bucket. Valid values are: "NotRestricted", "FullyRestricted".
         * If `NotRestricted` or unset, creation of new objects with
         * google-managed encryption is allowed.
         * If `FullyRestricted`, new objects can't be created using google-managed
         * encryption.
         * </pre>
         *
         * <code>optional string restriction_mode = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearRestrictionMode() {
          restrictionMode_ = getDefaultInstance().getRestrictionMode();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Restriction mode for google-managed encryption for new objects within
         * the bucket. Valid values are: "NotRestricted", "FullyRestricted".
         * If `NotRestricted` or unset, creation of new objects with
         * google-managed encryption is allowed.
         * If `FullyRestricted`, new objects can't be created using google-managed
         * encryption.
         * </pre>
         *
         * <code>optional string restriction_mode = 3;</code>
         *
         * @param value The bytes for restrictionMode to set.
         * @return This builder for chaining.
         */
        public Builder setRestrictionModeBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          restrictionMode_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.protobuf.Timestamp effectiveTime_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>
            effectiveTimeBuilder_;

        /**
         *
         *
         * <pre>
         * Time from which the config was effective. This is service-provided.
         * </pre>
         *
         * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
         *
         * @return Whether the effectiveTime field is set.
         */
        public boolean hasEffectiveTime() {
          return ((bitField0_ & 0x00000002) != 0);
        }

        /**
         *
         *
         * <pre>
         * Time from which the config was effective. This is service-provided.
         * </pre>
         *
         * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
         *
         * @return The effectiveTime.
         */
        public com.google.protobuf.Timestamp getEffectiveTime() {
          if (effectiveTimeBuilder_ == null) {
            return effectiveTime_ == null
                ? com.google.protobuf.Timestamp.getDefaultInstance()
                : effectiveTime_;
          } else {
            return effectiveTimeBuilder_.getMessage();
          }
        }

        /**
         *
         *
         * <pre>
         * Time from which the config was effective. This is service-provided.
         * </pre>
         *
         * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
         */
        public Builder setEffectiveTime(com.google.protobuf.Timestamp value) {
          if (effectiveTimeBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            effectiveTime_ = value;
          } else {
            effectiveTimeBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Time from which the config was effective. This is service-provided.
         * </pre>
         *
         * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
         */
        public Builder setEffectiveTime(com.google.protobuf.Timestamp.Builder builderForValue) {
          if (effectiveTimeBuilder_ == null) {
            effectiveTime_ = builderForValue.build();
          } else {
            effectiveTimeBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Time from which the config was effective. This is service-provided.
         * </pre>
         *
         * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
         */
        public Builder mergeEffectiveTime(com.google.protobuf.Timestamp value) {
          if (effectiveTimeBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && effectiveTime_ != null
                && effectiveTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
              getEffectiveTimeBuilder().mergeFrom(value);
            } else {
              effectiveTime_ = value;
            }
          } else {
            effectiveTimeBuilder_.mergeFrom(value);
          }
          if (effectiveTime_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Time from which the config was effective. This is service-provided.
         * </pre>
         *
         * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
         */
        public Builder clearEffectiveTime() {
          bitField0_ = (bitField0_ & ~0x00000002);
          effectiveTime_ = null;
          if (effectiveTimeBuilder_ != null) {
            effectiveTimeBuilder_.dispose();
            effectiveTimeBuilder_ = null;
          }
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Time from which the config was effective. This is service-provided.
         * </pre>
         *
         * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
         */
        public com.google.protobuf.Timestamp.Builder getEffectiveTimeBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getEffectiveTimeFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Time from which the config was effective. This is service-provided.
         * </pre>
         *
         * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
         */
        public com.google.protobuf.TimestampOrBuilder getEffectiveTimeOrBuilder() {
          if (effectiveTimeBuilder_ != null) {
            return effectiveTimeBuilder_.getMessageOrBuilder();
          } else {
            return effectiveTime_ == null
                ? com.google.protobuf.Timestamp.getDefaultInstance()
                : effectiveTime_;
          }
        }

        /**
         *
         *
         * <pre>
         * Time from which the config was effective. This is service-provided.
         * </pre>
         *
         * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>
            getEffectiveTimeFieldBuilder() {
          if (effectiveTimeBuilder_ == null) {
            effectiveTimeBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Timestamp,
                    com.google.protobuf.Timestamp.Builder,
                    com.google.protobuf.TimestampOrBuilder>(
                    getEffectiveTime(), getParentForChildren(), isClean());
            effectiveTime_ = null;
          }
          return effectiveTimeBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig)
      }

      // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig)
      private static final com.google.storage.v2.Bucket.Encryption
              .GoogleManagedEncryptionEnforcementConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig();
      }

      public static com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<GoogleManagedEncryptionEnforcementConfig>
          PARSER =
              new com.google.protobuf.AbstractParser<GoogleManagedEncryptionEnforcementConfig>() {
                @java.lang.Override
                public GoogleManagedEncryptionEnforcementConfig parsePartialFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                  Builder builder = newBuilder();
                  try {
                    builder.mergeFrom(input, extensionRegistry);
                  } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage(builder.buildPartial());
                  } catch (com.google.protobuf.UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException()
                        .setUnfinishedMessage(builder.buildPartial());
                  } catch (java.io.IOException e) {
                    throw new com.google.protobuf.InvalidProtocolBufferException(e)
                        .setUnfinishedMessage(builder.buildPartial());
                  }
                  return builder.buildPartial();
                }
              };

      public static com.google.protobuf.Parser<GoogleManagedEncryptionEnforcementConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<GoogleManagedEncryptionEnforcementConfig>
          getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface CustomerManagedEncryptionEnforcementConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Restriction mode for customer-managed encryption for new objects within
       * the bucket. Valid values are: "NotRestricted", "FullyRestricted".
       * If `NotRestricted` or unset, creation of new objects with
       * customer-managed encryption is allowed.
       * If `FullyRestricted`, new objects can't be created using
       * customer-managed encryption.
       * </pre>
       *
       * <code>optional string restriction_mode = 3;</code>
       *
       * @return Whether the restrictionMode field is set.
       */
      boolean hasRestrictionMode();

      /**
       *
       *
       * <pre>
       * Restriction mode for customer-managed encryption for new objects within
       * the bucket. Valid values are: "NotRestricted", "FullyRestricted".
       * If `NotRestricted` or unset, creation of new objects with
       * customer-managed encryption is allowed.
       * If `FullyRestricted`, new objects can't be created using
       * customer-managed encryption.
       * </pre>
       *
       * <code>optional string restriction_mode = 3;</code>
       *
       * @return The restrictionMode.
       */
      java.lang.String getRestrictionMode();

      /**
       *
       *
       * <pre>
       * Restriction mode for customer-managed encryption for new objects within
       * the bucket. Valid values are: "NotRestricted", "FullyRestricted".
       * If `NotRestricted` or unset, creation of new objects with
       * customer-managed encryption is allowed.
       * If `FullyRestricted`, new objects can't be created using
       * customer-managed encryption.
       * </pre>
       *
       * <code>optional string restriction_mode = 3;</code>
       *
       * @return The bytes for restrictionMode.
       */
      com.google.protobuf.ByteString getRestrictionModeBytes();

      /**
       *
       *
       * <pre>
       * Time from which the config was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       *
       * @return Whether the effectiveTime field is set.
       */
      boolean hasEffectiveTime();

      /**
       *
       *
       * <pre>
       * Time from which the config was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       *
       * @return The effectiveTime.
       */
      com.google.protobuf.Timestamp getEffectiveTime();

      /**
       *
       *
       * <pre>
       * Time from which the config was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       */
      com.google.protobuf.TimestampOrBuilder getEffectiveTimeOrBuilder();
    }

    /**
     *
     *
     * <pre>
     * Customer Managed Encryption (CMEK) enforcement config of a bucket.
     * </pre>
     *
     * Protobuf type {@code
     * google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig}
     */
    public static final class CustomerManagedEncryptionEnforcementConfig
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig)
        CustomerManagedEncryptionEnforcementConfigOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use CustomerManagedEncryptionEnforcementConfig.newBuilder() to construct.
      private CustomerManagedEncryptionEnforcementConfig(
          com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private CustomerManagedEncryptionEnforcementConfig() {
        restrictionMode_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new CustomerManagedEncryptionEnforcementConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Encryption_CustomerManagedEncryptionEnforcementConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Encryption_CustomerManagedEncryptionEnforcementConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
                    .class,
                com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
                    .Builder.class);
      }

      private int bitField0_;
      public static final int RESTRICTION_MODE_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private volatile java.lang.Object restrictionMode_ = "";

      /**
       *
       *
       * <pre>
       * Restriction mode for customer-managed encryption for new objects within
       * the bucket. Valid values are: "NotRestricted", "FullyRestricted".
       * If `NotRestricted` or unset, creation of new objects with
       * customer-managed encryption is allowed.
       * If `FullyRestricted`, new objects can't be created using
       * customer-managed encryption.
       * </pre>
       *
       * <code>optional string restriction_mode = 3;</code>
       *
       * @return Whether the restrictionMode field is set.
       */
      @java.lang.Override
      public boolean hasRestrictionMode() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Restriction mode for customer-managed encryption for new objects within
       * the bucket. Valid values are: "NotRestricted", "FullyRestricted".
       * If `NotRestricted` or unset, creation of new objects with
       * customer-managed encryption is allowed.
       * If `FullyRestricted`, new objects can't be created using
       * customer-managed encryption.
       * </pre>
       *
       * <code>optional string restriction_mode = 3;</code>
       *
       * @return The restrictionMode.
       */
      @java.lang.Override
      public java.lang.String getRestrictionMode() {
        java.lang.Object ref = restrictionMode_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          restrictionMode_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Restriction mode for customer-managed encryption for new objects within
       * the bucket. Valid values are: "NotRestricted", "FullyRestricted".
       * If `NotRestricted` or unset, creation of new objects with
       * customer-managed encryption is allowed.
       * If `FullyRestricted`, new objects can't be created using
       * customer-managed encryption.
       * </pre>
       *
       * <code>optional string restriction_mode = 3;</code>
       *
       * @return The bytes for restrictionMode.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getRestrictionModeBytes() {
        java.lang.Object ref = restrictionMode_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          restrictionMode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int EFFECTIVE_TIME_FIELD_NUMBER = 2;
      private com.google.protobuf.Timestamp effectiveTime_;

      /**
       *
       *
       * <pre>
       * Time from which the config was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       *
       * @return Whether the effectiveTime field is set.
       */
      @java.lang.Override
      public boolean hasEffectiveTime() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Time from which the config was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       *
       * @return The effectiveTime.
       */
      @java.lang.Override
      public com.google.protobuf.Timestamp getEffectiveTime() {
        return effectiveTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : effectiveTime_;
      }

      /**
       *
       *
       * <pre>
       * Time from which the config was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       */
      @java.lang.Override
      public com.google.protobuf.TimestampOrBuilder getEffectiveTimeOrBuilder() {
        return effectiveTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : effectiveTime_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(2, getEffectiveTime());
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, restrictionMode_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEffectiveTime());
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, restrictionMode_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig)) {
          return super.equals(obj);
        }
        com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig other =
            (com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig)
                obj;

        if (hasRestrictionMode() != other.hasRestrictionMode()) return false;
        if (hasRestrictionMode()) {
          if (!getRestrictionMode().equals(other.getRestrictionMode())) return false;
        }
        if (hasEffectiveTime() != other.hasEffectiveTime()) return false;
        if (hasEffectiveTime()) {
          if (!getEffectiveTime().equals(other.getEffectiveTime())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasRestrictionMode()) {
          hash = (37 * hash) + RESTRICTION_MODE_FIELD_NUMBER;
          hash = (53 * hash) + getRestrictionMode().hashCode();
        }
        if (hasEffectiveTime()) {
          hash = (37 * hash) + EFFECTIVE_TIME_FIELD_NUMBER;
          hash = (53 * hash) + getEffectiveTime().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.storage.v2.Bucket.Encryption
              .CustomerManagedEncryptionEnforcementConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.Encryption
              .CustomerManagedEncryptionEnforcementConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Encryption
              .CustomerManagedEncryptionEnforcementConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.Encryption
              .CustomerManagedEncryptionEnforcementConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Encryption
              .CustomerManagedEncryptionEnforcementConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.Encryption
              .CustomerManagedEncryptionEnforcementConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Encryption
              .CustomerManagedEncryptionEnforcementConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.Encryption
              .CustomerManagedEncryptionEnforcementConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Encryption
              .CustomerManagedEncryptionEnforcementConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.Encryption
              .CustomerManagedEncryptionEnforcementConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Encryption
              .CustomerManagedEncryptionEnforcementConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.Encryption
              .CustomerManagedEncryptionEnforcementConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Customer Managed Encryption (CMEK) enforcement config of a bucket.
       * </pre>
       *
       * Protobuf type {@code
       * google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig)
          com.google.storage.v2.Bucket.Encryption
              .CustomerManagedEncryptionEnforcementConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Encryption_CustomerManagedEncryptionEnforcementConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Encryption_CustomerManagedEncryptionEnforcementConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
                      .class,
                  com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
                      .Builder.class);
        }

        // Construct using
        // com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getEffectiveTimeFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          restrictionMode_ = "";
          effectiveTime_ = null;
          if (effectiveTimeBuilder_ != null) {
            effectiveTimeBuilder_.dispose();
            effectiveTimeBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Encryption_CustomerManagedEncryptionEnforcementConfig_descriptor;
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
            getDefaultInstanceForType() {
          return com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
            build() {
          com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
            buildPartial() {
          com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
              result =
                  new com.google.storage.v2.Bucket.Encryption
                      .CustomerManagedEncryptionEnforcementConfig(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
                result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.restrictionMode_ = restrictionMode_;
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.effectiveTime_ =
                effectiveTimeBuilder_ == null ? effectiveTime_ : effectiveTimeBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig) {
            return mergeFrom(
                (com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
                other) {
          if (other
              == com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
                  .getDefaultInstance()) return this;
          if (other.hasRestrictionMode()) {
            restrictionMode_ = other.restrictionMode_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasEffectiveTime()) {
            mergeEffectiveTime(other.getEffectiveTime());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 18:
                  {
                    input.readMessage(
                        getEffectiveTimeFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    restrictionMode_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object restrictionMode_ = "";

        /**
         *
         *
         * <pre>
         * Restriction mode for customer-managed encryption for new objects within
         * the bucket. Valid values are: "NotRestricted", "FullyRestricted".
         * If `NotRestricted` or unset, creation of new objects with
         * customer-managed encryption is allowed.
         * If `FullyRestricted`, new objects can't be created using
         * customer-managed encryption.
         * </pre>
         *
         * <code>optional string restriction_mode = 3;</code>
         *
         * @return Whether the restrictionMode field is set.
         */
        public boolean hasRestrictionMode() {
          return ((bitField0_ & 0x00000001) != 0);
        }

        /**
         *
         *
         * <pre>
         * Restriction mode for customer-managed encryption for new objects within
         * the bucket. Valid values are: "NotRestricted", "FullyRestricted".
         * If `NotRestricted` or unset, creation of new objects with
         * customer-managed encryption is allowed.
         * If `FullyRestricted`, new objects can't be created using
         * customer-managed encryption.
         * </pre>
         *
         * <code>optional string restriction_mode = 3;</code>
         *
         * @return The restrictionMode.
         */
        public java.lang.String getRestrictionMode() {
          java.lang.Object ref = restrictionMode_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            restrictionMode_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Restriction mode for customer-managed encryption for new objects within
         * the bucket. Valid values are: "NotRestricted", "FullyRestricted".
         * If `NotRestricted` or unset, creation of new objects with
         * customer-managed encryption is allowed.
         * If `FullyRestricted`, new objects can't be created using
         * customer-managed encryption.
         * </pre>
         *
         * <code>optional string restriction_mode = 3;</code>
         *
         * @return The bytes for restrictionMode.
         */
        public com.google.protobuf.ByteString getRestrictionModeBytes() {
          java.lang.Object ref = restrictionMode_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            restrictionMode_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Restriction mode for customer-managed encryption for new objects within
         * the bucket. Valid values are: "NotRestricted", "FullyRestricted".
         * If `NotRestricted` or unset, creation of new objects with
         * customer-managed encryption is allowed.
         * If `FullyRestricted`, new objects can't be created using
         * customer-managed encryption.
         * </pre>
         *
         * <code>optional string restriction_mode = 3;</code>
         *
         * @param value The restrictionMode to set.
         * @return This builder for chaining.
         */
        public Builder setRestrictionMode(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          restrictionMode_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Restriction mode for customer-managed encryption for new objects within
         * the bucket. Valid values are: "NotRestricted", "FullyRestricted".
         * If `NotRestricted` or unset, creation of new objects with
         * customer-managed encryption is allowed.
         * If `FullyRestricted`, new objects can't be created using
         * customer-managed encryption.
         * </pre>
         *
         * <code>optional string restriction_mode = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearRestrictionMode() {
          restrictionMode_ = getDefaultInstance().getRestrictionMode();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Restriction mode for customer-managed encryption for new objects within
         * the bucket. Valid values are: "NotRestricted", "FullyRestricted".
         * If `NotRestricted` or unset, creation of new objects with
         * customer-managed encryption is allowed.
         * If `FullyRestricted`, new objects can't be created using
         * customer-managed encryption.
         * </pre>
         *
         * <code>optional string restriction_mode = 3;</code>
         *
         * @param value The bytes for restrictionMode to set.
         * @return This builder for chaining.
         */
        public Builder setRestrictionModeBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          restrictionMode_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.protobuf.Timestamp effectiveTime_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>
            effectiveTimeBuilder_;

        /**
         *
         *
         * <pre>
         * Time from which the config was effective. This is service-provided.
         * </pre>
         *
         * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
         *
         * @return Whether the effectiveTime field is set.
         */
        public boolean hasEffectiveTime() {
          return ((bitField0_ & 0x00000002) != 0);
        }

        /**
         *
         *
         * <pre>
         * Time from which the config was effective. This is service-provided.
         * </pre>
         *
         * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
         *
         * @return The effectiveTime.
         */
        public com.google.protobuf.Timestamp getEffectiveTime() {
          if (effectiveTimeBuilder_ == null) {
            return effectiveTime_ == null
                ? com.google.protobuf.Timestamp.getDefaultInstance()
                : effectiveTime_;
          } else {
            return effectiveTimeBuilder_.getMessage();
          }
        }

        /**
         *
         *
         * <pre>
         * Time from which the config was effective. This is service-provided.
         * </pre>
         *
         * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
         */
        public Builder setEffectiveTime(com.google.protobuf.Timestamp value) {
          if (effectiveTimeBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            effectiveTime_ = value;
          } else {
            effectiveTimeBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Time from which the config was effective. This is service-provided.
         * </pre>
         *
         * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
         */
        public Builder setEffectiveTime(com.google.protobuf.Timestamp.Builder builderForValue) {
          if (effectiveTimeBuilder_ == null) {
            effectiveTime_ = builderForValue.build();
          } else {
            effectiveTimeBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Time from which the config was effective. This is service-provided.
         * </pre>
         *
         * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
         */
        public Builder mergeEffectiveTime(com.google.protobuf.Timestamp value) {
          if (effectiveTimeBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && effectiveTime_ != null
                && effectiveTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
              getEffectiveTimeBuilder().mergeFrom(value);
            } else {
              effectiveTime_ = value;
            }
          } else {
            effectiveTimeBuilder_.mergeFrom(value);
          }
          if (effectiveTime_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Time from which the config was effective. This is service-provided.
         * </pre>
         *
         * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
         */
        public Builder clearEffectiveTime() {
          bitField0_ = (bitField0_ & ~0x00000002);
          effectiveTime_ = null;
          if (effectiveTimeBuilder_ != null) {
            effectiveTimeBuilder_.dispose();
            effectiveTimeBuilder_ = null;
          }
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Time from which the config was effective. This is service-provided.
         * </pre>
         *
         * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
         */
        public com.google.protobuf.Timestamp.Builder getEffectiveTimeBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getEffectiveTimeFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Time from which the config was effective. This is service-provided.
         * </pre>
         *
         * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
         */
        public com.google.protobuf.TimestampOrBuilder getEffectiveTimeOrBuilder() {
          if (effectiveTimeBuilder_ != null) {
            return effectiveTimeBuilder_.getMessageOrBuilder();
          } else {
            return effectiveTime_ == null
                ? com.google.protobuf.Timestamp.getDefaultInstance()
                : effectiveTime_;
          }
        }

        /**
         *
         *
         * <pre>
         * Time from which the config was effective. This is service-provided.
         * </pre>
         *
         * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>
            getEffectiveTimeFieldBuilder() {
          if (effectiveTimeBuilder_ == null) {
            effectiveTimeBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Timestamp,
                    com.google.protobuf.Timestamp.Builder,
                    com.google.protobuf.TimestampOrBuilder>(
                    getEffectiveTime(), getParentForChildren(), isClean());
            effectiveTime_ = null;
          }
          return effectiveTimeBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig)
      }

      // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig)
      private static final com.google.storage.v2.Bucket.Encryption
              .CustomerManagedEncryptionEnforcementConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.storage.v2.Bucket.Encryption
                .CustomerManagedEncryptionEnforcementConfig();
      }

      public static com.google.storage.v2.Bucket.Encryption
              .CustomerManagedEncryptionEnforcementConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<CustomerManagedEncryptionEnforcementConfig>
          PARSER =
              new com.google.protobuf.AbstractParser<CustomerManagedEncryptionEnforcementConfig>() {
                @java.lang.Override
                public CustomerManagedEncryptionEnforcementConfig parsePartialFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                  Builder builder = newBuilder();
                  try {
                    builder.mergeFrom(input, extensionRegistry);
                  } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage(builder.buildPartial());
                  } catch (com.google.protobuf.UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException()
                        .setUnfinishedMessage(builder.buildPartial());
                  } catch (java.io.IOException e) {
                    throw new com.google.protobuf.InvalidProtocolBufferException(e)
                        .setUnfinishedMessage(builder.buildPartial());
                  }
                  return builder.buildPartial();
                }
              };

      public static com.google.protobuf.Parser<CustomerManagedEncryptionEnforcementConfig>
          parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<CustomerManagedEncryptionEnforcementConfig>
          getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface CustomerSuppliedEncryptionEnforcementConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Restriction mode for customer-supplied encryption for new objects
       * within the bucket. Valid values are: "NotRestricted",
       * "FullyRestricted".
       * If `NotRestricted` or unset, creation of new objects with
       * customer-supplied encryption is allowed.
       * If `FullyRestricted`, new objects can't be created using
       * customer-supplied encryption.
       * </pre>
       *
       * <code>optional string restriction_mode = 3;</code>
       *
       * @return Whether the restrictionMode field is set.
       */
      boolean hasRestrictionMode();

      /**
       *
       *
       * <pre>
       * Restriction mode for customer-supplied encryption for new objects
       * within the bucket. Valid values are: "NotRestricted",
       * "FullyRestricted".
       * If `NotRestricted` or unset, creation of new objects with
       * customer-supplied encryption is allowed.
       * If `FullyRestricted`, new objects can't be created using
       * customer-supplied encryption.
       * </pre>
       *
       * <code>optional string restriction_mode = 3;</code>
       *
       * @return The restrictionMode.
       */
      java.lang.String getRestrictionMode();

      /**
       *
       *
       * <pre>
       * Restriction mode for customer-supplied encryption for new objects
       * within the bucket. Valid values are: "NotRestricted",
       * "FullyRestricted".
       * If `NotRestricted` or unset, creation of new objects with
       * customer-supplied encryption is allowed.
       * If `FullyRestricted`, new objects can't be created using
       * customer-supplied encryption.
       * </pre>
       *
       * <code>optional string restriction_mode = 3;</code>
       *
       * @return The bytes for restrictionMode.
       */
      com.google.protobuf.ByteString getRestrictionModeBytes();

      /**
       *
       *
       * <pre>
       * Time from which the config was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       *
       * @return Whether the effectiveTime field is set.
       */
      boolean hasEffectiveTime();

      /**
       *
       *
       * <pre>
       * Time from which the config was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       *
       * @return The effectiveTime.
       */
      com.google.protobuf.Timestamp getEffectiveTime();

      /**
       *
       *
       * <pre>
       * Time from which the config was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       */
      com.google.protobuf.TimestampOrBuilder getEffectiveTimeOrBuilder();
    }

    /**
     *
     *
     * <pre>
     * Customer Supplied Encryption (CSEK) enforcement config of a bucket.
     * </pre>
     *
     * Protobuf type {@code
     * google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig}
     */
    public static final class CustomerSuppliedEncryptionEnforcementConfig
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig)
        CustomerSuppliedEncryptionEnforcementConfigOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use CustomerSuppliedEncryptionEnforcementConfig.newBuilder() to construct.
      private CustomerSuppliedEncryptionEnforcementConfig(
          com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private CustomerSuppliedEncryptionEnforcementConfig() {
        restrictionMode_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new CustomerSuppliedEncryptionEnforcementConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Encryption_CustomerSuppliedEncryptionEnforcementConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Encryption_CustomerSuppliedEncryptionEnforcementConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig
                    .class,
                com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig
                    .Builder.class);
      }

      private int bitField0_;
      public static final int RESTRICTION_MODE_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private volatile java.lang.Object restrictionMode_ = "";

      /**
       *
       *
       * <pre>
       * Restriction mode for customer-supplied encryption for new objects
       * within the bucket. Valid values are: "NotRestricted",
       * "FullyRestricted".
       * If `NotRestricted` or unset, creation of new objects with
       * customer-supplied encryption is allowed.
       * If `FullyRestricted`, new objects can't be created using
       * customer-supplied encryption.
       * </pre>
       *
       * <code>optional string restriction_mode = 3;</code>
       *
       * @return Whether the restrictionMode field is set.
       */
      @java.lang.Override
      public boolean hasRestrictionMode() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Restriction mode for customer-supplied encryption for new objects
       * within the bucket. Valid values are: "NotRestricted",
       * "FullyRestricted".
       * If `NotRestricted` or unset, creation of new objects with
       * customer-supplied encryption is allowed.
       * If `FullyRestricted`, new objects can't be created using
       * customer-supplied encryption.
       * </pre>
       *
       * <code>optional string restriction_mode = 3;</code>
       *
       * @return The restrictionMode.
       */
      @java.lang.Override
      public java.lang.String getRestrictionMode() {
        java.lang.Object ref = restrictionMode_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          restrictionMode_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Restriction mode for customer-supplied encryption for new objects
       * within the bucket. Valid values are: "NotRestricted",
       * "FullyRestricted".
       * If `NotRestricted` or unset, creation of new objects with
       * customer-supplied encryption is allowed.
       * If `FullyRestricted`, new objects can't be created using
       * customer-supplied encryption.
       * </pre>
       *
       * <code>optional string restriction_mode = 3;</code>
       *
       * @return The bytes for restrictionMode.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getRestrictionModeBytes() {
        java.lang.Object ref = restrictionMode_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          restrictionMode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int EFFECTIVE_TIME_FIELD_NUMBER = 2;
      private com.google.protobuf.Timestamp effectiveTime_;

      /**
       *
       *
       * <pre>
       * Time from which the config was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       *
       * @return Whether the effectiveTime field is set.
       */
      @java.lang.Override
      public boolean hasEffectiveTime() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Time from which the config was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       *
       * @return The effectiveTime.
       */
      @java.lang.Override
      public com.google.protobuf.Timestamp getEffectiveTime() {
        return effectiveTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : effectiveTime_;
      }

      /**
       *
       *
       * <pre>
       * Time from which the config was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       */
      @java.lang.Override
      public com.google.protobuf.TimestampOrBuilder getEffectiveTimeOrBuilder() {
        return effectiveTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : effectiveTime_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(2, getEffectiveTime());
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, restrictionMode_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEffectiveTime());
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, restrictionMode_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig)) {
          return super.equals(obj);
        }
        com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig other =
            (com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig)
                obj;

        if (hasRestrictionMode() != other.hasRestrictionMode()) return false;
        if (hasRestrictionMode()) {
          if (!getRestrictionMode().equals(other.getRestrictionMode())) return false;
        }
        if (hasEffectiveTime() != other.hasEffectiveTime()) return false;
        if (hasEffectiveTime()) {
          if (!getEffectiveTime().equals(other.getEffectiveTime())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasRestrictionMode()) {
          hash = (37 * hash) + RESTRICTION_MODE_FIELD_NUMBER;
          hash = (53 * hash) + getRestrictionMode().hashCode();
        }
        if (hasEffectiveTime()) {
          hash = (37 * hash) + EFFECTIVE_TIME_FIELD_NUMBER;
          hash = (53 * hash) + getEffectiveTime().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.storage.v2.Bucket.Encryption
              .CustomerSuppliedEncryptionEnforcementConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.Encryption
              .CustomerSuppliedEncryptionEnforcementConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Encryption
              .CustomerSuppliedEncryptionEnforcementConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.Encryption
              .CustomerSuppliedEncryptionEnforcementConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Encryption
              .CustomerSuppliedEncryptionEnforcementConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.Encryption
              .CustomerSuppliedEncryptionEnforcementConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Encryption
              .CustomerSuppliedEncryptionEnforcementConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.Encryption
              .CustomerSuppliedEncryptionEnforcementConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Encryption
              .CustomerSuppliedEncryptionEnforcementConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.Encryption
              .CustomerSuppliedEncryptionEnforcementConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Encryption
              .CustomerSuppliedEncryptionEnforcementConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.Encryption
              .CustomerSuppliedEncryptionEnforcementConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Customer Supplied Encryption (CSEK) enforcement config of a bucket.
       * </pre>
       *
       * Protobuf type {@code
       * google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig)
          com.google.storage.v2.Bucket.Encryption
              .CustomerSuppliedEncryptionEnforcementConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Encryption_CustomerSuppliedEncryptionEnforcementConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Encryption_CustomerSuppliedEncryptionEnforcementConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.storage.v2.Bucket.Encryption
                      .CustomerSuppliedEncryptionEnforcementConfig.class,
                  com.google.storage.v2.Bucket.Encryption
                      .CustomerSuppliedEncryptionEnforcementConfig.Builder.class);
        }

        // Construct using
        // com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getEffectiveTimeFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          restrictionMode_ = "";
          effectiveTime_ = null;
          if (effectiveTimeBuilder_ != null) {
            effectiveTimeBuilder_.dispose();
            effectiveTimeBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Encryption_CustomerSuppliedEncryptionEnforcementConfig_descriptor;
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig
            getDefaultInstanceForType() {
          return com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig
            build() {
          com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig
            buildPartial() {
          com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig
              result =
                  new com.google.storage.v2.Bucket.Encryption
                      .CustomerSuppliedEncryptionEnforcementConfig(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig
                result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.restrictionMode_ = restrictionMode_;
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.effectiveTime_ =
                effectiveTimeBuilder_ == null ? effectiveTime_ : effectiveTimeBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig) {
            return mergeFrom(
                (com.google.storage.v2.Bucket.Encryption
                        .CustomerSuppliedEncryptionEnforcementConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig
                other) {
          if (other
              == com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig
                  .getDefaultInstance()) return this;
          if (other.hasRestrictionMode()) {
            restrictionMode_ = other.restrictionMode_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasEffectiveTime()) {
            mergeEffectiveTime(other.getEffectiveTime());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 18:
                  {
                    input.readMessage(
                        getEffectiveTimeFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    restrictionMode_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object restrictionMode_ = "";

        /**
         *
         *
         * <pre>
         * Restriction mode for customer-supplied encryption for new objects
         * within the bucket. Valid values are: "NotRestricted",
         * "FullyRestricted".
         * If `NotRestricted` or unset, creation of new objects with
         * customer-supplied encryption is allowed.
         * If `FullyRestricted`, new objects can't be created using
         * customer-supplied encryption.
         * </pre>
         *
         * <code>optional string restriction_mode = 3;</code>
         *
         * @return Whether the restrictionMode field is set.
         */
        public boolean hasRestrictionMode() {
          return ((bitField0_ & 0x00000001) != 0);
        }

        /**
         *
         *
         * <pre>
         * Restriction mode for customer-supplied encryption for new objects
         * within the bucket. Valid values are: "NotRestricted",
         * "FullyRestricted".
         * If `NotRestricted` or unset, creation of new objects with
         * customer-supplied encryption is allowed.
         * If `FullyRestricted`, new objects can't be created using
         * customer-supplied encryption.
         * </pre>
         *
         * <code>optional string restriction_mode = 3;</code>
         *
         * @return The restrictionMode.
         */
        public java.lang.String getRestrictionMode() {
          java.lang.Object ref = restrictionMode_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            restrictionMode_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Restriction mode for customer-supplied encryption for new objects
         * within the bucket. Valid values are: "NotRestricted",
         * "FullyRestricted".
         * If `NotRestricted` or unset, creation of new objects with
         * customer-supplied encryption is allowed.
         * If `FullyRestricted`, new objects can't be created using
         * customer-supplied encryption.
         * </pre>
         *
         * <code>optional string restriction_mode = 3;</code>
         *
         * @return The bytes for restrictionMode.
         */
        public com.google.protobuf.ByteString getRestrictionModeBytes() {
          java.lang.Object ref = restrictionMode_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            restrictionMode_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Restriction mode for customer-supplied encryption for new objects
         * within the bucket. Valid values are: "NotRestricted",
         * "FullyRestricted".
         * If `NotRestricted` or unset, creation of new objects with
         * customer-supplied encryption is allowed.
         * If `FullyRestricted`, new objects can't be created using
         * customer-supplied encryption.
         * </pre>
         *
         * <code>optional string restriction_mode = 3;</code>
         *
         * @param value The restrictionMode to set.
         * @return This builder for chaining.
         */
        public Builder setRestrictionMode(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          restrictionMode_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Restriction mode for customer-supplied encryption for new objects
         * within the bucket. Valid values are: "NotRestricted",
         * "FullyRestricted".
         * If `NotRestricted` or unset, creation of new objects with
         * customer-supplied encryption is allowed.
         * If `FullyRestricted`, new objects can't be created using
         * customer-supplied encryption.
         * </pre>
         *
         * <code>optional string restriction_mode = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearRestrictionMode() {
          restrictionMode_ = getDefaultInstance().getRestrictionMode();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Restriction mode for customer-supplied encryption for new objects
         * within the bucket. Valid values are: "NotRestricted",
         * "FullyRestricted".
         * If `NotRestricted` or unset, creation of new objects with
         * customer-supplied encryption is allowed.
         * If `FullyRestricted`, new objects can't be created using
         * customer-supplied encryption.
         * </pre>
         *
         * <code>optional string restriction_mode = 3;</code>
         *
         * @param value The bytes for restrictionMode to set.
         * @return This builder for chaining.
         */
        public Builder setRestrictionModeBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          restrictionMode_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.protobuf.Timestamp effectiveTime_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>
            effectiveTimeBuilder_;

        /**
         *
         *
         * <pre>
         * Time from which the config was effective. This is service-provided.
         * </pre>
         *
         * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
         *
         * @return Whether the effectiveTime field is set.
         */
        public boolean hasEffectiveTime() {
          return ((bitField0_ & 0x00000002) != 0);
        }

        /**
         *
         *
         * <pre>
         * Time from which the config was effective. This is service-provided.
         * </pre>
         *
         * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
         *
         * @return The effectiveTime.
         */
        public com.google.protobuf.Timestamp getEffectiveTime() {
          if (effectiveTimeBuilder_ == null) {
            return effectiveTime_ == null
                ? com.google.protobuf.Timestamp.getDefaultInstance()
                : effectiveTime_;
          } else {
            return effectiveTimeBuilder_.getMessage();
          }
        }

        /**
         *
         *
         * <pre>
         * Time from which the config was effective. This is service-provided.
         * </pre>
         *
         * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
         */
        public Builder setEffectiveTime(com.google.protobuf.Timestamp value) {
          if (effectiveTimeBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            effectiveTime_ = value;
          } else {
            effectiveTimeBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Time from which the config was effective. This is service-provided.
         * </pre>
         *
         * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
         */
        public Builder setEffectiveTime(com.google.protobuf.Timestamp.Builder builderForValue) {
          if (effectiveTimeBuilder_ == null) {
            effectiveTime_ = builderForValue.build();
          } else {
            effectiveTimeBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Time from which the config was effective. This is service-provided.
         * </pre>
         *
         * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
         */
        public Builder mergeEffectiveTime(com.google.protobuf.Timestamp value) {
          if (effectiveTimeBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && effectiveTime_ != null
                && effectiveTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
              getEffectiveTimeBuilder().mergeFrom(value);
            } else {
              effectiveTime_ = value;
            }
          } else {
            effectiveTimeBuilder_.mergeFrom(value);
          }
          if (effectiveTime_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Time from which the config was effective. This is service-provided.
         * </pre>
         *
         * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
         */
        public Builder clearEffectiveTime() {
          bitField0_ = (bitField0_ & ~0x00000002);
          effectiveTime_ = null;
          if (effectiveTimeBuilder_ != null) {
            effectiveTimeBuilder_.dispose();
            effectiveTimeBuilder_ = null;
          }
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Time from which the config was effective. This is service-provided.
         * </pre>
         *
         * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
         */
        public com.google.protobuf.Timestamp.Builder getEffectiveTimeBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getEffectiveTimeFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Time from which the config was effective. This is service-provided.
         * </pre>
         *
         * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
         */
        public com.google.protobuf.TimestampOrBuilder getEffectiveTimeOrBuilder() {
          if (effectiveTimeBuilder_ != null) {
            return effectiveTimeBuilder_.getMessageOrBuilder();
          } else {
            return effectiveTime_ == null
                ? com.google.protobuf.Timestamp.getDefaultInstance()
                : effectiveTime_;
          }
        }

        /**
         *
         *
         * <pre>
         * Time from which the config was effective. This is service-provided.
         * </pre>
         *
         * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>
            getEffectiveTimeFieldBuilder() {
          if (effectiveTimeBuilder_ == null) {
            effectiveTimeBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Timestamp,
                    com.google.protobuf.Timestamp.Builder,
                    com.google.protobuf.TimestampOrBuilder>(
                    getEffectiveTime(), getParentForChildren(), isClean());
            effectiveTime_ = null;
          }
          return effectiveTimeBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig)
      }

      // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig)
      private static final com.google.storage.v2.Bucket.Encryption
              .CustomerSuppliedEncryptionEnforcementConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.storage.v2.Bucket.Encryption
                .CustomerSuppliedEncryptionEnforcementConfig();
      }

      public static com.google.storage.v2.Bucket.Encryption
              .CustomerSuppliedEncryptionEnforcementConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<CustomerSuppliedEncryptionEnforcementConfig>
          PARSER =
              new com.google.protobuf.AbstractParser<
                  CustomerSuppliedEncryptionEnforcementConfig>() {
                @java.lang.Override
                public CustomerSuppliedEncryptionEnforcementConfig parsePartialFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                  Builder builder = newBuilder();
                  try {
                    builder.mergeFrom(input, extensionRegistry);
                  } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage(builder.buildPartial());
                  } catch (com.google.protobuf.UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException()
                        .setUnfinishedMessage(builder.buildPartial());
                  } catch (java.io.IOException e) {
                    throw new com.google.protobuf.InvalidProtocolBufferException(e)
                        .setUnfinishedMessage(builder.buildPartial());
                  }
                  return builder.buildPartial();
                }
              };

      public static com.google.protobuf.Parser<CustomerSuppliedEncryptionEnforcementConfig>
          parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<CustomerSuppliedEncryptionEnforcementConfig>
          getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int DEFAULT_KMS_KEY_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object defaultKmsKey_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The name of the Cloud KMS key that will be used to encrypt
     * objects inserted into this bucket, if no encryption method is specified.
     * </pre>
     *
     * <code>
     * string default_kms_key = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The defaultKmsKey.
     */
    @java.lang.Override
    public java.lang.String getDefaultKmsKey() {
      java.lang.Object ref = defaultKmsKey_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultKmsKey_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the Cloud KMS key that will be used to encrypt
     * objects inserted into this bucket, if no encryption method is specified.
     * </pre>
     *
     * <code>
     * string default_kms_key = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for defaultKmsKey.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDefaultKmsKeyBytes() {
      java.lang.Object ref = defaultKmsKey_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultKmsKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GOOGLE_MANAGED_ENCRYPTION_ENFORCEMENT_CONFIG_FIELD_NUMBER = 2;
    private com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
        googleManagedEncryptionEnforcementConfig_;

    /**
     *
     *
     * <pre>
     * Optional. If omitted, then new objects with GMEK encryption-type is
     * allowed. If set, then new objects created in this bucket must comply with
     * enforcement config. Changing this has no effect on existing objects; it
     * applies to new objects only.
     * </pre>
     *
     * <code>
     * optional .google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig google_managed_encryption_enforcement_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the googleManagedEncryptionEnforcementConfig field is set.
     */
    @java.lang.Override
    public boolean hasGoogleManagedEncryptionEnforcementConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. If omitted, then new objects with GMEK encryption-type is
     * allowed. If set, then new objects created in this bucket must comply with
     * enforcement config. Changing this has no effect on existing objects; it
     * applies to new objects only.
     * </pre>
     *
     * <code>
     * optional .google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig google_managed_encryption_enforcement_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The googleManagedEncryptionEnforcementConfig.
     */
    @java.lang.Override
    public com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
        getGoogleManagedEncryptionEnforcementConfig() {
      return googleManagedEncryptionEnforcementConfig_ == null
          ? com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
              .getDefaultInstance()
          : googleManagedEncryptionEnforcementConfig_;
    }

    /**
     *
     *
     * <pre>
     * Optional. If omitted, then new objects with GMEK encryption-type is
     * allowed. If set, then new objects created in this bucket must comply with
     * enforcement config. Changing this has no effect on existing objects; it
     * applies to new objects only.
     * </pre>
     *
     * <code>
     * optional .google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig google_managed_encryption_enforcement_config = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfigOrBuilder
        getGoogleManagedEncryptionEnforcementConfigOrBuilder() {
      return googleManagedEncryptionEnforcementConfig_ == null
          ? com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
              .getDefaultInstance()
          : googleManagedEncryptionEnforcementConfig_;
    }

    public static final int CUSTOMER_MANAGED_ENCRYPTION_ENFORCEMENT_CONFIG_FIELD_NUMBER = 3;
    private com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
        customerManagedEncryptionEnforcementConfig_;

    /**
     *
     *
     * <pre>
     * Optional. If omitted, then new objects with CMEK encryption-type is
     * allowed. If set, then new objects created in this bucket must comply with
     * enforcement config. Changing this has no effect on existing objects; it
     * applies to new objects only.
     * </pre>
     *
     * <code>
     * optional .google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig customer_managed_encryption_enforcement_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the customerManagedEncryptionEnforcementConfig field is set.
     */
    @java.lang.Override
    public boolean hasCustomerManagedEncryptionEnforcementConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. If omitted, then new objects with CMEK encryption-type is
     * allowed. If set, then new objects created in this bucket must comply with
     * enforcement config. Changing this has no effect on existing objects; it
     * applies to new objects only.
     * </pre>
     *
     * <code>
     * optional .google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig customer_managed_encryption_enforcement_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The customerManagedEncryptionEnforcementConfig.
     */
    @java.lang.Override
    public com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
        getCustomerManagedEncryptionEnforcementConfig() {
      return customerManagedEncryptionEnforcementConfig_ == null
          ? com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
              .getDefaultInstance()
          : customerManagedEncryptionEnforcementConfig_;
    }

    /**
     *
     *
     * <pre>
     * Optional. If omitted, then new objects with CMEK encryption-type is
     * allowed. If set, then new objects created in this bucket must comply with
     * enforcement config. Changing this has no effect on existing objects; it
     * applies to new objects only.
     * </pre>
     *
     * <code>
     * optional .google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig customer_managed_encryption_enforcement_config = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.storage.v2.Bucket.Encryption
            .CustomerManagedEncryptionEnforcementConfigOrBuilder
        getCustomerManagedEncryptionEnforcementConfigOrBuilder() {
      return customerManagedEncryptionEnforcementConfig_ == null
          ? com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
              .getDefaultInstance()
          : customerManagedEncryptionEnforcementConfig_;
    }

    public static final int CUSTOMER_SUPPLIED_ENCRYPTION_ENFORCEMENT_CONFIG_FIELD_NUMBER = 4;
    private com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig
        customerSuppliedEncryptionEnforcementConfig_;

    /**
     *
     *
     * <pre>
     * Optional. If omitted, then new objects with CSEK encryption-type is
     * allowed. If set, then new objects created in this bucket must comply with
     * enforcement config. Changing this has no effect on existing objects; it
     * applies to new objects only.
     * </pre>
     *
     * <code>
     * optional .google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig customer_supplied_encryption_enforcement_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the customerSuppliedEncryptionEnforcementConfig field is set.
     */
    @java.lang.Override
    public boolean hasCustomerSuppliedEncryptionEnforcementConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. If omitted, then new objects with CSEK encryption-type is
     * allowed. If set, then new objects created in this bucket must comply with
     * enforcement config. Changing this has no effect on existing objects; it
     * applies to new objects only.
     * </pre>
     *
     * <code>
     * optional .google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig customer_supplied_encryption_enforcement_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The customerSuppliedEncryptionEnforcementConfig.
     */
    @java.lang.Override
    public com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig
        getCustomerSuppliedEncryptionEnforcementConfig() {
      return customerSuppliedEncryptionEnforcementConfig_ == null
          ? com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig
              .getDefaultInstance()
          : customerSuppliedEncryptionEnforcementConfig_;
    }

    /**
     *
     *
     * <pre>
     * Optional. If omitted, then new objects with CSEK encryption-type is
     * allowed. If set, then new objects created in this bucket must comply with
     * enforcement config. Changing this has no effect on existing objects; it
     * applies to new objects only.
     * </pre>
     *
     * <code>
     * optional .google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig customer_supplied_encryption_enforcement_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.storage.v2.Bucket.Encryption
            .CustomerSuppliedEncryptionEnforcementConfigOrBuilder
        getCustomerSuppliedEncryptionEnforcementConfigOrBuilder() {
      return customerSuppliedEncryptionEnforcementConfig_ == null
          ? com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig
              .getDefaultInstance()
          : customerSuppliedEncryptionEnforcementConfig_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultKmsKey_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, defaultKmsKey_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getGoogleManagedEncryptionEnforcementConfig());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(3, getCustomerManagedEncryptionEnforcementConfig());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(4, getCustomerSuppliedEncryptionEnforcementConfig());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultKmsKey_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, defaultKmsKey_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, getGoogleManagedEncryptionEnforcementConfig());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, getCustomerManagedEncryptionEnforcementConfig());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4, getCustomerSuppliedEncryptionEnforcementConfig());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.Encryption)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.Encryption other = (com.google.storage.v2.Bucket.Encryption) obj;

      if (!getDefaultKmsKey().equals(other.getDefaultKmsKey())) return false;
      if (hasGoogleManagedEncryptionEnforcementConfig()
          != other.hasGoogleManagedEncryptionEnforcementConfig()) return false;
      if (hasGoogleManagedEncryptionEnforcementConfig()) {
        if (!getGoogleManagedEncryptionEnforcementConfig()
            .equals(other.getGoogleManagedEncryptionEnforcementConfig())) return false;
      }
      if (hasCustomerManagedEncryptionEnforcementConfig()
          != other.hasCustomerManagedEncryptionEnforcementConfig()) return false;
      if (hasCustomerManagedEncryptionEnforcementConfig()) {
        if (!getCustomerManagedEncryptionEnforcementConfig()
            .equals(other.getCustomerManagedEncryptionEnforcementConfig())) return false;
      }
      if (hasCustomerSuppliedEncryptionEnforcementConfig()
          != other.hasCustomerSuppliedEncryptionEnforcementConfig()) return false;
      if (hasCustomerSuppliedEncryptionEnforcementConfig()) {
        if (!getCustomerSuppliedEncryptionEnforcementConfig()
            .equals(other.getCustomerSuppliedEncryptionEnforcementConfig())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DEFAULT_KMS_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultKmsKey().hashCode();
      if (hasGoogleManagedEncryptionEnforcementConfig()) {
        hash = (37 * hash) + GOOGLE_MANAGED_ENCRYPTION_ENFORCEMENT_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getGoogleManagedEncryptionEnforcementConfig().hashCode();
      }
      if (hasCustomerManagedEncryptionEnforcementConfig()) {
        hash = (37 * hash) + CUSTOMER_MANAGED_ENCRYPTION_ENFORCEMENT_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getCustomerManagedEncryptionEnforcementConfig().hashCode();
      }
      if (hasCustomerSuppliedEncryptionEnforcementConfig()) {
        hash = (37 * hash) + CUSTOMER_SUPPLIED_ENCRYPTION_ENFORCEMENT_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getCustomerSuppliedEncryptionEnforcementConfig().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Encryption parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Encryption parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Encryption parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.Encryption prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Encryption properties of a bucket.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.Encryption}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Encryption)
        com.google.storage.v2.Bucket.EncryptionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Encryption_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Encryption_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.Encryption.class,
                com.google.storage.v2.Bucket.Encryption.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.Encryption.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getGoogleManagedEncryptionEnforcementConfigFieldBuilder();
          getCustomerManagedEncryptionEnforcementConfigFieldBuilder();
          getCustomerSuppliedEncryptionEnforcementConfigFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        defaultKmsKey_ = "";
        googleManagedEncryptionEnforcementConfig_ = null;
        if (googleManagedEncryptionEnforcementConfigBuilder_ != null) {
          googleManagedEncryptionEnforcementConfigBuilder_.dispose();
          googleManagedEncryptionEnforcementConfigBuilder_ = null;
        }
        customerManagedEncryptionEnforcementConfig_ = null;
        if (customerManagedEncryptionEnforcementConfigBuilder_ != null) {
          customerManagedEncryptionEnforcementConfigBuilder_.dispose();
          customerManagedEncryptionEnforcementConfigBuilder_ = null;
        }
        customerSuppliedEncryptionEnforcementConfig_ = null;
        if (customerSuppliedEncryptionEnforcementConfigBuilder_ != null) {
          customerSuppliedEncryptionEnforcementConfigBuilder_.dispose();
          customerSuppliedEncryptionEnforcementConfigBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Encryption_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Encryption getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.Encryption.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Encryption build() {
        com.google.storage.v2.Bucket.Encryption result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Encryption buildPartial() {
        com.google.storage.v2.Bucket.Encryption result =
            new com.google.storage.v2.Bucket.Encryption(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.storage.v2.Bucket.Encryption result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.defaultKmsKey_ = defaultKmsKey_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.googleManagedEncryptionEnforcementConfig_ =
              googleManagedEncryptionEnforcementConfigBuilder_ == null
                  ? googleManagedEncryptionEnforcementConfig_
                  : googleManagedEncryptionEnforcementConfigBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.customerManagedEncryptionEnforcementConfig_ =
              customerManagedEncryptionEnforcementConfigBuilder_ == null
                  ? customerManagedEncryptionEnforcementConfig_
                  : customerManagedEncryptionEnforcementConfigBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.customerSuppliedEncryptionEnforcementConfig_ =
              customerSuppliedEncryptionEnforcementConfigBuilder_ == null
                  ? customerSuppliedEncryptionEnforcementConfig_
                  : customerSuppliedEncryptionEnforcementConfigBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.Encryption) {
          return mergeFrom((com.google.storage.v2.Bucket.Encryption) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.Encryption other) {
        if (other == com.google.storage.v2.Bucket.Encryption.getDefaultInstance()) return this;
        if (!other.getDefaultKmsKey().isEmpty()) {
          defaultKmsKey_ = other.defaultKmsKey_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasGoogleManagedEncryptionEnforcementConfig()) {
          mergeGoogleManagedEncryptionEnforcementConfig(
              other.getGoogleManagedEncryptionEnforcementConfig());
        }
        if (other.hasCustomerManagedEncryptionEnforcementConfig()) {
          mergeCustomerManagedEncryptionEnforcementConfig(
              other.getCustomerManagedEncryptionEnforcementConfig());
        }
        if (other.hasCustomerSuppliedEncryptionEnforcementConfig()) {
          mergeCustomerSuppliedEncryptionEnforcementConfig(
              other.getCustomerSuppliedEncryptionEnforcementConfig());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  defaultKmsKey_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getGoogleManagedEncryptionEnforcementConfigFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getCustomerManagedEncryptionEnforcementConfigFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(
                      getCustomerSuppliedEncryptionEnforcementConfigFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object defaultKmsKey_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The name of the Cloud KMS key that will be used to encrypt
       * objects inserted into this bucket, if no encryption method is specified.
       * </pre>
       *
       * <code>
       * string default_kms_key = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The defaultKmsKey.
       */
      public java.lang.String getDefaultKmsKey() {
        java.lang.Object ref = defaultKmsKey_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          defaultKmsKey_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The name of the Cloud KMS key that will be used to encrypt
       * objects inserted into this bucket, if no encryption method is specified.
       * </pre>
       *
       * <code>
       * string default_kms_key = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for defaultKmsKey.
       */
      public com.google.protobuf.ByteString getDefaultKmsKeyBytes() {
        java.lang.Object ref = defaultKmsKey_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          defaultKmsKey_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The name of the Cloud KMS key that will be used to encrypt
       * objects inserted into this bucket, if no encryption method is specified.
       * </pre>
       *
       * <code>
       * string default_kms_key = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The defaultKmsKey to set.
       * @return This builder for chaining.
       */
      public Builder setDefaultKmsKey(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        defaultKmsKey_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The name of the Cloud KMS key that will be used to encrypt
       * objects inserted into this bucket, if no encryption method is specified.
       * </pre>
       *
       * <code>
       * string default_kms_key = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDefaultKmsKey() {
        defaultKmsKey_ = getDefaultInstance().getDefaultKmsKey();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The name of the Cloud KMS key that will be used to encrypt
       * objects inserted into this bucket, if no encryption method is specified.
       * </pre>
       *
       * <code>
       * string default_kms_key = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for defaultKmsKey to set.
       * @return This builder for chaining.
       */
      public Builder setDefaultKmsKeyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        defaultKmsKey_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
          googleManagedEncryptionEnforcementConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig,
              com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
                  .Builder,
              com.google.storage.v2.Bucket.Encryption
                  .GoogleManagedEncryptionEnforcementConfigOrBuilder>
          googleManagedEncryptionEnforcementConfigBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. If omitted, then new objects with GMEK encryption-type is
       * allowed. If set, then new objects created in this bucket must comply with
       * enforcement config. Changing this has no effect on existing objects; it
       * applies to new objects only.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig google_managed_encryption_enforcement_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the googleManagedEncryptionEnforcementConfig field is set.
       */
      public boolean hasGoogleManagedEncryptionEnforcementConfig() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. If omitted, then new objects with GMEK encryption-type is
       * allowed. If set, then new objects created in this bucket must comply with
       * enforcement config. Changing this has no effect on existing objects; it
       * applies to new objects only.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig google_managed_encryption_enforcement_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The googleManagedEncryptionEnforcementConfig.
       */
      public com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
          getGoogleManagedEncryptionEnforcementConfig() {
        if (googleManagedEncryptionEnforcementConfigBuilder_ == null) {
          return googleManagedEncryptionEnforcementConfig_ == null
              ? com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
                  .getDefaultInstance()
              : googleManagedEncryptionEnforcementConfig_;
        } else {
          return googleManagedEncryptionEnforcementConfigBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. If omitted, then new objects with GMEK encryption-type is
       * allowed. If set, then new objects created in this bucket must comply with
       * enforcement config. Changing this has no effect on existing objects; it
       * applies to new objects only.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig google_managed_encryption_enforcement_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setGoogleManagedEncryptionEnforcementConfig(
          com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig value) {
        if (googleManagedEncryptionEnforcementConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          googleManagedEncryptionEnforcementConfig_ = value;
        } else {
          googleManagedEncryptionEnforcementConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If omitted, then new objects with GMEK encryption-type is
       * allowed. If set, then new objects created in this bucket must comply with
       * enforcement config. Changing this has no effect on existing objects; it
       * applies to new objects only.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig google_managed_encryption_enforcement_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setGoogleManagedEncryptionEnforcementConfig(
          com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig.Builder
              builderForValue) {
        if (googleManagedEncryptionEnforcementConfigBuilder_ == null) {
          googleManagedEncryptionEnforcementConfig_ = builderForValue.build();
        } else {
          googleManagedEncryptionEnforcementConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If omitted, then new objects with GMEK encryption-type is
       * allowed. If set, then new objects created in this bucket must comply with
       * enforcement config. Changing this has no effect on existing objects; it
       * applies to new objects only.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig google_managed_encryption_enforcement_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeGoogleManagedEncryptionEnforcementConfig(
          com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig value) {
        if (googleManagedEncryptionEnforcementConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && googleManagedEncryptionEnforcementConfig_ != null
              && googleManagedEncryptionEnforcementConfig_
                  != com.google.storage.v2.Bucket.Encryption
                      .GoogleManagedEncryptionEnforcementConfig.getDefaultInstance()) {
            getGoogleManagedEncryptionEnforcementConfigBuilder().mergeFrom(value);
          } else {
            googleManagedEncryptionEnforcementConfig_ = value;
          }
        } else {
          googleManagedEncryptionEnforcementConfigBuilder_.mergeFrom(value);
        }
        if (googleManagedEncryptionEnforcementConfig_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If omitted, then new objects with GMEK encryption-type is
       * allowed. If set, then new objects created in this bucket must comply with
       * enforcement config. Changing this has no effect on existing objects; it
       * applies to new objects only.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig google_managed_encryption_enforcement_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearGoogleManagedEncryptionEnforcementConfig() {
        bitField0_ = (bitField0_ & ~0x00000002);
        googleManagedEncryptionEnforcementConfig_ = null;
        if (googleManagedEncryptionEnforcementConfigBuilder_ != null) {
          googleManagedEncryptionEnforcementConfigBuilder_.dispose();
          googleManagedEncryptionEnforcementConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If omitted, then new objects with GMEK encryption-type is
       * allowed. If set, then new objects created in this bucket must comply with
       * enforcement config. Changing this has no effect on existing objects; it
       * applies to new objects only.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig google_managed_encryption_enforcement_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
              .Builder
          getGoogleManagedEncryptionEnforcementConfigBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getGoogleManagedEncryptionEnforcementConfigFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. If omitted, then new objects with GMEK encryption-type is
       * allowed. If set, then new objects created in this bucket must comply with
       * enforcement config. Changing this has no effect on existing objects; it
       * applies to new objects only.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig google_managed_encryption_enforcement_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.storage.v2.Bucket.Encryption
              .GoogleManagedEncryptionEnforcementConfigOrBuilder
          getGoogleManagedEncryptionEnforcementConfigOrBuilder() {
        if (googleManagedEncryptionEnforcementConfigBuilder_ != null) {
          return googleManagedEncryptionEnforcementConfigBuilder_.getMessageOrBuilder();
        } else {
          return googleManagedEncryptionEnforcementConfig_ == null
              ? com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
                  .getDefaultInstance()
              : googleManagedEncryptionEnforcementConfig_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. If omitted, then new objects with GMEK encryption-type is
       * allowed. If set, then new objects created in this bucket must comply with
       * enforcement config. Changing this has no effect on existing objects; it
       * applies to new objects only.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig google_managed_encryption_enforcement_config = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig,
              com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
                  .Builder,
              com.google.storage.v2.Bucket.Encryption
                  .GoogleManagedEncryptionEnforcementConfigOrBuilder>
          getGoogleManagedEncryptionEnforcementConfigFieldBuilder() {
        if (googleManagedEncryptionEnforcementConfigBuilder_ == null) {
          googleManagedEncryptionEnforcementConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig,
                  com.google.storage.v2.Bucket.Encryption.GoogleManagedEncryptionEnforcementConfig
                      .Builder,
                  com.google.storage.v2.Bucket.Encryption
                      .GoogleManagedEncryptionEnforcementConfigOrBuilder>(
                  getGoogleManagedEncryptionEnforcementConfig(), getParentForChildren(), isClean());
          googleManagedEncryptionEnforcementConfig_ = null;
        }
        return googleManagedEncryptionEnforcementConfigBuilder_;
      }

      private com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
          customerManagedEncryptionEnforcementConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig,
              com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
                  .Builder,
              com.google.storage.v2.Bucket.Encryption
                  .CustomerManagedEncryptionEnforcementConfigOrBuilder>
          customerManagedEncryptionEnforcementConfigBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. If omitted, then new objects with CMEK encryption-type is
       * allowed. If set, then new objects created in this bucket must comply with
       * enforcement config. Changing this has no effect on existing objects; it
       * applies to new objects only.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig customer_managed_encryption_enforcement_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the customerManagedEncryptionEnforcementConfig field is set.
       */
      public boolean hasCustomerManagedEncryptionEnforcementConfig() {
        return ((bitField0_ & 0x00000004) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. If omitted, then new objects with CMEK encryption-type is
       * allowed. If set, then new objects created in this bucket must comply with
       * enforcement config. Changing this has no effect on existing objects; it
       * applies to new objects only.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig customer_managed_encryption_enforcement_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The customerManagedEncryptionEnforcementConfig.
       */
      public com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
          getCustomerManagedEncryptionEnforcementConfig() {
        if (customerManagedEncryptionEnforcementConfigBuilder_ == null) {
          return customerManagedEncryptionEnforcementConfig_ == null
              ? com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
                  .getDefaultInstance()
              : customerManagedEncryptionEnforcementConfig_;
        } else {
          return customerManagedEncryptionEnforcementConfigBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. If omitted, then new objects with CMEK encryption-type is
       * allowed. If set, then new objects created in this bucket must comply with
       * enforcement config. Changing this has no effect on existing objects; it
       * applies to new objects only.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig customer_managed_encryption_enforcement_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setCustomerManagedEncryptionEnforcementConfig(
          com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
              value) {
        if (customerManagedEncryptionEnforcementConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          customerManagedEncryptionEnforcementConfig_ = value;
        } else {
          customerManagedEncryptionEnforcementConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If omitted, then new objects with CMEK encryption-type is
       * allowed. If set, then new objects created in this bucket must comply with
       * enforcement config. Changing this has no effect on existing objects; it
       * applies to new objects only.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig customer_managed_encryption_enforcement_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setCustomerManagedEncryptionEnforcementConfig(
          com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig.Builder
              builderForValue) {
        if (customerManagedEncryptionEnforcementConfigBuilder_ == null) {
          customerManagedEncryptionEnforcementConfig_ = builderForValue.build();
        } else {
          customerManagedEncryptionEnforcementConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If omitted, then new objects with CMEK encryption-type is
       * allowed. If set, then new objects created in this bucket must comply with
       * enforcement config. Changing this has no effect on existing objects; it
       * applies to new objects only.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig customer_managed_encryption_enforcement_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeCustomerManagedEncryptionEnforcementConfig(
          com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
              value) {
        if (customerManagedEncryptionEnforcementConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && customerManagedEncryptionEnforcementConfig_ != null
              && customerManagedEncryptionEnforcementConfig_
                  != com.google.storage.v2.Bucket.Encryption
                      .CustomerManagedEncryptionEnforcementConfig.getDefaultInstance()) {
            getCustomerManagedEncryptionEnforcementConfigBuilder().mergeFrom(value);
          } else {
            customerManagedEncryptionEnforcementConfig_ = value;
          }
        } else {
          customerManagedEncryptionEnforcementConfigBuilder_.mergeFrom(value);
        }
        if (customerManagedEncryptionEnforcementConfig_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If omitted, then new objects with CMEK encryption-type is
       * allowed. If set, then new objects created in this bucket must comply with
       * enforcement config. Changing this has no effect on existing objects; it
       * applies to new objects only.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig customer_managed_encryption_enforcement_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearCustomerManagedEncryptionEnforcementConfig() {
        bitField0_ = (bitField0_ & ~0x00000004);
        customerManagedEncryptionEnforcementConfig_ = null;
        if (customerManagedEncryptionEnforcementConfigBuilder_ != null) {
          customerManagedEncryptionEnforcementConfigBuilder_.dispose();
          customerManagedEncryptionEnforcementConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If omitted, then new objects with CMEK encryption-type is
       * allowed. If set, then new objects created in this bucket must comply with
       * enforcement config. Changing this has no effect on existing objects; it
       * applies to new objects only.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig customer_managed_encryption_enforcement_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
              .Builder
          getCustomerManagedEncryptionEnforcementConfigBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getCustomerManagedEncryptionEnforcementConfigFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. If omitted, then new objects with CMEK encryption-type is
       * allowed. If set, then new objects created in this bucket must comply with
       * enforcement config. Changing this has no effect on existing objects; it
       * applies to new objects only.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig customer_managed_encryption_enforcement_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.storage.v2.Bucket.Encryption
              .CustomerManagedEncryptionEnforcementConfigOrBuilder
          getCustomerManagedEncryptionEnforcementConfigOrBuilder() {
        if (customerManagedEncryptionEnforcementConfigBuilder_ != null) {
          return customerManagedEncryptionEnforcementConfigBuilder_.getMessageOrBuilder();
        } else {
          return customerManagedEncryptionEnforcementConfig_ == null
              ? com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
                  .getDefaultInstance()
              : customerManagedEncryptionEnforcementConfig_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. If omitted, then new objects with CMEK encryption-type is
       * allowed. If set, then new objects created in this bucket must comply with
       * enforcement config. Changing this has no effect on existing objects; it
       * applies to new objects only.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig customer_managed_encryption_enforcement_config = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig,
              com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
                  .Builder,
              com.google.storage.v2.Bucket.Encryption
                  .CustomerManagedEncryptionEnforcementConfigOrBuilder>
          getCustomerManagedEncryptionEnforcementConfigFieldBuilder() {
        if (customerManagedEncryptionEnforcementConfigBuilder_ == null) {
          customerManagedEncryptionEnforcementConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storage.v2.Bucket.Encryption
                      .CustomerManagedEncryptionEnforcementConfig,
                  com.google.storage.v2.Bucket.Encryption.CustomerManagedEncryptionEnforcementConfig
                      .Builder,
                  com.google.storage.v2.Bucket.Encryption
                      .CustomerManagedEncryptionEnforcementConfigOrBuilder>(
                  getCustomerManagedEncryptionEnforcementConfig(),
                  getParentForChildren(),
                  isClean());
          customerManagedEncryptionEnforcementConfig_ = null;
        }
        return customerManagedEncryptionEnforcementConfigBuilder_;
      }

      private com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig
          customerSuppliedEncryptionEnforcementConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig,
              com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig
                  .Builder,
              com.google.storage.v2.Bucket.Encryption
                  .CustomerSuppliedEncryptionEnforcementConfigOrBuilder>
          customerSuppliedEncryptionEnforcementConfigBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. If omitted, then new objects with CSEK encryption-type is
       * allowed. If set, then new objects created in this bucket must comply with
       * enforcement config. Changing this has no effect on existing objects; it
       * applies to new objects only.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig customer_supplied_encryption_enforcement_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the customerSuppliedEncryptionEnforcementConfig field is set.
       */
      public boolean hasCustomerSuppliedEncryptionEnforcementConfig() {
        return ((bitField0_ & 0x00000008) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. If omitted, then new objects with CSEK encryption-type is
       * allowed. If set, then new objects created in this bucket must comply with
       * enforcement config. Changing this has no effect on existing objects; it
       * applies to new objects only.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig customer_supplied_encryption_enforcement_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The customerSuppliedEncryptionEnforcementConfig.
       */
      public com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig
          getCustomerSuppliedEncryptionEnforcementConfig() {
        if (customerSuppliedEncryptionEnforcementConfigBuilder_ == null) {
          return customerSuppliedEncryptionEnforcementConfig_ == null
              ? com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig
                  .getDefaultInstance()
              : customerSuppliedEncryptionEnforcementConfig_;
        } else {
          return customerSuppliedEncryptionEnforcementConfigBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. If omitted, then new objects with CSEK encryption-type is
       * allowed. If set, then new objects created in this bucket must comply with
       * enforcement config. Changing this has no effect on existing objects; it
       * applies to new objects only.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig customer_supplied_encryption_enforcement_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setCustomerSuppliedEncryptionEnforcementConfig(
          com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig
              value) {
        if (customerSuppliedEncryptionEnforcementConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          customerSuppliedEncryptionEnforcementConfig_ = value;
        } else {
          customerSuppliedEncryptionEnforcementConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If omitted, then new objects with CSEK encryption-type is
       * allowed. If set, then new objects created in this bucket must comply with
       * enforcement config. Changing this has no effect on existing objects; it
       * applies to new objects only.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig customer_supplied_encryption_enforcement_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setCustomerSuppliedEncryptionEnforcementConfig(
          com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig
                  .Builder
              builderForValue) {
        if (customerSuppliedEncryptionEnforcementConfigBuilder_ == null) {
          customerSuppliedEncryptionEnforcementConfig_ = builderForValue.build();
        } else {
          customerSuppliedEncryptionEnforcementConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If omitted, then new objects with CSEK encryption-type is
       * allowed. If set, then new objects created in this bucket must comply with
       * enforcement config. Changing this has no effect on existing objects; it
       * applies to new objects only.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig customer_supplied_encryption_enforcement_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeCustomerSuppliedEncryptionEnforcementConfig(
          com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig
              value) {
        if (customerSuppliedEncryptionEnforcementConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && customerSuppliedEncryptionEnforcementConfig_ != null
              && customerSuppliedEncryptionEnforcementConfig_
                  != com.google.storage.v2.Bucket.Encryption
                      .CustomerSuppliedEncryptionEnforcementConfig.getDefaultInstance()) {
            getCustomerSuppliedEncryptionEnforcementConfigBuilder().mergeFrom(value);
          } else {
            customerSuppliedEncryptionEnforcementConfig_ = value;
          }
        } else {
          customerSuppliedEncryptionEnforcementConfigBuilder_.mergeFrom(value);
        }
        if (customerSuppliedEncryptionEnforcementConfig_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If omitted, then new objects with CSEK encryption-type is
       * allowed. If set, then new objects created in this bucket must comply with
       * enforcement config. Changing this has no effect on existing objects; it
       * applies to new objects only.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig customer_supplied_encryption_enforcement_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearCustomerSuppliedEncryptionEnforcementConfig() {
        bitField0_ = (bitField0_ & ~0x00000008);
        customerSuppliedEncryptionEnforcementConfig_ = null;
        if (customerSuppliedEncryptionEnforcementConfigBuilder_ != null) {
          customerSuppliedEncryptionEnforcementConfigBuilder_.dispose();
          customerSuppliedEncryptionEnforcementConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If omitted, then new objects with CSEK encryption-type is
       * allowed. If set, then new objects created in this bucket must comply with
       * enforcement config. Changing this has no effect on existing objects; it
       * applies to new objects only.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig customer_supplied_encryption_enforcement_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig
              .Builder
          getCustomerSuppliedEncryptionEnforcementConfigBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getCustomerSuppliedEncryptionEnforcementConfigFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. If omitted, then new objects with CSEK encryption-type is
       * allowed. If set, then new objects created in this bucket must comply with
       * enforcement config. Changing this has no effect on existing objects; it
       * applies to new objects only.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig customer_supplied_encryption_enforcement_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.storage.v2.Bucket.Encryption
              .CustomerSuppliedEncryptionEnforcementConfigOrBuilder
          getCustomerSuppliedEncryptionEnforcementConfigOrBuilder() {
        if (customerSuppliedEncryptionEnforcementConfigBuilder_ != null) {
          return customerSuppliedEncryptionEnforcementConfigBuilder_.getMessageOrBuilder();
        } else {
          return customerSuppliedEncryptionEnforcementConfig_ == null
              ? com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig
                  .getDefaultInstance()
              : customerSuppliedEncryptionEnforcementConfig_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. If omitted, then new objects with CSEK encryption-type is
       * allowed. If set, then new objects created in this bucket must comply with
       * enforcement config. Changing this has no effect on existing objects; it
       * applies to new objects only.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig customer_supplied_encryption_enforcement_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig,
              com.google.storage.v2.Bucket.Encryption.CustomerSuppliedEncryptionEnforcementConfig
                  .Builder,
              com.google.storage.v2.Bucket.Encryption
                  .CustomerSuppliedEncryptionEnforcementConfigOrBuilder>
          getCustomerSuppliedEncryptionEnforcementConfigFieldBuilder() {
        if (customerSuppliedEncryptionEnforcementConfigBuilder_ == null) {
          customerSuppliedEncryptionEnforcementConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storage.v2.Bucket.Encryption
                      .CustomerSuppliedEncryptionEnforcementConfig,
                  com.google.storage.v2.Bucket.Encryption
                      .CustomerSuppliedEncryptionEnforcementConfig.Builder,
                  com.google.storage.v2.Bucket.Encryption
                      .CustomerSuppliedEncryptionEnforcementConfigOrBuilder>(
                  getCustomerSuppliedEncryptionEnforcementConfig(),
                  getParentForChildren(),
                  isClean());
          customerSuppliedEncryptionEnforcementConfig_ = null;
        }
        return customerSuppliedEncryptionEnforcementConfigBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Encryption)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Encryption)
    private static final com.google.storage.v2.Bucket.Encryption DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Encryption();
    }

    public static com.google.storage.v2.Bucket.Encryption getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Encryption> PARSER =
        new com.google.protobuf.AbstractParser<Encryption>() {
          @java.lang.Override
          public Encryption parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Encryption> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Encryption> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.Encryption getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface IamConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.IamConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Bucket restriction options currently enforced on the bucket.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the uniformBucketLevelAccess field is set.
     */
    boolean hasUniformBucketLevelAccess();

    /**
     *
     *
     * <pre>
     * Optional. Bucket restriction options currently enforced on the bucket.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The uniformBucketLevelAccess.
     */
    com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess getUniformBucketLevelAccess();

    /**
     *
     *
     * <pre>
     * Optional. Bucket restriction options currently enforced on the bucket.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccessOrBuilder
        getUniformBucketLevelAccessOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Whether IAM will enforce public access prevention. Valid values
     * are "enforced" or "inherited".
     * </pre>
     *
     * <code>string public_access_prevention = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The publicAccessPrevention.
     */
    java.lang.String getPublicAccessPrevention();

    /**
     *
     *
     * <pre>
     * Optional. Whether IAM will enforce public access prevention. Valid values
     * are "enforced" or "inherited".
     * </pre>
     *
     * <code>string public_access_prevention = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for publicAccessPrevention.
     */
    com.google.protobuf.ByteString getPublicAccessPreventionBytes();
  }

  /**
   *
   *
   * <pre>
   * Bucket restriction options.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.IamConfig}
   */
  public static final class IamConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.IamConfig)
      IamConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use IamConfig.newBuilder() to construct.
    private IamConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IamConfig() {
      publicAccessPrevention_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new IamConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_IamConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_IamConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.IamConfig.class,
              com.google.storage.v2.Bucket.IamConfig.Builder.class);
    }

    public interface UniformBucketLevelAccessOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. If set, access checks only use bucket-level IAM policies or
       * above.
       * </pre>
       *
       * <code>bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The enabled.
       */
      boolean getEnabled();

      /**
       *
       *
       * <pre>
       * Optional. The deadline time for changing
       * `iam_config.uniform_bucket_level_access.enabled` from `true` to
       * `false`. Mutable until the specified deadline is reached, but not
       * afterward.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp lock_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the lockTime field is set.
       */
      boolean hasLockTime();

      /**
       *
       *
       * <pre>
       * Optional. The deadline time for changing
       * `iam_config.uniform_bucket_level_access.enabled` from `true` to
       * `false`. Mutable until the specified deadline is reached, but not
       * afterward.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp lock_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The lockTime.
       */
      com.google.protobuf.Timestamp getLockTime();

      /**
       *
       *
       * <pre>
       * Optional. The deadline time for changing
       * `iam_config.uniform_bucket_level_access.enabled` from `true` to
       * `false`. Mutable until the specified deadline is reached, but not
       * afterward.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp lock_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.protobuf.TimestampOrBuilder getLockTimeOrBuilder();
    }

    /**
     *
     *
     * <pre>
     * Settings for Uniform Bucket level access.
     * See https://cloud.google.com/storage/docs/uniform-bucket-level-access.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess}
     */
    public static final class UniformBucketLevelAccess
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess)
        UniformBucketLevelAccessOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use UniformBucketLevelAccess.newBuilder() to construct.
      private UniformBucketLevelAccess(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private UniformBucketLevelAccess() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new UniformBucketLevelAccess();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_IamConfig_UniformBucketLevelAccess_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_IamConfig_UniformBucketLevelAccess_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.class,
                com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.Builder.class);
      }

      private int bitField0_;
      public static final int ENABLED_FIELD_NUMBER = 1;
      private boolean enabled_ = false;

      /**
       *
       *
       * <pre>
       * Optional. If set, access checks only use bucket-level IAM policies or
       * above.
       * </pre>
       *
       * <code>bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The enabled.
       */
      @java.lang.Override
      public boolean getEnabled() {
        return enabled_;
      }

      public static final int LOCK_TIME_FIELD_NUMBER = 2;
      private com.google.protobuf.Timestamp lockTime_;

      /**
       *
       *
       * <pre>
       * Optional. The deadline time for changing
       * `iam_config.uniform_bucket_level_access.enabled` from `true` to
       * `false`. Mutable until the specified deadline is reached, but not
       * afterward.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp lock_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the lockTime field is set.
       */
      @java.lang.Override
      public boolean hasLockTime() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. The deadline time for changing
       * `iam_config.uniform_bucket_level_access.enabled` from `true` to
       * `false`. Mutable until the specified deadline is reached, but not
       * afterward.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp lock_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The lockTime.
       */
      @java.lang.Override
      public com.google.protobuf.Timestamp getLockTime() {
        return lockTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : lockTime_;
      }

      /**
       *
       *
       * <pre>
       * Optional. The deadline time for changing
       * `iam_config.uniform_bucket_level_access.enabled` from `true` to
       * `false`. Mutable until the specified deadline is reached, but not
       * afterward.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp lock_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.protobuf.TimestampOrBuilder getLockTimeOrBuilder() {
        return lockTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : lockTime_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (enabled_ != false) {
          output.writeBool(1, enabled_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(2, getLockTime());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (enabled_ != false) {
          size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enabled_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getLockTime());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess)) {
          return super.equals(obj);
        }
        com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess other =
            (com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess) obj;

        if (getEnabled() != other.getEnabled()) return false;
        if (hasLockTime() != other.hasLockTime()) return false;
        if (hasLockTime()) {
          if (!getLockTime().equals(other.getLockTime())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + ENABLED_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnabled());
        if (hasLockTime()) {
          hash = (37 * hash) + LOCK_TIME_FIELD_NUMBER;
          hash = (53 * hash) + getLockTime().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Settings for Uniform Bucket level access.
       * See https://cloud.google.com/storage/docs/uniform-bucket-level-access.
       * </pre>
       *
       * Protobuf type {@code google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess)
          com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccessOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_IamConfig_UniformBucketLevelAccess_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_IamConfig_UniformBucketLevelAccess_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.class,
                  com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.Builder.class);
        }

        // Construct using
        // com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getLockTimeFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          enabled_ = false;
          lockTime_ = null;
          if (lockTimeBuilder_ != null) {
            lockTimeBuilder_.dispose();
            lockTimeBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_IamConfig_UniformBucketLevelAccess_descriptor;
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
            getDefaultInstanceForType() {
          return com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess build() {
          com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess buildPartial() {
          com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess result =
              new com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.enabled_ = enabled_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.lockTime_ = lockTimeBuilder_ == null ? lockTime_ : lockTimeBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess) {
            return mergeFrom(
                (com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess other) {
          if (other
              == com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
                  .getDefaultInstance()) return this;
          if (other.getEnabled() != false) {
            setEnabled(other.getEnabled());
          }
          if (other.hasLockTime()) {
            mergeLockTime(other.getLockTime());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    enabled_ = input.readBool();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 18:
                  {
                    input.readMessage(getLockTimeFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private boolean enabled_;

        /**
         *
         *
         * <pre>
         * Optional. If set, access checks only use bucket-level IAM policies or
         * above.
         * </pre>
         *
         * <code>bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The enabled.
         */
        @java.lang.Override
        public boolean getEnabled() {
          return enabled_;
        }

        /**
         *
         *
         * <pre>
         * Optional. If set, access checks only use bucket-level IAM policies or
         * above.
         * </pre>
         *
         * <code>bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The enabled to set.
         * @return This builder for chaining.
         */
        public Builder setEnabled(boolean value) {

          enabled_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. If set, access checks only use bucket-level IAM policies or
         * above.
         * </pre>
         *
         * <code>bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearEnabled() {
          bitField0_ = (bitField0_ & ~0x00000001);
          enabled_ = false;
          onChanged();
          return this;
        }

        private com.google.protobuf.Timestamp lockTime_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>
            lockTimeBuilder_;

        /**
         *
         *
         * <pre>
         * Optional. The deadline time for changing
         * `iam_config.uniform_bucket_level_access.enabled` from `true` to
         * `false`. Mutable until the specified deadline is reached, but not
         * afterward.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp lock_time = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the lockTime field is set.
         */
        public boolean hasLockTime() {
          return ((bitField0_ & 0x00000002) != 0);
        }

        /**
         *
         *
         * <pre>
         * Optional. The deadline time for changing
         * `iam_config.uniform_bucket_level_access.enabled` from `true` to
         * `false`. Mutable until the specified deadline is reached, but not
         * afterward.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp lock_time = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The lockTime.
         */
        public com.google.protobuf.Timestamp getLockTime() {
          if (lockTimeBuilder_ == null) {
            return lockTime_ == null
                ? com.google.protobuf.Timestamp.getDefaultInstance()
                : lockTime_;
          } else {
            return lockTimeBuilder_.getMessage();
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The deadline time for changing
         * `iam_config.uniform_bucket_level_access.enabled` from `true` to
         * `false`. Mutable until the specified deadline is reached, but not
         * afterward.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp lock_time = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setLockTime(com.google.protobuf.Timestamp value) {
          if (lockTimeBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            lockTime_ = value;
          } else {
            lockTimeBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The deadline time for changing
         * `iam_config.uniform_bucket_level_access.enabled` from `true` to
         * `false`. Mutable until the specified deadline is reached, but not
         * afterward.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp lock_time = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setLockTime(com.google.protobuf.Timestamp.Builder builderForValue) {
          if (lockTimeBuilder_ == null) {
            lockTime_ = builderForValue.build();
          } else {
            lockTimeBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The deadline time for changing
         * `iam_config.uniform_bucket_level_access.enabled` from `true` to
         * `false`. Mutable until the specified deadline is reached, but not
         * afterward.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp lock_time = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder mergeLockTime(com.google.protobuf.Timestamp value) {
          if (lockTimeBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && lockTime_ != null
                && lockTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
              getLockTimeBuilder().mergeFrom(value);
            } else {
              lockTime_ = value;
            }
          } else {
            lockTimeBuilder_.mergeFrom(value);
          }
          if (lockTime_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The deadline time for changing
         * `iam_config.uniform_bucket_level_access.enabled` from `true` to
         * `false`. Mutable until the specified deadline is reached, but not
         * afterward.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp lock_time = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearLockTime() {
          bitField0_ = (bitField0_ & ~0x00000002);
          lockTime_ = null;
          if (lockTimeBuilder_ != null) {
            lockTimeBuilder_.dispose();
            lockTimeBuilder_ = null;
          }
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The deadline time for changing
         * `iam_config.uniform_bucket_level_access.enabled` from `true` to
         * `false`. Mutable until the specified deadline is reached, but not
         * afterward.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp lock_time = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.protobuf.Timestamp.Builder getLockTimeBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getLockTimeFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Optional. The deadline time for changing
         * `iam_config.uniform_bucket_level_access.enabled` from `true` to
         * `false`. Mutable until the specified deadline is reached, but not
         * afterward.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp lock_time = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.protobuf.TimestampOrBuilder getLockTimeOrBuilder() {
          if (lockTimeBuilder_ != null) {
            return lockTimeBuilder_.getMessageOrBuilder();
          } else {
            return lockTime_ == null
                ? com.google.protobuf.Timestamp.getDefaultInstance()
                : lockTime_;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The deadline time for changing
         * `iam_config.uniform_bucket_level_access.enabled` from `true` to
         * `false`. Mutable until the specified deadline is reached, but not
         * afterward.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp lock_time = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>
            getLockTimeFieldBuilder() {
          if (lockTimeBuilder_ == null) {
            lockTimeBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Timestamp,
                    com.google.protobuf.Timestamp.Builder,
                    com.google.protobuf.TimestampOrBuilder>(
                    getLockTime(), getParentForChildren(), isClean());
            lockTime_ = null;
          }
          return lockTimeBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess)
      }

      // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess)
      private static final com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess();
      }

      public static com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<UniformBucketLevelAccess> PARSER =
          new com.google.protobuf.AbstractParser<UniformBucketLevelAccess>() {
            @java.lang.Override
            public UniformBucketLevelAccess parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<UniformBucketLevelAccess> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<UniformBucketLevelAccess> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int UNIFORM_BUCKET_LEVEL_ACCESS_FIELD_NUMBER = 1;
    private com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
        uniformBucketLevelAccess_;

    /**
     *
     *
     * <pre>
     * Optional. Bucket restriction options currently enforced on the bucket.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the uniformBucketLevelAccess field is set.
     */
    @java.lang.Override
    public boolean hasUniformBucketLevelAccess() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Bucket restriction options currently enforced on the bucket.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The uniformBucketLevelAccess.
     */
    @java.lang.Override
    public com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
        getUniformBucketLevelAccess() {
      return uniformBucketLevelAccess_ == null
          ? com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.getDefaultInstance()
          : uniformBucketLevelAccess_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Bucket restriction options currently enforced on the bucket.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccessOrBuilder
        getUniformBucketLevelAccessOrBuilder() {
      return uniformBucketLevelAccess_ == null
          ? com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.getDefaultInstance()
          : uniformBucketLevelAccess_;
    }

    public static final int PUBLIC_ACCESS_PREVENTION_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object publicAccessPrevention_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Whether IAM will enforce public access prevention. Valid values
     * are "enforced" or "inherited".
     * </pre>
     *
     * <code>string public_access_prevention = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The publicAccessPrevention.
     */
    @java.lang.Override
    public java.lang.String getPublicAccessPrevention() {
      java.lang.Object ref = publicAccessPrevention_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        publicAccessPrevention_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Whether IAM will enforce public access prevention. Valid values
     * are "enforced" or "inherited".
     * </pre>
     *
     * <code>string public_access_prevention = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for publicAccessPrevention.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPublicAccessPreventionBytes() {
      java.lang.Object ref = publicAccessPrevention_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        publicAccessPrevention_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getUniformBucketLevelAccess());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(publicAccessPrevention_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, publicAccessPrevention_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, getUniformBucketLevelAccess());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(publicAccessPrevention_)) {
        size +=
            com.google.protobuf.GeneratedMessageV3.computeStringSize(3, publicAccessPrevention_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.IamConfig)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.IamConfig other = (com.google.storage.v2.Bucket.IamConfig) obj;

      if (hasUniformBucketLevelAccess() != other.hasUniformBucketLevelAccess()) return false;
      if (hasUniformBucketLevelAccess()) {
        if (!getUniformBucketLevelAccess().equals(other.getUniformBucketLevelAccess()))
          return false;
      }
      if (!getPublicAccessPrevention().equals(other.getPublicAccessPrevention())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasUniformBucketLevelAccess()) {
        hash = (37 * hash) + UNIFORM_BUCKET_LEVEL_ACCESS_FIELD_NUMBER;
        hash = (53 * hash) + getUniformBucketLevelAccess().hashCode();
      }
      hash = (37 * hash) + PUBLIC_ACCESS_PREVENTION_FIELD_NUMBER;
      hash = (53 * hash) + getPublicAccessPrevention().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.IamConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.IamConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Bucket restriction options.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.IamConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.IamConfig)
        com.google.storage.v2.Bucket.IamConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_IamConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_IamConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.IamConfig.class,
                com.google.storage.v2.Bucket.IamConfig.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.IamConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getUniformBucketLevelAccessFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        uniformBucketLevelAccess_ = null;
        if (uniformBucketLevelAccessBuilder_ != null) {
          uniformBucketLevelAccessBuilder_.dispose();
          uniformBucketLevelAccessBuilder_ = null;
        }
        publicAccessPrevention_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_IamConfig_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.IamConfig getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.IamConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.IamConfig build() {
        com.google.storage.v2.Bucket.IamConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.IamConfig buildPartial() {
        com.google.storage.v2.Bucket.IamConfig result =
            new com.google.storage.v2.Bucket.IamConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.storage.v2.Bucket.IamConfig result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.uniformBucketLevelAccess_ =
              uniformBucketLevelAccessBuilder_ == null
                  ? uniformBucketLevelAccess_
                  : uniformBucketLevelAccessBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.publicAccessPrevention_ = publicAccessPrevention_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.IamConfig) {
          return mergeFrom((com.google.storage.v2.Bucket.IamConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.IamConfig other) {
        if (other == com.google.storage.v2.Bucket.IamConfig.getDefaultInstance()) return this;
        if (other.hasUniformBucketLevelAccess()) {
          mergeUniformBucketLevelAccess(other.getUniformBucketLevelAccess());
        }
        if (!other.getPublicAccessPrevention().isEmpty()) {
          publicAccessPrevention_ = other.publicAccessPrevention_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getUniformBucketLevelAccessFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 26:
                {
                  publicAccessPrevention_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
          uniformBucketLevelAccess_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess,
              com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.Builder,
              com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccessOrBuilder>
          uniformBucketLevelAccessBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Bucket restriction options currently enforced on the bucket.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the uniformBucketLevelAccess field is set.
       */
      public boolean hasUniformBucketLevelAccess() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. Bucket restriction options currently enforced on the bucket.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The uniformBucketLevelAccess.
       */
      public com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
          getUniformBucketLevelAccess() {
        if (uniformBucketLevelAccessBuilder_ == null) {
          return uniformBucketLevelAccess_ == null
              ? com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.getDefaultInstance()
              : uniformBucketLevelAccess_;
        } else {
          return uniformBucketLevelAccessBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Bucket restriction options currently enforced on the bucket.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setUniformBucketLevelAccess(
          com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess value) {
        if (uniformBucketLevelAccessBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          uniformBucketLevelAccess_ = value;
        } else {
          uniformBucketLevelAccessBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Bucket restriction options currently enforced on the bucket.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setUniformBucketLevelAccess(
          com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.Builder builderForValue) {
        if (uniformBucketLevelAccessBuilder_ == null) {
          uniformBucketLevelAccess_ = builderForValue.build();
        } else {
          uniformBucketLevelAccessBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Bucket restriction options currently enforced on the bucket.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeUniformBucketLevelAccess(
          com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess value) {
        if (uniformBucketLevelAccessBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && uniformBucketLevelAccess_ != null
              && uniformBucketLevelAccess_
                  != com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess
                      .getDefaultInstance()) {
            getUniformBucketLevelAccessBuilder().mergeFrom(value);
          } else {
            uniformBucketLevelAccess_ = value;
          }
        } else {
          uniformBucketLevelAccessBuilder_.mergeFrom(value);
        }
        if (uniformBucketLevelAccess_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Bucket restriction options currently enforced on the bucket.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearUniformBucketLevelAccess() {
        bitField0_ = (bitField0_ & ~0x00000001);
        uniformBucketLevelAccess_ = null;
        if (uniformBucketLevelAccessBuilder_ != null) {
          uniformBucketLevelAccessBuilder_.dispose();
          uniformBucketLevelAccessBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Bucket restriction options currently enforced on the bucket.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.Builder
          getUniformBucketLevelAccessBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getUniformBucketLevelAccessFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. Bucket restriction options currently enforced on the bucket.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccessOrBuilder
          getUniformBucketLevelAccessOrBuilder() {
        if (uniformBucketLevelAccessBuilder_ != null) {
          return uniformBucketLevelAccessBuilder_.getMessageOrBuilder();
        } else {
          return uniformBucketLevelAccess_ == null
              ? com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.getDefaultInstance()
              : uniformBucketLevelAccess_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Bucket restriction options currently enforced on the bucket.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess uniform_bucket_level_access = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess,
              com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.Builder,
              com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccessOrBuilder>
          getUniformBucketLevelAccessFieldBuilder() {
        if (uniformBucketLevelAccessBuilder_ == null) {
          uniformBucketLevelAccessBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess,
                  com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccess.Builder,
                  com.google.storage.v2.Bucket.IamConfig.UniformBucketLevelAccessOrBuilder>(
                  getUniformBucketLevelAccess(), getParentForChildren(), isClean());
          uniformBucketLevelAccess_ = null;
        }
        return uniformBucketLevelAccessBuilder_;
      }

      private java.lang.Object publicAccessPrevention_ = "";

      /**
       *
       *
       * <pre>
       * Optional. Whether IAM will enforce public access prevention. Valid values
       * are "enforced" or "inherited".
       * </pre>
       *
       * <code>string public_access_prevention = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The publicAccessPrevention.
       */
      public java.lang.String getPublicAccessPrevention() {
        java.lang.Object ref = publicAccessPrevention_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          publicAccessPrevention_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Whether IAM will enforce public access prevention. Valid values
       * are "enforced" or "inherited".
       * </pre>
       *
       * <code>string public_access_prevention = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for publicAccessPrevention.
       */
      public com.google.protobuf.ByteString getPublicAccessPreventionBytes() {
        java.lang.Object ref = publicAccessPrevention_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          publicAccessPrevention_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Whether IAM will enforce public access prevention. Valid values
       * are "enforced" or "inherited".
       * </pre>
       *
       * <code>string public_access_prevention = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The publicAccessPrevention to set.
       * @return This builder for chaining.
       */
      public Builder setPublicAccessPrevention(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        publicAccessPrevention_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Whether IAM will enforce public access prevention. Valid values
       * are "enforced" or "inherited".
       * </pre>
       *
       * <code>string public_access_prevention = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPublicAccessPrevention() {
        publicAccessPrevention_ = getDefaultInstance().getPublicAccessPrevention();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Whether IAM will enforce public access prevention. Valid values
       * are "enforced" or "inherited".
       * </pre>
       *
       * <code>string public_access_prevention = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for publicAccessPrevention to set.
       * @return This builder for chaining.
       */
      public Builder setPublicAccessPreventionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        publicAccessPrevention_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.IamConfig)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.IamConfig)
    private static final com.google.storage.v2.Bucket.IamConfig DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.IamConfig();
    }

    public static com.google.storage.v2.Bucket.IamConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<IamConfig> PARSER =
        new com.google.protobuf.AbstractParser<IamConfig>() {
          @java.lang.Override
          public IamConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<IamConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IamConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.IamConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface LifecycleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Lifecycle)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. A lifecycle management rule, which is made of an action to take
     * and the condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<com.google.storage.v2.Bucket.Lifecycle.Rule> getRuleList();

    /**
     *
     *
     * <pre>
     * Optional. A lifecycle management rule, which is made of an action to take
     * and the condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.storage.v2.Bucket.Lifecycle.Rule getRule(int index);

    /**
     *
     *
     * <pre>
     * Optional. A lifecycle management rule, which is made of an action to take
     * and the condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getRuleCount();

    /**
     *
     *
     * <pre>
     * Optional. A lifecycle management rule, which is made of an action to take
     * and the condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<? extends com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder>
        getRuleOrBuilderList();

    /**
     *
     *
     * <pre>
     * Optional. A lifecycle management rule, which is made of an action to take
     * and the condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder getRuleOrBuilder(int index);
  }

  /**
   *
   *
   * <pre>
   * Lifecycle properties of a bucket.
   * For more information, see https://cloud.google.com/storage/docs/lifecycle.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.Lifecycle}
   */
  public static final class Lifecycle extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Lifecycle)
      LifecycleOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Lifecycle.newBuilder() to construct.
    private Lifecycle(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Lifecycle() {
      rule_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Lifecycle();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Lifecycle_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Lifecycle_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.Lifecycle.class,
              com.google.storage.v2.Bucket.Lifecycle.Builder.class);
    }

    public interface RuleOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Lifecycle.Rule)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. The action to take.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the action field is set.
       */
      boolean hasAction();

      /**
       *
       *
       * <pre>
       * Optional. The action to take.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The action.
       */
      com.google.storage.v2.Bucket.Lifecycle.Rule.Action getAction();

      /**
       *
       *
       * <pre>
       * Optional. The action to take.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.storage.v2.Bucket.Lifecycle.Rule.ActionOrBuilder getActionOrBuilder();

      /**
       *
       *
       * <pre>
       * Optional. The condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the condition field is set.
       */
      boolean hasCondition();

      /**
       *
       *
       * <pre>
       * Optional. The condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The condition.
       */
      com.google.storage.v2.Bucket.Lifecycle.Rule.Condition getCondition();

      /**
       *
       *
       * <pre>
       * Optional. The condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.storage.v2.Bucket.Lifecycle.Rule.ConditionOrBuilder getConditionOrBuilder();
    }

    /**
     *
     *
     * <pre>
     * A lifecycle Rule, combining an action to take on an object and a
     * condition which will trigger that action.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.Lifecycle.Rule}
     */
    public static final class Rule extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Lifecycle.Rule)
        RuleOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use Rule.newBuilder() to construct.
      private Rule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Rule() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Rule();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.Lifecycle.Rule.class,
                com.google.storage.v2.Bucket.Lifecycle.Rule.Builder.class);
      }

      public interface ActionOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Lifecycle.Rule.Action)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Optional. Type of the action. Currently, only `Delete`,
         * `SetStorageClass`, and `AbortIncompleteMultipartUpload` are
         * supported.
         * </pre>
         *
         * <code>string type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The type.
         */
        java.lang.String getType();

        /**
         *
         *
         * <pre>
         * Optional. Type of the action. Currently, only `Delete`,
         * `SetStorageClass`, and `AbortIncompleteMultipartUpload` are
         * supported.
         * </pre>
         *
         * <code>string type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for type.
         */
        com.google.protobuf.ByteString getTypeBytes();

        /**
         *
         *
         * <pre>
         * Optional. Target storage class. Required iff the type of the action
         * is SetStorageClass.
         * </pre>
         *
         * <code>string storage_class = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The storageClass.
         */
        java.lang.String getStorageClass();

        /**
         *
         *
         * <pre>
         * Optional. Target storage class. Required iff the type of the action
         * is SetStorageClass.
         * </pre>
         *
         * <code>string storage_class = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for storageClass.
         */
        com.google.protobuf.ByteString getStorageClassBytes();
      }

      /**
       *
       *
       * <pre>
       * An action to take on an object.
       * </pre>
       *
       * Protobuf type {@code google.storage.v2.Bucket.Lifecycle.Rule.Action}
       */
      public static final class Action extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Lifecycle.Rule.Action)
          ActionOrBuilder {
        private static final long serialVersionUID = 0L;

        // Use Action.newBuilder() to construct.
        private Action(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private Action() {
          type_ = "";
          storageClass_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new Action();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Action_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Action_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.storage.v2.Bucket.Lifecycle.Rule.Action.class,
                  com.google.storage.v2.Bucket.Lifecycle.Rule.Action.Builder.class);
        }

        public static final int TYPE_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object type_ = "";

        /**
         *
         *
         * <pre>
         * Optional. Type of the action. Currently, only `Delete`,
         * `SetStorageClass`, and `AbortIncompleteMultipartUpload` are
         * supported.
         * </pre>
         *
         * <code>string type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The type.
         */
        @java.lang.Override
        public java.lang.String getType() {
          java.lang.Object ref = type_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            type_ = s;
            return s;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. Type of the action. Currently, only `Delete`,
         * `SetStorageClass`, and `AbortIncompleteMultipartUpload` are
         * supported.
         * </pre>
         *
         * <code>string type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for type.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getTypeBytes() {
          java.lang.Object ref = type_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            type_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int STORAGE_CLASS_FIELD_NUMBER = 2;

        @SuppressWarnings("serial")
        private volatile java.lang.Object storageClass_ = "";

        /**
         *
         *
         * <pre>
         * Optional. Target storage class. Required iff the type of the action
         * is SetStorageClass.
         * </pre>
         *
         * <code>string storage_class = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The storageClass.
         */
        @java.lang.Override
        public java.lang.String getStorageClass() {
          java.lang.Object ref = storageClass_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            storageClass_ = s;
            return s;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. Target storage class. Required iff the type of the action
         * is SetStorageClass.
         * </pre>
         *
         * <code>string storage_class = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for storageClass.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getStorageClassBytes() {
          java.lang.Object ref = storageClass_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            storageClass_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, type_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(storageClass_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, storageClass_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, type_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(storageClass_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, storageClass_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj instanceof com.google.storage.v2.Bucket.Lifecycle.Rule.Action)) {
            return super.equals(obj);
          }
          com.google.storage.v2.Bucket.Lifecycle.Rule.Action other =
              (com.google.storage.v2.Bucket.Lifecycle.Rule.Action) obj;

          if (!getType().equals(other.getType())) return false;
          if (!getStorageClass().equals(other.getStorageClass())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + TYPE_FIELD_NUMBER;
          hash = (53 * hash) + getType().hashCode();
          hash = (37 * hash) + STORAGE_CLASS_FIELD_NUMBER;
          hash = (53 * hash) + getStorageClass().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(byte[] data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseDelimitedFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.storage.v2.Bucket.Lifecycle.Rule.Action prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }

        /**
         *
         *
         * <pre>
         * An action to take on an object.
         * </pre>
         *
         * Protobuf type {@code google.storage.v2.Bucket.Lifecycle.Rule.Action}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Lifecycle.Rule.Action)
            com.google.storage.v2.Bucket.Lifecycle.Rule.ActionOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.storage.v2.StorageProto
                .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Action_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.storage.v2.StorageProto
                .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Action_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.storage.v2.Bucket.Lifecycle.Rule.Action.class,
                    com.google.storage.v2.Bucket.Lifecycle.Rule.Action.Builder.class);
          }

          // Construct using com.google.storage.v2.Bucket.Lifecycle.Rule.Action.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            type_ = "";
            storageClass_ = "";
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.storage.v2.StorageProto
                .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Action_descriptor;
          }

          @java.lang.Override
          public com.google.storage.v2.Bucket.Lifecycle.Rule.Action getDefaultInstanceForType() {
            return com.google.storage.v2.Bucket.Lifecycle.Rule.Action.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.storage.v2.Bucket.Lifecycle.Rule.Action build() {
            com.google.storage.v2.Bucket.Lifecycle.Rule.Action result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.storage.v2.Bucket.Lifecycle.Rule.Action buildPartial() {
            com.google.storage.v2.Bucket.Lifecycle.Rule.Action result =
                new com.google.storage.v2.Bucket.Lifecycle.Rule.Action(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(com.google.storage.v2.Bucket.Lifecycle.Rule.Action result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.type_ = type_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.storageClass_ = storageClass_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof com.google.storage.v2.Bucket.Lifecycle.Rule.Action) {
              return mergeFrom((com.google.storage.v2.Bucket.Lifecycle.Rule.Action) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(com.google.storage.v2.Bucket.Lifecycle.Rule.Action other) {
            if (other == com.google.storage.v2.Bucket.Lifecycle.Rule.Action.getDefaultInstance())
              return this;
            if (!other.getType().isEmpty()) {
              type_ = other.type_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            if (!other.getStorageClass().isEmpty()) {
              storageClass_ = other.storageClass_;
              bitField0_ |= 0x00000002;
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      type_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 18:
                    {
                      storageClass_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 18
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object type_ = "";

          /**
           *
           *
           * <pre>
           * Optional. Type of the action. Currently, only `Delete`,
           * `SetStorageClass`, and `AbortIncompleteMultipartUpload` are
           * supported.
           * </pre>
           *
           * <code>string type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return The type.
           */
          public java.lang.String getType() {
            java.lang.Object ref = type_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              type_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }

          /**
           *
           *
           * <pre>
           * Optional. Type of the action. Currently, only `Delete`,
           * `SetStorageClass`, and `AbortIncompleteMultipartUpload` are
           * supported.
           * </pre>
           *
           * <code>string type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return The bytes for type.
           */
          public com.google.protobuf.ByteString getTypeBytes() {
            java.lang.Object ref = type_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              type_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }

          /**
           *
           *
           * <pre>
           * Optional. Type of the action. Currently, only `Delete`,
           * `SetStorageClass`, and `AbortIncompleteMultipartUpload` are
           * supported.
           * </pre>
           *
           * <code>string type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param value The type to set.
           * @return This builder for chaining.
           */
          public Builder setType(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            type_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. Type of the action. Currently, only `Delete`,
           * `SetStorageClass`, and `AbortIncompleteMultipartUpload` are
           * supported.
           * </pre>
           *
           * <code>string type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearType() {
            type_ = getDefaultInstance().getType();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. Type of the action. Currently, only `Delete`,
           * `SetStorageClass`, and `AbortIncompleteMultipartUpload` are
           * supported.
           * </pre>
           *
           * <code>string type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param value The bytes for type to set.
           * @return This builder for chaining.
           */
          public Builder setTypeBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            type_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          private java.lang.Object storageClass_ = "";

          /**
           *
           *
           * <pre>
           * Optional. Target storage class. Required iff the type of the action
           * is SetStorageClass.
           * </pre>
           *
           * <code>string storage_class = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return The storageClass.
           */
          public java.lang.String getStorageClass() {
            java.lang.Object ref = storageClass_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              storageClass_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }

          /**
           *
           *
           * <pre>
           * Optional. Target storage class. Required iff the type of the action
           * is SetStorageClass.
           * </pre>
           *
           * <code>string storage_class = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return The bytes for storageClass.
           */
          public com.google.protobuf.ByteString getStorageClassBytes() {
            java.lang.Object ref = storageClass_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              storageClass_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }

          /**
           *
           *
           * <pre>
           * Optional. Target storage class. Required iff the type of the action
           * is SetStorageClass.
           * </pre>
           *
           * <code>string storage_class = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param value The storageClass to set.
           * @return This builder for chaining.
           */
          public Builder setStorageClass(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            storageClass_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. Target storage class. Required iff the type of the action
           * is SetStorageClass.
           * </pre>
           *
           * <code>string storage_class = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearStorageClass() {
            storageClass_ = getDefaultInstance().getStorageClass();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. Target storage class. Required iff the type of the action
           * is SetStorageClass.
           * </pre>
           *
           * <code>string storage_class = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param value The bytes for storageClass to set.
           * @return This builder for chaining.
           */
          public Builder setStorageClassBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            storageClass_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Lifecycle.Rule.Action)
        }

        // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Lifecycle.Rule.Action)
        private static final com.google.storage.v2.Bucket.Lifecycle.Rule.Action DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Lifecycle.Rule.Action();
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Action getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Action> PARSER =
            new com.google.protobuf.AbstractParser<Action>() {
              @java.lang.Override
              public Action parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<Action> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Action> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.Lifecycle.Rule.Action getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface ConditionOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Lifecycle.Rule.Condition)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Age of an object (in days). This condition is satisfied when an
         * object reaches the specified age.
         * A value of 0 indicates that all objects immediately match this
         * condition.
         * </pre>
         *
         * <code>optional int32 age_days = 1;</code>
         *
         * @return Whether the ageDays field is set.
         */
        boolean hasAgeDays();

        /**
         *
         *
         * <pre>
         * Age of an object (in days). This condition is satisfied when an
         * object reaches the specified age.
         * A value of 0 indicates that all objects immediately match this
         * condition.
         * </pre>
         *
         * <code>optional int32 age_days = 1;</code>
         *
         * @return The ageDays.
         */
        int getAgeDays();

        /**
         *
         *
         * <pre>
         * Optional. This condition is satisfied when an object is created
         * before midnight of the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date created_before = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the createdBefore field is set.
         */
        boolean hasCreatedBefore();

        /**
         *
         *
         * <pre>
         * Optional. This condition is satisfied when an object is created
         * before midnight of the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date created_before = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The createdBefore.
         */
        com.google.type.Date getCreatedBefore();

        /**
         *
         *
         * <pre>
         * Optional. This condition is satisfied when an object is created
         * before midnight of the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date created_before = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        com.google.type.DateOrBuilder getCreatedBeforeOrBuilder();

        /**
         *
         *
         * <pre>
         * Relevant only for versioned objects. If the value is
         * `true`, this condition matches live objects; if the value
         * is `false`, it matches archived objects.
         * </pre>
         *
         * <code>optional bool is_live = 3;</code>
         *
         * @return Whether the isLive field is set.
         */
        boolean hasIsLive();

        /**
         *
         *
         * <pre>
         * Relevant only for versioned objects. If the value is
         * `true`, this condition matches live objects; if the value
         * is `false`, it matches archived objects.
         * </pre>
         *
         * <code>optional bool is_live = 3;</code>
         *
         * @return The isLive.
         */
        boolean getIsLive();

        /**
         *
         *
         * <pre>
         * Relevant only for versioned objects. If the value is N, this
         * condition is satisfied when there are at least N versions (including
         * the live version) newer than this version of the object.
         * </pre>
         *
         * <code>optional int32 num_newer_versions = 4;</code>
         *
         * @return Whether the numNewerVersions field is set.
         */
        boolean hasNumNewerVersions();

        /**
         *
         *
         * <pre>
         * Relevant only for versioned objects. If the value is N, this
         * condition is satisfied when there are at least N versions (including
         * the live version) newer than this version of the object.
         * </pre>
         *
         * <code>optional int32 num_newer_versions = 4;</code>
         *
         * @return The numNewerVersions.
         */
        int getNumNewerVersions();

        /**
         *
         *
         * <pre>
         * Optional. Objects having any of the storage classes specified by this
         * condition will be matched. Values include `MULTI_REGIONAL`,
         * `REGIONAL`, `NEARLINE`, `COLDLINE`, `STANDARD`, and
         * `DURABLE_REDUCED_AVAILABILITY`.
         * </pre>
         *
         * <code>
         * repeated string matches_storage_class = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return A list containing the matchesStorageClass.
         */
        java.util.List<java.lang.String> getMatchesStorageClassList();

        /**
         *
         *
         * <pre>
         * Optional. Objects having any of the storage classes specified by this
         * condition will be matched. Values include `MULTI_REGIONAL`,
         * `REGIONAL`, `NEARLINE`, `COLDLINE`, `STANDARD`, and
         * `DURABLE_REDUCED_AVAILABILITY`.
         * </pre>
         *
         * <code>
         * repeated string matches_storage_class = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The count of matchesStorageClass.
         */
        int getMatchesStorageClassCount();

        /**
         *
         *
         * <pre>
         * Optional. Objects having any of the storage classes specified by this
         * condition will be matched. Values include `MULTI_REGIONAL`,
         * `REGIONAL`, `NEARLINE`, `COLDLINE`, `STANDARD`, and
         * `DURABLE_REDUCED_AVAILABILITY`.
         * </pre>
         *
         * <code>
         * repeated string matches_storage_class = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index of the element to return.
         * @return The matchesStorageClass at the given index.
         */
        java.lang.String getMatchesStorageClass(int index);

        /**
         *
         *
         * <pre>
         * Optional. Objects having any of the storage classes specified by this
         * condition will be matched. Values include `MULTI_REGIONAL`,
         * `REGIONAL`, `NEARLINE`, `COLDLINE`, `STANDARD`, and
         * `DURABLE_REDUCED_AVAILABILITY`.
         * </pre>
         *
         * <code>
         * repeated string matches_storage_class = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the matchesStorageClass at the given index.
         */
        com.google.protobuf.ByteString getMatchesStorageClassBytes(int index);

        /**
         *
         *
         * <pre>
         * Number of days that have elapsed since the custom timestamp set on an
         * object.
         * The value of the field must be a nonnegative integer.
         * </pre>
         *
         * <code>optional int32 days_since_custom_time = 7;</code>
         *
         * @return Whether the daysSinceCustomTime field is set.
         */
        boolean hasDaysSinceCustomTime();

        /**
         *
         *
         * <pre>
         * Number of days that have elapsed since the custom timestamp set on an
         * object.
         * The value of the field must be a nonnegative integer.
         * </pre>
         *
         * <code>optional int32 days_since_custom_time = 7;</code>
         *
         * @return The daysSinceCustomTime.
         */
        int getDaysSinceCustomTime();

        /**
         *
         *
         * <pre>
         * Optional. An object matches this condition if the custom timestamp
         * set on the object is before the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date custom_time_before = 8 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the customTimeBefore field is set.
         */
        boolean hasCustomTimeBefore();

        /**
         *
         *
         * <pre>
         * Optional. An object matches this condition if the custom timestamp
         * set on the object is before the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date custom_time_before = 8 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The customTimeBefore.
         */
        com.google.type.Date getCustomTimeBefore();

        /**
         *
         *
         * <pre>
         * Optional. An object matches this condition if the custom timestamp
         * set on the object is before the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date custom_time_before = 8 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        com.google.type.DateOrBuilder getCustomTimeBeforeOrBuilder();

        /**
         *
         *
         * <pre>
         * This condition is relevant only for versioned objects. An object
         * version satisfies this condition only if these many days have been
         * passed since it became noncurrent. The value of the field must be a
         * nonnegative integer. If it's zero, the object version will become
         * eligible for Lifecycle action as soon as it becomes noncurrent.
         * </pre>
         *
         * <code>optional int32 days_since_noncurrent_time = 9;</code>
         *
         * @return Whether the daysSinceNoncurrentTime field is set.
         */
        boolean hasDaysSinceNoncurrentTime();

        /**
         *
         *
         * <pre>
         * This condition is relevant only for versioned objects. An object
         * version satisfies this condition only if these many days have been
         * passed since it became noncurrent. The value of the field must be a
         * nonnegative integer. If it's zero, the object version will become
         * eligible for Lifecycle action as soon as it becomes noncurrent.
         * </pre>
         *
         * <code>optional int32 days_since_noncurrent_time = 9;</code>
         *
         * @return The daysSinceNoncurrentTime.
         */
        int getDaysSinceNoncurrentTime();

        /**
         *
         *
         * <pre>
         * Optional. This condition is relevant only for versioned objects. An
         * object version satisfies this condition only if it became noncurrent
         * before the specified date in UTC.
         * </pre>
         *
         * <code>
         * .google.type.Date noncurrent_time_before = 10 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the noncurrentTimeBefore field is set.
         */
        boolean hasNoncurrentTimeBefore();

        /**
         *
         *
         * <pre>
         * Optional. This condition is relevant only for versioned objects. An
         * object version satisfies this condition only if it became noncurrent
         * before the specified date in UTC.
         * </pre>
         *
         * <code>
         * .google.type.Date noncurrent_time_before = 10 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The noncurrentTimeBefore.
         */
        com.google.type.Date getNoncurrentTimeBefore();

        /**
         *
         *
         * <pre>
         * Optional. This condition is relevant only for versioned objects. An
         * object version satisfies this condition only if it became noncurrent
         * before the specified date in UTC.
         * </pre>
         *
         * <code>
         * .google.type.Date noncurrent_time_before = 10 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        com.google.type.DateOrBuilder getNoncurrentTimeBeforeOrBuilder();

        /**
         *
         *
         * <pre>
         * Optional. List of object name prefixes. If any prefix exactly matches
         * the beginning of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_prefix = 11 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return A list containing the matchesPrefix.
         */
        java.util.List<java.lang.String> getMatchesPrefixList();

        /**
         *
         *
         * <pre>
         * Optional. List of object name prefixes. If any prefix exactly matches
         * the beginning of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_prefix = 11 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The count of matchesPrefix.
         */
        int getMatchesPrefixCount();

        /**
         *
         *
         * <pre>
         * Optional. List of object name prefixes. If any prefix exactly matches
         * the beginning of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_prefix = 11 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index of the element to return.
         * @return The matchesPrefix at the given index.
         */
        java.lang.String getMatchesPrefix(int index);

        /**
         *
         *
         * <pre>
         * Optional. List of object name prefixes. If any prefix exactly matches
         * the beginning of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_prefix = 11 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the matchesPrefix at the given index.
         */
        com.google.protobuf.ByteString getMatchesPrefixBytes(int index);

        /**
         *
         *
         * <pre>
         * Optional. List of object name suffixes. If any suffix exactly matches
         * the end of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_suffix = 12 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return A list containing the matchesSuffix.
         */
        java.util.List<java.lang.String> getMatchesSuffixList();

        /**
         *
         *
         * <pre>
         * Optional. List of object name suffixes. If any suffix exactly matches
         * the end of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_suffix = 12 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The count of matchesSuffix.
         */
        int getMatchesSuffixCount();

        /**
         *
         *
         * <pre>
         * Optional. List of object name suffixes. If any suffix exactly matches
         * the end of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_suffix = 12 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index of the element to return.
         * @return The matchesSuffix at the given index.
         */
        java.lang.String getMatchesSuffix(int index);

        /**
         *
         *
         * <pre>
         * Optional. List of object name suffixes. If any suffix exactly matches
         * the end of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_suffix = 12 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the matchesSuffix at the given index.
         */
        com.google.protobuf.ByteString getMatchesSuffixBytes(int index);
      }

      /**
       *
       *
       * <pre>
       * A condition of an object which triggers some action.
       * </pre>
       *
       * Protobuf type {@code google.storage.v2.Bucket.Lifecycle.Rule.Condition}
       */
      public static final class Condition extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Lifecycle.Rule.Condition)
          ConditionOrBuilder {
        private static final long serialVersionUID = 0L;

        // Use Condition.newBuilder() to construct.
        private Condition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private Condition() {
          matchesStorageClass_ = com.google.protobuf.LazyStringArrayList.emptyList();
          matchesPrefix_ = com.google.protobuf.LazyStringArrayList.emptyList();
          matchesSuffix_ = com.google.protobuf.LazyStringArrayList.emptyList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new Condition();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Condition_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Condition_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.class,
                  com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.Builder.class);
        }

        private int bitField0_;
        public static final int AGE_DAYS_FIELD_NUMBER = 1;
        private int ageDays_ = 0;

        /**
         *
         *
         * <pre>
         * Age of an object (in days). This condition is satisfied when an
         * object reaches the specified age.
         * A value of 0 indicates that all objects immediately match this
         * condition.
         * </pre>
         *
         * <code>optional int32 age_days = 1;</code>
         *
         * @return Whether the ageDays field is set.
         */
        @java.lang.Override
        public boolean hasAgeDays() {
          return ((bitField0_ & 0x00000001) != 0);
        }

        /**
         *
         *
         * <pre>
         * Age of an object (in days). This condition is satisfied when an
         * object reaches the specified age.
         * A value of 0 indicates that all objects immediately match this
         * condition.
         * </pre>
         *
         * <code>optional int32 age_days = 1;</code>
         *
         * @return The ageDays.
         */
        @java.lang.Override
        public int getAgeDays() {
          return ageDays_;
        }

        public static final int CREATED_BEFORE_FIELD_NUMBER = 2;
        private com.google.type.Date createdBefore_;

        /**
         *
         *
         * <pre>
         * Optional. This condition is satisfied when an object is created
         * before midnight of the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date created_before = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the createdBefore field is set.
         */
        @java.lang.Override
        public boolean hasCreatedBefore() {
          return ((bitField0_ & 0x00000002) != 0);
        }

        /**
         *
         *
         * <pre>
         * Optional. This condition is satisfied when an object is created
         * before midnight of the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date created_before = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The createdBefore.
         */
        @java.lang.Override
        public com.google.type.Date getCreatedBefore() {
          return createdBefore_ == null
              ? com.google.type.Date.getDefaultInstance()
              : createdBefore_;
        }

        /**
         *
         *
         * <pre>
         * Optional. This condition is satisfied when an object is created
         * before midnight of the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date created_before = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        @java.lang.Override
        public com.google.type.DateOrBuilder getCreatedBeforeOrBuilder() {
          return createdBefore_ == null
              ? com.google.type.Date.getDefaultInstance()
              : createdBefore_;
        }

        public static final int IS_LIVE_FIELD_NUMBER = 3;
        private boolean isLive_ = false;

        /**
         *
         *
         * <pre>
         * Relevant only for versioned objects. If the value is
         * `true`, this condition matches live objects; if the value
         * is `false`, it matches archived objects.
         * </pre>
         *
         * <code>optional bool is_live = 3;</code>
         *
         * @return Whether the isLive field is set.
         */
        @java.lang.Override
        public boolean hasIsLive() {
          return ((bitField0_ & 0x00000004) != 0);
        }

        /**
         *
         *
         * <pre>
         * Relevant only for versioned objects. If the value is
         * `true`, this condition matches live objects; if the value
         * is `false`, it matches archived objects.
         * </pre>
         *
         * <code>optional bool is_live = 3;</code>
         *
         * @return The isLive.
         */
        @java.lang.Override
        public boolean getIsLive() {
          return isLive_;
        }

        public static final int NUM_NEWER_VERSIONS_FIELD_NUMBER = 4;
        private int numNewerVersions_ = 0;

        /**
         *
         *
         * <pre>
         * Relevant only for versioned objects. If the value is N, this
         * condition is satisfied when there are at least N versions (including
         * the live version) newer than this version of the object.
         * </pre>
         *
         * <code>optional int32 num_newer_versions = 4;</code>
         *
         * @return Whether the numNewerVersions field is set.
         */
        @java.lang.Override
        public boolean hasNumNewerVersions() {
          return ((bitField0_ & 0x00000008) != 0);
        }

        /**
         *
         *
         * <pre>
         * Relevant only for versioned objects. If the value is N, this
         * condition is satisfied when there are at least N versions (including
         * the live version) newer than this version of the object.
         * </pre>
         *
         * <code>optional int32 num_newer_versions = 4;</code>
         *
         * @return The numNewerVersions.
         */
        @java.lang.Override
        public int getNumNewerVersions() {
          return numNewerVersions_;
        }

        public static final int MATCHES_STORAGE_CLASS_FIELD_NUMBER = 5;

        @SuppressWarnings("serial")
        private com.google.protobuf.LazyStringArrayList matchesStorageClass_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        /**
         *
         *
         * <pre>
         * Optional. Objects having any of the storage classes specified by this
         * condition will be matched. Values include `MULTI_REGIONAL`,
         * `REGIONAL`, `NEARLINE`, `COLDLINE`, `STANDARD`, and
         * `DURABLE_REDUCED_AVAILABILITY`.
         * </pre>
         *
         * <code>
         * repeated string matches_storage_class = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return A list containing the matchesStorageClass.
         */
        public com.google.protobuf.ProtocolStringList getMatchesStorageClassList() {
          return matchesStorageClass_;
        }

        /**
         *
         *
         * <pre>
         * Optional. Objects having any of the storage classes specified by this
         * condition will be matched. Values include `MULTI_REGIONAL`,
         * `REGIONAL`, `NEARLINE`, `COLDLINE`, `STANDARD`, and
         * `DURABLE_REDUCED_AVAILABILITY`.
         * </pre>
         *
         * <code>
         * repeated string matches_storage_class = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The count of matchesStorageClass.
         */
        public int getMatchesStorageClassCount() {
          return matchesStorageClass_.size();
        }

        /**
         *
         *
         * <pre>
         * Optional. Objects having any of the storage classes specified by this
         * condition will be matched. Values include `MULTI_REGIONAL`,
         * `REGIONAL`, `NEARLINE`, `COLDLINE`, `STANDARD`, and
         * `DURABLE_REDUCED_AVAILABILITY`.
         * </pre>
         *
         * <code>
         * repeated string matches_storage_class = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index of the element to return.
         * @return The matchesStorageClass at the given index.
         */
        public java.lang.String getMatchesStorageClass(int index) {
          return matchesStorageClass_.get(index);
        }

        /**
         *
         *
         * <pre>
         * Optional. Objects having any of the storage classes specified by this
         * condition will be matched. Values include `MULTI_REGIONAL`,
         * `REGIONAL`, `NEARLINE`, `COLDLINE`, `STANDARD`, and
         * `DURABLE_REDUCED_AVAILABILITY`.
         * </pre>
         *
         * <code>
         * repeated string matches_storage_class = 5 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the matchesStorageClass at the given index.
         */
        public com.google.protobuf.ByteString getMatchesStorageClassBytes(int index) {
          return matchesStorageClass_.getByteString(index);
        }

        public static final int DAYS_SINCE_CUSTOM_TIME_FIELD_NUMBER = 7;
        private int daysSinceCustomTime_ = 0;

        /**
         *
         *
         * <pre>
         * Number of days that have elapsed since the custom timestamp set on an
         * object.
         * The value of the field must be a nonnegative integer.
         * </pre>
         *
         * <code>optional int32 days_since_custom_time = 7;</code>
         *
         * @return Whether the daysSinceCustomTime field is set.
         */
        @java.lang.Override
        public boolean hasDaysSinceCustomTime() {
          return ((bitField0_ & 0x00000010) != 0);
        }

        /**
         *
         *
         * <pre>
         * Number of days that have elapsed since the custom timestamp set on an
         * object.
         * The value of the field must be a nonnegative integer.
         * </pre>
         *
         * <code>optional int32 days_since_custom_time = 7;</code>
         *
         * @return The daysSinceCustomTime.
         */
        @java.lang.Override
        public int getDaysSinceCustomTime() {
          return daysSinceCustomTime_;
        }

        public static final int CUSTOM_TIME_BEFORE_FIELD_NUMBER = 8;
        private com.google.type.Date customTimeBefore_;

        /**
         *
         *
         * <pre>
         * Optional. An object matches this condition if the custom timestamp
         * set on the object is before the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date custom_time_before = 8 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the customTimeBefore field is set.
         */
        @java.lang.Override
        public boolean hasCustomTimeBefore() {
          return ((bitField0_ & 0x00000020) != 0);
        }

        /**
         *
         *
         * <pre>
         * Optional. An object matches this condition if the custom timestamp
         * set on the object is before the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date custom_time_before = 8 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The customTimeBefore.
         */
        @java.lang.Override
        public com.google.type.Date getCustomTimeBefore() {
          return customTimeBefore_ == null
              ? com.google.type.Date.getDefaultInstance()
              : customTimeBefore_;
        }

        /**
         *
         *
         * <pre>
         * Optional. An object matches this condition if the custom timestamp
         * set on the object is before the specified date in UTC.
         * </pre>
         *
         * <code>.google.type.Date custom_time_before = 8 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        @java.lang.Override
        public com.google.type.DateOrBuilder getCustomTimeBeforeOrBuilder() {
          return customTimeBefore_ == null
              ? com.google.type.Date.getDefaultInstance()
              : customTimeBefore_;
        }

        public static final int DAYS_SINCE_NONCURRENT_TIME_FIELD_NUMBER = 9;
        private int daysSinceNoncurrentTime_ = 0;

        /**
         *
         *
         * <pre>
         * This condition is relevant only for versioned objects. An object
         * version satisfies this condition only if these many days have been
         * passed since it became noncurrent. The value of the field must be a
         * nonnegative integer. If it's zero, the object version will become
         * eligible for Lifecycle action as soon as it becomes noncurrent.
         * </pre>
         *
         * <code>optional int32 days_since_noncurrent_time = 9;</code>
         *
         * @return Whether the daysSinceNoncurrentTime field is set.
         */
        @java.lang.Override
        public boolean hasDaysSinceNoncurrentTime() {
          return ((bitField0_ & 0x00000040) != 0);
        }

        /**
         *
         *
         * <pre>
         * This condition is relevant only for versioned objects. An object
         * version satisfies this condition only if these many days have been
         * passed since it became noncurrent. The value of the field must be a
         * nonnegative integer. If it's zero, the object version will become
         * eligible for Lifecycle action as soon as it becomes noncurrent.
         * </pre>
         *
         * <code>optional int32 days_since_noncurrent_time = 9;</code>
         *
         * @return The daysSinceNoncurrentTime.
         */
        @java.lang.Override
        public int getDaysSinceNoncurrentTime() {
          return daysSinceNoncurrentTime_;
        }

        public static final int NONCURRENT_TIME_BEFORE_FIELD_NUMBER = 10;
        private com.google.type.Date noncurrentTimeBefore_;

        /**
         *
         *
         * <pre>
         * Optional. This condition is relevant only for versioned objects. An
         * object version satisfies this condition only if it became noncurrent
         * before the specified date in UTC.
         * </pre>
         *
         * <code>
         * .google.type.Date noncurrent_time_before = 10 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the noncurrentTimeBefore field is set.
         */
        @java.lang.Override
        public boolean hasNoncurrentTimeBefore() {
          return ((bitField0_ & 0x00000080) != 0);
        }

        /**
         *
         *
         * <pre>
         * Optional. This condition is relevant only for versioned objects. An
         * object version satisfies this condition only if it became noncurrent
         * before the specified date in UTC.
         * </pre>
         *
         * <code>
         * .google.type.Date noncurrent_time_before = 10 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The noncurrentTimeBefore.
         */
        @java.lang.Override
        public com.google.type.Date getNoncurrentTimeBefore() {
          return noncurrentTimeBefore_ == null
              ? com.google.type.Date.getDefaultInstance()
              : noncurrentTimeBefore_;
        }

        /**
         *
         *
         * <pre>
         * Optional. This condition is relevant only for versioned objects. An
         * object version satisfies this condition only if it became noncurrent
         * before the specified date in UTC.
         * </pre>
         *
         * <code>
         * .google.type.Date noncurrent_time_before = 10 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        @java.lang.Override
        public com.google.type.DateOrBuilder getNoncurrentTimeBeforeOrBuilder() {
          return noncurrentTimeBefore_ == null
              ? com.google.type.Date.getDefaultInstance()
              : noncurrentTimeBefore_;
        }

        public static final int MATCHES_PREFIX_FIELD_NUMBER = 11;

        @SuppressWarnings("serial")
        private com.google.protobuf.LazyStringArrayList matchesPrefix_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        /**
         *
         *
         * <pre>
         * Optional. List of object name prefixes. If any prefix exactly matches
         * the beginning of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_prefix = 11 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return A list containing the matchesPrefix.
         */
        public com.google.protobuf.ProtocolStringList getMatchesPrefixList() {
          return matchesPrefix_;
        }

        /**
         *
         *
         * <pre>
         * Optional. List of object name prefixes. If any prefix exactly matches
         * the beginning of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_prefix = 11 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The count of matchesPrefix.
         */
        public int getMatchesPrefixCount() {
          return matchesPrefix_.size();
        }

        /**
         *
         *
         * <pre>
         * Optional. List of object name prefixes. If any prefix exactly matches
         * the beginning of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_prefix = 11 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index of the element to return.
         * @return The matchesPrefix at the given index.
         */
        public java.lang.String getMatchesPrefix(int index) {
          return matchesPrefix_.get(index);
        }

        /**
         *
         *
         * <pre>
         * Optional. List of object name prefixes. If any prefix exactly matches
         * the beginning of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_prefix = 11 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the matchesPrefix at the given index.
         */
        public com.google.protobuf.ByteString getMatchesPrefixBytes(int index) {
          return matchesPrefix_.getByteString(index);
        }

        public static final int MATCHES_SUFFIX_FIELD_NUMBER = 12;

        @SuppressWarnings("serial")
        private com.google.protobuf.LazyStringArrayList matchesSuffix_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        /**
         *
         *
         * <pre>
         * Optional. List of object name suffixes. If any suffix exactly matches
         * the end of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_suffix = 12 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return A list containing the matchesSuffix.
         */
        public com.google.protobuf.ProtocolStringList getMatchesSuffixList() {
          return matchesSuffix_;
        }

        /**
         *
         *
         * <pre>
         * Optional. List of object name suffixes. If any suffix exactly matches
         * the end of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_suffix = 12 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The count of matchesSuffix.
         */
        public int getMatchesSuffixCount() {
          return matchesSuffix_.size();
        }

        /**
         *
         *
         * <pre>
         * Optional. List of object name suffixes. If any suffix exactly matches
         * the end of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_suffix = 12 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index of the element to return.
         * @return The matchesSuffix at the given index.
         */
        public java.lang.String getMatchesSuffix(int index) {
          return matchesSuffix_.get(index);
        }

        /**
         *
         *
         * <pre>
         * Optional. List of object name suffixes. If any suffix exactly matches
         * the end of the object name, the condition evaluates to true.
         * </pre>
         *
         * <code>repeated string matches_suffix = 12 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the matchesSuffix at the given index.
         */
        public com.google.protobuf.ByteString getMatchesSuffixBytes(int index) {
          return matchesSuffix_.getByteString(index);
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (((bitField0_ & 0x00000001) != 0)) {
            output.writeInt32(1, ageDays_);
          }
          if (((bitField0_ & 0x00000002) != 0)) {
            output.writeMessage(2, getCreatedBefore());
          }
          if (((bitField0_ & 0x00000004) != 0)) {
            output.writeBool(3, isLive_);
          }
          if (((bitField0_ & 0x00000008) != 0)) {
            output.writeInt32(4, numNewerVersions_);
          }
          for (int i = 0; i < matchesStorageClass_.size(); i++) {
            com.google.protobuf.GeneratedMessageV3.writeString(
                output, 5, matchesStorageClass_.getRaw(i));
          }
          if (((bitField0_ & 0x00000010) != 0)) {
            output.writeInt32(7, daysSinceCustomTime_);
          }
          if (((bitField0_ & 0x00000020) != 0)) {
            output.writeMessage(8, getCustomTimeBefore());
          }
          if (((bitField0_ & 0x00000040) != 0)) {
            output.writeInt32(9, daysSinceNoncurrentTime_);
          }
          if (((bitField0_ & 0x00000080) != 0)) {
            output.writeMessage(10, getNoncurrentTimeBefore());
          }
          for (int i = 0; i < matchesPrefix_.size(); i++) {
            com.google.protobuf.GeneratedMessageV3.writeString(
                output, 11, matchesPrefix_.getRaw(i));
          }
          for (int i = 0; i < matchesSuffix_.size(); i++) {
            com.google.protobuf.GeneratedMessageV3.writeString(
                output, 12, matchesSuffix_.getRaw(i));
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (((bitField0_ & 0x00000001) != 0)) {
            size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, ageDays_);
          }
          if (((bitField0_ & 0x00000002) != 0)) {
            size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreatedBefore());
          }
          if (((bitField0_ & 0x00000004) != 0)) {
            size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, isLive_);
          }
          if (((bitField0_ & 0x00000008) != 0)) {
            size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, numNewerVersions_);
          }
          {
            int dataSize = 0;
            for (int i = 0; i < matchesStorageClass_.size(); i++) {
              dataSize += computeStringSizeNoTag(matchesStorageClass_.getRaw(i));
            }
            size += dataSize;
            size += 1 * getMatchesStorageClassList().size();
          }
          if (((bitField0_ & 0x00000010) != 0)) {
            size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, daysSinceCustomTime_);
          }
          if (((bitField0_ & 0x00000020) != 0)) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(8, getCustomTimeBefore());
          }
          if (((bitField0_ & 0x00000040) != 0)) {
            size +=
                com.google.protobuf.CodedOutputStream.computeInt32Size(9, daysSinceNoncurrentTime_);
          }
          if (((bitField0_ & 0x00000080) != 0)) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(
                    10, getNoncurrentTimeBefore());
          }
          {
            int dataSize = 0;
            for (int i = 0; i < matchesPrefix_.size(); i++) {
              dataSize += computeStringSizeNoTag(matchesPrefix_.getRaw(i));
            }
            size += dataSize;
            size += 1 * getMatchesPrefixList().size();
          }
          {
            int dataSize = 0;
            for (int i = 0; i < matchesSuffix_.size(); i++) {
              dataSize += computeStringSizeNoTag(matchesSuffix_.getRaw(i));
            }
            size += dataSize;
            size += 1 * getMatchesSuffixList().size();
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj instanceof com.google.storage.v2.Bucket.Lifecycle.Rule.Condition)) {
            return super.equals(obj);
          }
          com.google.storage.v2.Bucket.Lifecycle.Rule.Condition other =
              (com.google.storage.v2.Bucket.Lifecycle.Rule.Condition) obj;

          if (hasAgeDays() != other.hasAgeDays()) return false;
          if (hasAgeDays()) {
            if (getAgeDays() != other.getAgeDays()) return false;
          }
          if (hasCreatedBefore() != other.hasCreatedBefore()) return false;
          if (hasCreatedBefore()) {
            if (!getCreatedBefore().equals(other.getCreatedBefore())) return false;
          }
          if (hasIsLive() != other.hasIsLive()) return false;
          if (hasIsLive()) {
            if (getIsLive() != other.getIsLive()) return false;
          }
          if (hasNumNewerVersions() != other.hasNumNewerVersions()) return false;
          if (hasNumNewerVersions()) {
            if (getNumNewerVersions() != other.getNumNewerVersions()) return false;
          }
          if (!getMatchesStorageClassList().equals(other.getMatchesStorageClassList()))
            return false;
          if (hasDaysSinceCustomTime() != other.hasDaysSinceCustomTime()) return false;
          if (hasDaysSinceCustomTime()) {
            if (getDaysSinceCustomTime() != other.getDaysSinceCustomTime()) return false;
          }
          if (hasCustomTimeBefore() != other.hasCustomTimeBefore()) return false;
          if (hasCustomTimeBefore()) {
            if (!getCustomTimeBefore().equals(other.getCustomTimeBefore())) return false;
          }
          if (hasDaysSinceNoncurrentTime() != other.hasDaysSinceNoncurrentTime()) return false;
          if (hasDaysSinceNoncurrentTime()) {
            if (getDaysSinceNoncurrentTime() != other.getDaysSinceNoncurrentTime()) return false;
          }
          if (hasNoncurrentTimeBefore() != other.hasNoncurrentTimeBefore()) return false;
          if (hasNoncurrentTimeBefore()) {
            if (!getNoncurrentTimeBefore().equals(other.getNoncurrentTimeBefore())) return false;
          }
          if (!getMatchesPrefixList().equals(other.getMatchesPrefixList())) return false;
          if (!getMatchesSuffixList().equals(other.getMatchesSuffixList())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (hasAgeDays()) {
            hash = (37 * hash) + AGE_DAYS_FIELD_NUMBER;
            hash = (53 * hash) + getAgeDays();
          }
          if (hasCreatedBefore()) {
            hash = (37 * hash) + CREATED_BEFORE_FIELD_NUMBER;
            hash = (53 * hash) + getCreatedBefore().hashCode();
          }
          if (hasIsLive()) {
            hash = (37 * hash) + IS_LIVE_FIELD_NUMBER;
            hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsLive());
          }
          if (hasNumNewerVersions()) {
            hash = (37 * hash) + NUM_NEWER_VERSIONS_FIELD_NUMBER;
            hash = (53 * hash) + getNumNewerVersions();
          }
          if (getMatchesStorageClassCount() > 0) {
            hash = (37 * hash) + MATCHES_STORAGE_CLASS_FIELD_NUMBER;
            hash = (53 * hash) + getMatchesStorageClassList().hashCode();
          }
          if (hasDaysSinceCustomTime()) {
            hash = (37 * hash) + DAYS_SINCE_CUSTOM_TIME_FIELD_NUMBER;
            hash = (53 * hash) + getDaysSinceCustomTime();
          }
          if (hasCustomTimeBefore()) {
            hash = (37 * hash) + CUSTOM_TIME_BEFORE_FIELD_NUMBER;
            hash = (53 * hash) + getCustomTimeBefore().hashCode();
          }
          if (hasDaysSinceNoncurrentTime()) {
            hash = (37 * hash) + DAYS_SINCE_NONCURRENT_TIME_FIELD_NUMBER;
            hash = (53 * hash) + getDaysSinceNoncurrentTime();
          }
          if (hasNoncurrentTimeBefore()) {
            hash = (37 * hash) + NONCURRENT_TIME_BEFORE_FIELD_NUMBER;
            hash = (53 * hash) + getNoncurrentTimeBefore().hashCode();
          }
          if (getMatchesPrefixCount() > 0) {
            hash = (37 * hash) + MATCHES_PREFIX_FIELD_NUMBER;
            hash = (53 * hash) + getMatchesPrefixList().hashCode();
          }
          if (getMatchesSuffixCount() > 0) {
            hash = (37 * hash) + MATCHES_SUFFIX_FIELD_NUMBER;
            hash = (53 * hash) + getMatchesSuffixList().hashCode();
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(byte[] data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseDelimitedFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.storage.v2.Bucket.Lifecycle.Rule.Condition prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }

        /**
         *
         *
         * <pre>
         * A condition of an object which triggers some action.
         * </pre>
         *
         * Protobuf type {@code google.storage.v2.Bucket.Lifecycle.Rule.Condition}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Lifecycle.Rule.Condition)
            com.google.storage.v2.Bucket.Lifecycle.Rule.ConditionOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.storage.v2.StorageProto
                .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Condition_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.storage.v2.StorageProto
                .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Condition_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.class,
                    com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.Builder.class);
          }

          // Construct using com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }

          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
              getCreatedBeforeFieldBuilder();
              getCustomTimeBeforeFieldBuilder();
              getNoncurrentTimeBeforeFieldBuilder();
            }
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            ageDays_ = 0;
            createdBefore_ = null;
            if (createdBeforeBuilder_ != null) {
              createdBeforeBuilder_.dispose();
              createdBeforeBuilder_ = null;
            }
            isLive_ = false;
            numNewerVersions_ = 0;
            matchesStorageClass_ = com.google.protobuf.LazyStringArrayList.emptyList();
            daysSinceCustomTime_ = 0;
            customTimeBefore_ = null;
            if (customTimeBeforeBuilder_ != null) {
              customTimeBeforeBuilder_.dispose();
              customTimeBeforeBuilder_ = null;
            }
            daysSinceNoncurrentTime_ = 0;
            noncurrentTimeBefore_ = null;
            if (noncurrentTimeBeforeBuilder_ != null) {
              noncurrentTimeBeforeBuilder_.dispose();
              noncurrentTimeBeforeBuilder_ = null;
            }
            matchesPrefix_ = com.google.protobuf.LazyStringArrayList.emptyList();
            matchesSuffix_ = com.google.protobuf.LazyStringArrayList.emptyList();
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.storage.v2.StorageProto
                .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_Condition_descriptor;
          }

          @java.lang.Override
          public com.google.storage.v2.Bucket.Lifecycle.Rule.Condition getDefaultInstanceForType() {
            return com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.storage.v2.Bucket.Lifecycle.Rule.Condition build() {
            com.google.storage.v2.Bucket.Lifecycle.Rule.Condition result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.storage.v2.Bucket.Lifecycle.Rule.Condition buildPartial() {
            com.google.storage.v2.Bucket.Lifecycle.Rule.Condition result =
                new com.google.storage.v2.Bucket.Lifecycle.Rule.Condition(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(com.google.storage.v2.Bucket.Lifecycle.Rule.Condition result) {
            int from_bitField0_ = bitField0_;
            int to_bitField0_ = 0;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.ageDays_ = ageDays_;
              to_bitField0_ |= 0x00000001;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.createdBefore_ =
                  createdBeforeBuilder_ == null ? createdBefore_ : createdBeforeBuilder_.build();
              to_bitField0_ |= 0x00000002;
            }
            if (((from_bitField0_ & 0x00000004) != 0)) {
              result.isLive_ = isLive_;
              to_bitField0_ |= 0x00000004;
            }
            if (((from_bitField0_ & 0x00000008) != 0)) {
              result.numNewerVersions_ = numNewerVersions_;
              to_bitField0_ |= 0x00000008;
            }
            if (((from_bitField0_ & 0x00000010) != 0)) {
              matchesStorageClass_.makeImmutable();
              result.matchesStorageClass_ = matchesStorageClass_;
            }
            if (((from_bitField0_ & 0x00000020) != 0)) {
              result.daysSinceCustomTime_ = daysSinceCustomTime_;
              to_bitField0_ |= 0x00000010;
            }
            if (((from_bitField0_ & 0x00000040) != 0)) {
              result.customTimeBefore_ =
                  customTimeBeforeBuilder_ == null
                      ? customTimeBefore_
                      : customTimeBeforeBuilder_.build();
              to_bitField0_ |= 0x00000020;
            }
            if (((from_bitField0_ & 0x00000080) != 0)) {
              result.daysSinceNoncurrentTime_ = daysSinceNoncurrentTime_;
              to_bitField0_ |= 0x00000040;
            }
            if (((from_bitField0_ & 0x00000100) != 0)) {
              result.noncurrentTimeBefore_ =
                  noncurrentTimeBeforeBuilder_ == null
                      ? noncurrentTimeBefore_
                      : noncurrentTimeBeforeBuilder_.build();
              to_bitField0_ |= 0x00000080;
            }
            if (((from_bitField0_ & 0x00000200) != 0)) {
              matchesPrefix_.makeImmutable();
              result.matchesPrefix_ = matchesPrefix_;
            }
            if (((from_bitField0_ & 0x00000400) != 0)) {
              matchesSuffix_.makeImmutable();
              result.matchesSuffix_ = matchesSuffix_;
            }
            result.bitField0_ |= to_bitField0_;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof com.google.storage.v2.Bucket.Lifecycle.Rule.Condition) {
              return mergeFrom((com.google.storage.v2.Bucket.Lifecycle.Rule.Condition) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(com.google.storage.v2.Bucket.Lifecycle.Rule.Condition other) {
            if (other == com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.getDefaultInstance())
              return this;
            if (other.hasAgeDays()) {
              setAgeDays(other.getAgeDays());
            }
            if (other.hasCreatedBefore()) {
              mergeCreatedBefore(other.getCreatedBefore());
            }
            if (other.hasIsLive()) {
              setIsLive(other.getIsLive());
            }
            if (other.hasNumNewerVersions()) {
              setNumNewerVersions(other.getNumNewerVersions());
            }
            if (!other.matchesStorageClass_.isEmpty()) {
              if (matchesStorageClass_.isEmpty()) {
                matchesStorageClass_ = other.matchesStorageClass_;
                bitField0_ |= 0x00000010;
              } else {
                ensureMatchesStorageClassIsMutable();
                matchesStorageClass_.addAll(other.matchesStorageClass_);
              }
              onChanged();
            }
            if (other.hasDaysSinceCustomTime()) {
              setDaysSinceCustomTime(other.getDaysSinceCustomTime());
            }
            if (other.hasCustomTimeBefore()) {
              mergeCustomTimeBefore(other.getCustomTimeBefore());
            }
            if (other.hasDaysSinceNoncurrentTime()) {
              setDaysSinceNoncurrentTime(other.getDaysSinceNoncurrentTime());
            }
            if (other.hasNoncurrentTimeBefore()) {
              mergeNoncurrentTimeBefore(other.getNoncurrentTimeBefore());
            }
            if (!other.matchesPrefix_.isEmpty()) {
              if (matchesPrefix_.isEmpty()) {
                matchesPrefix_ = other.matchesPrefix_;
                bitField0_ |= 0x00000200;
              } else {
                ensureMatchesPrefixIsMutable();
                matchesPrefix_.addAll(other.matchesPrefix_);
              }
              onChanged();
            }
            if (!other.matchesSuffix_.isEmpty()) {
              if (matchesSuffix_.isEmpty()) {
                matchesSuffix_ = other.matchesSuffix_;
                bitField0_ |= 0x00000400;
              } else {
                ensureMatchesSuffixIsMutable();
                matchesSuffix_.addAll(other.matchesSuffix_);
              }
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 8:
                    {
                      ageDays_ = input.readInt32();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 8
                  case 18:
                    {
                      input.readMessage(
                          getCreatedBeforeFieldBuilder().getBuilder(), extensionRegistry);
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 18
                  case 24:
                    {
                      isLive_ = input.readBool();
                      bitField0_ |= 0x00000004;
                      break;
                    } // case 24
                  case 32:
                    {
                      numNewerVersions_ = input.readInt32();
                      bitField0_ |= 0x00000008;
                      break;
                    } // case 32
                  case 42:
                    {
                      java.lang.String s = input.readStringRequireUtf8();
                      ensureMatchesStorageClassIsMutable();
                      matchesStorageClass_.add(s);
                      break;
                    } // case 42
                  case 56:
                    {
                      daysSinceCustomTime_ = input.readInt32();
                      bitField0_ |= 0x00000020;
                      break;
                    } // case 56
                  case 66:
                    {
                      input.readMessage(
                          getCustomTimeBeforeFieldBuilder().getBuilder(), extensionRegistry);
                      bitField0_ |= 0x00000040;
                      break;
                    } // case 66
                  case 72:
                    {
                      daysSinceNoncurrentTime_ = input.readInt32();
                      bitField0_ |= 0x00000080;
                      break;
                    } // case 72
                  case 82:
                    {
                      input.readMessage(
                          getNoncurrentTimeBeforeFieldBuilder().getBuilder(), extensionRegistry);
                      bitField0_ |= 0x00000100;
                      break;
                    } // case 82
                  case 90:
                    {
                      java.lang.String s = input.readStringRequireUtf8();
                      ensureMatchesPrefixIsMutable();
                      matchesPrefix_.add(s);
                      break;
                    } // case 90
                  case 98:
                    {
                      java.lang.String s = input.readStringRequireUtf8();
                      ensureMatchesSuffixIsMutable();
                      matchesSuffix_.add(s);
                      break;
                    } // case 98
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private int ageDays_;

          /**
           *
           *
           * <pre>
           * Age of an object (in days). This condition is satisfied when an
           * object reaches the specified age.
           * A value of 0 indicates that all objects immediately match this
           * condition.
           * </pre>
           *
           * <code>optional int32 age_days = 1;</code>
           *
           * @return Whether the ageDays field is set.
           */
          @java.lang.Override
          public boolean hasAgeDays() {
            return ((bitField0_ & 0x00000001) != 0);
          }

          /**
           *
           *
           * <pre>
           * Age of an object (in days). This condition is satisfied when an
           * object reaches the specified age.
           * A value of 0 indicates that all objects immediately match this
           * condition.
           * </pre>
           *
           * <code>optional int32 age_days = 1;</code>
           *
           * @return The ageDays.
           */
          @java.lang.Override
          public int getAgeDays() {
            return ageDays_;
          }

          /**
           *
           *
           * <pre>
           * Age of an object (in days). This condition is satisfied when an
           * object reaches the specified age.
           * A value of 0 indicates that all objects immediately match this
           * condition.
           * </pre>
           *
           * <code>optional int32 age_days = 1;</code>
           *
           * @param value The ageDays to set.
           * @return This builder for chaining.
           */
          public Builder setAgeDays(int value) {

            ageDays_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Age of an object (in days). This condition is satisfied when an
           * object reaches the specified age.
           * A value of 0 indicates that all objects immediately match this
           * condition.
           * </pre>
           *
           * <code>optional int32 age_days = 1;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearAgeDays() {
            bitField0_ = (bitField0_ & ~0x00000001);
            ageDays_ = 0;
            onChanged();
            return this;
          }

          private com.google.type.Date createdBefore_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
              createdBeforeBuilder_;

          /**
           *
           *
           * <pre>
           * Optional. This condition is satisfied when an object is created
           * before midnight of the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date created_before = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return Whether the createdBefore field is set.
           */
          public boolean hasCreatedBefore() {
            return ((bitField0_ & 0x00000002) != 0);
          }

          /**
           *
           *
           * <pre>
           * Optional. This condition is satisfied when an object is created
           * before midnight of the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date created_before = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return The createdBefore.
           */
          public com.google.type.Date getCreatedBefore() {
            if (createdBeforeBuilder_ == null) {
              return createdBefore_ == null
                  ? com.google.type.Date.getDefaultInstance()
                  : createdBefore_;
            } else {
              return createdBeforeBuilder_.getMessage();
            }
          }

          /**
           *
           *
           * <pre>
           * Optional. This condition is satisfied when an object is created
           * before midnight of the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date created_before = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public Builder setCreatedBefore(com.google.type.Date value) {
            if (createdBeforeBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              createdBefore_ = value;
            } else {
              createdBeforeBuilder_.setMessage(value);
            }
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. This condition is satisfied when an object is created
           * before midnight of the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date created_before = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public Builder setCreatedBefore(com.google.type.Date.Builder builderForValue) {
            if (createdBeforeBuilder_ == null) {
              createdBefore_ = builderForValue.build();
            } else {
              createdBeforeBuilder_.setMessage(builderForValue.build());
            }
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. This condition is satisfied when an object is created
           * before midnight of the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date created_before = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public Builder mergeCreatedBefore(com.google.type.Date value) {
            if (createdBeforeBuilder_ == null) {
              if (((bitField0_ & 0x00000002) != 0)
                  && createdBefore_ != null
                  && createdBefore_ != com.google.type.Date.getDefaultInstance()) {
                getCreatedBeforeBuilder().mergeFrom(value);
              } else {
                createdBefore_ = value;
              }
            } else {
              createdBeforeBuilder_.mergeFrom(value);
            }
            if (createdBefore_ != null) {
              bitField0_ |= 0x00000002;
              onChanged();
            }
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. This condition is satisfied when an object is created
           * before midnight of the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date created_before = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public Builder clearCreatedBefore() {
            bitField0_ = (bitField0_ & ~0x00000002);
            createdBefore_ = null;
            if (createdBeforeBuilder_ != null) {
              createdBeforeBuilder_.dispose();
              createdBeforeBuilder_ = null;
            }
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. This condition is satisfied when an object is created
           * before midnight of the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date created_before = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public com.google.type.Date.Builder getCreatedBeforeBuilder() {
            bitField0_ |= 0x00000002;
            onChanged();
            return getCreatedBeforeFieldBuilder().getBuilder();
          }

          /**
           *
           *
           * <pre>
           * Optional. This condition is satisfied when an object is created
           * before midnight of the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date created_before = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public com.google.type.DateOrBuilder getCreatedBeforeOrBuilder() {
            if (createdBeforeBuilder_ != null) {
              return createdBeforeBuilder_.getMessageOrBuilder();
            } else {
              return createdBefore_ == null
                  ? com.google.type.Date.getDefaultInstance()
                  : createdBefore_;
            }
          }

          /**
           *
           *
           * <pre>
           * Optional. This condition is satisfied when an object is created
           * before midnight of the specified date in UTC.
           * </pre>
           *
           * <code>.google.type.Date created_before = 2 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
              getCreatedBeforeFieldBuilder() {
            if (createdBeforeBuilder_ == null) {
              createdBeforeBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.type.Date,
                      com.google.type.Date.Builder,
                      com.google.type.DateOrBuilder>(
                      getCreatedBefore(), getParentForChildren(), isClean());
              createdBefore_ = null;
            }
            return createdBeforeBuilder_;
          }

          private boolean isLive_;

          /**
           *
           *
           * <pre>
           * Relevant only for versioned objects. If the value is
           * `true`, this condition matches live objects; if the value
           * is `false`, it matches archived objects.
           * </pre>
           *
           * <code>optional bool is_live = 3;</code>
           *
           * @return Whether the isLive field is set.
           */
          @java.lang.Override
          public boolean hasIsLive() {
            return ((bitField0_ & 0x00000004) != 0);
          }

          /**
           *
           *
           * <pre>
           * Relevant only for versioned objects. If the value is
           * `true`, this condition matches live objects; if the value
           * is `false`, it matches archived objects.
           * </pre>
           *
           * <code>optional bool is_live = 3;</code>
           *
           * @return The isLive.
           */
          @java.lang.Override
          public boolean getIsLive() {
            return isLive_;
          }

          /**
           *
           *
           * <pre>
           * Relevant only for versioned objects. If the value is
           * `true`, this condition matches live objects; if the value
           * is `false`, it matches archived objects.
           * </pre>
           *
           * <code>optional bool is_live = 3;</code>
           *
           * @param value The isLive to set.
           * @return This builder for chaining.
           */
          public Builder setIsLive(boolean value) {

            isLive_ = value;
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Relevant only for versioned objects. If the value is
           * `true`, this condition matches live objects; if the value
           * is `false`, it matches archived objects.
           * </pre>
           *
           * <code>optional bool is_live = 3;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearIsLive() {
            bitField0_ = (bitField0_ & ~0x00000004);
            isLive_ = false;
            onChanged();
            return this;
          }

          private int numNewerVersions_;

          /**
           *
           *
           * <pre>
           * Relevant only for versioned objects. If the value is N, this
           * condition is satisfied when there are at least N versions (including
           * the live version) newer than this version of the object.
           * </pre>
           *
           * <code>optional int32 num_newer_versions = 4;</code>
           *
           * @return Whether the numNewerVersions field is set.
           */
          @java.lang.Override
          public boolean hasNumNewerVersions() {
            return ((bitField0_ & 0x00000008) != 0);
          }

          /**
           *
           *
           * <pre>
           * Relevant only for versioned objects. If the value is N, this
           * condition is satisfied when there are at least N versions (including
           * the live version) newer than this version of the object.
           * </pre>
           *
           * <code>optional int32 num_newer_versions = 4;</code>
           *
           * @return The numNewerVersions.
           */
          @java.lang.Override
          public int getNumNewerVersions() {
            return numNewerVersions_;
          }

          /**
           *
           *
           * <pre>
           * Relevant only for versioned objects. If the value is N, this
           * condition is satisfied when there are at least N versions (including
           * the live version) newer than this version of the object.
           * </pre>
           *
           * <code>optional int32 num_newer_versions = 4;</code>
           *
           * @param value The numNewerVersions to set.
           * @return This builder for chaining.
           */
          public Builder setNumNewerVersions(int value) {

            numNewerVersions_ = value;
            bitField0_ |= 0x00000008;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Relevant only for versioned objects. If the value is N, this
           * condition is satisfied when there are at least N versions (including
           * the live version) newer than this version of the object.
           * </pre>
           *
           * <code>optional int32 num_newer_versions = 4;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearNumNewerVersions() {
            bitField0_ = (bitField0_ & ~0x00000008);
            numNewerVersions_ = 0;
            onChanged();
            return this;
          }

          private com.google.protobuf.LazyStringArrayList matchesStorageClass_ =
              com.google.protobuf.LazyStringArrayList.emptyList();

          private void ensureMatchesStorageClassIsMutable() {
            if (!matchesStorageClass_.isModifiable()) {
              matchesStorageClass_ =
                  new com.google.protobuf.LazyStringArrayList(matchesStorageClass_);
            }
            bitField0_ |= 0x00000010;
          }

          /**
           *
           *
           * <pre>
           * Optional. Objects having any of the storage classes specified by this
           * condition will be matched. Values include `MULTI_REGIONAL`,
           * `REGIONAL`, `NEARLINE`, `COLDLINE`, `STANDARD`, and
           * `DURABLE_REDUCED_AVAILABILITY`.
           * </pre>
           *
           * <code>
           * repeated string matches_storage_class = 5 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return A list containing the matchesStorageClass.
           */
          public com.google.protobuf.ProtocolStringList getMatchesStorageClassList() {
            matchesStorageClass_.makeImmutable();
            return matchesStorageClass_;
          }

          /**
           *
           *
           * <pre>
           * Optional. Objects having any of the storage classes specified by this
           * condition will be matched. Values include `MULTI_REGIONAL`,
           * `REGIONAL`, `NEARLINE`, `COLDLINE`, `STANDARD`, and
           * `DURABLE_REDUCED_AVAILABILITY`.
           * </pre>
           *
           * <code>
           * repeated string matches_storage_class = 5 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return The count of matchesStorageClass.
           */
          public int getMatchesStorageClassCount() {
            return matchesStorageClass_.size();
          }

          /**
           *
           *
           * <pre>
           * Optional. Objects having any of the storage classes specified by this
           * condition will be matched. Values include `MULTI_REGIONAL`,
           * `REGIONAL`, `NEARLINE`, `COLDLINE`, `STANDARD`, and
           * `DURABLE_REDUCED_AVAILABILITY`.
           * </pre>
           *
           * <code>
           * repeated string matches_storage_class = 5 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @param index The index of the element to return.
           * @return The matchesStorageClass at the given index.
           */
          public java.lang.String getMatchesStorageClass(int index) {
            return matchesStorageClass_.get(index);
          }

          /**
           *
           *
           * <pre>
           * Optional. Objects having any of the storage classes specified by this
           * condition will be matched. Values include `MULTI_REGIONAL`,
           * `REGIONAL`, `NEARLINE`, `COLDLINE`, `STANDARD`, and
           * `DURABLE_REDUCED_AVAILABILITY`.
           * </pre>
           *
           * <code>
           * repeated string matches_storage_class = 5 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @param index The index of the value to return.
           * @return The bytes of the matchesStorageClass at the given index.
           */
          public com.google.protobuf.ByteString getMatchesStorageClassBytes(int index) {
            return matchesStorageClass_.getByteString(index);
          }

          /**
           *
           *
           * <pre>
           * Optional. Objects having any of the storage classes specified by this
           * condition will be matched. Values include `MULTI_REGIONAL`,
           * `REGIONAL`, `NEARLINE`, `COLDLINE`, `STANDARD`, and
           * `DURABLE_REDUCED_AVAILABILITY`.
           * </pre>
           *
           * <code>
           * repeated string matches_storage_class = 5 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @param index The index to set the value at.
           * @param value The matchesStorageClass to set.
           * @return This builder for chaining.
           */
          public Builder setMatchesStorageClass(int index, java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureMatchesStorageClassIsMutable();
            matchesStorageClass_.set(index, value);
            bitField0_ |= 0x00000010;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. Objects having any of the storage classes specified by this
           * condition will be matched. Values include `MULTI_REGIONAL`,
           * `REGIONAL`, `NEARLINE`, `COLDLINE`, `STANDARD`, and
           * `DURABLE_REDUCED_AVAILABILITY`.
           * </pre>
           *
           * <code>
           * repeated string matches_storage_class = 5 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @param value The matchesStorageClass to add.
           * @return This builder for chaining.
           */
          public Builder addMatchesStorageClass(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureMatchesStorageClassIsMutable();
            matchesStorageClass_.add(value);
            bitField0_ |= 0x00000010;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. Objects having any of the storage classes specified by this
           * condition will be matched. Values include `MULTI_REGIONAL`,
           * `REGIONAL`, `NEARLINE`, `COLDLINE`, `STANDARD`, and
           * `DURABLE_REDUCED_AVAILABILITY`.
           * </pre>
           *
           * <code>
           * repeated string matches_storage_class = 5 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @param values The matchesStorageClass to add.
           * @return This builder for chaining.
           */
          public Builder addAllMatchesStorageClass(java.lang.Iterable<java.lang.String> values) {
            ensureMatchesStorageClassIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, matchesStorageClass_);
            bitField0_ |= 0x00000010;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. Objects having any of the storage classes specified by this
           * condition will be matched. Values include `MULTI_REGIONAL`,
           * `REGIONAL`, `NEARLINE`, `COLDLINE`, `STANDARD`, and
           * `DURABLE_REDUCED_AVAILABILITY`.
           * </pre>
           *
           * <code>
           * repeated string matches_storage_class = 5 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return This builder for chaining.
           */
          public Builder clearMatchesStorageClass() {
            matchesStorageClass_ = com.google.protobuf.LazyStringArrayList.emptyList();
            bitField0_ = (bitField0_ & ~0x00000010);
            ;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. Objects having any of the storage classes specified by this
           * condition will be matched. Values include `MULTI_REGIONAL`,
           * `REGIONAL`, `NEARLINE`, `COLDLINE`, `STANDARD`, and
           * `DURABLE_REDUCED_AVAILABILITY`.
           * </pre>
           *
           * <code>
           * repeated string matches_storage_class = 5 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @param value The bytes of the matchesStorageClass to add.
           * @return This builder for chaining.
           */
          public Builder addMatchesStorageClassBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            ensureMatchesStorageClassIsMutable();
            matchesStorageClass_.add(value);
            bitField0_ |= 0x00000010;
            onChanged();
            return this;
          }

          private int daysSinceCustomTime_;

          /**
           *
           *
           * <pre>
           * Number of days that have elapsed since the custom timestamp set on an
           * object.
           * The value of the field must be a nonnegative integer.
           * </pre>
           *
           * <code>optional int32 days_since_custom_time = 7;</code>
           *
           * @return Whether the daysSinceCustomTime field is set.
           */
          @java.lang.Override
          public boolean hasDaysSinceCustomTime() {
            return ((bitField0_ & 0x00000020) != 0);
          }

          /**
           *
           *
           * <pre>
           * Number of days that have elapsed since the custom timestamp set on an
           * object.
           * The value of the field must be a nonnegative integer.
           * </pre>
           *
           * <code>optional int32 days_since_custom_time = 7;</code>
           *
           * @return The daysSinceCustomTime.
           */
          @java.lang.Override
          public int getDaysSinceCustomTime() {
            return daysSinceCustomTime_;
          }

          /**
           *
           *
           * <pre>
           * Number of days that have elapsed since the custom timestamp set on an
           * object.
           * The value of the field must be a nonnegative integer.
           * </pre>
           *
           * <code>optional int32 days_since_custom_time = 7;</code>
           *
           * @param value The daysSinceCustomTime to set.
           * @return This builder for chaining.
           */
          public Builder setDaysSinceCustomTime(int value) {

            daysSinceCustomTime_ = value;
            bitField0_ |= 0x00000020;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Number of days that have elapsed since the custom timestamp set on an
           * object.
           * The value of the field must be a nonnegative integer.
           * </pre>
           *
           * <code>optional int32 days_since_custom_time = 7;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearDaysSinceCustomTime() {
            bitField0_ = (bitField0_ & ~0x00000020);
            daysSinceCustomTime_ = 0;
            onChanged();
            return this;
          }

          private com.google.type.Date customTimeBefore_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
              customTimeBeforeBuilder_;

          /**
           *
           *
           * <pre>
           * Optional. An object matches this condition if the custom timestamp
           * set on the object is before the specified date in UTC.
           * </pre>
           *
           * <code>
           * .google.type.Date custom_time_before = 8 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return Whether the customTimeBefore field is set.
           */
          public boolean hasCustomTimeBefore() {
            return ((bitField0_ & 0x00000040) != 0);
          }

          /**
           *
           *
           * <pre>
           * Optional. An object matches this condition if the custom timestamp
           * set on the object is before the specified date in UTC.
           * </pre>
           *
           * <code>
           * .google.type.Date custom_time_before = 8 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return The customTimeBefore.
           */
          public com.google.type.Date getCustomTimeBefore() {
            if (customTimeBeforeBuilder_ == null) {
              return customTimeBefore_ == null
                  ? com.google.type.Date.getDefaultInstance()
                  : customTimeBefore_;
            } else {
              return customTimeBeforeBuilder_.getMessage();
            }
          }

          /**
           *
           *
           * <pre>
           * Optional. An object matches this condition if the custom timestamp
           * set on the object is before the specified date in UTC.
           * </pre>
           *
           * <code>
           * .google.type.Date custom_time_before = 8 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public Builder setCustomTimeBefore(com.google.type.Date value) {
            if (customTimeBeforeBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              customTimeBefore_ = value;
            } else {
              customTimeBeforeBuilder_.setMessage(value);
            }
            bitField0_ |= 0x00000040;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. An object matches this condition if the custom timestamp
           * set on the object is before the specified date in UTC.
           * </pre>
           *
           * <code>
           * .google.type.Date custom_time_before = 8 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public Builder setCustomTimeBefore(com.google.type.Date.Builder builderForValue) {
            if (customTimeBeforeBuilder_ == null) {
              customTimeBefore_ = builderForValue.build();
            } else {
              customTimeBeforeBuilder_.setMessage(builderForValue.build());
            }
            bitField0_ |= 0x00000040;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. An object matches this condition if the custom timestamp
           * set on the object is before the specified date in UTC.
           * </pre>
           *
           * <code>
           * .google.type.Date custom_time_before = 8 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public Builder mergeCustomTimeBefore(com.google.type.Date value) {
            if (customTimeBeforeBuilder_ == null) {
              if (((bitField0_ & 0x00000040) != 0)
                  && customTimeBefore_ != null
                  && customTimeBefore_ != com.google.type.Date.getDefaultInstance()) {
                getCustomTimeBeforeBuilder().mergeFrom(value);
              } else {
                customTimeBefore_ = value;
              }
            } else {
              customTimeBeforeBuilder_.mergeFrom(value);
            }
            if (customTimeBefore_ != null) {
              bitField0_ |= 0x00000040;
              onChanged();
            }
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. An object matches this condition if the custom timestamp
           * set on the object is before the specified date in UTC.
           * </pre>
           *
           * <code>
           * .google.type.Date custom_time_before = 8 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public Builder clearCustomTimeBefore() {
            bitField0_ = (bitField0_ & ~0x00000040);
            customTimeBefore_ = null;
            if (customTimeBeforeBuilder_ != null) {
              customTimeBeforeBuilder_.dispose();
              customTimeBeforeBuilder_ = null;
            }
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. An object matches this condition if the custom timestamp
           * set on the object is before the specified date in UTC.
           * </pre>
           *
           * <code>
           * .google.type.Date custom_time_before = 8 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public com.google.type.Date.Builder getCustomTimeBeforeBuilder() {
            bitField0_ |= 0x00000040;
            onChanged();
            return getCustomTimeBeforeFieldBuilder().getBuilder();
          }

          /**
           *
           *
           * <pre>
           * Optional. An object matches this condition if the custom timestamp
           * set on the object is before the specified date in UTC.
           * </pre>
           *
           * <code>
           * .google.type.Date custom_time_before = 8 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public com.google.type.DateOrBuilder getCustomTimeBeforeOrBuilder() {
            if (customTimeBeforeBuilder_ != null) {
              return customTimeBeforeBuilder_.getMessageOrBuilder();
            } else {
              return customTimeBefore_ == null
                  ? com.google.type.Date.getDefaultInstance()
                  : customTimeBefore_;
            }
          }

          /**
           *
           *
           * <pre>
           * Optional. An object matches this condition if the custom timestamp
           * set on the object is before the specified date in UTC.
           * </pre>
           *
           * <code>
           * .google.type.Date custom_time_before = 8 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
              getCustomTimeBeforeFieldBuilder() {
            if (customTimeBeforeBuilder_ == null) {
              customTimeBeforeBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.type.Date,
                      com.google.type.Date.Builder,
                      com.google.type.DateOrBuilder>(
                      getCustomTimeBefore(), getParentForChildren(), isClean());
              customTimeBefore_ = null;
            }
            return customTimeBeforeBuilder_;
          }

          private int daysSinceNoncurrentTime_;

          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if these many days have been
           * passed since it became noncurrent. The value of the field must be a
           * nonnegative integer. If it's zero, the object version will become
           * eligible for Lifecycle action as soon as it becomes noncurrent.
           * </pre>
           *
           * <code>optional int32 days_since_noncurrent_time = 9;</code>
           *
           * @return Whether the daysSinceNoncurrentTime field is set.
           */
          @java.lang.Override
          public boolean hasDaysSinceNoncurrentTime() {
            return ((bitField0_ & 0x00000080) != 0);
          }

          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if these many days have been
           * passed since it became noncurrent. The value of the field must be a
           * nonnegative integer. If it's zero, the object version will become
           * eligible for Lifecycle action as soon as it becomes noncurrent.
           * </pre>
           *
           * <code>optional int32 days_since_noncurrent_time = 9;</code>
           *
           * @return The daysSinceNoncurrentTime.
           */
          @java.lang.Override
          public int getDaysSinceNoncurrentTime() {
            return daysSinceNoncurrentTime_;
          }

          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if these many days have been
           * passed since it became noncurrent. The value of the field must be a
           * nonnegative integer. If it's zero, the object version will become
           * eligible for Lifecycle action as soon as it becomes noncurrent.
           * </pre>
           *
           * <code>optional int32 days_since_noncurrent_time = 9;</code>
           *
           * @param value The daysSinceNoncurrentTime to set.
           * @return This builder for chaining.
           */
          public Builder setDaysSinceNoncurrentTime(int value) {

            daysSinceNoncurrentTime_ = value;
            bitField0_ |= 0x00000080;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * This condition is relevant only for versioned objects. An object
           * version satisfies this condition only if these many days have been
           * passed since it became noncurrent. The value of the field must be a
           * nonnegative integer. If it's zero, the object version will become
           * eligible for Lifecycle action as soon as it becomes noncurrent.
           * </pre>
           *
           * <code>optional int32 days_since_noncurrent_time = 9;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearDaysSinceNoncurrentTime() {
            bitField0_ = (bitField0_ & ~0x00000080);
            daysSinceNoncurrentTime_ = 0;
            onChanged();
            return this;
          }

          private com.google.type.Date noncurrentTimeBefore_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
              noncurrentTimeBeforeBuilder_;

          /**
           *
           *
           * <pre>
           * Optional. This condition is relevant only for versioned objects. An
           * object version satisfies this condition only if it became noncurrent
           * before the specified date in UTC.
           * </pre>
           *
           * <code>
           * .google.type.Date noncurrent_time_before = 10 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return Whether the noncurrentTimeBefore field is set.
           */
          public boolean hasNoncurrentTimeBefore() {
            return ((bitField0_ & 0x00000100) != 0);
          }

          /**
           *
           *
           * <pre>
           * Optional. This condition is relevant only for versioned objects. An
           * object version satisfies this condition only if it became noncurrent
           * before the specified date in UTC.
           * </pre>
           *
           * <code>
           * .google.type.Date noncurrent_time_before = 10 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return The noncurrentTimeBefore.
           */
          public com.google.type.Date getNoncurrentTimeBefore() {
            if (noncurrentTimeBeforeBuilder_ == null) {
              return noncurrentTimeBefore_ == null
                  ? com.google.type.Date.getDefaultInstance()
                  : noncurrentTimeBefore_;
            } else {
              return noncurrentTimeBeforeBuilder_.getMessage();
            }
          }

          /**
           *
           *
           * <pre>
           * Optional. This condition is relevant only for versioned objects. An
           * object version satisfies this condition only if it became noncurrent
           * before the specified date in UTC.
           * </pre>
           *
           * <code>
           * .google.type.Date noncurrent_time_before = 10 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public Builder setNoncurrentTimeBefore(com.google.type.Date value) {
            if (noncurrentTimeBeforeBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              noncurrentTimeBefore_ = value;
            } else {
              noncurrentTimeBeforeBuilder_.setMessage(value);
            }
            bitField0_ |= 0x00000100;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. This condition is relevant only for versioned objects. An
           * object version satisfies this condition only if it became noncurrent
           * before the specified date in UTC.
           * </pre>
           *
           * <code>
           * .google.type.Date noncurrent_time_before = 10 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public Builder setNoncurrentTimeBefore(com.google.type.Date.Builder builderForValue) {
            if (noncurrentTimeBeforeBuilder_ == null) {
              noncurrentTimeBefore_ = builderForValue.build();
            } else {
              noncurrentTimeBeforeBuilder_.setMessage(builderForValue.build());
            }
            bitField0_ |= 0x00000100;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. This condition is relevant only for versioned objects. An
           * object version satisfies this condition only if it became noncurrent
           * before the specified date in UTC.
           * </pre>
           *
           * <code>
           * .google.type.Date noncurrent_time_before = 10 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public Builder mergeNoncurrentTimeBefore(com.google.type.Date value) {
            if (noncurrentTimeBeforeBuilder_ == null) {
              if (((bitField0_ & 0x00000100) != 0)
                  && noncurrentTimeBefore_ != null
                  && noncurrentTimeBefore_ != com.google.type.Date.getDefaultInstance()) {
                getNoncurrentTimeBeforeBuilder().mergeFrom(value);
              } else {
                noncurrentTimeBefore_ = value;
              }
            } else {
              noncurrentTimeBeforeBuilder_.mergeFrom(value);
            }
            if (noncurrentTimeBefore_ != null) {
              bitField0_ |= 0x00000100;
              onChanged();
            }
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. This condition is relevant only for versioned objects. An
           * object version satisfies this condition only if it became noncurrent
           * before the specified date in UTC.
           * </pre>
           *
           * <code>
           * .google.type.Date noncurrent_time_before = 10 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public Builder clearNoncurrentTimeBefore() {
            bitField0_ = (bitField0_ & ~0x00000100);
            noncurrentTimeBefore_ = null;
            if (noncurrentTimeBeforeBuilder_ != null) {
              noncurrentTimeBeforeBuilder_.dispose();
              noncurrentTimeBeforeBuilder_ = null;
            }
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. This condition is relevant only for versioned objects. An
           * object version satisfies this condition only if it became noncurrent
           * before the specified date in UTC.
           * </pre>
           *
           * <code>
           * .google.type.Date noncurrent_time_before = 10 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public com.google.type.Date.Builder getNoncurrentTimeBeforeBuilder() {
            bitField0_ |= 0x00000100;
            onChanged();
            return getNoncurrentTimeBeforeFieldBuilder().getBuilder();
          }

          /**
           *
           *
           * <pre>
           * Optional. This condition is relevant only for versioned objects. An
           * object version satisfies this condition only if it became noncurrent
           * before the specified date in UTC.
           * </pre>
           *
           * <code>
           * .google.type.Date noncurrent_time_before = 10 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          public com.google.type.DateOrBuilder getNoncurrentTimeBeforeOrBuilder() {
            if (noncurrentTimeBeforeBuilder_ != null) {
              return noncurrentTimeBeforeBuilder_.getMessageOrBuilder();
            } else {
              return noncurrentTimeBefore_ == null
                  ? com.google.type.Date.getDefaultInstance()
                  : noncurrentTimeBefore_;
            }
          }

          /**
           *
           *
           * <pre>
           * Optional. This condition is relevant only for versioned objects. An
           * object version satisfies this condition only if it became noncurrent
           * before the specified date in UTC.
           * </pre>
           *
           * <code>
           * .google.type.Date noncurrent_time_before = 10 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
              getNoncurrentTimeBeforeFieldBuilder() {
            if (noncurrentTimeBeforeBuilder_ == null) {
              noncurrentTimeBeforeBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.type.Date,
                      com.google.type.Date.Builder,
                      com.google.type.DateOrBuilder>(
                      getNoncurrentTimeBefore(), getParentForChildren(), isClean());
              noncurrentTimeBefore_ = null;
            }
            return noncurrentTimeBeforeBuilder_;
          }

          private com.google.protobuf.LazyStringArrayList matchesPrefix_ =
              com.google.protobuf.LazyStringArrayList.emptyList();

          private void ensureMatchesPrefixIsMutable() {
            if (!matchesPrefix_.isModifiable()) {
              matchesPrefix_ = new com.google.protobuf.LazyStringArrayList(matchesPrefix_);
            }
            bitField0_ |= 0x00000200;
          }

          /**
           *
           *
           * <pre>
           * Optional. List of object name prefixes. If any prefix exactly matches
           * the beginning of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_prefix = 11 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return A list containing the matchesPrefix.
           */
          public com.google.protobuf.ProtocolStringList getMatchesPrefixList() {
            matchesPrefix_.makeImmutable();
            return matchesPrefix_;
          }

          /**
           *
           *
           * <pre>
           * Optional. List of object name prefixes. If any prefix exactly matches
           * the beginning of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_prefix = 11 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return The count of matchesPrefix.
           */
          public int getMatchesPrefixCount() {
            return matchesPrefix_.size();
          }

          /**
           *
           *
           * <pre>
           * Optional. List of object name prefixes. If any prefix exactly matches
           * the beginning of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_prefix = 11 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @param index The index of the element to return.
           * @return The matchesPrefix at the given index.
           */
          public java.lang.String getMatchesPrefix(int index) {
            return matchesPrefix_.get(index);
          }

          /**
           *
           *
           * <pre>
           * Optional. List of object name prefixes. If any prefix exactly matches
           * the beginning of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_prefix = 11 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @param index The index of the value to return.
           * @return The bytes of the matchesPrefix at the given index.
           */
          public com.google.protobuf.ByteString getMatchesPrefixBytes(int index) {
            return matchesPrefix_.getByteString(index);
          }

          /**
           *
           *
           * <pre>
           * Optional. List of object name prefixes. If any prefix exactly matches
           * the beginning of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_prefix = 11 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @param index The index to set the value at.
           * @param value The matchesPrefix to set.
           * @return This builder for chaining.
           */
          public Builder setMatchesPrefix(int index, java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureMatchesPrefixIsMutable();
            matchesPrefix_.set(index, value);
            bitField0_ |= 0x00000200;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. List of object name prefixes. If any prefix exactly matches
           * the beginning of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_prefix = 11 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @param value The matchesPrefix to add.
           * @return This builder for chaining.
           */
          public Builder addMatchesPrefix(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureMatchesPrefixIsMutable();
            matchesPrefix_.add(value);
            bitField0_ |= 0x00000200;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. List of object name prefixes. If any prefix exactly matches
           * the beginning of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_prefix = 11 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @param values The matchesPrefix to add.
           * @return This builder for chaining.
           */
          public Builder addAllMatchesPrefix(java.lang.Iterable<java.lang.String> values) {
            ensureMatchesPrefixIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, matchesPrefix_);
            bitField0_ |= 0x00000200;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. List of object name prefixes. If any prefix exactly matches
           * the beginning of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_prefix = 11 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return This builder for chaining.
           */
          public Builder clearMatchesPrefix() {
            matchesPrefix_ = com.google.protobuf.LazyStringArrayList.emptyList();
            bitField0_ = (bitField0_ & ~0x00000200);
            ;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. List of object name prefixes. If any prefix exactly matches
           * the beginning of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_prefix = 11 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @param value The bytes of the matchesPrefix to add.
           * @return This builder for chaining.
           */
          public Builder addMatchesPrefixBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            ensureMatchesPrefixIsMutable();
            matchesPrefix_.add(value);
            bitField0_ |= 0x00000200;
            onChanged();
            return this;
          }

          private com.google.protobuf.LazyStringArrayList matchesSuffix_ =
              com.google.protobuf.LazyStringArrayList.emptyList();

          private void ensureMatchesSuffixIsMutable() {
            if (!matchesSuffix_.isModifiable()) {
              matchesSuffix_ = new com.google.protobuf.LazyStringArrayList(matchesSuffix_);
            }
            bitField0_ |= 0x00000400;
          }

          /**
           *
           *
           * <pre>
           * Optional. List of object name suffixes. If any suffix exactly matches
           * the end of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_suffix = 12 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return A list containing the matchesSuffix.
           */
          public com.google.protobuf.ProtocolStringList getMatchesSuffixList() {
            matchesSuffix_.makeImmutable();
            return matchesSuffix_;
          }

          /**
           *
           *
           * <pre>
           * Optional. List of object name suffixes. If any suffix exactly matches
           * the end of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_suffix = 12 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return The count of matchesSuffix.
           */
          public int getMatchesSuffixCount() {
            return matchesSuffix_.size();
          }

          /**
           *
           *
           * <pre>
           * Optional. List of object name suffixes. If any suffix exactly matches
           * the end of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_suffix = 12 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @param index The index of the element to return.
           * @return The matchesSuffix at the given index.
           */
          public java.lang.String getMatchesSuffix(int index) {
            return matchesSuffix_.get(index);
          }

          /**
           *
           *
           * <pre>
           * Optional. List of object name suffixes. If any suffix exactly matches
           * the end of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_suffix = 12 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @param index The index of the value to return.
           * @return The bytes of the matchesSuffix at the given index.
           */
          public com.google.protobuf.ByteString getMatchesSuffixBytes(int index) {
            return matchesSuffix_.getByteString(index);
          }

          /**
           *
           *
           * <pre>
           * Optional. List of object name suffixes. If any suffix exactly matches
           * the end of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_suffix = 12 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @param index The index to set the value at.
           * @param value The matchesSuffix to set.
           * @return This builder for chaining.
           */
          public Builder setMatchesSuffix(int index, java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureMatchesSuffixIsMutable();
            matchesSuffix_.set(index, value);
            bitField0_ |= 0x00000400;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. List of object name suffixes. If any suffix exactly matches
           * the end of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_suffix = 12 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @param value The matchesSuffix to add.
           * @return This builder for chaining.
           */
          public Builder addMatchesSuffix(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureMatchesSuffixIsMutable();
            matchesSuffix_.add(value);
            bitField0_ |= 0x00000400;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. List of object name suffixes. If any suffix exactly matches
           * the end of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_suffix = 12 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @param values The matchesSuffix to add.
           * @return This builder for chaining.
           */
          public Builder addAllMatchesSuffix(java.lang.Iterable<java.lang.String> values) {
            ensureMatchesSuffixIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, matchesSuffix_);
            bitField0_ |= 0x00000400;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. List of object name suffixes. If any suffix exactly matches
           * the end of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_suffix = 12 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return This builder for chaining.
           */
          public Builder clearMatchesSuffix() {
            matchesSuffix_ = com.google.protobuf.LazyStringArrayList.emptyList();
            bitField0_ = (bitField0_ & ~0x00000400);
            ;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. List of object name suffixes. If any suffix exactly matches
           * the end of the object name, the condition evaluates to true.
           * </pre>
           *
           * <code>repeated string matches_suffix = 12 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @param value The bytes of the matchesSuffix to add.
           * @return This builder for chaining.
           */
          public Builder addMatchesSuffixBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            ensureMatchesSuffixIsMutable();
            matchesSuffix_.add(value);
            bitField0_ |= 0x00000400;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Lifecycle.Rule.Condition)
        }

        // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Lifecycle.Rule.Condition)
        private static final com.google.storage.v2.Bucket.Lifecycle.Rule.Condition DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Lifecycle.Rule.Condition();
        }

        public static com.google.storage.v2.Bucket.Lifecycle.Rule.Condition getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Condition> PARSER =
            new com.google.protobuf.AbstractParser<Condition>() {
              @java.lang.Override
              public Condition parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<Condition> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Condition> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.Lifecycle.Rule.Condition getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int bitField0_;
      public static final int ACTION_FIELD_NUMBER = 1;
      private com.google.storage.v2.Bucket.Lifecycle.Rule.Action action_;

      /**
       *
       *
       * <pre>
       * Optional. The action to take.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the action field is set.
       */
      @java.lang.Override
      public boolean hasAction() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. The action to take.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The action.
       */
      @java.lang.Override
      public com.google.storage.v2.Bucket.Lifecycle.Rule.Action getAction() {
        return action_ == null
            ? com.google.storage.v2.Bucket.Lifecycle.Rule.Action.getDefaultInstance()
            : action_;
      }

      /**
       *
       *
       * <pre>
       * Optional. The action to take.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.storage.v2.Bucket.Lifecycle.Rule.ActionOrBuilder getActionOrBuilder() {
        return action_ == null
            ? com.google.storage.v2.Bucket.Lifecycle.Rule.Action.getDefaultInstance()
            : action_;
      }

      public static final int CONDITION_FIELD_NUMBER = 2;
      private com.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition_;

      /**
       *
       *
       * <pre>
       * Optional. The condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the condition field is set.
       */
      @java.lang.Override
      public boolean hasCondition() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. The condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The condition.
       */
      @java.lang.Override
      public com.google.storage.v2.Bucket.Lifecycle.Rule.Condition getCondition() {
        return condition_ == null
            ? com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.getDefaultInstance()
            : condition_;
      }

      /**
       *
       *
       * <pre>
       * Optional. The condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.storage.v2.Bucket.Lifecycle.Rule.ConditionOrBuilder
          getConditionOrBuilder() {
        return condition_ == null
            ? com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.getDefaultInstance()
            : condition_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getAction());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(2, getCondition());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getAction());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCondition());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.storage.v2.Bucket.Lifecycle.Rule)) {
          return super.equals(obj);
        }
        com.google.storage.v2.Bucket.Lifecycle.Rule other =
            (com.google.storage.v2.Bucket.Lifecycle.Rule) obj;

        if (hasAction() != other.hasAction()) return false;
        if (hasAction()) {
          if (!getAction().equals(other.getAction())) return false;
        }
        if (hasCondition() != other.hasCondition()) return false;
        if (hasCondition()) {
          if (!getCondition().equals(other.getCondition())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasAction()) {
          hash = (37 * hash) + ACTION_FIELD_NUMBER;
          hash = (53 * hash) + getAction().hashCode();
        }
        if (hasCondition()) {
          hash = (37 * hash) + CONDITION_FIELD_NUMBER;
          hash = (53 * hash) + getCondition().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(com.google.storage.v2.Bucket.Lifecycle.Rule prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * A lifecycle Rule, combining an action to take on an object and a
       * condition which will trigger that action.
       * </pre>
       *
       * Protobuf type {@code google.storage.v2.Bucket.Lifecycle.Rule}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Lifecycle.Rule)
          com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.storage.v2.Bucket.Lifecycle.Rule.class,
                  com.google.storage.v2.Bucket.Lifecycle.Rule.Builder.class);
        }

        // Construct using com.google.storage.v2.Bucket.Lifecycle.Rule.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getActionFieldBuilder();
            getConditionFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          action_ = null;
          if (actionBuilder_ != null) {
            actionBuilder_.dispose();
            actionBuilder_ = null;
          }
          condition_ = null;
          if (conditionBuilder_ != null) {
            conditionBuilder_.dispose();
            conditionBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_Lifecycle_Rule_descriptor;
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.Lifecycle.Rule getDefaultInstanceForType() {
          return com.google.storage.v2.Bucket.Lifecycle.Rule.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.Lifecycle.Rule build() {
          com.google.storage.v2.Bucket.Lifecycle.Rule result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.Lifecycle.Rule buildPartial() {
          com.google.storage.v2.Bucket.Lifecycle.Rule result =
              new com.google.storage.v2.Bucket.Lifecycle.Rule(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(com.google.storage.v2.Bucket.Lifecycle.Rule result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.action_ = actionBuilder_ == null ? action_ : actionBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.condition_ = conditionBuilder_ == null ? condition_ : conditionBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.storage.v2.Bucket.Lifecycle.Rule) {
            return mergeFrom((com.google.storage.v2.Bucket.Lifecycle.Rule) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.storage.v2.Bucket.Lifecycle.Rule other) {
          if (other == com.google.storage.v2.Bucket.Lifecycle.Rule.getDefaultInstance())
            return this;
          if (other.hasAction()) {
            mergeAction(other.getAction());
          }
          if (other.hasCondition()) {
            mergeCondition(other.getCondition());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getActionFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(getConditionFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.storage.v2.Bucket.Lifecycle.Rule.Action action_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.Lifecycle.Rule.Action,
                com.google.storage.v2.Bucket.Lifecycle.Rule.Action.Builder,
                com.google.storage.v2.Bucket.Lifecycle.Rule.ActionOrBuilder>
            actionBuilder_;

        /**
         *
         *
         * <pre>
         * Optional. The action to take.
         * </pre>
         *
         * <code>
         * .google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the action field is set.
         */
        public boolean hasAction() {
          return ((bitField0_ & 0x00000001) != 0);
        }

        /**
         *
         *
         * <pre>
         * Optional. The action to take.
         * </pre>
         *
         * <code>
         * .google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The action.
         */
        public com.google.storage.v2.Bucket.Lifecycle.Rule.Action getAction() {
          if (actionBuilder_ == null) {
            return action_ == null
                ? com.google.storage.v2.Bucket.Lifecycle.Rule.Action.getDefaultInstance()
                : action_;
          } else {
            return actionBuilder_.getMessage();
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The action to take.
         * </pre>
         *
         * <code>
         * .google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setAction(com.google.storage.v2.Bucket.Lifecycle.Rule.Action value) {
          if (actionBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            action_ = value;
          } else {
            actionBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The action to take.
         * </pre>
         *
         * <code>
         * .google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setAction(
            com.google.storage.v2.Bucket.Lifecycle.Rule.Action.Builder builderForValue) {
          if (actionBuilder_ == null) {
            action_ = builderForValue.build();
          } else {
            actionBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The action to take.
         * </pre>
         *
         * <code>
         * .google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder mergeAction(com.google.storage.v2.Bucket.Lifecycle.Rule.Action value) {
          if (actionBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && action_ != null
                && action_
                    != com.google.storage.v2.Bucket.Lifecycle.Rule.Action.getDefaultInstance()) {
              getActionBuilder().mergeFrom(value);
            } else {
              action_ = value;
            }
          } else {
            actionBuilder_.mergeFrom(value);
          }
          if (action_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The action to take.
         * </pre>
         *
         * <code>
         * .google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearAction() {
          bitField0_ = (bitField0_ & ~0x00000001);
          action_ = null;
          if (actionBuilder_ != null) {
            actionBuilder_.dispose();
            actionBuilder_ = null;
          }
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The action to take.
         * </pre>
         *
         * <code>
         * .google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.storage.v2.Bucket.Lifecycle.Rule.Action.Builder getActionBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getActionFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Optional. The action to take.
         * </pre>
         *
         * <code>
         * .google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.storage.v2.Bucket.Lifecycle.Rule.ActionOrBuilder getActionOrBuilder() {
          if (actionBuilder_ != null) {
            return actionBuilder_.getMessageOrBuilder();
          } else {
            return action_ == null
                ? com.google.storage.v2.Bucket.Lifecycle.Rule.Action.getDefaultInstance()
                : action_;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The action to take.
         * </pre>
         *
         * <code>
         * .google.storage.v2.Bucket.Lifecycle.Rule.Action action = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.Lifecycle.Rule.Action,
                com.google.storage.v2.Bucket.Lifecycle.Rule.Action.Builder,
                com.google.storage.v2.Bucket.Lifecycle.Rule.ActionOrBuilder>
            getActionFieldBuilder() {
          if (actionBuilder_ == null) {
            actionBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.storage.v2.Bucket.Lifecycle.Rule.Action,
                    com.google.storage.v2.Bucket.Lifecycle.Rule.Action.Builder,
                    com.google.storage.v2.Bucket.Lifecycle.Rule.ActionOrBuilder>(
                    getAction(), getParentForChildren(), isClean());
            action_ = null;
          }
          return actionBuilder_;
        }

        private com.google.storage.v2.Bucket.Lifecycle.Rule.Condition condition_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.Lifecycle.Rule.Condition,
                com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.Builder,
                com.google.storage.v2.Bucket.Lifecycle.Rule.ConditionOrBuilder>
            conditionBuilder_;

        /**
         *
         *
         * <pre>
         * Optional. The condition(s) under which the action will be taken.
         * </pre>
         *
         * <code>
         * .google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the condition field is set.
         */
        public boolean hasCondition() {
          return ((bitField0_ & 0x00000002) != 0);
        }

        /**
         *
         *
         * <pre>
         * Optional. The condition(s) under which the action will be taken.
         * </pre>
         *
         * <code>
         * .google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The condition.
         */
        public com.google.storage.v2.Bucket.Lifecycle.Rule.Condition getCondition() {
          if (conditionBuilder_ == null) {
            return condition_ == null
                ? com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.getDefaultInstance()
                : condition_;
          } else {
            return conditionBuilder_.getMessage();
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The condition(s) under which the action will be taken.
         * </pre>
         *
         * <code>
         * .google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setCondition(com.google.storage.v2.Bucket.Lifecycle.Rule.Condition value) {
          if (conditionBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            condition_ = value;
          } else {
            conditionBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The condition(s) under which the action will be taken.
         * </pre>
         *
         * <code>
         * .google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setCondition(
            com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.Builder builderForValue) {
          if (conditionBuilder_ == null) {
            condition_ = builderForValue.build();
          } else {
            conditionBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The condition(s) under which the action will be taken.
         * </pre>
         *
         * <code>
         * .google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder mergeCondition(com.google.storage.v2.Bucket.Lifecycle.Rule.Condition value) {
          if (conditionBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && condition_ != null
                && condition_
                    != com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.getDefaultInstance()) {
              getConditionBuilder().mergeFrom(value);
            } else {
              condition_ = value;
            }
          } else {
            conditionBuilder_.mergeFrom(value);
          }
          if (condition_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The condition(s) under which the action will be taken.
         * </pre>
         *
         * <code>
         * .google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearCondition() {
          bitField0_ = (bitField0_ & ~0x00000002);
          condition_ = null;
          if (conditionBuilder_ != null) {
            conditionBuilder_.dispose();
            conditionBuilder_ = null;
          }
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The condition(s) under which the action will be taken.
         * </pre>
         *
         * <code>
         * .google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.Builder getConditionBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getConditionFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Optional. The condition(s) under which the action will be taken.
         * </pre>
         *
         * <code>
         * .google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.storage.v2.Bucket.Lifecycle.Rule.ConditionOrBuilder
            getConditionOrBuilder() {
          if (conditionBuilder_ != null) {
            return conditionBuilder_.getMessageOrBuilder();
          } else {
            return condition_ == null
                ? com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.getDefaultInstance()
                : condition_;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The condition(s) under which the action will be taken.
         * </pre>
         *
         * <code>
         * .google.storage.v2.Bucket.Lifecycle.Rule.Condition condition = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket.Lifecycle.Rule.Condition,
                com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.Builder,
                com.google.storage.v2.Bucket.Lifecycle.Rule.ConditionOrBuilder>
            getConditionFieldBuilder() {
          if (conditionBuilder_ == null) {
            conditionBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.storage.v2.Bucket.Lifecycle.Rule.Condition,
                    com.google.storage.v2.Bucket.Lifecycle.Rule.Condition.Builder,
                    com.google.storage.v2.Bucket.Lifecycle.Rule.ConditionOrBuilder>(
                    getCondition(), getParentForChildren(), isClean());
            condition_ = null;
          }
          return conditionBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Lifecycle.Rule)
      }

      // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Lifecycle.Rule)
      private static final com.google.storage.v2.Bucket.Lifecycle.Rule DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Lifecycle.Rule();
      }

      public static com.google.storage.v2.Bucket.Lifecycle.Rule getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Rule> PARSER =
          new com.google.protobuf.AbstractParser<Rule>() {
            @java.lang.Override
            public Rule parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Rule> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Rule> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Lifecycle.Rule getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int RULE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.storage.v2.Bucket.Lifecycle.Rule> rule_;

    /**
     *
     *
     * <pre>
     * Optional. A lifecycle management rule, which is made of an action to take
     * and the condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.storage.v2.Bucket.Lifecycle.Rule> getRuleList() {
      return rule_;
    }

    /**
     *
     *
     * <pre>
     * Optional. A lifecycle management rule, which is made of an action to take
     * and the condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder>
        getRuleOrBuilderList() {
      return rule_;
    }

    /**
     *
     *
     * <pre>
     * Optional. A lifecycle management rule, which is made of an action to take
     * and the condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public int getRuleCount() {
      return rule_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. A lifecycle management rule, which is made of an action to take
     * and the condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.storage.v2.Bucket.Lifecycle.Rule getRule(int index) {
      return rule_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. A lifecycle management rule, which is made of an action to take
     * and the condition(s) under which the action will be taken.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder getRuleOrBuilder(int index) {
      return rule_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < rule_.size(); i++) {
        output.writeMessage(1, rule_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < rule_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, rule_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.Lifecycle)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.Lifecycle other = (com.google.storage.v2.Bucket.Lifecycle) obj;

      if (!getRuleList().equals(other.getRuleList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getRuleCount() > 0) {
        hash = (37 * hash) + RULE_FIELD_NUMBER;
        hash = (53 * hash) + getRuleList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Lifecycle parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.Lifecycle prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Lifecycle properties of a bucket.
     * For more information, see https://cloud.google.com/storage/docs/lifecycle.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.Lifecycle}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Lifecycle)
        com.google.storage.v2.Bucket.LifecycleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Lifecycle_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Lifecycle_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.Lifecycle.class,
                com.google.storage.v2.Bucket.Lifecycle.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.Lifecycle.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (ruleBuilder_ == null) {
          rule_ = java.util.Collections.emptyList();
        } else {
          rule_ = null;
          ruleBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Lifecycle_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Lifecycle getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.Lifecycle.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Lifecycle build() {
        com.google.storage.v2.Bucket.Lifecycle result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Lifecycle buildPartial() {
        com.google.storage.v2.Bucket.Lifecycle result =
            new com.google.storage.v2.Bucket.Lifecycle(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(com.google.storage.v2.Bucket.Lifecycle result) {
        if (ruleBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            rule_ = java.util.Collections.unmodifiableList(rule_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.rule_ = rule_;
        } else {
          result.rule_ = ruleBuilder_.build();
        }
      }

      private void buildPartial0(com.google.storage.v2.Bucket.Lifecycle result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.Lifecycle) {
          return mergeFrom((com.google.storage.v2.Bucket.Lifecycle) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.Lifecycle other) {
        if (other == com.google.storage.v2.Bucket.Lifecycle.getDefaultInstance()) return this;
        if (ruleBuilder_ == null) {
          if (!other.rule_.isEmpty()) {
            if (rule_.isEmpty()) {
              rule_ = other.rule_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureRuleIsMutable();
              rule_.addAll(other.rule_);
            }
            onChanged();
          }
        } else {
          if (!other.rule_.isEmpty()) {
            if (ruleBuilder_.isEmpty()) {
              ruleBuilder_.dispose();
              ruleBuilder_ = null;
              rule_ = other.rule_;
              bitField0_ = (bitField0_ & ~0x00000001);
              ruleBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getRuleFieldBuilder()
                      : null;
            } else {
              ruleBuilder_.addAllMessages(other.rule_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.storage.v2.Bucket.Lifecycle.Rule m =
                      input.readMessage(
                          com.google.storage.v2.Bucket.Lifecycle.Rule.parser(), extensionRegistry);
                  if (ruleBuilder_ == null) {
                    ensureRuleIsMutable();
                    rule_.add(m);
                  } else {
                    ruleBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.storage.v2.Bucket.Lifecycle.Rule> rule_ =
          java.util.Collections.emptyList();

      private void ensureRuleIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          rule_ = new java.util.ArrayList<com.google.storage.v2.Bucket.Lifecycle.Rule>(rule_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.storage.v2.Bucket.Lifecycle.Rule,
              com.google.storage.v2.Bucket.Lifecycle.Rule.Builder,
              com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder>
          ruleBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. A lifecycle management rule, which is made of an action to take
       * and the condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.storage.v2.Bucket.Lifecycle.Rule> getRuleList() {
        if (ruleBuilder_ == null) {
          return java.util.Collections.unmodifiableList(rule_);
        } else {
          return ruleBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. A lifecycle management rule, which is made of an action to take
       * and the condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public int getRuleCount() {
        if (ruleBuilder_ == null) {
          return rule_.size();
        } else {
          return ruleBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. A lifecycle management rule, which is made of an action to take
       * and the condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.storage.v2.Bucket.Lifecycle.Rule getRule(int index) {
        if (ruleBuilder_ == null) {
          return rule_.get(index);
        } else {
          return ruleBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. A lifecycle management rule, which is made of an action to take
       * and the condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setRule(int index, com.google.storage.v2.Bucket.Lifecycle.Rule value) {
        if (ruleBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRuleIsMutable();
          rule_.set(index, value);
          onChanged();
        } else {
          ruleBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. A lifecycle management rule, which is made of an action to take
       * and the condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setRule(
          int index, com.google.storage.v2.Bucket.Lifecycle.Rule.Builder builderForValue) {
        if (ruleBuilder_ == null) {
          ensureRuleIsMutable();
          rule_.set(index, builderForValue.build());
          onChanged();
        } else {
          ruleBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. A lifecycle management rule, which is made of an action to take
       * and the condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addRule(com.google.storage.v2.Bucket.Lifecycle.Rule value) {
        if (ruleBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRuleIsMutable();
          rule_.add(value);
          onChanged();
        } else {
          ruleBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. A lifecycle management rule, which is made of an action to take
       * and the condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addRule(int index, com.google.storage.v2.Bucket.Lifecycle.Rule value) {
        if (ruleBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRuleIsMutable();
          rule_.add(index, value);
          onChanged();
        } else {
          ruleBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. A lifecycle management rule, which is made of an action to take
       * and the condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addRule(com.google.storage.v2.Bucket.Lifecycle.Rule.Builder builderForValue) {
        if (ruleBuilder_ == null) {
          ensureRuleIsMutable();
          rule_.add(builderForValue.build());
          onChanged();
        } else {
          ruleBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. A lifecycle management rule, which is made of an action to take
       * and the condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addRule(
          int index, com.google.storage.v2.Bucket.Lifecycle.Rule.Builder builderForValue) {
        if (ruleBuilder_ == null) {
          ensureRuleIsMutable();
          rule_.add(index, builderForValue.build());
          onChanged();
        } else {
          ruleBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. A lifecycle management rule, which is made of an action to take
       * and the condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAllRule(
          java.lang.Iterable<? extends com.google.storage.v2.Bucket.Lifecycle.Rule> values) {
        if (ruleBuilder_ == null) {
          ensureRuleIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, rule_);
          onChanged();
        } else {
          ruleBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. A lifecycle management rule, which is made of an action to take
       * and the condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearRule() {
        if (ruleBuilder_ == null) {
          rule_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          ruleBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. A lifecycle management rule, which is made of an action to take
       * and the condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeRule(int index) {
        if (ruleBuilder_ == null) {
          ensureRuleIsMutable();
          rule_.remove(index);
          onChanged();
        } else {
          ruleBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. A lifecycle management rule, which is made of an action to take
       * and the condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.storage.v2.Bucket.Lifecycle.Rule.Builder getRuleBuilder(int index) {
        return getRuleFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. A lifecycle management rule, which is made of an action to take
       * and the condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder getRuleOrBuilder(int index) {
        if (ruleBuilder_ == null) {
          return rule_.get(index);
        } else {
          return ruleBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. A lifecycle management rule, which is made of an action to take
       * and the condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<? extends com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder>
          getRuleOrBuilderList() {
        if (ruleBuilder_ != null) {
          return ruleBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(rule_);
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. A lifecycle management rule, which is made of an action to take
       * and the condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.storage.v2.Bucket.Lifecycle.Rule.Builder addRuleBuilder() {
        return getRuleFieldBuilder()
            .addBuilder(com.google.storage.v2.Bucket.Lifecycle.Rule.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Optional. A lifecycle management rule, which is made of an action to take
       * and the condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.storage.v2.Bucket.Lifecycle.Rule.Builder addRuleBuilder(int index) {
        return getRuleFieldBuilder()
            .addBuilder(index, com.google.storage.v2.Bucket.Lifecycle.Rule.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Optional. A lifecycle management rule, which is made of an action to take
       * and the condition(s) under which the action will be taken.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.Lifecycle.Rule rule = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.storage.v2.Bucket.Lifecycle.Rule.Builder>
          getRuleBuilderList() {
        return getRuleFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.storage.v2.Bucket.Lifecycle.Rule,
              com.google.storage.v2.Bucket.Lifecycle.Rule.Builder,
              com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder>
          getRuleFieldBuilder() {
        if (ruleBuilder_ == null) {
          ruleBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.storage.v2.Bucket.Lifecycle.Rule,
                  com.google.storage.v2.Bucket.Lifecycle.Rule.Builder,
                  com.google.storage.v2.Bucket.Lifecycle.RuleOrBuilder>(
                  rule_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          rule_ = null;
        }
        return ruleBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Lifecycle)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Lifecycle)
    private static final com.google.storage.v2.Bucket.Lifecycle DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Lifecycle();
    }

    public static com.google.storage.v2.Bucket.Lifecycle getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Lifecycle> PARSER =
        new com.google.protobuf.AbstractParser<Lifecycle>() {
          @java.lang.Override
          public Lifecycle parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Lifecycle> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Lifecycle> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.Lifecycle getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface LoggingOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Logging)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. The destination bucket where the current bucket's logs should
     * be placed, using path format (like `projects/123456/buckets/foo`).
     * </pre>
     *
     * <code>string log_bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The logBucket.
     */
    java.lang.String getLogBucket();

    /**
     *
     *
     * <pre>
     * Optional. The destination bucket where the current bucket's logs should
     * be placed, using path format (like `projects/123456/buckets/foo`).
     * </pre>
     *
     * <code>string log_bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for logBucket.
     */
    com.google.protobuf.ByteString getLogBucketBytes();

    /**
     *
     *
     * <pre>
     * Optional. A prefix for log object names.
     * </pre>
     *
     * <code>string log_object_prefix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The logObjectPrefix.
     */
    java.lang.String getLogObjectPrefix();

    /**
     *
     *
     * <pre>
     * Optional. A prefix for log object names.
     * </pre>
     *
     * <code>string log_object_prefix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for logObjectPrefix.
     */
    com.google.protobuf.ByteString getLogObjectPrefixBytes();
  }

  /**
   *
   *
   * <pre>
   * Logging-related properties of a bucket.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.Logging}
   */
  public static final class Logging extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Logging)
      LoggingOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Logging.newBuilder() to construct.
    private Logging(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Logging() {
      logBucket_ = "";
      logObjectPrefix_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Logging();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Logging_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Logging_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.Logging.class,
              com.google.storage.v2.Bucket.Logging.Builder.class);
    }

    public static final int LOG_BUCKET_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object logBucket_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The destination bucket where the current bucket's logs should
     * be placed, using path format (like `projects/123456/buckets/foo`).
     * </pre>
     *
     * <code>string log_bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The logBucket.
     */
    @java.lang.Override
    public java.lang.String getLogBucket() {
      java.lang.Object ref = logBucket_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        logBucket_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The destination bucket where the current bucket's logs should
     * be placed, using path format (like `projects/123456/buckets/foo`).
     * </pre>
     *
     * <code>string log_bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for logBucket.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLogBucketBytes() {
      java.lang.Object ref = logBucket_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        logBucket_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LOG_OBJECT_PREFIX_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object logObjectPrefix_ = "";

    /**
     *
     *
     * <pre>
     * Optional. A prefix for log object names.
     * </pre>
     *
     * <code>string log_object_prefix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The logObjectPrefix.
     */
    @java.lang.Override
    public java.lang.String getLogObjectPrefix() {
      java.lang.Object ref = logObjectPrefix_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        logObjectPrefix_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A prefix for log object names.
     * </pre>
     *
     * <code>string log_object_prefix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for logObjectPrefix.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLogObjectPrefixBytes() {
      java.lang.Object ref = logObjectPrefix_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        logObjectPrefix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logBucket_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, logBucket_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logObjectPrefix_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, logObjectPrefix_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logBucket_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, logBucket_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logObjectPrefix_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, logObjectPrefix_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.Logging)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.Logging other = (com.google.storage.v2.Bucket.Logging) obj;

      if (!getLogBucket().equals(other.getLogBucket())) return false;
      if (!getLogObjectPrefix().equals(other.getLogObjectPrefix())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + LOG_BUCKET_FIELD_NUMBER;
      hash = (53 * hash) + getLogBucket().hashCode();
      hash = (37 * hash) + LOG_OBJECT_PREFIX_FIELD_NUMBER;
      hash = (53 * hash) + getLogObjectPrefix().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Logging parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Logging parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Logging parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.Logging prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Logging-related properties of a bucket.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.Logging}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Logging)
        com.google.storage.v2.Bucket.LoggingOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Logging_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Logging_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.Logging.class,
                com.google.storage.v2.Bucket.Logging.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.Logging.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        logBucket_ = "";
        logObjectPrefix_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Logging_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Logging getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.Logging.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Logging build() {
        com.google.storage.v2.Bucket.Logging result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Logging buildPartial() {
        com.google.storage.v2.Bucket.Logging result =
            new com.google.storage.v2.Bucket.Logging(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.storage.v2.Bucket.Logging result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.logBucket_ = logBucket_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.logObjectPrefix_ = logObjectPrefix_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.Logging) {
          return mergeFrom((com.google.storage.v2.Bucket.Logging) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.Logging other) {
        if (other == com.google.storage.v2.Bucket.Logging.getDefaultInstance()) return this;
        if (!other.getLogBucket().isEmpty()) {
          logBucket_ = other.logBucket_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getLogObjectPrefix().isEmpty()) {
          logObjectPrefix_ = other.logObjectPrefix_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  logBucket_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  logObjectPrefix_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object logBucket_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The destination bucket where the current bucket's logs should
       * be placed, using path format (like `projects/123456/buckets/foo`).
       * </pre>
       *
       * <code>string log_bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The logBucket.
       */
      public java.lang.String getLogBucket() {
        java.lang.Object ref = logBucket_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          logBucket_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The destination bucket where the current bucket's logs should
       * be placed, using path format (like `projects/123456/buckets/foo`).
       * </pre>
       *
       * <code>string log_bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for logBucket.
       */
      public com.google.protobuf.ByteString getLogBucketBytes() {
        java.lang.Object ref = logBucket_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          logBucket_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The destination bucket where the current bucket's logs should
       * be placed, using path format (like `projects/123456/buckets/foo`).
       * </pre>
       *
       * <code>string log_bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The logBucket to set.
       * @return This builder for chaining.
       */
      public Builder setLogBucket(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        logBucket_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The destination bucket where the current bucket's logs should
       * be placed, using path format (like `projects/123456/buckets/foo`).
       * </pre>
       *
       * <code>string log_bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLogBucket() {
        logBucket_ = getDefaultInstance().getLogBucket();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The destination bucket where the current bucket's logs should
       * be placed, using path format (like `projects/123456/buckets/foo`).
       * </pre>
       *
       * <code>string log_bucket = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for logBucket to set.
       * @return This builder for chaining.
       */
      public Builder setLogBucketBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        logBucket_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object logObjectPrefix_ = "";

      /**
       *
       *
       * <pre>
       * Optional. A prefix for log object names.
       * </pre>
       *
       * <code>string log_object_prefix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The logObjectPrefix.
       */
      public java.lang.String getLogObjectPrefix() {
        java.lang.Object ref = logObjectPrefix_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          logObjectPrefix_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. A prefix for log object names.
       * </pre>
       *
       * <code>string log_object_prefix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for logObjectPrefix.
       */
      public com.google.protobuf.ByteString getLogObjectPrefixBytes() {
        java.lang.Object ref = logObjectPrefix_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          logObjectPrefix_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. A prefix for log object names.
       * </pre>
       *
       * <code>string log_object_prefix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The logObjectPrefix to set.
       * @return This builder for chaining.
       */
      public Builder setLogObjectPrefix(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        logObjectPrefix_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. A prefix for log object names.
       * </pre>
       *
       * <code>string log_object_prefix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLogObjectPrefix() {
        logObjectPrefix_ = getDefaultInstance().getLogObjectPrefix();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. A prefix for log object names.
       * </pre>
       *
       * <code>string log_object_prefix = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for logObjectPrefix to set.
       * @return This builder for chaining.
       */
      public Builder setLogObjectPrefixBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        logObjectPrefix_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Logging)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Logging)
    private static final com.google.storage.v2.Bucket.Logging DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Logging();
    }

    public static com.google.storage.v2.Bucket.Logging getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Logging> PARSER =
        new com.google.protobuf.AbstractParser<Logging>() {
          @java.lang.Override
          public Logging parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Logging> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Logging> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.Logging getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ObjectRetentionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.ObjectRetention)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Output only. If true, object retention is enabled for the
     * bucket.
     * </pre>
     *
     * <code>
     * bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enabled.
     */
    boolean getEnabled();
  }

  /**
   *
   *
   * <pre>
   * Object Retention related properties of a bucket.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.ObjectRetention}
   */
  public static final class ObjectRetention extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.ObjectRetention)
      ObjectRetentionOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ObjectRetention.newBuilder() to construct.
    private ObjectRetention(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ObjectRetention() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ObjectRetention();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_ObjectRetention_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_ObjectRetention_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.ObjectRetention.class,
              com.google.storage.v2.Bucket.ObjectRetention.Builder.class);
    }

    public static final int ENABLED_FIELD_NUMBER = 1;
    private boolean enabled_ = false;

    /**
     *
     *
     * <pre>
     * Optional. Output only. If true, object retention is enabled for the
     * bucket.
     * </pre>
     *
     * <code>
     * bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enabled.
     */
    @java.lang.Override
    public boolean getEnabled() {
      return enabled_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (enabled_ != false) {
        output.writeBool(1, enabled_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (enabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enabled_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.ObjectRetention)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.ObjectRetention other =
          (com.google.storage.v2.Bucket.ObjectRetention) obj;

      if (getEnabled() != other.getEnabled()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnabled());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.ObjectRetention parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.ObjectRetention parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.ObjectRetention parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.ObjectRetention parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.ObjectRetention parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.ObjectRetention parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.ObjectRetention parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.ObjectRetention parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.ObjectRetention parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.ObjectRetention parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.ObjectRetention parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.ObjectRetention parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.ObjectRetention prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Object Retention related properties of a bucket.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.ObjectRetention}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.ObjectRetention)
        com.google.storage.v2.Bucket.ObjectRetentionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_ObjectRetention_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_ObjectRetention_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.ObjectRetention.class,
                com.google.storage.v2.Bucket.ObjectRetention.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.ObjectRetention.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        enabled_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_ObjectRetention_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.ObjectRetention getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.ObjectRetention.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.ObjectRetention build() {
        com.google.storage.v2.Bucket.ObjectRetention result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.ObjectRetention buildPartial() {
        com.google.storage.v2.Bucket.ObjectRetention result =
            new com.google.storage.v2.Bucket.ObjectRetention(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.storage.v2.Bucket.ObjectRetention result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.enabled_ = enabled_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.ObjectRetention) {
          return mergeFrom((com.google.storage.v2.Bucket.ObjectRetention) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.ObjectRetention other) {
        if (other == com.google.storage.v2.Bucket.ObjectRetention.getDefaultInstance()) return this;
        if (other.getEnabled() != false) {
          setEnabled(other.getEnabled());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  enabled_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean enabled_;

      /**
       *
       *
       * <pre>
       * Optional. Output only. If true, object retention is enabled for the
       * bucket.
       * </pre>
       *
       * <code>
       * bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enabled.
       */
      @java.lang.Override
      public boolean getEnabled() {
        return enabled_;
      }

      /**
       *
       *
       * <pre>
       * Optional. Output only. If true, object retention is enabled for the
       * bucket.
       * </pre>
       *
       * <code>
       * bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enabled to set.
       * @return This builder for chaining.
       */
      public Builder setEnabled(boolean value) {

        enabled_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Output only. If true, object retention is enabled for the
       * bucket.
       * </pre>
       *
       * <code>
       * bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnabled() {
        bitField0_ = (bitField0_ & ~0x00000001);
        enabled_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.ObjectRetention)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.ObjectRetention)
    private static final com.google.storage.v2.Bucket.ObjectRetention DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.ObjectRetention();
    }

    public static com.google.storage.v2.Bucket.ObjectRetention getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ObjectRetention> PARSER =
        new com.google.protobuf.AbstractParser<ObjectRetention>() {
          @java.lang.Override
          public ObjectRetention parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ObjectRetention> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ObjectRetention> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.ObjectRetention getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface RetentionPolicyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.RetentionPolicy)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Server-determined value that indicates the time from which
     * policy was enforced and effective.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp effective_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the effectiveTime field is set.
     */
    boolean hasEffectiveTime();

    /**
     *
     *
     * <pre>
     * Optional. Server-determined value that indicates the time from which
     * policy was enforced and effective.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp effective_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The effectiveTime.
     */
    com.google.protobuf.Timestamp getEffectiveTime();

    /**
     *
     *
     * <pre>
     * Optional. Server-determined value that indicates the time from which
     * policy was enforced and effective.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp effective_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getEffectiveTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Once locked, an object retention policy cannot be modified.
     * </pre>
     *
     * <code>bool is_locked = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The isLocked.
     */
    boolean getIsLocked();

    /**
     *
     *
     * <pre>
     * Optional. The duration that objects need to be retained. Retention
     * duration must be greater than zero and less than 100 years. Note that
     * enforcement of retention periods less than a day is not guaranteed. Such
     * periods should only be used for testing purposes. Any `nanos` value
     * specified will be rounded down to the nearest second.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration retention_duration = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the retentionDuration field is set.
     */
    boolean hasRetentionDuration();

    /**
     *
     *
     * <pre>
     * Optional. The duration that objects need to be retained. Retention
     * duration must be greater than zero and less than 100 years. Note that
     * enforcement of retention periods less than a day is not guaranteed. Such
     * periods should only be used for testing purposes. Any `nanos` value
     * specified will be rounded down to the nearest second.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration retention_duration = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The retentionDuration.
     */
    com.google.protobuf.Duration getRetentionDuration();

    /**
     *
     *
     * <pre>
     * Optional. The duration that objects need to be retained. Retention
     * duration must be greater than zero and less than 100 years. Note that
     * enforcement of retention periods less than a day is not guaranteed. Such
     * periods should only be used for testing purposes. Any `nanos` value
     * specified will be rounded down to the nearest second.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration retention_duration = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.protobuf.DurationOrBuilder getRetentionDurationOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * Retention policy properties of a bucket.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.RetentionPolicy}
   */
  public static final class RetentionPolicy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.RetentionPolicy)
      RetentionPolicyOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use RetentionPolicy.newBuilder() to construct.
    private RetentionPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RetentionPolicy() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RetentionPolicy();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_RetentionPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_RetentionPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.RetentionPolicy.class,
              com.google.storage.v2.Bucket.RetentionPolicy.Builder.class);
    }

    private int bitField0_;
    public static final int EFFECTIVE_TIME_FIELD_NUMBER = 1;
    private com.google.protobuf.Timestamp effectiveTime_;

    /**
     *
     *
     * <pre>
     * Optional. Server-determined value that indicates the time from which
     * policy was enforced and effective.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp effective_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the effectiveTime field is set.
     */
    @java.lang.Override
    public boolean hasEffectiveTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Server-determined value that indicates the time from which
     * policy was enforced and effective.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp effective_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The effectiveTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getEffectiveTime() {
      return effectiveTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : effectiveTime_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Server-determined value that indicates the time from which
     * policy was enforced and effective.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp effective_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getEffectiveTimeOrBuilder() {
      return effectiveTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : effectiveTime_;
    }

    public static final int IS_LOCKED_FIELD_NUMBER = 2;
    private boolean isLocked_ = false;

    /**
     *
     *
     * <pre>
     * Optional. Once locked, an object retention policy cannot be modified.
     * </pre>
     *
     * <code>bool is_locked = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The isLocked.
     */
    @java.lang.Override
    public boolean getIsLocked() {
      return isLocked_;
    }

    public static final int RETENTION_DURATION_FIELD_NUMBER = 4;
    private com.google.protobuf.Duration retentionDuration_;

    /**
     *
     *
     * <pre>
     * Optional. The duration that objects need to be retained. Retention
     * duration must be greater than zero and less than 100 years. Note that
     * enforcement of retention periods less than a day is not guaranteed. Such
     * periods should only be used for testing purposes. Any `nanos` value
     * specified will be rounded down to the nearest second.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration retention_duration = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the retentionDuration field is set.
     */
    @java.lang.Override
    public boolean hasRetentionDuration() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The duration that objects need to be retained. Retention
     * duration must be greater than zero and less than 100 years. Note that
     * enforcement of retention periods less than a day is not guaranteed. Such
     * periods should only be used for testing purposes. Any `nanos` value
     * specified will be rounded down to the nearest second.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration retention_duration = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The retentionDuration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getRetentionDuration() {
      return retentionDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : retentionDuration_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The duration that objects need to be retained. Retention
     * duration must be greater than zero and less than 100 years. Note that
     * enforcement of retention periods less than a day is not guaranteed. Such
     * periods should only be used for testing purposes. Any `nanos` value
     * specified will be rounded down to the nearest second.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration retention_duration = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getRetentionDurationOrBuilder() {
      return retentionDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : retentionDuration_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getEffectiveTime());
      }
      if (isLocked_ != false) {
        output.writeBool(2, isLocked_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(4, getRetentionDuration());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getEffectiveTime());
      }
      if (isLocked_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, isLocked_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getRetentionDuration());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.RetentionPolicy)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.RetentionPolicy other =
          (com.google.storage.v2.Bucket.RetentionPolicy) obj;

      if (hasEffectiveTime() != other.hasEffectiveTime()) return false;
      if (hasEffectiveTime()) {
        if (!getEffectiveTime().equals(other.getEffectiveTime())) return false;
      }
      if (getIsLocked() != other.getIsLocked()) return false;
      if (hasRetentionDuration() != other.hasRetentionDuration()) return false;
      if (hasRetentionDuration()) {
        if (!getRetentionDuration().equals(other.getRetentionDuration())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasEffectiveTime()) {
        hash = (37 * hash) + EFFECTIVE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getEffectiveTime().hashCode();
      }
      hash = (37 * hash) + IS_LOCKED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsLocked());
      if (hasRetentionDuration()) {
        hash = (37 * hash) + RETENTION_DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getRetentionDuration().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.RetentionPolicy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Retention policy properties of a bucket.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.RetentionPolicy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.RetentionPolicy)
        com.google.storage.v2.Bucket.RetentionPolicyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_RetentionPolicy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_RetentionPolicy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.RetentionPolicy.class,
                com.google.storage.v2.Bucket.RetentionPolicy.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.RetentionPolicy.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getEffectiveTimeFieldBuilder();
          getRetentionDurationFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        effectiveTime_ = null;
        if (effectiveTimeBuilder_ != null) {
          effectiveTimeBuilder_.dispose();
          effectiveTimeBuilder_ = null;
        }
        isLocked_ = false;
        retentionDuration_ = null;
        if (retentionDurationBuilder_ != null) {
          retentionDurationBuilder_.dispose();
          retentionDurationBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_RetentionPolicy_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.RetentionPolicy getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.RetentionPolicy.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.RetentionPolicy build() {
        com.google.storage.v2.Bucket.RetentionPolicy result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.RetentionPolicy buildPartial() {
        com.google.storage.v2.Bucket.RetentionPolicy result =
            new com.google.storage.v2.Bucket.RetentionPolicy(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.storage.v2.Bucket.RetentionPolicy result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.effectiveTime_ =
              effectiveTimeBuilder_ == null ? effectiveTime_ : effectiveTimeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.isLocked_ = isLocked_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.retentionDuration_ =
              retentionDurationBuilder_ == null
                  ? retentionDuration_
                  : retentionDurationBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.RetentionPolicy) {
          return mergeFrom((com.google.storage.v2.Bucket.RetentionPolicy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.RetentionPolicy other) {
        if (other == com.google.storage.v2.Bucket.RetentionPolicy.getDefaultInstance()) return this;
        if (other.hasEffectiveTime()) {
          mergeEffectiveTime(other.getEffectiveTime());
        }
        if (other.getIsLocked() != false) {
          setIsLocked(other.getIsLocked());
        }
        if (other.hasRetentionDuration()) {
          mergeRetentionDuration(other.getRetentionDuration());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getEffectiveTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  isLocked_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 34:
                {
                  input.readMessage(
                      getRetentionDurationFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Timestamp effectiveTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          effectiveTimeBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Server-determined value that indicates the time from which
       * policy was enforced and effective.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp effective_time = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the effectiveTime field is set.
       */
      public boolean hasEffectiveTime() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. Server-determined value that indicates the time from which
       * policy was enforced and effective.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp effective_time = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The effectiveTime.
       */
      public com.google.protobuf.Timestamp getEffectiveTime() {
        if (effectiveTimeBuilder_ == null) {
          return effectiveTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : effectiveTime_;
        } else {
          return effectiveTimeBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Server-determined value that indicates the time from which
       * policy was enforced and effective.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp effective_time = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setEffectiveTime(com.google.protobuf.Timestamp value) {
        if (effectiveTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          effectiveTime_ = value;
        } else {
          effectiveTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Server-determined value that indicates the time from which
       * policy was enforced and effective.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp effective_time = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setEffectiveTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (effectiveTimeBuilder_ == null) {
          effectiveTime_ = builderForValue.build();
        } else {
          effectiveTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Server-determined value that indicates the time from which
       * policy was enforced and effective.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp effective_time = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeEffectiveTime(com.google.protobuf.Timestamp value) {
        if (effectiveTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && effectiveTime_ != null
              && effectiveTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getEffectiveTimeBuilder().mergeFrom(value);
          } else {
            effectiveTime_ = value;
          }
        } else {
          effectiveTimeBuilder_.mergeFrom(value);
        }
        if (effectiveTime_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Server-determined value that indicates the time from which
       * policy was enforced and effective.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp effective_time = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearEffectiveTime() {
        bitField0_ = (bitField0_ & ~0x00000001);
        effectiveTime_ = null;
        if (effectiveTimeBuilder_ != null) {
          effectiveTimeBuilder_.dispose();
          effectiveTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Server-determined value that indicates the time from which
       * policy was enforced and effective.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp effective_time = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getEffectiveTimeBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getEffectiveTimeFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. Server-determined value that indicates the time from which
       * policy was enforced and effective.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp effective_time = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getEffectiveTimeOrBuilder() {
        if (effectiveTimeBuilder_ != null) {
          return effectiveTimeBuilder_.getMessageOrBuilder();
        } else {
          return effectiveTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : effectiveTime_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Server-determined value that indicates the time from which
       * policy was enforced and effective.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp effective_time = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getEffectiveTimeFieldBuilder() {
        if (effectiveTimeBuilder_ == null) {
          effectiveTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getEffectiveTime(), getParentForChildren(), isClean());
          effectiveTime_ = null;
        }
        return effectiveTimeBuilder_;
      }

      private boolean isLocked_;

      /**
       *
       *
       * <pre>
       * Optional. Once locked, an object retention policy cannot be modified.
       * </pre>
       *
       * <code>bool is_locked = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The isLocked.
       */
      @java.lang.Override
      public boolean getIsLocked() {
        return isLocked_;
      }

      /**
       *
       *
       * <pre>
       * Optional. Once locked, an object retention policy cannot be modified.
       * </pre>
       *
       * <code>bool is_locked = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The isLocked to set.
       * @return This builder for chaining.
       */
      public Builder setIsLocked(boolean value) {

        isLocked_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Once locked, an object retention policy cannot be modified.
       * </pre>
       *
       * <code>bool is_locked = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIsLocked() {
        bitField0_ = (bitField0_ & ~0x00000002);
        isLocked_ = false;
        onChanged();
        return this;
      }

      private com.google.protobuf.Duration retentionDuration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          retentionDurationBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. The duration that objects need to be retained. Retention
       * duration must be greater than zero and less than 100 years. Note that
       * enforcement of retention periods less than a day is not guaranteed. Such
       * periods should only be used for testing purposes. Any `nanos` value
       * specified will be rounded down to the nearest second.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration retention_duration = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the retentionDuration field is set.
       */
      public boolean hasRetentionDuration() {
        return ((bitField0_ & 0x00000004) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. The duration that objects need to be retained. Retention
       * duration must be greater than zero and less than 100 years. Note that
       * enforcement of retention periods less than a day is not guaranteed. Such
       * periods should only be used for testing purposes. Any `nanos` value
       * specified will be rounded down to the nearest second.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration retention_duration = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The retentionDuration.
       */
      public com.google.protobuf.Duration getRetentionDuration() {
        if (retentionDurationBuilder_ == null) {
          return retentionDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : retentionDuration_;
        } else {
          return retentionDurationBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The duration that objects need to be retained. Retention
       * duration must be greater than zero and less than 100 years. Note that
       * enforcement of retention periods less than a day is not guaranteed. Such
       * periods should only be used for testing purposes. Any `nanos` value
       * specified will be rounded down to the nearest second.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration retention_duration = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setRetentionDuration(com.google.protobuf.Duration value) {
        if (retentionDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          retentionDuration_ = value;
        } else {
          retentionDurationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The duration that objects need to be retained. Retention
       * duration must be greater than zero and less than 100 years. Note that
       * enforcement of retention periods less than a day is not guaranteed. Such
       * periods should only be used for testing purposes. Any `nanos` value
       * specified will be rounded down to the nearest second.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration retention_duration = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setRetentionDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (retentionDurationBuilder_ == null) {
          retentionDuration_ = builderForValue.build();
        } else {
          retentionDurationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The duration that objects need to be retained. Retention
       * duration must be greater than zero and less than 100 years. Note that
       * enforcement of retention periods less than a day is not guaranteed. Such
       * periods should only be used for testing purposes. Any `nanos` value
       * specified will be rounded down to the nearest second.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration retention_duration = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeRetentionDuration(com.google.protobuf.Duration value) {
        if (retentionDurationBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && retentionDuration_ != null
              && retentionDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
            getRetentionDurationBuilder().mergeFrom(value);
          } else {
            retentionDuration_ = value;
          }
        } else {
          retentionDurationBuilder_.mergeFrom(value);
        }
        if (retentionDuration_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The duration that objects need to be retained. Retention
       * duration must be greater than zero and less than 100 years. Note that
       * enforcement of retention periods less than a day is not guaranteed. Such
       * periods should only be used for testing purposes. Any `nanos` value
       * specified will be rounded down to the nearest second.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration retention_duration = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearRetentionDuration() {
        bitField0_ = (bitField0_ & ~0x00000004);
        retentionDuration_ = null;
        if (retentionDurationBuilder_ != null) {
          retentionDurationBuilder_.dispose();
          retentionDurationBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The duration that objects need to be retained. Retention
       * duration must be greater than zero and less than 100 years. Note that
       * enforcement of retention periods less than a day is not guaranteed. Such
       * periods should only be used for testing purposes. Any `nanos` value
       * specified will be rounded down to the nearest second.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration retention_duration = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.Duration.Builder getRetentionDurationBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getRetentionDurationFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. The duration that objects need to be retained. Retention
       * duration must be greater than zero and less than 100 years. Note that
       * enforcement of retention periods less than a day is not guaranteed. Such
       * periods should only be used for testing purposes. Any `nanos` value
       * specified will be rounded down to the nearest second.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration retention_duration = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.DurationOrBuilder getRetentionDurationOrBuilder() {
        if (retentionDurationBuilder_ != null) {
          return retentionDurationBuilder_.getMessageOrBuilder();
        } else {
          return retentionDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : retentionDuration_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The duration that objects need to be retained. Retention
       * duration must be greater than zero and less than 100 years. Note that
       * enforcement of retention periods less than a day is not guaranteed. Such
       * periods should only be used for testing purposes. Any `nanos` value
       * specified will be rounded down to the nearest second.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration retention_duration = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getRetentionDurationFieldBuilder() {
        if (retentionDurationBuilder_ == null) {
          retentionDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getRetentionDuration(), getParentForChildren(), isClean());
          retentionDuration_ = null;
        }
        return retentionDurationBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.RetentionPolicy)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.RetentionPolicy)
    private static final com.google.storage.v2.Bucket.RetentionPolicy DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.RetentionPolicy();
    }

    public static com.google.storage.v2.Bucket.RetentionPolicy getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RetentionPolicy> PARSER =
        new com.google.protobuf.AbstractParser<RetentionPolicy>() {
          @java.lang.Override
          public RetentionPolicy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<RetentionPolicy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RetentionPolicy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.RetentionPolicy getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SoftDeletePolicyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.SoftDeletePolicy)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The period of time that soft-deleted objects in the bucket must be
     * retained and cannot be permanently deleted. The duration must be greater
     * than or equal to 7 days and less than 1 year.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
     *
     * @return Whether the retentionDuration field is set.
     */
    boolean hasRetentionDuration();

    /**
     *
     *
     * <pre>
     * The period of time that soft-deleted objects in the bucket must be
     * retained and cannot be permanently deleted. The duration must be greater
     * than or equal to 7 days and less than 1 year.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
     *
     * @return The retentionDuration.
     */
    com.google.protobuf.Duration getRetentionDuration();

    /**
     *
     *
     * <pre>
     * The period of time that soft-deleted objects in the bucket must be
     * retained and cannot be permanently deleted. The duration must be greater
     * than or equal to 7 days and less than 1 year.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
     */
    com.google.protobuf.DurationOrBuilder getRetentionDurationOrBuilder();

    /**
     *
     *
     * <pre>
     * Time from which the policy was effective. This is service-provided.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
     *
     * @return Whether the effectiveTime field is set.
     */
    boolean hasEffectiveTime();

    /**
     *
     *
     * <pre>
     * Time from which the policy was effective. This is service-provided.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
     *
     * @return The effectiveTime.
     */
    com.google.protobuf.Timestamp getEffectiveTime();

    /**
     *
     *
     * <pre>
     * Time from which the policy was effective. This is service-provided.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
     */
    com.google.protobuf.TimestampOrBuilder getEffectiveTimeOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * Soft delete policy properties of a bucket.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.SoftDeletePolicy}
   */
  public static final class SoftDeletePolicy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.SoftDeletePolicy)
      SoftDeletePolicyOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use SoftDeletePolicy.newBuilder() to construct.
    private SoftDeletePolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SoftDeletePolicy() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SoftDeletePolicy();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_SoftDeletePolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_SoftDeletePolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.SoftDeletePolicy.class,
              com.google.storage.v2.Bucket.SoftDeletePolicy.Builder.class);
    }

    private int bitField0_;
    public static final int RETENTION_DURATION_FIELD_NUMBER = 1;
    private com.google.protobuf.Duration retentionDuration_;

    /**
     *
     *
     * <pre>
     * The period of time that soft-deleted objects in the bucket must be
     * retained and cannot be permanently deleted. The duration must be greater
     * than or equal to 7 days and less than 1 year.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
     *
     * @return Whether the retentionDuration field is set.
     */
    @java.lang.Override
    public boolean hasRetentionDuration() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The period of time that soft-deleted objects in the bucket must be
     * retained and cannot be permanently deleted. The duration must be greater
     * than or equal to 7 days and less than 1 year.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
     *
     * @return The retentionDuration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getRetentionDuration() {
      return retentionDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : retentionDuration_;
    }

    /**
     *
     *
     * <pre>
     * The period of time that soft-deleted objects in the bucket must be
     * retained and cannot be permanently deleted. The duration must be greater
     * than or equal to 7 days and less than 1 year.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getRetentionDurationOrBuilder() {
      return retentionDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : retentionDuration_;
    }

    public static final int EFFECTIVE_TIME_FIELD_NUMBER = 2;
    private com.google.protobuf.Timestamp effectiveTime_;

    /**
     *
     *
     * <pre>
     * Time from which the policy was effective. This is service-provided.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
     *
     * @return Whether the effectiveTime field is set.
     */
    @java.lang.Override
    public boolean hasEffectiveTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Time from which the policy was effective. This is service-provided.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
     *
     * @return The effectiveTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getEffectiveTime() {
      return effectiveTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : effectiveTime_;
    }

    /**
     *
     *
     * <pre>
     * Time from which the policy was effective. This is service-provided.
     * </pre>
     *
     * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getEffectiveTimeOrBuilder() {
      return effectiveTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : effectiveTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getRetentionDuration());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getEffectiveTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getRetentionDuration());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEffectiveTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.SoftDeletePolicy)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.SoftDeletePolicy other =
          (com.google.storage.v2.Bucket.SoftDeletePolicy) obj;

      if (hasRetentionDuration() != other.hasRetentionDuration()) return false;
      if (hasRetentionDuration()) {
        if (!getRetentionDuration().equals(other.getRetentionDuration())) return false;
      }
      if (hasEffectiveTime() != other.hasEffectiveTime()) return false;
      if (hasEffectiveTime()) {
        if (!getEffectiveTime().equals(other.getEffectiveTime())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasRetentionDuration()) {
        hash = (37 * hash) + RETENTION_DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getRetentionDuration().hashCode();
      }
      if (hasEffectiveTime()) {
        hash = (37 * hash) + EFFECTIVE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getEffectiveTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.SoftDeletePolicy parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.SoftDeletePolicy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.SoftDeletePolicy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.SoftDeletePolicy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.SoftDeletePolicy parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.SoftDeletePolicy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.SoftDeletePolicy parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.SoftDeletePolicy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.SoftDeletePolicy parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.SoftDeletePolicy parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.SoftDeletePolicy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.SoftDeletePolicy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.SoftDeletePolicy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Soft delete policy properties of a bucket.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.SoftDeletePolicy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.SoftDeletePolicy)
        com.google.storage.v2.Bucket.SoftDeletePolicyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_SoftDeletePolicy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_SoftDeletePolicy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.SoftDeletePolicy.class,
                com.google.storage.v2.Bucket.SoftDeletePolicy.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.SoftDeletePolicy.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getRetentionDurationFieldBuilder();
          getEffectiveTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        retentionDuration_ = null;
        if (retentionDurationBuilder_ != null) {
          retentionDurationBuilder_.dispose();
          retentionDurationBuilder_ = null;
        }
        effectiveTime_ = null;
        if (effectiveTimeBuilder_ != null) {
          effectiveTimeBuilder_.dispose();
          effectiveTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_SoftDeletePolicy_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.SoftDeletePolicy getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.SoftDeletePolicy.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.SoftDeletePolicy build() {
        com.google.storage.v2.Bucket.SoftDeletePolicy result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.SoftDeletePolicy buildPartial() {
        com.google.storage.v2.Bucket.SoftDeletePolicy result =
            new com.google.storage.v2.Bucket.SoftDeletePolicy(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.storage.v2.Bucket.SoftDeletePolicy result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.retentionDuration_ =
              retentionDurationBuilder_ == null
                  ? retentionDuration_
                  : retentionDurationBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.effectiveTime_ =
              effectiveTimeBuilder_ == null ? effectiveTime_ : effectiveTimeBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.SoftDeletePolicy) {
          return mergeFrom((com.google.storage.v2.Bucket.SoftDeletePolicy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.SoftDeletePolicy other) {
        if (other == com.google.storage.v2.Bucket.SoftDeletePolicy.getDefaultInstance())
          return this;
        if (other.hasRetentionDuration()) {
          mergeRetentionDuration(other.getRetentionDuration());
        }
        if (other.hasEffectiveTime()) {
          mergeEffectiveTime(other.getEffectiveTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getRetentionDurationFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getEffectiveTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Duration retentionDuration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          retentionDurationBuilder_;

      /**
       *
       *
       * <pre>
       * The period of time that soft-deleted objects in the bucket must be
       * retained and cannot be permanently deleted. The duration must be greater
       * than or equal to 7 days and less than 1 year.
       * </pre>
       *
       * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
       *
       * @return Whether the retentionDuration field is set.
       */
      public boolean hasRetentionDuration() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * The period of time that soft-deleted objects in the bucket must be
       * retained and cannot be permanently deleted. The duration must be greater
       * than or equal to 7 days and less than 1 year.
       * </pre>
       *
       * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
       *
       * @return The retentionDuration.
       */
      public com.google.protobuf.Duration getRetentionDuration() {
        if (retentionDurationBuilder_ == null) {
          return retentionDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : retentionDuration_;
        } else {
          return retentionDurationBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The period of time that soft-deleted objects in the bucket must be
       * retained and cannot be permanently deleted. The duration must be greater
       * than or equal to 7 days and less than 1 year.
       * </pre>
       *
       * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
       */
      public Builder setRetentionDuration(com.google.protobuf.Duration value) {
        if (retentionDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          retentionDuration_ = value;
        } else {
          retentionDurationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The period of time that soft-deleted objects in the bucket must be
       * retained and cannot be permanently deleted. The duration must be greater
       * than or equal to 7 days and less than 1 year.
       * </pre>
       *
       * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
       */
      public Builder setRetentionDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (retentionDurationBuilder_ == null) {
          retentionDuration_ = builderForValue.build();
        } else {
          retentionDurationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The period of time that soft-deleted objects in the bucket must be
       * retained and cannot be permanently deleted. The duration must be greater
       * than or equal to 7 days and less than 1 year.
       * </pre>
       *
       * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
       */
      public Builder mergeRetentionDuration(com.google.protobuf.Duration value) {
        if (retentionDurationBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && retentionDuration_ != null
              && retentionDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
            getRetentionDurationBuilder().mergeFrom(value);
          } else {
            retentionDuration_ = value;
          }
        } else {
          retentionDurationBuilder_.mergeFrom(value);
        }
        if (retentionDuration_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The period of time that soft-deleted objects in the bucket must be
       * retained and cannot be permanently deleted. The duration must be greater
       * than or equal to 7 days and less than 1 year.
       * </pre>
       *
       * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
       */
      public Builder clearRetentionDuration() {
        bitField0_ = (bitField0_ & ~0x00000001);
        retentionDuration_ = null;
        if (retentionDurationBuilder_ != null) {
          retentionDurationBuilder_.dispose();
          retentionDurationBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The period of time that soft-deleted objects in the bucket must be
       * retained and cannot be permanently deleted. The duration must be greater
       * than or equal to 7 days and less than 1 year.
       * </pre>
       *
       * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
       */
      public com.google.protobuf.Duration.Builder getRetentionDurationBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getRetentionDurationFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The period of time that soft-deleted objects in the bucket must be
       * retained and cannot be permanently deleted. The duration must be greater
       * than or equal to 7 days and less than 1 year.
       * </pre>
       *
       * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
       */
      public com.google.protobuf.DurationOrBuilder getRetentionDurationOrBuilder() {
        if (retentionDurationBuilder_ != null) {
          return retentionDurationBuilder_.getMessageOrBuilder();
        } else {
          return retentionDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : retentionDuration_;
        }
      }

      /**
       *
       *
       * <pre>
       * The period of time that soft-deleted objects in the bucket must be
       * retained and cannot be permanently deleted. The duration must be greater
       * than or equal to 7 days and less than 1 year.
       * </pre>
       *
       * <code>optional .google.protobuf.Duration retention_duration = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getRetentionDurationFieldBuilder() {
        if (retentionDurationBuilder_ == null) {
          retentionDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getRetentionDuration(), getParentForChildren(), isClean());
          retentionDuration_ = null;
        }
        return retentionDurationBuilder_;
      }

      private com.google.protobuf.Timestamp effectiveTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          effectiveTimeBuilder_;

      /**
       *
       *
       * <pre>
       * Time from which the policy was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       *
       * @return Whether the effectiveTime field is set.
       */
      public boolean hasEffectiveTime() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Time from which the policy was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       *
       * @return The effectiveTime.
       */
      public com.google.protobuf.Timestamp getEffectiveTime() {
        if (effectiveTimeBuilder_ == null) {
          return effectiveTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : effectiveTime_;
        } else {
          return effectiveTimeBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Time from which the policy was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       */
      public Builder setEffectiveTime(com.google.protobuf.Timestamp value) {
        if (effectiveTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          effectiveTime_ = value;
        } else {
          effectiveTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Time from which the policy was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       */
      public Builder setEffectiveTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (effectiveTimeBuilder_ == null) {
          effectiveTime_ = builderForValue.build();
        } else {
          effectiveTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Time from which the policy was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       */
      public Builder mergeEffectiveTime(com.google.protobuf.Timestamp value) {
        if (effectiveTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && effectiveTime_ != null
              && effectiveTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getEffectiveTimeBuilder().mergeFrom(value);
          } else {
            effectiveTime_ = value;
          }
        } else {
          effectiveTimeBuilder_.mergeFrom(value);
        }
        if (effectiveTime_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Time from which the policy was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       */
      public Builder clearEffectiveTime() {
        bitField0_ = (bitField0_ & ~0x00000002);
        effectiveTime_ = null;
        if (effectiveTimeBuilder_ != null) {
          effectiveTimeBuilder_.dispose();
          effectiveTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Time from which the policy was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       */
      public com.google.protobuf.Timestamp.Builder getEffectiveTimeBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getEffectiveTimeFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Time from which the policy was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getEffectiveTimeOrBuilder() {
        if (effectiveTimeBuilder_ != null) {
          return effectiveTimeBuilder_.getMessageOrBuilder();
        } else {
          return effectiveTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : effectiveTime_;
        }
      }

      /**
       *
       *
       * <pre>
       * Time from which the policy was effective. This is service-provided.
       * </pre>
       *
       * <code>optional .google.protobuf.Timestamp effective_time = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getEffectiveTimeFieldBuilder() {
        if (effectiveTimeBuilder_ == null) {
          effectiveTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getEffectiveTime(), getParentForChildren(), isClean());
          effectiveTime_ = null;
        }
        return effectiveTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.SoftDeletePolicy)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.SoftDeletePolicy)
    private static final com.google.storage.v2.Bucket.SoftDeletePolicy DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.SoftDeletePolicy();
    }

    public static com.google.storage.v2.Bucket.SoftDeletePolicy getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SoftDeletePolicy> PARSER =
        new com.google.protobuf.AbstractParser<SoftDeletePolicy>() {
          @java.lang.Override
          public SoftDeletePolicy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SoftDeletePolicy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SoftDeletePolicy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.SoftDeletePolicy getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface VersioningOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Versioning)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. While set to true, versioning is fully enabled for this bucket.
     * </pre>
     *
     * <code>bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enabled.
     */
    boolean getEnabled();
  }

  /**
   *
   *
   * <pre>
   * Properties of a bucket related to versioning.
   * For more on Cloud Storage versioning, see
   * https://cloud.google.com/storage/docs/object-versioning.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.Versioning}
   */
  public static final class Versioning extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Versioning)
      VersioningOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Versioning.newBuilder() to construct.
    private Versioning(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Versioning() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Versioning();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Versioning_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Versioning_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.Versioning.class,
              com.google.storage.v2.Bucket.Versioning.Builder.class);
    }

    public static final int ENABLED_FIELD_NUMBER = 1;
    private boolean enabled_ = false;

    /**
     *
     *
     * <pre>
     * Optional. While set to true, versioning is fully enabled for this bucket.
     * </pre>
     *
     * <code>bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enabled.
     */
    @java.lang.Override
    public boolean getEnabled() {
      return enabled_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (enabled_ != false) {
        output.writeBool(1, enabled_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (enabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enabled_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.Versioning)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.Versioning other = (com.google.storage.v2.Bucket.Versioning) obj;

      if (getEnabled() != other.getEnabled()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnabled());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Versioning parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Versioning parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Versioning parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.Versioning prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Properties of a bucket related to versioning.
     * For more on Cloud Storage versioning, see
     * https://cloud.google.com/storage/docs/object-versioning.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.Versioning}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Versioning)
        com.google.storage.v2.Bucket.VersioningOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Versioning_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Versioning_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.Versioning.class,
                com.google.storage.v2.Bucket.Versioning.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.Versioning.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        enabled_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Versioning_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Versioning getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.Versioning.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Versioning build() {
        com.google.storage.v2.Bucket.Versioning result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Versioning buildPartial() {
        com.google.storage.v2.Bucket.Versioning result =
            new com.google.storage.v2.Bucket.Versioning(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.storage.v2.Bucket.Versioning result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.enabled_ = enabled_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.Versioning) {
          return mergeFrom((com.google.storage.v2.Bucket.Versioning) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.Versioning other) {
        if (other == com.google.storage.v2.Bucket.Versioning.getDefaultInstance()) return this;
        if (other.getEnabled() != false) {
          setEnabled(other.getEnabled());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  enabled_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean enabled_;

      /**
       *
       *
       * <pre>
       * Optional. While set to true, versioning is fully enabled for this bucket.
       * </pre>
       *
       * <code>bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The enabled.
       */
      @java.lang.Override
      public boolean getEnabled() {
        return enabled_;
      }

      /**
       *
       *
       * <pre>
       * Optional. While set to true, versioning is fully enabled for this bucket.
       * </pre>
       *
       * <code>bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The enabled to set.
       * @return This builder for chaining.
       */
      public Builder setEnabled(boolean value) {

        enabled_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. While set to true, versioning is fully enabled for this bucket.
       * </pre>
       *
       * <code>bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnabled() {
        bitField0_ = (bitField0_ & ~0x00000001);
        enabled_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Versioning)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Versioning)
    private static final com.google.storage.v2.Bucket.Versioning DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Versioning();
    }

    public static com.google.storage.v2.Bucket.Versioning getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Versioning> PARSER =
        new com.google.protobuf.AbstractParser<Versioning>() {
          @java.lang.Override
          public Versioning parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Versioning> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Versioning> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.Versioning getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface WebsiteOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Website)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. If the requested object path is missing, the service will
     * ensure the path has a trailing '/', append this suffix, and attempt to
     * retrieve the resulting object. This allows the creation of `index.html`
     * objects to represent directory pages.
     * </pre>
     *
     * <code>string main_page_suffix = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The mainPageSuffix.
     */
    java.lang.String getMainPageSuffix();

    /**
     *
     *
     * <pre>
     * Optional. If the requested object path is missing, the service will
     * ensure the path has a trailing '/', append this suffix, and attempt to
     * retrieve the resulting object. This allows the creation of `index.html`
     * objects to represent directory pages.
     * </pre>
     *
     * <code>string main_page_suffix = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for mainPageSuffix.
     */
    com.google.protobuf.ByteString getMainPageSuffixBytes();

    /**
     *
     *
     * <pre>
     * Optional. If the requested object path is missing, and any
     * `mainPageSuffix` object is missing, if applicable, the service
     * will return the named object from this bucket as the content for a
     * [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
     * result.
     * </pre>
     *
     * <code>string not_found_page = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The notFoundPage.
     */
    java.lang.String getNotFoundPage();

    /**
     *
     *
     * <pre>
     * Optional. If the requested object path is missing, and any
     * `mainPageSuffix` object is missing, if applicable, the service
     * will return the named object from this bucket as the content for a
     * [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
     * result.
     * </pre>
     *
     * <code>string not_found_page = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for notFoundPage.
     */
    com.google.protobuf.ByteString getNotFoundPageBytes();
  }

  /**
   *
   *
   * <pre>
   * Properties of a bucket related to accessing the contents as a static
   * website. For more on hosting a static website via Cloud Storage, see
   * https://cloud.google.com/storage/docs/hosting-static-website.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.Website}
   */
  public static final class Website extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Website)
      WebsiteOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Website.newBuilder() to construct.
    private Website(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Website() {
      mainPageSuffix_ = "";
      notFoundPage_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Website();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Website_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Website_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.Website.class,
              com.google.storage.v2.Bucket.Website.Builder.class);
    }

    public static final int MAIN_PAGE_SUFFIX_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object mainPageSuffix_ = "";

    /**
     *
     *
     * <pre>
     * Optional. If the requested object path is missing, the service will
     * ensure the path has a trailing '/', append this suffix, and attempt to
     * retrieve the resulting object. This allows the creation of `index.html`
     * objects to represent directory pages.
     * </pre>
     *
     * <code>string main_page_suffix = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The mainPageSuffix.
     */
    @java.lang.Override
    public java.lang.String getMainPageSuffix() {
      java.lang.Object ref = mainPageSuffix_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        mainPageSuffix_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. If the requested object path is missing, the service will
     * ensure the path has a trailing '/', append this suffix, and attempt to
     * retrieve the resulting object. This allows the creation of `index.html`
     * objects to represent directory pages.
     * </pre>
     *
     * <code>string main_page_suffix = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for mainPageSuffix.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMainPageSuffixBytes() {
      java.lang.Object ref = mainPageSuffix_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        mainPageSuffix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NOT_FOUND_PAGE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object notFoundPage_ = "";

    /**
     *
     *
     * <pre>
     * Optional. If the requested object path is missing, and any
     * `mainPageSuffix` object is missing, if applicable, the service
     * will return the named object from this bucket as the content for a
     * [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
     * result.
     * </pre>
     *
     * <code>string not_found_page = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The notFoundPage.
     */
    @java.lang.Override
    public java.lang.String getNotFoundPage() {
      java.lang.Object ref = notFoundPage_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        notFoundPage_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. If the requested object path is missing, and any
     * `mainPageSuffix` object is missing, if applicable, the service
     * will return the named object from this bucket as the content for a
     * [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
     * result.
     * </pre>
     *
     * <code>string not_found_page = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for notFoundPage.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNotFoundPageBytes() {
      java.lang.Object ref = notFoundPage_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        notFoundPage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mainPageSuffix_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, mainPageSuffix_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(notFoundPage_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, notFoundPage_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mainPageSuffix_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, mainPageSuffix_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(notFoundPage_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, notFoundPage_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.Website)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.Website other = (com.google.storage.v2.Bucket.Website) obj;

      if (!getMainPageSuffix().equals(other.getMainPageSuffix())) return false;
      if (!getNotFoundPage().equals(other.getNotFoundPage())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MAIN_PAGE_SUFFIX_FIELD_NUMBER;
      hash = (53 * hash) + getMainPageSuffix().hashCode();
      hash = (37 * hash) + NOT_FOUND_PAGE_FIELD_NUMBER;
      hash = (53 * hash) + getNotFoundPage().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Website parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Website parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Website parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.Website prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Properties of a bucket related to accessing the contents as a static
     * website. For more on hosting a static website via Cloud Storage, see
     * https://cloud.google.com/storage/docs/hosting-static-website.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.Website}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Website)
        com.google.storage.v2.Bucket.WebsiteOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Website_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Website_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.Website.class,
                com.google.storage.v2.Bucket.Website.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.Website.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        mainPageSuffix_ = "";
        notFoundPage_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Website_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Website getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.Website.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Website build() {
        com.google.storage.v2.Bucket.Website result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Website buildPartial() {
        com.google.storage.v2.Bucket.Website result =
            new com.google.storage.v2.Bucket.Website(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.storage.v2.Bucket.Website result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.mainPageSuffix_ = mainPageSuffix_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.notFoundPage_ = notFoundPage_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.Website) {
          return mergeFrom((com.google.storage.v2.Bucket.Website) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.Website other) {
        if (other == com.google.storage.v2.Bucket.Website.getDefaultInstance()) return this;
        if (!other.getMainPageSuffix().isEmpty()) {
          mainPageSuffix_ = other.mainPageSuffix_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getNotFoundPage().isEmpty()) {
          notFoundPage_ = other.notFoundPage_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  mainPageSuffix_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  notFoundPage_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object mainPageSuffix_ = "";

      /**
       *
       *
       * <pre>
       * Optional. If the requested object path is missing, the service will
       * ensure the path has a trailing '/', append this suffix, and attempt to
       * retrieve the resulting object. This allows the creation of `index.html`
       * objects to represent directory pages.
       * </pre>
       *
       * <code>string main_page_suffix = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The mainPageSuffix.
       */
      public java.lang.String getMainPageSuffix() {
        java.lang.Object ref = mainPageSuffix_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          mainPageSuffix_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. If the requested object path is missing, the service will
       * ensure the path has a trailing '/', append this suffix, and attempt to
       * retrieve the resulting object. This allows the creation of `index.html`
       * objects to represent directory pages.
       * </pre>
       *
       * <code>string main_page_suffix = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for mainPageSuffix.
       */
      public com.google.protobuf.ByteString getMainPageSuffixBytes() {
        java.lang.Object ref = mainPageSuffix_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          mainPageSuffix_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. If the requested object path is missing, the service will
       * ensure the path has a trailing '/', append this suffix, and attempt to
       * retrieve the resulting object. This allows the creation of `index.html`
       * objects to represent directory pages.
       * </pre>
       *
       * <code>string main_page_suffix = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The mainPageSuffix to set.
       * @return This builder for chaining.
       */
      public Builder setMainPageSuffix(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        mainPageSuffix_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If the requested object path is missing, the service will
       * ensure the path has a trailing '/', append this suffix, and attempt to
       * retrieve the resulting object. This allows the creation of `index.html`
       * objects to represent directory pages.
       * </pre>
       *
       * <code>string main_page_suffix = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMainPageSuffix() {
        mainPageSuffix_ = getDefaultInstance().getMainPageSuffix();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If the requested object path is missing, the service will
       * ensure the path has a trailing '/', append this suffix, and attempt to
       * retrieve the resulting object. This allows the creation of `index.html`
       * objects to represent directory pages.
       * </pre>
       *
       * <code>string main_page_suffix = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for mainPageSuffix to set.
       * @return This builder for chaining.
       */
      public Builder setMainPageSuffixBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        mainPageSuffix_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object notFoundPage_ = "";

      /**
       *
       *
       * <pre>
       * Optional. If the requested object path is missing, and any
       * `mainPageSuffix` object is missing, if applicable, the service
       * will return the named object from this bucket as the content for a
       * [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
       * result.
       * </pre>
       *
       * <code>string not_found_page = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The notFoundPage.
       */
      public java.lang.String getNotFoundPage() {
        java.lang.Object ref = notFoundPage_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          notFoundPage_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. If the requested object path is missing, and any
       * `mainPageSuffix` object is missing, if applicable, the service
       * will return the named object from this bucket as the content for a
       * [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
       * result.
       * </pre>
       *
       * <code>string not_found_page = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for notFoundPage.
       */
      public com.google.protobuf.ByteString getNotFoundPageBytes() {
        java.lang.Object ref = notFoundPage_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          notFoundPage_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. If the requested object path is missing, and any
       * `mainPageSuffix` object is missing, if applicable, the service
       * will return the named object from this bucket as the content for a
       * [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
       * result.
       * </pre>
       *
       * <code>string not_found_page = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The notFoundPage to set.
       * @return This builder for chaining.
       */
      public Builder setNotFoundPage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        notFoundPage_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If the requested object path is missing, and any
       * `mainPageSuffix` object is missing, if applicable, the service
       * will return the named object from this bucket as the content for a
       * [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
       * result.
       * </pre>
       *
       * <code>string not_found_page = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNotFoundPage() {
        notFoundPage_ = getDefaultInstance().getNotFoundPage();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If the requested object path is missing, and any
       * `mainPageSuffix` object is missing, if applicable, the service
       * will return the named object from this bucket as the content for a
       * [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
       * result.
       * </pre>
       *
       * <code>string not_found_page = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for notFoundPage to set.
       * @return This builder for chaining.
       */
      public Builder setNotFoundPageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        notFoundPage_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Website)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Website)
    private static final com.google.storage.v2.Bucket.Website DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Website();
    }

    public static com.google.storage.v2.Bucket.Website getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Website> PARSER =
        new com.google.protobuf.AbstractParser<Website>() {
          @java.lang.Override
          public Website parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Website> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Website> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.Website getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CustomPlacementConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.CustomPlacementConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. List of locations to use for data placement.
     * </pre>
     *
     * <code>repeated string data_locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the dataLocations.
     */
    java.util.List<java.lang.String> getDataLocationsList();

    /**
     *
     *
     * <pre>
     * Optional. List of locations to use for data placement.
     * </pre>
     *
     * <code>repeated string data_locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of dataLocations.
     */
    int getDataLocationsCount();

    /**
     *
     *
     * <pre>
     * Optional. List of locations to use for data placement.
     * </pre>
     *
     * <code>repeated string data_locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The dataLocations at the given index.
     */
    java.lang.String getDataLocations(int index);

    /**
     *
     *
     * <pre>
     * Optional. List of locations to use for data placement.
     * </pre>
     *
     * <code>repeated string data_locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the dataLocations at the given index.
     */
    com.google.protobuf.ByteString getDataLocationsBytes(int index);
  }

  /**
   *
   *
   * <pre>
   * Configuration for Custom Dual Regions.  It should specify precisely two
   * eligible regions within the same Multiregion. More information on regions
   * may be found [here](https://cloud.google.com/storage/docs/locations).
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.CustomPlacementConfig}
   */
  public static final class CustomPlacementConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.CustomPlacementConfig)
      CustomPlacementConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use CustomPlacementConfig.newBuilder() to construct.
    private CustomPlacementConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CustomPlacementConfig() {
      dataLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CustomPlacementConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_CustomPlacementConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_CustomPlacementConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.CustomPlacementConfig.class,
              com.google.storage.v2.Bucket.CustomPlacementConfig.Builder.class);
    }

    public static final int DATA_LOCATIONS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList dataLocations_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * Optional. List of locations to use for data placement.
     * </pre>
     *
     * <code>repeated string data_locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the dataLocations.
     */
    public com.google.protobuf.ProtocolStringList getDataLocationsList() {
      return dataLocations_;
    }

    /**
     *
     *
     * <pre>
     * Optional. List of locations to use for data placement.
     * </pre>
     *
     * <code>repeated string data_locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of dataLocations.
     */
    public int getDataLocationsCount() {
      return dataLocations_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. List of locations to use for data placement.
     * </pre>
     *
     * <code>repeated string data_locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The dataLocations at the given index.
     */
    public java.lang.String getDataLocations(int index) {
      return dataLocations_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. List of locations to use for data placement.
     * </pre>
     *
     * <code>repeated string data_locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the dataLocations at the given index.
     */
    public com.google.protobuf.ByteString getDataLocationsBytes(int index) {
      return dataLocations_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < dataLocations_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, dataLocations_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < dataLocations_.size(); i++) {
          dataSize += computeStringSizeNoTag(dataLocations_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getDataLocationsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.CustomPlacementConfig)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.CustomPlacementConfig other =
          (com.google.storage.v2.Bucket.CustomPlacementConfig) obj;

      if (!getDataLocationsList().equals(other.getDataLocationsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getDataLocationsCount() > 0) {
        hash = (37 * hash) + DATA_LOCATIONS_FIELD_NUMBER;
        hash = (53 * hash) + getDataLocationsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.CustomPlacementConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.CustomPlacementConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.CustomPlacementConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.CustomPlacementConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.CustomPlacementConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.CustomPlacementConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.CustomPlacementConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.CustomPlacementConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.CustomPlacementConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.CustomPlacementConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.CustomPlacementConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.CustomPlacementConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.CustomPlacementConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Configuration for Custom Dual Regions.  It should specify precisely two
     * eligible regions within the same Multiregion. More information on regions
     * may be found [here](https://cloud.google.com/storage/docs/locations).
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.CustomPlacementConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.CustomPlacementConfig)
        com.google.storage.v2.Bucket.CustomPlacementConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_CustomPlacementConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_CustomPlacementConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.CustomPlacementConfig.class,
                com.google.storage.v2.Bucket.CustomPlacementConfig.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.CustomPlacementConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        dataLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_CustomPlacementConfig_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.CustomPlacementConfig getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.CustomPlacementConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.CustomPlacementConfig build() {
        com.google.storage.v2.Bucket.CustomPlacementConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.CustomPlacementConfig buildPartial() {
        com.google.storage.v2.Bucket.CustomPlacementConfig result =
            new com.google.storage.v2.Bucket.CustomPlacementConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.storage.v2.Bucket.CustomPlacementConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          dataLocations_.makeImmutable();
          result.dataLocations_ = dataLocations_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.CustomPlacementConfig) {
          return mergeFrom((com.google.storage.v2.Bucket.CustomPlacementConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.CustomPlacementConfig other) {
        if (other == com.google.storage.v2.Bucket.CustomPlacementConfig.getDefaultInstance())
          return this;
        if (!other.dataLocations_.isEmpty()) {
          if (dataLocations_.isEmpty()) {
            dataLocations_ = other.dataLocations_;
            bitField0_ |= 0x00000001;
          } else {
            ensureDataLocationsIsMutable();
            dataLocations_.addAll(other.dataLocations_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureDataLocationsIsMutable();
                  dataLocations_.add(s);
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList dataLocations_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureDataLocationsIsMutable() {
        if (!dataLocations_.isModifiable()) {
          dataLocations_ = new com.google.protobuf.LazyStringArrayList(dataLocations_);
        }
        bitField0_ |= 0x00000001;
      }

      /**
       *
       *
       * <pre>
       * Optional. List of locations to use for data placement.
       * </pre>
       *
       * <code>repeated string data_locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the dataLocations.
       */
      public com.google.protobuf.ProtocolStringList getDataLocationsList() {
        dataLocations_.makeImmutable();
        return dataLocations_;
      }

      /**
       *
       *
       * <pre>
       * Optional. List of locations to use for data placement.
       * </pre>
       *
       * <code>repeated string data_locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of dataLocations.
       */
      public int getDataLocationsCount() {
        return dataLocations_.size();
      }

      /**
       *
       *
       * <pre>
       * Optional. List of locations to use for data placement.
       * </pre>
       *
       * <code>repeated string data_locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The dataLocations at the given index.
       */
      public java.lang.String getDataLocations(int index) {
        return dataLocations_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. List of locations to use for data placement.
       * </pre>
       *
       * <code>repeated string data_locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the dataLocations at the given index.
       */
      public com.google.protobuf.ByteString getDataLocationsBytes(int index) {
        return dataLocations_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. List of locations to use for data placement.
       * </pre>
       *
       * <code>repeated string data_locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index to set the value at.
       * @param value The dataLocations to set.
       * @return This builder for chaining.
       */
      public Builder setDataLocations(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataLocationsIsMutable();
        dataLocations_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. List of locations to use for data placement.
       * </pre>
       *
       * <code>repeated string data_locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The dataLocations to add.
       * @return This builder for chaining.
       */
      public Builder addDataLocations(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataLocationsIsMutable();
        dataLocations_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. List of locations to use for data placement.
       * </pre>
       *
       * <code>repeated string data_locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param values The dataLocations to add.
       * @return This builder for chaining.
       */
      public Builder addAllDataLocations(java.lang.Iterable<java.lang.String> values) {
        ensureDataLocationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dataLocations_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. List of locations to use for data placement.
       * </pre>
       *
       * <code>repeated string data_locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDataLocations() {
        dataLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. List of locations to use for data placement.
       * </pre>
       *
       * <code>repeated string data_locations = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes of the dataLocations to add.
       * @return This builder for chaining.
       */
      public Builder addDataLocationsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureDataLocationsIsMutable();
        dataLocations_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.CustomPlacementConfig)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.CustomPlacementConfig)
    private static final com.google.storage.v2.Bucket.CustomPlacementConfig DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.CustomPlacementConfig();
    }

    public static com.google.storage.v2.Bucket.CustomPlacementConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CustomPlacementConfig> PARSER =
        new com.google.protobuf.AbstractParser<CustomPlacementConfig>() {
          @java.lang.Override
          public CustomPlacementConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CustomPlacementConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CustomPlacementConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.CustomPlacementConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AutoclassOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.Autoclass)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Enables Autoclass.
     * </pre>
     *
     * <code>bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enabled.
     */
    boolean getEnabled();

    /**
     *
     *
     * <pre>
     * Output only. Latest instant at which the `enabled` field was set to true
     * after being disabled/unconfigured or set to false after being enabled. If
     * Autoclass is enabled when the bucket is created, the toggle_time is set
     * to the bucket creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the toggleTime field is set.
     */
    boolean hasToggleTime();

    /**
     *
     *
     * <pre>
     * Output only. Latest instant at which the `enabled` field was set to true
     * after being disabled/unconfigured or set to false after being enabled. If
     * Autoclass is enabled when the bucket is created, the toggle_time is set
     * to the bucket creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The toggleTime.
     */
    com.google.protobuf.Timestamp getToggleTime();

    /**
     *
     *
     * <pre>
     * Output only. Latest instant at which the `enabled` field was set to true
     * after being disabled/unconfigured or set to false after being enabled. If
     * Autoclass is enabled when the bucket is created, the toggle_time is set
     * to the bucket creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getToggleTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * An object in an Autoclass bucket will eventually cool down to the
     * terminal storage class if there is no access to the object.
     * The only valid values are NEARLINE and ARCHIVE.
     * </pre>
     *
     * <code>optional string terminal_storage_class = 3;</code>
     *
     * @return Whether the terminalStorageClass field is set.
     */
    boolean hasTerminalStorageClass();

    /**
     *
     *
     * <pre>
     * An object in an Autoclass bucket will eventually cool down to the
     * terminal storage class if there is no access to the object.
     * The only valid values are NEARLINE and ARCHIVE.
     * </pre>
     *
     * <code>optional string terminal_storage_class = 3;</code>
     *
     * @return The terminalStorageClass.
     */
    java.lang.String getTerminalStorageClass();

    /**
     *
     *
     * <pre>
     * An object in an Autoclass bucket will eventually cool down to the
     * terminal storage class if there is no access to the object.
     * The only valid values are NEARLINE and ARCHIVE.
     * </pre>
     *
     * <code>optional string terminal_storage_class = 3;</code>
     *
     * @return The bytes for terminalStorageClass.
     */
    com.google.protobuf.ByteString getTerminalStorageClassBytes();

    /**
     *
     *
     * <pre>
     * Output only. Latest instant at which the autoclass terminal storage class
     * was updated.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the terminalStorageClassUpdateTime field is set.
     */
    boolean hasTerminalStorageClassUpdateTime();

    /**
     *
     *
     * <pre>
     * Output only. Latest instant at which the autoclass terminal storage class
     * was updated.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The terminalStorageClassUpdateTime.
     */
    com.google.protobuf.Timestamp getTerminalStorageClassUpdateTime();

    /**
     *
     *
     * <pre>
     * Output only. Latest instant at which the autoclass terminal storage class
     * was updated.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getTerminalStorageClassUpdateTimeOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * Configuration for a bucket's Autoclass feature.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.Autoclass}
   */
  public static final class Autoclass extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.Autoclass)
      AutoclassOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Autoclass.newBuilder() to construct.
    private Autoclass(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Autoclass() {
      terminalStorageClass_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Autoclass();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Autoclass_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_Autoclass_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.Autoclass.class,
              com.google.storage.v2.Bucket.Autoclass.Builder.class);
    }

    private int bitField0_;
    public static final int ENABLED_FIELD_NUMBER = 1;
    private boolean enabled_ = false;

    /**
     *
     *
     * <pre>
     * Optional. Enables Autoclass.
     * </pre>
     *
     * <code>bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enabled.
     */
    @java.lang.Override
    public boolean getEnabled() {
      return enabled_;
    }

    public static final int TOGGLE_TIME_FIELD_NUMBER = 2;
    private com.google.protobuf.Timestamp toggleTime_;

    /**
     *
     *
     * <pre>
     * Output only. Latest instant at which the `enabled` field was set to true
     * after being disabled/unconfigured or set to false after being enabled. If
     * Autoclass is enabled when the bucket is created, the toggle_time is set
     * to the bucket creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the toggleTime field is set.
     */
    @java.lang.Override
    public boolean hasToggleTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Latest instant at which the `enabled` field was set to true
     * after being disabled/unconfigured or set to false after being enabled. If
     * Autoclass is enabled when the bucket is created, the toggle_time is set
     * to the bucket creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The toggleTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getToggleTime() {
      return toggleTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : toggleTime_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Latest instant at which the `enabled` field was set to true
     * after being disabled/unconfigured or set to false after being enabled. If
     * Autoclass is enabled when the bucket is created, the toggle_time is set
     * to the bucket creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getToggleTimeOrBuilder() {
      return toggleTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : toggleTime_;
    }

    public static final int TERMINAL_STORAGE_CLASS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object terminalStorageClass_ = "";

    /**
     *
     *
     * <pre>
     * An object in an Autoclass bucket will eventually cool down to the
     * terminal storage class if there is no access to the object.
     * The only valid values are NEARLINE and ARCHIVE.
     * </pre>
     *
     * <code>optional string terminal_storage_class = 3;</code>
     *
     * @return Whether the terminalStorageClass field is set.
     */
    @java.lang.Override
    public boolean hasTerminalStorageClass() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * An object in an Autoclass bucket will eventually cool down to the
     * terminal storage class if there is no access to the object.
     * The only valid values are NEARLINE and ARCHIVE.
     * </pre>
     *
     * <code>optional string terminal_storage_class = 3;</code>
     *
     * @return The terminalStorageClass.
     */
    @java.lang.Override
    public java.lang.String getTerminalStorageClass() {
      java.lang.Object ref = terminalStorageClass_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        terminalStorageClass_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * An object in an Autoclass bucket will eventually cool down to the
     * terminal storage class if there is no access to the object.
     * The only valid values are NEARLINE and ARCHIVE.
     * </pre>
     *
     * <code>optional string terminal_storage_class = 3;</code>
     *
     * @return The bytes for terminalStorageClass.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTerminalStorageClassBytes() {
      java.lang.Object ref = terminalStorageClass_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        terminalStorageClass_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TERMINAL_STORAGE_CLASS_UPDATE_TIME_FIELD_NUMBER = 4;
    private com.google.protobuf.Timestamp terminalStorageClassUpdateTime_;

    /**
     *
     *
     * <pre>
     * Output only. Latest instant at which the autoclass terminal storage class
     * was updated.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the terminalStorageClassUpdateTime field is set.
     */
    @java.lang.Override
    public boolean hasTerminalStorageClassUpdateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Latest instant at which the autoclass terminal storage class
     * was updated.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The terminalStorageClassUpdateTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getTerminalStorageClassUpdateTime() {
      return terminalStorageClassUpdateTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : terminalStorageClassUpdateTime_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Latest instant at which the autoclass terminal storage class
     * was updated.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getTerminalStorageClassUpdateTimeOrBuilder() {
      return terminalStorageClassUpdateTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : terminalStorageClassUpdateTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (enabled_ != false) {
        output.writeBool(1, enabled_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getToggleTime());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, terminalStorageClass_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(4, getTerminalStorageClassUpdateTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (enabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enabled_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getToggleTime());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, terminalStorageClass_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4, getTerminalStorageClassUpdateTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.Autoclass)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.Autoclass other = (com.google.storage.v2.Bucket.Autoclass) obj;

      if (getEnabled() != other.getEnabled()) return false;
      if (hasToggleTime() != other.hasToggleTime()) return false;
      if (hasToggleTime()) {
        if (!getToggleTime().equals(other.getToggleTime())) return false;
      }
      if (hasTerminalStorageClass() != other.hasTerminalStorageClass()) return false;
      if (hasTerminalStorageClass()) {
        if (!getTerminalStorageClass().equals(other.getTerminalStorageClass())) return false;
      }
      if (hasTerminalStorageClassUpdateTime() != other.hasTerminalStorageClassUpdateTime())
        return false;
      if (hasTerminalStorageClassUpdateTime()) {
        if (!getTerminalStorageClassUpdateTime().equals(other.getTerminalStorageClassUpdateTime()))
          return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnabled());
      if (hasToggleTime()) {
        hash = (37 * hash) + TOGGLE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getToggleTime().hashCode();
      }
      if (hasTerminalStorageClass()) {
        hash = (37 * hash) + TERMINAL_STORAGE_CLASS_FIELD_NUMBER;
        hash = (53 * hash) + getTerminalStorageClass().hashCode();
      }
      if (hasTerminalStorageClassUpdateTime()) {
        hash = (37 * hash) + TERMINAL_STORAGE_CLASS_UPDATE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getTerminalStorageClassUpdateTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.Autoclass parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Autoclass parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Autoclass parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Autoclass parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Autoclass parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.Autoclass parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Autoclass parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Autoclass parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Autoclass parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Autoclass parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.Autoclass parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.Autoclass parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.Autoclass prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Configuration for a bucket's Autoclass feature.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.Autoclass}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.Autoclass)
        com.google.storage.v2.Bucket.AutoclassOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Autoclass_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Autoclass_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.Autoclass.class,
                com.google.storage.v2.Bucket.Autoclass.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.Autoclass.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getToggleTimeFieldBuilder();
          getTerminalStorageClassUpdateTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        enabled_ = false;
        toggleTime_ = null;
        if (toggleTimeBuilder_ != null) {
          toggleTimeBuilder_.dispose();
          toggleTimeBuilder_ = null;
        }
        terminalStorageClass_ = "";
        terminalStorageClassUpdateTime_ = null;
        if (terminalStorageClassUpdateTimeBuilder_ != null) {
          terminalStorageClassUpdateTimeBuilder_.dispose();
          terminalStorageClassUpdateTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_Autoclass_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Autoclass getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.Autoclass.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Autoclass build() {
        com.google.storage.v2.Bucket.Autoclass result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.Autoclass buildPartial() {
        com.google.storage.v2.Bucket.Autoclass result =
            new com.google.storage.v2.Bucket.Autoclass(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.storage.v2.Bucket.Autoclass result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.enabled_ = enabled_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.toggleTime_ =
              toggleTimeBuilder_ == null ? toggleTime_ : toggleTimeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.terminalStorageClass_ = terminalStorageClass_;
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.terminalStorageClassUpdateTime_ =
              terminalStorageClassUpdateTimeBuilder_ == null
                  ? terminalStorageClassUpdateTime_
                  : terminalStorageClassUpdateTimeBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.Autoclass) {
          return mergeFrom((com.google.storage.v2.Bucket.Autoclass) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.Autoclass other) {
        if (other == com.google.storage.v2.Bucket.Autoclass.getDefaultInstance()) return this;
        if (other.getEnabled() != false) {
          setEnabled(other.getEnabled());
        }
        if (other.hasToggleTime()) {
          mergeToggleTime(other.getToggleTime());
        }
        if (other.hasTerminalStorageClass()) {
          terminalStorageClass_ = other.terminalStorageClass_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (other.hasTerminalStorageClassUpdateTime()) {
          mergeTerminalStorageClassUpdateTime(other.getTerminalStorageClassUpdateTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  enabled_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  input.readMessage(getToggleTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  terminalStorageClass_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(
                      getTerminalStorageClassUpdateTimeFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean enabled_;

      /**
       *
       *
       * <pre>
       * Optional. Enables Autoclass.
       * </pre>
       *
       * <code>bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The enabled.
       */
      @java.lang.Override
      public boolean getEnabled() {
        return enabled_;
      }

      /**
       *
       *
       * <pre>
       * Optional. Enables Autoclass.
       * </pre>
       *
       * <code>bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The enabled to set.
       * @return This builder for chaining.
       */
      public Builder setEnabled(boolean value) {

        enabled_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Enables Autoclass.
       * </pre>
       *
       * <code>bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnabled() {
        bitField0_ = (bitField0_ & ~0x00000001);
        enabled_ = false;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp toggleTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          toggleTimeBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the `enabled` field was set to true
       * after being disabled/unconfigured or set to false after being enabled. If
       * Autoclass is enabled when the bucket is created, the toggle_time is set
       * to the bucket creation time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the toggleTime field is set.
       */
      public boolean hasToggleTime() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the `enabled` field was set to true
       * after being disabled/unconfigured or set to false after being enabled. If
       * Autoclass is enabled when the bucket is created, the toggle_time is set
       * to the bucket creation time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The toggleTime.
       */
      public com.google.protobuf.Timestamp getToggleTime() {
        if (toggleTimeBuilder_ == null) {
          return toggleTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : toggleTime_;
        } else {
          return toggleTimeBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the `enabled` field was set to true
       * after being disabled/unconfigured or set to false after being enabled. If
       * Autoclass is enabled when the bucket is created, the toggle_time is set
       * to the bucket creation time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setToggleTime(com.google.protobuf.Timestamp value) {
        if (toggleTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          toggleTime_ = value;
        } else {
          toggleTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the `enabled` field was set to true
       * after being disabled/unconfigured or set to false after being enabled. If
       * Autoclass is enabled when the bucket is created, the toggle_time is set
       * to the bucket creation time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setToggleTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (toggleTimeBuilder_ == null) {
          toggleTime_ = builderForValue.build();
        } else {
          toggleTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the `enabled` field was set to true
       * after being disabled/unconfigured or set to false after being enabled. If
       * Autoclass is enabled when the bucket is created, the toggle_time is set
       * to the bucket creation time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeToggleTime(com.google.protobuf.Timestamp value) {
        if (toggleTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && toggleTime_ != null
              && toggleTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getToggleTimeBuilder().mergeFrom(value);
          } else {
            toggleTime_ = value;
          }
        } else {
          toggleTimeBuilder_.mergeFrom(value);
        }
        if (toggleTime_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the `enabled` field was set to true
       * after being disabled/unconfigured or set to false after being enabled. If
       * Autoclass is enabled when the bucket is created, the toggle_time is set
       * to the bucket creation time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearToggleTime() {
        bitField0_ = (bitField0_ & ~0x00000002);
        toggleTime_ = null;
        if (toggleTimeBuilder_ != null) {
          toggleTimeBuilder_.dispose();
          toggleTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the `enabled` field was set to true
       * after being disabled/unconfigured or set to false after being enabled. If
       * Autoclass is enabled when the bucket is created, the toggle_time is set
       * to the bucket creation time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getToggleTimeBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getToggleTimeFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the `enabled` field was set to true
       * after being disabled/unconfigured or set to false after being enabled. If
       * Autoclass is enabled when the bucket is created, the toggle_time is set
       * to the bucket creation time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getToggleTimeOrBuilder() {
        if (toggleTimeBuilder_ != null) {
          return toggleTimeBuilder_.getMessageOrBuilder();
        } else {
          return toggleTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : toggleTime_;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the `enabled` field was set to true
       * after being disabled/unconfigured or set to false after being enabled. If
       * Autoclass is enabled when the bucket is created, the toggle_time is set
       * to the bucket creation time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp toggle_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getToggleTimeFieldBuilder() {
        if (toggleTimeBuilder_ == null) {
          toggleTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getToggleTime(), getParentForChildren(), isClean());
          toggleTime_ = null;
        }
        return toggleTimeBuilder_;
      }

      private java.lang.Object terminalStorageClass_ = "";

      /**
       *
       *
       * <pre>
       * An object in an Autoclass bucket will eventually cool down to the
       * terminal storage class if there is no access to the object.
       * The only valid values are NEARLINE and ARCHIVE.
       * </pre>
       *
       * <code>optional string terminal_storage_class = 3;</code>
       *
       * @return Whether the terminalStorageClass field is set.
       */
      public boolean hasTerminalStorageClass() {
        return ((bitField0_ & 0x00000004) != 0);
      }

      /**
       *
       *
       * <pre>
       * An object in an Autoclass bucket will eventually cool down to the
       * terminal storage class if there is no access to the object.
       * The only valid values are NEARLINE and ARCHIVE.
       * </pre>
       *
       * <code>optional string terminal_storage_class = 3;</code>
       *
       * @return The terminalStorageClass.
       */
      public java.lang.String getTerminalStorageClass() {
        java.lang.Object ref = terminalStorageClass_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          terminalStorageClass_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * An object in an Autoclass bucket will eventually cool down to the
       * terminal storage class if there is no access to the object.
       * The only valid values are NEARLINE and ARCHIVE.
       * </pre>
       *
       * <code>optional string terminal_storage_class = 3;</code>
       *
       * @return The bytes for terminalStorageClass.
       */
      public com.google.protobuf.ByteString getTerminalStorageClassBytes() {
        java.lang.Object ref = terminalStorageClass_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          terminalStorageClass_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * An object in an Autoclass bucket will eventually cool down to the
       * terminal storage class if there is no access to the object.
       * The only valid values are NEARLINE and ARCHIVE.
       * </pre>
       *
       * <code>optional string terminal_storage_class = 3;</code>
       *
       * @param value The terminalStorageClass to set.
       * @return This builder for chaining.
       */
      public Builder setTerminalStorageClass(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        terminalStorageClass_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * An object in an Autoclass bucket will eventually cool down to the
       * terminal storage class if there is no access to the object.
       * The only valid values are NEARLINE and ARCHIVE.
       * </pre>
       *
       * <code>optional string terminal_storage_class = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTerminalStorageClass() {
        terminalStorageClass_ = getDefaultInstance().getTerminalStorageClass();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * An object in an Autoclass bucket will eventually cool down to the
       * terminal storage class if there is no access to the object.
       * The only valid values are NEARLINE and ARCHIVE.
       * </pre>
       *
       * <code>optional string terminal_storage_class = 3;</code>
       *
       * @param value The bytes for terminalStorageClass to set.
       * @return This builder for chaining.
       */
      public Builder setTerminalStorageClassBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        terminalStorageClass_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp terminalStorageClassUpdateTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          terminalStorageClassUpdateTimeBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the autoclass terminal storage class
       * was updated.
       * </pre>
       *
       * <code>
       * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the terminalStorageClassUpdateTime field is set.
       */
      public boolean hasTerminalStorageClassUpdateTime() {
        return ((bitField0_ & 0x00000008) != 0);
      }

      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the autoclass terminal storage class
       * was updated.
       * </pre>
       *
       * <code>
       * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The terminalStorageClassUpdateTime.
       */
      public com.google.protobuf.Timestamp getTerminalStorageClassUpdateTime() {
        if (terminalStorageClassUpdateTimeBuilder_ == null) {
          return terminalStorageClassUpdateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : terminalStorageClassUpdateTime_;
        } else {
          return terminalStorageClassUpdateTimeBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the autoclass terminal storage class
       * was updated.
       * </pre>
       *
       * <code>
       * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setTerminalStorageClassUpdateTime(com.google.protobuf.Timestamp value) {
        if (terminalStorageClassUpdateTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          terminalStorageClassUpdateTime_ = value;
        } else {
          terminalStorageClassUpdateTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the autoclass terminal storage class
       * was updated.
       * </pre>
       *
       * <code>
       * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setTerminalStorageClassUpdateTime(
          com.google.protobuf.Timestamp.Builder builderForValue) {
        if (terminalStorageClassUpdateTimeBuilder_ == null) {
          terminalStorageClassUpdateTime_ = builderForValue.build();
        } else {
          terminalStorageClassUpdateTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the autoclass terminal storage class
       * was updated.
       * </pre>
       *
       * <code>
       * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeTerminalStorageClassUpdateTime(com.google.protobuf.Timestamp value) {
        if (terminalStorageClassUpdateTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && terminalStorageClassUpdateTime_ != null
              && terminalStorageClassUpdateTime_
                  != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getTerminalStorageClassUpdateTimeBuilder().mergeFrom(value);
          } else {
            terminalStorageClassUpdateTime_ = value;
          }
        } else {
          terminalStorageClassUpdateTimeBuilder_.mergeFrom(value);
        }
        if (terminalStorageClassUpdateTime_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the autoclass terminal storage class
       * was updated.
       * </pre>
       *
       * <code>
       * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearTerminalStorageClassUpdateTime() {
        bitField0_ = (bitField0_ & ~0x00000008);
        terminalStorageClassUpdateTime_ = null;
        if (terminalStorageClassUpdateTimeBuilder_ != null) {
          terminalStorageClassUpdateTimeBuilder_.dispose();
          terminalStorageClassUpdateTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the autoclass terminal storage class
       * was updated.
       * </pre>
       *
       * <code>
       * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getTerminalStorageClassUpdateTimeBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getTerminalStorageClassUpdateTimeFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the autoclass terminal storage class
       * was updated.
       * </pre>
       *
       * <code>
       * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getTerminalStorageClassUpdateTimeOrBuilder() {
        if (terminalStorageClassUpdateTimeBuilder_ != null) {
          return terminalStorageClassUpdateTimeBuilder_.getMessageOrBuilder();
        } else {
          return terminalStorageClassUpdateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : terminalStorageClassUpdateTime_;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Latest instant at which the autoclass terminal storage class
       * was updated.
       * </pre>
       *
       * <code>
       * optional .google.protobuf.Timestamp terminal_storage_class_update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getTerminalStorageClassUpdateTimeFieldBuilder() {
        if (terminalStorageClassUpdateTimeBuilder_ == null) {
          terminalStorageClassUpdateTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getTerminalStorageClassUpdateTime(), getParentForChildren(), isClean());
          terminalStorageClassUpdateTime_ = null;
        }
        return terminalStorageClassUpdateTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.Autoclass)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.Autoclass)
    private static final com.google.storage.v2.Bucket.Autoclass DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.Autoclass();
    }

    public static com.google.storage.v2.Bucket.Autoclass getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Autoclass> PARSER =
        new com.google.protobuf.AbstractParser<Autoclass>() {
          @java.lang.Override
          public Autoclass parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Autoclass> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Autoclass> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.Autoclass getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface IpFilterOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.IpFilter)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The state of the IP filter configuration. Valid values are `Enabled` and
     * `Disabled`. When set to `Enabled`, IP filtering rules are applied to a
     * bucket and all incoming requests to the bucket are evaluated against
     * these rules. When set to `Disabled`, IP filtering rules are not applied
     * to a bucket.".
     * </pre>
     *
     * <code>optional string mode = 1;</code>
     *
     * @return Whether the mode field is set.
     */
    boolean hasMode();

    /**
     *
     *
     * <pre>
     * The state of the IP filter configuration. Valid values are `Enabled` and
     * `Disabled`. When set to `Enabled`, IP filtering rules are applied to a
     * bucket and all incoming requests to the bucket are evaluated against
     * these rules. When set to `Disabled`, IP filtering rules are not applied
     * to a bucket.".
     * </pre>
     *
     * <code>optional string mode = 1;</code>
     *
     * @return The mode.
     */
    java.lang.String getMode();

    /**
     *
     *
     * <pre>
     * The state of the IP filter configuration. Valid values are `Enabled` and
     * `Disabled`. When set to `Enabled`, IP filtering rules are applied to a
     * bucket and all incoming requests to the bucket are evaluated against
     * these rules. When set to `Disabled`, IP filtering rules are not applied
     * to a bucket.".
     * </pre>
     *
     * <code>optional string mode = 1;</code>
     *
     * @return The bytes for mode.
     */
    com.google.protobuf.ByteString getModeBytes();

    /**
     *
     *
     * <pre>
     * Public IPs allowed to operate or access the bucket.
     * </pre>
     *
     * <code>
     * optional .google.storage.v2.Bucket.IpFilter.PublicNetworkSource public_network_source = 2;
     * </code>
     *
     * @return Whether the publicNetworkSource field is set.
     */
    boolean hasPublicNetworkSource();

    /**
     *
     *
     * <pre>
     * Public IPs allowed to operate or access the bucket.
     * </pre>
     *
     * <code>
     * optional .google.storage.v2.Bucket.IpFilter.PublicNetworkSource public_network_source = 2;
     * </code>
     *
     * @return The publicNetworkSource.
     */
    com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource getPublicNetworkSource();

    /**
     *
     *
     * <pre>
     * Public IPs allowed to operate or access the bucket.
     * </pre>
     *
     * <code>
     * optional .google.storage.v2.Bucket.IpFilter.PublicNetworkSource public_network_source = 2;
     * </code>
     */
    com.google.storage.v2.Bucket.IpFilter.PublicNetworkSourceOrBuilder
        getPublicNetworkSourceOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. The list of network sources that are allowed to access
     * operations on the bucket or the underlying objects.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.Bucket.IpFilter.VpcNetworkSource vpc_network_sources = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource>
        getVpcNetworkSourcesList();

    /**
     *
     *
     * <pre>
     * Optional. The list of network sources that are allowed to access
     * operations on the bucket or the underlying objects.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.Bucket.IpFilter.VpcNetworkSource vpc_network_sources = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource getVpcNetworkSources(int index);

    /**
     *
     *
     * <pre>
     * Optional. The list of network sources that are allowed to access
     * operations on the bucket or the underlying objects.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.Bucket.IpFilter.VpcNetworkSource vpc_network_sources = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getVpcNetworkSourcesCount();

    /**
     *
     *
     * <pre>
     * Optional. The list of network sources that are allowed to access
     * operations on the bucket or the underlying objects.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.Bucket.IpFilter.VpcNetworkSource vpc_network_sources = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<? extends com.google.storage.v2.Bucket.IpFilter.VpcNetworkSourceOrBuilder>
        getVpcNetworkSourcesOrBuilderList();

    /**
     *
     *
     * <pre>
     * Optional. The list of network sources that are allowed to access
     * operations on the bucket or the underlying objects.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.Bucket.IpFilter.VpcNetworkSource vpc_network_sources = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.storage.v2.Bucket.IpFilter.VpcNetworkSourceOrBuilder getVpcNetworkSourcesOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * Optional. Whether or not to allow VPCs from orgs different than the
     * bucket's parent org to access the bucket. When set to true, validations
     * on the existence of the VPCs won't be performed. If set to false, each
     * VPC network source will be checked to belong to the same org as the
     * bucket as well as validated for existence.
     * </pre>
     *
     * <code>bool allow_cross_org_vpcs = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The allowCrossOrgVpcs.
     */
    boolean getAllowCrossOrgVpcs();

    /**
     *
     *
     * <pre>
     * Whether or not to allow all P4SA access to the bucket. When set to true,
     * IP filter config validation will not apply.
     * </pre>
     *
     * <code>optional bool allow_all_service_agent_access = 5;</code>
     *
     * @return Whether the allowAllServiceAgentAccess field is set.
     */
    boolean hasAllowAllServiceAgentAccess();

    /**
     *
     *
     * <pre>
     * Whether or not to allow all P4SA access to the bucket. When set to true,
     * IP filter config validation will not apply.
     * </pre>
     *
     * <code>optional bool allow_all_service_agent_access = 5;</code>
     *
     * @return The allowAllServiceAgentAccess.
     */
    boolean getAllowAllServiceAgentAccess();
  }

  /**
   *
   *
   * <pre>
   * The [bucket IP
   * filtering](https://cloud.google.com/storage/docs/ip-filtering-overview)
   * configuration. Specifies the network sources that can access the bucket, as
   * well as its underlying objects.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.IpFilter}
   */
  public static final class IpFilter extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.IpFilter)
      IpFilterOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use IpFilter.newBuilder() to construct.
    private IpFilter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IpFilter() {
      mode_ = "";
      vpcNetworkSources_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new IpFilter();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_IpFilter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Bucket_IpFilter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Bucket.IpFilter.class,
              com.google.storage.v2.Bucket.IpFilter.Builder.class);
    }

    public interface PublicNetworkSourceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.IpFilter.PublicNetworkSource)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. The list of IPv4 and IPv6 cidr blocks that are allowed to
       * operate or access the bucket and its underlying objects.
       * </pre>
       *
       * <code>repeated string allowed_ip_cidr_ranges = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return A list containing the allowedIpCidrRanges.
       */
      java.util.List<java.lang.String> getAllowedIpCidrRangesList();

      /**
       *
       *
       * <pre>
       * Optional. The list of IPv4 and IPv6 cidr blocks that are allowed to
       * operate or access the bucket and its underlying objects.
       * </pre>
       *
       * <code>repeated string allowed_ip_cidr_ranges = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The count of allowedIpCidrRanges.
       */
      int getAllowedIpCidrRangesCount();

      /**
       *
       *
       * <pre>
       * Optional. The list of IPv4 and IPv6 cidr blocks that are allowed to
       * operate or access the bucket and its underlying objects.
       * </pre>
       *
       * <code>repeated string allowed_ip_cidr_ranges = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The allowedIpCidrRanges at the given index.
       */
      java.lang.String getAllowedIpCidrRanges(int index);

      /**
       *
       *
       * <pre>
       * Optional. The list of IPv4 and IPv6 cidr blocks that are allowed to
       * operate or access the bucket and its underlying objects.
       * </pre>
       *
       * <code>repeated string allowed_ip_cidr_ranges = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the allowedIpCidrRanges at the given index.
       */
      com.google.protobuf.ByteString getAllowedIpCidrRangesBytes(int index);
    }

    /**
     *
     *
     * <pre>
     * The public network IP address ranges that can access the bucket and its
     * data.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.IpFilter.PublicNetworkSource}
     */
    public static final class PublicNetworkSource extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.IpFilter.PublicNetworkSource)
        PublicNetworkSourceOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use PublicNetworkSource.newBuilder() to construct.
      private PublicNetworkSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private PublicNetworkSource() {
        allowedIpCidrRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new PublicNetworkSource();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_IpFilter_PublicNetworkSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_IpFilter_PublicNetworkSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource.class,
                com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource.Builder.class);
      }

      public static final int ALLOWED_IP_CIDR_RANGES_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList allowedIpCidrRanges_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      /**
       *
       *
       * <pre>
       * Optional. The list of IPv4 and IPv6 cidr blocks that are allowed to
       * operate or access the bucket and its underlying objects.
       * </pre>
       *
       * <code>repeated string allowed_ip_cidr_ranges = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return A list containing the allowedIpCidrRanges.
       */
      public com.google.protobuf.ProtocolStringList getAllowedIpCidrRangesList() {
        return allowedIpCidrRanges_;
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of IPv4 and IPv6 cidr blocks that are allowed to
       * operate or access the bucket and its underlying objects.
       * </pre>
       *
       * <code>repeated string allowed_ip_cidr_ranges = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The count of allowedIpCidrRanges.
       */
      public int getAllowedIpCidrRangesCount() {
        return allowedIpCidrRanges_.size();
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of IPv4 and IPv6 cidr blocks that are allowed to
       * operate or access the bucket and its underlying objects.
       * </pre>
       *
       * <code>repeated string allowed_ip_cidr_ranges = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The allowedIpCidrRanges at the given index.
       */
      public java.lang.String getAllowedIpCidrRanges(int index) {
        return allowedIpCidrRanges_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of IPv4 and IPv6 cidr blocks that are allowed to
       * operate or access the bucket and its underlying objects.
       * </pre>
       *
       * <code>repeated string allowed_ip_cidr_ranges = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the allowedIpCidrRanges at the given index.
       */
      public com.google.protobuf.ByteString getAllowedIpCidrRangesBytes(int index) {
        return allowedIpCidrRanges_.getByteString(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < allowedIpCidrRanges_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(
              output, 1, allowedIpCidrRanges_.getRaw(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          for (int i = 0; i < allowedIpCidrRanges_.size(); i++) {
            dataSize += computeStringSizeNoTag(allowedIpCidrRanges_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getAllowedIpCidrRangesList().size();
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource)) {
          return super.equals(obj);
        }
        com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource other =
            (com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource) obj;

        if (!getAllowedIpCidrRangesList().equals(other.getAllowedIpCidrRangesList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getAllowedIpCidrRangesCount() > 0) {
          hash = (37 * hash) + ALLOWED_IP_CIDR_RANGES_FIELD_NUMBER;
          hash = (53 * hash) + getAllowedIpCidrRangesList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * The public network IP address ranges that can access the bucket and its
       * data.
       * </pre>
       *
       * Protobuf type {@code google.storage.v2.Bucket.IpFilter.PublicNetworkSource}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.IpFilter.PublicNetworkSource)
          com.google.storage.v2.Bucket.IpFilter.PublicNetworkSourceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_IpFilter_PublicNetworkSource_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_IpFilter_PublicNetworkSource_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource.class,
                  com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource.Builder.class);
        }

        // Construct using com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          allowedIpCidrRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_IpFilter_PublicNetworkSource_descriptor;
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource
            getDefaultInstanceForType() {
          return com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource build() {
          com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource buildPartial() {
          com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource result =
              new com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            allowedIpCidrRanges_.makeImmutable();
            result.allowedIpCidrRanges_ = allowedIpCidrRanges_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource) {
            return mergeFrom((com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource other) {
          if (other
              == com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource.getDefaultInstance())
            return this;
          if (!other.allowedIpCidrRanges_.isEmpty()) {
            if (allowedIpCidrRanges_.isEmpty()) {
              allowedIpCidrRanges_ = other.allowedIpCidrRanges_;
              bitField0_ |= 0x00000001;
            } else {
              ensureAllowedIpCidrRangesIsMutable();
              allowedIpCidrRanges_.addAll(other.allowedIpCidrRanges_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureAllowedIpCidrRangesIsMutable();
                    allowedIpCidrRanges_.add(s);
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.LazyStringArrayList allowedIpCidrRanges_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureAllowedIpCidrRangesIsMutable() {
          if (!allowedIpCidrRanges_.isModifiable()) {
            allowedIpCidrRanges_ =
                new com.google.protobuf.LazyStringArrayList(allowedIpCidrRanges_);
          }
          bitField0_ |= 0x00000001;
        }

        /**
         *
         *
         * <pre>
         * Optional. The list of IPv4 and IPv6 cidr blocks that are allowed to
         * operate or access the bucket and its underlying objects.
         * </pre>
         *
         * <code>
         * repeated string allowed_ip_cidr_ranges = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return A list containing the allowedIpCidrRanges.
         */
        public com.google.protobuf.ProtocolStringList getAllowedIpCidrRangesList() {
          allowedIpCidrRanges_.makeImmutable();
          return allowedIpCidrRanges_;
        }

        /**
         *
         *
         * <pre>
         * Optional. The list of IPv4 and IPv6 cidr blocks that are allowed to
         * operate or access the bucket and its underlying objects.
         * </pre>
         *
         * <code>
         * repeated string allowed_ip_cidr_ranges = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The count of allowedIpCidrRanges.
         */
        public int getAllowedIpCidrRangesCount() {
          return allowedIpCidrRanges_.size();
        }

        /**
         *
         *
         * <pre>
         * Optional. The list of IPv4 and IPv6 cidr blocks that are allowed to
         * operate or access the bucket and its underlying objects.
         * </pre>
         *
         * <code>
         * repeated string allowed_ip_cidr_ranges = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index of the element to return.
         * @return The allowedIpCidrRanges at the given index.
         */
        public java.lang.String getAllowedIpCidrRanges(int index) {
          return allowedIpCidrRanges_.get(index);
        }

        /**
         *
         *
         * <pre>
         * Optional. The list of IPv4 and IPv6 cidr blocks that are allowed to
         * operate or access the bucket and its underlying objects.
         * </pre>
         *
         * <code>
         * repeated string allowed_ip_cidr_ranges = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the allowedIpCidrRanges at the given index.
         */
        public com.google.protobuf.ByteString getAllowedIpCidrRangesBytes(int index) {
          return allowedIpCidrRanges_.getByteString(index);
        }

        /**
         *
         *
         * <pre>
         * Optional. The list of IPv4 and IPv6 cidr blocks that are allowed to
         * operate or access the bucket and its underlying objects.
         * </pre>
         *
         * <code>
         * repeated string allowed_ip_cidr_ranges = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index to set the value at.
         * @param value The allowedIpCidrRanges to set.
         * @return This builder for chaining.
         */
        public Builder setAllowedIpCidrRanges(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAllowedIpCidrRangesIsMutable();
          allowedIpCidrRanges_.set(index, value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The list of IPv4 and IPv6 cidr blocks that are allowed to
         * operate or access the bucket and its underlying objects.
         * </pre>
         *
         * <code>
         * repeated string allowed_ip_cidr_ranges = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The allowedIpCidrRanges to add.
         * @return This builder for chaining.
         */
        public Builder addAllowedIpCidrRanges(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAllowedIpCidrRangesIsMutable();
          allowedIpCidrRanges_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The list of IPv4 and IPv6 cidr blocks that are allowed to
         * operate or access the bucket and its underlying objects.
         * </pre>
         *
         * <code>
         * repeated string allowed_ip_cidr_ranges = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param values The allowedIpCidrRanges to add.
         * @return This builder for chaining.
         */
        public Builder addAllAllowedIpCidrRanges(java.lang.Iterable<java.lang.String> values) {
          ensureAllowedIpCidrRangesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowedIpCidrRanges_);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The list of IPv4 and IPv6 cidr blocks that are allowed to
         * operate or access the bucket and its underlying objects.
         * </pre>
         *
         * <code>
         * repeated string allowed_ip_cidr_ranges = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearAllowedIpCidrRanges() {
          allowedIpCidrRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          ;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The list of IPv4 and IPv6 cidr blocks that are allowed to
         * operate or access the bucket and its underlying objects.
         * </pre>
         *
         * <code>
         * repeated string allowed_ip_cidr_ranges = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The bytes of the allowedIpCidrRanges to add.
         * @return This builder for chaining.
         */
        public Builder addAllowedIpCidrRangesBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureAllowedIpCidrRangesIsMutable();
          allowedIpCidrRanges_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.IpFilter.PublicNetworkSource)
      }

      // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.IpFilter.PublicNetworkSource)
      private static final com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource();
      }

      public static com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<PublicNetworkSource> PARSER =
          new com.google.protobuf.AbstractParser<PublicNetworkSource>() {
            @java.lang.Override
            public PublicNetworkSource parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<PublicNetworkSource> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<PublicNetworkSource> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface VpcNetworkSourceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.IpFilter.VpcNetworkSource)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Name of the network.
       *
       * Format: `projects/PROJECT_ID/global/networks/NETWORK_NAME`
       * </pre>
       *
       * <code>optional string network = 1;</code>
       *
       * @return Whether the network field is set.
       */
      boolean hasNetwork();

      /**
       *
       *
       * <pre>
       * Name of the network.
       *
       * Format: `projects/PROJECT_ID/global/networks/NETWORK_NAME`
       * </pre>
       *
       * <code>optional string network = 1;</code>
       *
       * @return The network.
       */
      java.lang.String getNetwork();

      /**
       *
       *
       * <pre>
       * Name of the network.
       *
       * Format: `projects/PROJECT_ID/global/networks/NETWORK_NAME`
       * </pre>
       *
       * <code>optional string network = 1;</code>
       *
       * @return The bytes for network.
       */
      com.google.protobuf.ByteString getNetworkBytes();

      /**
       *
       *
       * <pre>
       * Optional. The list of public or private IPv4 and IPv6 CIDR ranges that
       * can access the bucket. In the CIDR IP address block, the specified IP
       * address must be properly truncated, meaning all the host bits must be
       * zero or else the input is considered malformed. For example,
       * `192.0.2.0/24` is accepted but `192.0.2.1/24` is not. Similarly, for
       * IPv6, `2001:db8::/32` is accepted whereas `2001:db8::1/32` is not.
       * </pre>
       *
       * <code>repeated string allowed_ip_cidr_ranges = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return A list containing the allowedIpCidrRanges.
       */
      java.util.List<java.lang.String> getAllowedIpCidrRangesList();

      /**
       *
       *
       * <pre>
       * Optional. The list of public or private IPv4 and IPv6 CIDR ranges that
       * can access the bucket. In the CIDR IP address block, the specified IP
       * address must be properly truncated, meaning all the host bits must be
       * zero or else the input is considered malformed. For example,
       * `192.0.2.0/24` is accepted but `192.0.2.1/24` is not. Similarly, for
       * IPv6, `2001:db8::/32` is accepted whereas `2001:db8::1/32` is not.
       * </pre>
       *
       * <code>repeated string allowed_ip_cidr_ranges = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The count of allowedIpCidrRanges.
       */
      int getAllowedIpCidrRangesCount();

      /**
       *
       *
       * <pre>
       * Optional. The list of public or private IPv4 and IPv6 CIDR ranges that
       * can access the bucket. In the CIDR IP address block, the specified IP
       * address must be properly truncated, meaning all the host bits must be
       * zero or else the input is considered malformed. For example,
       * `192.0.2.0/24` is accepted but `192.0.2.1/24` is not. Similarly, for
       * IPv6, `2001:db8::/32` is accepted whereas `2001:db8::1/32` is not.
       * </pre>
       *
       * <code>repeated string allowed_ip_cidr_ranges = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The allowedIpCidrRanges at the given index.
       */
      java.lang.String getAllowedIpCidrRanges(int index);

      /**
       *
       *
       * <pre>
       * Optional. The list of public or private IPv4 and IPv6 CIDR ranges that
       * can access the bucket. In the CIDR IP address block, the specified IP
       * address must be properly truncated, meaning all the host bits must be
       * zero or else the input is considered malformed. For example,
       * `192.0.2.0/24` is accepted but `192.0.2.1/24` is not. Similarly, for
       * IPv6, `2001:db8::/32` is accepted whereas `2001:db8::1/32` is not.
       * </pre>
       *
       * <code>repeated string allowed_ip_cidr_ranges = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the allowedIpCidrRanges at the given index.
       */
      com.google.protobuf.ByteString getAllowedIpCidrRangesBytes(int index);
    }

    /**
     *
     *
     * <pre>
     * The list of VPC networks that can access the bucket.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.IpFilter.VpcNetworkSource}
     */
    public static final class VpcNetworkSource extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.IpFilter.VpcNetworkSource)
        VpcNetworkSourceOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use VpcNetworkSource.newBuilder() to construct.
      private VpcNetworkSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private VpcNetworkSource() {
        network_ = "";
        allowedIpCidrRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new VpcNetworkSource();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_IpFilter_VpcNetworkSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_IpFilter_VpcNetworkSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource.class,
                com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource.Builder.class);
      }

      private int bitField0_;
      public static final int NETWORK_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object network_ = "";

      /**
       *
       *
       * <pre>
       * Name of the network.
       *
       * Format: `projects/PROJECT_ID/global/networks/NETWORK_NAME`
       * </pre>
       *
       * <code>optional string network = 1;</code>
       *
       * @return Whether the network field is set.
       */
      @java.lang.Override
      public boolean hasNetwork() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Name of the network.
       *
       * Format: `projects/PROJECT_ID/global/networks/NETWORK_NAME`
       * </pre>
       *
       * <code>optional string network = 1;</code>
       *
       * @return The network.
       */
      @java.lang.Override
      public java.lang.String getNetwork() {
        java.lang.Object ref = network_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          network_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Name of the network.
       *
       * Format: `projects/PROJECT_ID/global/networks/NETWORK_NAME`
       * </pre>
       *
       * <code>optional string network = 1;</code>
       *
       * @return The bytes for network.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getNetworkBytes() {
        java.lang.Object ref = network_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          network_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int ALLOWED_IP_CIDR_RANGES_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList allowedIpCidrRanges_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      /**
       *
       *
       * <pre>
       * Optional. The list of public or private IPv4 and IPv6 CIDR ranges that
       * can access the bucket. In the CIDR IP address block, the specified IP
       * address must be properly truncated, meaning all the host bits must be
       * zero or else the input is considered malformed. For example,
       * `192.0.2.0/24` is accepted but `192.0.2.1/24` is not. Similarly, for
       * IPv6, `2001:db8::/32` is accepted whereas `2001:db8::1/32` is not.
       * </pre>
       *
       * <code>repeated string allowed_ip_cidr_ranges = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return A list containing the allowedIpCidrRanges.
       */
      public com.google.protobuf.ProtocolStringList getAllowedIpCidrRangesList() {
        return allowedIpCidrRanges_;
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of public or private IPv4 and IPv6 CIDR ranges that
       * can access the bucket. In the CIDR IP address block, the specified IP
       * address must be properly truncated, meaning all the host bits must be
       * zero or else the input is considered malformed. For example,
       * `192.0.2.0/24` is accepted but `192.0.2.1/24` is not. Similarly, for
       * IPv6, `2001:db8::/32` is accepted whereas `2001:db8::1/32` is not.
       * </pre>
       *
       * <code>repeated string allowed_ip_cidr_ranges = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The count of allowedIpCidrRanges.
       */
      public int getAllowedIpCidrRangesCount() {
        return allowedIpCidrRanges_.size();
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of public or private IPv4 and IPv6 CIDR ranges that
       * can access the bucket. In the CIDR IP address block, the specified IP
       * address must be properly truncated, meaning all the host bits must be
       * zero or else the input is considered malformed. For example,
       * `192.0.2.0/24` is accepted but `192.0.2.1/24` is not. Similarly, for
       * IPv6, `2001:db8::/32` is accepted whereas `2001:db8::1/32` is not.
       * </pre>
       *
       * <code>repeated string allowed_ip_cidr_ranges = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The allowedIpCidrRanges at the given index.
       */
      public java.lang.String getAllowedIpCidrRanges(int index) {
        return allowedIpCidrRanges_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of public or private IPv4 and IPv6 CIDR ranges that
       * can access the bucket. In the CIDR IP address block, the specified IP
       * address must be properly truncated, meaning all the host bits must be
       * zero or else the input is considered malformed. For example,
       * `192.0.2.0/24` is accepted but `192.0.2.1/24` is not. Similarly, for
       * IPv6, `2001:db8::/32` is accepted whereas `2001:db8::1/32` is not.
       * </pre>
       *
       * <code>repeated string allowed_ip_cidr_ranges = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the allowedIpCidrRanges at the given index.
       */
      public com.google.protobuf.ByteString getAllowedIpCidrRangesBytes(int index) {
        return allowedIpCidrRanges_.getByteString(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, network_);
        }
        for (int i = 0; i < allowedIpCidrRanges_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(
              output, 2, allowedIpCidrRanges_.getRaw(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, network_);
        }
        {
          int dataSize = 0;
          for (int i = 0; i < allowedIpCidrRanges_.size(); i++) {
            dataSize += computeStringSizeNoTag(allowedIpCidrRanges_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getAllowedIpCidrRangesList().size();
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource)) {
          return super.equals(obj);
        }
        com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource other =
            (com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource) obj;

        if (hasNetwork() != other.hasNetwork()) return false;
        if (hasNetwork()) {
          if (!getNetwork().equals(other.getNetwork())) return false;
        }
        if (!getAllowedIpCidrRangesList().equals(other.getAllowedIpCidrRangesList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasNetwork()) {
          hash = (37 * hash) + NETWORK_FIELD_NUMBER;
          hash = (53 * hash) + getNetwork().hashCode();
        }
        if (getAllowedIpCidrRangesCount() > 0) {
          hash = (37 * hash) + ALLOWED_IP_CIDR_RANGES_FIELD_NUMBER;
          hash = (53 * hash) + getAllowedIpCidrRangesList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * The list of VPC networks that can access the bucket.
       * </pre>
       *
       * Protobuf type {@code google.storage.v2.Bucket.IpFilter.VpcNetworkSource}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.IpFilter.VpcNetworkSource)
          com.google.storage.v2.Bucket.IpFilter.VpcNetworkSourceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_IpFilter_VpcNetworkSource_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_IpFilter_VpcNetworkSource_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource.class,
                  com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource.Builder.class);
        }

        // Construct using com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          network_ = "";
          allowedIpCidrRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_Bucket_IpFilter_VpcNetworkSource_descriptor;
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource getDefaultInstanceForType() {
          return com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource build() {
          com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource buildPartial() {
          com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource result =
              new com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.network_ = network_;
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            allowedIpCidrRanges_.makeImmutable();
            result.allowedIpCidrRanges_ = allowedIpCidrRanges_;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource) {
            return mergeFrom((com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource other) {
          if (other == com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource.getDefaultInstance())
            return this;
          if (other.hasNetwork()) {
            network_ = other.network_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.allowedIpCidrRanges_.isEmpty()) {
            if (allowedIpCidrRanges_.isEmpty()) {
              allowedIpCidrRanges_ = other.allowedIpCidrRanges_;
              bitField0_ |= 0x00000002;
            } else {
              ensureAllowedIpCidrRangesIsMutable();
              allowedIpCidrRanges_.addAll(other.allowedIpCidrRanges_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    network_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureAllowedIpCidrRangesIsMutable();
                    allowedIpCidrRanges_.add(s);
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object network_ = "";

        /**
         *
         *
         * <pre>
         * Name of the network.
         *
         * Format: `projects/PROJECT_ID/global/networks/NETWORK_NAME`
         * </pre>
         *
         * <code>optional string network = 1;</code>
         *
         * @return Whether the network field is set.
         */
        public boolean hasNetwork() {
          return ((bitField0_ & 0x00000001) != 0);
        }

        /**
         *
         *
         * <pre>
         * Name of the network.
         *
         * Format: `projects/PROJECT_ID/global/networks/NETWORK_NAME`
         * </pre>
         *
         * <code>optional string network = 1;</code>
         *
         * @return The network.
         */
        public java.lang.String getNetwork() {
          java.lang.Object ref = network_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            network_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Name of the network.
         *
         * Format: `projects/PROJECT_ID/global/networks/NETWORK_NAME`
         * </pre>
         *
         * <code>optional string network = 1;</code>
         *
         * @return The bytes for network.
         */
        public com.google.protobuf.ByteString getNetworkBytes() {
          java.lang.Object ref = network_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            network_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Name of the network.
         *
         * Format: `projects/PROJECT_ID/global/networks/NETWORK_NAME`
         * </pre>
         *
         * <code>optional string network = 1;</code>
         *
         * @param value The network to set.
         * @return This builder for chaining.
         */
        public Builder setNetwork(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          network_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Name of the network.
         *
         * Format: `projects/PROJECT_ID/global/networks/NETWORK_NAME`
         * </pre>
         *
         * <code>optional string network = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearNetwork() {
          network_ = getDefaultInstance().getNetwork();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Name of the network.
         *
         * Format: `projects/PROJECT_ID/global/networks/NETWORK_NAME`
         * </pre>
         *
         * <code>optional string network = 1;</code>
         *
         * @param value The bytes for network to set.
         * @return This builder for chaining.
         */
        public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          network_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.protobuf.LazyStringArrayList allowedIpCidrRanges_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureAllowedIpCidrRangesIsMutable() {
          if (!allowedIpCidrRanges_.isModifiable()) {
            allowedIpCidrRanges_ =
                new com.google.protobuf.LazyStringArrayList(allowedIpCidrRanges_);
          }
          bitField0_ |= 0x00000002;
        }

        /**
         *
         *
         * <pre>
         * Optional. The list of public or private IPv4 and IPv6 CIDR ranges that
         * can access the bucket. In the CIDR IP address block, the specified IP
         * address must be properly truncated, meaning all the host bits must be
         * zero or else the input is considered malformed. For example,
         * `192.0.2.0/24` is accepted but `192.0.2.1/24` is not. Similarly, for
         * IPv6, `2001:db8::/32` is accepted whereas `2001:db8::1/32` is not.
         * </pre>
         *
         * <code>
         * repeated string allowed_ip_cidr_ranges = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return A list containing the allowedIpCidrRanges.
         */
        public com.google.protobuf.ProtocolStringList getAllowedIpCidrRangesList() {
          allowedIpCidrRanges_.makeImmutable();
          return allowedIpCidrRanges_;
        }

        /**
         *
         *
         * <pre>
         * Optional. The list of public or private IPv4 and IPv6 CIDR ranges that
         * can access the bucket. In the CIDR IP address block, the specified IP
         * address must be properly truncated, meaning all the host bits must be
         * zero or else the input is considered malformed. For example,
         * `192.0.2.0/24` is accepted but `192.0.2.1/24` is not. Similarly, for
         * IPv6, `2001:db8::/32` is accepted whereas `2001:db8::1/32` is not.
         * </pre>
         *
         * <code>
         * repeated string allowed_ip_cidr_ranges = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The count of allowedIpCidrRanges.
         */
        public int getAllowedIpCidrRangesCount() {
          return allowedIpCidrRanges_.size();
        }

        /**
         *
         *
         * <pre>
         * Optional. The list of public or private IPv4 and IPv6 CIDR ranges that
         * can access the bucket. In the CIDR IP address block, the specified IP
         * address must be properly truncated, meaning all the host bits must be
         * zero or else the input is considered malformed. For example,
         * `192.0.2.0/24` is accepted but `192.0.2.1/24` is not. Similarly, for
         * IPv6, `2001:db8::/32` is accepted whereas `2001:db8::1/32` is not.
         * </pre>
         *
         * <code>
         * repeated string allowed_ip_cidr_ranges = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index of the element to return.
         * @return The allowedIpCidrRanges at the given index.
         */
        public java.lang.String getAllowedIpCidrRanges(int index) {
          return allowedIpCidrRanges_.get(index);
        }

        /**
         *
         *
         * <pre>
         * Optional. The list of public or private IPv4 and IPv6 CIDR ranges that
         * can access the bucket. In the CIDR IP address block, the specified IP
         * address must be properly truncated, meaning all the host bits must be
         * zero or else the input is considered malformed. For example,
         * `192.0.2.0/24` is accepted but `192.0.2.1/24` is not. Similarly, for
         * IPv6, `2001:db8::/32` is accepted whereas `2001:db8::1/32` is not.
         * </pre>
         *
         * <code>
         * repeated string allowed_ip_cidr_ranges = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the allowedIpCidrRanges at the given index.
         */
        public com.google.protobuf.ByteString getAllowedIpCidrRangesBytes(int index) {
          return allowedIpCidrRanges_.getByteString(index);
        }

        /**
         *
         *
         * <pre>
         * Optional. The list of public or private IPv4 and IPv6 CIDR ranges that
         * can access the bucket. In the CIDR IP address block, the specified IP
         * address must be properly truncated, meaning all the host bits must be
         * zero or else the input is considered malformed. For example,
         * `192.0.2.0/24` is accepted but `192.0.2.1/24` is not. Similarly, for
         * IPv6, `2001:db8::/32` is accepted whereas `2001:db8::1/32` is not.
         * </pre>
         *
         * <code>
         * repeated string allowed_ip_cidr_ranges = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index to set the value at.
         * @param value The allowedIpCidrRanges to set.
         * @return This builder for chaining.
         */
        public Builder setAllowedIpCidrRanges(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAllowedIpCidrRangesIsMutable();
          allowedIpCidrRanges_.set(index, value);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The list of public or private IPv4 and IPv6 CIDR ranges that
         * can access the bucket. In the CIDR IP address block, the specified IP
         * address must be properly truncated, meaning all the host bits must be
         * zero or else the input is considered malformed. For example,
         * `192.0.2.0/24` is accepted but `192.0.2.1/24` is not. Similarly, for
         * IPv6, `2001:db8::/32` is accepted whereas `2001:db8::1/32` is not.
         * </pre>
         *
         * <code>
         * repeated string allowed_ip_cidr_ranges = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The allowedIpCidrRanges to add.
         * @return This builder for chaining.
         */
        public Builder addAllowedIpCidrRanges(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAllowedIpCidrRangesIsMutable();
          allowedIpCidrRanges_.add(value);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The list of public or private IPv4 and IPv6 CIDR ranges that
         * can access the bucket. In the CIDR IP address block, the specified IP
         * address must be properly truncated, meaning all the host bits must be
         * zero or else the input is considered malformed. For example,
         * `192.0.2.0/24` is accepted but `192.0.2.1/24` is not. Similarly, for
         * IPv6, `2001:db8::/32` is accepted whereas `2001:db8::1/32` is not.
         * </pre>
         *
         * <code>
         * repeated string allowed_ip_cidr_ranges = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param values The allowedIpCidrRanges to add.
         * @return This builder for chaining.
         */
        public Builder addAllAllowedIpCidrRanges(java.lang.Iterable<java.lang.String> values) {
          ensureAllowedIpCidrRangesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowedIpCidrRanges_);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The list of public or private IPv4 and IPv6 CIDR ranges that
         * can access the bucket. In the CIDR IP address block, the specified IP
         * address must be properly truncated, meaning all the host bits must be
         * zero or else the input is considered malformed. For example,
         * `192.0.2.0/24` is accepted but `192.0.2.1/24` is not. Similarly, for
         * IPv6, `2001:db8::/32` is accepted whereas `2001:db8::1/32` is not.
         * </pre>
         *
         * <code>
         * repeated string allowed_ip_cidr_ranges = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearAllowedIpCidrRanges() {
          allowedIpCidrRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          ;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The list of public or private IPv4 and IPv6 CIDR ranges that
         * can access the bucket. In the CIDR IP address block, the specified IP
         * address must be properly truncated, meaning all the host bits must be
         * zero or else the input is considered malformed. For example,
         * `192.0.2.0/24` is accepted but `192.0.2.1/24` is not. Similarly, for
         * IPv6, `2001:db8::/32` is accepted whereas `2001:db8::1/32` is not.
         * </pre>
         *
         * <code>
         * repeated string allowed_ip_cidr_ranges = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The bytes of the allowedIpCidrRanges to add.
         * @return This builder for chaining.
         */
        public Builder addAllowedIpCidrRangesBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureAllowedIpCidrRangesIsMutable();
          allowedIpCidrRanges_.add(value);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.IpFilter.VpcNetworkSource)
      }

      // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.IpFilter.VpcNetworkSource)
      private static final com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource();
      }

      public static com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<VpcNetworkSource> PARSER =
          new com.google.protobuf.AbstractParser<VpcNetworkSource>() {
            @java.lang.Override
            public VpcNetworkSource parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<VpcNetworkSource> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<VpcNetworkSource> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int MODE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object mode_ = "";

    /**
     *
     *
     * <pre>
     * The state of the IP filter configuration. Valid values are `Enabled` and
     * `Disabled`. When set to `Enabled`, IP filtering rules are applied to a
     * bucket and all incoming requests to the bucket are evaluated against
     * these rules. When set to `Disabled`, IP filtering rules are not applied
     * to a bucket.".
     * </pre>
     *
     * <code>optional string mode = 1;</code>
     *
     * @return Whether the mode field is set.
     */
    @java.lang.Override
    public boolean hasMode() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The state of the IP filter configuration. Valid values are `Enabled` and
     * `Disabled`. When set to `Enabled`, IP filtering rules are applied to a
     * bucket and all incoming requests to the bucket are evaluated against
     * these rules. When set to `Disabled`, IP filtering rules are not applied
     * to a bucket.".
     * </pre>
     *
     * <code>optional string mode = 1;</code>
     *
     * @return The mode.
     */
    @java.lang.Override
    public java.lang.String getMode() {
      java.lang.Object ref = mode_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        mode_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The state of the IP filter configuration. Valid values are `Enabled` and
     * `Disabled`. When set to `Enabled`, IP filtering rules are applied to a
     * bucket and all incoming requests to the bucket are evaluated against
     * these rules. When set to `Disabled`, IP filtering rules are not applied
     * to a bucket.".
     * </pre>
     *
     * <code>optional string mode = 1;</code>
     *
     * @return The bytes for mode.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getModeBytes() {
      java.lang.Object ref = mode_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        mode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PUBLIC_NETWORK_SOURCE_FIELD_NUMBER = 2;
    private com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource publicNetworkSource_;

    /**
     *
     *
     * <pre>
     * Public IPs allowed to operate or access the bucket.
     * </pre>
     *
     * <code>
     * optional .google.storage.v2.Bucket.IpFilter.PublicNetworkSource public_network_source = 2;
     * </code>
     *
     * @return Whether the publicNetworkSource field is set.
     */
    @java.lang.Override
    public boolean hasPublicNetworkSource() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Public IPs allowed to operate or access the bucket.
     * </pre>
     *
     * <code>
     * optional .google.storage.v2.Bucket.IpFilter.PublicNetworkSource public_network_source = 2;
     * </code>
     *
     * @return The publicNetworkSource.
     */
    @java.lang.Override
    public com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource getPublicNetworkSource() {
      return publicNetworkSource_ == null
          ? com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource.getDefaultInstance()
          : publicNetworkSource_;
    }

    /**
     *
     *
     * <pre>
     * Public IPs allowed to operate or access the bucket.
     * </pre>
     *
     * <code>
     * optional .google.storage.v2.Bucket.IpFilter.PublicNetworkSource public_network_source = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.storage.v2.Bucket.IpFilter.PublicNetworkSourceOrBuilder
        getPublicNetworkSourceOrBuilder() {
      return publicNetworkSource_ == null
          ? com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource.getDefaultInstance()
          : publicNetworkSource_;
    }

    public static final int VPC_NETWORK_SOURCES_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private java.util.List<com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource>
        vpcNetworkSources_;

    /**
     *
     *
     * <pre>
     * Optional. The list of network sources that are allowed to access
     * operations on the bucket or the underlying objects.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.Bucket.IpFilter.VpcNetworkSource vpc_network_sources = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource>
        getVpcNetworkSourcesList() {
      return vpcNetworkSources_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of network sources that are allowed to access
     * operations on the bucket or the underlying objects.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.Bucket.IpFilter.VpcNetworkSource vpc_network_sources = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.storage.v2.Bucket.IpFilter.VpcNetworkSourceOrBuilder>
        getVpcNetworkSourcesOrBuilderList() {
      return vpcNetworkSources_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of network sources that are allowed to access
     * operations on the bucket or the underlying objects.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.Bucket.IpFilter.VpcNetworkSource vpc_network_sources = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public int getVpcNetworkSourcesCount() {
      return vpcNetworkSources_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of network sources that are allowed to access
     * operations on the bucket or the underlying objects.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.Bucket.IpFilter.VpcNetworkSource vpc_network_sources = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource getVpcNetworkSources(int index) {
      return vpcNetworkSources_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of network sources that are allowed to access
     * operations on the bucket or the underlying objects.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.Bucket.IpFilter.VpcNetworkSource vpc_network_sources = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.storage.v2.Bucket.IpFilter.VpcNetworkSourceOrBuilder
        getVpcNetworkSourcesOrBuilder(int index) {
      return vpcNetworkSources_.get(index);
    }

    public static final int ALLOW_CROSS_ORG_VPCS_FIELD_NUMBER = 4;
    private boolean allowCrossOrgVpcs_ = false;

    /**
     *
     *
     * <pre>
     * Optional. Whether or not to allow VPCs from orgs different than the
     * bucket's parent org to access the bucket. When set to true, validations
     * on the existence of the VPCs won't be performed. If set to false, each
     * VPC network source will be checked to belong to the same org as the
     * bucket as well as validated for existence.
     * </pre>
     *
     * <code>bool allow_cross_org_vpcs = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The allowCrossOrgVpcs.
     */
    @java.lang.Override
    public boolean getAllowCrossOrgVpcs() {
      return allowCrossOrgVpcs_;
    }

    public static final int ALLOW_ALL_SERVICE_AGENT_ACCESS_FIELD_NUMBER = 5;
    private boolean allowAllServiceAgentAccess_ = false;

    /**
     *
     *
     * <pre>
     * Whether or not to allow all P4SA access to the bucket. When set to true,
     * IP filter config validation will not apply.
     * </pre>
     *
     * <code>optional bool allow_all_service_agent_access = 5;</code>
     *
     * @return Whether the allowAllServiceAgentAccess field is set.
     */
    @java.lang.Override
    public boolean hasAllowAllServiceAgentAccess() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Whether or not to allow all P4SA access to the bucket. When set to true,
     * IP filter config validation will not apply.
     * </pre>
     *
     * <code>optional bool allow_all_service_agent_access = 5;</code>
     *
     * @return The allowAllServiceAgentAccess.
     */
    @java.lang.Override
    public boolean getAllowAllServiceAgentAccess() {
      return allowAllServiceAgentAccess_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, mode_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getPublicNetworkSource());
      }
      for (int i = 0; i < vpcNetworkSources_.size(); i++) {
        output.writeMessage(3, vpcNetworkSources_.get(i));
      }
      if (allowCrossOrgVpcs_ != false) {
        output.writeBool(4, allowCrossOrgVpcs_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeBool(5, allowAllServiceAgentAccess_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, mode_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(2, getPublicNetworkSource());
      }
      for (int i = 0; i < vpcNetworkSources_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(3, vpcNetworkSources_.get(i));
      }
      if (allowCrossOrgVpcs_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, allowCrossOrgVpcs_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(5, allowAllServiceAgentAccess_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Bucket.IpFilter)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Bucket.IpFilter other = (com.google.storage.v2.Bucket.IpFilter) obj;

      if (hasMode() != other.hasMode()) return false;
      if (hasMode()) {
        if (!getMode().equals(other.getMode())) return false;
      }
      if (hasPublicNetworkSource() != other.hasPublicNetworkSource()) return false;
      if (hasPublicNetworkSource()) {
        if (!getPublicNetworkSource().equals(other.getPublicNetworkSource())) return false;
      }
      if (!getVpcNetworkSourcesList().equals(other.getVpcNetworkSourcesList())) return false;
      if (getAllowCrossOrgVpcs() != other.getAllowCrossOrgVpcs()) return false;
      if (hasAllowAllServiceAgentAccess() != other.hasAllowAllServiceAgentAccess()) return false;
      if (hasAllowAllServiceAgentAccess()) {
        if (getAllowAllServiceAgentAccess() != other.getAllowAllServiceAgentAccess()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMode()) {
        hash = (37 * hash) + MODE_FIELD_NUMBER;
        hash = (53 * hash) + getMode().hashCode();
      }
      if (hasPublicNetworkSource()) {
        hash = (37 * hash) + PUBLIC_NETWORK_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getPublicNetworkSource().hashCode();
      }
      if (getVpcNetworkSourcesCount() > 0) {
        hash = (37 * hash) + VPC_NETWORK_SOURCES_FIELD_NUMBER;
        hash = (53 * hash) + getVpcNetworkSourcesList().hashCode();
      }
      hash = (37 * hash) + ALLOW_CROSS_ORG_VPCS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowCrossOrgVpcs());
      if (hasAllowAllServiceAgentAccess()) {
        hash = (37 * hash) + ALLOW_ALL_SERVICE_AGENT_ACCESS_FIELD_NUMBER;
        hash =
            (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowAllServiceAgentAccess());
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Bucket.IpFilter parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.IpFilter parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.IpFilter parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.IpFilter parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.IpFilter parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Bucket.IpFilter parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.IpFilter parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.IpFilter parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.IpFilter parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.IpFilter parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Bucket.IpFilter parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Bucket.IpFilter parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Bucket.IpFilter prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * The [bucket IP
     * filtering](https://cloud.google.com/storage/docs/ip-filtering-overview)
     * configuration. Specifies the network sources that can access the bucket, as
     * well as its underlying objects.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Bucket.IpFilter}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Bucket.IpFilter)
        com.google.storage.v2.Bucket.IpFilterOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_IpFilter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_IpFilter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Bucket.IpFilter.class,
                com.google.storage.v2.Bucket.IpFilter.Builder.class);
      }

      // Construct using com.google.storage.v2.Bucket.IpFilter.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getPublicNetworkSourceFieldBuilder();
          getVpcNetworkSourcesFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        mode_ = "";
        publicNetworkSource_ = null;
        if (publicNetworkSourceBuilder_ != null) {
          publicNetworkSourceBuilder_.dispose();
          publicNetworkSourceBuilder_ = null;
        }
        if (vpcNetworkSourcesBuilder_ == null) {
          vpcNetworkSources_ = java.util.Collections.emptyList();
        } else {
          vpcNetworkSources_ = null;
          vpcNetworkSourcesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        allowCrossOrgVpcs_ = false;
        allowAllServiceAgentAccess_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Bucket_IpFilter_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.IpFilter getDefaultInstanceForType() {
        return com.google.storage.v2.Bucket.IpFilter.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.IpFilter build() {
        com.google.storage.v2.Bucket.IpFilter result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Bucket.IpFilter buildPartial() {
        com.google.storage.v2.Bucket.IpFilter result =
            new com.google.storage.v2.Bucket.IpFilter(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(com.google.storage.v2.Bucket.IpFilter result) {
        if (vpcNetworkSourcesBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            vpcNetworkSources_ = java.util.Collections.unmodifiableList(vpcNetworkSources_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.vpcNetworkSources_ = vpcNetworkSources_;
        } else {
          result.vpcNetworkSources_ = vpcNetworkSourcesBuilder_.build();
        }
      }

      private void buildPartial0(com.google.storage.v2.Bucket.IpFilter result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.mode_ = mode_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.publicNetworkSource_ =
              publicNetworkSourceBuilder_ == null
                  ? publicNetworkSource_
                  : publicNetworkSourceBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.allowCrossOrgVpcs_ = allowCrossOrgVpcs_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.allowAllServiceAgentAccess_ = allowAllServiceAgentAccess_;
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Bucket.IpFilter) {
          return mergeFrom((com.google.storage.v2.Bucket.IpFilter) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Bucket.IpFilter other) {
        if (other == com.google.storage.v2.Bucket.IpFilter.getDefaultInstance()) return this;
        if (other.hasMode()) {
          mode_ = other.mode_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasPublicNetworkSource()) {
          mergePublicNetworkSource(other.getPublicNetworkSource());
        }
        if (vpcNetworkSourcesBuilder_ == null) {
          if (!other.vpcNetworkSources_.isEmpty()) {
            if (vpcNetworkSources_.isEmpty()) {
              vpcNetworkSources_ = other.vpcNetworkSources_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureVpcNetworkSourcesIsMutable();
              vpcNetworkSources_.addAll(other.vpcNetworkSources_);
            }
            onChanged();
          }
        } else {
          if (!other.vpcNetworkSources_.isEmpty()) {
            if (vpcNetworkSourcesBuilder_.isEmpty()) {
              vpcNetworkSourcesBuilder_.dispose();
              vpcNetworkSourcesBuilder_ = null;
              vpcNetworkSources_ = other.vpcNetworkSources_;
              bitField0_ = (bitField0_ & ~0x00000004);
              vpcNetworkSourcesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getVpcNetworkSourcesFieldBuilder()
                      : null;
            } else {
              vpcNetworkSourcesBuilder_.addAllMessages(other.vpcNetworkSources_);
            }
          }
        }
        if (other.getAllowCrossOrgVpcs() != false) {
          setAllowCrossOrgVpcs(other.getAllowCrossOrgVpcs());
        }
        if (other.hasAllowAllServiceAgentAccess()) {
          setAllowAllServiceAgentAccess(other.getAllowAllServiceAgentAccess());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  mode_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getPublicNetworkSourceFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource m =
                      input.readMessage(
                          com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource.parser(),
                          extensionRegistry);
                  if (vpcNetworkSourcesBuilder_ == null) {
                    ensureVpcNetworkSourcesIsMutable();
                    vpcNetworkSources_.add(m);
                  } else {
                    vpcNetworkSourcesBuilder_.addMessage(m);
                  }
                  break;
                } // case 26
              case 32:
                {
                  allowCrossOrgVpcs_ = input.readBool();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              case 40:
                {
                  allowAllServiceAgentAccess_ = input.readBool();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 40
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object mode_ = "";

      /**
       *
       *
       * <pre>
       * The state of the IP filter configuration. Valid values are `Enabled` and
       * `Disabled`. When set to `Enabled`, IP filtering rules are applied to a
       * bucket and all incoming requests to the bucket are evaluated against
       * these rules. When set to `Disabled`, IP filtering rules are not applied
       * to a bucket.".
       * </pre>
       *
       * <code>optional string mode = 1;</code>
       *
       * @return Whether the mode field is set.
       */
      public boolean hasMode() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * The state of the IP filter configuration. Valid values are `Enabled` and
       * `Disabled`. When set to `Enabled`, IP filtering rules are applied to a
       * bucket and all incoming requests to the bucket are evaluated against
       * these rules. When set to `Disabled`, IP filtering rules are not applied
       * to a bucket.".
       * </pre>
       *
       * <code>optional string mode = 1;</code>
       *
       * @return The mode.
       */
      public java.lang.String getMode() {
        java.lang.Object ref = mode_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          mode_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The state of the IP filter configuration. Valid values are `Enabled` and
       * `Disabled`. When set to `Enabled`, IP filtering rules are applied to a
       * bucket and all incoming requests to the bucket are evaluated against
       * these rules. When set to `Disabled`, IP filtering rules are not applied
       * to a bucket.".
       * </pre>
       *
       * <code>optional string mode = 1;</code>
       *
       * @return The bytes for mode.
       */
      public com.google.protobuf.ByteString getModeBytes() {
        java.lang.Object ref = mode_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          mode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The state of the IP filter configuration. Valid values are `Enabled` and
       * `Disabled`. When set to `Enabled`, IP filtering rules are applied to a
       * bucket and all incoming requests to the bucket are evaluated against
       * these rules. When set to `Disabled`, IP filtering rules are not applied
       * to a bucket.".
       * </pre>
       *
       * <code>optional string mode = 1;</code>
       *
       * @param value The mode to set.
       * @return This builder for chaining.
       */
      public Builder setMode(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        mode_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The state of the IP filter configuration. Valid values are `Enabled` and
       * `Disabled`. When set to `Enabled`, IP filtering rules are applied to a
       * bucket and all incoming requests to the bucket are evaluated against
       * these rules. When set to `Disabled`, IP filtering rules are not applied
       * to a bucket.".
       * </pre>
       *
       * <code>optional string mode = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMode() {
        mode_ = getDefaultInstance().getMode();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The state of the IP filter configuration. Valid values are `Enabled` and
       * `Disabled`. When set to `Enabled`, IP filtering rules are applied to a
       * bucket and all incoming requests to the bucket are evaluated against
       * these rules. When set to `Disabled`, IP filtering rules are not applied
       * to a bucket.".
       * </pre>
       *
       * <code>optional string mode = 1;</code>
       *
       * @param value The bytes for mode to set.
       * @return This builder for chaining.
       */
      public Builder setModeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        mode_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource publicNetworkSource_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource,
              com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource.Builder,
              com.google.storage.v2.Bucket.IpFilter.PublicNetworkSourceOrBuilder>
          publicNetworkSourceBuilder_;

      /**
       *
       *
       * <pre>
       * Public IPs allowed to operate or access the bucket.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.IpFilter.PublicNetworkSource public_network_source = 2;
       * </code>
       *
       * @return Whether the publicNetworkSource field is set.
       */
      public boolean hasPublicNetworkSource() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Public IPs allowed to operate or access the bucket.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.IpFilter.PublicNetworkSource public_network_source = 2;
       * </code>
       *
       * @return The publicNetworkSource.
       */
      public com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource getPublicNetworkSource() {
        if (publicNetworkSourceBuilder_ == null) {
          return publicNetworkSource_ == null
              ? com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource.getDefaultInstance()
              : publicNetworkSource_;
        } else {
          return publicNetworkSourceBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Public IPs allowed to operate or access the bucket.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.IpFilter.PublicNetworkSource public_network_source = 2;
       * </code>
       */
      public Builder setPublicNetworkSource(
          com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource value) {
        if (publicNetworkSourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          publicNetworkSource_ = value;
        } else {
          publicNetworkSourceBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Public IPs allowed to operate or access the bucket.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.IpFilter.PublicNetworkSource public_network_source = 2;
       * </code>
       */
      public Builder setPublicNetworkSource(
          com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource.Builder builderForValue) {
        if (publicNetworkSourceBuilder_ == null) {
          publicNetworkSource_ = builderForValue.build();
        } else {
          publicNetworkSourceBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Public IPs allowed to operate or access the bucket.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.IpFilter.PublicNetworkSource public_network_source = 2;
       * </code>
       */
      public Builder mergePublicNetworkSource(
          com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource value) {
        if (publicNetworkSourceBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && publicNetworkSource_ != null
              && publicNetworkSource_
                  != com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource
                      .getDefaultInstance()) {
            getPublicNetworkSourceBuilder().mergeFrom(value);
          } else {
            publicNetworkSource_ = value;
          }
        } else {
          publicNetworkSourceBuilder_.mergeFrom(value);
        }
        if (publicNetworkSource_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Public IPs allowed to operate or access the bucket.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.IpFilter.PublicNetworkSource public_network_source = 2;
       * </code>
       */
      public Builder clearPublicNetworkSource() {
        bitField0_ = (bitField0_ & ~0x00000002);
        publicNetworkSource_ = null;
        if (publicNetworkSourceBuilder_ != null) {
          publicNetworkSourceBuilder_.dispose();
          publicNetworkSourceBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Public IPs allowed to operate or access the bucket.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.IpFilter.PublicNetworkSource public_network_source = 2;
       * </code>
       */
      public com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource.Builder
          getPublicNetworkSourceBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getPublicNetworkSourceFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Public IPs allowed to operate or access the bucket.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.IpFilter.PublicNetworkSource public_network_source = 2;
       * </code>
       */
      public com.google.storage.v2.Bucket.IpFilter.PublicNetworkSourceOrBuilder
          getPublicNetworkSourceOrBuilder() {
        if (publicNetworkSourceBuilder_ != null) {
          return publicNetworkSourceBuilder_.getMessageOrBuilder();
        } else {
          return publicNetworkSource_ == null
              ? com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource.getDefaultInstance()
              : publicNetworkSource_;
        }
      }

      /**
       *
       *
       * <pre>
       * Public IPs allowed to operate or access the bucket.
       * </pre>
       *
       * <code>
       * optional .google.storage.v2.Bucket.IpFilter.PublicNetworkSource public_network_source = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource,
              com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource.Builder,
              com.google.storage.v2.Bucket.IpFilter.PublicNetworkSourceOrBuilder>
          getPublicNetworkSourceFieldBuilder() {
        if (publicNetworkSourceBuilder_ == null) {
          publicNetworkSourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource,
                  com.google.storage.v2.Bucket.IpFilter.PublicNetworkSource.Builder,
                  com.google.storage.v2.Bucket.IpFilter.PublicNetworkSourceOrBuilder>(
                  getPublicNetworkSource(), getParentForChildren(), isClean());
          publicNetworkSource_ = null;
        }
        return publicNetworkSourceBuilder_;
      }

      private java.util.List<com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource>
          vpcNetworkSources_ = java.util.Collections.emptyList();

      private void ensureVpcNetworkSourcesIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          vpcNetworkSources_ =
              new java.util.ArrayList<com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource>(
                  vpcNetworkSources_);
          bitField0_ |= 0x00000004;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource,
              com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource.Builder,
              com.google.storage.v2.Bucket.IpFilter.VpcNetworkSourceOrBuilder>
          vpcNetworkSourcesBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. The list of network sources that are allowed to access
       * operations on the bucket or the underlying objects.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.IpFilter.VpcNetworkSource vpc_network_sources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource>
          getVpcNetworkSourcesList() {
        if (vpcNetworkSourcesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(vpcNetworkSources_);
        } else {
          return vpcNetworkSourcesBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of network sources that are allowed to access
       * operations on the bucket or the underlying objects.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.IpFilter.VpcNetworkSource vpc_network_sources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public int getVpcNetworkSourcesCount() {
        if (vpcNetworkSourcesBuilder_ == null) {
          return vpcNetworkSources_.size();
        } else {
          return vpcNetworkSourcesBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of network sources that are allowed to access
       * operations on the bucket or the underlying objects.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.IpFilter.VpcNetworkSource vpc_network_sources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource getVpcNetworkSources(
          int index) {
        if (vpcNetworkSourcesBuilder_ == null) {
          return vpcNetworkSources_.get(index);
        } else {
          return vpcNetworkSourcesBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of network sources that are allowed to access
       * operations on the bucket or the underlying objects.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.IpFilter.VpcNetworkSource vpc_network_sources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setVpcNetworkSources(
          int index, com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource value) {
        if (vpcNetworkSourcesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureVpcNetworkSourcesIsMutable();
          vpcNetworkSources_.set(index, value);
          onChanged();
        } else {
          vpcNetworkSourcesBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of network sources that are allowed to access
       * operations on the bucket or the underlying objects.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.IpFilter.VpcNetworkSource vpc_network_sources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setVpcNetworkSources(
          int index,
          com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource.Builder builderForValue) {
        if (vpcNetworkSourcesBuilder_ == null) {
          ensureVpcNetworkSourcesIsMutable();
          vpcNetworkSources_.set(index, builderForValue.build());
          onChanged();
        } else {
          vpcNetworkSourcesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of network sources that are allowed to access
       * operations on the bucket or the underlying objects.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.IpFilter.VpcNetworkSource vpc_network_sources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addVpcNetworkSources(
          com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource value) {
        if (vpcNetworkSourcesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureVpcNetworkSourcesIsMutable();
          vpcNetworkSources_.add(value);
          onChanged();
        } else {
          vpcNetworkSourcesBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of network sources that are allowed to access
       * operations on the bucket or the underlying objects.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.IpFilter.VpcNetworkSource vpc_network_sources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addVpcNetworkSources(
          int index, com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource value) {
        if (vpcNetworkSourcesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureVpcNetworkSourcesIsMutable();
          vpcNetworkSources_.add(index, value);
          onChanged();
        } else {
          vpcNetworkSourcesBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of network sources that are allowed to access
       * operations on the bucket or the underlying objects.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.IpFilter.VpcNetworkSource vpc_network_sources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addVpcNetworkSources(
          com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource.Builder builderForValue) {
        if (vpcNetworkSourcesBuilder_ == null) {
          ensureVpcNetworkSourcesIsMutable();
          vpcNetworkSources_.add(builderForValue.build());
          onChanged();
        } else {
          vpcNetworkSourcesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of network sources that are allowed to access
       * operations on the bucket or the underlying objects.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.IpFilter.VpcNetworkSource vpc_network_sources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addVpcNetworkSources(
          int index,
          com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource.Builder builderForValue) {
        if (vpcNetworkSourcesBuilder_ == null) {
          ensureVpcNetworkSourcesIsMutable();
          vpcNetworkSources_.add(index, builderForValue.build());
          onChanged();
        } else {
          vpcNetworkSourcesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of network sources that are allowed to access
       * operations on the bucket or the underlying objects.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.IpFilter.VpcNetworkSource vpc_network_sources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAllVpcNetworkSources(
          java.lang.Iterable<? extends com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource>
              values) {
        if (vpcNetworkSourcesBuilder_ == null) {
          ensureVpcNetworkSourcesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, vpcNetworkSources_);
          onChanged();
        } else {
          vpcNetworkSourcesBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of network sources that are allowed to access
       * operations on the bucket or the underlying objects.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.IpFilter.VpcNetworkSource vpc_network_sources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearVpcNetworkSources() {
        if (vpcNetworkSourcesBuilder_ == null) {
          vpcNetworkSources_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          vpcNetworkSourcesBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of network sources that are allowed to access
       * operations on the bucket or the underlying objects.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.IpFilter.VpcNetworkSource vpc_network_sources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeVpcNetworkSources(int index) {
        if (vpcNetworkSourcesBuilder_ == null) {
          ensureVpcNetworkSourcesIsMutable();
          vpcNetworkSources_.remove(index);
          onChanged();
        } else {
          vpcNetworkSourcesBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of network sources that are allowed to access
       * operations on the bucket or the underlying objects.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.IpFilter.VpcNetworkSource vpc_network_sources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource.Builder
          getVpcNetworkSourcesBuilder(int index) {
        return getVpcNetworkSourcesFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of network sources that are allowed to access
       * operations on the bucket or the underlying objects.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.IpFilter.VpcNetworkSource vpc_network_sources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.storage.v2.Bucket.IpFilter.VpcNetworkSourceOrBuilder
          getVpcNetworkSourcesOrBuilder(int index) {
        if (vpcNetworkSourcesBuilder_ == null) {
          return vpcNetworkSources_.get(index);
        } else {
          return vpcNetworkSourcesBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of network sources that are allowed to access
       * operations on the bucket or the underlying objects.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.IpFilter.VpcNetworkSource vpc_network_sources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              ? extends com.google.storage.v2.Bucket.IpFilter.VpcNetworkSourceOrBuilder>
          getVpcNetworkSourcesOrBuilderList() {
        if (vpcNetworkSourcesBuilder_ != null) {
          return vpcNetworkSourcesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(vpcNetworkSources_);
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of network sources that are allowed to access
       * operations on the bucket or the underlying objects.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.IpFilter.VpcNetworkSource vpc_network_sources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource.Builder
          addVpcNetworkSourcesBuilder() {
        return getVpcNetworkSourcesFieldBuilder()
            .addBuilder(
                com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of network sources that are allowed to access
       * operations on the bucket or the underlying objects.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.IpFilter.VpcNetworkSource vpc_network_sources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource.Builder
          addVpcNetworkSourcesBuilder(int index) {
        return getVpcNetworkSourcesFieldBuilder()
            .addBuilder(
                index, com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Optional. The list of network sources that are allowed to access
       * operations on the bucket or the underlying objects.
       * </pre>
       *
       * <code>
       * repeated .google.storage.v2.Bucket.IpFilter.VpcNetworkSource vpc_network_sources = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource.Builder>
          getVpcNetworkSourcesBuilderList() {
        return getVpcNetworkSourcesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource,
              com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource.Builder,
              com.google.storage.v2.Bucket.IpFilter.VpcNetworkSourceOrBuilder>
          getVpcNetworkSourcesFieldBuilder() {
        if (vpcNetworkSourcesBuilder_ == null) {
          vpcNetworkSourcesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource,
                  com.google.storage.v2.Bucket.IpFilter.VpcNetworkSource.Builder,
                  com.google.storage.v2.Bucket.IpFilter.VpcNetworkSourceOrBuilder>(
                  vpcNetworkSources_,
                  ((bitField0_ & 0x00000004) != 0),
                  getParentForChildren(),
                  isClean());
          vpcNetworkSources_ = null;
        }
        return vpcNetworkSourcesBuilder_;
      }

      private boolean allowCrossOrgVpcs_;

      /**
       *
       *
       * <pre>
       * Optional. Whether or not to allow VPCs from orgs different than the
       * bucket's parent org to access the bucket. When set to true, validations
       * on the existence of the VPCs won't be performed. If set to false, each
       * VPC network source will be checked to belong to the same org as the
       * bucket as well as validated for existence.
       * </pre>
       *
       * <code>bool allow_cross_org_vpcs = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The allowCrossOrgVpcs.
       */
      @java.lang.Override
      public boolean getAllowCrossOrgVpcs() {
        return allowCrossOrgVpcs_;
      }

      /**
       *
       *
       * <pre>
       * Optional. Whether or not to allow VPCs from orgs different than the
       * bucket's parent org to access the bucket. When set to true, validations
       * on the existence of the VPCs won't be performed. If set to false, each
       * VPC network source will be checked to belong to the same org as the
       * bucket as well as validated for existence.
       * </pre>
       *
       * <code>bool allow_cross_org_vpcs = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The allowCrossOrgVpcs to set.
       * @return This builder for chaining.
       */
      public Builder setAllowCrossOrgVpcs(boolean value) {

        allowCrossOrgVpcs_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Whether or not to allow VPCs from orgs different than the
       * bucket's parent org to access the bucket. When set to true, validations
       * on the existence of the VPCs won't be performed. If set to false, each
       * VPC network source will be checked to belong to the same org as the
       * bucket as well as validated for existence.
       * </pre>
       *
       * <code>bool allow_cross_org_vpcs = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllowCrossOrgVpcs() {
        bitField0_ = (bitField0_ & ~0x00000008);
        allowCrossOrgVpcs_ = false;
        onChanged();
        return this;
      }

      private boolean allowAllServiceAgentAccess_;

      /**
       *
       *
       * <pre>
       * Whether or not to allow all P4SA access to the bucket. When set to true,
       * IP filter config validation will not apply.
       * </pre>
       *
       * <code>optional bool allow_all_service_agent_access = 5;</code>
       *
       * @return Whether the allowAllServiceAgentAccess field is set.
       */
      @java.lang.Override
      public boolean hasAllowAllServiceAgentAccess() {
        return ((bitField0_ & 0x00000010) != 0);
      }

      /**
       *
       *
       * <pre>
       * Whether or not to allow all P4SA access to the bucket. When set to true,
       * IP filter config validation will not apply.
       * </pre>
       *
       * <code>optional bool allow_all_service_agent_access = 5;</code>
       *
       * @return The allowAllServiceAgentAccess.
       */
      @java.lang.Override
      public boolean getAllowAllServiceAgentAccess() {
        return allowAllServiceAgentAccess_;
      }

      /**
       *
       *
       * <pre>
       * Whether or not to allow all P4SA access to the bucket. When set to true,
       * IP filter config validation will not apply.
       * </pre>
       *
       * <code>optional bool allow_all_service_agent_access = 5;</code>
       *
       * @param value The allowAllServiceAgentAccess to set.
       * @return This builder for chaining.
       */
      public Builder setAllowAllServiceAgentAccess(boolean value) {

        allowAllServiceAgentAccess_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Whether or not to allow all P4SA access to the bucket. When set to true,
       * IP filter config validation will not apply.
       * </pre>
       *
       * <code>optional bool allow_all_service_agent_access = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllowAllServiceAgentAccess() {
        bitField0_ = (bitField0_ & ~0x00000010);
        allowAllServiceAgentAccess_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Bucket.IpFilter)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Bucket.IpFilter)
    private static final com.google.storage.v2.Bucket.IpFilter DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Bucket.IpFilter();
    }

    public static com.google.storage.v2.Bucket.IpFilter getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<IpFilter> PARSER =
        new com.google.protobuf.AbstractParser<IpFilter>() {
          @java.lang.Override
          public IpFilter parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<IpFilter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IpFilter> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Bucket.IpFilter getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface HierarchicalNamespaceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Bucket.HierarchicalNamespace)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Enables the hierarchical namespace feature.
     * </pre>
     *
     * <code>bool enabled = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enabled.
     */
    boolean getEnabled();
  }

  /**
   *
   *
   * <pre>
   * Configuration for a bucket's hierarchical namespace feature.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Bucket.HierarchicalNamespace}
   */
  public static final class HierarchicalNamespace extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Bucket.HierarchicalNamespace)
      HierarchicalNamespaceOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use HierarchicalNamespace.newBuilder() to construct.
    private HierarchicalNamespace(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private HierarchicalNa