/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

// Protobuf Java Version: 3.25.8
package com.google.storage.v2;

public interface BidiReadObjectSpecOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.storage.v2.BidiReadObjectSpec)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The name of the bucket containing the object to read.
   * </pre>
   *
   * <code>
   * string bucket = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bucket.
   */
  java.lang.String getBucket();

  /**
   *
   *
   * <pre>
   * Required. The name of the bucket containing the object to read.
   * </pre>
   *
   * <code>
   * string bucket = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for bucket.
   */
  com.google.protobuf.ByteString getBucketBytes();

  /**
   *
   *
   * <pre>
   * Required. The name of the object to read.
   * </pre>
   *
   * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The object.
   */
  java.lang.String getObject();

  /**
   *
   *
   * <pre>
   * Required. The name of the object to read.
   * </pre>
   *
   * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for object.
   */
  com.google.protobuf.ByteString getObjectBytes();

  /**
   *
   *
   * <pre>
   * Optional. If present, selects a specific revision of this object (as
   * opposed to the latest version, the default).
   * </pre>
   *
   * <code>int64 generation = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The generation.
   */
  long getGeneration();

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current generation
   * matches the given value. Setting to 0 makes the operation succeed only if
   * there are no live versions of the object.
   * </pre>
   *
   * <code>optional int64 if_generation_match = 4;</code>
   *
   * @return Whether the ifGenerationMatch field is set.
   */
  boolean hasIfGenerationMatch();

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current generation
   * matches the given value. Setting to 0 makes the operation succeed only if
   * there are no live versions of the object.
   * </pre>
   *
   * <code>optional int64 if_generation_match = 4;</code>
   *
   * @return The ifGenerationMatch.
   */
  long getIfGenerationMatch();

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's live generation
   * does not match the given value. If no live object exists, the precondition
   * fails. Setting to 0 makes the operation succeed only if there is a live
   * version of the object.
   * </pre>
   *
   * <code>optional int64 if_generation_not_match = 5;</code>
   *
   * @return Whether the ifGenerationNotMatch field is set.
   */
  boolean hasIfGenerationNotMatch();

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's live generation
   * does not match the given value. If no live object exists, the precondition
   * fails. Setting to 0 makes the operation succeed only if there is a live
   * version of the object.
   * </pre>
   *
   * <code>optional int64 if_generation_not_match = 5;</code>
   *
   * @return The ifGenerationNotMatch.
   */
  long getIfGenerationNotMatch();

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * metageneration matches the given value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_match = 6;</code>
   *
   * @return Whether the ifMetagenerationMatch field is set.
   */
  boolean hasIfMetagenerationMatch();

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * metageneration matches the given value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_match = 6;</code>
   *
   * @return The ifMetagenerationMatch.
   */
  long getIfMetagenerationMatch();

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * metageneration does not match the given value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_not_match = 7;</code>
   *
   * @return Whether the ifMetagenerationNotMatch field is set.
   */
  boolean hasIfMetagenerationNotMatch();

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * metageneration does not match the given value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_not_match = 7;</code>
   *
   * @return The ifMetagenerationNotMatch.
   */
  long getIfMetagenerationNotMatch();

  /**
   *
   *
   * <pre>
   * Optional. A set of parameters common to Storage API requests concerning an
   * object.
   * </pre>
   *
   * <code>
   * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the commonObjectRequestParams field is set.
   */
  boolean hasCommonObjectRequestParams();

  /**
   *
   *
   * <pre>
   * Optional. A set of parameters common to Storage API requests concerning an
   * object.
   * </pre>
   *
   * <code>
   * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The commonObjectRequestParams.
   */
  com.google.storage.v2.CommonObjectRequestParams getCommonObjectRequestParams();

  /**
   *
   *
   * <pre>
   * Optional. A set of parameters common to Storage API requests concerning an
   * object.
   * </pre>
   *
   * <code>
   * .google.storage.v2.CommonObjectRequestParams common_object_request_params = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.storage.v2.CommonObjectRequestParamsOrBuilder getCommonObjectRequestParamsOrBuilder();

  /**
   *
   *
   * <pre>
   * Mask specifying which fields to read.
   * The `checksummed_data` field and its children are always present.
   * If no mask is specified, it defaults to all fields except `metadata.
   * owner` and `metadata.acl`.
   * `*` might be used to mean "all fields".
   * As per https://google.aip.dev/161, this field is deprecated.
   * As an alternative, `grpc metadata` can be used:
   * </pre>
   *
   * <code>optional .google.protobuf.FieldMask read_mask = 12 [deprecated = true];</code>
   *
   * @deprecated google.storage.v2.BidiReadObjectSpec.read_mask is deprecated. See
   *     google/storage/v2/storage.proto;l=1187
   * @return Whether the readMask field is set.
   */
  @java.lang.Deprecated
  boolean hasReadMask();

  /**
   *
   *
   * <pre>
   * Mask specifying which fields to read.
   * The `checksummed_data` field and its children are always present.
   * If no mask is specified, it defaults to all fields except `metadata.
   * owner` and `metadata.acl`.
   * `*` might be used to mean "all fields".
   * As per https://google.aip.dev/161, this field is deprecated.
   * As an alternative, `grpc metadata` can be used:
   * </pre>
   *
   * <code>optional .google.protobuf.FieldMask read_mask = 12 [deprecated = true];</code>
   *
   * @deprecated google.storage.v2.BidiReadObjectSpec.read_mask is deprecated. See
   *     google/storage/v2/storage.proto;l=1187
   * @return The readMask.
   */
  @java.lang.Deprecated
  com.google.protobuf.FieldMask getReadMask();

  /**
   *
   *
   * <pre>
   * Mask specifying which fields to read.
   * The `checksummed_data` field and its children are always present.
   * If no mask is specified, it defaults to all fields except `metadata.
   * owner` and `metadata.acl`.
   * `*` might be used to mean "all fields".
   * As per https://google.aip.dev/161, this field is deprecated.
   * As an alternative, `grpc metadata` can be used:
   * </pre>
   *
   * <code>optional .google.protobuf.FieldMask read_mask = 12 [deprecated = true];</code>
   */
  @java.lang.Deprecated
  com.google.protobuf.FieldMaskOrBuilder getReadMaskOrBuilder();

  /**
   *
   *
   * <pre>
   * The client can optionally set this field. The read handle is an optimized
   * way of creating new streams. Read handles are generated and periodically
   * refreshed from prior reads.
   * </pre>
   *
   * <code>optional .google.storage.v2.BidiReadHandle read_handle = 13;</code>
   *
   * @return Whether the readHandle field is set.
   */
  boolean hasReadHandle();

  /**
   *
   *
   * <pre>
   * The client can optionally set this field. The read handle is an optimized
   * way of creating new streams. Read handles are generated and periodically
   * refreshed from prior reads.
   * </pre>
   *
   * <code>optional .google.storage.v2.BidiReadHandle read_handle = 13;</code>
   *
   * @return The readHandle.
   */
  com.google.storage.v2.BidiReadHandle getReadHandle();

  /**
   *
   *
   * <pre>
   * The client can optionally set this field. The read handle is an optimized
   * way of creating new streams. Read handles are generated and periodically
   * refreshed from prior reads.
   * </pre>
   *
   * <code>optional .google.storage.v2.BidiReadHandle read_handle = 13;</code>
   */
  com.google.storage.v2.BidiReadHandleOrBuilder getReadHandleOrBuilder();

  /**
   *
   *
   * <pre>
   * The routing token that influences request routing for the stream. Must be
   * provided if a BidiReadObjectRedirectedError is returned.
   * </pre>
   *
   * <code>optional string routing_token = 14;</code>
   *
   * @return Whether the routingToken field is set.
   */
  boolean hasRoutingToken();

  /**
   *
   *
   * <pre>
   * The routing token that influences request routing for the stream. Must be
   * provided if a BidiReadObjectRedirectedError is returned.
   * </pre>
   *
   * <code>optional string routing_token = 14;</code>
   *
   * @return The routingToken.
   */
  java.lang.String getRoutingToken();

  /**
   *
   *
   * <pre>
   * The routing token that influences request routing for the stream. Must be
   * provided if a BidiReadObjectRedirectedError is returned.
   * </pre>
   *
   * <code>optional string routing_token = 14;</code>
   *
   * @return The bytes for routingToken.
   */
  com.google.protobuf.ByteString getRoutingTokenBytes();
}
