/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

// Protobuf Java Version: 3.25.8
package com.google.storage.v2;

/**
 *
 *
 * <pre>
 * Request message for [CreateBucket][google.storage.v2.Storage.CreateBucket].
 * </pre>
 *
 * Protobuf type {@code google.storage.v2.CreateBucketRequest}
 */
public final class CreateBucketRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.v2.CreateBucketRequest)
    CreateBucketRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use CreateBucketRequest.newBuilder() to construct.
  private CreateBucketRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateBucketRequest() {
    parent_ = "";
    bucketId_ = "";
    predefinedAcl_ = "";
    predefinedDefaultObjectAcl_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateBucketRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_CreateBucketRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_CreateBucketRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.v2.CreateBucketRequest.class,
            com.google.storage.v2.CreateBucketRequest.Builder.class);
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";

  /**
   *
   *
   * <pre>
   * Required. The project to which this bucket belongs. This field must either
   * be empty or `projects/_`. The project ID that owns this bucket should be
   * specified in the `bucket.project` field.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The project to which this bucket belongs. This field must either
   * be empty or `projects/_`. The project ID that owns this bucket should be
   * specified in the `bucket.project` field.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BUCKET_FIELD_NUMBER = 2;
  private com.google.storage.v2.Bucket bucket_;

  /**
   *
   *
   * <pre>
   * Optional. Properties of the new bucket being inserted.
   * The name of the bucket is specified in the `bucket_id` field. Populating
   * `bucket.name` field results in an error.
   * The project of the bucket must be specified in the `bucket.project` field.
   * This field must be in `projects/{projectIdentifier}` format,
   * {projectIdentifier} can be the project ID or project number. The `parent`
   * field must be either empty or `projects/_`.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the bucket field is set.
   */
  @java.lang.Override
  public boolean hasBucket() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Properties of the new bucket being inserted.
   * The name of the bucket is specified in the `bucket_id` field. Populating
   * `bucket.name` field results in an error.
   * The project of the bucket must be specified in the `bucket.project` field.
   * This field must be in `projects/{projectIdentifier}` format,
   * {projectIdentifier} can be the project ID or project number. The `parent`
   * field must be either empty or `projects/_`.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bucket.
   */
  @java.lang.Override
  public com.google.storage.v2.Bucket getBucket() {
    return bucket_ == null ? com.google.storage.v2.Bucket.getDefaultInstance() : bucket_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Properties of the new bucket being inserted.
   * The name of the bucket is specified in the `bucket_id` field. Populating
   * `bucket.name` field results in an error.
   * The project of the bucket must be specified in the `bucket.project` field.
   * This field must be in `projects/{projectIdentifier}` format,
   * {projectIdentifier} can be the project ID or project number. The `parent`
   * field must be either empty or `projects/_`.
   * </pre>
   *
   * <code>.google.storage.v2.Bucket bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public com.google.storage.v2.BucketOrBuilder getBucketOrBuilder() {
    return bucket_ == null ? com.google.storage.v2.Bucket.getDefaultInstance() : bucket_;
  }

  public static final int BUCKET_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object bucketId_ = "";

  /**
   *
   *
   * <pre>
   * Required. The ID to use for this bucket, which becomes the final component
   * of the bucket's resource name. For example, the value `foo` might result in
   * a bucket with the name `projects/123456/buckets/foo`.
   * </pre>
   *
   * <code>string bucket_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bucketId.
   */
  @java.lang.Override
  public java.lang.String getBucketId() {
    java.lang.Object ref = bucketId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      bucketId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The ID to use for this bucket, which becomes the final component
   * of the bucket's resource name. For example, the value `foo` might result in
   * a bucket with the name `projects/123456/buckets/foo`.
   * </pre>
   *
   * <code>string bucket_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for bucketId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBucketIdBytes() {
    java.lang.Object ref = bucketId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      bucketId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PREDEFINED_ACL_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object predefinedAcl_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Apply a predefined set of access controls to this bucket.
   * Valid values are `authenticatedRead`, `private`, `projectPrivate`,
   * `publicRead`, or `publicReadWrite`.
   * </pre>
   *
   * <code>string predefined_acl = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The predefinedAcl.
   */
  @java.lang.Override
  public java.lang.String getPredefinedAcl() {
    java.lang.Object ref = predefinedAcl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      predefinedAcl_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Apply a predefined set of access controls to this bucket.
   * Valid values are `authenticatedRead`, `private`, `projectPrivate`,
   * `publicRead`, or `publicReadWrite`.
   * </pre>
   *
   * <code>string predefined_acl = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for predefinedAcl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPredefinedAclBytes() {
    java.lang.Object ref = predefinedAcl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      predefinedAcl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PREDEFINED_DEFAULT_OBJECT_ACL_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object predefinedDefaultObjectAcl_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Apply a predefined set of default object access controls to this
   * bucket. Valid values are `authenticatedRead`, `bucketOwnerFullControl`,
   * `bucketOwnerRead`, `private`, `projectPrivate`, or `publicRead`.
   * </pre>
   *
   * <code>string predefined_default_object_acl = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The predefinedDefaultObjectAcl.
   */
  @java.lang.Override
  public java.lang.String getPredefinedDefaultObjectAcl() {
    java.lang.Object ref = predefinedDefaultObjectAcl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      predefinedDefaultObjectAcl_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Apply a predefined set of default object access controls to this
   * bucket. Valid values are `authenticatedRead`, `bucketOwnerFullControl`,
   * `bucketOwnerRead`, `private`, `projectPrivate`, or `publicRead`.
   * </pre>
   *
   * <code>string predefined_default_object_acl = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The bytes for predefinedDefaultObjectAcl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPredefinedDefaultObjectAclBytes() {
    java.lang.Object ref = predefinedDefaultObjectAcl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      predefinedDefaultObjectAcl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLE_OBJECT_RETENTION_FIELD_NUMBER = 9;
  private boolean enableObjectRetention_ = false;

  /**
   *
   *
   * <pre>
   * Optional. If true, enable object retention on the bucket.
   * </pre>
   *
   * <code>bool enable_object_retention = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enableObjectRetention.
   */
  @java.lang.Override
  public boolean getEnableObjectRetention() {
    return enableObjectRetention_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getBucket());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucketId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, bucketId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(predefinedAcl_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, predefinedAcl_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(predefinedDefaultObjectAcl_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, predefinedDefaultObjectAcl_);
    }
    if (enableObjectRetention_ != false) {
      output.writeBool(9, enableObjectRetention_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getBucket());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucketId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, bucketId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(predefinedAcl_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, predefinedAcl_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(predefinedDefaultObjectAcl_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(7, predefinedDefaultObjectAcl_);
    }
    if (enableObjectRetention_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(9, enableObjectRetention_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.storage.v2.CreateBucketRequest)) {
      return super.equals(obj);
    }
    com.google.storage.v2.CreateBucketRequest other =
        (com.google.storage.v2.CreateBucketRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (hasBucket() != other.hasBucket()) return false;
    if (hasBucket()) {
      if (!getBucket().equals(other.getBucket())) return false;
    }
    if (!getBucketId().equals(other.getBucketId())) return false;
    if (!getPredefinedAcl().equals(other.getPredefinedAcl())) return false;
    if (!getPredefinedDefaultObjectAcl().equals(other.getPredefinedDefaultObjectAcl()))
      return false;
    if (getEnableObjectRetention() != other.getEnableObjectRetention()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasBucket()) {
      hash = (37 * hash) + BUCKET_FIELD_NUMBER;
      hash = (53 * hash) + getBucket().hashCode();
    }
    hash = (37 * hash) + BUCKET_ID_FIELD_NUMBER;
    hash = (53 * hash) + getBucketId().hashCode();
    hash = (37 * hash) + PREDEFINED_ACL_FIELD_NUMBER;
    hash = (53 * hash) + getPredefinedAcl().hashCode();
    hash = (37 * hash) + PREDEFINED_DEFAULT_OBJECT_ACL_FIELD_NUMBER;
    hash = (53 * hash) + getPredefinedDefaultObjectAcl().hashCode();
    hash = (37 * hash) + ENABLE_OBJECT_RETENTION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableObjectRetention());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.v2.CreateBucketRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.CreateBucketRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.CreateBucketRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.CreateBucketRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.CreateBucketRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.CreateBucketRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.CreateBucketRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.CreateBucketRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.CreateBucketRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.CreateBucketRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.CreateBucketRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.CreateBucketRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.storage.v2.CreateBucketRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for [CreateBucket][google.storage.v2.Storage.CreateBucket].
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.CreateBucketRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.v2.CreateBucketRequest)
      com.google.storage.v2.CreateBucketRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_CreateBucketRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_CreateBucketRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.CreateBucketRequest.class,
              com.google.storage.v2.CreateBucketRequest.Builder.class);
    }

    // Construct using com.google.storage.v2.CreateBucketRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getBucketFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      bucket_ = null;
      if (bucketBuilder_ != null) {
        bucketBuilder_.dispose();
        bucketBuilder_ = null;
      }
      bucketId_ = "";
      predefinedAcl_ = "";
      predefinedDefaultObjectAcl_ = "";
      enableObjectRetention_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_CreateBucketRequest_descriptor;
    }

    @java.lang.Override
    public com.google.storage.v2.CreateBucketRequest getDefaultInstanceForType() {
      return com.google.storage.v2.CreateBucketRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.v2.CreateBucketRequest build() {
      com.google.storage.v2.CreateBucketRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.v2.CreateBucketRequest buildPartial() {
      com.google.storage.v2.CreateBucketRequest result =
          new com.google.storage.v2.CreateBucketRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.storage.v2.CreateBucketRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.bucket_ = bucketBuilder_ == null ? bucket_ : bucketBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.bucketId_ = bucketId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.predefinedAcl_ = predefinedAcl_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.predefinedDefaultObjectAcl_ = predefinedDefaultObjectAcl_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.enableObjectRetention_ = enableObjectRetention_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.storage.v2.CreateBucketRequest) {
        return mergeFrom((com.google.storage.v2.CreateBucketRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.storage.v2.CreateBucketRequest other) {
      if (other == com.google.storage.v2.CreateBucketRequest.getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasBucket()) {
        mergeBucket(other.getBucket());
      }
      if (!other.getBucketId().isEmpty()) {
        bucketId_ = other.bucketId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getPredefinedAcl().isEmpty()) {
        predefinedAcl_ = other.predefinedAcl_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getPredefinedDefaultObjectAcl().isEmpty()) {
        predefinedDefaultObjectAcl_ = other.predefinedDefaultObjectAcl_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.getEnableObjectRetention() != false) {
        setEnableObjectRetention(other.getEnableObjectRetention());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getBucketFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                bucketId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 50:
              {
                predefinedAcl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 50
            case 58:
              {
                predefinedDefaultObjectAcl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 58
            case 72:
              {
                enableObjectRetention_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 72
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";

    /**
     *
     *
     * <pre>
     * Required. The project to which this bucket belongs. This field must either
     * be empty or `projects/_`. The project ID that owns this bucket should be
     * specified in the `bucket.project` field.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The project to which this bucket belongs. This field must either
     * be empty or `projects/_`. The project ID that owns this bucket should be
     * specified in the `bucket.project` field.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The project to which this bucket belongs. This field must either
     * be empty or `projects/_`. The project ID that owns this bucket should be
     * specified in the `bucket.project` field.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The project to which this bucket belongs. This field must either
     * be empty or `projects/_`. The project ID that owns this bucket should be
     * specified in the `bucket.project` field.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The project to which this bucket belongs. This field must either
     * be empty or `projects/_`. The project ID that owns this bucket should be
     * specified in the `bucket.project` field.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.storage.v2.Bucket bucket_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket,
            com.google.storage.v2.Bucket.Builder,
            com.google.storage.v2.BucketOrBuilder>
        bucketBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Properties of the new bucket being inserted.
     * The name of the bucket is specified in the `bucket_id` field. Populating
     * `bucket.name` field results in an error.
     * The project of the bucket must be specified in the `bucket.project` field.
     * This field must be in `projects/{projectIdentifier}` format,
     * {projectIdentifier} can be the project ID or project number. The `parent`
     * field must be either empty or `projects/_`.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the bucket field is set.
     */
    public boolean hasBucket() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Properties of the new bucket being inserted.
     * The name of the bucket is specified in the `bucket_id` field. Populating
     * `bucket.name` field results in an error.
     * The project of the bucket must be specified in the `bucket.project` field.
     * This field must be in `projects/{projectIdentifier}` format,
     * {projectIdentifier} can be the project ID or project number. The `parent`
     * field must be either empty or `projects/_`.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bucket.
     */
    public com.google.storage.v2.Bucket getBucket() {
      if (bucketBuilder_ == null) {
        return bucket_ == null ? com.google.storage.v2.Bucket.getDefaultInstance() : bucket_;
      } else {
        return bucketBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Properties of the new bucket being inserted.
     * The name of the bucket is specified in the `bucket_id` field. Populating
     * `bucket.name` field results in an error.
     * The project of the bucket must be specified in the `bucket.project` field.
     * This field must be in `projects/{projectIdentifier}` format,
     * {projectIdentifier} can be the project ID or project number. The `parent`
     * field must be either empty or `projects/_`.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder setBucket(com.google.storage.v2.Bucket value) {
      if (bucketBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        bucket_ = value;
      } else {
        bucketBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Properties of the new bucket being inserted.
     * The name of the bucket is specified in the `bucket_id` field. Populating
     * `bucket.name` field results in an error.
     * The project of the bucket must be specified in the `bucket.project` field.
     * This field must be in `projects/{projectIdentifier}` format,
     * {projectIdentifier} can be the project ID or project number. The `parent`
     * field must be either empty or `projects/_`.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder setBucket(com.google.storage.v2.Bucket.Builder builderForValue) {
      if (bucketBuilder_ == null) {
        bucket_ = builderForValue.build();
      } else {
        bucketBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Properties of the new bucket being inserted.
     * The name of the bucket is specified in the `bucket_id` field. Populating
     * `bucket.name` field results in an error.
     * The project of the bucket must be specified in the `bucket.project` field.
     * This field must be in `projects/{projectIdentifier}` format,
     * {projectIdentifier} can be the project ID or project number. The `parent`
     * field must be either empty or `projects/_`.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder mergeBucket(com.google.storage.v2.Bucket value) {
      if (bucketBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && bucket_ != null
            && bucket_ != com.google.storage.v2.Bucket.getDefaultInstance()) {
          getBucketBuilder().mergeFrom(value);
        } else {
          bucket_ = value;
        }
      } else {
        bucketBuilder_.mergeFrom(value);
      }
      if (bucket_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Properties of the new bucket being inserted.
     * The name of the bucket is specified in the `bucket_id` field. Populating
     * `bucket.name` field results in an error.
     * The project of the bucket must be specified in the `bucket.project` field.
     * This field must be in `projects/{projectIdentifier}` format,
     * {projectIdentifier} can be the project ID or project number. The `parent`
     * field must be either empty or `projects/_`.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder clearBucket() {
      bitField0_ = (bitField0_ & ~0x00000002);
      bucket_ = null;
      if (bucketBuilder_ != null) {
        bucketBuilder_.dispose();
        bucketBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Properties of the new bucket being inserted.
     * The name of the bucket is specified in the `bucket_id` field. Populating
     * `bucket.name` field results in an error.
     * The project of the bucket must be specified in the `bucket.project` field.
     * This field must be in `projects/{projectIdentifier}` format,
     * {projectIdentifier} can be the project ID or project number. The `parent`
     * field must be either empty or `projects/_`.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public com.google.storage.v2.Bucket.Builder getBucketBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getBucketFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Properties of the new bucket being inserted.
     * The name of the bucket is specified in the `bucket_id` field. Populating
     * `bucket.name` field results in an error.
     * The project of the bucket must be specified in the `bucket.project` field.
     * This field must be in `projects/{projectIdentifier}` format,
     * {projectIdentifier} can be the project ID or project number. The `parent`
     * field must be either empty or `projects/_`.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public com.google.storage.v2.BucketOrBuilder getBucketOrBuilder() {
      if (bucketBuilder_ != null) {
        return bucketBuilder_.getMessageOrBuilder();
      } else {
        return bucket_ == null ? com.google.storage.v2.Bucket.getDefaultInstance() : bucket_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Properties of the new bucket being inserted.
     * The name of the bucket is specified in the `bucket_id` field. Populating
     * `bucket.name` field results in an error.
     * The project of the bucket must be specified in the `bucket.project` field.
     * This field must be in `projects/{projectIdentifier}` format,
     * {projectIdentifier} can be the project ID or project number. The `parent`
     * field must be either empty or `projects/_`.
     * </pre>
     *
     * <code>.google.storage.v2.Bucket bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Bucket,
            com.google.storage.v2.Bucket.Builder,
            com.google.storage.v2.BucketOrBuilder>
        getBucketFieldBuilder() {
      if (bucketBuilder_ == null) {
        bucketBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Bucket,
                com.google.storage.v2.Bucket.Builder,
                com.google.storage.v2.BucketOrBuilder>(
                getBucket(), getParentForChildren(), isClean());
        bucket_ = null;
      }
      return bucketBuilder_;
    }

    private java.lang.Object bucketId_ = "";

    /**
     *
     *
     * <pre>
     * Required. The ID to use for this bucket, which becomes the final component
     * of the bucket's resource name. For example, the value `foo` might result in
     * a bucket with the name `projects/123456/buckets/foo`.
     * </pre>
     *
     * <code>string bucket_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bucketId.
     */
    public java.lang.String getBucketId() {
      java.lang.Object ref = bucketId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bucketId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The ID to use for this bucket, which becomes the final component
     * of the bucket's resource name. For example, the value `foo` might result in
     * a bucket with the name `projects/123456/buckets/foo`.
     * </pre>
     *
     * <code>string bucket_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for bucketId.
     */
    public com.google.protobuf.ByteString getBucketIdBytes() {
      java.lang.Object ref = bucketId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bucketId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The ID to use for this bucket, which becomes the final component
     * of the bucket's resource name. For example, the value `foo` might result in
     * a bucket with the name `projects/123456/buckets/foo`.
     * </pre>
     *
     * <code>string bucket_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bucketId to set.
     * @return This builder for chaining.
     */
    public Builder setBucketId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bucketId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The ID to use for this bucket, which becomes the final component
     * of the bucket's resource name. For example, the value `foo` might result in
     * a bucket with the name `projects/123456/buckets/foo`.
     * </pre>
     *
     * <code>string bucket_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBucketId() {
      bucketId_ = getDefaultInstance().getBucketId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The ID to use for this bucket, which becomes the final component
     * of the bucket's resource name. For example, the value `foo` might result in
     * a bucket with the name `projects/123456/buckets/foo`.
     * </pre>
     *
     * <code>string bucket_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for bucketId to set.
     * @return This builder for chaining.
     */
    public Builder setBucketIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      bucketId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object predefinedAcl_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Apply a predefined set of access controls to this bucket.
     * Valid values are `authenticatedRead`, `private`, `projectPrivate`,
     * `publicRead`, or `publicReadWrite`.
     * </pre>
     *
     * <code>string predefined_acl = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The predefinedAcl.
     */
    public java.lang.String getPredefinedAcl() {
      java.lang.Object ref = predefinedAcl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        predefinedAcl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Apply a predefined set of access controls to this bucket.
     * Valid values are `authenticatedRead`, `private`, `projectPrivate`,
     * `publicRead`, or `publicReadWrite`.
     * </pre>
     *
     * <code>string predefined_acl = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for predefinedAcl.
     */
    public com.google.protobuf.ByteString getPredefinedAclBytes() {
      java.lang.Object ref = predefinedAcl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        predefinedAcl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Apply a predefined set of access controls to this bucket.
     * Valid values are `authenticatedRead`, `private`, `projectPrivate`,
     * `publicRead`, or `publicReadWrite`.
     * </pre>
     *
     * <code>string predefined_acl = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The predefinedAcl to set.
     * @return This builder for chaining.
     */
    public Builder setPredefinedAcl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      predefinedAcl_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Apply a predefined set of access controls to this bucket.
     * Valid values are `authenticatedRead`, `private`, `projectPrivate`,
     * `publicRead`, or `publicReadWrite`.
     * </pre>
     *
     * <code>string predefined_acl = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPredefinedAcl() {
      predefinedAcl_ = getDefaultInstance().getPredefinedAcl();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Apply a predefined set of access controls to this bucket.
     * Valid values are `authenticatedRead`, `private`, `projectPrivate`,
     * `publicRead`, or `publicReadWrite`.
     * </pre>
     *
     * <code>string predefined_acl = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for predefinedAcl to set.
     * @return This builder for chaining.
     */
    public Builder setPredefinedAclBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      predefinedAcl_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object predefinedDefaultObjectAcl_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Apply a predefined set of default object access controls to this
     * bucket. Valid values are `authenticatedRead`, `bucketOwnerFullControl`,
     * `bucketOwnerRead`, `private`, `projectPrivate`, or `publicRead`.
     * </pre>
     *
     * <code>string predefined_default_object_acl = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The predefinedDefaultObjectAcl.
     */
    public java.lang.String getPredefinedDefaultObjectAcl() {
      java.lang.Object ref = predefinedDefaultObjectAcl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        predefinedDefaultObjectAcl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Apply a predefined set of default object access controls to this
     * bucket. Valid values are `authenticatedRead`, `bucketOwnerFullControl`,
     * `bucketOwnerRead`, `private`, `projectPrivate`, or `publicRead`.
     * </pre>
     *
     * <code>string predefined_default_object_acl = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The bytes for predefinedDefaultObjectAcl.
     */
    public com.google.protobuf.ByteString getPredefinedDefaultObjectAclBytes() {
      java.lang.Object ref = predefinedDefaultObjectAcl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        predefinedDefaultObjectAcl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Apply a predefined set of default object access controls to this
     * bucket. Valid values are `authenticatedRead`, `bucketOwnerFullControl`,
     * `bucketOwnerRead`, `private`, `projectPrivate`, or `publicRead`.
     * </pre>
     *
     * <code>string predefined_default_object_acl = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The predefinedDefaultObjectAcl to set.
     * @return This builder for chaining.
     */
    public Builder setPredefinedDefaultObjectAcl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      predefinedDefaultObjectAcl_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Apply a predefined set of default object access controls to this
     * bucket. Valid values are `authenticatedRead`, `bucketOwnerFullControl`,
     * `bucketOwnerRead`, `private`, `projectPrivate`, or `publicRead`.
     * </pre>
     *
     * <code>string predefined_default_object_acl = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPredefinedDefaultObjectAcl() {
      predefinedDefaultObjectAcl_ = getDefaultInstance().getPredefinedDefaultObjectAcl();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Apply a predefined set of default object access controls to this
     * bucket. Valid values are `authenticatedRead`, `bucketOwnerFullControl`,
     * `bucketOwnerRead`, `private`, `projectPrivate`, or `publicRead`.
     * </pre>
     *
     * <code>string predefined_default_object_acl = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes for predefinedDefaultObjectAcl to set.
     * @return This builder for chaining.
     */
    public Builder setPredefinedDefaultObjectAclBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      predefinedDefaultObjectAcl_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private boolean enableObjectRetention_;

    /**
     *
     *
     * <pre>
     * Optional. If true, enable object retention on the bucket.
     * </pre>
     *
     * <code>bool enable_object_retention = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enableObjectRetention.
     */
    @java.lang.Override
    public boolean getEnableObjectRetention() {
      return enableObjectRetention_;
    }

    /**
     *
     *
     * <pre>
     * Optional. If true, enable object retention on the bucket.
     * </pre>
     *
     * <code>bool enable_object_retention = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The enableObjectRetention to set.
     * @return This builder for chaining.
     */
    public Builder setEnableObjectRetention(boolean value) {

      enableObjectRetention_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If true, enable object retention on the bucket.
     * </pre>
     *
     * <code>bool enable_object_retention = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableObjectRetention() {
      bitField0_ = (bitField0_ & ~0x00000020);
      enableObjectRetention_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.v2.CreateBucketRequest)
  }

  // @@protoc_insertion_point(class_scope:google.storage.v2.CreateBucketRequest)
  private static final com.google.storage.v2.CreateBucketRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.storage.v2.CreateBucketRequest();
  }

  public static com.google.storage.v2.CreateBucketRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateBucketRequest> PARSER =
      new com.google.protobuf.AbstractParser<CreateBucketRequest>() {
        @java.lang.Override
        public CreateBucketRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CreateBucketRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateBucketRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.v2.CreateBucketRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
