/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.telcoautomation.v1alpha1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EdgeSlmName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_EDGE_SLM = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/edgeSlms/{edge_slm}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String edgeSlm;

    @Deprecated
    protected EdgeSlmName() {
        this.project = null;
        this.location = null;
        this.edgeSlm = null;
    }

    private EdgeSlmName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.edgeSlm = (String)Preconditions.checkNotNull((Object)builder.getEdgeSlm());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getEdgeSlm() {
        return this.edgeSlm;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EdgeSlmName of(String project, String location, String edgeSlm) {
        return EdgeSlmName.newBuilder().setProject(project).setLocation(location).setEdgeSlm(edgeSlm).build();
    }

    public static String format(String project, String location, String edgeSlm) {
        return EdgeSlmName.newBuilder().setProject(project).setLocation(location).setEdgeSlm(edgeSlm).build().toString();
    }

    public static EdgeSlmName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_EDGE_SLM.validatedMatch(formattedString, "EdgeSlmName.parse: formattedString not in valid format");
        return EdgeSlmName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("edge_slm"));
    }

    public static List<EdgeSlmName> parseList(List<String> formattedStrings) {
        ArrayList<EdgeSlmName> list = new ArrayList<EdgeSlmName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EdgeSlmName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EdgeSlmName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EdgeSlmName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_EDGE_SLM.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EdgeSlmName edgeSlmName = this;
            synchronized (edgeSlmName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.edgeSlm != null) {
                        fieldMapBuilder.put((Object)"edge_slm", (Object)this.edgeSlm);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_EDGE_SLM.instantiate(new String[]{"project", this.project, "location", this.location, "edge_slm", this.edgeSlm});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            EdgeSlmName that = (EdgeSlmName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.edgeSlm, that.edgeSlm);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.edgeSlm);
    }

    public static class Builder {
        private String project;
        private String location;
        private String edgeSlm;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEdgeSlm() {
            return this.edgeSlm;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setEdgeSlm(String edgeSlm) {
            this.edgeSlm = edgeSlm;
            return this;
        }

        private Builder(EdgeSlmName edgeSlmName) {
            this.project = edgeSlmName.project;
            this.location = edgeSlmName.location;
            this.edgeSlm = edgeSlmName.edgeSlm;
        }

        public EdgeSlmName build() {
            return new EdgeSlmName(this);
        }
    }
}

