/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vertexai/v1/prediction_service.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.vertexai.api;

/**
 *
 *
 * <pre>
 * Request message for
 * [PredictionService.StreamDirectPredict][google.cloud.aiplatform.v1.PredictionService.StreamDirectPredict].
 *
 * The first message must contain
 * [endpoint][google.cloud.aiplatform.v1.StreamDirectPredictRequest.endpoint]
 * field and optionally [input][]. The subsequent messages must contain
 * [input][].
 * </pre>
 *
 * Protobuf type {@code google.cloud.vertexai.v1.StreamDirectPredictRequest}
 */
public final class StreamDirectPredictRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vertexai.v1.StreamDirectPredictRequest)
    StreamDirectPredictRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StreamDirectPredictRequest.newBuilder() to construct.
  private StreamDirectPredictRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StreamDirectPredictRequest() {
    endpoint_ = "";
    inputs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StreamDirectPredictRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vertexai.api.PredictionServiceProto
        .internal_static_google_cloud_vertexai_v1_StreamDirectPredictRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vertexai.api.PredictionServiceProto
        .internal_static_google_cloud_vertexai_v1_StreamDirectPredictRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vertexai.api.StreamDirectPredictRequest.class,
            com.google.cloud.vertexai.api.StreamDirectPredictRequest.Builder.class);
  }

  private int bitField0_;
  public static final int ENDPOINT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object endpoint_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the Endpoint requested to serve the prediction.
   * Format:
   * `projects/{project}/locations/{location}/endpoints/{endpoint}`
   * </pre>
   *
   * <code>
   * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The endpoint.
   */
  @java.lang.Override
  public java.lang.String getEndpoint() {
    java.lang.Object ref = endpoint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      endpoint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the Endpoint requested to serve the prediction.
   * Format:
   * `projects/{project}/locations/{location}/endpoints/{endpoint}`
   * </pre>
   *
   * <code>
   * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for endpoint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEndpointBytes() {
    java.lang.Object ref = endpoint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      endpoint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INPUTS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.vertexai.api.Tensor> inputs_;
  /**
   *
   *
   * <pre>
   * Optional. The prediction input.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Tensor inputs = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.vertexai.api.Tensor> getInputsList() {
    return inputs_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The prediction input.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Tensor inputs = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.vertexai.api.TensorOrBuilder>
      getInputsOrBuilderList() {
    return inputs_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The prediction input.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Tensor inputs = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getInputsCount() {
    return inputs_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The prediction input.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Tensor inputs = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.Tensor getInputs(int index) {
    return inputs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The prediction input.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Tensor inputs = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.TensorOrBuilder getInputsOrBuilder(int index) {
    return inputs_.get(index);
  }

  public static final int PARAMETERS_FIELD_NUMBER = 3;
  private com.google.cloud.vertexai.api.Tensor parameters_;
  /**
   *
   *
   * <pre>
   * Optional. The parameters that govern the prediction.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.Tensor parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the parameters field is set.
   */
  @java.lang.Override
  public boolean hasParameters() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The parameters that govern the prediction.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.Tensor parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The parameters.
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.Tensor getParameters() {
    return parameters_ == null
        ? com.google.cloud.vertexai.api.Tensor.getDefaultInstance()
        : parameters_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The parameters that govern the prediction.
   * </pre>
   *
   * <code>
   * .google.cloud.vertexai.v1.Tensor parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.TensorOrBuilder getParametersOrBuilder() {
    return parameters_ == null
        ? com.google.cloud.vertexai.api.Tensor.getDefaultInstance()
        : parameters_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpoint_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, endpoint_);
    }
    for (int i = 0; i < inputs_.size(); i++) {
      output.writeMessage(2, inputs_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getParameters());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpoint_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, endpoint_);
    }
    for (int i = 0; i < inputs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, inputs_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getParameters());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vertexai.api.StreamDirectPredictRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.vertexai.api.StreamDirectPredictRequest other =
        (com.google.cloud.vertexai.api.StreamDirectPredictRequest) obj;

    if (!getEndpoint().equals(other.getEndpoint())) return false;
    if (!getInputsList().equals(other.getInputsList())) return false;
    if (hasParameters() != other.hasParameters()) return false;
    if (hasParameters()) {
      if (!getParameters().equals(other.getParameters())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ENDPOINT_FIELD_NUMBER;
    hash = (53 * hash) + getEndpoint().hashCode();
    if (getInputsCount() > 0) {
      hash = (37 * hash) + INPUTS_FIELD_NUMBER;
      hash = (53 * hash) + getInputsList().hashCode();
    }
    if (hasParameters()) {
      hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getParameters().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vertexai.api.StreamDirectPredictRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.StreamDirectPredictRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.StreamDirectPredictRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.StreamDirectPredictRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.StreamDirectPredictRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.StreamDirectPredictRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.StreamDirectPredictRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.StreamDirectPredictRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.StreamDirectPredictRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.StreamDirectPredictRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.StreamDirectPredictRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.StreamDirectPredictRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.vertexai.api.StreamDirectPredictRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [PredictionService.StreamDirectPredict][google.cloud.aiplatform.v1.PredictionService.StreamDirectPredict].
   *
   * The first message must contain
   * [endpoint][google.cloud.aiplatform.v1.StreamDirectPredictRequest.endpoint]
   * field and optionally [input][]. The subsequent messages must contain
   * [input][].
   * </pre>
   *
   * Protobuf type {@code google.cloud.vertexai.v1.StreamDirectPredictRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vertexai.v1.StreamDirectPredictRequest)
      com.google.cloud.vertexai.api.StreamDirectPredictRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vertexai.api.PredictionServiceProto
          .internal_static_google_cloud_vertexai_v1_StreamDirectPredictRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vertexai.api.PredictionServiceProto
          .internal_static_google_cloud_vertexai_v1_StreamDirectPredictRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vertexai.api.StreamDirectPredictRequest.class,
              com.google.cloud.vertexai.api.StreamDirectPredictRequest.Builder.class);
    }

    // Construct using com.google.cloud.vertexai.api.StreamDirectPredictRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getInputsFieldBuilder();
        getParametersFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      endpoint_ = "";
      if (inputsBuilder_ == null) {
        inputs_ = java.util.Collections.emptyList();
      } else {
        inputs_ = null;
        inputsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      parameters_ = null;
      if (parametersBuilder_ != null) {
        parametersBuilder_.dispose();
        parametersBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vertexai.api.PredictionServiceProto
          .internal_static_google_cloud_vertexai_v1_StreamDirectPredictRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.StreamDirectPredictRequest getDefaultInstanceForType() {
      return com.google.cloud.vertexai.api.StreamDirectPredictRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.StreamDirectPredictRequest build() {
      com.google.cloud.vertexai.api.StreamDirectPredictRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.StreamDirectPredictRequest buildPartial() {
      com.google.cloud.vertexai.api.StreamDirectPredictRequest result =
          new com.google.cloud.vertexai.api.StreamDirectPredictRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.vertexai.api.StreamDirectPredictRequest result) {
      if (inputsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          inputs_ = java.util.Collections.unmodifiableList(inputs_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.inputs_ = inputs_;
      } else {
        result.inputs_ = inputsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.vertexai.api.StreamDirectPredictRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.endpoint_ = endpoint_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.parameters_ = parametersBuilder_ == null ? parameters_ : parametersBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vertexai.api.StreamDirectPredictRequest) {
        return mergeFrom((com.google.cloud.vertexai.api.StreamDirectPredictRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vertexai.api.StreamDirectPredictRequest other) {
      if (other == com.google.cloud.vertexai.api.StreamDirectPredictRequest.getDefaultInstance())
        return this;
      if (!other.getEndpoint().isEmpty()) {
        endpoint_ = other.endpoint_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (inputsBuilder_ == null) {
        if (!other.inputs_.isEmpty()) {
          if (inputs_.isEmpty()) {
            inputs_ = other.inputs_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureInputsIsMutable();
            inputs_.addAll(other.inputs_);
          }
          onChanged();
        }
      } else {
        if (!other.inputs_.isEmpty()) {
          if (inputsBuilder_.isEmpty()) {
            inputsBuilder_.dispose();
            inputsBuilder_ = null;
            inputs_ = other.inputs_;
            bitField0_ = (bitField0_ & ~0x00000002);
            inputsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getInputsFieldBuilder()
                    : null;
          } else {
            inputsBuilder_.addAllMessages(other.inputs_);
          }
        }
      }
      if (other.hasParameters()) {
        mergeParameters(other.getParameters());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                endpoint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.vertexai.api.Tensor m =
                    input.readMessage(
                        com.google.cloud.vertexai.api.Tensor.parser(), extensionRegistry);
                if (inputsBuilder_ == null) {
                  ensureInputsIsMutable();
                  inputs_.add(m);
                } else {
                  inputsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getParametersFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object endpoint_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the Endpoint requested to serve the prediction.
     * Format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The endpoint.
     */
    public java.lang.String getEndpoint() {
      java.lang.Object ref = endpoint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endpoint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Endpoint requested to serve the prediction.
     * Format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for endpoint.
     */
    public com.google.protobuf.ByteString getEndpointBytes() {
      java.lang.Object ref = endpoint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        endpoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Endpoint requested to serve the prediction.
     * Format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The endpoint to set.
     * @return This builder for chaining.
     */
    public Builder setEndpoint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      endpoint_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Endpoint requested to serve the prediction.
     * Format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEndpoint() {
      endpoint_ = getDefaultInstance().getEndpoint();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Endpoint requested to serve the prediction.
     * Format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for endpoint to set.
     * @return This builder for chaining.
     */
    public Builder setEndpointBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      endpoint_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.vertexai.api.Tensor> inputs_ =
        java.util.Collections.emptyList();

    private void ensureInputsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        inputs_ = new java.util.ArrayList<com.google.cloud.vertexai.api.Tensor>(inputs_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vertexai.api.Tensor,
            com.google.cloud.vertexai.api.Tensor.Builder,
            com.google.cloud.vertexai.api.TensorOrBuilder>
        inputsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The prediction input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tensor inputs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.vertexai.api.Tensor> getInputsList() {
      if (inputsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(inputs_);
      } else {
        return inputsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The prediction input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tensor inputs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getInputsCount() {
      if (inputsBuilder_ == null) {
        return inputs_.size();
      } else {
        return inputsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The prediction input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tensor inputs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.Tensor getInputs(int index) {
      if (inputsBuilder_ == null) {
        return inputs_.get(index);
      } else {
        return inputsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The prediction input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tensor inputs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setInputs(int index, com.google.cloud.vertexai.api.Tensor value) {
      if (inputsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInputsIsMutable();
        inputs_.set(index, value);
        onChanged();
      } else {
        inputsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The prediction input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tensor inputs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setInputs(
        int index, com.google.cloud.vertexai.api.Tensor.Builder builderForValue) {
      if (inputsBuilder_ == null) {
        ensureInputsIsMutable();
        inputs_.set(index, builderForValue.build());
        onChanged();
      } else {
        inputsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The prediction input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tensor inputs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addInputs(com.google.cloud.vertexai.api.Tensor value) {
      if (inputsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInputsIsMutable();
        inputs_.add(value);
        onChanged();
      } else {
        inputsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The prediction input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tensor inputs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addInputs(int index, com.google.cloud.vertexai.api.Tensor value) {
      if (inputsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInputsIsMutable();
        inputs_.add(index, value);
        onChanged();
      } else {
        inputsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The prediction input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tensor inputs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addInputs(com.google.cloud.vertexai.api.Tensor.Builder builderForValue) {
      if (inputsBuilder_ == null) {
        ensureInputsIsMutable();
        inputs_.add(builderForValue.build());
        onChanged();
      } else {
        inputsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The prediction input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tensor inputs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addInputs(
        int index, com.google.cloud.vertexai.api.Tensor.Builder builderForValue) {
      if (inputsBuilder_ == null) {
        ensureInputsIsMutable();
        inputs_.add(index, builderForValue.build());
        onChanged();
      } else {
        inputsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The prediction input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tensor inputs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllInputs(
        java.lang.Iterable<? extends com.google.cloud.vertexai.api.Tensor> values) {
      if (inputsBuilder_ == null) {
        ensureInputsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, inputs_);
        onChanged();
      } else {
        inputsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The prediction input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tensor inputs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearInputs() {
      if (inputsBuilder_ == null) {
        inputs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        inputsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The prediction input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tensor inputs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeInputs(int index) {
      if (inputsBuilder_ == null) {
        ensureInputsIsMutable();
        inputs_.remove(index);
        onChanged();
      } else {
        inputsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The prediction input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tensor inputs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.Tensor.Builder getInputsBuilder(int index) {
      return getInputsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The prediction input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tensor inputs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.TensorOrBuilder getInputsOrBuilder(int index) {
      if (inputsBuilder_ == null) {
        return inputs_.get(index);
      } else {
        return inputsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The prediction input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tensor inputs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.vertexai.api.TensorOrBuilder>
        getInputsOrBuilderList() {
      if (inputsBuilder_ != null) {
        return inputsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(inputs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The prediction input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tensor inputs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.Tensor.Builder addInputsBuilder() {
      return getInputsFieldBuilder()
          .addBuilder(com.google.cloud.vertexai.api.Tensor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The prediction input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tensor inputs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.Tensor.Builder addInputsBuilder(int index) {
      return getInputsFieldBuilder()
          .addBuilder(index, com.google.cloud.vertexai.api.Tensor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The prediction input.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Tensor inputs = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.vertexai.api.Tensor.Builder> getInputsBuilderList() {
      return getInputsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vertexai.api.Tensor,
            com.google.cloud.vertexai.api.Tensor.Builder,
            com.google.cloud.vertexai.api.TensorOrBuilder>
        getInputsFieldBuilder() {
      if (inputsBuilder_ == null) {
        inputsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vertexai.api.Tensor,
                com.google.cloud.vertexai.api.Tensor.Builder,
                com.google.cloud.vertexai.api.TensorOrBuilder>(
                inputs_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        inputs_ = null;
      }
      return inputsBuilder_;
    }

    private com.google.cloud.vertexai.api.Tensor parameters_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.Tensor,
            com.google.cloud.vertexai.api.Tensor.Builder,
            com.google.cloud.vertexai.api.TensorOrBuilder>
        parametersBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The parameters that govern the prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.Tensor parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the parameters field is set.
     */
    public boolean hasParameters() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The parameters that govern the prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.Tensor parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The parameters.
     */
    public com.google.cloud.vertexai.api.Tensor getParameters() {
      if (parametersBuilder_ == null) {
        return parameters_ == null
            ? com.google.cloud.vertexai.api.Tensor.getDefaultInstance()
            : parameters_;
      } else {
        return parametersBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The parameters that govern the prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.Tensor parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setParameters(com.google.cloud.vertexai.api.Tensor value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        parameters_ = value;
      } else {
        parametersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The parameters that govern the prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.Tensor parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setParameters(com.google.cloud.vertexai.api.Tensor.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        parameters_ = builderForValue.build();
      } else {
        parametersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The parameters that govern the prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.Tensor parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeParameters(com.google.cloud.vertexai.api.Tensor value) {
      if (parametersBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && parameters_ != null
            && parameters_ != com.google.cloud.vertexai.api.Tensor.getDefaultInstance()) {
          getParametersBuilder().mergeFrom(value);
        } else {
          parameters_ = value;
        }
      } else {
        parametersBuilder_.mergeFrom(value);
      }
      if (parameters_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The parameters that govern the prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.Tensor parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearParameters() {
      bitField0_ = (bitField0_ & ~0x00000004);
      parameters_ = null;
      if (parametersBuilder_ != null) {
        parametersBuilder_.dispose();
        parametersBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The parameters that govern the prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.Tensor parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.Tensor.Builder getParametersBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getParametersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The parameters that govern the prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.Tensor parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.vertexai.api.TensorOrBuilder getParametersOrBuilder() {
      if (parametersBuilder_ != null) {
        return parametersBuilder_.getMessageOrBuilder();
      } else {
        return parameters_ == null
            ? com.google.cloud.vertexai.api.Tensor.getDefaultInstance()
            : parameters_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The parameters that govern the prediction.
     * </pre>
     *
     * <code>
     * .google.cloud.vertexai.v1.Tensor parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.vertexai.api.Tensor,
            com.google.cloud.vertexai.api.Tensor.Builder,
            com.google.cloud.vertexai.api.TensorOrBuilder>
        getParametersFieldBuilder() {
      if (parametersBuilder_ == null) {
        parametersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.vertexai.api.Tensor,
                com.google.cloud.vertexai.api.Tensor.Builder,
                com.google.cloud.vertexai.api.TensorOrBuilder>(
                getParameters(), getParentForChildren(), isClean());
        parameters_ = null;
      }
      return parametersBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vertexai.v1.StreamDirectPredictRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vertexai.v1.StreamDirectPredictRequest)
  private static final com.google.cloud.vertexai.api.StreamDirectPredictRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vertexai.api.StreamDirectPredictRequest();
  }

  public static com.google.cloud.vertexai.api.StreamDirectPredictRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StreamDirectPredictRequest> PARSER =
      new com.google.protobuf.AbstractParser<StreamDirectPredictRequest>() {
        @java.lang.Override
        public StreamDirectPredictRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StreamDirectPredictRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StreamDirectPredictRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vertexai.api.StreamDirectPredictRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
