/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vertexai/v1/explanation.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.vertexai.api;

/**
 *
 *
 * <pre>
 * Aggregated explanation metrics for a Model over a set of instances.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vertexai.v1.ModelExplanation}
 */
public final class ModelExplanation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vertexai.v1.ModelExplanation)
    ModelExplanationOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ModelExplanation.newBuilder() to construct.
  private ModelExplanation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ModelExplanation() {
    meanAttributions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ModelExplanation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vertexai.api.ExplanationProto
        .internal_static_google_cloud_vertexai_v1_ModelExplanation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vertexai.api.ExplanationProto
        .internal_static_google_cloud_vertexai_v1_ModelExplanation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vertexai.api.ModelExplanation.class,
            com.google.cloud.vertexai.api.ModelExplanation.Builder.class);
  }

  public static final int MEAN_ATTRIBUTIONS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.vertexai.api.Attribution> meanAttributions_;

  /**
   *
   *
   * <pre>
   * Output only. Aggregated attributions explaining the Model's prediction
   * outputs over the set of instances. The attributions are grouped by outputs.
   *
   * For Models that predict only one output, such as regression Models that
   * predict only one score, there is only one attibution that explains the
   * predicted output. For Models that predict multiple outputs, such as
   * multiclass Models that predict multiple classes, each element explains one
   * specific item.
   * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
   * can be used to identify which output this attribution is explaining.
   *
   * The
   * [baselineOutputValue][google.cloud.aiplatform.v1.Attribution.baseline_output_value],
   * [instanceOutputValue][google.cloud.aiplatform.v1.Attribution.instance_output_value]
   * and
   * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
   * fields are averaged over the test data.
   *
   * NOTE: Currently AutoML tabular classification Models produce only one
   * attribution, which averages attributions over all the classes it predicts.
   * [Attribution.approximation_error][google.cloud.aiplatform.v1.Attribution.approximation_error]
   * is not populated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Attribution mean_attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.vertexai.api.Attribution> getMeanAttributionsList() {
    return meanAttributions_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Aggregated attributions explaining the Model's prediction
   * outputs over the set of instances. The attributions are grouped by outputs.
   *
   * For Models that predict only one output, such as regression Models that
   * predict only one score, there is only one attibution that explains the
   * predicted output. For Models that predict multiple outputs, such as
   * multiclass Models that predict multiple classes, each element explains one
   * specific item.
   * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
   * can be used to identify which output this attribution is explaining.
   *
   * The
   * [baselineOutputValue][google.cloud.aiplatform.v1.Attribution.baseline_output_value],
   * [instanceOutputValue][google.cloud.aiplatform.v1.Attribution.instance_output_value]
   * and
   * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
   * fields are averaged over the test data.
   *
   * NOTE: Currently AutoML tabular classification Models produce only one
   * attribution, which averages attributions over all the classes it predicts.
   * [Attribution.approximation_error][google.cloud.aiplatform.v1.Attribution.approximation_error]
   * is not populated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Attribution mean_attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.vertexai.api.AttributionOrBuilder>
      getMeanAttributionsOrBuilderList() {
    return meanAttributions_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Aggregated attributions explaining the Model's prediction
   * outputs over the set of instances. The attributions are grouped by outputs.
   *
   * For Models that predict only one output, such as regression Models that
   * predict only one score, there is only one attibution that explains the
   * predicted output. For Models that predict multiple outputs, such as
   * multiclass Models that predict multiple classes, each element explains one
   * specific item.
   * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
   * can be used to identify which output this attribution is explaining.
   *
   * The
   * [baselineOutputValue][google.cloud.aiplatform.v1.Attribution.baseline_output_value],
   * [instanceOutputValue][google.cloud.aiplatform.v1.Attribution.instance_output_value]
   * and
   * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
   * fields are averaged over the test data.
   *
   * NOTE: Currently AutoML tabular classification Models produce only one
   * attribution, which averages attributions over all the classes it predicts.
   * [Attribution.approximation_error][google.cloud.aiplatform.v1.Attribution.approximation_error]
   * is not populated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Attribution mean_attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getMeanAttributionsCount() {
    return meanAttributions_.size();
  }

  /**
   *
   *
   * <pre>
   * Output only. Aggregated attributions explaining the Model's prediction
   * outputs over the set of instances. The attributions are grouped by outputs.
   *
   * For Models that predict only one output, such as regression Models that
   * predict only one score, there is only one attibution that explains the
   * predicted output. For Models that predict multiple outputs, such as
   * multiclass Models that predict multiple classes, each element explains one
   * specific item.
   * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
   * can be used to identify which output this attribution is explaining.
   *
   * The
   * [baselineOutputValue][google.cloud.aiplatform.v1.Attribution.baseline_output_value],
   * [instanceOutputValue][google.cloud.aiplatform.v1.Attribution.instance_output_value]
   * and
   * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
   * fields are averaged over the test data.
   *
   * NOTE: Currently AutoML tabular classification Models produce only one
   * attribution, which averages attributions over all the classes it predicts.
   * [Attribution.approximation_error][google.cloud.aiplatform.v1.Attribution.approximation_error]
   * is not populated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Attribution mean_attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.Attribution getMeanAttributions(int index) {
    return meanAttributions_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Output only. Aggregated attributions explaining the Model's prediction
   * outputs over the set of instances. The attributions are grouped by outputs.
   *
   * For Models that predict only one output, such as regression Models that
   * predict only one score, there is only one attibution that explains the
   * predicted output. For Models that predict multiple outputs, such as
   * multiclass Models that predict multiple classes, each element explains one
   * specific item.
   * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
   * can be used to identify which output this attribution is explaining.
   *
   * The
   * [baselineOutputValue][google.cloud.aiplatform.v1.Attribution.baseline_output_value],
   * [instanceOutputValue][google.cloud.aiplatform.v1.Attribution.instance_output_value]
   * and
   * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
   * fields are averaged over the test data.
   *
   * NOTE: Currently AutoML tabular classification Models produce only one
   * attribution, which averages attributions over all the classes it predicts.
   * [Attribution.approximation_error][google.cloud.aiplatform.v1.Attribution.approximation_error]
   * is not populated.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.vertexai.v1.Attribution mean_attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.vertexai.api.AttributionOrBuilder getMeanAttributionsOrBuilder(
      int index) {
    return meanAttributions_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < meanAttributions_.size(); i++) {
      output.writeMessage(1, meanAttributions_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < meanAttributions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, meanAttributions_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vertexai.api.ModelExplanation)) {
      return super.equals(obj);
    }
    com.google.cloud.vertexai.api.ModelExplanation other =
        (com.google.cloud.vertexai.api.ModelExplanation) obj;

    if (!getMeanAttributionsList().equals(other.getMeanAttributionsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getMeanAttributionsCount() > 0) {
      hash = (37 * hash) + MEAN_ATTRIBUTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getMeanAttributionsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vertexai.api.ModelExplanation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.ModelExplanation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.ModelExplanation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.ModelExplanation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.ModelExplanation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vertexai.api.ModelExplanation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.ModelExplanation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.ModelExplanation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.ModelExplanation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.ModelExplanation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vertexai.api.ModelExplanation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vertexai.api.ModelExplanation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.vertexai.api.ModelExplanation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Aggregated explanation metrics for a Model over a set of instances.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vertexai.v1.ModelExplanation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vertexai.v1.ModelExplanation)
      com.google.cloud.vertexai.api.ModelExplanationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vertexai.api.ExplanationProto
          .internal_static_google_cloud_vertexai_v1_ModelExplanation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vertexai.api.ExplanationProto
          .internal_static_google_cloud_vertexai_v1_ModelExplanation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vertexai.api.ModelExplanation.class,
              com.google.cloud.vertexai.api.ModelExplanation.Builder.class);
    }

    // Construct using com.google.cloud.vertexai.api.ModelExplanation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (meanAttributionsBuilder_ == null) {
        meanAttributions_ = java.util.Collections.emptyList();
      } else {
        meanAttributions_ = null;
        meanAttributionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vertexai.api.ExplanationProto
          .internal_static_google_cloud_vertexai_v1_ModelExplanation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.ModelExplanation getDefaultInstanceForType() {
      return com.google.cloud.vertexai.api.ModelExplanation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.ModelExplanation build() {
      com.google.cloud.vertexai.api.ModelExplanation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vertexai.api.ModelExplanation buildPartial() {
      com.google.cloud.vertexai.api.ModelExplanation result =
          new com.google.cloud.vertexai.api.ModelExplanation(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.vertexai.api.ModelExplanation result) {
      if (meanAttributionsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          meanAttributions_ = java.util.Collections.unmodifiableList(meanAttributions_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.meanAttributions_ = meanAttributions_;
      } else {
        result.meanAttributions_ = meanAttributionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.vertexai.api.ModelExplanation result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vertexai.api.ModelExplanation) {
        return mergeFrom((com.google.cloud.vertexai.api.ModelExplanation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vertexai.api.ModelExplanation other) {
      if (other == com.google.cloud.vertexai.api.ModelExplanation.getDefaultInstance()) return this;
      if (meanAttributionsBuilder_ == null) {
        if (!other.meanAttributions_.isEmpty()) {
          if (meanAttributions_.isEmpty()) {
            meanAttributions_ = other.meanAttributions_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureMeanAttributionsIsMutable();
            meanAttributions_.addAll(other.meanAttributions_);
          }
          onChanged();
        }
      } else {
        if (!other.meanAttributions_.isEmpty()) {
          if (meanAttributionsBuilder_.isEmpty()) {
            meanAttributionsBuilder_.dispose();
            meanAttributionsBuilder_ = null;
            meanAttributions_ = other.meanAttributions_;
            bitField0_ = (bitField0_ & ~0x00000001);
            meanAttributionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMeanAttributionsFieldBuilder()
                    : null;
          } else {
            meanAttributionsBuilder_.addAllMessages(other.meanAttributions_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.vertexai.api.Attribution m =
                    input.readMessage(
                        com.google.cloud.vertexai.api.Attribution.parser(), extensionRegistry);
                if (meanAttributionsBuilder_ == null) {
                  ensureMeanAttributionsIsMutable();
                  meanAttributions_.add(m);
                } else {
                  meanAttributionsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.vertexai.api.Attribution> meanAttributions_ =
        java.util.Collections.emptyList();

    private void ensureMeanAttributionsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        meanAttributions_ =
            new java.util.ArrayList<com.google.cloud.vertexai.api.Attribution>(meanAttributions_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vertexai.api.Attribution,
            com.google.cloud.vertexai.api.Attribution.Builder,
            com.google.cloud.vertexai.api.AttributionOrBuilder>
        meanAttributionsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Aggregated attributions explaining the Model's prediction
     * outputs over the set of instances. The attributions are grouped by outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * The
     * [baselineOutputValue][google.cloud.aiplatform.v1.Attribution.baseline_output_value],
     * [instanceOutputValue][google.cloud.aiplatform.v1.Attribution.instance_output_value]
     * and
     * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
     * fields are averaged over the test data.
     *
     * NOTE: Currently AutoML tabular classification Models produce only one
     * attribution, which averages attributions over all the classes it predicts.
     * [Attribution.approximation_error][google.cloud.aiplatform.v1.Attribution.approximation_error]
     * is not populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Attribution mean_attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.vertexai.api.Attribution> getMeanAttributionsList() {
      if (meanAttributionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(meanAttributions_);
      } else {
        return meanAttributionsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Aggregated attributions explaining the Model's prediction
     * outputs over the set of instances. The attributions are grouped by outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * The
     * [baselineOutputValue][google.cloud.aiplatform.v1.Attribution.baseline_output_value],
     * [instanceOutputValue][google.cloud.aiplatform.v1.Attribution.instance_output_value]
     * and
     * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
     * fields are averaged over the test data.
     *
     * NOTE: Currently AutoML tabular classification Models produce only one
     * attribution, which averages attributions over all the classes it predicts.
     * [Attribution.approximation_error][google.cloud.aiplatform.v1.Attribution.approximation_error]
     * is not populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Attribution mean_attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getMeanAttributionsCount() {
      if (meanAttributionsBuilder_ == null) {
        return meanAttributions_.size();
      } else {
        return meanAttributionsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Aggregated attributions explaining the Model's prediction
     * outputs over the set of instances. The attributions are grouped by outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * The
     * [baselineOutputValue][google.cloud.aiplatform.v1.Attribution.baseline_output_value],
     * [instanceOutputValue][google.cloud.aiplatform.v1.Attribution.instance_output_value]
     * and
     * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
     * fields are averaged over the test data.
     *
     * NOTE: Currently AutoML tabular classification Models produce only one
     * attribution, which averages attributions over all the classes it predicts.
     * [Attribution.approximation_error][google.cloud.aiplatform.v1.Attribution.approximation_error]
     * is not populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Attribution mean_attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.vertexai.api.Attribution getMeanAttributions(int index) {
      if (meanAttributionsBuilder_ == null) {
        return meanAttributions_.get(index);
      } else {
        return meanAttributionsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Aggregated attributions explaining the Model's prediction
     * outputs over the set of instances. The attributions are grouped by outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * The
     * [baselineOutputValue][google.cloud.aiplatform.v1.Attribution.baseline_output_value],
     * [instanceOutputValue][google.cloud.aiplatform.v1.Attribution.instance_output_value]
     * and
     * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
     * fields are averaged over the test data.
     *
     * NOTE: Currently AutoML tabular classification Models produce only one
     * attribution, which averages attributions over all the classes it predicts.
     * [Attribution.approximation_error][google.cloud.aiplatform.v1.Attribution.approximation_error]
     * is not populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Attribution mean_attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMeanAttributions(int index, com.google.cloud.vertexai.api.Attribution value) {
      if (meanAttributionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMeanAttributionsIsMutable();
        meanAttributions_.set(index, value);
        onChanged();
      } else {
        meanAttributionsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Aggregated attributions explaining the Model's prediction
     * outputs over the set of instances. The attributions are grouped by outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * The
     * [baselineOutputValue][google.cloud.aiplatform.v1.Attribution.baseline_output_value],
     * [instanceOutputValue][google.cloud.aiplatform.v1.Attribution.instance_output_value]
     * and
     * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
     * fields are averaged over the test data.
     *
     * NOTE: Currently AutoML tabular classification Models produce only one
     * attribution, which averages attributions over all the classes it predicts.
     * [Attribution.approximation_error][google.cloud.aiplatform.v1.Attribution.approximation_error]
     * is not populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Attribution mean_attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMeanAttributions(
        int index, com.google.cloud.vertexai.api.Attribution.Builder builderForValue) {
      if (meanAttributionsBuilder_ == null) {
        ensureMeanAttributionsIsMutable();
        meanAttributions_.set(index, builderForValue.build());
        onChanged();
      } else {
        meanAttributionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Aggregated attributions explaining the Model's prediction
     * outputs over the set of instances. The attributions are grouped by outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * The
     * [baselineOutputValue][google.cloud.aiplatform.v1.Attribution.baseline_output_value],
     * [instanceOutputValue][google.cloud.aiplatform.v1.Attribution.instance_output_value]
     * and
     * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
     * fields are averaged over the test data.
     *
     * NOTE: Currently AutoML tabular classification Models produce only one
     * attribution, which averages attributions over all the classes it predicts.
     * [Attribution.approximation_error][google.cloud.aiplatform.v1.Attribution.approximation_error]
     * is not populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Attribution mean_attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMeanAttributions(com.google.cloud.vertexai.api.Attribution value) {
      if (meanAttributionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMeanAttributionsIsMutable();
        meanAttributions_.add(value);
        onChanged();
      } else {
        meanAttributionsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Aggregated attributions explaining the Model's prediction
     * outputs over the set of instances. The attributions are grouped by outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * The
     * [baselineOutputValue][google.cloud.aiplatform.v1.Attribution.baseline_output_value],
     * [instanceOutputValue][google.cloud.aiplatform.v1.Attribution.instance_output_value]
     * and
     * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
     * fields are averaged over the test data.
     *
     * NOTE: Currently AutoML tabular classification Models produce only one
     * attribution, which averages attributions over all the classes it predicts.
     * [Attribution.approximation_error][google.cloud.aiplatform.v1.Attribution.approximation_error]
     * is not populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Attribution mean_attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMeanAttributions(int index, com.google.cloud.vertexai.api.Attribution value) {
      if (meanAttributionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMeanAttributionsIsMutable();
        meanAttributions_.add(index, value);
        onChanged();
      } else {
        meanAttributionsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Aggregated attributions explaining the Model's prediction
     * outputs over the set of instances. The attributions are grouped by outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * The
     * [baselineOutputValue][google.cloud.aiplatform.v1.Attribution.baseline_output_value],
     * [instanceOutputValue][google.cloud.aiplatform.v1.Attribution.instance_output_value]
     * and
     * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
     * fields are averaged over the test data.
     *
     * NOTE: Currently AutoML tabular classification Models produce only one
     * attribution, which averages attributions over all the classes it predicts.
     * [Attribution.approximation_error][google.cloud.aiplatform.v1.Attribution.approximation_error]
     * is not populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Attribution mean_attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMeanAttributions(
        com.google.cloud.vertexai.api.Attribution.Builder builderForValue) {
      if (meanAttributionsBuilder_ == null) {
        ensureMeanAttributionsIsMutable();
        meanAttributions_.add(builderForValue.build());
        onChanged();
      } else {
        meanAttributionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Aggregated attributions explaining the Model's prediction
     * outputs over the set of instances. The attributions are grouped by outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * The
     * [baselineOutputValue][google.cloud.aiplatform.v1.Attribution.baseline_output_value],
     * [instanceOutputValue][google.cloud.aiplatform.v1.Attribution.instance_output_value]
     * and
     * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
     * fields are averaged over the test data.
     *
     * NOTE: Currently AutoML tabular classification Models produce only one
     * attribution, which averages attributions over all the classes it predicts.
     * [Attribution.approximation_error][google.cloud.aiplatform.v1.Attribution.approximation_error]
     * is not populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Attribution mean_attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMeanAttributions(
        int index, com.google.cloud.vertexai.api.Attribution.Builder builderForValue) {
      if (meanAttributionsBuilder_ == null) {
        ensureMeanAttributionsIsMutable();
        meanAttributions_.add(index, builderForValue.build());
        onChanged();
      } else {
        meanAttributionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Aggregated attributions explaining the Model's prediction
     * outputs over the set of instances. The attributions are grouped by outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * The
     * [baselineOutputValue][google.cloud.aiplatform.v1.Attribution.baseline_output_value],
     * [instanceOutputValue][google.cloud.aiplatform.v1.Attribution.instance_output_value]
     * and
     * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
     * fields are averaged over the test data.
     *
     * NOTE: Currently AutoML tabular classification Models produce only one
     * attribution, which averages attributions over all the classes it predicts.
     * [Attribution.approximation_error][google.cloud.aiplatform.v1.Attribution.approximation_error]
     * is not populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Attribution mean_attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllMeanAttributions(
        java.lang.Iterable<? extends com.google.cloud.vertexai.api.Attribution> values) {
      if (meanAttributionsBuilder_ == null) {
        ensureMeanAttributionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, meanAttributions_);
        onChanged();
      } else {
        meanAttributionsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Aggregated attributions explaining the Model's prediction
     * outputs over the set of instances. The attributions are grouped by outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * The
     * [baselineOutputValue][google.cloud.aiplatform.v1.Attribution.baseline_output_value],
     * [instanceOutputValue][google.cloud.aiplatform.v1.Attribution.instance_output_value]
     * and
     * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
     * fields are averaged over the test data.
     *
     * NOTE: Currently AutoML tabular classification Models produce only one
     * attribution, which averages attributions over all the classes it predicts.
     * [Attribution.approximation_error][google.cloud.aiplatform.v1.Attribution.approximation_error]
     * is not populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Attribution mean_attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearMeanAttributions() {
      if (meanAttributionsBuilder_ == null) {
        meanAttributions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        meanAttributionsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Aggregated attributions explaining the Model's prediction
     * outputs over the set of instances. The attributions are grouped by outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * The
     * [baselineOutputValue][google.cloud.aiplatform.v1.Attribution.baseline_output_value],
     * [instanceOutputValue][google.cloud.aiplatform.v1.Attribution.instance_output_value]
     * and
     * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
     * fields are averaged over the test data.
     *
     * NOTE: Currently AutoML tabular classification Models produce only one
     * attribution, which averages attributions over all the classes it predicts.
     * [Attribution.approximation_error][google.cloud.aiplatform.v1.Attribution.approximation_error]
     * is not populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Attribution mean_attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeMeanAttributions(int index) {
      if (meanAttributionsBuilder_ == null) {
        ensureMeanAttributionsIsMutable();
        meanAttributions_.remove(index);
        onChanged();
      } else {
        meanAttributionsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Aggregated attributions explaining the Model's prediction
     * outputs over the set of instances. The attributions are grouped by outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * The
     * [baselineOutputValue][google.cloud.aiplatform.v1.Attribution.baseline_output_value],
     * [instanceOutputValue][google.cloud.aiplatform.v1.Attribution.instance_output_value]
     * and
     * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
     * fields are averaged over the test data.
     *
     * NOTE: Currently AutoML tabular classification Models produce only one
     * attribution, which averages attributions over all the classes it predicts.
     * [Attribution.approximation_error][google.cloud.aiplatform.v1.Attribution.approximation_error]
     * is not populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Attribution mean_attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.vertexai.api.Attribution.Builder getMeanAttributionsBuilder(int index) {
      return getMeanAttributionsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. Aggregated attributions explaining the Model's prediction
     * outputs over the set of instances. The attributions are grouped by outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * The
     * [baselineOutputValue][google.cloud.aiplatform.v1.Attribution.baseline_output_value],
     * [instanceOutputValue][google.cloud.aiplatform.v1.Attribution.instance_output_value]
     * and
     * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
     * fields are averaged over the test data.
     *
     * NOTE: Currently AutoML tabular classification Models produce only one
     * attribution, which averages attributions over all the classes it predicts.
     * [Attribution.approximation_error][google.cloud.aiplatform.v1.Attribution.approximation_error]
     * is not populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Attribution mean_attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.vertexai.api.AttributionOrBuilder getMeanAttributionsOrBuilder(
        int index) {
      if (meanAttributionsBuilder_ == null) {
        return meanAttributions_.get(index);
      } else {
        return meanAttributionsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Aggregated attributions explaining the Model's prediction
     * outputs over the set of instances. The attributions are grouped by outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * The
     * [baselineOutputValue][google.cloud.aiplatform.v1.Attribution.baseline_output_value],
     * [instanceOutputValue][google.cloud.aiplatform.v1.Attribution.instance_output_value]
     * and
     * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
     * fields are averaged over the test data.
     *
     * NOTE: Currently AutoML tabular classification Models produce only one
     * attribution, which averages attributions over all the classes it predicts.
     * [Attribution.approximation_error][google.cloud.aiplatform.v1.Attribution.approximation_error]
     * is not populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Attribution mean_attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.vertexai.api.AttributionOrBuilder>
        getMeanAttributionsOrBuilderList() {
      if (meanAttributionsBuilder_ != null) {
        return meanAttributionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(meanAttributions_);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Aggregated attributions explaining the Model's prediction
     * outputs over the set of instances. The attributions are grouped by outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * The
     * [baselineOutputValue][google.cloud.aiplatform.v1.Attribution.baseline_output_value],
     * [instanceOutputValue][google.cloud.aiplatform.v1.Attribution.instance_output_value]
     * and
     * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
     * fields are averaged over the test data.
     *
     * NOTE: Currently AutoML tabular classification Models produce only one
     * attribution, which averages attributions over all the classes it predicts.
     * [Attribution.approximation_error][google.cloud.aiplatform.v1.Attribution.approximation_error]
     * is not populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Attribution mean_attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.vertexai.api.Attribution.Builder addMeanAttributionsBuilder() {
      return getMeanAttributionsFieldBuilder()
          .addBuilder(com.google.cloud.vertexai.api.Attribution.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Aggregated attributions explaining the Model's prediction
     * outputs over the set of instances. The attributions are grouped by outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * The
     * [baselineOutputValue][google.cloud.aiplatform.v1.Attribution.baseline_output_value],
     * [instanceOutputValue][google.cloud.aiplatform.v1.Attribution.instance_output_value]
     * and
     * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
     * fields are averaged over the test data.
     *
     * NOTE: Currently AutoML tabular classification Models produce only one
     * attribution, which averages attributions over all the classes it predicts.
     * [Attribution.approximation_error][google.cloud.aiplatform.v1.Attribution.approximation_error]
     * is not populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Attribution mean_attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.vertexai.api.Attribution.Builder addMeanAttributionsBuilder(int index) {
      return getMeanAttributionsFieldBuilder()
          .addBuilder(index, com.google.cloud.vertexai.api.Attribution.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Aggregated attributions explaining the Model's prediction
     * outputs over the set of instances. The attributions are grouped by outputs.
     *
     * For Models that predict only one output, such as regression Models that
     * predict only one score, there is only one attibution that explains the
     * predicted output. For Models that predict multiple outputs, such as
     * multiclass Models that predict multiple classes, each element explains one
     * specific item.
     * [Attribution.output_index][google.cloud.aiplatform.v1.Attribution.output_index]
     * can be used to identify which output this attribution is explaining.
     *
     * The
     * [baselineOutputValue][google.cloud.aiplatform.v1.Attribution.baseline_output_value],
     * [instanceOutputValue][google.cloud.aiplatform.v1.Attribution.instance_output_value]
     * and
     * [featureAttributions][google.cloud.aiplatform.v1.Attribution.feature_attributions]
     * fields are averaged over the test data.
     *
     * NOTE: Currently AutoML tabular classification Models produce only one
     * attribution, which averages attributions over all the classes it predicts.
     * [Attribution.approximation_error][google.cloud.aiplatform.v1.Attribution.approximation_error]
     * is not populated.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.vertexai.v1.Attribution mean_attributions = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.vertexai.api.Attribution.Builder>
        getMeanAttributionsBuilderList() {
      return getMeanAttributionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vertexai.api.Attribution,
            com.google.cloud.vertexai.api.Attribution.Builder,
            com.google.cloud.vertexai.api.AttributionOrBuilder>
        getMeanAttributionsFieldBuilder() {
      if (meanAttributionsBuilder_ == null) {
        meanAttributionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vertexai.api.Attribution,
                com.google.cloud.vertexai.api.Attribution.Builder,
                com.google.cloud.vertexai.api.AttributionOrBuilder>(
                meanAttributions_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        meanAttributions_ = null;
      }
      return meanAttributionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vertexai.v1.ModelExplanation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vertexai.v1.ModelExplanation)
  private static final com.google.cloud.vertexai.api.ModelExplanation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vertexai.api.ModelExplanation();
  }

  public static com.google.cloud.vertexai.api.ModelExplanation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ModelExplanation> PARSER =
      new com.google.protobuf.AbstractParser<ModelExplanation>() {
        @java.lang.Override
        public ModelExplanation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ModelExplanation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ModelExplanation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vertexai.api.ModelExplanation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
