/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.workstations.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WorkstationName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_WORKSTATION_CLUSTER_WORKSTATION_CONFIG_WORKSTATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/workstationClusters/{workstation_cluster}/workstationConfigs/{workstation_config}/workstations/{workstation}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String workstationCluster;
    private final String workstationConfig;
    private final String workstation;

    @Deprecated
    protected WorkstationName() {
        this.project = null;
        this.location = null;
        this.workstationCluster = null;
        this.workstationConfig = null;
        this.workstation = null;
    }

    private WorkstationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.workstationCluster = (String)Preconditions.checkNotNull((Object)builder.getWorkstationCluster());
        this.workstationConfig = (String)Preconditions.checkNotNull((Object)builder.getWorkstationConfig());
        this.workstation = (String)Preconditions.checkNotNull((Object)builder.getWorkstation());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getWorkstationCluster() {
        return this.workstationCluster;
    }

    public String getWorkstationConfig() {
        return this.workstationConfig;
    }

    public String getWorkstation() {
        return this.workstation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static WorkstationName of(String project, String location, String workstationCluster, String workstationConfig, String workstation) {
        return WorkstationName.newBuilder().setProject(project).setLocation(location).setWorkstationCluster(workstationCluster).setWorkstationConfig(workstationConfig).setWorkstation(workstation).build();
    }

    public static String format(String project, String location, String workstationCluster, String workstationConfig, String workstation) {
        return WorkstationName.newBuilder().setProject(project).setLocation(location).setWorkstationCluster(workstationCluster).setWorkstationConfig(workstationConfig).setWorkstation(workstation).build().toString();
    }

    public static WorkstationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_WORKSTATION_CLUSTER_WORKSTATION_CONFIG_WORKSTATION.validatedMatch(formattedString, "WorkstationName.parse: formattedString not in valid format");
        return WorkstationName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("workstation_cluster"), (String)matchMap.get("workstation_config"), (String)matchMap.get("workstation"));
    }

    public static List<WorkstationName> parseList(List<String> formattedStrings) {
        ArrayList<WorkstationName> list = new ArrayList<WorkstationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(WorkstationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<WorkstationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (WorkstationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_WORKSTATION_CLUSTER_WORKSTATION_CONFIG_WORKSTATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            WorkstationName workstationName = this;
            synchronized (workstationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.workstationCluster != null) {
                        fieldMapBuilder.put((Object)"workstation_cluster", (Object)this.workstationCluster);
                    }
                    if (this.workstationConfig != null) {
                        fieldMapBuilder.put((Object)"workstation_config", (Object)this.workstationConfig);
                    }
                    if (this.workstation != null) {
                        fieldMapBuilder.put((Object)"workstation", (Object)this.workstation);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_WORKSTATION_CLUSTER_WORKSTATION_CONFIG_WORKSTATION.instantiate(new String[]{"project", this.project, "location", this.location, "workstation_cluster", this.workstationCluster, "workstation_config", this.workstationConfig, "workstation", this.workstation});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            WorkstationName that = (WorkstationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.workstationCluster, that.workstationCluster) && Objects.equals(this.workstationConfig, that.workstationConfig) && Objects.equals(this.workstation, that.workstation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.workstationCluster);
        h *= 1000003;
        h ^= Objects.hashCode(this.workstationConfig);
        h *= 1000003;
        return h ^= Objects.hashCode(this.workstation);
    }

    public static class Builder {
        private String project;
        private String location;
        private String workstationCluster;
        private String workstationConfig;
        private String workstation;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getWorkstationCluster() {
            return this.workstationCluster;
        }

        public String getWorkstationConfig() {
            return this.workstationConfig;
        }

        public String getWorkstation() {
            return this.workstation;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setWorkstationCluster(String workstationCluster) {
            this.workstationCluster = workstationCluster;
            return this;
        }

        public Builder setWorkstationConfig(String workstationConfig) {
            this.workstationConfig = workstationConfig;
            return this;
        }

        public Builder setWorkstation(String workstation) {
            this.workstation = workstation;
            return this;
        }

        private Builder(WorkstationName workstationName) {
            this.project = workstationName.project;
            this.location = workstationName.location;
            this.workstationCluster = workstationName.workstationCluster;
            this.workstationConfig = workstationName.workstationConfig;
            this.workstation = workstationName.workstation;
        }

        public WorkstationName build() {
            return new WorkstationName(this);
        }
    }
}

