/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/workstations/v1beta/workstations.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.workstations.v1beta;

/**
 *
 *
 * <pre>
 * Request message for GenerateAccessToken.
 * </pre>
 *
 * Protobuf type {@code google.cloud.workstations.v1beta.GenerateAccessTokenRequest}
 */
public final class GenerateAccessTokenRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.workstations.v1beta.GenerateAccessTokenRequest)
    GenerateAccessTokenRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use GenerateAccessTokenRequest.newBuilder() to construct.
  private GenerateAccessTokenRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GenerateAccessTokenRequest() {
    workstation_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GenerateAccessTokenRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.workstations.v1beta.WorkstationsProto
        .internal_static_google_cloud_workstations_v1beta_GenerateAccessTokenRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.workstations.v1beta.WorkstationsProto
        .internal_static_google_cloud_workstations_v1beta_GenerateAccessTokenRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest.class,
            com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest.Builder.class);
  }

  private int expirationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object expiration_;

  public enum ExpirationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    EXPIRE_TIME(2),
    TTL(3),
    EXPIRATION_NOT_SET(0);
    private final int value;

    private ExpirationCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ExpirationCase valueOf(int value) {
      return forNumber(value);
    }

    public static ExpirationCase forNumber(int value) {
      switch (value) {
        case 2:
          return EXPIRE_TIME;
        case 3:
          return TTL;
        case 0:
          return EXPIRATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ExpirationCase getExpirationCase() {
    return ExpirationCase.forNumber(expirationCase_);
  }

  public static final int EXPIRE_TIME_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * Desired expiration time of the access token. This value must
   * be at most 24 hours in the future. If a value is not specified, the
   * token's expiration time will be set to a default value of 1 hour in the
   * future.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 2;</code>
   *
   * @return Whether the expireTime field is set.
   */
  @java.lang.Override
  public boolean hasExpireTime() {
    return expirationCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * Desired expiration time of the access token. This value must
   * be at most 24 hours in the future. If a value is not specified, the
   * token's expiration time will be set to a default value of 1 hour in the
   * future.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 2;</code>
   *
   * @return The expireTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getExpireTime() {
    if (expirationCase_ == 2) {
      return (com.google.protobuf.Timestamp) expiration_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Desired expiration time of the access token. This value must
   * be at most 24 hours in the future. If a value is not specified, the
   * token's expiration time will be set to a default value of 1 hour in the
   * future.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
    if (expirationCase_ == 2) {
      return (com.google.protobuf.Timestamp) expiration_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }

  public static final int TTL_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * Desired lifetime duration of the access token. This value must
   * be at most 24 hours. If a value is not specified, the token's lifetime
   * will be set to a default value of 1 hour.
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 3;</code>
   *
   * @return Whether the ttl field is set.
   */
  @java.lang.Override
  public boolean hasTtl() {
    return expirationCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * Desired lifetime duration of the access token. This value must
   * be at most 24 hours. If a value is not specified, the token's lifetime
   * will be set to a default value of 1 hour.
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 3;</code>
   *
   * @return The ttl.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTtl() {
    if (expirationCase_ == 3) {
      return (com.google.protobuf.Duration) expiration_;
    }
    return com.google.protobuf.Duration.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Desired lifetime duration of the access token. This value must
   * be at most 24 hours. If a value is not specified, the token's lifetime
   * will be set to a default value of 1 hour.
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTtlOrBuilder() {
    if (expirationCase_ == 3) {
      return (com.google.protobuf.Duration) expiration_;
    }
    return com.google.protobuf.Duration.getDefaultInstance();
  }

  public static final int WORKSTATION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object workstation_ = "";

  /**
   *
   *
   * <pre>
   * Required. Name of the workstation for which the access token should be
   * generated.
   * </pre>
   *
   * <code>
   * string workstation = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The workstation.
   */
  @java.lang.Override
  public java.lang.String getWorkstation() {
    java.lang.Object ref = workstation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      workstation_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Name of the workstation for which the access token should be
   * generated.
   * </pre>
   *
   * <code>
   * string workstation = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for workstation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getWorkstationBytes() {
    java.lang.Object ref = workstation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      workstation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(workstation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, workstation_);
    }
    if (expirationCase_ == 2) {
      output.writeMessage(2, (com.google.protobuf.Timestamp) expiration_);
    }
    if (expirationCase_ == 3) {
      output.writeMessage(3, (com.google.protobuf.Duration) expiration_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(workstation_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, workstation_);
    }
    if (expirationCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.protobuf.Timestamp) expiration_);
    }
    if (expirationCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.protobuf.Duration) expiration_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest other =
        (com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest) obj;

    if (!getWorkstation().equals(other.getWorkstation())) return false;
    if (!getExpirationCase().equals(other.getExpirationCase())) return false;
    switch (expirationCase_) {
      case 2:
        if (!getExpireTime().equals(other.getExpireTime())) return false;
        break;
      case 3:
        if (!getTtl().equals(other.getTtl())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + WORKSTATION_FIELD_NUMBER;
    hash = (53 * hash) + getWorkstation().hashCode();
    switch (expirationCase_) {
      case 2:
        hash = (37 * hash) + EXPIRE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getExpireTime().hashCode();
        break;
      case 3:
        hash = (37 * hash) + TTL_FIELD_NUMBER;
        hash = (53 * hash) + getTtl().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for GenerateAccessToken.
   * </pre>
   *
   * Protobuf type {@code google.cloud.workstations.v1beta.GenerateAccessTokenRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.workstations.v1beta.GenerateAccessTokenRequest)
      com.google.cloud.workstations.v1beta.GenerateAccessTokenRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.workstations.v1beta.WorkstationsProto
          .internal_static_google_cloud_workstations_v1beta_GenerateAccessTokenRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.workstations.v1beta.WorkstationsProto
          .internal_static_google_cloud_workstations_v1beta_GenerateAccessTokenRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest.class,
              com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest.Builder.class);
    }

    // Construct using com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.clear();
      }
      if (ttlBuilder_ != null) {
        ttlBuilder_.clear();
      }
      workstation_ = "";
      expirationCase_ = 0;
      expiration_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.workstations.v1beta.WorkstationsProto
          .internal_static_google_cloud_workstations_v1beta_GenerateAccessTokenRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest
        getDefaultInstanceForType() {
      return com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest build() {
      com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest buildPartial() {
      com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest result =
          new com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.workstation_ = workstation_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest result) {
      result.expirationCase_ = expirationCase_;
      result.expiration_ = this.expiration_;
      if (expirationCase_ == 2 && expireTimeBuilder_ != null) {
        result.expiration_ = expireTimeBuilder_.build();
      }
      if (expirationCase_ == 3 && ttlBuilder_ != null) {
        result.expiration_ = ttlBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest) {
        return mergeFrom((com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest other) {
      if (other
          == com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest.getDefaultInstance())
        return this;
      if (!other.getWorkstation().isEmpty()) {
        workstation_ = other.workstation_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      switch (other.getExpirationCase()) {
        case EXPIRE_TIME:
          {
            mergeExpireTime(other.getExpireTime());
            break;
          }
        case TTL:
          {
            mergeTtl(other.getTtl());
            break;
          }
        case EXPIRATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                workstation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getExpireTimeFieldBuilder().getBuilder(), extensionRegistry);
                expirationCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getTtlFieldBuilder().getBuilder(), extensionRegistry);
                expirationCase_ = 3;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int expirationCase_ = 0;
    private java.lang.Object expiration_;

    public ExpirationCase getExpirationCase() {
      return ExpirationCase.forNumber(expirationCase_);
    }

    public Builder clearExpiration() {
      expirationCase_ = 0;
      expiration_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        expireTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Desired expiration time of the access token. This value must
     * be at most 24 hours in the future. If a value is not specified, the
     * token's expiration time will be set to a default value of 1 hour in the
     * future.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     *
     * @return Whether the expireTime field is set.
     */
    @java.lang.Override
    public boolean hasExpireTime() {
      return expirationCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Desired expiration time of the access token. This value must
     * be at most 24 hours in the future. If a value is not specified, the
     * token's expiration time will be set to a default value of 1 hour in the
     * future.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     *
     * @return The expireTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getExpireTime() {
      if (expireTimeBuilder_ == null) {
        if (expirationCase_ == 2) {
          return (com.google.protobuf.Timestamp) expiration_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      } else {
        if (expirationCase_ == 2) {
          return expireTimeBuilder_.getMessage();
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Desired expiration time of the access token. This value must
     * be at most 24 hours in the future. If a value is not specified, the
     * token's expiration time will be set to a default value of 1 hour in the
     * future.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expiration_ = value;
        onChanged();
      } else {
        expireTimeBuilder_.setMessage(value);
      }
      expirationCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Desired expiration time of the access token. This value must
     * be at most 24 hours in the future. If a value is not specified, the
     * token's expiration time will be set to a default value of 1 hour in the
     * future.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (expireTimeBuilder_ == null) {
        expiration_ = builderForValue.build();
        onChanged();
      } else {
        expireTimeBuilder_.setMessage(builderForValue.build());
      }
      expirationCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Desired expiration time of the access token. This value must
     * be at most 24 hours in the future. If a value is not specified, the
     * token's expiration time will be set to a default value of 1 hour in the
     * future.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     */
    public Builder mergeExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (expirationCase_ == 2
            && expiration_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          expiration_ =
              com.google.protobuf.Timestamp.newBuilder((com.google.protobuf.Timestamp) expiration_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          expiration_ = value;
        }
        onChanged();
      } else {
        if (expirationCase_ == 2) {
          expireTimeBuilder_.mergeFrom(value);
        } else {
          expireTimeBuilder_.setMessage(value);
        }
      }
      expirationCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Desired expiration time of the access token. This value must
     * be at most 24 hours in the future. If a value is not specified, the
     * token's expiration time will be set to a default value of 1 hour in the
     * future.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     */
    public Builder clearExpireTime() {
      if (expireTimeBuilder_ == null) {
        if (expirationCase_ == 2) {
          expirationCase_ = 0;
          expiration_ = null;
          onChanged();
        }
      } else {
        if (expirationCase_ == 2) {
          expirationCase_ = 0;
          expiration_ = null;
        }
        expireTimeBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Desired expiration time of the access token. This value must
     * be at most 24 hours in the future. If a value is not specified, the
     * token's expiration time will be set to a default value of 1 hour in the
     * future.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getExpireTimeBuilder() {
      return getExpireTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Desired expiration time of the access token. This value must
     * be at most 24 hours in the future. If a value is not specified, the
     * token's expiration time will be set to a default value of 1 hour in the
     * future.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
      if ((expirationCase_ == 2) && (expireTimeBuilder_ != null)) {
        return expireTimeBuilder_.getMessageOrBuilder();
      } else {
        if (expirationCase_ == 2) {
          return (com.google.protobuf.Timestamp) expiration_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Desired expiration time of the access token. This value must
     * be at most 24 hours in the future. If a value is not specified, the
     * token's expiration time will be set to a default value of 1 hour in the
     * future.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getExpireTimeFieldBuilder() {
      if (expireTimeBuilder_ == null) {
        if (!(expirationCase_ == 2)) {
          expiration_ = com.google.protobuf.Timestamp.getDefaultInstance();
        }
        expireTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                (com.google.protobuf.Timestamp) expiration_, getParentForChildren(), isClean());
        expiration_ = null;
      }
      expirationCase_ = 2;
      onChanged();
      return expireTimeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        ttlBuilder_;

    /**
     *
     *
     * <pre>
     * Desired lifetime duration of the access token. This value must
     * be at most 24 hours. If a value is not specified, the token's lifetime
     * will be set to a default value of 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 3;</code>
     *
     * @return Whether the ttl field is set.
     */
    @java.lang.Override
    public boolean hasTtl() {
      return expirationCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Desired lifetime duration of the access token. This value must
     * be at most 24 hours. If a value is not specified, the token's lifetime
     * will be set to a default value of 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 3;</code>
     *
     * @return The ttl.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getTtl() {
      if (ttlBuilder_ == null) {
        if (expirationCase_ == 3) {
          return (com.google.protobuf.Duration) expiration_;
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      } else {
        if (expirationCase_ == 3) {
          return ttlBuilder_.getMessage();
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Desired lifetime duration of the access token. This value must
     * be at most 24 hours. If a value is not specified, the token's lifetime
     * will be set to a default value of 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 3;</code>
     */
    public Builder setTtl(com.google.protobuf.Duration value) {
      if (ttlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expiration_ = value;
        onChanged();
      } else {
        ttlBuilder_.setMessage(value);
      }
      expirationCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Desired lifetime duration of the access token. This value must
     * be at most 24 hours. If a value is not specified, the token's lifetime
     * will be set to a default value of 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 3;</code>
     */
    public Builder setTtl(com.google.protobuf.Duration.Builder builderForValue) {
      if (ttlBuilder_ == null) {
        expiration_ = builderForValue.build();
        onChanged();
      } else {
        ttlBuilder_.setMessage(builderForValue.build());
      }
      expirationCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Desired lifetime duration of the access token. This value must
     * be at most 24 hours. If a value is not specified, the token's lifetime
     * will be set to a default value of 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 3;</code>
     */
    public Builder mergeTtl(com.google.protobuf.Duration value) {
      if (ttlBuilder_ == null) {
        if (expirationCase_ == 3
            && expiration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          expiration_ =
              com.google.protobuf.Duration.newBuilder((com.google.protobuf.Duration) expiration_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          expiration_ = value;
        }
        onChanged();
      } else {
        if (expirationCase_ == 3) {
          ttlBuilder_.mergeFrom(value);
        } else {
          ttlBuilder_.setMessage(value);
        }
      }
      expirationCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Desired lifetime duration of the access token. This value must
     * be at most 24 hours. If a value is not specified, the token's lifetime
     * will be set to a default value of 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 3;</code>
     */
    public Builder clearTtl() {
      if (ttlBuilder_ == null) {
        if (expirationCase_ == 3) {
          expirationCase_ = 0;
          expiration_ = null;
          onChanged();
        }
      } else {
        if (expirationCase_ == 3) {
          expirationCase_ = 0;
          expiration_ = null;
        }
        ttlBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Desired lifetime duration of the access token. This value must
     * be at most 24 hours. If a value is not specified, the token's lifetime
     * will be set to a default value of 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 3;</code>
     */
    public com.google.protobuf.Duration.Builder getTtlBuilder() {
      return getTtlFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Desired lifetime duration of the access token. This value must
     * be at most 24 hours. If a value is not specified, the token's lifetime
     * will be set to a default value of 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 3;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getTtlOrBuilder() {
      if ((expirationCase_ == 3) && (ttlBuilder_ != null)) {
        return ttlBuilder_.getMessageOrBuilder();
      } else {
        if (expirationCase_ == 3) {
          return (com.google.protobuf.Duration) expiration_;
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Desired lifetime duration of the access token. This value must
     * be at most 24 hours. If a value is not specified, the token's lifetime
     * will be set to a default value of 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTtlFieldBuilder() {
      if (ttlBuilder_ == null) {
        if (!(expirationCase_ == 3)) {
          expiration_ = com.google.protobuf.Duration.getDefaultInstance();
        }
        ttlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                (com.google.protobuf.Duration) expiration_, getParentForChildren(), isClean());
        expiration_ = null;
      }
      expirationCase_ = 3;
      onChanged();
      return ttlBuilder_;
    }

    private java.lang.Object workstation_ = "";

    /**
     *
     *
     * <pre>
     * Required. Name of the workstation for which the access token should be
     * generated.
     * </pre>
     *
     * <code>
     * string workstation = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The workstation.
     */
    public java.lang.String getWorkstation() {
      java.lang.Object ref = workstation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        workstation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the workstation for which the access token should be
     * generated.
     * </pre>
     *
     * <code>
     * string workstation = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for workstation.
     */
    public com.google.protobuf.ByteString getWorkstationBytes() {
      java.lang.Object ref = workstation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        workstation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the workstation for which the access token should be
     * generated.
     * </pre>
     *
     * <code>
     * string workstation = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The workstation to set.
     * @return This builder for chaining.
     */
    public Builder setWorkstation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      workstation_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the workstation for which the access token should be
     * generated.
     * </pre>
     *
     * <code>
     * string workstation = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWorkstation() {
      workstation_ = getDefaultInstance().getWorkstation();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the workstation for which the access token should be
     * generated.
     * </pre>
     *
     * <code>
     * string workstation = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for workstation to set.
     * @return This builder for chaining.
     */
    public Builder setWorkstationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      workstation_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.workstations.v1beta.GenerateAccessTokenRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.workstations.v1beta.GenerateAccessTokenRequest)
  private static final com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest();
  }

  public static com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GenerateAccessTokenRequest> PARSER =
      new com.google.protobuf.AbstractParser<GenerateAccessTokenRequest>() {
        @java.lang.Override
        public GenerateAccessTokenRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GenerateAccessTokenRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GenerateAccessTokenRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.workstations.v1beta.GenerateAccessTokenRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
