/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/apps/card/v1/card.proto

// Protobuf Java Version: 3.25.4
package com.google.apps.card.v1;

/**
 *
 *
 * <pre>
 * A field in which users can enter text. Supports suggestions and on-change
 * actions. For an example in Google Chat apps, see [Add a field in which a user
 * can enter
 * text](https://developers.google.com/workspace/chat/design-interactive-card-dialog#add_a_field_in_which_a_user_can_enter_text).
 *
 * Chat apps receive and can process the value of entered text during form input
 * events. For details about working with form inputs, see [Receive form
 * data](https://developers.google.com/workspace/chat/read-form-data).
 *
 * When you need to collect undefined or abstract data from users,
 * use a text input. To collect defined or enumerated data from users, use the
 * [SelectionInput][google.apps.card.v1.SelectionInput] widget.
 *
 * [Google Workspace Add-ons and Chat
 * apps](https://developers.google.com/workspace/extend):
 * </pre>
 *
 * Protobuf type {@code google.apps.card.v1.TextInput}
 */
public final class TextInput extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.apps.card.v1.TextInput)
    TextInputOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TextInput.newBuilder() to construct.
  private TextInput(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TextInput() {
    name_ = "";
    label_ = "";
    hintText_ = "";
    value_ = "";
    type_ = 0;
    placeholderText_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TextInput();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.apps.card.v1.CardProto
        .internal_static_google_apps_card_v1_TextInput_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.apps.card.v1.CardProto
        .internal_static_google_apps_card_v1_TextInput_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.apps.card.v1.TextInput.class,
            com.google.apps.card.v1.TextInput.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * How a text input field appears in the user interface. For example,
   * whether it's a single line input field, or a multi-line input. If
   * `initialSuggestions` is specified, `type` is always `SINGLE_LINE`,
   * even if it's set to `MULTIPLE_LINE`.
   *
   * [Google Workspace Add-ons and Chat
   * apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * Protobuf enum {@code google.apps.card.v1.TextInput.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The text input field has a fixed height of one line.
     * </pre>
     *
     * <code>SINGLE_LINE = 0;</code>
     */
    SINGLE_LINE(0),
    /**
     *
     *
     * <pre>
     * The text input field has a fixed height of multiple lines.
     * </pre>
     *
     * <code>MULTIPLE_LINE = 1;</code>
     */
    MULTIPLE_LINE(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The text input field has a fixed height of one line.
     * </pre>
     *
     * <code>SINGLE_LINE = 0;</code>
     */
    public static final int SINGLE_LINE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The text input field has a fixed height of multiple lines.
     * </pre>
     *
     * <code>MULTIPLE_LINE = 1;</code>
     */
    public static final int MULTIPLE_LINE_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return SINGLE_LINE;
        case 1:
          return MULTIPLE_LINE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.apps.card.v1.TextInput.getDescriptor().getEnumTypes().get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.apps.card.v1.TextInput.Type)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The name by which the text input is identified in a form input event.
   *
   * For details about working with form inputs, see [Receive form
   * data](https://developers.google.com/workspace/chat/read-form-data).
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name by which the text input is identified in a form input event.
   *
   * For details about working with form inputs, see [Receive form
   * data](https://developers.google.com/workspace/chat/read-form-data).
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABEL_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object label_ = "";
  /**
   *
   *
   * <pre>
   * The text that appears above the text input field in the user interface.
   *
   * Specify text that helps the user enter the information your app needs.
   * For example, if you are asking someone's name, but specifically need their
   * surname, write `surname` instead of `name`.
   *
   * Required if `hintText` is unspecified. Otherwise, optional.
   * </pre>
   *
   * <code>string label = 2;</code>
   *
   * @return The label.
   */
  @java.lang.Override
  public java.lang.String getLabel() {
    java.lang.Object ref = label_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      label_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The text that appears above the text input field in the user interface.
   *
   * Specify text that helps the user enter the information your app needs.
   * For example, if you are asking someone's name, but specifically need their
   * surname, write `surname` instead of `name`.
   *
   * Required if `hintText` is unspecified. Otherwise, optional.
   * </pre>
   *
   * <code>string label = 2;</code>
   *
   * @return The bytes for label.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLabelBytes() {
    java.lang.Object ref = label_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      label_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HINT_TEXT_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object hintText_ = "";
  /**
   *
   *
   * <pre>
   * Text that appears below the text input field meant to assist users by
   * prompting them to enter a certain value. This text is always visible.
   *
   * Required if `label` is unspecified. Otherwise, optional.
   * </pre>
   *
   * <code>string hint_text = 3;</code>
   *
   * @return The hintText.
   */
  @java.lang.Override
  public java.lang.String getHintText() {
    java.lang.Object ref = hintText_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      hintText_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Text that appears below the text input field meant to assist users by
   * prompting them to enter a certain value. This text is always visible.
   *
   * Required if `label` is unspecified. Otherwise, optional.
   * </pre>
   *
   * <code>string hint_text = 3;</code>
   *
   * @return The bytes for hintText.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHintTextBytes() {
    java.lang.Object ref = hintText_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      hintText_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALUE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object value_ = "";
  /**
   *
   *
   * <pre>
   * The value entered by a user, returned as part of a form input event.
   *
   * For details about working with form inputs, see [Receive form
   * data](https://developers.google.com/workspace/chat/read-form-data).
   * </pre>
   *
   * <code>string value = 4;</code>
   *
   * @return The value.
   */
  @java.lang.Override
  public java.lang.String getValue() {
    java.lang.Object ref = value_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      value_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The value entered by a user, returned as part of a form input event.
   *
   * For details about working with form inputs, see [Receive form
   * data](https://developers.google.com/workspace/chat/read-form-data).
   * </pre>
   *
   * <code>string value = 4;</code>
   *
   * @return The bytes for value.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getValueBytes() {
    java.lang.Object ref = value_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      value_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 5;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * How a text input field appears in the user interface.
   * For example, whether the field is single or multi-line.
   * </pre>
   *
   * <code>.google.apps.card.v1.TextInput.Type type = 5;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * How a text input field appears in the user interface.
   * For example, whether the field is single or multi-line.
   * </pre>
   *
   * <code>.google.apps.card.v1.TextInput.Type type = 5;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.apps.card.v1.TextInput.Type getType() {
    com.google.apps.card.v1.TextInput.Type result =
        com.google.apps.card.v1.TextInput.Type.forNumber(type_);
    return result == null ? com.google.apps.card.v1.TextInput.Type.UNRECOGNIZED : result;
  }

  public static final int ON_CHANGE_ACTION_FIELD_NUMBER = 6;
  private com.google.apps.card.v1.Action onChangeAction_;
  /**
   *
   *
   * <pre>
   * What to do when a change occurs in the text input field. For example, a
   * user adding to the field or deleting text.
   *
   * Examples of actions to take include running a custom function or opening
   * a [dialog](https://developers.google.com/workspace/chat/dialogs)
   * in Google Chat.
   * </pre>
   *
   * <code>.google.apps.card.v1.Action on_change_action = 6;</code>
   *
   * @return Whether the onChangeAction field is set.
   */
  @java.lang.Override
  public boolean hasOnChangeAction() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * What to do when a change occurs in the text input field. For example, a
   * user adding to the field or deleting text.
   *
   * Examples of actions to take include running a custom function or opening
   * a [dialog](https://developers.google.com/workspace/chat/dialogs)
   * in Google Chat.
   * </pre>
   *
   * <code>.google.apps.card.v1.Action on_change_action = 6;</code>
   *
   * @return The onChangeAction.
   */
  @java.lang.Override
  public com.google.apps.card.v1.Action getOnChangeAction() {
    return onChangeAction_ == null
        ? com.google.apps.card.v1.Action.getDefaultInstance()
        : onChangeAction_;
  }
  /**
   *
   *
   * <pre>
   * What to do when a change occurs in the text input field. For example, a
   * user adding to the field or deleting text.
   *
   * Examples of actions to take include running a custom function or opening
   * a [dialog](https://developers.google.com/workspace/chat/dialogs)
   * in Google Chat.
   * </pre>
   *
   * <code>.google.apps.card.v1.Action on_change_action = 6;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.ActionOrBuilder getOnChangeActionOrBuilder() {
    return onChangeAction_ == null
        ? com.google.apps.card.v1.Action.getDefaultInstance()
        : onChangeAction_;
  }

  public static final int INITIAL_SUGGESTIONS_FIELD_NUMBER = 7;
  private com.google.apps.card.v1.Suggestions initialSuggestions_;
  /**
   *
   *
   * <pre>
   * Suggested values that users can enter. These values appear when users click
   * inside the text input field. As users type, the suggested values
   * dynamically filter to match what the users have typed.
   *
   * For example, a text input field for programming language might suggest
   * Java, JavaScript, Python, and C++. When users start typing `Jav`, the list
   * of suggestions filters to show just `Java` and `JavaScript`.
   *
   * Suggested values help guide users to enter values that your app can make
   * sense of. When referring to JavaScript, some users might enter `javascript`
   * and others `java script`. Suggesting `JavaScript` can standardize how users
   * interact with your app.
   *
   * When specified, `TextInput.type` is always `SINGLE_LINE`, even if it's set
   * to `MULTIPLE_LINE`.
   *
   * [Google Workspace
   * Add-ons and Chat apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * <code>.google.apps.card.v1.Suggestions initial_suggestions = 7;</code>
   *
   * @return Whether the initialSuggestions field is set.
   */
  @java.lang.Override
  public boolean hasInitialSuggestions() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Suggested values that users can enter. These values appear when users click
   * inside the text input field. As users type, the suggested values
   * dynamically filter to match what the users have typed.
   *
   * For example, a text input field for programming language might suggest
   * Java, JavaScript, Python, and C++. When users start typing `Jav`, the list
   * of suggestions filters to show just `Java` and `JavaScript`.
   *
   * Suggested values help guide users to enter values that your app can make
   * sense of. When referring to JavaScript, some users might enter `javascript`
   * and others `java script`. Suggesting `JavaScript` can standardize how users
   * interact with your app.
   *
   * When specified, `TextInput.type` is always `SINGLE_LINE`, even if it's set
   * to `MULTIPLE_LINE`.
   *
   * [Google Workspace
   * Add-ons and Chat apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * <code>.google.apps.card.v1.Suggestions initial_suggestions = 7;</code>
   *
   * @return The initialSuggestions.
   */
  @java.lang.Override
  public com.google.apps.card.v1.Suggestions getInitialSuggestions() {
    return initialSuggestions_ == null
        ? com.google.apps.card.v1.Suggestions.getDefaultInstance()
        : initialSuggestions_;
  }
  /**
   *
   *
   * <pre>
   * Suggested values that users can enter. These values appear when users click
   * inside the text input field. As users type, the suggested values
   * dynamically filter to match what the users have typed.
   *
   * For example, a text input field for programming language might suggest
   * Java, JavaScript, Python, and C++. When users start typing `Jav`, the list
   * of suggestions filters to show just `Java` and `JavaScript`.
   *
   * Suggested values help guide users to enter values that your app can make
   * sense of. When referring to JavaScript, some users might enter `javascript`
   * and others `java script`. Suggesting `JavaScript` can standardize how users
   * interact with your app.
   *
   * When specified, `TextInput.type` is always `SINGLE_LINE`, even if it's set
   * to `MULTIPLE_LINE`.
   *
   * [Google Workspace
   * Add-ons and Chat apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * <code>.google.apps.card.v1.Suggestions initial_suggestions = 7;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.SuggestionsOrBuilder getInitialSuggestionsOrBuilder() {
    return initialSuggestions_ == null
        ? com.google.apps.card.v1.Suggestions.getDefaultInstance()
        : initialSuggestions_;
  }

  public static final int AUTO_COMPLETE_ACTION_FIELD_NUMBER = 8;
  private com.google.apps.card.v1.Action autoCompleteAction_;
  /**
   *
   *
   * <pre>
   * Optional. Specify what action to take when the text input field provides
   * suggestions to users who interact with it.
   *
   * If unspecified, the suggestions are set by `initialSuggestions` and
   * are processed by the client.
   *
   * If specified, the app takes the action specified here, such as running
   * a custom function.
   *
   * [Google Workspace
   * Add-ons](https://developers.google.com/workspace/add-ons):
   * </pre>
   *
   * <code>.google.apps.card.v1.Action auto_complete_action = 8;</code>
   *
   * @return Whether the autoCompleteAction field is set.
   */
  @java.lang.Override
  public boolean hasAutoCompleteAction() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Specify what action to take when the text input field provides
   * suggestions to users who interact with it.
   *
   * If unspecified, the suggestions are set by `initialSuggestions` and
   * are processed by the client.
   *
   * If specified, the app takes the action specified here, such as running
   * a custom function.
   *
   * [Google Workspace
   * Add-ons](https://developers.google.com/workspace/add-ons):
   * </pre>
   *
   * <code>.google.apps.card.v1.Action auto_complete_action = 8;</code>
   *
   * @return The autoCompleteAction.
   */
  @java.lang.Override
  public com.google.apps.card.v1.Action getAutoCompleteAction() {
    return autoCompleteAction_ == null
        ? com.google.apps.card.v1.Action.getDefaultInstance()
        : autoCompleteAction_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Specify what action to take when the text input field provides
   * suggestions to users who interact with it.
   *
   * If unspecified, the suggestions are set by `initialSuggestions` and
   * are processed by the client.
   *
   * If specified, the app takes the action specified here, such as running
   * a custom function.
   *
   * [Google Workspace
   * Add-ons](https://developers.google.com/workspace/add-ons):
   * </pre>
   *
   * <code>.google.apps.card.v1.Action auto_complete_action = 8;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.ActionOrBuilder getAutoCompleteActionOrBuilder() {
    return autoCompleteAction_ == null
        ? com.google.apps.card.v1.Action.getDefaultInstance()
        : autoCompleteAction_;
  }

  public static final int PLACEHOLDER_TEXT_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object placeholderText_ = "";
  /**
   *
   *
   * <pre>
   * Text that appears in the text input field when the field is empty.
   * Use this text to prompt users to enter a value. For example, `Enter a
   * number from 0 to 100`.
   *
   * [Google Chat apps](https://developers.google.com/workspace/chat):
   * </pre>
   *
   * <code>string placeholder_text = 12;</code>
   *
   * @return The placeholderText.
   */
  @java.lang.Override
  public java.lang.String getPlaceholderText() {
    java.lang.Object ref = placeholderText_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      placeholderText_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Text that appears in the text input field when the field is empty.
   * Use this text to prompt users to enter a value. For example, `Enter a
   * number from 0 to 100`.
   *
   * [Google Chat apps](https://developers.google.com/workspace/chat):
   * </pre>
   *
   * <code>string placeholder_text = 12;</code>
   *
   * @return The bytes for placeholderText.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPlaceholderTextBytes() {
    java.lang.Object ref = placeholderText_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      placeholderText_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(label_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, label_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hintText_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, hintText_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, value_);
    }
    if (type_ != com.google.apps.card.v1.TextInput.Type.SINGLE_LINE.getNumber()) {
      output.writeEnum(5, type_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getOnChangeAction());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getInitialSuggestions());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(8, getAutoCompleteAction());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(placeholderText_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, placeholderText_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(label_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, label_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hintText_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, hintText_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, value_);
    }
    if (type_ != com.google.apps.card.v1.TextInput.Type.SINGLE_LINE.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, type_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getOnChangeAction());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getInitialSuggestions());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getAutoCompleteAction());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(placeholderText_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, placeholderText_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.apps.card.v1.TextInput)) {
      return super.equals(obj);
    }
    com.google.apps.card.v1.TextInput other = (com.google.apps.card.v1.TextInput) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getLabel().equals(other.getLabel())) return false;
    if (!getHintText().equals(other.getHintText())) return false;
    if (!getValue().equals(other.getValue())) return false;
    if (type_ != other.type_) return false;
    if (hasOnChangeAction() != other.hasOnChangeAction()) return false;
    if (hasOnChangeAction()) {
      if (!getOnChangeAction().equals(other.getOnChangeAction())) return false;
    }
    if (hasInitialSuggestions() != other.hasInitialSuggestions()) return false;
    if (hasInitialSuggestions()) {
      if (!getInitialSuggestions().equals(other.getInitialSuggestions())) return false;
    }
    if (hasAutoCompleteAction() != other.hasAutoCompleteAction()) return false;
    if (hasAutoCompleteAction()) {
      if (!getAutoCompleteAction().equals(other.getAutoCompleteAction())) return false;
    }
    if (!getPlaceholderText().equals(other.getPlaceholderText())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + LABEL_FIELD_NUMBER;
    hash = (53 * hash) + getLabel().hashCode();
    hash = (37 * hash) + HINT_TEXT_FIELD_NUMBER;
    hash = (53 * hash) + getHintText().hashCode();
    hash = (37 * hash) + VALUE_FIELD_NUMBER;
    hash = (53 * hash) + getValue().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    if (hasOnChangeAction()) {
      hash = (37 * hash) + ON_CHANGE_ACTION_FIELD_NUMBER;
      hash = (53 * hash) + getOnChangeAction().hashCode();
    }
    if (hasInitialSuggestions()) {
      hash = (37 * hash) + INITIAL_SUGGESTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getInitialSuggestions().hashCode();
    }
    if (hasAutoCompleteAction()) {
      hash = (37 * hash) + AUTO_COMPLETE_ACTION_FIELD_NUMBER;
      hash = (53 * hash) + getAutoCompleteAction().hashCode();
    }
    hash = (37 * hash) + PLACEHOLDER_TEXT_FIELD_NUMBER;
    hash = (53 * hash) + getPlaceholderText().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.apps.card.v1.TextInput parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.TextInput parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.TextInput parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.TextInput parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.TextInput parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.TextInput parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.TextInput parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.TextInput parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.card.v1.TextInput parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.TextInput parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.card.v1.TextInput parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.TextInput parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.apps.card.v1.TextInput prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A field in which users can enter text. Supports suggestions and on-change
   * actions. For an example in Google Chat apps, see [Add a field in which a user
   * can enter
   * text](https://developers.google.com/workspace/chat/design-interactive-card-dialog#add_a_field_in_which_a_user_can_enter_text).
   *
   * Chat apps receive and can process the value of entered text during form input
   * events. For details about working with form inputs, see [Receive form
   * data](https://developers.google.com/workspace/chat/read-form-data).
   *
   * When you need to collect undefined or abstract data from users,
   * use a text input. To collect defined or enumerated data from users, use the
   * [SelectionInput][google.apps.card.v1.SelectionInput] widget.
   *
   * [Google Workspace Add-ons and Chat
   * apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * Protobuf type {@code google.apps.card.v1.TextInput}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.apps.card.v1.TextInput)
      com.google.apps.card.v1.TextInputOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_TextInput_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_TextInput_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.apps.card.v1.TextInput.class,
              com.google.apps.card.v1.TextInput.Builder.class);
    }

    // Construct using com.google.apps.card.v1.TextInput.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getOnChangeActionFieldBuilder();
        getInitialSuggestionsFieldBuilder();
        getAutoCompleteActionFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      label_ = "";
      hintText_ = "";
      value_ = "";
      type_ = 0;
      onChangeAction_ = null;
      if (onChangeActionBuilder_ != null) {
        onChangeActionBuilder_.dispose();
        onChangeActionBuilder_ = null;
      }
      initialSuggestions_ = null;
      if (initialSuggestionsBuilder_ != null) {
        initialSuggestionsBuilder_.dispose();
        initialSuggestionsBuilder_ = null;
      }
      autoCompleteAction_ = null;
      if (autoCompleteActionBuilder_ != null) {
        autoCompleteActionBuilder_.dispose();
        autoCompleteActionBuilder_ = null;
      }
      placeholderText_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_TextInput_descriptor;
    }

    @java.lang.Override
    public com.google.apps.card.v1.TextInput getDefaultInstanceForType() {
      return com.google.apps.card.v1.TextInput.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.apps.card.v1.TextInput build() {
      com.google.apps.card.v1.TextInput result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.apps.card.v1.TextInput buildPartial() {
      com.google.apps.card.v1.TextInput result = new com.google.apps.card.v1.TextInput(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.apps.card.v1.TextInput result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.label_ = label_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.hintText_ = hintText_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.value_ = value_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.type_ = type_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.onChangeAction_ =
            onChangeActionBuilder_ == null ? onChangeAction_ : onChangeActionBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.initialSuggestions_ =
            initialSuggestionsBuilder_ == null
                ? initialSuggestions_
                : initialSuggestionsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.autoCompleteAction_ =
            autoCompleteActionBuilder_ == null
                ? autoCompleteAction_
                : autoCompleteActionBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.placeholderText_ = placeholderText_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.apps.card.v1.TextInput) {
        return mergeFrom((com.google.apps.card.v1.TextInput) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.apps.card.v1.TextInput other) {
      if (other == com.google.apps.card.v1.TextInput.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getLabel().isEmpty()) {
        label_ = other.label_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getHintText().isEmpty()) {
        hintText_ = other.hintText_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getValue().isEmpty()) {
        value_ = other.value_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.hasOnChangeAction()) {
        mergeOnChangeAction(other.getOnChangeAction());
      }
      if (other.hasInitialSuggestions()) {
        mergeInitialSuggestions(other.getInitialSuggestions());
      }
      if (other.hasAutoCompleteAction()) {
        mergeAutoCompleteAction(other.getAutoCompleteAction());
      }
      if (!other.getPlaceholderText().isEmpty()) {
        placeholderText_ = other.placeholderText_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                label_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                hintText_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                value_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(getOnChangeActionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getInitialSuggestionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getAutoCompleteActionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 98:
              {
                placeholderText_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 98
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name by which the text input is identified in a form input event.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name by which the text input is identified in a form input event.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name by which the text input is identified in a form input event.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name by which the text input is identified in a form input event.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name by which the text input is identified in a form input event.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object label_ = "";
    /**
     *
     *
     * <pre>
     * The text that appears above the text input field in the user interface.
     *
     * Specify text that helps the user enter the information your app needs.
     * For example, if you are asking someone's name, but specifically need their
     * surname, write `surname` instead of `name`.
     *
     * Required if `hintText` is unspecified. Otherwise, optional.
     * </pre>
     *
     * <code>string label = 2;</code>
     *
     * @return The label.
     */
    public java.lang.String getLabel() {
      java.lang.Object ref = label_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        label_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The text that appears above the text input field in the user interface.
     *
     * Specify text that helps the user enter the information your app needs.
     * For example, if you are asking someone's name, but specifically need their
     * surname, write `surname` instead of `name`.
     *
     * Required if `hintText` is unspecified. Otherwise, optional.
     * </pre>
     *
     * <code>string label = 2;</code>
     *
     * @return The bytes for label.
     */
    public com.google.protobuf.ByteString getLabelBytes() {
      java.lang.Object ref = label_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        label_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The text that appears above the text input field in the user interface.
     *
     * Specify text that helps the user enter the information your app needs.
     * For example, if you are asking someone's name, but specifically need their
     * surname, write `surname` instead of `name`.
     *
     * Required if `hintText` is unspecified. Otherwise, optional.
     * </pre>
     *
     * <code>string label = 2;</code>
     *
     * @param value The label to set.
     * @return This builder for chaining.
     */
    public Builder setLabel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      label_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The text that appears above the text input field in the user interface.
     *
     * Specify text that helps the user enter the information your app needs.
     * For example, if you are asking someone's name, but specifically need their
     * surname, write `surname` instead of `name`.
     *
     * Required if `hintText` is unspecified. Otherwise, optional.
     * </pre>
     *
     * <code>string label = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLabel() {
      label_ = getDefaultInstance().getLabel();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The text that appears above the text input field in the user interface.
     *
     * Specify text that helps the user enter the information your app needs.
     * For example, if you are asking someone's name, but specifically need their
     * surname, write `surname` instead of `name`.
     *
     * Required if `hintText` is unspecified. Otherwise, optional.
     * </pre>
     *
     * <code>string label = 2;</code>
     *
     * @param value The bytes for label to set.
     * @return This builder for chaining.
     */
    public Builder setLabelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      label_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object hintText_ = "";
    /**
     *
     *
     * <pre>
     * Text that appears below the text input field meant to assist users by
     * prompting them to enter a certain value. This text is always visible.
     *
     * Required if `label` is unspecified. Otherwise, optional.
     * </pre>
     *
     * <code>string hint_text = 3;</code>
     *
     * @return The hintText.
     */
    public java.lang.String getHintText() {
      java.lang.Object ref = hintText_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        hintText_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Text that appears below the text input field meant to assist users by
     * prompting them to enter a certain value. This text is always visible.
     *
     * Required if `label` is unspecified. Otherwise, optional.
     * </pre>
     *
     * <code>string hint_text = 3;</code>
     *
     * @return The bytes for hintText.
     */
    public com.google.protobuf.ByteString getHintTextBytes() {
      java.lang.Object ref = hintText_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        hintText_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Text that appears below the text input field meant to assist users by
     * prompting them to enter a certain value. This text is always visible.
     *
     * Required if `label` is unspecified. Otherwise, optional.
     * </pre>
     *
     * <code>string hint_text = 3;</code>
     *
     * @param value The hintText to set.
     * @return This builder for chaining.
     */
    public Builder setHintText(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      hintText_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text that appears below the text input field meant to assist users by
     * prompting them to enter a certain value. This text is always visible.
     *
     * Required if `label` is unspecified. Otherwise, optional.
     * </pre>
     *
     * <code>string hint_text = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHintText() {
      hintText_ = getDefaultInstance().getHintText();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text that appears below the text input field meant to assist users by
     * prompting them to enter a certain value. This text is always visible.
     *
     * Required if `label` is unspecified. Otherwise, optional.
     * </pre>
     *
     * <code>string hint_text = 3;</code>
     *
     * @param value The bytes for hintText to set.
     * @return This builder for chaining.
     */
    public Builder setHintTextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      hintText_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object value_ = "";
    /**
     *
     *
     * <pre>
     * The value entered by a user, returned as part of a form input event.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>string value = 4;</code>
     *
     * @return The value.
     */
    public java.lang.String getValue() {
      java.lang.Object ref = value_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        value_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The value entered by a user, returned as part of a form input event.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>string value = 4;</code>
     *
     * @return The bytes for value.
     */
    public com.google.protobuf.ByteString getValueBytes() {
      java.lang.Object ref = value_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        value_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The value entered by a user, returned as part of a form input event.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>string value = 4;</code>
     *
     * @param value The value to set.
     * @return This builder for chaining.
     */
    public Builder setValue(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      value_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The value entered by a user, returned as part of a form input event.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>string value = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValue() {
      value_ = getDefaultInstance().getValue();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The value entered by a user, returned as part of a form input event.
     *
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>string value = 4;</code>
     *
     * @param value The bytes for value to set.
     * @return This builder for chaining.
     */
    public Builder setValueBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      value_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * How a text input field appears in the user interface.
     * For example, whether the field is single or multi-line.
     * </pre>
     *
     * <code>.google.apps.card.v1.TextInput.Type type = 5;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * How a text input field appears in the user interface.
     * For example, whether the field is single or multi-line.
     * </pre>
     *
     * <code>.google.apps.card.v1.TextInput.Type type = 5;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * How a text input field appears in the user interface.
     * For example, whether the field is single or multi-line.
     * </pre>
     *
     * <code>.google.apps.card.v1.TextInput.Type type = 5;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.apps.card.v1.TextInput.Type getType() {
      com.google.apps.card.v1.TextInput.Type result =
          com.google.apps.card.v1.TextInput.Type.forNumber(type_);
      return result == null ? com.google.apps.card.v1.TextInput.Type.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * How a text input field appears in the user interface.
     * For example, whether the field is single or multi-line.
     * </pre>
     *
     * <code>.google.apps.card.v1.TextInput.Type type = 5;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.apps.card.v1.TextInput.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * How a text input field appears in the user interface.
     * For example, whether the field is single or multi-line.
     * </pre>
     *
     * <code>.google.apps.card.v1.TextInput.Type type = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000010);
      type_ = 0;
      onChanged();
      return this;
    }

    private com.google.apps.card.v1.Action onChangeAction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.Action,
            com.google.apps.card.v1.Action.Builder,
            com.google.apps.card.v1.ActionOrBuilder>
        onChangeActionBuilder_;
    /**
     *
     *
     * <pre>
     * What to do when a change occurs in the text input field. For example, a
     * user adding to the field or deleting text.
     *
     * Examples of actions to take include running a custom function or opening
     * a [dialog](https://developers.google.com/workspace/chat/dialogs)
     * in Google Chat.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action on_change_action = 6;</code>
     *
     * @return Whether the onChangeAction field is set.
     */
    public boolean hasOnChangeAction() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * What to do when a change occurs in the text input field. For example, a
     * user adding to the field or deleting text.
     *
     * Examples of actions to take include running a custom function or opening
     * a [dialog](https://developers.google.com/workspace/chat/dialogs)
     * in Google Chat.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action on_change_action = 6;</code>
     *
     * @return The onChangeAction.
     */
    public com.google.apps.card.v1.Action getOnChangeAction() {
      if (onChangeActionBuilder_ == null) {
        return onChangeAction_ == null
            ? com.google.apps.card.v1.Action.getDefaultInstance()
            : onChangeAction_;
      } else {
        return onChangeActionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * What to do when a change occurs in the text input field. For example, a
     * user adding to the field or deleting text.
     *
     * Examples of actions to take include running a custom function or opening
     * a [dialog](https://developers.google.com/workspace/chat/dialogs)
     * in Google Chat.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action on_change_action = 6;</code>
     */
    public Builder setOnChangeAction(com.google.apps.card.v1.Action value) {
      if (onChangeActionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        onChangeAction_ = value;
      } else {
        onChangeActionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * What to do when a change occurs in the text input field. For example, a
     * user adding to the field or deleting text.
     *
     * Examples of actions to take include running a custom function or opening
     * a [dialog](https://developers.google.com/workspace/chat/dialogs)
     * in Google Chat.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action on_change_action = 6;</code>
     */
    public Builder setOnChangeAction(com.google.apps.card.v1.Action.Builder builderForValue) {
      if (onChangeActionBuilder_ == null) {
        onChangeAction_ = builderForValue.build();
      } else {
        onChangeActionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * What to do when a change occurs in the text input field. For example, a
     * user adding to the field or deleting text.
     *
     * Examples of actions to take include running a custom function or opening
     * a [dialog](https://developers.google.com/workspace/chat/dialogs)
     * in Google Chat.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action on_change_action = 6;</code>
     */
    public Builder mergeOnChangeAction(com.google.apps.card.v1.Action value) {
      if (onChangeActionBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && onChangeAction_ != null
            && onChangeAction_ != com.google.apps.card.v1.Action.getDefaultInstance()) {
          getOnChangeActionBuilder().mergeFrom(value);
        } else {
          onChangeAction_ = value;
        }
      } else {
        onChangeActionBuilder_.mergeFrom(value);
      }
      if (onChangeAction_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * What to do when a change occurs in the text input field. For example, a
     * user adding to the field or deleting text.
     *
     * Examples of actions to take include running a custom function or opening
     * a [dialog](https://developers.google.com/workspace/chat/dialogs)
     * in Google Chat.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action on_change_action = 6;</code>
     */
    public Builder clearOnChangeAction() {
      bitField0_ = (bitField0_ & ~0x00000020);
      onChangeAction_ = null;
      if (onChangeActionBuilder_ != null) {
        onChangeActionBuilder_.dispose();
        onChangeActionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * What to do when a change occurs in the text input field. For example, a
     * user adding to the field or deleting text.
     *
     * Examples of actions to take include running a custom function or opening
     * a [dialog](https://developers.google.com/workspace/chat/dialogs)
     * in Google Chat.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action on_change_action = 6;</code>
     */
    public com.google.apps.card.v1.Action.Builder getOnChangeActionBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getOnChangeActionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * What to do when a change occurs in the text input field. For example, a
     * user adding to the field or deleting text.
     *
     * Examples of actions to take include running a custom function or opening
     * a [dialog](https://developers.google.com/workspace/chat/dialogs)
     * in Google Chat.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action on_change_action = 6;</code>
     */
    public com.google.apps.card.v1.ActionOrBuilder getOnChangeActionOrBuilder() {
      if (onChangeActionBuilder_ != null) {
        return onChangeActionBuilder_.getMessageOrBuilder();
      } else {
        return onChangeAction_ == null
            ? com.google.apps.card.v1.Action.getDefaultInstance()
            : onChangeAction_;
      }
    }
    /**
     *
     *
     * <pre>
     * What to do when a change occurs in the text input field. For example, a
     * user adding to the field or deleting text.
     *
     * Examples of actions to take include running a custom function or opening
     * a [dialog](https://developers.google.com/workspace/chat/dialogs)
     * in Google Chat.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action on_change_action = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.Action,
            com.google.apps.card.v1.Action.Builder,
            com.google.apps.card.v1.ActionOrBuilder>
        getOnChangeActionFieldBuilder() {
      if (onChangeActionBuilder_ == null) {
        onChangeActionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.card.v1.Action,
                com.google.apps.card.v1.Action.Builder,
                com.google.apps.card.v1.ActionOrBuilder>(
                getOnChangeAction(), getParentForChildren(), isClean());
        onChangeAction_ = null;
      }
      return onChangeActionBuilder_;
    }

    private com.google.apps.card.v1.Suggestions initialSuggestions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.Suggestions,
            com.google.apps.card.v1.Suggestions.Builder,
            com.google.apps.card.v1.SuggestionsOrBuilder>
        initialSuggestionsBuilder_;
    /**
     *
     *
     * <pre>
     * Suggested values that users can enter. These values appear when users click
     * inside the text input field. As users type, the suggested values
     * dynamically filter to match what the users have typed.
     *
     * For example, a text input field for programming language might suggest
     * Java, JavaScript, Python, and C++. When users start typing `Jav`, the list
     * of suggestions filters to show just `Java` and `JavaScript`.
     *
     * Suggested values help guide users to enter values that your app can make
     * sense of. When referring to JavaScript, some users might enter `javascript`
     * and others `java script`. Suggesting `JavaScript` can standardize how users
     * interact with your app.
     *
     * When specified, `TextInput.type` is always `SINGLE_LINE`, even if it's set
     * to `MULTIPLE_LINE`.
     *
     * [Google Workspace
     * Add-ons and Chat apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * <code>.google.apps.card.v1.Suggestions initial_suggestions = 7;</code>
     *
     * @return Whether the initialSuggestions field is set.
     */
    public boolean hasInitialSuggestions() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Suggested values that users can enter. These values appear when users click
     * inside the text input field. As users type, the suggested values
     * dynamically filter to match what the users have typed.
     *
     * For example, a text input field for programming language might suggest
     * Java, JavaScript, Python, and C++. When users start typing `Jav`, the list
     * of suggestions filters to show just `Java` and `JavaScript`.
     *
     * Suggested values help guide users to enter values that your app can make
     * sense of. When referring to JavaScript, some users might enter `javascript`
     * and others `java script`. Suggesting `JavaScript` can standardize how users
     * interact with your app.
     *
     * When specified, `TextInput.type` is always `SINGLE_LINE`, even if it's set
     * to `MULTIPLE_LINE`.
     *
     * [Google Workspace
     * Add-ons and Chat apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * <code>.google.apps.card.v1.Suggestions initial_suggestions = 7;</code>
     *
     * @return The initialSuggestions.
     */
    public com.google.apps.card.v1.Suggestions getInitialSuggestions() {
      if (initialSuggestionsBuilder_ == null) {
        return initialSuggestions_ == null
            ? com.google.apps.card.v1.Suggestions.getDefaultInstance()
            : initialSuggestions_;
      } else {
        return initialSuggestionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Suggested values that users can enter. These values appear when users click
     * inside the text input field. As users type, the suggested values
     * dynamically filter to match what the users have typed.
     *
     * For example, a text input field for programming language might suggest
     * Java, JavaScript, Python, and C++. When users start typing `Jav`, the list
     * of suggestions filters to show just `Java` and `JavaScript`.
     *
     * Suggested values help guide users to enter values that your app can make
     * sense of. When referring to JavaScript, some users might enter `javascript`
     * and others `java script`. Suggesting `JavaScript` can standardize how users
     * interact with your app.
     *
     * When specified, `TextInput.type` is always `SINGLE_LINE`, even if it's set
     * to `MULTIPLE_LINE`.
     *
     * [Google Workspace
     * Add-ons and Chat apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * <code>.google.apps.card.v1.Suggestions initial_suggestions = 7;</code>
     */
    public Builder setInitialSuggestions(com.google.apps.card.v1.Suggestions value) {
      if (initialSuggestionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        initialSuggestions_ = value;
      } else {
        initialSuggestionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Suggested values that users can enter. These values appear when users click
     * inside the text input field. As users type, the suggested values
     * dynamically filter to match what the users have typed.
     *
     * For example, a text input field for programming language might suggest
     * Java, JavaScript, Python, and C++. When users start typing `Jav`, the list
     * of suggestions filters to show just `Java` and `JavaScript`.
     *
     * Suggested values help guide users to enter values that your app can make
     * sense of. When referring to JavaScript, some users might enter `javascript`
     * and others `java script`. Suggesting `JavaScript` can standardize how users
     * interact with your app.
     *
     * When specified, `TextInput.type` is always `SINGLE_LINE`, even if it's set
     * to `MULTIPLE_LINE`.
     *
     * [Google Workspace
     * Add-ons and Chat apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * <code>.google.apps.card.v1.Suggestions initial_suggestions = 7;</code>
     */
    public Builder setInitialSuggestions(
        com.google.apps.card.v1.Suggestions.Builder builderForValue) {
      if (initialSuggestionsBuilder_ == null) {
        initialSuggestions_ = builderForValue.build();
      } else {
        initialSuggestionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Suggested values that users can enter. These values appear when users click
     * inside the text input field. As users type, the suggested values
     * dynamically filter to match what the users have typed.
     *
     * For example, a text input field for programming language might suggest
     * Java, JavaScript, Python, and C++. When users start typing `Jav`, the list
     * of suggestions filters to show just `Java` and `JavaScript`.
     *
     * Suggested values help guide users to enter values that your app can make
     * sense of. When referring to JavaScript, some users might enter `javascript`
     * and others `java script`. Suggesting `JavaScript` can standardize how users
     * interact with your app.
     *
     * When specified, `TextInput.type` is always `SINGLE_LINE`, even if it's set
     * to `MULTIPLE_LINE`.
     *
     * [Google Workspace
     * Add-ons and Chat apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * <code>.google.apps.card.v1.Suggestions initial_suggestions = 7;</code>
     */
    public Builder mergeInitialSuggestions(com.google.apps.card.v1.Suggestions value) {
      if (initialSuggestionsBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && initialSuggestions_ != null
            && initialSuggestions_ != com.google.apps.card.v1.Suggestions.getDefaultInstance()) {
          getInitialSuggestionsBuilder().mergeFrom(value);
        } else {
          initialSuggestions_ = value;
        }
      } else {
        initialSuggestionsBuilder_.mergeFrom(value);
      }
      if (initialSuggestions_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Suggested values that users can enter. These values appear when users click
     * inside the text input field. As users type, the suggested values
     * dynamically filter to match what the users have typed.
     *
     * For example, a text input field for programming language might suggest
     * Java, JavaScript, Python, and C++. When users start typing `Jav`, the list
     * of suggestions filters to show just `Java` and `JavaScript`.
     *
     * Suggested values help guide users to enter values that your app can make
     * sense of. When referring to JavaScript, some users might enter `javascript`
     * and others `java script`. Suggesting `JavaScript` can standardize how users
     * interact with your app.
     *
     * When specified, `TextInput.type` is always `SINGLE_LINE`, even if it's set
     * to `MULTIPLE_LINE`.
     *
     * [Google Workspace
     * Add-ons and Chat apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * <code>.google.apps.card.v1.Suggestions initial_suggestions = 7;</code>
     */
    public Builder clearInitialSuggestions() {
      bitField0_ = (bitField0_ & ~0x00000040);
      initialSuggestions_ = null;
      if (initialSuggestionsBuilder_ != null) {
        initialSuggestionsBuilder_.dispose();
        initialSuggestionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Suggested values that users can enter. These values appear when users click
     * inside the text input field. As users type, the suggested values
     * dynamically filter to match what the users have typed.
     *
     * For example, a text input field for programming language might suggest
     * Java, JavaScript, Python, and C++. When users start typing `Jav`, the list
     * of suggestions filters to show just `Java` and `JavaScript`.
     *
     * Suggested values help guide users to enter values that your app can make
     * sense of. When referring to JavaScript, some users might enter `javascript`
     * and others `java script`. Suggesting `JavaScript` can standardize how users
     * interact with your app.
     *
     * When specified, `TextInput.type` is always `SINGLE_LINE`, even if it's set
     * to `MULTIPLE_LINE`.
     *
     * [Google Workspace
     * Add-ons and Chat apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * <code>.google.apps.card.v1.Suggestions initial_suggestions = 7;</code>
     */
    public com.google.apps.card.v1.Suggestions.Builder getInitialSuggestionsBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getInitialSuggestionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Suggested values that users can enter. These values appear when users click
     * inside the text input field. As users type, the suggested values
     * dynamically filter to match what the users have typed.
     *
     * For example, a text input field for programming language might suggest
     * Java, JavaScript, Python, and C++. When users start typing `Jav`, the list
     * of suggestions filters to show just `Java` and `JavaScript`.
     *
     * Suggested values help guide users to enter values that your app can make
     * sense of. When referring to JavaScript, some users might enter `javascript`
     * and others `java script`. Suggesting `JavaScript` can standardize how users
     * interact with your app.
     *
     * When specified, `TextInput.type` is always `SINGLE_LINE`, even if it's set
     * to `MULTIPLE_LINE`.
     *
     * [Google Workspace
     * Add-ons and Chat apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * <code>.google.apps.card.v1.Suggestions initial_suggestions = 7;</code>
     */
    public com.google.apps.card.v1.SuggestionsOrBuilder getInitialSuggestionsOrBuilder() {
      if (initialSuggestionsBuilder_ != null) {
        return initialSuggestionsBuilder_.getMessageOrBuilder();
      } else {
        return initialSuggestions_ == null
            ? com.google.apps.card.v1.Suggestions.getDefaultInstance()
            : initialSuggestions_;
      }
    }
    /**
     *
     *
     * <pre>
     * Suggested values that users can enter. These values appear when users click
     * inside the text input field. As users type, the suggested values
     * dynamically filter to match what the users have typed.
     *
     * For example, a text input field for programming language might suggest
     * Java, JavaScript, Python, and C++. When users start typing `Jav`, the list
     * of suggestions filters to show just `Java` and `JavaScript`.
     *
     * Suggested values help guide users to enter values that your app can make
     * sense of. When referring to JavaScript, some users might enter `javascript`
     * and others `java script`. Suggesting `JavaScript` can standardize how users
     * interact with your app.
     *
     * When specified, `TextInput.type` is always `SINGLE_LINE`, even if it's set
     * to `MULTIPLE_LINE`.
     *
     * [Google Workspace
     * Add-ons and Chat apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * <code>.google.apps.card.v1.Suggestions initial_suggestions = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.Suggestions,
            com.google.apps.card.v1.Suggestions.Builder,
            com.google.apps.card.v1.SuggestionsOrBuilder>
        getInitialSuggestionsFieldBuilder() {
      if (initialSuggestionsBuilder_ == null) {
        initialSuggestionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.card.v1.Suggestions,
                com.google.apps.card.v1.Suggestions.Builder,
                com.google.apps.card.v1.SuggestionsOrBuilder>(
                getInitialSuggestions(), getParentForChildren(), isClean());
        initialSuggestions_ = null;
      }
      return initialSuggestionsBuilder_;
    }

    private com.google.apps.card.v1.Action autoCompleteAction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.Action,
            com.google.apps.card.v1.Action.Builder,
            com.google.apps.card.v1.ActionOrBuilder>
        autoCompleteActionBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Specify what action to take when the text input field provides
     * suggestions to users who interact with it.
     *
     * If unspecified, the suggestions are set by `initialSuggestions` and
     * are processed by the client.
     *
     * If specified, the app takes the action specified here, such as running
     * a custom function.
     *
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Action auto_complete_action = 8;</code>
     *
     * @return Whether the autoCompleteAction field is set.
     */
    public boolean hasAutoCompleteAction() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Specify what action to take when the text input field provides
     * suggestions to users who interact with it.
     *
     * If unspecified, the suggestions are set by `initialSuggestions` and
     * are processed by the client.
     *
     * If specified, the app takes the action specified here, such as running
     * a custom function.
     *
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Action auto_complete_action = 8;</code>
     *
     * @return The autoCompleteAction.
     */
    public com.google.apps.card.v1.Action getAutoCompleteAction() {
      if (autoCompleteActionBuilder_ == null) {
        return autoCompleteAction_ == null
            ? com.google.apps.card.v1.Action.getDefaultInstance()
            : autoCompleteAction_;
      } else {
        return autoCompleteActionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specify what action to take when the text input field provides
     * suggestions to users who interact with it.
     *
     * If unspecified, the suggestions are set by `initialSuggestions` and
     * are processed by the client.
     *
     * If specified, the app takes the action specified here, such as running
     * a custom function.
     *
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Action auto_complete_action = 8;</code>
     */
    public Builder setAutoCompleteAction(com.google.apps.card.v1.Action value) {
      if (autoCompleteActionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        autoCompleteAction_ = value;
      } else {
        autoCompleteActionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specify what action to take when the text input field provides
     * suggestions to users who interact with it.
     *
     * If unspecified, the suggestions are set by `initialSuggestions` and
     * are processed by the client.
     *
     * If specified, the app takes the action specified here, such as running
     * a custom function.
     *
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Action auto_complete_action = 8;</code>
     */
    public Builder setAutoCompleteAction(com.google.apps.card.v1.Action.Builder builderForValue) {
      if (autoCompleteActionBuilder_ == null) {
        autoCompleteAction_ = builderForValue.build();
      } else {
        autoCompleteActionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specify what action to take when the text input field provides
     * suggestions to users who interact with it.
     *
     * If unspecified, the suggestions are set by `initialSuggestions` and
     * are processed by the client.
     *
     * If specified, the app takes the action specified here, such as running
     * a custom function.
     *
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Action auto_complete_action = 8;</code>
     */
    public Builder mergeAutoCompleteAction(com.google.apps.card.v1.Action value) {
      if (autoCompleteActionBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && autoCompleteAction_ != null
            && autoCompleteAction_ != com.google.apps.card.v1.Action.getDefaultInstance()) {
          getAutoCompleteActionBuilder().mergeFrom(value);
        } else {
          autoCompleteAction_ = value;
        }
      } else {
        autoCompleteActionBuilder_.mergeFrom(value);
      }
      if (autoCompleteAction_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specify what action to take when the text input field provides
     * suggestions to users who interact with it.
     *
     * If unspecified, the suggestions are set by `initialSuggestions` and
     * are processed by the client.
     *
     * If specified, the app takes the action specified here, such as running
     * a custom function.
     *
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Action auto_complete_action = 8;</code>
     */
    public Builder clearAutoCompleteAction() {
      bitField0_ = (bitField0_ & ~0x00000080);
      autoCompleteAction_ = null;
      if (autoCompleteActionBuilder_ != null) {
        autoCompleteActionBuilder_.dispose();
        autoCompleteActionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specify what action to take when the text input field provides
     * suggestions to users who interact with it.
     *
     * If unspecified, the suggestions are set by `initialSuggestions` and
     * are processed by the client.
     *
     * If specified, the app takes the action specified here, such as running
     * a custom function.
     *
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Action auto_complete_action = 8;</code>
     */
    public com.google.apps.card.v1.Action.Builder getAutoCompleteActionBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getAutoCompleteActionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Specify what action to take when the text input field provides
     * suggestions to users who interact with it.
     *
     * If unspecified, the suggestions are set by `initialSuggestions` and
     * are processed by the client.
     *
     * If specified, the app takes the action specified here, such as running
     * a custom function.
     *
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Action auto_complete_action = 8;</code>
     */
    public com.google.apps.card.v1.ActionOrBuilder getAutoCompleteActionOrBuilder() {
      if (autoCompleteActionBuilder_ != null) {
        return autoCompleteActionBuilder_.getMessageOrBuilder();
      } else {
        return autoCompleteAction_ == null
            ? com.google.apps.card.v1.Action.getDefaultInstance()
            : autoCompleteAction_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specify what action to take when the text input field provides
     * suggestions to users who interact with it.
     *
     * If unspecified, the suggestions are set by `initialSuggestions` and
     * are processed by the client.
     *
     * If specified, the app takes the action specified here, such as running
     * a custom function.
     *
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Action auto_complete_action = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.Action,
            com.google.apps.card.v1.Action.Builder,
            com.google.apps.card.v1.ActionOrBuilder>
        getAutoCompleteActionFieldBuilder() {
      if (autoCompleteActionBuilder_ == null) {
        autoCompleteActionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.card.v1.Action,
                com.google.apps.card.v1.Action.Builder,
                com.google.apps.card.v1.ActionOrBuilder>(
                getAutoCompleteAction(), getParentForChildren(), isClean());
        autoCompleteAction_ = null;
      }
      return autoCompleteActionBuilder_;
    }

    private java.lang.Object placeholderText_ = "";
    /**
     *
     *
     * <pre>
     * Text that appears in the text input field when the field is empty.
     * Use this text to prompt users to enter a value. For example, `Enter a
     * number from 0 to 100`.
     *
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * <code>string placeholder_text = 12;</code>
     *
     * @return The placeholderText.
     */
    public java.lang.String getPlaceholderText() {
      java.lang.Object ref = placeholderText_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        placeholderText_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Text that appears in the text input field when the field is empty.
     * Use this text to prompt users to enter a value. For example, `Enter a
     * number from 0 to 100`.
     *
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * <code>string placeholder_text = 12;</code>
     *
     * @return The bytes for placeholderText.
     */
    public com.google.protobuf.ByteString getPlaceholderTextBytes() {
      java.lang.Object ref = placeholderText_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        placeholderText_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Text that appears in the text input field when the field is empty.
     * Use this text to prompt users to enter a value. For example, `Enter a
     * number from 0 to 100`.
     *
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * <code>string placeholder_text = 12;</code>
     *
     * @param value The placeholderText to set.
     * @return This builder for chaining.
     */
    public Builder setPlaceholderText(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      placeholderText_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text that appears in the text input field when the field is empty.
     * Use this text to prompt users to enter a value. For example, `Enter a
     * number from 0 to 100`.
     *
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * <code>string placeholder_text = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPlaceholderText() {
      placeholderText_ = getDefaultInstance().getPlaceholderText();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text that appears in the text input field when the field is empty.
     * Use this text to prompt users to enter a value. For example, `Enter a
     * number from 0 to 100`.
     *
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * <code>string placeholder_text = 12;</code>
     *
     * @param value The bytes for placeholderText to set.
     * @return This builder for chaining.
     */
    public Builder setPlaceholderTextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      placeholderText_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.apps.card.v1.TextInput)
  }

  // @@protoc_insertion_point(class_scope:google.apps.card.v1.TextInput)
  private static final com.google.apps.card.v1.TextInput DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.apps.card.v1.TextInput();
  }

  public static com.google.apps.card.v1.TextInput getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TextInput> PARSER =
      new com.google.protobuf.AbstractParser<TextInput>() {
        @java.lang.Override
        public TextInput parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TextInput> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TextInput> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.apps.card.v1.TextInput getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
