/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/audit/audit_log.proto

package com.google.cloud.audit;

/**
 *
 *
 * <pre>
 * Authentication information for the operation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.audit.AuthenticationInfo}
 */
public final class AuthenticationInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.audit.AuthenticationInfo)
    AuthenticationInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AuthenticationInfo.newBuilder() to construct.
  private AuthenticationInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AuthenticationInfo() {
    principalEmail_ = "";
    authoritySelector_ = "";
    serviceAccountKeyName_ = "";
    serviceAccountDelegationInfo_ = java.util.Collections.emptyList();
    principalSubject_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AuthenticationInfo();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private AuthenticationInfo(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              principalEmail_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              authoritySelector_ = s;
              break;
            }
          case 34:
            {
              com.google.protobuf.Struct.Builder subBuilder = null;
              if (thirdPartyPrincipal_ != null) {
                subBuilder = thirdPartyPrincipal_.toBuilder();
              }
              thirdPartyPrincipal_ =
                  input.readMessage(com.google.protobuf.Struct.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(thirdPartyPrincipal_);
                thirdPartyPrincipal_ = subBuilder.buildPartial();
              }

              break;
            }
          case 42:
            {
              java.lang.String s = input.readStringRequireUtf8();

              serviceAccountKeyName_ = s;
              break;
            }
          case 50:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                serviceAccountDelegationInfo_ =
                    new java.util.ArrayList<com.google.cloud.audit.ServiceAccountDelegationInfo>();
                mutable_bitField0_ |= 0x00000001;
              }
              serviceAccountDelegationInfo_.add(
                  input.readMessage(
                      com.google.cloud.audit.ServiceAccountDelegationInfo.parser(),
                      extensionRegistry));
              break;
            }
          case 66:
            {
              java.lang.String s = input.readStringRequireUtf8();

              principalSubject_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        serviceAccountDelegationInfo_ =
            java.util.Collections.unmodifiableList(serviceAccountDelegationInfo_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.audit.AuditLogProto
        .internal_static_google_cloud_audit_AuthenticationInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.audit.AuditLogProto
        .internal_static_google_cloud_audit_AuthenticationInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.audit.AuthenticationInfo.class,
            com.google.cloud.audit.AuthenticationInfo.Builder.class);
  }

  public static final int PRINCIPAL_EMAIL_FIELD_NUMBER = 1;
  private volatile java.lang.Object principalEmail_;
  /**
   *
   *
   * <pre>
   * The email address of the authenticated user (or service account on behalf
   * of third party principal) making the request. For third party identity
   * callers, the `principal_subject` field is populated instead of this field.
   * For privacy reasons, the principal email address is sometimes redacted.
   * For more information, see
   * https://cloud.google.com/logging/docs/audit#user-id.
   * </pre>
   *
   * <code>string principal_email = 1;</code>
   *
   * @return The principalEmail.
   */
  @java.lang.Override
  public java.lang.String getPrincipalEmail() {
    java.lang.Object ref = principalEmail_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      principalEmail_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The email address of the authenticated user (or service account on behalf
   * of third party principal) making the request. For third party identity
   * callers, the `principal_subject` field is populated instead of this field.
   * For privacy reasons, the principal email address is sometimes redacted.
   * For more information, see
   * https://cloud.google.com/logging/docs/audit#user-id.
   * </pre>
   *
   * <code>string principal_email = 1;</code>
   *
   * @return The bytes for principalEmail.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPrincipalEmailBytes() {
    java.lang.Object ref = principalEmail_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      principalEmail_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AUTHORITY_SELECTOR_FIELD_NUMBER = 2;
  private volatile java.lang.Object authoritySelector_;
  /**
   *
   *
   * <pre>
   * The authority selector specified by the requestor, if any.
   * It is not guaranteed that the principal was allowed to use this authority.
   * </pre>
   *
   * <code>string authority_selector = 2;</code>
   *
   * @return The authoritySelector.
   */
  @java.lang.Override
  public java.lang.String getAuthoritySelector() {
    java.lang.Object ref = authoritySelector_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      authoritySelector_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The authority selector specified by the requestor, if any.
   * It is not guaranteed that the principal was allowed to use this authority.
   * </pre>
   *
   * <code>string authority_selector = 2;</code>
   *
   * @return The bytes for authoritySelector.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAuthoritySelectorBytes() {
    java.lang.Object ref = authoritySelector_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      authoritySelector_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int THIRD_PARTY_PRINCIPAL_FIELD_NUMBER = 4;
  private com.google.protobuf.Struct thirdPartyPrincipal_;
  /**
   *
   *
   * <pre>
   * The third party identification (if any) of the authenticated user making
   * the request.
   * When the JSON object represented here has a proto equivalent, the proto
   * name will be indicated in the `&#64;type` property.
   * </pre>
   *
   * <code>.google.protobuf.Struct third_party_principal = 4;</code>
   *
   * @return Whether the thirdPartyPrincipal field is set.
   */
  @java.lang.Override
  public boolean hasThirdPartyPrincipal() {
    return thirdPartyPrincipal_ != null;
  }
  /**
   *
   *
   * <pre>
   * The third party identification (if any) of the authenticated user making
   * the request.
   * When the JSON object represented here has a proto equivalent, the proto
   * name will be indicated in the `&#64;type` property.
   * </pre>
   *
   * <code>.google.protobuf.Struct third_party_principal = 4;</code>
   *
   * @return The thirdPartyPrincipal.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getThirdPartyPrincipal() {
    return thirdPartyPrincipal_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : thirdPartyPrincipal_;
  }
  /**
   *
   *
   * <pre>
   * The third party identification (if any) of the authenticated user making
   * the request.
   * When the JSON object represented here has a proto equivalent, the proto
   * name will be indicated in the `&#64;type` property.
   * </pre>
   *
   * <code>.google.protobuf.Struct third_party_principal = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getThirdPartyPrincipalOrBuilder() {
    return getThirdPartyPrincipal();
  }

  public static final int SERVICE_ACCOUNT_KEY_NAME_FIELD_NUMBER = 5;
  private volatile java.lang.Object serviceAccountKeyName_;
  /**
   *
   *
   * <pre>
   * The name of the service account key used to create or exchange
   * credentials for authenticating the service account making the request.
   * This is a scheme-less URI full resource name. For example:
   * "//iam.googleapis.com/projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}"
   * </pre>
   *
   * <code>string service_account_key_name = 5;</code>
   *
   * @return The serviceAccountKeyName.
   */
  @java.lang.Override
  public java.lang.String getServiceAccountKeyName() {
    java.lang.Object ref = serviceAccountKeyName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccountKeyName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the service account key used to create or exchange
   * credentials for authenticating the service account making the request.
   * This is a scheme-less URI full resource name. For example:
   * "//iam.googleapis.com/projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}"
   * </pre>
   *
   * <code>string service_account_key_name = 5;</code>
   *
   * @return The bytes for serviceAccountKeyName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountKeyNameBytes() {
    java.lang.Object ref = serviceAccountKeyName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccountKeyName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_ACCOUNT_DELEGATION_INFO_FIELD_NUMBER = 6;
  private java.util.List<com.google.cloud.audit.ServiceAccountDelegationInfo>
      serviceAccountDelegationInfo_;
  /**
   *
   *
   * <pre>
   * Identity delegation history of an authenticated service account that makes
   * the request. It contains information on the real authorities that try to
   * access GCP resources by delegating on a service account. When multiple
   * authorities present, they are guaranteed to be sorted based on the original
   * ordering of the identity delegation events.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.audit.ServiceAccountDelegationInfo service_account_delegation_info = 6;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.audit.ServiceAccountDelegationInfo>
      getServiceAccountDelegationInfoList() {
    return serviceAccountDelegationInfo_;
  }
  /**
   *
   *
   * <pre>
   * Identity delegation history of an authenticated service account that makes
   * the request. It contains information on the real authorities that try to
   * access GCP resources by delegating on a service account. When multiple
   * authorities present, they are guaranteed to be sorted based on the original
   * ordering of the identity delegation events.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.audit.ServiceAccountDelegationInfo service_account_delegation_info = 6;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.audit.ServiceAccountDelegationInfoOrBuilder>
      getServiceAccountDelegationInfoOrBuilderList() {
    return serviceAccountDelegationInfo_;
  }
  /**
   *
   *
   * <pre>
   * Identity delegation history of an authenticated service account that makes
   * the request. It contains information on the real authorities that try to
   * access GCP resources by delegating on a service account. When multiple
   * authorities present, they are guaranteed to be sorted based on the original
   * ordering of the identity delegation events.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.audit.ServiceAccountDelegationInfo service_account_delegation_info = 6;
   * </code>
   */
  @java.lang.Override
  public int getServiceAccountDelegationInfoCount() {
    return serviceAccountDelegationInfo_.size();
  }
  /**
   *
   *
   * <pre>
   * Identity delegation history of an authenticated service account that makes
   * the request. It contains information on the real authorities that try to
   * access GCP resources by delegating on a service account. When multiple
   * authorities present, they are guaranteed to be sorted based on the original
   * ordering of the identity delegation events.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.audit.ServiceAccountDelegationInfo service_account_delegation_info = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.audit.ServiceAccountDelegationInfo getServiceAccountDelegationInfo(
      int index) {
    return serviceAccountDelegationInfo_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Identity delegation history of an authenticated service account that makes
   * the request. It contains information on the real authorities that try to
   * access GCP resources by delegating on a service account. When multiple
   * authorities present, they are guaranteed to be sorted based on the original
   * ordering of the identity delegation events.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.audit.ServiceAccountDelegationInfo service_account_delegation_info = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.audit.ServiceAccountDelegationInfoOrBuilder
      getServiceAccountDelegationInfoOrBuilder(int index) {
    return serviceAccountDelegationInfo_.get(index);
  }

  public static final int PRINCIPAL_SUBJECT_FIELD_NUMBER = 8;
  private volatile java.lang.Object principalSubject_;
  /**
   *
   *
   * <pre>
   * String representation of identity of requesting party.
   * Populated for both first and third party identities.
   * </pre>
   *
   * <code>string principal_subject = 8;</code>
   *
   * @return The principalSubject.
   */
  @java.lang.Override
  public java.lang.String getPrincipalSubject() {
    java.lang.Object ref = principalSubject_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      principalSubject_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * String representation of identity of requesting party.
   * Populated for both first and third party identities.
   * </pre>
   *
   * <code>string principal_subject = 8;</code>
   *
   * @return The bytes for principalSubject.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPrincipalSubjectBytes() {
    java.lang.Object ref = principalSubject_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      principalSubject_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getPrincipalEmailBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, principalEmail_);
    }
    if (!getAuthoritySelectorBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, authoritySelector_);
    }
    if (thirdPartyPrincipal_ != null) {
      output.writeMessage(4, getThirdPartyPrincipal());
    }
    if (!getServiceAccountKeyNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, serviceAccountKeyName_);
    }
    for (int i = 0; i < serviceAccountDelegationInfo_.size(); i++) {
      output.writeMessage(6, serviceAccountDelegationInfo_.get(i));
    }
    if (!getPrincipalSubjectBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, principalSubject_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getPrincipalEmailBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, principalEmail_);
    }
    if (!getAuthoritySelectorBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, authoritySelector_);
    }
    if (thirdPartyPrincipal_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getThirdPartyPrincipal());
    }
    if (!getServiceAccountKeyNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, serviceAccountKeyName_);
    }
    for (int i = 0; i < serviceAccountDelegationInfo_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, serviceAccountDelegationInfo_.get(i));
    }
    if (!getPrincipalSubjectBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, principalSubject_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.audit.AuthenticationInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.audit.AuthenticationInfo other =
        (com.google.cloud.audit.AuthenticationInfo) obj;

    if (!getPrincipalEmail().equals(other.getPrincipalEmail())) return false;
    if (!getAuthoritySelector().equals(other.getAuthoritySelector())) return false;
    if (hasThirdPartyPrincipal() != other.hasThirdPartyPrincipal()) return false;
    if (hasThirdPartyPrincipal()) {
      if (!getThirdPartyPrincipal().equals(other.getThirdPartyPrincipal())) return false;
    }
    if (!getServiceAccountKeyName().equals(other.getServiceAccountKeyName())) return false;
    if (!getServiceAccountDelegationInfoList().equals(other.getServiceAccountDelegationInfoList()))
      return false;
    if (!getPrincipalSubject().equals(other.getPrincipalSubject())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PRINCIPAL_EMAIL_FIELD_NUMBER;
    hash = (53 * hash) + getPrincipalEmail().hashCode();
    hash = (37 * hash) + AUTHORITY_SELECTOR_FIELD_NUMBER;
    hash = (53 * hash) + getAuthoritySelector().hashCode();
    if (hasThirdPartyPrincipal()) {
      hash = (37 * hash) + THIRD_PARTY_PRINCIPAL_FIELD_NUMBER;
      hash = (53 * hash) + getThirdPartyPrincipal().hashCode();
    }
    hash = (37 * hash) + SERVICE_ACCOUNT_KEY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccountKeyName().hashCode();
    if (getServiceAccountDelegationInfoCount() > 0) {
      hash = (37 * hash) + SERVICE_ACCOUNT_DELEGATION_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getServiceAccountDelegationInfoList().hashCode();
    }
    hash = (37 * hash) + PRINCIPAL_SUBJECT_FIELD_NUMBER;
    hash = (53 * hash) + getPrincipalSubject().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.audit.AuthenticationInfo parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.audit.AuthenticationInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.audit.AuthenticationInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.audit.AuthenticationInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.audit.AuthenticationInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.audit.AuthenticationInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.audit.AuthenticationInfo parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.audit.AuthenticationInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.audit.AuthenticationInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.audit.AuthenticationInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.audit.AuthenticationInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.audit.AuthenticationInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.audit.AuthenticationInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Authentication information for the operation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.audit.AuthenticationInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.audit.AuthenticationInfo)
      com.google.cloud.audit.AuthenticationInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.audit.AuditLogProto
          .internal_static_google_cloud_audit_AuthenticationInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.audit.AuditLogProto
          .internal_static_google_cloud_audit_AuthenticationInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.audit.AuthenticationInfo.class,
              com.google.cloud.audit.AuthenticationInfo.Builder.class);
    }

    // Construct using com.google.cloud.audit.AuthenticationInfo.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getServiceAccountDelegationInfoFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      principalEmail_ = "";

      authoritySelector_ = "";

      if (thirdPartyPrincipalBuilder_ == null) {
        thirdPartyPrincipal_ = null;
      } else {
        thirdPartyPrincipal_ = null;
        thirdPartyPrincipalBuilder_ = null;
      }
      serviceAccountKeyName_ = "";

      if (serviceAccountDelegationInfoBuilder_ == null) {
        serviceAccountDelegationInfo_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        serviceAccountDelegationInfoBuilder_.clear();
      }
      principalSubject_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.audit.AuditLogProto
          .internal_static_google_cloud_audit_AuthenticationInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.audit.AuthenticationInfo getDefaultInstanceForType() {
      return com.google.cloud.audit.AuthenticationInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.audit.AuthenticationInfo build() {
      com.google.cloud.audit.AuthenticationInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.audit.AuthenticationInfo buildPartial() {
      com.google.cloud.audit.AuthenticationInfo result =
          new com.google.cloud.audit.AuthenticationInfo(this);
      int from_bitField0_ = bitField0_;
      result.principalEmail_ = principalEmail_;
      result.authoritySelector_ = authoritySelector_;
      if (thirdPartyPrincipalBuilder_ == null) {
        result.thirdPartyPrincipal_ = thirdPartyPrincipal_;
      } else {
        result.thirdPartyPrincipal_ = thirdPartyPrincipalBuilder_.build();
      }
      result.serviceAccountKeyName_ = serviceAccountKeyName_;
      if (serviceAccountDelegationInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          serviceAccountDelegationInfo_ =
              java.util.Collections.unmodifiableList(serviceAccountDelegationInfo_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.serviceAccountDelegationInfo_ = serviceAccountDelegationInfo_;
      } else {
        result.serviceAccountDelegationInfo_ = serviceAccountDelegationInfoBuilder_.build();
      }
      result.principalSubject_ = principalSubject_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.audit.AuthenticationInfo) {
        return mergeFrom((com.google.cloud.audit.AuthenticationInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.audit.AuthenticationInfo other) {
      if (other == com.google.cloud.audit.AuthenticationInfo.getDefaultInstance()) return this;
      if (!other.getPrincipalEmail().isEmpty()) {
        principalEmail_ = other.principalEmail_;
        onChanged();
      }
      if (!other.getAuthoritySelector().isEmpty()) {
        authoritySelector_ = other.authoritySelector_;
        onChanged();
      }
      if (other.hasThirdPartyPrincipal()) {
        mergeThirdPartyPrincipal(other.getThirdPartyPrincipal());
      }
      if (!other.getServiceAccountKeyName().isEmpty()) {
        serviceAccountKeyName_ = other.serviceAccountKeyName_;
        onChanged();
      }
      if (serviceAccountDelegationInfoBuilder_ == null) {
        if (!other.serviceAccountDelegationInfo_.isEmpty()) {
          if (serviceAccountDelegationInfo_.isEmpty()) {
            serviceAccountDelegationInfo_ = other.serviceAccountDelegationInfo_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureServiceAccountDelegationInfoIsMutable();
            serviceAccountDelegationInfo_.addAll(other.serviceAccountDelegationInfo_);
          }
          onChanged();
        }
      } else {
        if (!other.serviceAccountDelegationInfo_.isEmpty()) {
          if (serviceAccountDelegationInfoBuilder_.isEmpty()) {
            serviceAccountDelegationInfoBuilder_.dispose();
            serviceAccountDelegationInfoBuilder_ = null;
            serviceAccountDelegationInfo_ = other.serviceAccountDelegationInfo_;
            bitField0_ = (bitField0_ & ~0x00000001);
            serviceAccountDelegationInfoBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getServiceAccountDelegationInfoFieldBuilder()
                    : null;
          } else {
            serviceAccountDelegationInfoBuilder_.addAllMessages(
                other.serviceAccountDelegationInfo_);
          }
        }
      }
      if (!other.getPrincipalSubject().isEmpty()) {
        principalSubject_ = other.principalSubject_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.audit.AuthenticationInfo parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.audit.AuthenticationInfo) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object principalEmail_ = "";
    /**
     *
     *
     * <pre>
     * The email address of the authenticated user (or service account on behalf
     * of third party principal) making the request. For third party identity
     * callers, the `principal_subject` field is populated instead of this field.
     * For privacy reasons, the principal email address is sometimes redacted.
     * For more information, see
     * https://cloud.google.com/logging/docs/audit#user-id.
     * </pre>
     *
     * <code>string principal_email = 1;</code>
     *
     * @return The principalEmail.
     */
    public java.lang.String getPrincipalEmail() {
      java.lang.Object ref = principalEmail_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        principalEmail_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The email address of the authenticated user (or service account on behalf
     * of third party principal) making the request. For third party identity
     * callers, the `principal_subject` field is populated instead of this field.
     * For privacy reasons, the principal email address is sometimes redacted.
     * For more information, see
     * https://cloud.google.com/logging/docs/audit#user-id.
     * </pre>
     *
     * <code>string principal_email = 1;</code>
     *
     * @return The bytes for principalEmail.
     */
    public com.google.protobuf.ByteString getPrincipalEmailBytes() {
      java.lang.Object ref = principalEmail_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        principalEmail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The email address of the authenticated user (or service account on behalf
     * of third party principal) making the request. For third party identity
     * callers, the `principal_subject` field is populated instead of this field.
     * For privacy reasons, the principal email address is sometimes redacted.
     * For more information, see
     * https://cloud.google.com/logging/docs/audit#user-id.
     * </pre>
     *
     * <code>string principal_email = 1;</code>
     *
     * @param value The principalEmail to set.
     * @return This builder for chaining.
     */
    public Builder setPrincipalEmail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      principalEmail_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The email address of the authenticated user (or service account on behalf
     * of third party principal) making the request. For third party identity
     * callers, the `principal_subject` field is populated instead of this field.
     * For privacy reasons, the principal email address is sometimes redacted.
     * For more information, see
     * https://cloud.google.com/logging/docs/audit#user-id.
     * </pre>
     *
     * <code>string principal_email = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrincipalEmail() {

      principalEmail_ = getDefaultInstance().getPrincipalEmail();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The email address of the authenticated user (or service account on behalf
     * of third party principal) making the request. For third party identity
     * callers, the `principal_subject` field is populated instead of this field.
     * For privacy reasons, the principal email address is sometimes redacted.
     * For more information, see
     * https://cloud.google.com/logging/docs/audit#user-id.
     * </pre>
     *
     * <code>string principal_email = 1;</code>
     *
     * @param value The bytes for principalEmail to set.
     * @return This builder for chaining.
     */
    public Builder setPrincipalEmailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      principalEmail_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object authoritySelector_ = "";
    /**
     *
     *
     * <pre>
     * The authority selector specified by the requestor, if any.
     * It is not guaranteed that the principal was allowed to use this authority.
     * </pre>
     *
     * <code>string authority_selector = 2;</code>
     *
     * @return The authoritySelector.
     */
    public java.lang.String getAuthoritySelector() {
      java.lang.Object ref = authoritySelector_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        authoritySelector_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The authority selector specified by the requestor, if any.
     * It is not guaranteed that the principal was allowed to use this authority.
     * </pre>
     *
     * <code>string authority_selector = 2;</code>
     *
     * @return The bytes for authoritySelector.
     */
    public com.google.protobuf.ByteString getAuthoritySelectorBytes() {
      java.lang.Object ref = authoritySelector_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        authoritySelector_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The authority selector specified by the requestor, if any.
     * It is not guaranteed that the principal was allowed to use this authority.
     * </pre>
     *
     * <code>string authority_selector = 2;</code>
     *
     * @param value The authoritySelector to set.
     * @return This builder for chaining.
     */
    public Builder setAuthoritySelector(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      authoritySelector_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The authority selector specified by the requestor, if any.
     * It is not guaranteed that the principal was allowed to use this authority.
     * </pre>
     *
     * <code>string authority_selector = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAuthoritySelector() {

      authoritySelector_ = getDefaultInstance().getAuthoritySelector();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The authority selector specified by the requestor, if any.
     * It is not guaranteed that the principal was allowed to use this authority.
     * </pre>
     *
     * <code>string authority_selector = 2;</code>
     *
     * @param value The bytes for authoritySelector to set.
     * @return This builder for chaining.
     */
    public Builder setAuthoritySelectorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      authoritySelector_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct thirdPartyPrincipal_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        thirdPartyPrincipalBuilder_;
    /**
     *
     *
     * <pre>
     * The third party identification (if any) of the authenticated user making
     * the request.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct third_party_principal = 4;</code>
     *
     * @return Whether the thirdPartyPrincipal field is set.
     */
    public boolean hasThirdPartyPrincipal() {
      return thirdPartyPrincipalBuilder_ != null || thirdPartyPrincipal_ != null;
    }
    /**
     *
     *
     * <pre>
     * The third party identification (if any) of the authenticated user making
     * the request.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct third_party_principal = 4;</code>
     *
     * @return The thirdPartyPrincipal.
     */
    public com.google.protobuf.Struct getThirdPartyPrincipal() {
      if (thirdPartyPrincipalBuilder_ == null) {
        return thirdPartyPrincipal_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : thirdPartyPrincipal_;
      } else {
        return thirdPartyPrincipalBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The third party identification (if any) of the authenticated user making
     * the request.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct third_party_principal = 4;</code>
     */
    public Builder setThirdPartyPrincipal(com.google.protobuf.Struct value) {
      if (thirdPartyPrincipalBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        thirdPartyPrincipal_ = value;
        onChanged();
      } else {
        thirdPartyPrincipalBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The third party identification (if any) of the authenticated user making
     * the request.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct third_party_principal = 4;</code>
     */
    public Builder setThirdPartyPrincipal(com.google.protobuf.Struct.Builder builderForValue) {
      if (thirdPartyPrincipalBuilder_ == null) {
        thirdPartyPrincipal_ = builderForValue.build();
        onChanged();
      } else {
        thirdPartyPrincipalBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The third party identification (if any) of the authenticated user making
     * the request.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct third_party_principal = 4;</code>
     */
    public Builder mergeThirdPartyPrincipal(com.google.protobuf.Struct value) {
      if (thirdPartyPrincipalBuilder_ == null) {
        if (thirdPartyPrincipal_ != null) {
          thirdPartyPrincipal_ =
              com.google.protobuf.Struct.newBuilder(thirdPartyPrincipal_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          thirdPartyPrincipal_ = value;
        }
        onChanged();
      } else {
        thirdPartyPrincipalBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The third party identification (if any) of the authenticated user making
     * the request.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct third_party_principal = 4;</code>
     */
    public Builder clearThirdPartyPrincipal() {
      if (thirdPartyPrincipalBuilder_ == null) {
        thirdPartyPrincipal_ = null;
        onChanged();
      } else {
        thirdPartyPrincipal_ = null;
        thirdPartyPrincipalBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The third party identification (if any) of the authenticated user making
     * the request.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct third_party_principal = 4;</code>
     */
    public com.google.protobuf.Struct.Builder getThirdPartyPrincipalBuilder() {

      onChanged();
      return getThirdPartyPrincipalFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The third party identification (if any) of the authenticated user making
     * the request.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct third_party_principal = 4;</code>
     */
    public com.google.protobuf.StructOrBuilder getThirdPartyPrincipalOrBuilder() {
      if (thirdPartyPrincipalBuilder_ != null) {
        return thirdPartyPrincipalBuilder_.getMessageOrBuilder();
      } else {
        return thirdPartyPrincipal_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : thirdPartyPrincipal_;
      }
    }
    /**
     *
     *
     * <pre>
     * The third party identification (if any) of the authenticated user making
     * the request.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct third_party_principal = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getThirdPartyPrincipalFieldBuilder() {
      if (thirdPartyPrincipalBuilder_ == null) {
        thirdPartyPrincipalBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getThirdPartyPrincipal(), getParentForChildren(), isClean());
        thirdPartyPrincipal_ = null;
      }
      return thirdPartyPrincipalBuilder_;
    }

    private java.lang.Object serviceAccountKeyName_ = "";
    /**
     *
     *
     * <pre>
     * The name of the service account key used to create or exchange
     * credentials for authenticating the service account making the request.
     * This is a scheme-less URI full resource name. For example:
     * "//iam.googleapis.com/projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}"
     * </pre>
     *
     * <code>string service_account_key_name = 5;</code>
     *
     * @return The serviceAccountKeyName.
     */
    public java.lang.String getServiceAccountKeyName() {
      java.lang.Object ref = serviceAccountKeyName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccountKeyName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the service account key used to create or exchange
     * credentials for authenticating the service account making the request.
     * This is a scheme-less URI full resource name. For example:
     * "//iam.googleapis.com/projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}"
     * </pre>
     *
     * <code>string service_account_key_name = 5;</code>
     *
     * @return The bytes for serviceAccountKeyName.
     */
    public com.google.protobuf.ByteString getServiceAccountKeyNameBytes() {
      java.lang.Object ref = serviceAccountKeyName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccountKeyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the service account key used to create or exchange
     * credentials for authenticating the service account making the request.
     * This is a scheme-less URI full resource name. For example:
     * "//iam.googleapis.com/projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}"
     * </pre>
     *
     * <code>string service_account_key_name = 5;</code>
     *
     * @param value The serviceAccountKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountKeyName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      serviceAccountKeyName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the service account key used to create or exchange
     * credentials for authenticating the service account making the request.
     * This is a scheme-less URI full resource name. For example:
     * "//iam.googleapis.com/projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}"
     * </pre>
     *
     * <code>string service_account_key_name = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccountKeyName() {

      serviceAccountKeyName_ = getDefaultInstance().getServiceAccountKeyName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the service account key used to create or exchange
     * credentials for authenticating the service account making the request.
     * This is a scheme-less URI full resource name. For example:
     * "//iam.googleapis.com/projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}"
     * </pre>
     *
     * <code>string service_account_key_name = 5;</code>
     *
     * @param value The bytes for serviceAccountKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountKeyNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      serviceAccountKeyName_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.audit.ServiceAccountDelegationInfo>
        serviceAccountDelegationInfo_ = java.util.Collections.emptyList();

    private void ensureServiceAccountDelegationInfoIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        serviceAccountDelegationInfo_ =
            new java.util.ArrayList<com.google.cloud.audit.ServiceAccountDelegationInfo>(
                serviceAccountDelegationInfo_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.audit.ServiceAccountDelegationInfo,
            com.google.cloud.audit.ServiceAccountDelegationInfo.Builder,
            com.google.cloud.audit.ServiceAccountDelegationInfoOrBuilder>
        serviceAccountDelegationInfoBuilder_;

    /**
     *
     *
     * <pre>
     * Identity delegation history of an authenticated service account that makes
     * the request. It contains information on the real authorities that try to
     * access GCP resources by delegating on a service account. When multiple
     * authorities present, they are guaranteed to be sorted based on the original
     * ordering of the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.audit.ServiceAccountDelegationInfo service_account_delegation_info = 6;
     * </code>
     */
    public java.util.List<com.google.cloud.audit.ServiceAccountDelegationInfo>
        getServiceAccountDelegationInfoList() {
      if (serviceAccountDelegationInfoBuilder_ == null) {
        return java.util.Collections.unmodifiableList(serviceAccountDelegationInfo_);
      } else {
        return serviceAccountDelegationInfoBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Identity delegation history of an authenticated service account that makes
     * the request. It contains information on the real authorities that try to
     * access GCP resources by delegating on a service account. When multiple
     * authorities present, they are guaranteed to be sorted based on the original
     * ordering of the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.audit.ServiceAccountDelegationInfo service_account_delegation_info = 6;
     * </code>
     */
    public int getServiceAccountDelegationInfoCount() {
      if (serviceAccountDelegationInfoBuilder_ == null) {
        return serviceAccountDelegationInfo_.size();
      } else {
        return serviceAccountDelegationInfoBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Identity delegation history of an authenticated service account that makes
     * the request. It contains information on the real authorities that try to
     * access GCP resources by delegating on a service account. When multiple
     * authorities present, they are guaranteed to be sorted based on the original
     * ordering of the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.audit.ServiceAccountDelegationInfo service_account_delegation_info = 6;
     * </code>
     */
    public com.google.cloud.audit.ServiceAccountDelegationInfo getServiceAccountDelegationInfo(
        int index) {
      if (serviceAccountDelegationInfoBuilder_ == null) {
        return serviceAccountDelegationInfo_.get(index);
      } else {
        return serviceAccountDelegationInfoBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Identity delegation history of an authenticated service account that makes
     * the request. It contains information on the real authorities that try to
     * access GCP resources by delegating on a service account. When multiple
     * authorities present, they are guaranteed to be sorted based on the original
     * ordering of the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.audit.ServiceAccountDelegationInfo service_account_delegation_info = 6;
     * </code>
     */
    public Builder setServiceAccountDelegationInfo(
        int index, com.google.cloud.audit.ServiceAccountDelegationInfo value) {
      if (serviceAccountDelegationInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServiceAccountDelegationInfoIsMutable();
        serviceAccountDelegationInfo_.set(index, value);
        onChanged();
      } else {
        serviceAccountDelegationInfoBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identity delegation history of an authenticated service account that makes
     * the request. It contains information on the real authorities that try to
     * access GCP resources by delegating on a service account. When multiple
     * authorities present, they are guaranteed to be sorted based on the original
     * ordering of the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.audit.ServiceAccountDelegationInfo service_account_delegation_info = 6;
     * </code>
     */
    public Builder setServiceAccountDelegationInfo(
        int index, com.google.cloud.audit.ServiceAccountDelegationInfo.Builder builderForValue) {
      if (serviceAccountDelegationInfoBuilder_ == null) {
        ensureServiceAccountDelegationInfoIsMutable();
        serviceAccountDelegationInfo_.set(index, builderForValue.build());
        onChanged();
      } else {
        serviceAccountDelegationInfoBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identity delegation history of an authenticated service account that makes
     * the request. It contains information on the real authorities that try to
     * access GCP resources by delegating on a service account. When multiple
     * authorities present, they are guaranteed to be sorted based on the original
     * ordering of the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.audit.ServiceAccountDelegationInfo service_account_delegation_info = 6;
     * </code>
     */
    public Builder addServiceAccountDelegationInfo(
        com.google.cloud.audit.ServiceAccountDelegationInfo value) {
      if (serviceAccountDelegationInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServiceAccountDelegationInfoIsMutable();
        serviceAccountDelegationInfo_.add(value);
        onChanged();
      } else {
        serviceAccountDelegationInfoBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identity delegation history of an authenticated service account that makes
     * the request. It contains information on the real authorities that try to
     * access GCP resources by delegating on a service account. When multiple
     * authorities present, they are guaranteed to be sorted based on the original
     * ordering of the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.audit.ServiceAccountDelegationInfo service_account_delegation_info = 6;
     * </code>
     */
    public Builder addServiceAccountDelegationInfo(
        int index, com.google.cloud.audit.ServiceAccountDelegationInfo value) {
      if (serviceAccountDelegationInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServiceAccountDelegationInfoIsMutable();
        serviceAccountDelegationInfo_.add(index, value);
        onChanged();
      } else {
        serviceAccountDelegationInfoBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identity delegation history of an authenticated service account that makes
     * the request. It contains information on the real authorities that try to
     * access GCP resources by delegating on a service account. When multiple
     * authorities present, they are guaranteed to be sorted based on the original
     * ordering of the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.audit.ServiceAccountDelegationInfo service_account_delegation_info = 6;
     * </code>
     */
    public Builder addServiceAccountDelegationInfo(
        com.google.cloud.audit.ServiceAccountDelegationInfo.Builder builderForValue) {
      if (serviceAccountDelegationInfoBuilder_ == null) {
        ensureServiceAccountDelegationInfoIsMutable();
        serviceAccountDelegationInfo_.add(builderForValue.build());
        onChanged();
      } else {
        serviceAccountDelegationInfoBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identity delegation history of an authenticated service account that makes
     * the request. It contains information on the real authorities that try to
     * access GCP resources by delegating on a service account. When multiple
     * authorities present, they are guaranteed to be sorted based on the original
     * ordering of the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.audit.ServiceAccountDelegationInfo service_account_delegation_info = 6;
     * </code>
     */
    public Builder addServiceAccountDelegationInfo(
        int index, com.google.cloud.audit.ServiceAccountDelegationInfo.Builder builderForValue) {
      if (serviceAccountDelegationInfoBuilder_ == null) {
        ensureServiceAccountDelegationInfoIsMutable();
        serviceAccountDelegationInfo_.add(index, builderForValue.build());
        onChanged();
      } else {
        serviceAccountDelegationInfoBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identity delegation history of an authenticated service account that makes
     * the request. It contains information on the real authorities that try to
     * access GCP resources by delegating on a service account. When multiple
     * authorities present, they are guaranteed to be sorted based on the original
     * ordering of the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.audit.ServiceAccountDelegationInfo service_account_delegation_info = 6;
     * </code>
     */
    public Builder addAllServiceAccountDelegationInfo(
        java.lang.Iterable<? extends com.google.cloud.audit.ServiceAccountDelegationInfo> values) {
      if (serviceAccountDelegationInfoBuilder_ == null) {
        ensureServiceAccountDelegationInfoIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, serviceAccountDelegationInfo_);
        onChanged();
      } else {
        serviceAccountDelegationInfoBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identity delegation history of an authenticated service account that makes
     * the request. It contains information on the real authorities that try to
     * access GCP resources by delegating on a service account. When multiple
     * authorities present, they are guaranteed to be sorted based on the original
     * ordering of the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.audit.ServiceAccountDelegationInfo service_account_delegation_info = 6;
     * </code>
     */
    public Builder clearServiceAccountDelegationInfo() {
      if (serviceAccountDelegationInfoBuilder_ == null) {
        serviceAccountDelegationInfo_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        serviceAccountDelegationInfoBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identity delegation history of an authenticated service account that makes
     * the request. It contains information on the real authorities that try to
     * access GCP resources by delegating on a service account. When multiple
     * authorities present, they are guaranteed to be sorted based on the original
     * ordering of the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.audit.ServiceAccountDelegationInfo service_account_delegation_info = 6;
     * </code>
     */
    public Builder removeServiceAccountDelegationInfo(int index) {
      if (serviceAccountDelegationInfoBuilder_ == null) {
        ensureServiceAccountDelegationInfoIsMutable();
        serviceAccountDelegationInfo_.remove(index);
        onChanged();
      } else {
        serviceAccountDelegationInfoBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identity delegation history of an authenticated service account that makes
     * the request. It contains information on the real authorities that try to
     * access GCP resources by delegating on a service account. When multiple
     * authorities present, they are guaranteed to be sorted based on the original
     * ordering of the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.audit.ServiceAccountDelegationInfo service_account_delegation_info = 6;
     * </code>
     */
    public com.google.cloud.audit.ServiceAccountDelegationInfo.Builder
        getServiceAccountDelegationInfoBuilder(int index) {
      return getServiceAccountDelegationInfoFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Identity delegation history of an authenticated service account that makes
     * the request. It contains information on the real authorities that try to
     * access GCP resources by delegating on a service account. When multiple
     * authorities present, they are guaranteed to be sorted based on the original
     * ordering of the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.audit.ServiceAccountDelegationInfo service_account_delegation_info = 6;
     * </code>
     */
    public com.google.cloud.audit.ServiceAccountDelegationInfoOrBuilder
        getServiceAccountDelegationInfoOrBuilder(int index) {
      if (serviceAccountDelegationInfoBuilder_ == null) {
        return serviceAccountDelegationInfo_.get(index);
      } else {
        return serviceAccountDelegationInfoBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Identity delegation history of an authenticated service account that makes
     * the request. It contains information on the real authorities that try to
     * access GCP resources by delegating on a service account. When multiple
     * authorities present, they are guaranteed to be sorted based on the original
     * ordering of the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.audit.ServiceAccountDelegationInfo service_account_delegation_info = 6;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.audit.ServiceAccountDelegationInfoOrBuilder>
        getServiceAccountDelegationInfoOrBuilderList() {
      if (serviceAccountDelegationInfoBuilder_ != null) {
        return serviceAccountDelegationInfoBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(serviceAccountDelegationInfo_);
      }
    }
    /**
     *
     *
     * <pre>
     * Identity delegation history of an authenticated service account that makes
     * the request. It contains information on the real authorities that try to
     * access GCP resources by delegating on a service account. When multiple
     * authorities present, they are guaranteed to be sorted based on the original
     * ordering of the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.audit.ServiceAccountDelegationInfo service_account_delegation_info = 6;
     * </code>
     */
    public com.google.cloud.audit.ServiceAccountDelegationInfo.Builder
        addServiceAccountDelegationInfoBuilder() {
      return getServiceAccountDelegationInfoFieldBuilder()
          .addBuilder(com.google.cloud.audit.ServiceAccountDelegationInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Identity delegation history of an authenticated service account that makes
     * the request. It contains information on the real authorities that try to
     * access GCP resources by delegating on a service account. When multiple
     * authorities present, they are guaranteed to be sorted based on the original
     * ordering of the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.audit.ServiceAccountDelegationInfo service_account_delegation_info = 6;
     * </code>
     */
    public com.google.cloud.audit.ServiceAccountDelegationInfo.Builder
        addServiceAccountDelegationInfoBuilder(int index) {
      return getServiceAccountDelegationInfoFieldBuilder()
          .addBuilder(
              index, com.google.cloud.audit.ServiceAccountDelegationInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Identity delegation history of an authenticated service account that makes
     * the request. It contains information on the real authorities that try to
     * access GCP resources by delegating on a service account. When multiple
     * authorities present, they are guaranteed to be sorted based on the original
     * ordering of the identity delegation events.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.audit.ServiceAccountDelegationInfo service_account_delegation_info = 6;
     * </code>
     */
    public java.util.List<com.google.cloud.audit.ServiceAccountDelegationInfo.Builder>
        getServiceAccountDelegationInfoBuilderList() {
      return getServiceAccountDelegationInfoFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.audit.ServiceAccountDelegationInfo,
            com.google.cloud.audit.ServiceAccountDelegationInfo.Builder,
            com.google.cloud.audit.ServiceAccountDelegationInfoOrBuilder>
        getServiceAccountDelegationInfoFieldBuilder() {
      if (serviceAccountDelegationInfoBuilder_ == null) {
        serviceAccountDelegationInfoBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.audit.ServiceAccountDelegationInfo,
                com.google.cloud.audit.ServiceAccountDelegationInfo.Builder,
                com.google.cloud.audit.ServiceAccountDelegationInfoOrBuilder>(
                serviceAccountDelegationInfo_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        serviceAccountDelegationInfo_ = null;
      }
      return serviceAccountDelegationInfoBuilder_;
    }

    private java.lang.Object principalSubject_ = "";
    /**
     *
     *
     * <pre>
     * String representation of identity of requesting party.
     * Populated for both first and third party identities.
     * </pre>
     *
     * <code>string principal_subject = 8;</code>
     *
     * @return The principalSubject.
     */
    public java.lang.String getPrincipalSubject() {
      java.lang.Object ref = principalSubject_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        principalSubject_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * String representation of identity of requesting party.
     * Populated for both first and third party identities.
     * </pre>
     *
     * <code>string principal_subject = 8;</code>
     *
     * @return The bytes for principalSubject.
     */
    public com.google.protobuf.ByteString getPrincipalSubjectBytes() {
      java.lang.Object ref = principalSubject_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        principalSubject_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * String representation of identity of requesting party.
     * Populated for both first and third party identities.
     * </pre>
     *
     * <code>string principal_subject = 8;</code>
     *
     * @param value The principalSubject to set.
     * @return This builder for chaining.
     */
    public Builder setPrincipalSubject(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      principalSubject_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * String representation of identity of requesting party.
     * Populated for both first and third party identities.
     * </pre>
     *
     * <code>string principal_subject = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrincipalSubject() {

      principalSubject_ = getDefaultInstance().getPrincipalSubject();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * String representation of identity of requesting party.
     * Populated for both first and third party identities.
     * </pre>
     *
     * <code>string principal_subject = 8;</code>
     *
     * @param value The bytes for principalSubject to set.
     * @return This builder for chaining.
     */
    public Builder setPrincipalSubjectBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      principalSubject_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.audit.AuthenticationInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.audit.AuthenticationInfo)
  private static final com.google.cloud.audit.AuthenticationInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.audit.AuthenticationInfo();
  }

  public static com.google.cloud.audit.AuthenticationInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AuthenticationInfo> PARSER =
      new com.google.protobuf.AbstractParser<AuthenticationInfo>() {
        @java.lang.Override
        public AuthenticationInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new AuthenticationInfo(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<AuthenticationInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AuthenticationInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.audit.AuthenticationInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
