/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for RowAccessPolicyReference.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RowAccessPolicyReference extends com.google.api.client.json.GenericJson {

  /**
   * Required. The ID of the dataset containing this row access policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String datasetId;

  /**
   * Required. The ID of the row access policy. The ID must contain only letters (a-z, A-Z), numbers
   * (0-9), or underscores (_). The maximum length is 256 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String policyId;

  /**
   * Required. The ID of the project containing this row access policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String projectId;

  /**
   * Required. The ID of the table containing this row access policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tableId;

  /**
   * Required. The ID of the dataset containing this row access policy.
   * @return value or {@code null} for none
   */
  public java.lang.String getDatasetId() {
    return datasetId;
  }

  /**
   * Required. The ID of the dataset containing this row access policy.
   * @param datasetId datasetId or {@code null} for none
   */
  public RowAccessPolicyReference setDatasetId(java.lang.String datasetId) {
    this.datasetId = datasetId;
    return this;
  }

  /**
   * Required. The ID of the row access policy. The ID must contain only letters (a-z, A-Z), numbers
   * (0-9), or underscores (_). The maximum length is 256 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getPolicyId() {
    return policyId;
  }

  /**
   * Required. The ID of the row access policy. The ID must contain only letters (a-z, A-Z), numbers
   * (0-9), or underscores (_). The maximum length is 256 characters.
   * @param policyId policyId or {@code null} for none
   */
  public RowAccessPolicyReference setPolicyId(java.lang.String policyId) {
    this.policyId = policyId;
    return this;
  }

  /**
   * Required. The ID of the project containing this row access policy.
   * @return value or {@code null} for none
   */
  public java.lang.String getProjectId() {
    return projectId;
  }

  /**
   * Required. The ID of the project containing this row access policy.
   * @param projectId projectId or {@code null} for none
   */
  public RowAccessPolicyReference setProjectId(java.lang.String projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Required. The ID of the table containing this row access policy.
   * @return value or {@code null} for none
   */
  public java.lang.String getTableId() {
    return tableId;
  }

  /**
   * Required. The ID of the table containing this row access policy.
   * @param tableId tableId or {@code null} for none
   */
  public RowAccessPolicyReference setTableId(java.lang.String tableId) {
    this.tableId = tableId;
    return this;
  }

  @Override
  public RowAccessPolicyReference set(String fieldName, Object value) {
    return (RowAccessPolicyReference) super.set(fieldName, value);
  }

  @Override
  public RowAccessPolicyReference clone() {
    return (RowAccessPolicyReference) super.clone();
  }

}
