/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Information related to a CSV data source.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CsvOptions extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Indicates if BigQuery should accept rows that are missing trailing optional columns.
   * If true, BigQuery treats missing trailing columns as null values. If false, records with
   * missing trailing columns are treated as bad records, and if there are too many bad records, an
   * invalid error is returned in the job result. The default value is false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean allowJaggedRows;

  /**
   * Optional. Indicates if BigQuery should allow quoted data sections that contain newline
   * characters in a CSV file. The default value is false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean allowQuotedNewlines;

  /**
   * Optional. The character encoding of the data. The supported values are UTF-8, ISO-8859-1, UTF-
   * 16BE, UTF-16LE, UTF-32BE, and UTF-32LE. The default value is UTF-8. BigQuery decodes the data
   * after the raw, binary data has been split using the values of the quote and fieldDelimiter
   * properties.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String encoding;

  /**
   * Optional. The separator character for fields in a CSV file. The separator is interpreted as a
   * single byte. For files encoded in ISO-8859-1, any single character can be used as a separator.
   * For files encoded in UTF-8, characters represented in decimal range 1-127 (U+0001-U+007F) can
   * be used without any modification. UTF-8 characters encoded with multiple bytes (i.e. U+0080 and
   * above) will have only the first byte used for separating fields. The remaining bytes will be
   * treated as a part of the field. BigQuery also supports the escape sequence "\t" (U+0009) to
   * specify a tab separator. The default value is comma (",", U+002C).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fieldDelimiter;

  /**
   * [Optional] A custom string that will represent a NULL value in CSV import data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nullMarker;

  /**
   * Optional. Indicates if the embedded ASCII control characters (the first 32 characters in the
   * ASCII-table, from '\x00' to '\x1F') are preserved.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean preserveAsciiControlCharacters;

  /**
   * Optional. The value that is used to quote data sections in a CSV file. BigQuery converts the
   * string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the
   * data in its raw, binary state. The default value is a double-quote ("). If your data does not
   * contain quoted sections, set the property value to an empty string. If your data contains
   * quoted newline characters, you must also set the allowQuotedNewlines property to true. To
   * include the specific quote character within a quoted value, precede it with an additional
   * matching quote character. For example, if you want to escape the default character ' " ', use '
   * "" '.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String quote;

  /**
   * Optional. The number of rows at the top of a CSV file that BigQuery will skip when reading the
   * data. The default value is 0. This property is useful if you have header rows in the file that
   * should be skipped. When autodetect is on, the behavior is the following: * skipLeadingRows
   * unspecified - Autodetect tries to detect headers in the first row. If they are not detected,
   * the row is read as data. Otherwise data is read starting from the second row. * skipLeadingRows
   * is 0 - Instructs autodetect that there are no headers and data should be read starting from the
   * first row. * skipLeadingRows = N > 0 - Autodetect skips N-1 rows and tries to detect headers in
   * row N. If headers are not detected, row N is just skipped. Otherwise row N is used to extract
   * column names for the detected schema.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long skipLeadingRows;

  /**
   * Optional. Indicates if BigQuery should accept rows that are missing trailing optional columns.
   * If true, BigQuery treats missing trailing columns as null values. If false, records with
   * missing trailing columns are treated as bad records, and if there are too many bad records, an
   * invalid error is returned in the job result. The default value is false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAllowJaggedRows() {
    return allowJaggedRows;
  }

  /**
   * Optional. Indicates if BigQuery should accept rows that are missing trailing optional columns.
   * If true, BigQuery treats missing trailing columns as null values. If false, records with
   * missing trailing columns are treated as bad records, and if there are too many bad records, an
   * invalid error is returned in the job result. The default value is false.
   * @param allowJaggedRows allowJaggedRows or {@code null} for none
   */
  public CsvOptions setAllowJaggedRows(java.lang.Boolean allowJaggedRows) {
    this.allowJaggedRows = allowJaggedRows;
    return this;
  }

  /**
   * Optional. Indicates if BigQuery should allow quoted data sections that contain newline
   * characters in a CSV file. The default value is false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAllowQuotedNewlines() {
    return allowQuotedNewlines;
  }

  /**
   * Optional. Indicates if BigQuery should allow quoted data sections that contain newline
   * characters in a CSV file. The default value is false.
   * @param allowQuotedNewlines allowQuotedNewlines or {@code null} for none
   */
  public CsvOptions setAllowQuotedNewlines(java.lang.Boolean allowQuotedNewlines) {
    this.allowQuotedNewlines = allowQuotedNewlines;
    return this;
  }

  /**
   * Optional. The character encoding of the data. The supported values are UTF-8, ISO-8859-1, UTF-
   * 16BE, UTF-16LE, UTF-32BE, and UTF-32LE. The default value is UTF-8. BigQuery decodes the data
   * after the raw, binary data has been split using the values of the quote and fieldDelimiter
   * properties.
   * @return value or {@code null} for none
   */
  public java.lang.String getEncoding() {
    return encoding;
  }

  /**
   * Optional. The character encoding of the data. The supported values are UTF-8, ISO-8859-1, UTF-
   * 16BE, UTF-16LE, UTF-32BE, and UTF-32LE. The default value is UTF-8. BigQuery decodes the data
   * after the raw, binary data has been split using the values of the quote and fieldDelimiter
   * properties.
   * @param encoding encoding or {@code null} for none
   */
  public CsvOptions setEncoding(java.lang.String encoding) {
    this.encoding = encoding;
    return this;
  }

  /**
   * Optional. The separator character for fields in a CSV file. The separator is interpreted as a
   * single byte. For files encoded in ISO-8859-1, any single character can be used as a separator.
   * For files encoded in UTF-8, characters represented in decimal range 1-127 (U+0001-U+007F) can
   * be used without any modification. UTF-8 characters encoded with multiple bytes (i.e. U+0080 and
   * above) will have only the first byte used for separating fields. The remaining bytes will be
   * treated as a part of the field. BigQuery also supports the escape sequence "\t" (U+0009) to
   * specify a tab separator. The default value is comma (",", U+002C).
   * @return value or {@code null} for none
   */
  public java.lang.String getFieldDelimiter() {
    return fieldDelimiter;
  }

  /**
   * Optional. The separator character for fields in a CSV file. The separator is interpreted as a
   * single byte. For files encoded in ISO-8859-1, any single character can be used as a separator.
   * For files encoded in UTF-8, characters represented in decimal range 1-127 (U+0001-U+007F) can
   * be used without any modification. UTF-8 characters encoded with multiple bytes (i.e. U+0080 and
   * above) will have only the first byte used for separating fields. The remaining bytes will be
   * treated as a part of the field. BigQuery also supports the escape sequence "\t" (U+0009) to
   * specify a tab separator. The default value is comma (",", U+002C).
   * @param fieldDelimiter fieldDelimiter or {@code null} for none
   */
  public CsvOptions setFieldDelimiter(java.lang.String fieldDelimiter) {
    this.fieldDelimiter = fieldDelimiter;
    return this;
  }

  /**
   * [Optional] A custom string that will represent a NULL value in CSV import data.
   * @return value or {@code null} for none
   */
  public java.lang.String getNullMarker() {
    return nullMarker;
  }

  /**
   * [Optional] A custom string that will represent a NULL value in CSV import data.
   * @param nullMarker nullMarker or {@code null} for none
   */
  public CsvOptions setNullMarker(java.lang.String nullMarker) {
    this.nullMarker = nullMarker;
    return this;
  }

  /**
   * Optional. Indicates if the embedded ASCII control characters (the first 32 characters in the
   * ASCII-table, from '\x00' to '\x1F') are preserved.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPreserveAsciiControlCharacters() {
    return preserveAsciiControlCharacters;
  }

  /**
   * Optional. Indicates if the embedded ASCII control characters (the first 32 characters in the
   * ASCII-table, from '\x00' to '\x1F') are preserved.
   * @param preserveAsciiControlCharacters preserveAsciiControlCharacters or {@code null} for none
   */
  public CsvOptions setPreserveAsciiControlCharacters(java.lang.Boolean preserveAsciiControlCharacters) {
    this.preserveAsciiControlCharacters = preserveAsciiControlCharacters;
    return this;
  }

  /**
   * Optional. The value that is used to quote data sections in a CSV file. BigQuery converts the
   * string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the
   * data in its raw, binary state. The default value is a double-quote ("). If your data does not
   * contain quoted sections, set the property value to an empty string. If your data contains
   * quoted newline characters, you must also set the allowQuotedNewlines property to true. To
   * include the specific quote character within a quoted value, precede it with an additional
   * matching quote character. For example, if you want to escape the default character ' " ', use '
   * "" '.
   * @return value or {@code null} for none
   */
  public java.lang.String getQuote() {
    return quote;
  }

  /**
   * Optional. The value that is used to quote data sections in a CSV file. BigQuery converts the
   * string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the
   * data in its raw, binary state. The default value is a double-quote ("). If your data does not
   * contain quoted sections, set the property value to an empty string. If your data contains
   * quoted newline characters, you must also set the allowQuotedNewlines property to true. To
   * include the specific quote character within a quoted value, precede it with an additional
   * matching quote character. For example, if you want to escape the default character ' " ', use '
   * "" '.
   * @param quote quote or {@code null} for none
   */
  public CsvOptions setQuote(java.lang.String quote) {
    this.quote = quote;
    return this;
  }

  /**
   * Optional. The number of rows at the top of a CSV file that BigQuery will skip when reading the
   * data. The default value is 0. This property is useful if you have header rows in the file that
   * should be skipped. When autodetect is on, the behavior is the following: * skipLeadingRows
   * unspecified - Autodetect tries to detect headers in the first row. If they are not detected,
   * the row is read as data. Otherwise data is read starting from the second row. * skipLeadingRows
   * is 0 - Instructs autodetect that there are no headers and data should be read starting from the
   * first row. * skipLeadingRows = N > 0 - Autodetect skips N-1 rows and tries to detect headers in
   * row N. If headers are not detected, row N is just skipped. Otherwise row N is used to extract
   * column names for the detected schema.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSkipLeadingRows() {
    return skipLeadingRows;
  }

  /**
   * Optional. The number of rows at the top of a CSV file that BigQuery will skip when reading the
   * data. The default value is 0. This property is useful if you have header rows in the file that
   * should be skipped. When autodetect is on, the behavior is the following: * skipLeadingRows
   * unspecified - Autodetect tries to detect headers in the first row. If they are not detected,
   * the row is read as data. Otherwise data is read starting from the second row. * skipLeadingRows
   * is 0 - Instructs autodetect that there are no headers and data should be read starting from the
   * first row. * skipLeadingRows = N > 0 - Autodetect skips N-1 rows and tries to detect headers in
   * row N. If headers are not detected, row N is just skipped. Otherwise row N is used to extract
   * column names for the detected schema.
   * @param skipLeadingRows skipLeadingRows or {@code null} for none
   */
  public CsvOptions setSkipLeadingRows(java.lang.Long skipLeadingRows) {
    this.skipLeadingRows = skipLeadingRows;
    return this;
  }

  @Override
  public CsvOptions set(String fieldName, Object value) {
    return (CsvOptions) super.set(fieldName, value);
  }

  @Override
  public CsvOptions clone() {
    return (CsvOptions) super.clone();
  }

}
