/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for Table.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Table extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Specifies the configuration of a BigLake managed table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BigLakeConfiguration biglakeConfiguration;

  /**
   * Output only. Contains information about the clone. This value is set via the clone operation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CloneDefinition cloneDefinition;

  /**
   * Clustering specification for the table. Must be specified with time-based partitioning, data in
   * the table will be first partitioned and subsequently clustered.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Clustering clustering;

  /**
   * Output only. The time when this table was created, in milliseconds since the epoch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long creationTime;

  /**
   * Optional. Defines the default collation specification of new STRING fields in the table. During
   * table creation or update, if a STRING field is added to this table without explicit collation
   * specified, then the table inherits the table default collation. A change to this field affects
   * only fields added afterwards, and does not alter the existing fields. The following values are
   * supported: * 'und:ci': undetermined locale, case insensitive. * '': empty string. Default to
   * case-sensitive behavior.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String defaultCollation;

  /**
   * Optional. Defines the default rounding mode specification of new decimal fields (NUMERIC OR
   * BIGNUMERIC) in the table. During table creation or update, if a decimal field is added to this
   * table without an explicit rounding mode specified, then the field inherits the table default
   * rounding mode. Changing this field doesn't affect existing fields.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String defaultRoundingMode;

  /**
   * Optional. A user-friendly description of this table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Custom encryption configuration (e.g., Cloud KMS keys).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EncryptionConfiguration encryptionConfiguration;

  /**
   * Output only. A hash of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * Optional. The time when this table expires, in milliseconds since the epoch. If not present,
   * the table will persist indefinitely. Expired tables will be deleted and their storage
   * reclaimed. The defaultTableExpirationMs property of the encapsulating dataset can be used to
   * set a default expirationTime on newly created tables.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long expirationTime;

  /**
   * Optional. Describes the data format, location, and other properties of a table stored outside
   * of BigQuery. By defining these properties, the data source can then be queried as if it were a
   * standard BigQuery table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ExternalDataConfiguration externalDataConfiguration;

  /**
   * Optional. A descriptive name for this table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String friendlyName;

  /**
   * Output only. An opaque ID uniquely identifying the table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The type of resource ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The labels associated with this table. You can use these to organize and group your tables.
   * Label keys and values can be no longer than 63 characters, can only contain lowercase letters,
   * numeric characters, underscores and dashes. International characters are allowed. Label values
   * are optional. Label keys must start with a letter and each label in the list must have a
   * different key.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * Output only. The time when this table was last modified, in milliseconds since the epoch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger lastModifiedTime;

  /**
   * Output only. The geographic location where the table resides. This value is inherited from the
   * dataset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String location;

  /**
   * Optional. The materialized view definition.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MaterializedViewDefinition materializedView;

  /**
   * Output only. The materialized view status.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MaterializedViewStatus materializedViewStatus;

  /**
   * Optional. The maximum staleness of data that could be returned when the table (or stale MV) is
   * queried. Staleness encoded as a string encoding of sql IntervalValue type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String maxStaleness;

  /**
   * Deprecated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ModelDefinition model;

  /**
   * Output only. Number of logical bytes that are less than 90 days old.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long numActiveLogicalBytes;

  /**
   * Output only. Number of physical bytes less than 90 days old. This data is not kept in real
   * time, and might be delayed by a few seconds to a few minutes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long numActivePhysicalBytes;

  /**
   * Output only. The size of this table in logical bytes, excluding any data in the streaming
   * buffer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long numBytes;

  /**
   * Output only. The number of logical bytes in the table that are considered "long-term storage".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long numLongTermBytes;

  /**
   * Output only. Number of logical bytes that are more than 90 days old.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long numLongTermLogicalBytes;

  /**
   * Output only. Number of physical bytes more than 90 days old. This data is not kept in real
   * time, and might be delayed by a few seconds to a few minutes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long numLongTermPhysicalBytes;

  /**
   * Output only. The number of partitions present in the table or materialized view. This data is
   * not kept in real time, and might be delayed by a few seconds to a few minutes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long numPartitions;

  /**
   * Output only. The physical size of this table in bytes. This includes storage used for time
   * travel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long numPhysicalBytes;

  /**
   * Output only. The number of rows of data in this table, excluding any data in the streaming
   * buffer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger numRows;

  /**
   * Output only. Number of physical bytes used by time travel storage (deleted or changed data).
   * This data is not kept in real time, and might be delayed by a few seconds to a few minutes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long numTimeTravelPhysicalBytes;

  /**
   * Output only. Total number of logical bytes in the table or materialized view.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long numTotalLogicalBytes;

  /**
   * Output only. The physical size of this table in bytes. This also includes storage used for time
   * travel. This data is not kept in real time, and might be delayed by a few seconds to a few
   * minutes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long numTotalPhysicalBytes;

  /**
   * If specified, configures range partitioning for this table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RangePartitioning rangePartitioning;

  /**
   * Optional. Output only. Table references of all replicas currently active on the table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TableReference> replicas;

  /**
   * Optional. If set to true, queries over this table require a partition filter that can be used
   * for partition elimination to be specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean requirePartitionFilter;

  /**
   * [Optional] The tags associated with this table. Tag keys are globally unique. See additional
   * information on [tags](https://cloud.google.com/iam/docs/tags-access-control#definitions). An
   * object containing a list of "key": value pairs. The key is the namespaced friendly name of the
   * tag key, e.g. "12345/environment" where 12345 is parent id. The value is the friendly short
   * name of the tag value, e.g. "production".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> resourceTags;

  /**
   * Optional. Describes the schema of this table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableSchema schema;

  /**
   * Output only. A URL that can be used to access this resource again.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Output only. Contains information about the snapshot. This value is set via snapshot creation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SnapshotDefinition snapshotDefinition;

  /**
   * Output only. Contains information regarding this table's streaming buffer, if one is present.
   * This field will be absent if the table is not being streamed to or if there is no data in the
   * streaming buffer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Streamingbuffer streamingBuffer;

  /**
   * Optional. Tables Primary Key and Foreign Key information
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableConstraints tableConstraints;

  /**
   * Required. Reference describing the ID of this table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableReference tableReference;

  /**
   * Optional. Table replication info for table created `AS REPLICA` DDL like: `CREATE MATERIALIZED
   * VIEW mv1 AS REPLICA OF src_mv`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableReplicationInfo tableReplicationInfo;

  /**
   * If specified, configures time-based partitioning for this table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TimePartitioning timePartitioning;

  /**
   * Output only. Describes the table type. The following values are supported: * `TABLE`: A normal
   * BigQuery table. * `VIEW`: A virtual table defined by a SQL query. * `EXTERNAL`: A table that
   * references data stored in an external storage system, such as Google Cloud Storage. *
   * `MATERIALIZED_VIEW`: A precomputed view defined by a SQL query. * `SNAPSHOT`: An immutable
   * BigQuery table that preserves the contents of a base table at a particular time. See additional
   * information on [table snapshots](/bigquery/docs/table-snapshots-intro). The default value is
   * `TABLE`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Optional. The view definition.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ViewDefinition view;

  /**
   * Optional. Specifies the configuration of a BigLake managed table.
   * @return value or {@code null} for none
   */
  public BigLakeConfiguration getBiglakeConfiguration() {
    return biglakeConfiguration;
  }

  /**
   * Optional. Specifies the configuration of a BigLake managed table.
   * @param biglakeConfiguration biglakeConfiguration or {@code null} for none
   */
  public Table setBiglakeConfiguration(BigLakeConfiguration biglakeConfiguration) {
    this.biglakeConfiguration = biglakeConfiguration;
    return this;
  }

  /**
   * Output only. Contains information about the clone. This value is set via the clone operation.
   * @return value or {@code null} for none
   */
  public CloneDefinition getCloneDefinition() {
    return cloneDefinition;
  }

  /**
   * Output only. Contains information about the clone. This value is set via the clone operation.
   * @param cloneDefinition cloneDefinition or {@code null} for none
   */
  public Table setCloneDefinition(CloneDefinition cloneDefinition) {
    this.cloneDefinition = cloneDefinition;
    return this;
  }

  /**
   * Clustering specification for the table. Must be specified with time-based partitioning, data in
   * the table will be first partitioned and subsequently clustered.
   * @return value or {@code null} for none
   */
  public Clustering getClustering() {
    return clustering;
  }

  /**
   * Clustering specification for the table. Must be specified with time-based partitioning, data in
   * the table will be first partitioned and subsequently clustered.
   * @param clustering clustering or {@code null} for none
   */
  public Table setClustering(Clustering clustering) {
    this.clustering = clustering;
    return this;
  }

  /**
   * Output only. The time when this table was created, in milliseconds since the epoch.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCreationTime() {
    return creationTime;
  }

  /**
   * Output only. The time when this table was created, in milliseconds since the epoch.
   * @param creationTime creationTime or {@code null} for none
   */
  public Table setCreationTime(java.lang.Long creationTime) {
    this.creationTime = creationTime;
    return this;
  }

  /**
   * Optional. Defines the default collation specification of new STRING fields in the table. During
   * table creation or update, if a STRING field is added to this table without explicit collation
   * specified, then the table inherits the table default collation. A change to this field affects
   * only fields added afterwards, and does not alter the existing fields. The following values are
   * supported: * 'und:ci': undetermined locale, case insensitive. * '': empty string. Default to
   * case-sensitive behavior.
   * @return value or {@code null} for none
   */
  public java.lang.String getDefaultCollation() {
    return defaultCollation;
  }

  /**
   * Optional. Defines the default collation specification of new STRING fields in the table. During
   * table creation or update, if a STRING field is added to this table without explicit collation
   * specified, then the table inherits the table default collation. A change to this field affects
   * only fields added afterwards, and does not alter the existing fields. The following values are
   * supported: * 'und:ci': undetermined locale, case insensitive. * '': empty string. Default to
   * case-sensitive behavior.
   * @param defaultCollation defaultCollation or {@code null} for none
   */
  public Table setDefaultCollation(java.lang.String defaultCollation) {
    this.defaultCollation = defaultCollation;
    return this;
  }

  /**
   * Optional. Defines the default rounding mode specification of new decimal fields (NUMERIC OR
   * BIGNUMERIC) in the table. During table creation or update, if a decimal field is added to this
   * table without an explicit rounding mode specified, then the field inherits the table default
   * rounding mode. Changing this field doesn't affect existing fields.
   * @return value or {@code null} for none
   */
  public java.lang.String getDefaultRoundingMode() {
    return defaultRoundingMode;
  }

  /**
   * Optional. Defines the default rounding mode specification of new decimal fields (NUMERIC OR
   * BIGNUMERIC) in the table. During table creation or update, if a decimal field is added to this
   * table without an explicit rounding mode specified, then the field inherits the table default
   * rounding mode. Changing this field doesn't affect existing fields.
   * @param defaultRoundingMode defaultRoundingMode or {@code null} for none
   */
  public Table setDefaultRoundingMode(java.lang.String defaultRoundingMode) {
    this.defaultRoundingMode = defaultRoundingMode;
    return this;
  }

  /**
   * Optional. A user-friendly description of this table.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Optional. A user-friendly description of this table.
   * @param description description or {@code null} for none
   */
  public Table setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Custom encryption configuration (e.g., Cloud KMS keys).
   * @return value or {@code null} for none
   */
  public EncryptionConfiguration getEncryptionConfiguration() {
    return encryptionConfiguration;
  }

  /**
   * Custom encryption configuration (e.g., Cloud KMS keys).
   * @param encryptionConfiguration encryptionConfiguration or {@code null} for none
   */
  public Table setEncryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
    this.encryptionConfiguration = encryptionConfiguration;
    return this;
  }

  /**
   * Output only. A hash of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * Output only. A hash of this resource.
   * @param etag etag or {@code null} for none
   */
  public Table setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * Optional. The time when this table expires, in milliseconds since the epoch. If not present,
   * the table will persist indefinitely. Expired tables will be deleted and their storage
   * reclaimed. The defaultTableExpirationMs property of the encapsulating dataset can be used to
   * set a default expirationTime on newly created tables.
   * @return value or {@code null} for none
   */
  public java.lang.Long getExpirationTime() {
    return expirationTime;
  }

  /**
   * Optional. The time when this table expires, in milliseconds since the epoch. If not present,
   * the table will persist indefinitely. Expired tables will be deleted and their storage
   * reclaimed. The defaultTableExpirationMs property of the encapsulating dataset can be used to
   * set a default expirationTime on newly created tables.
   * @param expirationTime expirationTime or {@code null} for none
   */
  public Table setExpirationTime(java.lang.Long expirationTime) {
    this.expirationTime = expirationTime;
    return this;
  }

  /**
   * Optional. Describes the data format, location, and other properties of a table stored outside
   * of BigQuery. By defining these properties, the data source can then be queried as if it were a
   * standard BigQuery table.
   * @return value or {@code null} for none
   */
  public ExternalDataConfiguration getExternalDataConfiguration() {
    return externalDataConfiguration;
  }

  /**
   * Optional. Describes the data format, location, and other properties of a table stored outside
   * of BigQuery. By defining these properties, the data source can then be queried as if it were a
   * standard BigQuery table.
   * @param externalDataConfiguration externalDataConfiguration or {@code null} for none
   */
  public Table setExternalDataConfiguration(ExternalDataConfiguration externalDataConfiguration) {
    this.externalDataConfiguration = externalDataConfiguration;
    return this;
  }

  /**
   * Optional. A descriptive name for this table.
   * @return value or {@code null} for none
   */
  public java.lang.String getFriendlyName() {
    return friendlyName;
  }

  /**
   * Optional. A descriptive name for this table.
   * @param friendlyName friendlyName or {@code null} for none
   */
  public Table setFriendlyName(java.lang.String friendlyName) {
    this.friendlyName = friendlyName;
    return this;
  }

  /**
   * Output only. An opaque ID uniquely identifying the table.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Output only. An opaque ID uniquely identifying the table.
   * @param id id or {@code null} for none
   */
  public Table setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The type of resource ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The type of resource ID.
   * @param kind kind or {@code null} for none
   */
  public Table setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The labels associated with this table. You can use these to organize and group your tables.
   * Label keys and values can be no longer than 63 characters, can only contain lowercase letters,
   * numeric characters, underscores and dashes. International characters are allowed. Label values
   * are optional. Label keys must start with a letter and each label in the list must have a
   * different key.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * The labels associated with this table. You can use these to organize and group your tables.
   * Label keys and values can be no longer than 63 characters, can only contain lowercase letters,
   * numeric characters, underscores and dashes. International characters are allowed. Label values
   * are optional. Label keys must start with a letter and each label in the list must have a
   * different key.
   * @param labels labels or {@code null} for none
   */
  public Table setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * Output only. The time when this table was last modified, in milliseconds since the epoch.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getLastModifiedTime() {
    return lastModifiedTime;
  }

  /**
   * Output only. The time when this table was last modified, in milliseconds since the epoch.
   * @param lastModifiedTime lastModifiedTime or {@code null} for none
   */
  public Table setLastModifiedTime(java.math.BigInteger lastModifiedTime) {
    this.lastModifiedTime = lastModifiedTime;
    return this;
  }

  /**
   * Output only. The geographic location where the table resides. This value is inherited from the
   * dataset.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocation() {
    return location;
  }

  /**
   * Output only. The geographic location where the table resides. This value is inherited from the
   * dataset.
   * @param location location or {@code null} for none
   */
  public Table setLocation(java.lang.String location) {
    this.location = location;
    return this;
  }

  /**
   * Optional. The materialized view definition.
   * @return value or {@code null} for none
   */
  public MaterializedViewDefinition getMaterializedView() {
    return materializedView;
  }

  /**
   * Optional. The materialized view definition.
   * @param materializedView materializedView or {@code null} for none
   */
  public Table setMaterializedView(MaterializedViewDefinition materializedView) {
    this.materializedView = materializedView;
    return this;
  }

  /**
   * Output only. The materialized view status.
   * @return value or {@code null} for none
   */
  public MaterializedViewStatus getMaterializedViewStatus() {
    return materializedViewStatus;
  }

  /**
   * Output only. The materialized view status.
   * @param materializedViewStatus materializedViewStatus or {@code null} for none
   */
  public Table setMaterializedViewStatus(MaterializedViewStatus materializedViewStatus) {
    this.materializedViewStatus = materializedViewStatus;
    return this;
  }

  /**
   * Optional. The maximum staleness of data that could be returned when the table (or stale MV) is
   * queried. Staleness encoded as a string encoding of sql IntervalValue type.
   * @return value or {@code null} for none
   */
  public java.lang.String getMaxStaleness() {
    return maxStaleness;
  }

  /**
   * Optional. The maximum staleness of data that could be returned when the table (or stale MV) is
   * queried. Staleness encoded as a string encoding of sql IntervalValue type.
   * @param maxStaleness maxStaleness or {@code null} for none
   */
  public Table setMaxStaleness(java.lang.String maxStaleness) {
    this.maxStaleness = maxStaleness;
    return this;
  }

  /**
   * Deprecated.
   * @return value or {@code null} for none
   */
  public ModelDefinition getModel() {
    return model;
  }

  /**
   * Deprecated.
   * @param model model or {@code null} for none
   */
  public Table setModel(ModelDefinition model) {
    this.model = model;
    return this;
  }

  /**
   * Output only. Number of logical bytes that are less than 90 days old.
   * @return value or {@code null} for none
   */
  public java.lang.Long getNumActiveLogicalBytes() {
    return numActiveLogicalBytes;
  }

  /**
   * Output only. Number of logical bytes that are less than 90 days old.
   * @param numActiveLogicalBytes numActiveLogicalBytes or {@code null} for none
   */
  public Table setNumActiveLogicalBytes(java.lang.Long numActiveLogicalBytes) {
    this.numActiveLogicalBytes = numActiveLogicalBytes;
    return this;
  }

  /**
   * Output only. Number of physical bytes less than 90 days old. This data is not kept in real
   * time, and might be delayed by a few seconds to a few minutes.
   * @return value or {@code null} for none
   */
  public java.lang.Long getNumActivePhysicalBytes() {
    return numActivePhysicalBytes;
  }

  /**
   * Output only. Number of physical bytes less than 90 days old. This data is not kept in real
   * time, and might be delayed by a few seconds to a few minutes.
   * @param numActivePhysicalBytes numActivePhysicalBytes or {@code null} for none
   */
  public Table setNumActivePhysicalBytes(java.lang.Long numActivePhysicalBytes) {
    this.numActivePhysicalBytes = numActivePhysicalBytes;
    return this;
  }

  /**
   * Output only. The size of this table in logical bytes, excluding any data in the streaming
   * buffer.
   * @return value or {@code null} for none
   */
  public java.lang.Long getNumBytes() {
    return numBytes;
  }

  /**
   * Output only. The size of this table in logical bytes, excluding any data in the streaming
   * buffer.
   * @param numBytes numBytes or {@code null} for none
   */
  public Table setNumBytes(java.lang.Long numBytes) {
    this.numBytes = numBytes;
    return this;
  }

  /**
   * Output only. The number of logical bytes in the table that are considered "long-term storage".
   * @return value or {@code null} for none
   */
  public java.lang.Long getNumLongTermBytes() {
    return numLongTermBytes;
  }

  /**
   * Output only. The number of logical bytes in the table that are considered "long-term storage".
   * @param numLongTermBytes numLongTermBytes or {@code null} for none
   */
  public Table setNumLongTermBytes(java.lang.Long numLongTermBytes) {
    this.numLongTermBytes = numLongTermBytes;
    return this;
  }

  /**
   * Output only. Number of logical bytes that are more than 90 days old.
   * @return value or {@code null} for none
   */
  public java.lang.Long getNumLongTermLogicalBytes() {
    return numLongTermLogicalBytes;
  }

  /**
   * Output only. Number of logical bytes that are more than 90 days old.
   * @param numLongTermLogicalBytes numLongTermLogicalBytes or {@code null} for none
   */
  public Table setNumLongTermLogicalBytes(java.lang.Long numLongTermLogicalBytes) {
    this.numLongTermLogicalBytes = numLongTermLogicalBytes;
    return this;
  }

  /**
   * Output only. Number of physical bytes more than 90 days old. This data is not kept in real
   * time, and might be delayed by a few seconds to a few minutes.
   * @return value or {@code null} for none
   */
  public java.lang.Long getNumLongTermPhysicalBytes() {
    return numLongTermPhysicalBytes;
  }

  /**
   * Output only. Number of physical bytes more than 90 days old. This data is not kept in real
   * time, and might be delayed by a few seconds to a few minutes.
   * @param numLongTermPhysicalBytes numLongTermPhysicalBytes or {@code null} for none
   */
  public Table setNumLongTermPhysicalBytes(java.lang.Long numLongTermPhysicalBytes) {
    this.numLongTermPhysicalBytes = numLongTermPhysicalBytes;
    return this;
  }

  /**
   * Output only. The number of partitions present in the table or materialized view. This data is
   * not kept in real time, and might be delayed by a few seconds to a few minutes.
   * @return value or {@code null} for none
   */
  public java.lang.Long getNumPartitions() {
    return numPartitions;
  }

  /**
   * Output only. The number of partitions present in the table or materialized view. This data is
   * not kept in real time, and might be delayed by a few seconds to a few minutes.
   * @param numPartitions numPartitions or {@code null} for none
   */
  public Table setNumPartitions(java.lang.Long numPartitions) {
    this.numPartitions = numPartitions;
    return this;
  }

  /**
   * Output only. The physical size of this table in bytes. This includes storage used for time
   * travel.
   * @return value or {@code null} for none
   */
  public java.lang.Long getNumPhysicalBytes() {
    return numPhysicalBytes;
  }

  /**
   * Output only. The physical size of this table in bytes. This includes storage used for time
   * travel.
   * @param numPhysicalBytes numPhysicalBytes or {@code null} for none
   */
  public Table setNumPhysicalBytes(java.lang.Long numPhysicalBytes) {
    this.numPhysicalBytes = numPhysicalBytes;
    return this;
  }

  /**
   * Output only. The number of rows of data in this table, excluding any data in the streaming
   * buffer.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getNumRows() {
    return numRows;
  }

  /**
   * Output only. The number of rows of data in this table, excluding any data in the streaming
   * buffer.
   * @param numRows numRows or {@code null} for none
   */
  public Table setNumRows(java.math.BigInteger numRows) {
    this.numRows = numRows;
    return this;
  }

  /**
   * Output only. Number of physical bytes used by time travel storage (deleted or changed data).
   * This data is not kept in real time, and might be delayed by a few seconds to a few minutes.
   * @return value or {@code null} for none
   */
  public java.lang.Long getNumTimeTravelPhysicalBytes() {
    return numTimeTravelPhysicalBytes;
  }

  /**
   * Output only. Number of physical bytes used by time travel storage (deleted or changed data).
   * This data is not kept in real time, and might be delayed by a few seconds to a few minutes.
   * @param numTimeTravelPhysicalBytes numTimeTravelPhysicalBytes or {@code null} for none
   */
  public Table setNumTimeTravelPhysicalBytes(java.lang.Long numTimeTravelPhysicalBytes) {
    this.numTimeTravelPhysicalBytes = numTimeTravelPhysicalBytes;
    return this;
  }

  /**
   * Output only. Total number of logical bytes in the table or materialized view.
   * @return value or {@code null} for none
   */
  public java.lang.Long getNumTotalLogicalBytes() {
    return numTotalLogicalBytes;
  }

  /**
   * Output only. Total number of logical bytes in the table or materialized view.
   * @param numTotalLogicalBytes numTotalLogicalBytes or {@code null} for none
   */
  public Table setNumTotalLogicalBytes(java.lang.Long numTotalLogicalBytes) {
    this.numTotalLogicalBytes = numTotalLogicalBytes;
    return this;
  }

  /**
   * Output only. The physical size of this table in bytes. This also includes storage used for time
   * travel. This data is not kept in real time, and might be delayed by a few seconds to a few
   * minutes.
   * @return value or {@code null} for none
   */
  public java.lang.Long getNumTotalPhysicalBytes() {
    return numTotalPhysicalBytes;
  }

  /**
   * Output only. The physical size of this table in bytes. This also includes storage used for time
   * travel. This data is not kept in real time, and might be delayed by a few seconds to a few
   * minutes.
   * @param numTotalPhysicalBytes numTotalPhysicalBytes or {@code null} for none
   */
  public Table setNumTotalPhysicalBytes(java.lang.Long numTotalPhysicalBytes) {
    this.numTotalPhysicalBytes = numTotalPhysicalBytes;
    return this;
  }

  /**
   * If specified, configures range partitioning for this table.
   * @return value or {@code null} for none
   */
  public RangePartitioning getRangePartitioning() {
    return rangePartitioning;
  }

  /**
   * If specified, configures range partitioning for this table.
   * @param rangePartitioning rangePartitioning or {@code null} for none
   */
  public Table setRangePartitioning(RangePartitioning rangePartitioning) {
    this.rangePartitioning = rangePartitioning;
    return this;
  }

  /**
   * Optional. Output only. Table references of all replicas currently active on the table.
   * @return value or {@code null} for none
   */
  public java.util.List<TableReference> getReplicas() {
    return replicas;
  }

  /**
   * Optional. Output only. Table references of all replicas currently active on the table.
   * @param replicas replicas or {@code null} for none
   */
  public Table setReplicas(java.util.List<TableReference> replicas) {
    this.replicas = replicas;
    return this;
  }

  /**
   * Optional. If set to true, queries over this table require a partition filter that can be used
   * for partition elimination to be specified.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getRequirePartitionFilter() {
    return requirePartitionFilter;
  }

  /**
   * Optional. If set to true, queries over this table require a partition filter that can be used
   * for partition elimination to be specified.
   * @param requirePartitionFilter requirePartitionFilter or {@code null} for none
   */
  public Table setRequirePartitionFilter(java.lang.Boolean requirePartitionFilter) {
    this.requirePartitionFilter = requirePartitionFilter;
    return this;
  }

  /**
   * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
   *
   * <p>
   * Boolean properties can have four possible values:
   * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
   * or {@link Boolean#FALSE}.
   * </p>
   *
   * <p>
   * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
   * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
   * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * </p>
   *
   * <p>
   * Optional. If set to true, queries over this table require a partition filter that can be used for
 partition elimination to be specified.
   * </p>
   */
  public boolean isRequirePartitionFilter() {
    if (requirePartitionFilter == null || requirePartitionFilter == com.google.api.client.util.Data.NULL_BOOLEAN) {
      return false;
    }
    return requirePartitionFilter;
  }

  /**
   * [Optional] The tags associated with this table. Tag keys are globally unique. See additional
   * information on [tags](https://cloud.google.com/iam/docs/tags-access-control#definitions). An
   * object containing a list of "key": value pairs. The key is the namespaced friendly name of the
   * tag key, e.g. "12345/environment" where 12345 is parent id. The value is the friendly short
   * name of the tag value, e.g. "production".
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getResourceTags() {
    return resourceTags;
  }

  /**
   * [Optional] The tags associated with this table. Tag keys are globally unique. See additional
   * information on [tags](https://cloud.google.com/iam/docs/tags-access-control#definitions). An
   * object containing a list of "key": value pairs. The key is the namespaced friendly name of the
   * tag key, e.g. "12345/environment" where 12345 is parent id. The value is the friendly short
   * name of the tag value, e.g. "production".
   * @param resourceTags resourceTags or {@code null} for none
   */
  public Table setResourceTags(java.util.Map<String, java.lang.String> resourceTags) {
    this.resourceTags = resourceTags;
    return this;
  }

  /**
   * Optional. Describes the schema of this table.
   * @return value or {@code null} for none
   */
  public TableSchema getSchema() {
    return schema;
  }

  /**
   * Optional. Describes the schema of this table.
   * @param schema schema or {@code null} for none
   */
  public Table setSchema(TableSchema schema) {
    this.schema = schema;
    return this;
  }

  /**
   * Output only. A URL that can be used to access this resource again.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Output only. A URL that can be used to access this resource again.
   * @param selfLink selfLink or {@code null} for none
   */
  public Table setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Output only. Contains information about the snapshot. This value is set via snapshot creation.
   * @return value or {@code null} for none
   */
  public SnapshotDefinition getSnapshotDefinition() {
    return snapshotDefinition;
  }

  /**
   * Output only. Contains information about the snapshot. This value is set via snapshot creation.
   * @param snapshotDefinition snapshotDefinition or {@code null} for none
   */
  public Table setSnapshotDefinition(SnapshotDefinition snapshotDefinition) {
    this.snapshotDefinition = snapshotDefinition;
    return this;
  }

  /**
   * Output only. Contains information regarding this table's streaming buffer, if one is present.
   * This field will be absent if the table is not being streamed to or if there is no data in the
   * streaming buffer.
   * @return value or {@code null} for none
   */
  public Streamingbuffer getStreamingBuffer() {
    return streamingBuffer;
  }

  /**
   * Output only. Contains information regarding this table's streaming buffer, if one is present.
   * This field will be absent if the table is not being streamed to or if there is no data in the
   * streaming buffer.
   * @param streamingBuffer streamingBuffer or {@code null} for none
   */
  public Table setStreamingBuffer(Streamingbuffer streamingBuffer) {
    this.streamingBuffer = streamingBuffer;
    return this;
  }

  /**
   * Optional. Tables Primary Key and Foreign Key information
   * @return value or {@code null} for none
   */
  public TableConstraints getTableConstraints() {
    return tableConstraints;
  }

  /**
   * Optional. Tables Primary Key and Foreign Key information
   * @param tableConstraints tableConstraints or {@code null} for none
   */
  public Table setTableConstraints(TableConstraints tableConstraints) {
    this.tableConstraints = tableConstraints;
    return this;
  }

  /**
   * Required. Reference describing the ID of this table.
   * @return value or {@code null} for none
   */
  public TableReference getTableReference() {
    return tableReference;
  }

  /**
   * Required. Reference describing the ID of this table.
   * @param tableReference tableReference or {@code null} for none
   */
  public Table setTableReference(TableReference tableReference) {
    this.tableReference = tableReference;
    return this;
  }

  /**
   * Optional. Table replication info for table created `AS REPLICA` DDL like: `CREATE MATERIALIZED
   * VIEW mv1 AS REPLICA OF src_mv`
   * @return value or {@code null} for none
   */
  public TableReplicationInfo getTableReplicationInfo() {
    return tableReplicationInfo;
  }

  /**
   * Optional. Table replication info for table created `AS REPLICA` DDL like: `CREATE MATERIALIZED
   * VIEW mv1 AS REPLICA OF src_mv`
   * @param tableReplicationInfo tableReplicationInfo or {@code null} for none
   */
  public Table setTableReplicationInfo(TableReplicationInfo tableReplicationInfo) {
    this.tableReplicationInfo = tableReplicationInfo;
    return this;
  }

  /**
   * If specified, configures time-based partitioning for this table.
   * @return value or {@code null} for none
   */
  public TimePartitioning getTimePartitioning() {
    return timePartitioning;
  }

  /**
   * If specified, configures time-based partitioning for this table.
   * @param timePartitioning timePartitioning or {@code null} for none
   */
  public Table setTimePartitioning(TimePartitioning timePartitioning) {
    this.timePartitioning = timePartitioning;
    return this;
  }

  /**
   * Output only. Describes the table type. The following values are supported: * `TABLE`: A normal
   * BigQuery table. * `VIEW`: A virtual table defined by a SQL query. * `EXTERNAL`: A table that
   * references data stored in an external storage system, such as Google Cloud Storage. *
   * `MATERIALIZED_VIEW`: A precomputed view defined by a SQL query. * `SNAPSHOT`: An immutable
   * BigQuery table that preserves the contents of a base table at a particular time. See additional
   * information on [table snapshots](/bigquery/docs/table-snapshots-intro). The default value is
   * `TABLE`.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Output only. Describes the table type. The following values are supported: * `TABLE`: A normal
   * BigQuery table. * `VIEW`: A virtual table defined by a SQL query. * `EXTERNAL`: A table that
   * references data stored in an external storage system, such as Google Cloud Storage. *
   * `MATERIALIZED_VIEW`: A precomputed view defined by a SQL query. * `SNAPSHOT`: An immutable
   * BigQuery table that preserves the contents of a base table at a particular time. See additional
   * information on [table snapshots](/bigquery/docs/table-snapshots-intro). The default value is
   * `TABLE`.
   * @param type type or {@code null} for none
   */
  public Table setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * Optional. The view definition.
   * @return value or {@code null} for none
   */
  public ViewDefinition getView() {
    return view;
  }

  /**
   * Optional. The view definition.
   * @param view view or {@code null} for none
   */
  public Table setView(ViewDefinition view) {
    this.view = view;
    return this;
  }

  @Override
  public Table set(String fieldName, Object value) {
    return (Table) super.set(fieldName, value);
  }

  @Override
  public Table clone() {
    return (Table) super.clone();
  }

}
