/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Statistics related to Incremental Query Results. Populated as part of JobStatistics2. This
 * feature is not yet available.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class IncrementalResultStats extends com.google.api.client.json.GenericJson {

  /**
   * Reason why incremental query results are/were not written by the query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String disabledReason;

  /**
   * The time at which the result table's contents were modified. May be absent if no results have
   * been written or the query has completed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String resultSetLastModifyTime;

  /**
   * The time at which the result table's contents were completely replaced. May be absent if no
   * results have been written or the query has completed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String resultSetLastReplaceTime;

  /**
   * Reason why incremental query results are/were not written by the query.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisabledReason() {
    return disabledReason;
  }

  /**
   * Reason why incremental query results are/were not written by the query.
   * @param disabledReason disabledReason or {@code null} for none
   */
  public IncrementalResultStats setDisabledReason(java.lang.String disabledReason) {
    this.disabledReason = disabledReason;
    return this;
  }

  /**
   * The time at which the result table's contents were modified. May be absent if no results have
   * been written or the query has completed.
   * @return value or {@code null} for none
   */
  public String getResultSetLastModifyTime() {
    return resultSetLastModifyTime;
  }

  /**
   * The time at which the result table's contents were modified. May be absent if no results have
   * been written or the query has completed.
   * @param resultSetLastModifyTime resultSetLastModifyTime or {@code null} for none
   */
  public IncrementalResultStats setResultSetLastModifyTime(String resultSetLastModifyTime) {
    this.resultSetLastModifyTime = resultSetLastModifyTime;
    return this;
  }

  /**
   * The time at which the result table's contents were completely replaced. May be absent if no
   * results have been written or the query has completed.
   * @return value or {@code null} for none
   */
  public String getResultSetLastReplaceTime() {
    return resultSetLastReplaceTime;
  }

  /**
   * The time at which the result table's contents were completely replaced. May be absent if no
   * results have been written or the query has completed.
   * @param resultSetLastReplaceTime resultSetLastReplaceTime or {@code null} for none
   */
  public IncrementalResultStats setResultSetLastReplaceTime(String resultSetLastReplaceTime) {
    this.resultSetLastReplaceTime = resultSetLastReplaceTime;
    return this;
  }

  @Override
  public IncrementalResultStats set(String fieldName, Object value) {
    return (IncrementalResultStats) super.set(fieldName, value);
  }

  @Override
  public IncrementalResultStats clone() {
    return (IncrementalResultStats) super.clone();
  }

}
