/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.bigquery;

import com.google.api.client.googleapis.batch.BatchRequest;
import com.google.api.client.googleapis.batch.json.JsonBatchCallback;
import com.google.api.client.googleapis.json.GoogleJsonErrorContainer;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.googleapis.media.MediaHttpDownloader;
import com.google.api.client.googleapis.media.MediaHttpUploader;
import com.google.api.client.googleapis.services.GoogleClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpClient;
import com.google.api.client.http.json.JsonHttpRequest;
import com.google.api.client.http.json.JsonHttpRequestInitializer;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.Key;
import com.google.api.services.bigquery.BigqueryRequest;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetList;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobList;
import com.google.api.services.bigquery.model.ProjectList;
import com.google.api.services.bigquery.model.QueryRequest;
import com.google.api.services.bigquery.model.QueryResponse;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableDataList;
import com.google.api.services.bigquery.model.TableList;
import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedLong;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class Bigquery
extends GoogleClient {
    @Deprecated
    public static final String DEFAULT_BASE_PATH = "/bigquery/v2/";
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "bigquery/v2/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/bigquery/v2/";

    @Deprecated
    public Bigquery(HttpTransport httpTransport, JsonFactory jsonFactory) {
        super(httpTransport, jsonFactory, DEFAULT_BASE_URL);
    }

    public Bigquery(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        super(httpTransport, jsonFactory, DEFAULT_ROOT_URL, DEFAULT_SERVICE_PATH, httpRequestInitializer);
    }

    @Deprecated
    Bigquery(HttpTransport httpTransport, JsonHttpRequestInitializer jsonHttpRequestInitializer, HttpRequestInitializer httpRequestInitializer, JsonFactory jsonFactory, JsonObjectParser jsonObjectParser, String string, String string2) {
        super(httpTransport, jsonHttpRequestInitializer, httpRequestInitializer, jsonFactory, jsonObjectParser, string, string2);
    }

    Bigquery(HttpTransport httpTransport, JsonHttpRequestInitializer jsonHttpRequestInitializer, HttpRequestInitializer httpRequestInitializer, JsonFactory jsonFactory, JsonObjectParser jsonObjectParser, String string, String string2, String string3, boolean bl) {
        super(httpTransport, jsonHttpRequestInitializer, httpRequestInitializer, jsonFactory, jsonObjectParser, string, string2, string3, bl);
    }

    protected void initialize(JsonHttpRequest jsonHttpRequest) throws IOException {
        super.initialize(jsonHttpRequest);
    }

    @Deprecated
    public static Builder builder(HttpTransport httpTransport, JsonFactory jsonFactory) {
        return new Builder(httpTransport, jsonFactory, new GenericUrl(DEFAULT_BASE_URL));
    }

    public Tables tables() {
        return new Tables();
    }

    public Datasets datasets() {
        return new Datasets();
    }

    public Jobs jobs() {
        return new Jobs();
    }

    public Tabledata tabledata() {
        return new Tabledata();
    }

    public Projects projects() {
        return new Projects();
    }

    public static final class Builder
    extends GoogleClient.Builder {
        @Deprecated
        Builder(HttpTransport httpTransport, JsonFactory jsonFactory, GenericUrl genericUrl) {
            super(httpTransport, jsonFactory, genericUrl);
        }

        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Bigquery.DEFAULT_ROOT_URL, Bigquery.DEFAULT_SERVICE_PATH, httpRequestInitializer);
        }

        public Bigquery build() {
            if (this.isBaseUrlUsed()) {
                return new Bigquery(this.getTransport(), this.getJsonHttpRequestInitializer(), this.getHttpRequestInitializer(), this.getJsonFactory(), this.getObjectParser(), this.getBaseUrl().build(), this.getApplicationName());
            }
            return new Bigquery(this.getTransport(), this.getJsonHttpRequestInitializer(), this.getHttpRequestInitializer(), this.getJsonFactory(), this.getObjectParser(), this.getRootUrl(), this.getServicePath(), this.getApplicationName(), this.getSuppressPatternChecks());
        }

        @Deprecated
        public Builder setBaseUrl(GenericUrl genericUrl) {
            super.setBaseUrl(genericUrl);
            return this;
        }

        public Builder setRootUrl(String string) {
            super.setRootUrl(string);
            return this;
        }

        public Builder setServicePath(String string) {
            super.setServicePath(string);
            return this;
        }

        public Builder setJsonHttpRequestInitializer(JsonHttpRequestInitializer jsonHttpRequestInitializer) {
            super.setJsonHttpRequestInitializer(jsonHttpRequestInitializer);
            return this;
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            super.setHttpRequestInitializer(httpRequestInitializer);
            return this;
        }

        public Builder setApplicationName(String string) {
            super.setApplicationName(string);
            return this;
        }

        public Builder setObjectParser(JsonObjectParser jsonObjectParser) {
            super.setObjectParser(jsonObjectParser);
            return this;
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            super.setSuppressPatternChecks(bl);
            return this;
        }
    }

    public class Projects {
        public List list() throws IOException {
            List list = new List();
            Bigquery.this.initialize(list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends BigqueryRequest {
            private static final String REST_PATH = "projects";
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            List() {
                super((JsonHttpClient)Bigquery.this, HttpMethod.GET, REST_PATH, null);
            }

            public ProjectList execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                ProjectList projectList = (ProjectList)((Object)httpResponse.parseAs(ProjectList.class));
                projectList.setResponseHeaders(httpResponse.getHeaders());
                return projectList;
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<ProjectList> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), ProjectList.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            @Override
            public List setFields(String string) {
                super.setFields(string);
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }
        }
    }

    public class Tabledata {
        public List list(String string, String string2, String string3) throws IOException {
            List list = new List(string, string2, string3);
            Bigquery.this.initialize(list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends BigqueryRequest {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}/data";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private UnsignedLong startIndex;

            List(String string, String string2, String string3) {
                super((JsonHttpClient)Bigquery.this, HttpMethod.GET, REST_PATH, null);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
                this.tableId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter tableId must be specified.");
            }

            public TableDataList execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                TableDataList tableDataList = (TableDataList)((Object)httpResponse.parseAs(TableDataList.class));
                tableDataList.setResponseHeaders(httpResponse.getHeaders());
                return tableDataList;
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<TableDataList> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), TableDataList.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            @Override
            public List setFields(String string) {
                super.setFields(string);
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public List setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public List setTableId(String string) {
                this.tableId = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public UnsignedLong getStartIndex() {
                return this.startIndex;
            }

            public List setStartIndex(UnsignedLong unsignedLong) {
                this.startIndex = unsignedLong;
                return this;
            }
        }
    }

    public class Jobs {
        public Insert insert(String string, Job job) throws IOException {
            Insert insert = new Insert(string, job);
            Bigquery.this.initialize(insert);
            return insert;
        }

        public Insert insert(String string, Job job, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
            Insert insert = new Insert(string, job, abstractInputStreamContent);
            Bigquery.this.initialize(insert);
            return insert;
        }

        public Query query(String string, QueryRequest queryRequest) throws IOException {
            Query query = new Query(string, queryRequest);
            Bigquery.this.initialize(query);
            return query;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Bigquery.this.initialize(list);
            return list;
        }

        public GetQueryResults getQueryResults(String string, String string2) throws IOException {
            GetQueryResults getQueryResults = new GetQueryResults(string, string2);
            Bigquery.this.initialize(getQueryResults);
            return getQueryResults;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Bigquery.this.initialize(get);
            return get;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends BigqueryRequest {
            private static final String REST_PATH = "projects/{projectId}/jobs/{jobId}";
            @Key
            private String projectId;
            @Key
            private String jobId;
            private MediaHttpDownloader downloader;

            Get(String string, String string2) {
                super((JsonHttpClient)Bigquery.this, HttpMethod.GET, REST_PATH, null);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.jobId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter jobId must be specified.");
                this.downloader = new MediaHttpDownloader(Bigquery.this.getRequestFactory().getTransport(), Bigquery.this.getRequestFactory().getInitializer());
            }

            public Job execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                Job job = (Job)((Object)httpResponse.parseAs(Job.class));
                job.setResponseHeaders(httpResponse.getHeaders());
                return job;
            }

            @Deprecated
            public InputStream executeAsMedia() throws IOException {
                this.setAlt("media");
                HttpResponse httpResponse = this.executeUnparsed();
                return httpResponse.getContent();
            }

            public void download(OutputStream outputStream) throws IOException {
                this.downloader.download(this.buildHttpRequestUrl(), outputStream);
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<Job> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), Job.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            @Override
            public Get setFields(String string) {
                super.setFields(string);
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getJobId() {
                return this.jobId;
            }

            public Get setJobId(String string) {
                this.jobId = string;
                return this;
            }

            public MediaHttpDownloader getMediaHttpDownloader() {
                return this.downloader;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetQueryResults
        extends BigqueryRequest {
            private static final String REST_PATH = "projects/{projectId}/queries/{jobId}";
            @Key
            private String projectId;
            @Key
            private String jobId;
            @Key
            private Long timeoutMs;
            @Key
            private UnsignedLong startIndex;
            @Key
            private Long maxResults;
            private MediaHttpDownloader downloader;

            GetQueryResults(String string, String string2) {
                super((JsonHttpClient)Bigquery.this, HttpMethod.GET, REST_PATH, null);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.jobId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter jobId must be specified.");
                this.downloader = new MediaHttpDownloader(Bigquery.this.getRequestFactory().getTransport(), Bigquery.this.getRequestFactory().getInitializer());
            }

            public GetQueryResultsResponse execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                GetQueryResultsResponse getQueryResultsResponse = (GetQueryResultsResponse)((Object)httpResponse.parseAs(GetQueryResultsResponse.class));
                getQueryResultsResponse.setResponseHeaders(httpResponse.getHeaders());
                return getQueryResultsResponse;
            }

            @Deprecated
            public InputStream executeAsMedia() throws IOException {
                this.setAlt("media");
                HttpResponse httpResponse = this.executeUnparsed();
                return httpResponse.getContent();
            }

            public void download(OutputStream outputStream) throws IOException {
                this.downloader.download(this.buildHttpRequestUrl(), outputStream);
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<GetQueryResultsResponse> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), GetQueryResultsResponse.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            @Override
            public GetQueryResults setFields(String string) {
                super.setFields(string);
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public GetQueryResults setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getJobId() {
                return this.jobId;
            }

            public GetQueryResults setJobId(String string) {
                this.jobId = string;
                return this;
            }

            public Long getTimeoutMs() {
                return this.timeoutMs;
            }

            public GetQueryResults setTimeoutMs(Long l) {
                this.timeoutMs = l;
                return this;
            }

            public UnsignedLong getStartIndex() {
                return this.startIndex;
            }

            public GetQueryResults setStartIndex(UnsignedLong unsignedLong) {
                this.startIndex = unsignedLong;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public GetQueryResults setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public MediaHttpDownloader getMediaHttpDownloader() {
                return this.downloader;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends BigqueryRequest {
            private static final String REST_PATH = "projects/{projectId}/jobs";
            @Key
            private String projectId;
            @Key
            private String projection;
            @Key
            private java.util.List<String> stateFilter;
            @Key
            private Boolean allUsers;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            List(String string) {
                super((JsonHttpClient)Bigquery.this, HttpMethod.GET, REST_PATH, null);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
            }

            public JobList execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                JobList jobList = (JobList)((Object)httpResponse.parseAs(JobList.class));
                jobList.setResponseHeaders(httpResponse.getHeaders());
                return jobList;
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<JobList> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), JobList.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            @Override
            public List setFields(String string) {
                super.setFields(string);
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public List setProjection(String string) {
                this.projection = string;
                return this;
            }

            public java.util.List<String> getStateFilter() {
                return this.stateFilter;
            }

            public List setStateFilter(java.util.List<String> list) {
                this.stateFilter = list;
                return this;
            }

            public Boolean getAllUsers() {
                return this.allUsers;
            }

            public List setAllUsers(Boolean bl) {
                this.allUsers = bl;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Query
        extends BigqueryRequest {
            private static final String REST_PATH = "projects/{projectId}/queries";
            @Key
            private String projectId;

            Query(String string, QueryRequest queryRequest) {
                super((JsonHttpClient)Bigquery.this, HttpMethod.POST, REST_PATH, (Object)queryRequest);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                Preconditions.checkNotNull((Object)((Object)queryRequest));
            }

            public QueryResponse execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                QueryResponse queryResponse = (QueryResponse)((Object)httpResponse.parseAs(QueryResponse.class));
                queryResponse.setResponseHeaders(httpResponse.getHeaders());
                return queryResponse;
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<QueryResponse> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), QueryResponse.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            @Override
            public Query setFields(String string) {
                super.setFields(string);
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Query setProjectId(String string) {
                this.projectId = string;
                return this;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends BigqueryRequest {
            private static final String REST_PATH = "projects/{projectId}/jobs";
            @Key
            private String projectId;
            private MediaHttpUploader uploader;

            Insert(String string, Job job) {
                super((JsonHttpClient)Bigquery.this, HttpMethod.POST, REST_PATH, (Object)job);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                Preconditions.checkNotNull((Object)((Object)job));
            }

            Insert(String string, Job job, AbstractInputStreamContent abstractInputStreamContent) {
                super((JsonHttpClient)Bigquery.this, HttpMethod.POST, "/upload" + new GenericUrl(Bigquery.this.getBaseUrl()).getRawPath() + REST_PATH, (Object)job);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.uploader = new MediaHttpUploader(abstractInputStreamContent, Bigquery.this.getRequestFactory().getTransport(), Bigquery.this.getRequestFactory().getInitializer());
                this.uploader.setInitiationMethod(HttpMethod.POST);
                if (job != null) {
                    this.uploader.setMetadata((HttpContent)Bigquery.this.createSerializer((Object)job));
                }
            }

            public HttpResponse executeUnparsed() throws IOException {
                if (this.uploader == null) {
                    return super.executeUnparsed();
                }
                HttpResponse httpResponse = this.uploader.upload(this.buildHttpRequestUrl());
                if (!httpResponse.isSuccessStatusCode()) {
                    throw GoogleJsonResponseException.from((JsonFactory)Bigquery.this.getJsonFactory(), (HttpResponse)httpResponse);
                }
                return httpResponse;
            }

            public HttpRequest buildHttpRequest() throws IOException {
                if (this.uploader == null) {
                    return super.buildHttpRequest();
                }
                throw new UnsupportedOperationException();
            }

            public Job execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                Job job = (Job)((Object)Bigquery.this.getJsonHttpParser().parse(httpResponse, Job.class));
                job.setResponseHeaders(httpResponse.getHeaders());
                return job;
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<Job> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), Job.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            @Override
            public Insert setFields(String string) {
                super.setFields(string);
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Insert setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public MediaHttpUploader getMediaHttpUploader() {
                return this.uploader;
            }
        }
    }

    public class Datasets {
        public Insert insert(String string, Dataset dataset) throws IOException {
            Insert insert = new Insert(string, dataset);
            Bigquery.this.initialize(insert);
            return insert;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Bigquery.this.initialize(get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Bigquery.this.initialize(list);
            return list;
        }

        public Update update(String string, String string2, Dataset dataset) throws IOException {
            Update update = new Update(string, string2, dataset);
            Bigquery.this.initialize(update);
            return update;
        }

        public Patch patch(String string, String string2, Dataset dataset) throws IOException {
            Patch patch = new Patch(string, string2, dataset);
            Bigquery.this.initialize(patch);
            return patch;
        }

        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Bigquery.this.initialize(delete);
            return delete;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends BigqueryRequest {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private Boolean deleteContents;

            Delete(String string, String string2) {
                super((JsonHttpClient)Bigquery.this, HttpMethod.DELETE, REST_PATH, null);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
            }

            public void execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                httpResponse.ignore();
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<Void> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), Void.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            @Override
            public Delete setFields(String string) {
                super.setFields(string);
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Delete setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Delete setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            public Boolean getDeleteContents() {
                return this.deleteContents;
            }

            public Delete setDeleteContents(Boolean bl) {
                this.deleteContents = bl;
                return this;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends BigqueryRequest {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;

            Patch(String string, String string2, Dataset dataset) {
                super((JsonHttpClient)Bigquery.this, HttpMethod.PATCH, REST_PATH, (Object)dataset);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
                Preconditions.checkNotNull((Object)((Object)dataset));
            }

            public Dataset execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                Dataset dataset = (Dataset)((Object)httpResponse.parseAs(Dataset.class));
                dataset.setResponseHeaders(httpResponse.getHeaders());
                return dataset;
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<Dataset> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), Dataset.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            @Override
            public Patch setFields(String string) {
                super.setFields(string);
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Patch setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Patch setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends BigqueryRequest {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;

            Update(String string, String string2, Dataset dataset) {
                super((JsonHttpClient)Bigquery.this, HttpMethod.PUT, REST_PATH, (Object)dataset);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
                Preconditions.checkNotNull((Object)((Object)dataset));
            }

            public Dataset execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                Dataset dataset = (Dataset)((Object)httpResponse.parseAs(Dataset.class));
                dataset.setResponseHeaders(httpResponse.getHeaders());
                return dataset;
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<Dataset> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), Dataset.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            @Override
            public Update setFields(String string) {
                super.setFields(string);
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Update setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Update setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends BigqueryRequest {
            private static final String REST_PATH = "projects/{projectId}/datasets";
            @Key
            private String projectId;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            List(String string) {
                super((JsonHttpClient)Bigquery.this, HttpMethod.GET, REST_PATH, null);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
            }

            public DatasetList execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                DatasetList datasetList = (DatasetList)((Object)httpResponse.parseAs(DatasetList.class));
                datasetList.setResponseHeaders(httpResponse.getHeaders());
                return datasetList;
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<DatasetList> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), DatasetList.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            @Override
            public List setFields(String string) {
                super.setFields(string);
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends BigqueryRequest {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;

            Get(String string, String string2) {
                super((JsonHttpClient)Bigquery.this, HttpMethod.GET, REST_PATH, null);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
            }

            public Dataset execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                Dataset dataset = (Dataset)((Object)httpResponse.parseAs(Dataset.class));
                dataset.setResponseHeaders(httpResponse.getHeaders());
                return dataset;
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<Dataset> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), Dataset.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            @Override
            public Get setFields(String string) {
                super.setFields(string);
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Get setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends BigqueryRequest {
            private static final String REST_PATH = "projects/{projectId}/datasets";
            @Key
            private String projectId;

            Insert(String string, Dataset dataset) {
                super((JsonHttpClient)Bigquery.this, HttpMethod.POST, REST_PATH, (Object)dataset);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                Preconditions.checkNotNull((Object)((Object)dataset));
            }

            public Dataset execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                Dataset dataset = (Dataset)((Object)httpResponse.parseAs(Dataset.class));
                dataset.setResponseHeaders(httpResponse.getHeaders());
                return dataset;
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<Dataset> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), Dataset.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            @Override
            public Insert setFields(String string) {
                super.setFields(string);
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Insert setProjectId(String string) {
                this.projectId = string;
                return this;
            }
        }
    }

    public class Tables {
        public Insert insert(String string, String string2, Table table) throws IOException {
            Insert insert = new Insert(string, string2, table);
            Bigquery.this.initialize(insert);
            return insert;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Bigquery.this.initialize(get);
            return get;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Bigquery.this.initialize(list);
            return list;
        }

        public Update update(String string, String string2, String string3, Table table) throws IOException {
            Update update = new Update(string, string2, string3, table);
            Bigquery.this.initialize(update);
            return update;
        }

        public Patch patch(String string, String string2, String string3, Table table) throws IOException {
            Patch patch = new Patch(string, string2, string3, table);
            Bigquery.this.initialize(patch);
            return patch;
        }

        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Bigquery.this.initialize(delete);
            return delete;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends BigqueryRequest {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;

            Delete(String string, String string2, String string3) {
                super((JsonHttpClient)Bigquery.this, HttpMethod.DELETE, REST_PATH, null);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
                this.tableId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter tableId must be specified.");
            }

            public void execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                httpResponse.ignore();
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<Void> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), Void.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            @Override
            public Delete setFields(String string) {
                super.setFields(string);
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Delete setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Delete setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public Delete setTableId(String string) {
                this.tableId = string;
                return this;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends BigqueryRequest {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;

            Patch(String string, String string2, String string3, Table table) {
                super((JsonHttpClient)Bigquery.this, HttpMethod.PATCH, REST_PATH, (Object)table);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
                this.tableId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter tableId must be specified.");
                Preconditions.checkNotNull((Object)((Object)table));
            }

            public Table execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                Table table = (Table)((Object)httpResponse.parseAs(Table.class));
                table.setResponseHeaders(httpResponse.getHeaders());
                return table;
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<Table> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), Table.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            @Override
            public Patch setFields(String string) {
                super.setFields(string);
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Patch setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Patch setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public Patch setTableId(String string) {
                this.tableId = string;
                return this;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends BigqueryRequest {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;

            Update(String string, String string2, String string3, Table table) {
                super((JsonHttpClient)Bigquery.this, HttpMethod.PUT, REST_PATH, (Object)table);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
                this.tableId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter tableId must be specified.");
                Preconditions.checkNotNull((Object)((Object)table));
            }

            public Table execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                Table table = (Table)((Object)httpResponse.parseAs(Table.class));
                table.setResponseHeaders(httpResponse.getHeaders());
                return table;
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<Table> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), Table.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            @Override
            public Update setFields(String string) {
                super.setFields(string);
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Update setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Update setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public Update setTableId(String string) {
                this.tableId = string;
                return this;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends BigqueryRequest {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            List(String string, String string2) {
                super((JsonHttpClient)Bigquery.this, HttpMethod.GET, REST_PATH, null);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
            }

            public TableList execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                TableList tableList = (TableList)((Object)httpResponse.parseAs(TableList.class));
                tableList.setResponseHeaders(httpResponse.getHeaders());
                return tableList;
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<TableList> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), TableList.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            @Override
            public List setFields(String string) {
                super.setFields(string);
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public List setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends BigqueryRequest {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;

            Get(String string, String string2, String string3) {
                super((JsonHttpClient)Bigquery.this, HttpMethod.GET, REST_PATH, null);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
                this.tableId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter tableId must be specified.");
            }

            public Table execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                Table table = (Table)((Object)httpResponse.parseAs(Table.class));
                table.setResponseHeaders(httpResponse.getHeaders());
                return table;
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<Table> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), Table.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            @Override
            public Get setFields(String string) {
                super.setFields(string);
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Get setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public Get setTableId(String string) {
                this.tableId = string;
                return this;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends BigqueryRequest {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables";
            @Key
            private String projectId;
            @Key
            private String datasetId;

            Insert(String string, String string2, Table table) {
                super((JsonHttpClient)Bigquery.this, HttpMethod.POST, REST_PATH, (Object)table);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
                Preconditions.checkNotNull((Object)((Object)table));
            }

            public Table execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                Table table = (Table)((Object)httpResponse.parseAs(Table.class));
                table.setResponseHeaders(httpResponse.getHeaders());
                return table;
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<Table> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), Table.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            @Override
            public Insert setFields(String string) {
                super.setFields(string);
                return this;
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Insert setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Insert setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }
        }
    }
}

