/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-01-30 at 19:00:35 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dns.model;

/**
 * A project resource. The project is a top level container for resources including Cloud DNS
 * ManagedZones. Projects can be created only in the APIs console.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud DNS API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Project extends com.google.api.client.json.GenericJson {

  /**
   * User assigned unique identifier for the resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dns#project".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Unique numeric identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger number;

  /**
   * Quotas assigned to this project (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Quota quota;

  /**
   * User assigned unique identifier for the resource (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * User assigned unique identifier for the resource (output only).
   * @param id id or {@code null} for none
   */
  public Project setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dns#project".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dns#project".
   * @param kind kind or {@code null} for none
   */
  public Project setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Unique numeric identifier for the resource; defined by the server (output only).
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getNumber() {
    return number;
  }

  /**
   * Unique numeric identifier for the resource; defined by the server (output only).
   * @param number number or {@code null} for none
   */
  public Project setNumber(java.math.BigInteger number) {
    this.number = number;
    return this;
  }

  /**
   * Quotas assigned to this project (output only).
   * @return value or {@code null} for none
   */
  public Quota getQuota() {
    return quota;
  }

  /**
   * Quotas assigned to this project (output only).
   * @param quota quota or {@code null} for none
   */
  public Project setQuota(Quota quota) {
    this.quota = quota;
    return this;
  }

  @Override
  public Project set(String fieldName, Object value) {
    return (Project) super.set(fieldName, value);
  }

  @Override
  public Project clone() {
    return (Project) super.clone();
  }

}
