/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-01-30 at 19:00:35 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dns.model;

/**
 * A unit of data that will be returned by the DNS servers.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud DNS API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ResourceRecordSet extends com.google.api.client.json.GenericJson {

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dns#resourceRecordSet".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * For example, www.example.com.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * As defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> rrdatas;

  /**
   * Number of seconds that this ResourceRecordSet can be cached by resolvers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer ttl;

  /**
   * The identifier of a supported record type, for example, A, AAAA, MX, TXT, and so on.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dns#resourceRecordSet".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "dns#resourceRecordSet".
   * @param kind kind or {@code null} for none
   */
  public ResourceRecordSet setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * For example, www.example.com.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * For example, www.example.com.
   * @param name name or {@code null} for none
   */
  public ResourceRecordSet setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * As defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1).
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getRrdatas() {
    return rrdatas;
  }

  /**
   * As defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1).
   * @param rrdatas rrdatas or {@code null} for none
   */
  public ResourceRecordSet setRrdatas(java.util.List<java.lang.String> rrdatas) {
    this.rrdatas = rrdatas;
    return this;
  }

  /**
   * Number of seconds that this ResourceRecordSet can be cached by resolvers.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTtl() {
    return ttl;
  }

  /**
   * Number of seconds that this ResourceRecordSet can be cached by resolvers.
   * @param ttl ttl or {@code null} for none
   */
  public ResourceRecordSet setTtl(java.lang.Integer ttl) {
    this.ttl = ttl;
    return this;
  }

  /**
   * The identifier of a supported record type, for example, A, AAAA, MX, TXT, and so on.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The identifier of a supported record type, for example, A, AAAA, MX, TXT, and so on.
   * @param type type or {@code null} for none
   */
  public ResourceRecordSet setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public ResourceRecordSet set(String fieldName, Object value) {
    return (ResourceRecordSet) super.set(fieldName, value);
  }

  @Override
  public ResourceRecordSet clone() {
    return (ResourceRecordSet) super.clone();
  }

}
