/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.drive;

import com.google.api.client.googleapis.batch.BatchRequest;
import com.google.api.client.googleapis.batch.json.JsonBatchCallback;
import com.google.api.client.googleapis.json.GoogleJsonErrorContainer;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.googleapis.media.MediaHttpDownloader;
import com.google.api.client.googleapis.media.MediaHttpUploader;
import com.google.api.client.googleapis.services.GoogleClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpClient;
import com.google.api.client.http.json.JsonHttpRequest;
import com.google.api.client.http.json.JsonHttpRequestInitializer;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.Data;
import com.google.api.client.util.Key;
import com.google.api.services.drive.DriveRequest;
import com.google.api.services.drive.model.File;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Drive
extends GoogleClient {
    @Deprecated
    public static final String DEFAULT_BASE_PATH = "/drive/v1/";
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "drive/v1/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/drive/v1/";

    @Deprecated
    public Drive(HttpTransport httpTransport, JsonFactory jsonFactory) {
        super(httpTransport, jsonFactory, DEFAULT_BASE_URL);
    }

    public Drive(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        super(httpTransport, jsonFactory, DEFAULT_ROOT_URL, DEFAULT_SERVICE_PATH, httpRequestInitializer);
    }

    @Deprecated
    Drive(HttpTransport httpTransport, JsonHttpRequestInitializer jsonHttpRequestInitializer, HttpRequestInitializer httpRequestInitializer, JsonFactory jsonFactory, JsonObjectParser jsonObjectParser, String string, String string2) {
        super(httpTransport, jsonHttpRequestInitializer, httpRequestInitializer, jsonFactory, jsonObjectParser, string, string2);
    }

    Drive(HttpTransport httpTransport, JsonHttpRequestInitializer jsonHttpRequestInitializer, HttpRequestInitializer httpRequestInitializer, JsonFactory jsonFactory, JsonObjectParser jsonObjectParser, String string, String string2, String string3, boolean bl) {
        super(httpTransport, jsonHttpRequestInitializer, httpRequestInitializer, jsonFactory, jsonObjectParser, string, string2, string3, bl);
    }

    protected void initialize(JsonHttpRequest jsonHttpRequest) throws IOException {
        super.initialize(jsonHttpRequest);
    }

    @Deprecated
    public static Builder builder(HttpTransport httpTransport, JsonFactory jsonFactory) {
        return new Builder(httpTransport, jsonFactory, new GenericUrl(DEFAULT_BASE_URL));
    }

    public Files files() {
        return new Files();
    }

    public static final class Builder
    extends GoogleClient.Builder {
        @Deprecated
        Builder(HttpTransport httpTransport, JsonFactory jsonFactory, GenericUrl genericUrl) {
            super(httpTransport, jsonFactory, genericUrl);
        }

        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Drive.DEFAULT_ROOT_URL, Drive.DEFAULT_SERVICE_PATH, httpRequestInitializer);
        }

        public Drive build() {
            if (this.isBaseUrlUsed()) {
                return new Drive(this.getTransport(), this.getJsonHttpRequestInitializer(), this.getHttpRequestInitializer(), this.getJsonFactory(), this.getObjectParser(), this.getBaseUrl().build(), this.getApplicationName());
            }
            return new Drive(this.getTransport(), this.getJsonHttpRequestInitializer(), this.getHttpRequestInitializer(), this.getJsonFactory(), this.getObjectParser(), this.getRootUrl(), this.getServicePath(), this.getApplicationName(), this.getSuppressPatternChecks());
        }

        @Deprecated
        public Builder setBaseUrl(GenericUrl genericUrl) {
            super.setBaseUrl(genericUrl);
            return this;
        }

        public Builder setRootUrl(String string) {
            super.setRootUrl(string);
            return this;
        }

        public Builder setServicePath(String string) {
            super.setServicePath(string);
            return this;
        }

        public Builder setJsonHttpRequestInitializer(JsonHttpRequestInitializer jsonHttpRequestInitializer) {
            super.setJsonHttpRequestInitializer(jsonHttpRequestInitializer);
            return this;
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            super.setHttpRequestInitializer(httpRequestInitializer);
            return this;
        }

        public Builder setApplicationName(String string) {
            super.setApplicationName(string);
            return this;
        }

        public Builder setObjectParser(JsonObjectParser jsonObjectParser) {
            super.setObjectParser(jsonObjectParser);
            return this;
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            super.setSuppressPatternChecks(bl);
            return this;
        }
    }

    public class Files {
        public Insert insert(File file) throws IOException {
            Insert insert = new Insert(file);
            Drive.this.initialize(insert);
            return insert;
        }

        public Insert insert(File file, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
            Insert insert = new Insert(file, abstractInputStreamContent);
            Drive.this.initialize(insert);
            return insert;
        }

        public Patch patch(String string, File file) throws IOException {
            Patch patch = new Patch(string, file);
            Drive.this.initialize(patch);
            return patch;
        }

        public Update update(String string, File file) throws IOException {
            Update update = new Update(string, file);
            Drive.this.initialize(update);
            return update;
        }

        public Update update(String string, File file, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
            Update update = new Update(string, file, abstractInputStreamContent);
            Drive.this.initialize(update);
            return update;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Drive.this.initialize(get);
            return get;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DriveRequest {
            private static final String REST_PATH = "files/{id}";
            @Key
            private String id;
            @Key
            private Boolean updateViewedDate;
            @Key
            private String projection;
            private MediaHttpDownloader downloader;

            Get(String string) {
                super((JsonHttpClient)Drive.this, HttpMethod.GET, REST_PATH, null);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                this.downloader = new MediaHttpDownloader(Drive.this.getRequestFactory().getTransport(), Drive.this.getRequestFactory().getInitializer());
            }

            public File execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                File file = (File)((Object)httpResponse.parseAs(File.class));
                file.setResponseHeaders(httpResponse.getHeaders());
                return file;
            }

            @Deprecated
            public InputStream executeAsMedia() throws IOException {
                this.setAlt("media");
                HttpResponse httpResponse = this.executeUnparsed();
                return httpResponse.getContent();
            }

            public void download(OutputStream outputStream) throws IOException {
                this.downloader.download(this.buildHttpRequestUrl(), outputStream);
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<File> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), File.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            @Override
            public Get setFields(String string) {
                super.setFields(string);
                return this;
            }

            public String getId() {
                return this.id;
            }

            public Get setId(String string) {
                this.id = string;
                return this;
            }

            public Boolean getUpdateViewedDate() {
                return this.updateViewedDate;
            }

            public Get setUpdateViewedDate(Boolean bl) {
                this.updateViewedDate = bl;
                return this;
            }

            public boolean isUpdateViewedDate() {
                if (this.updateViewedDate == null || this.updateViewedDate == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.updateViewedDate;
            }

            public String getProjection() {
                return this.projection;
            }

            public Get setProjection(String string) {
                this.projection = string;
                return this;
            }

            public MediaHttpDownloader getMediaHttpDownloader() {
                return this.downloader;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DriveRequest {
            private static final String REST_PATH = "files/{id}";
            @Key
            private String id;
            @Key
            private Boolean updateViewedDate;
            @Key
            private Boolean updateModifiedDate;
            @Key
            private Boolean newRevision;
            private MediaHttpUploader uploader;

            Update(String string, File file) {
                super((JsonHttpClient)Drive.this, HttpMethod.PUT, REST_PATH, (Object)file);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                Preconditions.checkNotNull((Object)((Object)file));
            }

            Update(String string, File file, AbstractInputStreamContent abstractInputStreamContent) {
                super((JsonHttpClient)Drive.this, HttpMethod.PUT, "/upload" + new GenericUrl(Drive.this.getBaseUrl()).getRawPath() + REST_PATH, (Object)file);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                this.uploader = new MediaHttpUploader(abstractInputStreamContent, Drive.this.getRequestFactory().getTransport(), Drive.this.getRequestFactory().getInitializer());
                this.uploader.setInitiationMethod(HttpMethod.PUT);
                if (file != null) {
                    this.uploader.setMetadata((HttpContent)Drive.this.createSerializer((Object)file));
                }
            }

            public HttpResponse executeUnparsed() throws IOException {
                if (this.uploader == null) {
                    return super.executeUnparsed();
                }
                HttpResponse httpResponse = this.uploader.upload(this.buildHttpRequestUrl());
                if (!httpResponse.isSuccessStatusCode()) {
                    throw GoogleJsonResponseException.from((JsonFactory)Drive.this.getJsonFactory(), (HttpResponse)httpResponse);
                }
                return httpResponse;
            }

            public HttpRequest buildHttpRequest() throws IOException {
                if (this.uploader == null) {
                    return super.buildHttpRequest();
                }
                throw new UnsupportedOperationException();
            }

            public File execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                File file = (File)((Object)Drive.this.getJsonHttpParser().parse(httpResponse, File.class));
                file.setResponseHeaders(httpResponse.getHeaders());
                return file;
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<File> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), File.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            @Override
            public Update setFields(String string) {
                super.setFields(string);
                return this;
            }

            public String getId() {
                return this.id;
            }

            public Update setId(String string) {
                this.id = string;
                return this;
            }

            public Boolean getUpdateViewedDate() {
                return this.updateViewedDate;
            }

            public Update setUpdateViewedDate(Boolean bl) {
                this.updateViewedDate = bl;
                return this;
            }

            public boolean isUpdateViewedDate() {
                if (this.updateViewedDate == null || this.updateViewedDate == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.updateViewedDate;
            }

            public Boolean getUpdateModifiedDate() {
                return this.updateModifiedDate;
            }

            public Update setUpdateModifiedDate(Boolean bl) {
                this.updateModifiedDate = bl;
                return this;
            }

            public boolean isUpdateModifiedDate() {
                if (this.updateModifiedDate == null || this.updateModifiedDate == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.updateModifiedDate;
            }

            public Boolean getNewRevision() {
                return this.newRevision;
            }

            public Update setNewRevision(Boolean bl) {
                this.newRevision = bl;
                return this;
            }

            public boolean isNewRevision() {
                if (this.newRevision == null || this.newRevision == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.newRevision;
            }

            public MediaHttpUploader getMediaHttpUploader() {
                return this.uploader;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends DriveRequest {
            private static final String REST_PATH = "files/{id}";
            @Key
            private String id;
            @Key
            private Boolean updateViewedDate;
            @Key
            private Boolean updateModifiedDate;
            @Key
            private Boolean newRevision;

            Patch(String string, File file) {
                super((JsonHttpClient)Drive.this, HttpMethod.PATCH, REST_PATH, (Object)file);
                this.id = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter id must be specified.");
                Preconditions.checkNotNull((Object)((Object)file));
            }

            public File execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                File file = (File)((Object)httpResponse.parseAs(File.class));
                file.setResponseHeaders(httpResponse.getHeaders());
                return file;
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<File> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), File.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            @Override
            public Patch setFields(String string) {
                super.setFields(string);
                return this;
            }

            public String getId() {
                return this.id;
            }

            public Patch setId(String string) {
                this.id = string;
                return this;
            }

            public Boolean getUpdateViewedDate() {
                return this.updateViewedDate;
            }

            public Patch setUpdateViewedDate(Boolean bl) {
                this.updateViewedDate = bl;
                return this;
            }

            public boolean isUpdateViewedDate() {
                if (this.updateViewedDate == null || this.updateViewedDate == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.updateViewedDate;
            }

            public Boolean getUpdateModifiedDate() {
                return this.updateModifiedDate;
            }

            public Patch setUpdateModifiedDate(Boolean bl) {
                this.updateModifiedDate = bl;
                return this;
            }

            public boolean isUpdateModifiedDate() {
                if (this.updateModifiedDate == null || this.updateModifiedDate == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.updateModifiedDate;
            }

            public Boolean getNewRevision() {
                return this.newRevision;
            }

            public Patch setNewRevision(Boolean bl) {
                this.newRevision = bl;
                return this;
            }

            public boolean isNewRevision() {
                if (this.newRevision == null || this.newRevision == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.newRevision;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends DriveRequest {
            private static final String REST_PATH = "files";
            private MediaHttpUploader uploader;

            Insert(File file) {
                super((JsonHttpClient)Drive.this, HttpMethod.POST, REST_PATH, (Object)file);
                Preconditions.checkNotNull((Object)((Object)file));
            }

            Insert(File file, AbstractInputStreamContent abstractInputStreamContent) {
                super((JsonHttpClient)Drive.this, HttpMethod.POST, "/upload" + new GenericUrl(Drive.this.getBaseUrl()).getRawPath() + REST_PATH, (Object)file);
                this.uploader = new MediaHttpUploader(abstractInputStreamContent, Drive.this.getRequestFactory().getTransport(), Drive.this.getRequestFactory().getInitializer());
                this.uploader.setInitiationMethod(HttpMethod.POST);
                if (file != null) {
                    this.uploader.setMetadata((HttpContent)Drive.this.createSerializer((Object)file));
                }
            }

            public HttpResponse executeUnparsed() throws IOException {
                if (this.uploader == null) {
                    return super.executeUnparsed();
                }
                HttpResponse httpResponse = this.uploader.upload(this.buildHttpRequestUrl());
                if (!httpResponse.isSuccessStatusCode()) {
                    throw GoogleJsonResponseException.from((JsonFactory)Drive.this.getJsonFactory(), (HttpResponse)httpResponse);
                }
                return httpResponse;
            }

            public HttpRequest buildHttpRequest() throws IOException {
                if (this.uploader == null) {
                    return super.buildHttpRequest();
                }
                throw new UnsupportedOperationException();
            }

            public File execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                File file = (File)((Object)Drive.this.getJsonHttpParser().parse(httpResponse, File.class));
                file.setResponseHeaders(httpResponse.getHeaders());
                return file;
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<File> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), File.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            @Override
            public Insert setFields(String string) {
                super.setFields(string);
                return this;
            }

            public MediaHttpUploader getMediaHttpUploader() {
                return this.uploader;
            }
        }
    }
}

