/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.drive.model;


import com.google.api.client.http.HttpHeaders;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonString;
import com.google.api.client.util.DateTime;


/**
 * A single revision of a file.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * @author Google, Inc.
 */
public final class Revision extends GenericJson {


  /**
   * The MIME type of the revision.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String mimeType;



  /**
   * Whether this revision is pinned to prevent automatic purging. This will only be populated on
   * files with content stored in Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Boolean pinned;



  /**
   * This is always drive#revision.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;



  /**
   * A link to the published revision.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String publishedLink;



  /**
   * Whether this revision is published outside the domain.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Boolean publishedOutsideDomain;



  /**
   * Whether subsequent revisions will be automatically republished.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Boolean publishAuto;



  /**
   * Whether this revision is published. This is only populated for Google Docs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Boolean published;



  /**
   * Short term download URL for the file. This will only be populated on files with content stored
   * in Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String downloadUrl;



  /**
   * A link back to this revision.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;



  /**
   * The ETag of the revision.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String etag;



  /**
   * The size of the revision in bytes. This will only be populated on files with content stored in
   * Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @JsonString
  private Long fileSize;



  /**
   * Links for exporting Google Docs to specific formats.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, String> exportLinks;



  /**
   * Name of the last user to modify this revision.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String lastModifyingUserName;



  /**
   * The original filename when this revision was created. This will only be populated on files with
   * content stored in Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String originalFilename;



  /**
   * The ID of the revision.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String id;



  /**
   * An MD5 checksum for the content of this revision. This will only be populated on files with
   * content stored in Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String md5Checksum;



  /**
   * Last time this revision was modified (formatted RFC 3339 timestamp).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime modifiedDate;




  /**
   * The MIME type of the revision.
   * The value returned may be {@code null}.
   */
  public String getMimeType() {
    return mimeType;
  }

  /**
   * The MIME type of the revision.
   * The value set may be {@code null}.
   */
  public Revision setMimeType(String mimeType) {
    this.mimeType = mimeType;
    return this;
  }

  /**
   * Whether this revision is pinned to prevent automatic purging. This will only be populated on
   * files with content stored in Drive.
   * The value returned may be {@code null}.
   */
  public Boolean getPinned() {
    return pinned;
  }

  /**
   * Whether this revision is pinned to prevent automatic purging. This will only be populated on
   * files with content stored in Drive.
   * The value set may be {@code null}.
   */
  public Revision setPinned(Boolean pinned) {
    this.pinned = pinned;
    return this;
  }

  /**
   * This is always drive#revision.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * This is always drive#revision.
   * The value set may be {@code null}.
   */
  public Revision setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * A link to the published revision.
   * The value returned may be {@code null}.
   */
  public String getPublishedLink() {
    return publishedLink;
  }

  /**
   * A link to the published revision.
   * The value set may be {@code null}.
   */
  public Revision setPublishedLink(String publishedLink) {
    this.publishedLink = publishedLink;
    return this;
  }

  /**
   * Whether this revision is published outside the domain.
   * The value returned may be {@code null}.
   */
  public Boolean getPublishedOutsideDomain() {
    return publishedOutsideDomain;
  }

  /**
   * Whether this revision is published outside the domain.
   * The value set may be {@code null}.
   */
  public Revision setPublishedOutsideDomain(Boolean publishedOutsideDomain) {
    this.publishedOutsideDomain = publishedOutsideDomain;
    return this;
  }

  /**
   * Whether subsequent revisions will be automatically republished.
   * The value returned may be {@code null}.
   */
  public Boolean getPublishAuto() {
    return publishAuto;
  }

  /**
   * Whether subsequent revisions will be automatically republished.
   * The value set may be {@code null}.
   */
  public Revision setPublishAuto(Boolean publishAuto) {
    this.publishAuto = publishAuto;
    return this;
  }

  /**
   * Whether this revision is published. This is only populated for Google Docs.
   * The value returned may be {@code null}.
   */
  public Boolean getPublished() {
    return published;
  }

  /**
   * Whether this revision is published. This is only populated for Google Docs.
   * The value set may be {@code null}.
   */
  public Revision setPublished(Boolean published) {
    this.published = published;
    return this;
  }

  /**
   * Short term download URL for the file. This will only be populated on files with content stored
   * in Drive.
   * The value returned may be {@code null}.
   */
  public String getDownloadUrl() {
    return downloadUrl;
  }

  /**
   * Short term download URL for the file. This will only be populated on files with content stored
   * in Drive.
   * The value set may be {@code null}.
   */
  public Revision setDownloadUrl(String downloadUrl) {
    this.downloadUrl = downloadUrl;
    return this;
  }

  /**
   * A link back to this revision.
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * A link back to this revision.
   * The value set may be {@code null}.
   */
  public Revision setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The ETag of the revision.
   * The value returned may be {@code null}.
   */
  public String getEtag() {
    return etag;
  }

  /**
   * The ETag of the revision.
   * The value set may be {@code null}.
   */
  public Revision setEtag(String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The size of the revision in bytes. This will only be populated on files with content stored in
   * Drive.
   * The value returned may be {@code null}.
   */
  public Long getFileSize() {
    return fileSize;
  }

  /**
   * The size of the revision in bytes. This will only be populated on files with content stored in
   * Drive.
   * The value set may be {@code null}.
   */
  public Revision setFileSize(Long fileSize) {
    this.fileSize = fileSize;
    return this;
  }

  /**
   * Links for exporting Google Docs to specific formats.
   * The value returned may be {@code null}.
   */
  public java.util.Map<String, String> getExportLinks() {
    return exportLinks;
  }

  /**
   * Links for exporting Google Docs to specific formats.
   * The value set may be {@code null}.
   */
  public Revision setExportLinks(java.util.Map<String, String> exportLinks) {
    this.exportLinks = exportLinks;
    return this;
  }

  /**
   * Name of the last user to modify this revision.
   * The value returned may be {@code null}.
   */
  public String getLastModifyingUserName() {
    return lastModifyingUserName;
  }

  /**
   * Name of the last user to modify this revision.
   * The value set may be {@code null}.
   */
  public Revision setLastModifyingUserName(String lastModifyingUserName) {
    this.lastModifyingUserName = lastModifyingUserName;
    return this;
  }

  /**
   * The original filename when this revision was created. This will only be populated on files with
   * content stored in Drive.
   * The value returned may be {@code null}.
   */
  public String getOriginalFilename() {
    return originalFilename;
  }

  /**
   * The original filename when this revision was created. This will only be populated on files with
   * content stored in Drive.
   * The value set may be {@code null}.
   */
  public Revision setOriginalFilename(String originalFilename) {
    this.originalFilename = originalFilename;
    return this;
  }

  /**
   * The ID of the revision.
   * The value returned may be {@code null}.
   */
  public String getId() {
    return id;
  }

  /**
   * The ID of the revision.
   * The value set may be {@code null}.
   */
  public Revision setId(String id) {
    this.id = id;
    return this;
  }

  /**
   * An MD5 checksum for the content of this revision. This will only be populated on files with
   * content stored in Drive.
   * The value returned may be {@code null}.
   */
  public String getMd5Checksum() {
    return md5Checksum;
  }

  /**
   * An MD5 checksum for the content of this revision. This will only be populated on files with
   * content stored in Drive.
   * The value set may be {@code null}.
   */
  public Revision setMd5Checksum(String md5Checksum) {
    this.md5Checksum = md5Checksum;
    return this;
  }

  /**
   * Last time this revision was modified (formatted RFC 3339 timestamp).
   * The value returned may be {@code null}.
   */
  public DateTime getModifiedDate() {
    return modifiedDate;
  }

  /**
   * Last time this revision was modified (formatted RFC 3339 timestamp).
   * The value set may be {@code null}.
   */
  public Revision setModifiedDate(DateTime modifiedDate) {
    this.modifiedDate = modifiedDate;
    return this;
  }


  private HttpHeaders responseHeaders;

  /**
   * Sets the HTTP headers returned with the server response, or <code>null</code>.
   *
   * This member should only be non-null if this object was the top level element of a response. For
   * example, a request that returns a single {@link Revision} would include the response headers,
   * while a request which returns an array of {@link Revision}, would have a non-null response
   * header in the enclosing object only.
   */
  public void setResponseHeaders(HttpHeaders responseHeaders) {
    this.responseHeaders = responseHeaders;
  }

  /**
   * Returns the HTTP headers that were returned with the server response, or
   * <code>null</code>.
   */
  public HttpHeaders getResponseHeaders() {
    return responseHeaders;
  }

















}
