/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2013-12-19 23:55:21 UTC)
 * on 2014-01-30 at 03:46:11 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.oauth2.model;

/**
 * Model definition for Userinfo.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google OAuth2 API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Userinfo extends com.google.api.client.json.GenericJson {

  /**
   * The user's email address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String email;

  /**
   * The user's last name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("family_name")
  private java.lang.String familyName;

  /**
   * The user's gender.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String gender;

  /**
   * The user's first name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("given_name")
  private java.lang.String givenName;

  /**
   * The hosted domain e.g. example.com if the user is Google apps user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String hd;

  /**
   * The focus obfuscated gaia id of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * URL of the profile page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String link;

  /**
   * The user's default locale.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String locale;

  /**
   * The user's full name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * URL of the user's picture image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String picture;

  /**
   * The user's default timezone.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String timezone;

  /**
   * Boolean flag which is true if the email address is verified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("verified_email")
  private java.lang.Boolean verifiedEmail;

  /**
   * The user's email address.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmail() {
    return email;
  }

  /**
   * The user's email address.
   * @param email email or {@code null} for none
   */
  public Userinfo setEmail(java.lang.String email) {
    this.email = email;
    return this;
  }

  /**
   * The user's last name.
   * @return value or {@code null} for none
   */
  public java.lang.String getFamilyName() {
    return familyName;
  }

  /**
   * The user's last name.
   * @param familyName familyName or {@code null} for none
   */
  public Userinfo setFamilyName(java.lang.String familyName) {
    this.familyName = familyName;
    return this;
  }

  /**
   * The user's gender.
   * @return value or {@code null} for none
   */
  public java.lang.String getGender() {
    return gender;
  }

  /**
   * The user's gender.
   * @param gender gender or {@code null} for none
   */
  public Userinfo setGender(java.lang.String gender) {
    this.gender = gender;
    return this;
  }

  /**
   * The user's first name.
   * @return value or {@code null} for none
   */
  public java.lang.String getGivenName() {
    return givenName;
  }

  /**
   * The user's first name.
   * @param givenName givenName or {@code null} for none
   */
  public Userinfo setGivenName(java.lang.String givenName) {
    this.givenName = givenName;
    return this;
  }

  /**
   * The hosted domain e.g. example.com if the user is Google apps user.
   * @return value or {@code null} for none
   */
  public java.lang.String getHd() {
    return hd;
  }

  /**
   * The hosted domain e.g. example.com if the user is Google apps user.
   * @param hd hd or {@code null} for none
   */
  public Userinfo setHd(java.lang.String hd) {
    this.hd = hd;
    return this;
  }

  /**
   * The focus obfuscated gaia id of the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The focus obfuscated gaia id of the user.
   * @param id id or {@code null} for none
   */
  public Userinfo setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * URL of the profile page.
   * @return value or {@code null} for none
   */
  public java.lang.String getLink() {
    return link;
  }

  /**
   * URL of the profile page.
   * @param link link or {@code null} for none
   */
  public Userinfo setLink(java.lang.String link) {
    this.link = link;
    return this;
  }

  /**
   * The user's default locale.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocale() {
    return locale;
  }

  /**
   * The user's default locale.
   * @param locale locale or {@code null} for none
   */
  public Userinfo setLocale(java.lang.String locale) {
    this.locale = locale;
    return this;
  }

  /**
   * The user's full name.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The user's full name.
   * @param name name or {@code null} for none
   */
  public Userinfo setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * URL of the user's picture image.
   * @return value or {@code null} for none
   */
  public java.lang.String getPicture() {
    return picture;
  }

  /**
   * URL of the user's picture image.
   * @param picture picture or {@code null} for none
   */
  public Userinfo setPicture(java.lang.String picture) {
    this.picture = picture;
    return this;
  }

  /**
   * The user's default timezone.
   * @return value or {@code null} for none
   */
  public java.lang.String getTimezone() {
    return timezone;
  }

  /**
   * The user's default timezone.
   * @param timezone timezone or {@code null} for none
   */
  public Userinfo setTimezone(java.lang.String timezone) {
    this.timezone = timezone;
    return this;
  }

  /**
   * Boolean flag which is true if the email address is verified.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getVerifiedEmail() {
    return verifiedEmail;
  }

  /**
   * Boolean flag which is true if the email address is verified.
   * @param verifiedEmail verifiedEmail or {@code null} for none
   */
  public Userinfo setVerifiedEmail(java.lang.Boolean verifiedEmail) {
    this.verifiedEmail = verifiedEmail;
    return this;
  }

  @Override
  public Userinfo set(String fieldName, Object value) {
    return (Userinfo) super.set(fieldName, value);
  }

  @Override
  public Userinfo clone() {
    return (Userinfo) super.clone();
  }

}
