/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-08-21 at 22:31:28 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.oauth2;

/**
 * Available OAuth 2.0 scopes for use with the Google OAuth2 API.
 *
 * @since 1.4
 */
public class Oauth2Scopes {

  /** Know your basic profile info and list of people in your circles.. */
  public static final String PLUS_LOGIN = "https://www.googleapis.com/auth/plus.login";

  /** Know who you are on Google. */
  public static final String PLUS_ME = "https://www.googleapis.com/auth/plus.me";

  /** View your email address. */
  public static final String USERINFO_EMAIL = "https://www.googleapis.com/auth/userinfo.email";

  /** View your basic profile info. */
  public static final String USERINFO_PROFILE = "https://www.googleapis.com/auth/userinfo.profile";

  /**
   * Returns an unmodifiable set that contains all scopes declared by this class.
   *
   * @since 1.16
   */
  public static java.util.Set<String> all() {
    java.util.Set<String> set = new java.util.HashSet<String>();
    set.add(PLUS_LOGIN);
    set.add(PLUS_ME);
    set.add(USERINFO_EMAIL);
    set.add(USERINFO_PROFILE);
    return java.util.Collections.unmodifiableSet(set);
  }

  private Oauth2Scopes() {
  }
}
