/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.people.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.people.v1.PeopleServiceRequest;
import com.google.api.services.people.v1.PeopleServiceRequestInitializer;
import com.google.api.services.people.v1.model.BatchCreateContactsRequest;
import com.google.api.services.people.v1.model.BatchCreateContactsResponse;
import com.google.api.services.people.v1.model.BatchDeleteContactsRequest;
import com.google.api.services.people.v1.model.BatchGetContactGroupsResponse;
import com.google.api.services.people.v1.model.BatchUpdateContactsRequest;
import com.google.api.services.people.v1.model.BatchUpdateContactsResponse;
import com.google.api.services.people.v1.model.ContactGroup;
import com.google.api.services.people.v1.model.CopyOtherContactToMyContactsGroupRequest;
import com.google.api.services.people.v1.model.CreateContactGroupRequest;
import com.google.api.services.people.v1.model.DeleteContactPhotoResponse;
import com.google.api.services.people.v1.model.Empty;
import com.google.api.services.people.v1.model.GetPeopleResponse;
import com.google.api.services.people.v1.model.ListConnectionsResponse;
import com.google.api.services.people.v1.model.ListContactGroupsResponse;
import com.google.api.services.people.v1.model.ListDirectoryPeopleResponse;
import com.google.api.services.people.v1.model.ListOtherContactsResponse;
import com.google.api.services.people.v1.model.ModifyContactGroupMembersRequest;
import com.google.api.services.people.v1.model.ModifyContactGroupMembersResponse;
import com.google.api.services.people.v1.model.Person;
import com.google.api.services.people.v1.model.SearchDirectoryPeopleResponse;
import com.google.api.services.people.v1.model.SearchResponse;
import com.google.api.services.people.v1.model.UpdateContactGroupRequest;
import com.google.api.services.people.v1.model.UpdateContactPhotoRequest;
import com.google.api.services.people.v1.model.UpdateContactPhotoResponse;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;

public class PeopleService
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://people.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://people.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://people.googleapis.com/";

    public PeopleService(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    PeopleService(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public ContactGroups contactGroups() {
        return new ContactGroups();
    }

    public OtherContacts otherContacts() {
        return new OtherContacts();
    }

    public People people() {
        return new People();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the People API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return PeopleService.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://people.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), PeopleService.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(PeopleService.DEFAULT_BATCH_PATH);
        }

        public PeopleService build() {
            return new PeopleService(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setPeopleServiceRequestInitializer(PeopleServiceRequestInitializer peopleserviceRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)peopleserviceRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class People {
        public BatchCreateContacts batchCreateContacts(BatchCreateContactsRequest content) throws IOException {
            BatchCreateContacts result = new BatchCreateContacts(content);
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public BatchDeleteContacts batchDeleteContacts(BatchDeleteContactsRequest content) throws IOException {
            BatchDeleteContacts result = new BatchDeleteContacts(content);
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public BatchUpdateContacts batchUpdateContacts(BatchUpdateContactsRequest content) throws IOException {
            BatchUpdateContacts result = new BatchUpdateContacts(content);
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public CreateContact createContact(Person content) throws IOException {
            CreateContact result = new CreateContact(content);
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public DeleteContact deleteContact(String resourceName) throws IOException {
            DeleteContact result = new DeleteContact(resourceName);
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public DeleteContactPhoto deleteContactPhoto(String resourceName) throws IOException {
            DeleteContactPhoto result = new DeleteContactPhoto(resourceName);
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String resourceName) throws IOException {
            Get result = new Get(resourceName);
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetBatchGet getBatchGet() throws IOException {
            GetBatchGet result = new GetBatchGet();
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ListDirectoryPeople listDirectoryPeople() throws IOException {
            ListDirectoryPeople result = new ListDirectoryPeople();
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SearchContacts searchContacts() throws IOException {
            SearchContacts result = new SearchContacts();
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SearchDirectoryPeople searchDirectoryPeople() throws IOException {
            SearchDirectoryPeople result = new SearchDirectoryPeople();
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public UpdateContact updateContact(String resourceName, Person content) throws IOException {
            UpdateContact result = new UpdateContact(resourceName, content);
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public UpdateContactPhoto updateContactPhoto(String resourceName, UpdateContactPhotoRequest content) throws IOException {
            UpdateContactPhoto result = new UpdateContactPhoto(resourceName, content);
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Connections connections() {
            return new Connections();
        }

        public class Connections {
            public List list(String resourceName) throws IOException {
                List result = new List(resourceName);
                PeopleService.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends PeopleServiceRequest<ListConnectionsResponse> {
                private static final String REST_PATH = "v1/{+resourceName}/connections";
                private final Pattern RESOURCE_NAME_PATTERN;
                @Key
                private String resourceName;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private String personFields;
                @Key(value="requestMask.includeField")
                private String requestMaskIncludeField;
                @Key
                private Boolean requestSyncToken;
                @Key
                private String sortOrder;
                @Key
                private java.util.List<String> sources;
                @Key
                private String syncToken;

                protected List(String resourceName) {
                    super(PeopleService.this, "GET", REST_PATH, null, ListConnectionsResponse.class);
                    this.RESOURCE_NAME_PATTERN = Pattern.compile("^people/[^/]+$");
                    this.resourceName = (String)Preconditions.checkNotNull((Object)resourceName, (Object)"Required parameter resourceName must be specified.");
                    if (!PeopleService.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^people/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getResourceName() {
                    return this.resourceName;
                }

                public List setResourceName(String resourceName) {
                    if (!PeopleService.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^people/[^/]+$");
                    }
                    this.resourceName = resourceName;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public String getPersonFields() {
                    return this.personFields;
                }

                public List setPersonFields(String personFields) {
                    this.personFields = personFields;
                    return this;
                }

                public String getRequestMaskIncludeField() {
                    return this.requestMaskIncludeField;
                }

                public List setRequestMaskIncludeField(String requestMaskIncludeField) {
                    this.requestMaskIncludeField = requestMaskIncludeField;
                    return this;
                }

                public Boolean getRequestSyncToken() {
                    return this.requestSyncToken;
                }

                public List setRequestSyncToken(Boolean requestSyncToken) {
                    this.requestSyncToken = requestSyncToken;
                    return this;
                }

                public String getSortOrder() {
                    return this.sortOrder;
                }

                public List setSortOrder(String sortOrder) {
                    this.sortOrder = sortOrder;
                    return this;
                }

                public java.util.List<String> getSources() {
                    return this.sources;
                }

                public List setSources(java.util.List<String> sources) {
                    this.sources = sources;
                    return this;
                }

                public String getSyncToken() {
                    return this.syncToken;
                }

                public List setSyncToken(String syncToken) {
                    this.syncToken = syncToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }

        public class UpdateContactPhoto
        extends PeopleServiceRequest<UpdateContactPhotoResponse> {
            private static final String REST_PATH = "v1/{+resourceName}:updateContactPhoto";
            private final Pattern RESOURCE_NAME_PATTERN;
            @Key
            private String resourceName;

            protected UpdateContactPhoto(String resourceName, UpdateContactPhotoRequest content) {
                super(PeopleService.this, "PATCH", REST_PATH, (Object)content, UpdateContactPhotoResponse.class);
                this.RESOURCE_NAME_PATTERN = Pattern.compile("^people/[^/]+$");
                this.resourceName = (String)Preconditions.checkNotNull((Object)resourceName, (Object)"Required parameter resourceName must be specified.");
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^people/[^/]+$");
                }
            }

            public UpdateContactPhoto set$Xgafv(String $Xgafv) {
                return (UpdateContactPhoto)super.set$Xgafv($Xgafv);
            }

            public UpdateContactPhoto setAccessToken(String accessToken) {
                return (UpdateContactPhoto)super.setAccessToken(accessToken);
            }

            public UpdateContactPhoto setAlt(String alt) {
                return (UpdateContactPhoto)super.setAlt(alt);
            }

            public UpdateContactPhoto setCallback(String callback) {
                return (UpdateContactPhoto)super.setCallback(callback);
            }

            public UpdateContactPhoto setFields(String fields) {
                return (UpdateContactPhoto)super.setFields(fields);
            }

            public UpdateContactPhoto setKey(String key) {
                return (UpdateContactPhoto)super.setKey(key);
            }

            public UpdateContactPhoto setOauthToken(String oauthToken) {
                return (UpdateContactPhoto)super.setOauthToken(oauthToken);
            }

            public UpdateContactPhoto setPrettyPrint(Boolean prettyPrint) {
                return (UpdateContactPhoto)super.setPrettyPrint(prettyPrint);
            }

            public UpdateContactPhoto setQuotaUser(String quotaUser) {
                return (UpdateContactPhoto)super.setQuotaUser(quotaUser);
            }

            public UpdateContactPhoto setUploadType(String uploadType) {
                return (UpdateContactPhoto)super.setUploadType(uploadType);
            }

            public UpdateContactPhoto setUploadProtocol(String uploadProtocol) {
                return (UpdateContactPhoto)super.setUploadProtocol(uploadProtocol);
            }

            public String getResourceName() {
                return this.resourceName;
            }

            public UpdateContactPhoto setResourceName(String resourceName) {
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^people/[^/]+$");
                }
                this.resourceName = resourceName;
                return this;
            }

            @Override
            public UpdateContactPhoto set(String parameterName, Object value) {
                return (UpdateContactPhoto)super.set(parameterName, value);
            }
        }

        public class UpdateContact
        extends PeopleServiceRequest<Person> {
            private static final String REST_PATH = "v1/{+resourceName}:updateContact";
            private final Pattern RESOURCE_NAME_PATTERN;
            @Key
            private String resourceName;
            @Key
            private String personFields;
            @Key
            private List<String> sources;
            @Key
            private String updatePersonFields;

            protected UpdateContact(String resourceName, Person content) {
                super(PeopleService.this, "PATCH", REST_PATH, (Object)content, Person.class);
                this.RESOURCE_NAME_PATTERN = Pattern.compile("^people/[^/]+$");
                this.resourceName = (String)Preconditions.checkNotNull((Object)resourceName, (Object)"Required parameter resourceName must be specified.");
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^people/[^/]+$");
                }
            }

            public UpdateContact set$Xgafv(String $Xgafv) {
                return (UpdateContact)super.set$Xgafv($Xgafv);
            }

            public UpdateContact setAccessToken(String accessToken) {
                return (UpdateContact)super.setAccessToken(accessToken);
            }

            public UpdateContact setAlt(String alt) {
                return (UpdateContact)super.setAlt(alt);
            }

            public UpdateContact setCallback(String callback) {
                return (UpdateContact)super.setCallback(callback);
            }

            public UpdateContact setFields(String fields) {
                return (UpdateContact)super.setFields(fields);
            }

            public UpdateContact setKey(String key) {
                return (UpdateContact)super.setKey(key);
            }

            public UpdateContact setOauthToken(String oauthToken) {
                return (UpdateContact)super.setOauthToken(oauthToken);
            }

            public UpdateContact setPrettyPrint(Boolean prettyPrint) {
                return (UpdateContact)super.setPrettyPrint(prettyPrint);
            }

            public UpdateContact setQuotaUser(String quotaUser) {
                return (UpdateContact)super.setQuotaUser(quotaUser);
            }

            public UpdateContact setUploadType(String uploadType) {
                return (UpdateContact)super.setUploadType(uploadType);
            }

            public UpdateContact setUploadProtocol(String uploadProtocol) {
                return (UpdateContact)super.setUploadProtocol(uploadProtocol);
            }

            public String getResourceName() {
                return this.resourceName;
            }

            public UpdateContact setResourceName(String resourceName) {
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^people/[^/]+$");
                }
                this.resourceName = resourceName;
                return this;
            }

            public String getPersonFields() {
                return this.personFields;
            }

            public UpdateContact setPersonFields(String personFields) {
                this.personFields = personFields;
                return this;
            }

            public List<String> getSources() {
                return this.sources;
            }

            public UpdateContact setSources(List<String> sources) {
                this.sources = sources;
                return this;
            }

            public String getUpdatePersonFields() {
                return this.updatePersonFields;
            }

            public UpdateContact setUpdatePersonFields(String updatePersonFields) {
                this.updatePersonFields = updatePersonFields;
                return this;
            }

            @Override
            public UpdateContact set(String parameterName, Object value) {
                return (UpdateContact)super.set(parameterName, value);
            }
        }

        public class SearchDirectoryPeople
        extends PeopleServiceRequest<SearchDirectoryPeopleResponse> {
            private static final String REST_PATH = "v1/people:searchDirectoryPeople";
            @Key
            private List<String> mergeSources;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private String query;
            @Key
            private String readMask;
            @Key
            private List<String> sources;

            protected SearchDirectoryPeople() {
                super(PeopleService.this, "GET", REST_PATH, null, SearchDirectoryPeopleResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public SearchDirectoryPeople set$Xgafv(String $Xgafv) {
                return (SearchDirectoryPeople)super.set$Xgafv($Xgafv);
            }

            public SearchDirectoryPeople setAccessToken(String accessToken) {
                return (SearchDirectoryPeople)super.setAccessToken(accessToken);
            }

            public SearchDirectoryPeople setAlt(String alt) {
                return (SearchDirectoryPeople)super.setAlt(alt);
            }

            public SearchDirectoryPeople setCallback(String callback) {
                return (SearchDirectoryPeople)super.setCallback(callback);
            }

            public SearchDirectoryPeople setFields(String fields) {
                return (SearchDirectoryPeople)super.setFields(fields);
            }

            public SearchDirectoryPeople setKey(String key) {
                return (SearchDirectoryPeople)super.setKey(key);
            }

            public SearchDirectoryPeople setOauthToken(String oauthToken) {
                return (SearchDirectoryPeople)super.setOauthToken(oauthToken);
            }

            public SearchDirectoryPeople setPrettyPrint(Boolean prettyPrint) {
                return (SearchDirectoryPeople)super.setPrettyPrint(prettyPrint);
            }

            public SearchDirectoryPeople setQuotaUser(String quotaUser) {
                return (SearchDirectoryPeople)super.setQuotaUser(quotaUser);
            }

            public SearchDirectoryPeople setUploadType(String uploadType) {
                return (SearchDirectoryPeople)super.setUploadType(uploadType);
            }

            public SearchDirectoryPeople setUploadProtocol(String uploadProtocol) {
                return (SearchDirectoryPeople)super.setUploadProtocol(uploadProtocol);
            }

            public List<String> getMergeSources() {
                return this.mergeSources;
            }

            public SearchDirectoryPeople setMergeSources(List<String> mergeSources) {
                this.mergeSources = mergeSources;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public SearchDirectoryPeople setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public SearchDirectoryPeople setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getQuery() {
                return this.query;
            }

            public SearchDirectoryPeople setQuery(String query) {
                this.query = query;
                return this;
            }

            public String getReadMask() {
                return this.readMask;
            }

            public SearchDirectoryPeople setReadMask(String readMask) {
                this.readMask = readMask;
                return this;
            }

            public List<String> getSources() {
                return this.sources;
            }

            public SearchDirectoryPeople setSources(List<String> sources) {
                this.sources = sources;
                return this;
            }

            @Override
            public SearchDirectoryPeople set(String parameterName, Object value) {
                return (SearchDirectoryPeople)super.set(parameterName, value);
            }
        }

        public class SearchContacts
        extends PeopleServiceRequest<SearchResponse> {
            private static final String REST_PATH = "v1/people:searchContacts";
            @Key
            private Integer pageSize;
            @Key
            private String query;
            @Key
            private String readMask;
            @Key
            private List<String> sources;

            protected SearchContacts() {
                super(PeopleService.this, "GET", REST_PATH, null, SearchResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public SearchContacts set$Xgafv(String $Xgafv) {
                return (SearchContacts)super.set$Xgafv($Xgafv);
            }

            public SearchContacts setAccessToken(String accessToken) {
                return (SearchContacts)super.setAccessToken(accessToken);
            }

            public SearchContacts setAlt(String alt) {
                return (SearchContacts)super.setAlt(alt);
            }

            public SearchContacts setCallback(String callback) {
                return (SearchContacts)super.setCallback(callback);
            }

            public SearchContacts setFields(String fields) {
                return (SearchContacts)super.setFields(fields);
            }

            public SearchContacts setKey(String key) {
                return (SearchContacts)super.setKey(key);
            }

            public SearchContacts setOauthToken(String oauthToken) {
                return (SearchContacts)super.setOauthToken(oauthToken);
            }

            public SearchContacts setPrettyPrint(Boolean prettyPrint) {
                return (SearchContacts)super.setPrettyPrint(prettyPrint);
            }

            public SearchContacts setQuotaUser(String quotaUser) {
                return (SearchContacts)super.setQuotaUser(quotaUser);
            }

            public SearchContacts setUploadType(String uploadType) {
                return (SearchContacts)super.setUploadType(uploadType);
            }

            public SearchContacts setUploadProtocol(String uploadProtocol) {
                return (SearchContacts)super.setUploadProtocol(uploadProtocol);
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public SearchContacts setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getQuery() {
                return this.query;
            }

            public SearchContacts setQuery(String query) {
                this.query = query;
                return this;
            }

            public String getReadMask() {
                return this.readMask;
            }

            public SearchContacts setReadMask(String readMask) {
                this.readMask = readMask;
                return this;
            }

            public List<String> getSources() {
                return this.sources;
            }

            public SearchContacts setSources(List<String> sources) {
                this.sources = sources;
                return this;
            }

            @Override
            public SearchContacts set(String parameterName, Object value) {
                return (SearchContacts)super.set(parameterName, value);
            }
        }

        public class ListDirectoryPeople
        extends PeopleServiceRequest<ListDirectoryPeopleResponse> {
            private static final String REST_PATH = "v1/people:listDirectoryPeople";
            @Key
            private List<String> mergeSources;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private String readMask;
            @Key
            private Boolean requestSyncToken;
            @Key
            private List<String> sources;
            @Key
            private String syncToken;

            protected ListDirectoryPeople() {
                super(PeopleService.this, "GET", REST_PATH, null, ListDirectoryPeopleResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListDirectoryPeople set$Xgafv(String $Xgafv) {
                return (ListDirectoryPeople)super.set$Xgafv($Xgafv);
            }

            public ListDirectoryPeople setAccessToken(String accessToken) {
                return (ListDirectoryPeople)super.setAccessToken(accessToken);
            }

            public ListDirectoryPeople setAlt(String alt) {
                return (ListDirectoryPeople)super.setAlt(alt);
            }

            public ListDirectoryPeople setCallback(String callback) {
                return (ListDirectoryPeople)super.setCallback(callback);
            }

            public ListDirectoryPeople setFields(String fields) {
                return (ListDirectoryPeople)super.setFields(fields);
            }

            public ListDirectoryPeople setKey(String key) {
                return (ListDirectoryPeople)super.setKey(key);
            }

            public ListDirectoryPeople setOauthToken(String oauthToken) {
                return (ListDirectoryPeople)super.setOauthToken(oauthToken);
            }

            public ListDirectoryPeople setPrettyPrint(Boolean prettyPrint) {
                return (ListDirectoryPeople)super.setPrettyPrint(prettyPrint);
            }

            public ListDirectoryPeople setQuotaUser(String quotaUser) {
                return (ListDirectoryPeople)super.setQuotaUser(quotaUser);
            }

            public ListDirectoryPeople setUploadType(String uploadType) {
                return (ListDirectoryPeople)super.setUploadType(uploadType);
            }

            public ListDirectoryPeople setUploadProtocol(String uploadProtocol) {
                return (ListDirectoryPeople)super.setUploadProtocol(uploadProtocol);
            }

            public List<String> getMergeSources() {
                return this.mergeSources;
            }

            public ListDirectoryPeople setMergeSources(List<String> mergeSources) {
                this.mergeSources = mergeSources;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public ListDirectoryPeople setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListDirectoryPeople setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getReadMask() {
                return this.readMask;
            }

            public ListDirectoryPeople setReadMask(String readMask) {
                this.readMask = readMask;
                return this;
            }

            public Boolean getRequestSyncToken() {
                return this.requestSyncToken;
            }

            public ListDirectoryPeople setRequestSyncToken(Boolean requestSyncToken) {
                this.requestSyncToken = requestSyncToken;
                return this;
            }

            public List<String> getSources() {
                return this.sources;
            }

            public ListDirectoryPeople setSources(List<String> sources) {
                this.sources = sources;
                return this;
            }

            public String getSyncToken() {
                return this.syncToken;
            }

            public ListDirectoryPeople setSyncToken(String syncToken) {
                this.syncToken = syncToken;
                return this;
            }

            @Override
            public ListDirectoryPeople set(String parameterName, Object value) {
                return (ListDirectoryPeople)super.set(parameterName, value);
            }
        }

        public class GetBatchGet
        extends PeopleServiceRequest<GetPeopleResponse> {
            private static final String REST_PATH = "v1/people:batchGet";
            @Key
            private String personFields;
            @Key(value="requestMask.includeField")
            private String requestMaskIncludeField;
            @Key
            private List<String> resourceNames;
            @Key
            private List<String> sources;

            protected GetBatchGet() {
                super(PeopleService.this, "GET", REST_PATH, null, GetPeopleResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetBatchGet set$Xgafv(String $Xgafv) {
                return (GetBatchGet)super.set$Xgafv($Xgafv);
            }

            public GetBatchGet setAccessToken(String accessToken) {
                return (GetBatchGet)super.setAccessToken(accessToken);
            }

            public GetBatchGet setAlt(String alt) {
                return (GetBatchGet)super.setAlt(alt);
            }

            public GetBatchGet setCallback(String callback) {
                return (GetBatchGet)super.setCallback(callback);
            }

            public GetBatchGet setFields(String fields) {
                return (GetBatchGet)super.setFields(fields);
            }

            public GetBatchGet setKey(String key) {
                return (GetBatchGet)super.setKey(key);
            }

            public GetBatchGet setOauthToken(String oauthToken) {
                return (GetBatchGet)super.setOauthToken(oauthToken);
            }

            public GetBatchGet setPrettyPrint(Boolean prettyPrint) {
                return (GetBatchGet)super.setPrettyPrint(prettyPrint);
            }

            public GetBatchGet setQuotaUser(String quotaUser) {
                return (GetBatchGet)super.setQuotaUser(quotaUser);
            }

            public GetBatchGet setUploadType(String uploadType) {
                return (GetBatchGet)super.setUploadType(uploadType);
            }

            public GetBatchGet setUploadProtocol(String uploadProtocol) {
                return (GetBatchGet)super.setUploadProtocol(uploadProtocol);
            }

            public String getPersonFields() {
                return this.personFields;
            }

            public GetBatchGet setPersonFields(String personFields) {
                this.personFields = personFields;
                return this;
            }

            public String getRequestMaskIncludeField() {
                return this.requestMaskIncludeField;
            }

            public GetBatchGet setRequestMaskIncludeField(String requestMaskIncludeField) {
                this.requestMaskIncludeField = requestMaskIncludeField;
                return this;
            }

            public List<String> getResourceNames() {
                return this.resourceNames;
            }

            public GetBatchGet setResourceNames(List<String> resourceNames) {
                this.resourceNames = resourceNames;
                return this;
            }

            public List<String> getSources() {
                return this.sources;
            }

            public GetBatchGet setSources(List<String> sources) {
                this.sources = sources;
                return this;
            }

            @Override
            public GetBatchGet set(String parameterName, Object value) {
                return (GetBatchGet)super.set(parameterName, value);
            }
        }

        public class Get
        extends PeopleServiceRequest<Person> {
            private static final String REST_PATH = "v1/{+resourceName}";
            private final Pattern RESOURCE_NAME_PATTERN;
            @Key
            private String resourceName;
            @Key
            private String personFields;
            @Key(value="requestMask.includeField")
            private String requestMaskIncludeField;
            @Key
            private List<String> sources;

            protected Get(String resourceName) {
                super(PeopleService.this, "GET", REST_PATH, null, Person.class);
                this.RESOURCE_NAME_PATTERN = Pattern.compile("^people/[^/]+$");
                this.resourceName = (String)Preconditions.checkNotNull((Object)resourceName, (Object)"Required parameter resourceName must be specified.");
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^people/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getResourceName() {
                return this.resourceName;
            }

            public Get setResourceName(String resourceName) {
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^people/[^/]+$");
                }
                this.resourceName = resourceName;
                return this;
            }

            public String getPersonFields() {
                return this.personFields;
            }

            public Get setPersonFields(String personFields) {
                this.personFields = personFields;
                return this;
            }

            public String getRequestMaskIncludeField() {
                return this.requestMaskIncludeField;
            }

            public Get setRequestMaskIncludeField(String requestMaskIncludeField) {
                this.requestMaskIncludeField = requestMaskIncludeField;
                return this;
            }

            public List<String> getSources() {
                return this.sources;
            }

            public Get setSources(List<String> sources) {
                this.sources = sources;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class DeleteContactPhoto
        extends PeopleServiceRequest<DeleteContactPhotoResponse> {
            private static final String REST_PATH = "v1/{+resourceName}:deleteContactPhoto";
            private final Pattern RESOURCE_NAME_PATTERN;
            @Key
            private String resourceName;
            @Key
            private String personFields;
            @Key
            private List<String> sources;

            protected DeleteContactPhoto(String resourceName) {
                super(PeopleService.this, "DELETE", REST_PATH, null, DeleteContactPhotoResponse.class);
                this.RESOURCE_NAME_PATTERN = Pattern.compile("^people/[^/]+$");
                this.resourceName = (String)Preconditions.checkNotNull((Object)resourceName, (Object)"Required parameter resourceName must be specified.");
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^people/[^/]+$");
                }
            }

            public DeleteContactPhoto set$Xgafv(String $Xgafv) {
                return (DeleteContactPhoto)super.set$Xgafv($Xgafv);
            }

            public DeleteContactPhoto setAccessToken(String accessToken) {
                return (DeleteContactPhoto)super.setAccessToken(accessToken);
            }

            public DeleteContactPhoto setAlt(String alt) {
                return (DeleteContactPhoto)super.setAlt(alt);
            }

            public DeleteContactPhoto setCallback(String callback) {
                return (DeleteContactPhoto)super.setCallback(callback);
            }

            public DeleteContactPhoto setFields(String fields) {
                return (DeleteContactPhoto)super.setFields(fields);
            }

            public DeleteContactPhoto setKey(String key) {
                return (DeleteContactPhoto)super.setKey(key);
            }

            public DeleteContactPhoto setOauthToken(String oauthToken) {
                return (DeleteContactPhoto)super.setOauthToken(oauthToken);
            }

            public DeleteContactPhoto setPrettyPrint(Boolean prettyPrint) {
                return (DeleteContactPhoto)super.setPrettyPrint(prettyPrint);
            }

            public DeleteContactPhoto setQuotaUser(String quotaUser) {
                return (DeleteContactPhoto)super.setQuotaUser(quotaUser);
            }

            public DeleteContactPhoto setUploadType(String uploadType) {
                return (DeleteContactPhoto)super.setUploadType(uploadType);
            }

            public DeleteContactPhoto setUploadProtocol(String uploadProtocol) {
                return (DeleteContactPhoto)super.setUploadProtocol(uploadProtocol);
            }

            public String getResourceName() {
                return this.resourceName;
            }

            public DeleteContactPhoto setResourceName(String resourceName) {
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^people/[^/]+$");
                }
                this.resourceName = resourceName;
                return this;
            }

            public String getPersonFields() {
                return this.personFields;
            }

            public DeleteContactPhoto setPersonFields(String personFields) {
                this.personFields = personFields;
                return this;
            }

            public List<String> getSources() {
                return this.sources;
            }

            public DeleteContactPhoto setSources(List<String> sources) {
                this.sources = sources;
                return this;
            }

            @Override
            public DeleteContactPhoto set(String parameterName, Object value) {
                return (DeleteContactPhoto)super.set(parameterName, value);
            }
        }

        public class DeleteContact
        extends PeopleServiceRequest<Empty> {
            private static final String REST_PATH = "v1/{+resourceName}:deleteContact";
            private final Pattern RESOURCE_NAME_PATTERN;
            @Key
            private String resourceName;

            protected DeleteContact(String resourceName) {
                super(PeopleService.this, "DELETE", REST_PATH, null, Empty.class);
                this.RESOURCE_NAME_PATTERN = Pattern.compile("^people/[^/]+$");
                this.resourceName = (String)Preconditions.checkNotNull((Object)resourceName, (Object)"Required parameter resourceName must be specified.");
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^people/[^/]+$");
                }
            }

            public DeleteContact set$Xgafv(String $Xgafv) {
                return (DeleteContact)super.set$Xgafv($Xgafv);
            }

            public DeleteContact setAccessToken(String accessToken) {
                return (DeleteContact)super.setAccessToken(accessToken);
            }

            public DeleteContact setAlt(String alt) {
                return (DeleteContact)super.setAlt(alt);
            }

            public DeleteContact setCallback(String callback) {
                return (DeleteContact)super.setCallback(callback);
            }

            public DeleteContact setFields(String fields) {
                return (DeleteContact)super.setFields(fields);
            }

            public DeleteContact setKey(String key) {
                return (DeleteContact)super.setKey(key);
            }

            public DeleteContact setOauthToken(String oauthToken) {
                return (DeleteContact)super.setOauthToken(oauthToken);
            }

            public DeleteContact setPrettyPrint(Boolean prettyPrint) {
                return (DeleteContact)super.setPrettyPrint(prettyPrint);
            }

            public DeleteContact setQuotaUser(String quotaUser) {
                return (DeleteContact)super.setQuotaUser(quotaUser);
            }

            public DeleteContact setUploadType(String uploadType) {
                return (DeleteContact)super.setUploadType(uploadType);
            }

            public DeleteContact setUploadProtocol(String uploadProtocol) {
                return (DeleteContact)super.setUploadProtocol(uploadProtocol);
            }

            public String getResourceName() {
                return this.resourceName;
            }

            public DeleteContact setResourceName(String resourceName) {
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^people/[^/]+$");
                }
                this.resourceName = resourceName;
                return this;
            }

            @Override
            public DeleteContact set(String parameterName, Object value) {
                return (DeleteContact)super.set(parameterName, value);
            }
        }

        public class CreateContact
        extends PeopleServiceRequest<Person> {
            private static final String REST_PATH = "v1/people:createContact";
            @Key
            private String personFields;
            @Key
            private List<String> sources;

            protected CreateContact(Person content) {
                super(PeopleService.this, "POST", REST_PATH, (Object)content, Person.class);
            }

            public CreateContact set$Xgafv(String $Xgafv) {
                return (CreateContact)super.set$Xgafv($Xgafv);
            }

            public CreateContact setAccessToken(String accessToken) {
                return (CreateContact)super.setAccessToken(accessToken);
            }

            public CreateContact setAlt(String alt) {
                return (CreateContact)super.setAlt(alt);
            }

            public CreateContact setCallback(String callback) {
                return (CreateContact)super.setCallback(callback);
            }

            public CreateContact setFields(String fields) {
                return (CreateContact)super.setFields(fields);
            }

            public CreateContact setKey(String key) {
                return (CreateContact)super.setKey(key);
            }

            public CreateContact setOauthToken(String oauthToken) {
                return (CreateContact)super.setOauthToken(oauthToken);
            }

            public CreateContact setPrettyPrint(Boolean prettyPrint) {
                return (CreateContact)super.setPrettyPrint(prettyPrint);
            }

            public CreateContact setQuotaUser(String quotaUser) {
                return (CreateContact)super.setQuotaUser(quotaUser);
            }

            public CreateContact setUploadType(String uploadType) {
                return (CreateContact)super.setUploadType(uploadType);
            }

            public CreateContact setUploadProtocol(String uploadProtocol) {
                return (CreateContact)super.setUploadProtocol(uploadProtocol);
            }

            public String getPersonFields() {
                return this.personFields;
            }

            public CreateContact setPersonFields(String personFields) {
                this.personFields = personFields;
                return this;
            }

            public List<String> getSources() {
                return this.sources;
            }

            public CreateContact setSources(List<String> sources) {
                this.sources = sources;
                return this;
            }

            @Override
            public CreateContact set(String parameterName, Object value) {
                return (CreateContact)super.set(parameterName, value);
            }
        }

        public class BatchUpdateContacts
        extends PeopleServiceRequest<BatchUpdateContactsResponse> {
            private static final String REST_PATH = "v1/people:batchUpdateContacts";

            protected BatchUpdateContacts(BatchUpdateContactsRequest content) {
                super(PeopleService.this, "POST", REST_PATH, (Object)content, BatchUpdateContactsResponse.class);
            }

            public BatchUpdateContacts set$Xgafv(String $Xgafv) {
                return (BatchUpdateContacts)super.set$Xgafv($Xgafv);
            }

            public BatchUpdateContacts setAccessToken(String accessToken) {
                return (BatchUpdateContacts)super.setAccessToken(accessToken);
            }

            public BatchUpdateContacts setAlt(String alt) {
                return (BatchUpdateContacts)super.setAlt(alt);
            }

            public BatchUpdateContacts setCallback(String callback) {
                return (BatchUpdateContacts)super.setCallback(callback);
            }

            public BatchUpdateContacts setFields(String fields) {
                return (BatchUpdateContacts)super.setFields(fields);
            }

            public BatchUpdateContacts setKey(String key) {
                return (BatchUpdateContacts)super.setKey(key);
            }

            public BatchUpdateContacts setOauthToken(String oauthToken) {
                return (BatchUpdateContacts)super.setOauthToken(oauthToken);
            }

            public BatchUpdateContacts setPrettyPrint(Boolean prettyPrint) {
                return (BatchUpdateContacts)super.setPrettyPrint(prettyPrint);
            }

            public BatchUpdateContacts setQuotaUser(String quotaUser) {
                return (BatchUpdateContacts)super.setQuotaUser(quotaUser);
            }

            public BatchUpdateContacts setUploadType(String uploadType) {
                return (BatchUpdateContacts)super.setUploadType(uploadType);
            }

            public BatchUpdateContacts setUploadProtocol(String uploadProtocol) {
                return (BatchUpdateContacts)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public BatchUpdateContacts set(String parameterName, Object value) {
                return (BatchUpdateContacts)super.set(parameterName, value);
            }
        }

        public class BatchDeleteContacts
        extends PeopleServiceRequest<Empty> {
            private static final String REST_PATH = "v1/people:batchDeleteContacts";

            protected BatchDeleteContacts(BatchDeleteContactsRequest content) {
                super(PeopleService.this, "POST", REST_PATH, (Object)content, Empty.class);
            }

            public BatchDeleteContacts set$Xgafv(String $Xgafv) {
                return (BatchDeleteContacts)super.set$Xgafv($Xgafv);
            }

            public BatchDeleteContacts setAccessToken(String accessToken) {
                return (BatchDeleteContacts)super.setAccessToken(accessToken);
            }

            public BatchDeleteContacts setAlt(String alt) {
                return (BatchDeleteContacts)super.setAlt(alt);
            }

            public BatchDeleteContacts setCallback(String callback) {
                return (BatchDeleteContacts)super.setCallback(callback);
            }

            public BatchDeleteContacts setFields(String fields) {
                return (BatchDeleteContacts)super.setFields(fields);
            }

            public BatchDeleteContacts setKey(String key) {
                return (BatchDeleteContacts)super.setKey(key);
            }

            public BatchDeleteContacts setOauthToken(String oauthToken) {
                return (BatchDeleteContacts)super.setOauthToken(oauthToken);
            }

            public BatchDeleteContacts setPrettyPrint(Boolean prettyPrint) {
                return (BatchDeleteContacts)super.setPrettyPrint(prettyPrint);
            }

            public BatchDeleteContacts setQuotaUser(String quotaUser) {
                return (BatchDeleteContacts)super.setQuotaUser(quotaUser);
            }

            public BatchDeleteContacts setUploadType(String uploadType) {
                return (BatchDeleteContacts)super.setUploadType(uploadType);
            }

            public BatchDeleteContacts setUploadProtocol(String uploadProtocol) {
                return (BatchDeleteContacts)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public BatchDeleteContacts set(String parameterName, Object value) {
                return (BatchDeleteContacts)super.set(parameterName, value);
            }
        }

        public class BatchCreateContacts
        extends PeopleServiceRequest<BatchCreateContactsResponse> {
            private static final String REST_PATH = "v1/people:batchCreateContacts";

            protected BatchCreateContacts(BatchCreateContactsRequest content) {
                super(PeopleService.this, "POST", REST_PATH, (Object)content, BatchCreateContactsResponse.class);
            }

            public BatchCreateContacts set$Xgafv(String $Xgafv) {
                return (BatchCreateContacts)super.set$Xgafv($Xgafv);
            }

            public BatchCreateContacts setAccessToken(String accessToken) {
                return (BatchCreateContacts)super.setAccessToken(accessToken);
            }

            public BatchCreateContacts setAlt(String alt) {
                return (BatchCreateContacts)super.setAlt(alt);
            }

            public BatchCreateContacts setCallback(String callback) {
                return (BatchCreateContacts)super.setCallback(callback);
            }

            public BatchCreateContacts setFields(String fields) {
                return (BatchCreateContacts)super.setFields(fields);
            }

            public BatchCreateContacts setKey(String key) {
                return (BatchCreateContacts)super.setKey(key);
            }

            public BatchCreateContacts setOauthToken(String oauthToken) {
                return (BatchCreateContacts)super.setOauthToken(oauthToken);
            }

            public BatchCreateContacts setPrettyPrint(Boolean prettyPrint) {
                return (BatchCreateContacts)super.setPrettyPrint(prettyPrint);
            }

            public BatchCreateContacts setQuotaUser(String quotaUser) {
                return (BatchCreateContacts)super.setQuotaUser(quotaUser);
            }

            public BatchCreateContacts setUploadType(String uploadType) {
                return (BatchCreateContacts)super.setUploadType(uploadType);
            }

            public BatchCreateContacts setUploadProtocol(String uploadProtocol) {
                return (BatchCreateContacts)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public BatchCreateContacts set(String parameterName, Object value) {
                return (BatchCreateContacts)super.set(parameterName, value);
            }
        }
    }

    public class OtherContacts {
        public CopyOtherContactToMyContactsGroup copyOtherContactToMyContactsGroup(String resourceName, CopyOtherContactToMyContactsGroupRequest content) throws IOException {
            CopyOtherContactToMyContactsGroup result = new CopyOtherContactToMyContactsGroup(resourceName, content);
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Search search() throws IOException {
            Search result = new Search();
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Search
        extends PeopleServiceRequest<SearchResponse> {
            private static final String REST_PATH = "v1/otherContacts:search";
            @Key
            private Integer pageSize;
            @Key
            private String query;
            @Key
            private String readMask;

            protected Search() {
                super(PeopleService.this, "GET", REST_PATH, null, SearchResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Search set$Xgafv(String $Xgafv) {
                return (Search)super.set$Xgafv($Xgafv);
            }

            public Search setAccessToken(String accessToken) {
                return (Search)super.setAccessToken(accessToken);
            }

            public Search setAlt(String alt) {
                return (Search)super.setAlt(alt);
            }

            public Search setCallback(String callback) {
                return (Search)super.setCallback(callback);
            }

            public Search setFields(String fields) {
                return (Search)super.setFields(fields);
            }

            public Search setKey(String key) {
                return (Search)super.setKey(key);
            }

            public Search setOauthToken(String oauthToken) {
                return (Search)super.setOauthToken(oauthToken);
            }

            public Search setPrettyPrint(Boolean prettyPrint) {
                return (Search)super.setPrettyPrint(prettyPrint);
            }

            public Search setQuotaUser(String quotaUser) {
                return (Search)super.setQuotaUser(quotaUser);
            }

            public Search setUploadType(String uploadType) {
                return (Search)super.setUploadType(uploadType);
            }

            public Search setUploadProtocol(String uploadProtocol) {
                return (Search)super.setUploadProtocol(uploadProtocol);
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public Search setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getQuery() {
                return this.query;
            }

            public Search setQuery(String query) {
                this.query = query;
                return this;
            }

            public String getReadMask() {
                return this.readMask;
            }

            public Search setReadMask(String readMask) {
                this.readMask = readMask;
                return this;
            }

            @Override
            public Search set(String parameterName, Object value) {
                return (Search)super.set(parameterName, value);
            }
        }

        public class List
        extends PeopleServiceRequest<ListOtherContactsResponse> {
            private static final String REST_PATH = "v1/otherContacts";
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private String readMask;
            @Key
            private Boolean requestSyncToken;
            @Key
            private java.util.List<String> sources;
            @Key
            private String syncToken;

            protected List() {
                super(PeopleService.this, "GET", REST_PATH, null, ListOtherContactsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getReadMask() {
                return this.readMask;
            }

            public List setReadMask(String readMask) {
                this.readMask = readMask;
                return this;
            }

            public Boolean getRequestSyncToken() {
                return this.requestSyncToken;
            }

            public List setRequestSyncToken(Boolean requestSyncToken) {
                this.requestSyncToken = requestSyncToken;
                return this;
            }

            public java.util.List<String> getSources() {
                return this.sources;
            }

            public List setSources(java.util.List<String> sources) {
                this.sources = sources;
                return this;
            }

            public String getSyncToken() {
                return this.syncToken;
            }

            public List setSyncToken(String syncToken) {
                this.syncToken = syncToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class CopyOtherContactToMyContactsGroup
        extends PeopleServiceRequest<Person> {
            private static final String REST_PATH = "v1/{+resourceName}:copyOtherContactToMyContactsGroup";
            private final Pattern RESOURCE_NAME_PATTERN;
            @Key
            private String resourceName;

            protected CopyOtherContactToMyContactsGroup(String resourceName, CopyOtherContactToMyContactsGroupRequest content) {
                super(PeopleService.this, "POST", REST_PATH, (Object)content, Person.class);
                this.RESOURCE_NAME_PATTERN = Pattern.compile("^otherContacts/[^/]+$");
                this.resourceName = (String)Preconditions.checkNotNull((Object)resourceName, (Object)"Required parameter resourceName must be specified.");
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^otherContacts/[^/]+$");
                }
            }

            public CopyOtherContactToMyContactsGroup set$Xgafv(String $Xgafv) {
                return (CopyOtherContactToMyContactsGroup)super.set$Xgafv($Xgafv);
            }

            public CopyOtherContactToMyContactsGroup setAccessToken(String accessToken) {
                return (CopyOtherContactToMyContactsGroup)super.setAccessToken(accessToken);
            }

            public CopyOtherContactToMyContactsGroup setAlt(String alt) {
                return (CopyOtherContactToMyContactsGroup)super.setAlt(alt);
            }

            public CopyOtherContactToMyContactsGroup setCallback(String callback) {
                return (CopyOtherContactToMyContactsGroup)super.setCallback(callback);
            }

            public CopyOtherContactToMyContactsGroup setFields(String fields) {
                return (CopyOtherContactToMyContactsGroup)super.setFields(fields);
            }

            public CopyOtherContactToMyContactsGroup setKey(String key) {
                return (CopyOtherContactToMyContactsGroup)super.setKey(key);
            }

            public CopyOtherContactToMyContactsGroup setOauthToken(String oauthToken) {
                return (CopyOtherContactToMyContactsGroup)super.setOauthToken(oauthToken);
            }

            public CopyOtherContactToMyContactsGroup setPrettyPrint(Boolean prettyPrint) {
                return (CopyOtherContactToMyContactsGroup)super.setPrettyPrint(prettyPrint);
            }

            public CopyOtherContactToMyContactsGroup setQuotaUser(String quotaUser) {
                return (CopyOtherContactToMyContactsGroup)super.setQuotaUser(quotaUser);
            }

            public CopyOtherContactToMyContactsGroup setUploadType(String uploadType) {
                return (CopyOtherContactToMyContactsGroup)super.setUploadType(uploadType);
            }

            public CopyOtherContactToMyContactsGroup setUploadProtocol(String uploadProtocol) {
                return (CopyOtherContactToMyContactsGroup)super.setUploadProtocol(uploadProtocol);
            }

            public String getResourceName() {
                return this.resourceName;
            }

            public CopyOtherContactToMyContactsGroup setResourceName(String resourceName) {
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^otherContacts/[^/]+$");
                }
                this.resourceName = resourceName;
                return this;
            }

            @Override
            public CopyOtherContactToMyContactsGroup set(String parameterName, Object value) {
                return (CopyOtherContactToMyContactsGroup)super.set(parameterName, value);
            }
        }
    }

    public class ContactGroups {
        public BatchGet batchGet() throws IOException {
            BatchGet result = new BatchGet();
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Create create(CreateContactGroupRequest content) throws IOException {
            Create result = new Create(content);
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String resourceName) throws IOException {
            Delete result = new Delete(resourceName);
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String resourceName) throws IOException {
            Get result = new Get(resourceName);
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String resourceName, UpdateContactGroupRequest content) throws IOException {
            Update result = new Update(resourceName, content);
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Members members() {
            return new Members();
        }

        public class Members {
            public Modify modify(String resourceName, ModifyContactGroupMembersRequest content) throws IOException {
                Modify result = new Modify(resourceName, content);
                PeopleService.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Modify
            extends PeopleServiceRequest<ModifyContactGroupMembersResponse> {
                private static final String REST_PATH = "v1/{+resourceName}/members:modify";
                private final Pattern RESOURCE_NAME_PATTERN;
                @Key
                private String resourceName;

                protected Modify(String resourceName, ModifyContactGroupMembersRequest content) {
                    super(PeopleService.this, "POST", REST_PATH, (Object)content, ModifyContactGroupMembersResponse.class);
                    this.RESOURCE_NAME_PATTERN = Pattern.compile("^contactGroups/[^/]+$");
                    this.resourceName = (String)Preconditions.checkNotNull((Object)resourceName, (Object)"Required parameter resourceName must be specified.");
                    if (!PeopleService.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^contactGroups/[^/]+$");
                    }
                }

                public Modify set$Xgafv(String $Xgafv) {
                    return (Modify)super.set$Xgafv($Xgafv);
                }

                public Modify setAccessToken(String accessToken) {
                    return (Modify)super.setAccessToken(accessToken);
                }

                public Modify setAlt(String alt) {
                    return (Modify)super.setAlt(alt);
                }

                public Modify setCallback(String callback) {
                    return (Modify)super.setCallback(callback);
                }

                public Modify setFields(String fields) {
                    return (Modify)super.setFields(fields);
                }

                public Modify setKey(String key) {
                    return (Modify)super.setKey(key);
                }

                public Modify setOauthToken(String oauthToken) {
                    return (Modify)super.setOauthToken(oauthToken);
                }

                public Modify setPrettyPrint(Boolean prettyPrint) {
                    return (Modify)super.setPrettyPrint(prettyPrint);
                }

                public Modify setQuotaUser(String quotaUser) {
                    return (Modify)super.setQuotaUser(quotaUser);
                }

                public Modify setUploadType(String uploadType) {
                    return (Modify)super.setUploadType(uploadType);
                }

                public Modify setUploadProtocol(String uploadProtocol) {
                    return (Modify)super.setUploadProtocol(uploadProtocol);
                }

                public String getResourceName() {
                    return this.resourceName;
                }

                public Modify setResourceName(String resourceName) {
                    if (!PeopleService.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^contactGroups/[^/]+$");
                    }
                    this.resourceName = resourceName;
                    return this;
                }

                @Override
                public Modify set(String parameterName, Object value) {
                    return (Modify)super.set(parameterName, value);
                }
            }
        }

        public class Update
        extends PeopleServiceRequest<ContactGroup> {
            private static final String REST_PATH = "v1/{+resourceName}";
            private final Pattern RESOURCE_NAME_PATTERN;
            @Key
            private String resourceName;

            protected Update(String resourceName, UpdateContactGroupRequest content) {
                super(PeopleService.this, "PUT", REST_PATH, (Object)content, ContactGroup.class);
                this.RESOURCE_NAME_PATTERN = Pattern.compile("^contactGroups/[^/]+$");
                this.resourceName = (String)Preconditions.checkNotNull((Object)resourceName, (Object)"Required parameter resourceName must be specified.");
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^contactGroups/[^/]+$");
                }
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getResourceName() {
                return this.resourceName;
            }

            public Update setResourceName(String resourceName) {
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^contactGroups/[^/]+$");
                }
                this.resourceName = resourceName;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class List
        extends PeopleServiceRequest<ListContactGroupsResponse> {
            private static final String REST_PATH = "v1/contactGroups";
            @Key
            private String groupFields;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private String syncToken;

            protected List() {
                super(PeopleService.this, "GET", REST_PATH, null, ListContactGroupsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getGroupFields() {
                return this.groupFields;
            }

            public List setGroupFields(String groupFields) {
                this.groupFields = groupFields;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getSyncToken() {
                return this.syncToken;
            }

            public List setSyncToken(String syncToken) {
                this.syncToken = syncToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends PeopleServiceRequest<ContactGroup> {
            private static final String REST_PATH = "v1/{+resourceName}";
            private final Pattern RESOURCE_NAME_PATTERN;
            @Key
            private String resourceName;
            @Key
            private String groupFields;
            @Key
            private Integer maxMembers;

            protected Get(String resourceName) {
                super(PeopleService.this, "GET", REST_PATH, null, ContactGroup.class);
                this.RESOURCE_NAME_PATTERN = Pattern.compile("^contactGroups/[^/]+$");
                this.resourceName = (String)Preconditions.checkNotNull((Object)resourceName, (Object)"Required parameter resourceName must be specified.");
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^contactGroups/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getResourceName() {
                return this.resourceName;
            }

            public Get setResourceName(String resourceName) {
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^contactGroups/[^/]+$");
                }
                this.resourceName = resourceName;
                return this;
            }

            public String getGroupFields() {
                return this.groupFields;
            }

            public Get setGroupFields(String groupFields) {
                this.groupFields = groupFields;
                return this;
            }

            public Integer getMaxMembers() {
                return this.maxMembers;
            }

            public Get setMaxMembers(Integer maxMembers) {
                this.maxMembers = maxMembers;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends PeopleServiceRequest<Empty> {
            private static final String REST_PATH = "v1/{+resourceName}";
            private final Pattern RESOURCE_NAME_PATTERN;
            @Key
            private String resourceName;
            @Key
            private Boolean deleteContacts;

            protected Delete(String resourceName) {
                super(PeopleService.this, "DELETE", REST_PATH, null, Empty.class);
                this.RESOURCE_NAME_PATTERN = Pattern.compile("^contactGroups/[^/]+$");
                this.resourceName = (String)Preconditions.checkNotNull((Object)resourceName, (Object)"Required parameter resourceName must be specified.");
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^contactGroups/[^/]+$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getResourceName() {
                return this.resourceName;
            }

            public Delete setResourceName(String resourceName) {
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^contactGroups/[^/]+$");
                }
                this.resourceName = resourceName;
                return this;
            }

            public Boolean getDeleteContacts() {
                return this.deleteContacts;
            }

            public Delete setDeleteContacts(Boolean deleteContacts) {
                this.deleteContacts = deleteContacts;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends PeopleServiceRequest<ContactGroup> {
            private static final String REST_PATH = "v1/contactGroups";

            protected Create(CreateContactGroupRequest content) {
                super(PeopleService.this, "POST", REST_PATH, (Object)content, ContactGroup.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }

        public class BatchGet
        extends PeopleServiceRequest<BatchGetContactGroupsResponse> {
            private static final String REST_PATH = "v1/contactGroups:batchGet";
            @Key
            private String groupFields;
            @Key
            private Integer maxMembers;
            @Key
            private java.util.List<String> resourceNames;

            protected BatchGet() {
                super(PeopleService.this, "GET", REST_PATH, null, BatchGetContactGroupsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public BatchGet set$Xgafv(String $Xgafv) {
                return (BatchGet)super.set$Xgafv($Xgafv);
            }

            public BatchGet setAccessToken(String accessToken) {
                return (BatchGet)super.setAccessToken(accessToken);
            }

            public BatchGet setAlt(String alt) {
                return (BatchGet)super.setAlt(alt);
            }

            public BatchGet setCallback(String callback) {
                return (BatchGet)super.setCallback(callback);
            }

            public BatchGet setFields(String fields) {
                return (BatchGet)super.setFields(fields);
            }

            public BatchGet setKey(String key) {
                return (BatchGet)super.setKey(key);
            }

            public BatchGet setOauthToken(String oauthToken) {
                return (BatchGet)super.setOauthToken(oauthToken);
            }

            public BatchGet setPrettyPrint(Boolean prettyPrint) {
                return (BatchGet)super.setPrettyPrint(prettyPrint);
            }

            public BatchGet setQuotaUser(String quotaUser) {
                return (BatchGet)super.setQuotaUser(quotaUser);
            }

            public BatchGet setUploadType(String uploadType) {
                return (BatchGet)super.setUploadType(uploadType);
            }

            public BatchGet setUploadProtocol(String uploadProtocol) {
                return (BatchGet)super.setUploadProtocol(uploadProtocol);
            }

            public String getGroupFields() {
                return this.groupFields;
            }

            public BatchGet setGroupFields(String groupFields) {
                this.groupFields = groupFields;
                return this;
            }

            public Integer getMaxMembers() {
                return this.maxMembers;
            }

            public BatchGet setMaxMembers(Integer maxMembers) {
                this.maxMembers = maxMembers;
                return this;
            }

            public java.util.List<String> getResourceNames() {
                return this.resourceNames;
            }

            public BatchGet setResourceNames(java.util.List<String> resourceNames) {
                this.resourceNames = resourceNames;
                return this;
            }

            @Override
            public BatchGet set(String parameterName, Object value) {
                return (BatchGet)super.set(parameterName, value);
            }
        }
    }
}

