/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.plus;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.Key;
import com.google.api.services.plus.ApiClient;
import com.google.api.services.plus.model.Activity;
import com.google.api.services.plus.model.ActivityFeed;
import com.google.api.services.plus.model.Comment;
import com.google.api.services.plus.model.CommentFeed;
import com.google.api.services.plus.model.PeopleFeed;
import com.google.api.services.plus.model.Person;
import java.io.IOException;

public class Plus
extends ApiClient {
    final Plus self;
    public final Activities activities = new Activities();
    public final Comments comments = new Comments();
    public final People people = new People();

    public Plus(HttpTransport transport, HttpRequestInitializer requestInitializer, JsonFactory jsonFactory) {
        super("https://www.googleapis.com", "/plus/v1/", transport, requestInitializer, jsonFactory);
        this.self = this;
    }

    public Plus(HttpTransport transport, JsonFactory jsonFactory) {
        this(transport, null, jsonFactory);
    }

    public Plus(String appName, HttpTransport transport, JsonFactory jsonFactory) {
        this(transport, null, jsonFactory);
        this.setApplicationName(appName);
    }

    class RemoteRequest
    extends GenericData {
        @Key
        private String fields;

        RemoteRequest() {
            this.fields = Plus.this.getFields();
        }

        public String getFields() {
            return this.fields;
        }

        public void setFields(String fields) {
            this.fields = fields;
        }

        HttpResponse execute(HttpMethod method, String requestUrl) throws IOException {
            HttpRequest request = Plus.this.self.buildHttpRequest(method, requestUrl, this);
            if (method == HttpMethod.POST) {
                request.setContent((HttpContent)ByteArrayContent.fromString((String)"application/json", (String)" "));
            }
            return request.execute();
        }

        HttpResponse execute(HttpMethod method, String requestUrl, Object body) throws IOException {
            HttpRequest request = Plus.this.self.buildHttpRequest(method, requestUrl, this);
            request.setContent((HttpContent)Plus.this.self.createSerializer(body));
            request.setEnableGZipContent(true);
            return request.execute();
        }
    }

    public class People {
        public ListByActivity listByActivity(String activityId, String collection) {
            return new ListByActivity(activityId, collection);
        }

        public Search search() {
            return new Search();
        }

        public Get get(String userId) {
            return new Get(userId);
        }

        public class Get
        extends RemoteRequest {
            private static final String REST_PATH = "people/{userId}";
            @Key(value="userId")
            private String userId;

            private Get(String userId) {
                this.userId = userId;
            }

            public Person execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                Person result = (Person)((Object)Plus.this.jsonParser.parse(response, Person.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public HttpResponse executeUnparsed() throws IOException {
                return super.execute(HttpMethod.GET, REST_PATH);
            }

            public String getUserId() {
                return this.userId;
            }

            public Get setUserId(String userId) {
                this.userId = userId;
                return this;
            }
        }

        public class Search
        extends RemoteRequest {
            private static final String REST_PATH = "people";
            @Key(value="pageToken")
            private String pageToken;
            @Key(value="maxResults")
            private Long maxResults;
            @Key(value="query")
            private String query;

            private Search() {
            }

            public PeopleFeed execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                PeopleFeed result = (PeopleFeed)((Object)Plus.this.jsonParser.parse(response, PeopleFeed.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public HttpResponse executeUnparsed() throws IOException {
                return super.execute(HttpMethod.GET, REST_PATH);
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Search setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public Search setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getQuery() {
                return this.query;
            }

            public Search setQuery(String query) {
                this.query = query;
                return this;
            }
        }

        public class ListByActivity
        extends RemoteRequest {
            private static final String REST_PATH = "activities/{activityId}/people/{collection}";
            @Key(value="activityId")
            private String activityId;
            @Key(value="collection")
            private String collection;
            @Key(value="pageToken")
            private String pageToken;
            @Key(value="maxResults")
            private Long maxResults;

            private ListByActivity(String activityId, String collection) {
                this.activityId = activityId;
                this.collection = collection;
            }

            public PeopleFeed execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                PeopleFeed result = (PeopleFeed)((Object)Plus.this.jsonParser.parse(response, PeopleFeed.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public HttpResponse executeUnparsed() throws IOException {
                return super.execute(HttpMethod.GET, REST_PATH);
            }

            public String getActivityId() {
                return this.activityId;
            }

            public ListByActivity setActivityId(String activityId) {
                this.activityId = activityId;
                return this;
            }

            public String getCollection() {
                return this.collection;
            }

            public ListByActivity setCollection(String collection) {
                this.collection = collection;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListByActivity setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public ListByActivity setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }
        }
    }

    public class Comments {
        public List list(String activityId) {
            return new List(activityId);
        }

        public Get get(String commentId) {
            return new Get(commentId);
        }

        public class Get
        extends RemoteRequest {
            private static final String REST_PATH = "comments/{commentId}";
            @Key(value="commentId")
            private String commentId;

            private Get(String commentId) {
                this.commentId = commentId;
            }

            public Comment execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                Comment result = (Comment)((Object)Plus.this.jsonParser.parse(response, Comment.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public HttpResponse executeUnparsed() throws IOException {
                return super.execute(HttpMethod.GET, REST_PATH);
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Get setCommentId(String commentId) {
                this.commentId = commentId;
                return this;
            }
        }

        public class List
        extends RemoteRequest {
            private static final String REST_PATH = "activities/{activityId}/comments";
            @Key(value="activityId")
            private String activityId;
            @Key(value="pageToken")
            private String pageToken;
            @Key(value="maxResults")
            private Long maxResults;

            private List(String activityId) {
                this.activityId = activityId;
            }

            public CommentFeed execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                CommentFeed result = (CommentFeed)((Object)Plus.this.jsonParser.parse(response, CommentFeed.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public HttpResponse executeUnparsed() throws IOException {
                return super.execute(HttpMethod.GET, REST_PATH);
            }

            public String getActivityId() {
                return this.activityId;
            }

            public List setActivityId(String activityId) {
                this.activityId = activityId;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }
        }
    }

    public class Activities {
        public Search search() {
            return new Search();
        }

        public List list(String userId, String collection) {
            return new List(userId, collection);
        }

        public Get get(String activityId) {
            return new Get(activityId);
        }

        public class Get
        extends RemoteRequest {
            private static final String REST_PATH = "activities/{activityId}";
            @Key(value="activityId")
            private String activityId;

            private Get(String activityId) {
                this.activityId = activityId;
            }

            public Activity execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                Activity result = (Activity)((Object)Plus.this.jsonParser.parse(response, Activity.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public HttpResponse executeUnparsed() throws IOException {
                return super.execute(HttpMethod.GET, REST_PATH);
            }

            public String getActivityId() {
                return this.activityId;
            }

            public Get setActivityId(String activityId) {
                this.activityId = activityId;
                return this;
            }
        }

        public class List
        extends RemoteRequest {
            private static final String REST_PATH = "people/{userId}/activities/{collection}";
            @Key(value="userId")
            private String userId;
            @Key(value="collection")
            private String collection;
            @Key(value="pageToken")
            private String pageToken;
            @Key(value="maxResults")
            private Long maxResults;

            private List(String userId, String collection) {
                this.userId = userId;
                this.collection = collection;
            }

            public ActivityFeed execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                ActivityFeed result = (ActivityFeed)((Object)Plus.this.jsonParser.parse(response, ActivityFeed.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public HttpResponse executeUnparsed() throws IOException {
                return super.execute(HttpMethod.GET, REST_PATH);
            }

            public String getUserId() {
                return this.userId;
            }

            public List setUserId(String userId) {
                this.userId = userId;
                return this;
            }

            public String getCollection() {
                return this.collection;
            }

            public List setCollection(String collection) {
                this.collection = collection;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }
        }

        public class Search
        extends RemoteRequest {
            private static final String REST_PATH = "activities";
            @Key(value="orderBy")
            private String orderBy;
            @Key(value="pageToken")
            private String pageToken;
            @Key(value="maxResults")
            private Long maxResults;
            @Key(value="query")
            private String query;

            private Search() {
            }

            public ActivityFeed execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                ActivityFeed result = (ActivityFeed)((Object)Plus.this.jsonParser.parse(response, ActivityFeed.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public HttpResponse executeUnparsed() throws IOException {
                return super.execute(HttpMethod.GET, REST_PATH);
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public Search setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Search setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public Search setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getQuery() {
                return this.query;
            }

            public Search setQuery(String query) {
                this.query = query;
                return this;
            }
        }
    }
}

