/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.plus;

import com.google.api.client.googleapis.batch.BatchRequest;
import com.google.api.client.googleapis.batch.json.JsonBatchCallback;
import com.google.api.client.googleapis.json.GoogleJsonErrorContainer;
import com.google.api.client.googleapis.services.GoogleClient;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpClient;
import com.google.api.client.http.json.JsonHttpRequestInitializer;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.services.plus.PlusRequest;
import com.google.api.services.plus.model.Activity;
import com.google.api.services.plus.model.ActivityFeed;
import com.google.api.services.plus.model.Comment;
import com.google.api.services.plus.model.CommentFeed;
import com.google.api.services.plus.model.PeopleFeed;
import com.google.api.services.plus.model.Person;
import com.google.common.base.Preconditions;
import java.io.IOException;

public class Plus
extends GoogleClient {
    public static final String DEFAULT_BASE_PATH = "/plus/v1/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/plus/v1/";

    public Plus(HttpTransport httpTransport, JsonFactory jsonFactory) {
        super(httpTransport, jsonFactory, DEFAULT_BASE_URL);
    }

    Plus(HttpTransport httpTransport, JsonHttpRequestInitializer jsonHttpRequestInitializer, HttpRequestInitializer httpRequestInitializer, JsonFactory jsonFactory, String string, String string2) {
        super(httpTransport, jsonHttpRequestInitializer, httpRequestInitializer, jsonFactory, string, string2);
    }

    public static Builder builder(HttpTransport httpTransport, JsonFactory jsonFactory) {
        return new Builder(httpTransport, jsonFactory);
    }

    public Activities activities() {
        return new Activities();
    }

    public Comments comments() {
        return new Comments();
    }

    public People people() {
        return new People();
    }

    public static final class Builder
    extends GoogleClient.Builder {
        Builder(HttpTransport httpTransport, JsonFactory jsonFactory) {
            super(httpTransport, jsonFactory, new GenericUrl(Plus.DEFAULT_BASE_URL));
        }

        public Plus build() {
            return new Plus(this.getTransport(), this.getJsonHttpRequestInitializer(), this.getHttpRequestInitializer(), this.getJsonFactory(), this.getBaseUrl().build(), this.getApplicationName());
        }

        public Builder setBaseUrl(GenericUrl genericUrl) {
            super.setBaseUrl(genericUrl);
            return this;
        }

        public Builder setJsonHttpRequestInitializer(JsonHttpRequestInitializer jsonHttpRequestInitializer) {
            super.setJsonHttpRequestInitializer(jsonHttpRequestInitializer);
            return this;
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            super.setHttpRequestInitializer(httpRequestInitializer);
            return this;
        }

        public Builder setApplicationName(String string) {
            super.setApplicationName(string);
            return this;
        }
    }

    public class People {
        public ListByActivity listByActivity(String string, String string2) throws IOException {
            ListByActivity listByActivity = new ListByActivity(string, string2);
            Plus.this.initialize(listByActivity);
            return listByActivity;
        }

        public Search search(String string) throws IOException {
            Search search = new Search(string);
            Plus.this.initialize(search);
            return search;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Plus.this.initialize(get);
            return get;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends PlusRequest {
            private static final String REST_PATH = "people/{userId}";
            @Key
            private String userId;

            private Get(String string) {
                super((JsonHttpClient)Plus.this, HttpMethod.GET, REST_PATH, null);
                this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
            }

            public Person execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                Person person = (Person)((Object)httpResponse.parseAs(Person.class));
                person.setResponseHeaders(httpResponse.getHeaders());
                return person;
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<Person> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), Person.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            public String getUserId() {
                return this.userId;
            }

            public Get setUserId(String string) {
                this.userId = string;
                return this;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Search
        extends PlusRequest {
            private static final String REST_PATH = "people";
            @Key
            private String query;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;
            @Key
            private String language;

            private Search(String string) {
                super((JsonHttpClient)Plus.this, HttpMethod.GET, REST_PATH, null);
                this.query = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter query must be specified.");
            }

            public PeopleFeed execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                PeopleFeed peopleFeed = (PeopleFeed)((Object)httpResponse.parseAs(PeopleFeed.class));
                peopleFeed.setResponseHeaders(httpResponse.getHeaders());
                return peopleFeed;
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<PeopleFeed> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), PeopleFeed.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            public String getQuery() {
                return this.query;
            }

            public Search setQuery(String string) {
                this.query = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Search setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public Search setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public Search setLanguage(String string) {
                this.language = string;
                return this;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ListByActivity
        extends PlusRequest {
            private static final String REST_PATH = "activities/{activityId}/people/{collection}";
            @Key
            private String activityId;
            @Key
            private String collection;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            private ListByActivity(String string, String string2) {
                super((JsonHttpClient)Plus.this, HttpMethod.GET, REST_PATH, null);
                this.activityId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter activityId must be specified.");
                this.collection = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter collection must be specified.");
            }

            public PeopleFeed execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                PeopleFeed peopleFeed = (PeopleFeed)((Object)httpResponse.parseAs(PeopleFeed.class));
                peopleFeed.setResponseHeaders(httpResponse.getHeaders());
                return peopleFeed;
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<PeopleFeed> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), PeopleFeed.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            public String getActivityId() {
                return this.activityId;
            }

            public ListByActivity setActivityId(String string) {
                this.activityId = string;
                return this;
            }

            public String getCollection() {
                return this.collection;
            }

            public ListByActivity setCollection(String string) {
                this.collection = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListByActivity setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public ListByActivity setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }
        }
    }

    public class Comments {
        public List list(String string) throws IOException {
            List list = new List(string);
            Plus.this.initialize(list);
            return list;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Plus.this.initialize(get);
            return get;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends PlusRequest {
            private static final String REST_PATH = "comments/{commentId}";
            @Key
            private String commentId;

            private Get(String string) {
                super((JsonHttpClient)Plus.this, HttpMethod.GET, REST_PATH, null);
                this.commentId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter commentId must be specified.");
            }

            public Comment execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                Comment comment = (Comment)((Object)httpResponse.parseAs(Comment.class));
                comment.setResponseHeaders(httpResponse.getHeaders());
                return comment;
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<Comment> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), Comment.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Get setCommentId(String string) {
                this.commentId = string;
                return this;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends PlusRequest {
            private static final String REST_PATH = "activities/{activityId}/comments";
            @Key
            private String activityId;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;
            @Key
            private String sortOrder;

            private List(String string) {
                super((JsonHttpClient)Plus.this, HttpMethod.GET, REST_PATH, null);
                this.activityId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter activityId must be specified.");
            }

            public CommentFeed execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                CommentFeed commentFeed = (CommentFeed)((Object)httpResponse.parseAs(CommentFeed.class));
                commentFeed.setResponseHeaders(httpResponse.getHeaders());
                return commentFeed;
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<CommentFeed> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), CommentFeed.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            public String getActivityId() {
                return this.activityId;
            }

            public List setActivityId(String string) {
                this.activityId = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getSortOrder() {
                return this.sortOrder;
            }

            public List setSortOrder(String string) {
                this.sortOrder = string;
                return this;
            }
        }
    }

    public class Activities {
        public Search search(String string) throws IOException {
            Search search = new Search(string);
            Plus.this.initialize(search);
            return search;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Plus.this.initialize(list);
            return list;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Plus.this.initialize(get);
            return get;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends PlusRequest {
            private static final String REST_PATH = "activities/{activityId}";
            @Key
            private String activityId;

            private Get(String string) {
                super((JsonHttpClient)Plus.this, HttpMethod.GET, REST_PATH, null);
                this.activityId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter activityId must be specified.");
            }

            public Activity execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                Activity activity = (Activity)((Object)httpResponse.parseAs(Activity.class));
                activity.setResponseHeaders(httpResponse.getHeaders());
                return activity;
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<Activity> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), Activity.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            public String getActivityId() {
                return this.activityId;
            }

            public Get setActivityId(String string) {
                this.activityId = string;
                return this;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends PlusRequest {
            private static final String REST_PATH = "people/{userId}/activities/{collection}";
            @Key
            private String userId;
            @Key
            private String collection;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            private List(String string, String string2) {
                super((JsonHttpClient)Plus.this, HttpMethod.GET, REST_PATH, null);
                this.userId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userId must be specified.");
                this.collection = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter collection must be specified.");
            }

            public ActivityFeed execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                ActivityFeed activityFeed = (ActivityFeed)((Object)httpResponse.parseAs(ActivityFeed.class));
                activityFeed.setResponseHeaders(httpResponse.getHeaders());
                return activityFeed;
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<ActivityFeed> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), ActivityFeed.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            public String getUserId() {
                return this.userId;
            }

            public List setUserId(String string) {
                this.userId = string;
                return this;
            }

            public String getCollection() {
                return this.collection;
            }

            public List setCollection(String string) {
                this.collection = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Search
        extends PlusRequest {
            private static final String REST_PATH = "activities";
            @Key
            private String query;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;
            @Key
            private String language;

            private Search(String string) {
                super((JsonHttpClient)Plus.this, HttpMethod.GET, REST_PATH, null);
                this.query = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter query must be specified.");
            }

            public ActivityFeed execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                ActivityFeed activityFeed = (ActivityFeed)((Object)httpResponse.parseAs(ActivityFeed.class));
                activityFeed.setResponseHeaders(httpResponse.getHeaders());
                return activityFeed;
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<ActivityFeed> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), ActivityFeed.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            public String getQuery() {
                return this.query;
            }

            public Search setQuery(String string) {
                this.query = string;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public Search setOrderBy(String string) {
                this.orderBy = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Search setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public Search setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public Search setLanguage(String string) {
                this.language = string;
                return this;
            }
        }
    }
}

