/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2013-04-29 14:08:19 UTC)
 * on 2013-05-01 at 03:11:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.plus.model;

/**
 * Model definition for ItemScope.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google+ API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ItemScope extends com.google.api.client.json.GenericJson {

  /**
   * The subject matter of the content.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ItemScope about;

  /**
   * An additional name for a Person, can be used for a middle name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> additionalName;

  /**
   * Postal address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ItemScope address;

  /**
   * Address country.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String addressCountry;

  /**
   * Address locality.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String addressLocality;

  /**
   * Address region.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String addressRegion;

  /**
   * The encoding.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("associated_media")
  private java.util.List<ItemScope> associatedMedia;

  /**
   * Number of attendees.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer attendeeCount;

  /**
   * A person attending the event.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ItemScope> attendees;

  /**
   * From http://schema.org/MusicRecording, the audio file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ItemScope audio;

  /**
   * The person or persons who created this result. In the example of restaurant reviews, this might
   * be the reviewer's name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ItemScope> author;

  /**
   * Best possible rating value that a result might obtain. This property defines the upper bound
   * for the ratingValue. For example, you might have a 5 star rating scale, you would provide 5 as
   * the value for this property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bestRating;

  /**
   * Date of birth.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String birthDate;

  /**
   * From http://schema.org/MusicRecording, the artist that performed this recording.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ItemScope byArtist;

  /**
   * The caption for this object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String caption;

  /**
   * File size in (mega/kilo) bytes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String contentSize;

  /**
   * Actual bytes of the media object, for example the image file or video file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String contentUrl;

  /**
   * A list of contributors to this result.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ItemScope> contributor;

  /**
   * The date the result was created such as the date that a review was first created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dateCreated;

  /**
   * The date the result was last modified such as the date that a review was last edited.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dateModified;

  /**
   * The initial date that the result was published. For example, a user writes a comment on a blog,
   * which has a result.dateCreated of when they submit it. If the blog users comment moderation,
   * the result.datePublished value would match the date when the owner approved the message.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String datePublished;

  /**
   * The string that describes the content of the result.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * The duration of the item (movie, audio recording, event, etc.) in ISO 8601 date format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String duration;

  /**
   * A URL pointing to a player for a specific video. In general, this is the information in the src
   * element of an embed tag and should not be the same as the content of the loc tag.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String embedUrl;

  /**
   * The end date and time of the event (in ISO 8601 date format).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String endDate;

  /**
   * Family name. This property can be used with givenName instead of the name property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String familyName;

  /**
   * Gender of the person.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String gender;

  /**
   * Geo coordinates.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ItemScope geo;

  /**
   * Given name. This property can be used with familyName instead of the name property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String givenName;

  /**
   * The height of the media object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String height;

  /**
   * An identifier for the target. Your app can choose how to identify targets. The target.id is
   * required if you are writing an activity that does not have a corresponding web page or
   * target.url property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * A URL to the image that represents this result. For example, if a user writes a review of a
   * restaurant and attaches a photo of their meal, you might use that photo as the result.image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String image;

  /**
   * From http://schema.org/MusicRecording, which album a song is in.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ItemScope inAlbum;

  /**
   * Identifies this resource as an itemScope.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Latitude.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double latitude;

  /**
   * The location of the event or organization.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ItemScope location;

  /**
   * Longitude.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double longitude;

  /**
   * The name of the result. In the example of a restaurant review, this might be the summary the
   * user gave their review such as "Great ambiance, but overpriced."
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Property of http://schema.org/TVEpisode indicating which series the episode belongs to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ItemScope partOfTVSeries;

  /**
   * The main performer or performers of the event-for example, a presenter, musician, or actor.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ItemScope> performers;

  /**
   * Player type that is required. For example: Flash or Silverlight.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String playerType;

  /**
   * Post office box number.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String postOfficeBoxNumber;

  /**
   * Postal code.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String postalCode;

  /**
   * Rating value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ratingValue;

  /**
   * Review rating.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ItemScope reviewRating;

  /**
   * The start date and time of the event (in ISO 8601 date format).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String startDate;

  /**
   * Street address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String streetAddress;

  /**
   * The text that is the result of the app activity. For example, if a user leaves a review of a
   * restaurant, this might be the text of the review.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String text;

  /**
   * Thumbnail image for an image or video.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ItemScope thumbnail;

  /**
   * A URL to a thumbnail image that represents this result.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String thumbnailUrl;

  /**
   * The exchange traded instrument associated with a Corporation object. The tickerSymbol is
   * expressed as an exchange and an instrument name separated by a space character. For the
   * exchange component of the tickerSymbol attribute, we reccommend using the controlled vocaulary
   * of Market Identifier Codes (MIC) specified in ISO15022.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tickerSymbol;

  /**
   * The schema.org URL that best describes the referenced target and matches the type of moment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The URL that points to the result object. For example, a permalink directly to a restaurant
   * reviewer's comment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String url;

  /**
   * The width of the media object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String width;

  /**
   * Worst possible rating value that a result might obtain. This property defines the lower bound
   * for the ratingValue.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String worstRating;

  /**
   * The subject matter of the content.
   * @return value or {@code null} for none
   */
  public ItemScope getAbout() {
    return about;
  }

  /**
   * The subject matter of the content.
   * @param about about or {@code null} for none
   */
  public ItemScope setAbout(ItemScope about) {
    this.about = about;
    return this;
  }

  /**
   * An additional name for a Person, can be used for a middle name.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAdditionalName() {
    return additionalName;
  }

  /**
   * An additional name for a Person, can be used for a middle name.
   * @param additionalName additionalName or {@code null} for none
   */
  public ItemScope setAdditionalName(java.util.List<java.lang.String> additionalName) {
    this.additionalName = additionalName;
    return this;
  }

  /**
   * Postal address.
   * @return value or {@code null} for none
   */
  public ItemScope getAddress() {
    return address;
  }

  /**
   * Postal address.
   * @param address address or {@code null} for none
   */
  public ItemScope setAddress(ItemScope address) {
    this.address = address;
    return this;
  }

  /**
   * Address country.
   * @return value or {@code null} for none
   */
  public java.lang.String getAddressCountry() {
    return addressCountry;
  }

  /**
   * Address country.
   * @param addressCountry addressCountry or {@code null} for none
   */
  public ItemScope setAddressCountry(java.lang.String addressCountry) {
    this.addressCountry = addressCountry;
    return this;
  }

  /**
   * Address locality.
   * @return value or {@code null} for none
   */
  public java.lang.String getAddressLocality() {
    return addressLocality;
  }

  /**
   * Address locality.
   * @param addressLocality addressLocality or {@code null} for none
   */
  public ItemScope setAddressLocality(java.lang.String addressLocality) {
    this.addressLocality = addressLocality;
    return this;
  }

  /**
   * Address region.
   * @return value or {@code null} for none
   */
  public java.lang.String getAddressRegion() {
    return addressRegion;
  }

  /**
   * Address region.
   * @param addressRegion addressRegion or {@code null} for none
   */
  public ItemScope setAddressRegion(java.lang.String addressRegion) {
    this.addressRegion = addressRegion;
    return this;
  }

  /**
   * The encoding.
   * @return value or {@code null} for none
   */
  public java.util.List<ItemScope> getAssociatedMedia() {
    return associatedMedia;
  }

  /**
   * The encoding.
   * @param associatedMedia associatedMedia or {@code null} for none
   */
  public ItemScope setAssociatedMedia(java.util.List<ItemScope> associatedMedia) {
    this.associatedMedia = associatedMedia;
    return this;
  }

  /**
   * Number of attendees.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getAttendeeCount() {
    return attendeeCount;
  }

  /**
   * Number of attendees.
   * @param attendeeCount attendeeCount or {@code null} for none
   */
  public ItemScope setAttendeeCount(java.lang.Integer attendeeCount) {
    this.attendeeCount = attendeeCount;
    return this;
  }

  /**
   * A person attending the event.
   * @return value or {@code null} for none
   */
  public java.util.List<ItemScope> getAttendees() {
    return attendees;
  }

  /**
   * A person attending the event.
   * @param attendees attendees or {@code null} for none
   */
  public ItemScope setAttendees(java.util.List<ItemScope> attendees) {
    this.attendees = attendees;
    return this;
  }

  /**
   * From http://schema.org/MusicRecording, the audio file.
   * @return value or {@code null} for none
   */
  public ItemScope getAudio() {
    return audio;
  }

  /**
   * From http://schema.org/MusicRecording, the audio file.
   * @param audio audio or {@code null} for none
   */
  public ItemScope setAudio(ItemScope audio) {
    this.audio = audio;
    return this;
  }

  /**
   * The person or persons who created this result. In the example of restaurant reviews, this might
   * be the reviewer's name.
   * @return value or {@code null} for none
   */
  public java.util.List<ItemScope> getAuthor() {
    return author;
  }

  /**
   * The person or persons who created this result. In the example of restaurant reviews, this might
   * be the reviewer's name.
   * @param author author or {@code null} for none
   */
  public ItemScope setAuthor(java.util.List<ItemScope> author) {
    this.author = author;
    return this;
  }

  /**
   * Best possible rating value that a result might obtain. This property defines the upper bound
   * for the ratingValue. For example, you might have a 5 star rating scale, you would provide 5 as
   * the value for this property.
   * @return value or {@code null} for none
   */
  public java.lang.String getBestRating() {
    return bestRating;
  }

  /**
   * Best possible rating value that a result might obtain. This property defines the upper bound
   * for the ratingValue. For example, you might have a 5 star rating scale, you would provide 5 as
   * the value for this property.
   * @param bestRating bestRating or {@code null} for none
   */
  public ItemScope setBestRating(java.lang.String bestRating) {
    this.bestRating = bestRating;
    return this;
  }

  /**
   * Date of birth.
   * @return value or {@code null} for none
   */
  public java.lang.String getBirthDate() {
    return birthDate;
  }

  /**
   * Date of birth.
   * @param birthDate birthDate or {@code null} for none
   */
  public ItemScope setBirthDate(java.lang.String birthDate) {
    this.birthDate = birthDate;
    return this;
  }

  /**
   * From http://schema.org/MusicRecording, the artist that performed this recording.
   * @return value or {@code null} for none
   */
  public ItemScope getByArtist() {
    return byArtist;
  }

  /**
   * From http://schema.org/MusicRecording, the artist that performed this recording.
   * @param byArtist byArtist or {@code null} for none
   */
  public ItemScope setByArtist(ItemScope byArtist) {
    this.byArtist = byArtist;
    return this;
  }

  /**
   * The caption for this object.
   * @return value or {@code null} for none
   */
  public java.lang.String getCaption() {
    return caption;
  }

  /**
   * The caption for this object.
   * @param caption caption or {@code null} for none
   */
  public ItemScope setCaption(java.lang.String caption) {
    this.caption = caption;
    return this;
  }

  /**
   * File size in (mega/kilo) bytes.
   * @return value or {@code null} for none
   */
  public java.lang.String getContentSize() {
    return contentSize;
  }

  /**
   * File size in (mega/kilo) bytes.
   * @param contentSize contentSize or {@code null} for none
   */
  public ItemScope setContentSize(java.lang.String contentSize) {
    this.contentSize = contentSize;
    return this;
  }

  /**
   * Actual bytes of the media object, for example the image file or video file.
   * @return value or {@code null} for none
   */
  public java.lang.String getContentUrl() {
    return contentUrl;
  }

  /**
   * Actual bytes of the media object, for example the image file or video file.
   * @param contentUrl contentUrl or {@code null} for none
   */
  public ItemScope setContentUrl(java.lang.String contentUrl) {
    this.contentUrl = contentUrl;
    return this;
  }

  /**
   * A list of contributors to this result.
   * @return value or {@code null} for none
   */
  public java.util.List<ItemScope> getContributor() {
    return contributor;
  }

  /**
   * A list of contributors to this result.
   * @param contributor contributor or {@code null} for none
   */
  public ItemScope setContributor(java.util.List<ItemScope> contributor) {
    this.contributor = contributor;
    return this;
  }

  /**
   * The date the result was created such as the date that a review was first created.
   * @return value or {@code null} for none
   */
  public java.lang.String getDateCreated() {
    return dateCreated;
  }

  /**
   * The date the result was created such as the date that a review was first created.
   * @param dateCreated dateCreated or {@code null} for none
   */
  public ItemScope setDateCreated(java.lang.String dateCreated) {
    this.dateCreated = dateCreated;
    return this;
  }

  /**
   * The date the result was last modified such as the date that a review was last edited.
   * @return value or {@code null} for none
   */
  public java.lang.String getDateModified() {
    return dateModified;
  }

  /**
   * The date the result was last modified such as the date that a review was last edited.
   * @param dateModified dateModified or {@code null} for none
   */
  public ItemScope setDateModified(java.lang.String dateModified) {
    this.dateModified = dateModified;
    return this;
  }

  /**
   * The initial date that the result was published. For example, a user writes a comment on a blog,
   * which has a result.dateCreated of when they submit it. If the blog users comment moderation,
   * the result.datePublished value would match the date when the owner approved the message.
   * @return value or {@code null} for none
   */
  public java.lang.String getDatePublished() {
    return datePublished;
  }

  /**
   * The initial date that the result was published. For example, a user writes a comment on a blog,
   * which has a result.dateCreated of when they submit it. If the blog users comment moderation,
   * the result.datePublished value would match the date when the owner approved the message.
   * @param datePublished datePublished or {@code null} for none
   */
  public ItemScope setDatePublished(java.lang.String datePublished) {
    this.datePublished = datePublished;
    return this;
  }

  /**
   * The string that describes the content of the result.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * The string that describes the content of the result.
   * @param description description or {@code null} for none
   */
  public ItemScope setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * The duration of the item (movie, audio recording, event, etc.) in ISO 8601 date format.
   * @return value or {@code null} for none
   */
  public java.lang.String getDuration() {
    return duration;
  }

  /**
   * The duration of the item (movie, audio recording, event, etc.) in ISO 8601 date format.
   * @param duration duration or {@code null} for none
   */
  public ItemScope setDuration(java.lang.String duration) {
    this.duration = duration;
    return this;
  }

  /**
   * A URL pointing to a player for a specific video. In general, this is the information in the src
   * element of an embed tag and should not be the same as the content of the loc tag.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmbedUrl() {
    return embedUrl;
  }

  /**
   * A URL pointing to a player for a specific video. In general, this is the information in the src
   * element of an embed tag and should not be the same as the content of the loc tag.
   * @param embedUrl embedUrl or {@code null} for none
   */
  public ItemScope setEmbedUrl(java.lang.String embedUrl) {
    this.embedUrl = embedUrl;
    return this;
  }

  /**
   * The end date and time of the event (in ISO 8601 date format).
   * @return value or {@code null} for none
   */
  public java.lang.String getEndDate() {
    return endDate;
  }

  /**
   * The end date and time of the event (in ISO 8601 date format).
   * @param endDate endDate or {@code null} for none
   */
  public ItemScope setEndDate(java.lang.String endDate) {
    this.endDate = endDate;
    return this;
  }

  /**
   * Family name. This property can be used with givenName instead of the name property.
   * @return value or {@code null} for none
   */
  public java.lang.String getFamilyName() {
    return familyName;
  }

  /**
   * Family name. This property can be used with givenName instead of the name property.
   * @param familyName familyName or {@code null} for none
   */
  public ItemScope setFamilyName(java.lang.String familyName) {
    this.familyName = familyName;
    return this;
  }

  /**
   * Gender of the person.
   * @return value or {@code null} for none
   */
  public java.lang.String getGender() {
    return gender;
  }

  /**
   * Gender of the person.
   * @param gender gender or {@code null} for none
   */
  public ItemScope setGender(java.lang.String gender) {
    this.gender = gender;
    return this;
  }

  /**
   * Geo coordinates.
   * @return value or {@code null} for none
   */
  public ItemScope getGeo() {
    return geo;
  }

  /**
   * Geo coordinates.
   * @param geo geo or {@code null} for none
   */
  public ItemScope setGeo(ItemScope geo) {
    this.geo = geo;
    return this;
  }

  /**
   * Given name. This property can be used with familyName instead of the name property.
   * @return value or {@code null} for none
   */
  public java.lang.String getGivenName() {
    return givenName;
  }

  /**
   * Given name. This property can be used with familyName instead of the name property.
   * @param givenName givenName or {@code null} for none
   */
  public ItemScope setGivenName(java.lang.String givenName) {
    this.givenName = givenName;
    return this;
  }

  /**
   * The height of the media object.
   * @return value or {@code null} for none
   */
  public java.lang.String getHeight() {
    return height;
  }

  /**
   * The height of the media object.
   * @param height height or {@code null} for none
   */
  public ItemScope setHeight(java.lang.String height) {
    this.height = height;
    return this;
  }

  /**
   * An identifier for the target. Your app can choose how to identify targets. The target.id is
   * required if you are writing an activity that does not have a corresponding web page or
   * target.url property.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * An identifier for the target. Your app can choose how to identify targets. The target.id is
   * required if you are writing an activity that does not have a corresponding web page or
   * target.url property.
   * @param id id or {@code null} for none
   */
  public ItemScope setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * A URL to the image that represents this result. For example, if a user writes a review of a
   * restaurant and attaches a photo of their meal, you might use that photo as the result.image.
   * @return value or {@code null} for none
   */
  public java.lang.String getImage() {
    return image;
  }

  /**
   * A URL to the image that represents this result. For example, if a user writes a review of a
   * restaurant and attaches a photo of their meal, you might use that photo as the result.image.
   * @param image image or {@code null} for none
   */
  public ItemScope setImage(java.lang.String image) {
    this.image = image;
    return this;
  }

  /**
   * From http://schema.org/MusicRecording, which album a song is in.
   * @return value or {@code null} for none
   */
  public ItemScope getInAlbum() {
    return inAlbum;
  }

  /**
   * From http://schema.org/MusicRecording, which album a song is in.
   * @param inAlbum inAlbum or {@code null} for none
   */
  public ItemScope setInAlbum(ItemScope inAlbum) {
    this.inAlbum = inAlbum;
    return this;
  }

  /**
   * Identifies this resource as an itemScope.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies this resource as an itemScope.
   * @param kind kind or {@code null} for none
   */
  public ItemScope setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Latitude.
   * @return value or {@code null} for none
   */
  public java.lang.Double getLatitude() {
    return latitude;
  }

  /**
   * Latitude.
   * @param latitude latitude or {@code null} for none
   */
  public ItemScope setLatitude(java.lang.Double latitude) {
    this.latitude = latitude;
    return this;
  }

  /**
   * The location of the event or organization.
   * @return value or {@code null} for none
   */
  public ItemScope getLocation() {
    return location;
  }

  /**
   * The location of the event or organization.
   * @param location location or {@code null} for none
   */
  public ItemScope setLocation(ItemScope location) {
    this.location = location;
    return this;
  }

  /**
   * Longitude.
   * @return value or {@code null} for none
   */
  public java.lang.Double getLongitude() {
    return longitude;
  }

  /**
   * Longitude.
   * @param longitude longitude or {@code null} for none
   */
  public ItemScope setLongitude(java.lang.Double longitude) {
    this.longitude = longitude;
    return this;
  }

  /**
   * The name of the result. In the example of a restaurant review, this might be the summary the
   * user gave their review such as "Great ambiance, but overpriced."
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the result. In the example of a restaurant review, this might be the summary the
   * user gave their review such as "Great ambiance, but overpriced."
   * @param name name or {@code null} for none
   */
  public ItemScope setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Property of http://schema.org/TVEpisode indicating which series the episode belongs to.
   * @return value or {@code null} for none
   */
  public ItemScope getPartOfTVSeries() {
    return partOfTVSeries;
  }

  /**
   * Property of http://schema.org/TVEpisode indicating which series the episode belongs to.
   * @param partOfTVSeries partOfTVSeries or {@code null} for none
   */
  public ItemScope setPartOfTVSeries(ItemScope partOfTVSeries) {
    this.partOfTVSeries = partOfTVSeries;
    return this;
  }

  /**
   * The main performer or performers of the event-for example, a presenter, musician, or actor.
   * @return value or {@code null} for none
   */
  public java.util.List<ItemScope> getPerformers() {
    return performers;
  }

  /**
   * The main performer or performers of the event-for example, a presenter, musician, or actor.
   * @param performers performers or {@code null} for none
   */
  public ItemScope setPerformers(java.util.List<ItemScope> performers) {
    this.performers = performers;
    return this;
  }

  /**
   * Player type that is required. For example: Flash or Silverlight.
   * @return value or {@code null} for none
   */
  public java.lang.String getPlayerType() {
    return playerType;
  }

  /**
   * Player type that is required. For example: Flash or Silverlight.
   * @param playerType playerType or {@code null} for none
   */
  public ItemScope setPlayerType(java.lang.String playerType) {
    this.playerType = playerType;
    return this;
  }

  /**
   * Post office box number.
   * @return value or {@code null} for none
   */
  public java.lang.String getPostOfficeBoxNumber() {
    return postOfficeBoxNumber;
  }

  /**
   * Post office box number.
   * @param postOfficeBoxNumber postOfficeBoxNumber or {@code null} for none
   */
  public ItemScope setPostOfficeBoxNumber(java.lang.String postOfficeBoxNumber) {
    this.postOfficeBoxNumber = postOfficeBoxNumber;
    return this;
  }

  /**
   * Postal code.
   * @return value or {@code null} for none
   */
  public java.lang.String getPostalCode() {
    return postalCode;
  }

  /**
   * Postal code.
   * @param postalCode postalCode or {@code null} for none
   */
  public ItemScope setPostalCode(java.lang.String postalCode) {
    this.postalCode = postalCode;
    return this;
  }

  /**
   * Rating value.
   * @return value or {@code null} for none
   */
  public java.lang.String getRatingValue() {
    return ratingValue;
  }

  /**
   * Rating value.
   * @param ratingValue ratingValue or {@code null} for none
   */
  public ItemScope setRatingValue(java.lang.String ratingValue) {
    this.ratingValue = ratingValue;
    return this;
  }

  /**
   * Review rating.
   * @return value or {@code null} for none
   */
  public ItemScope getReviewRating() {
    return reviewRating;
  }

  /**
   * Review rating.
   * @param reviewRating reviewRating or {@code null} for none
   */
  public ItemScope setReviewRating(ItemScope reviewRating) {
    this.reviewRating = reviewRating;
    return this;
  }

  /**
   * The start date and time of the event (in ISO 8601 date format).
   * @return value or {@code null} for none
   */
  public java.lang.String getStartDate() {
    return startDate;
  }

  /**
   * The start date and time of the event (in ISO 8601 date format).
   * @param startDate startDate or {@code null} for none
   */
  public ItemScope setStartDate(java.lang.String startDate) {
    this.startDate = startDate;
    return this;
  }

  /**
   * Street address.
   * @return value or {@code null} for none
   */
  public java.lang.String getStreetAddress() {
    return streetAddress;
  }

  /**
   * Street address.
   * @param streetAddress streetAddress or {@code null} for none
   */
  public ItemScope setStreetAddress(java.lang.String streetAddress) {
    this.streetAddress = streetAddress;
    return this;
  }

  /**
   * The text that is the result of the app activity. For example, if a user leaves a review of a
   * restaurant, this might be the text of the review.
   * @return value or {@code null} for none
   */
  public java.lang.String getText() {
    return text;
  }

  /**
   * The text that is the result of the app activity. For example, if a user leaves a review of a
   * restaurant, this might be the text of the review.
   * @param text text or {@code null} for none
   */
  public ItemScope setText(java.lang.String text) {
    this.text = text;
    return this;
  }

  /**
   * Thumbnail image for an image or video.
   * @return value or {@code null} for none
   */
  public ItemScope getThumbnail() {
    return thumbnail;
  }

  /**
   * Thumbnail image for an image or video.
   * @param thumbnail thumbnail or {@code null} for none
   */
  public ItemScope setThumbnail(ItemScope thumbnail) {
    this.thumbnail = thumbnail;
    return this;
  }

  /**
   * A URL to a thumbnail image that represents this result.
   * @return value or {@code null} for none
   */
  public java.lang.String getThumbnailUrl() {
    return thumbnailUrl;
  }

  /**
   * A URL to a thumbnail image that represents this result.
   * @param thumbnailUrl thumbnailUrl or {@code null} for none
   */
  public ItemScope setThumbnailUrl(java.lang.String thumbnailUrl) {
    this.thumbnailUrl = thumbnailUrl;
    return this;
  }

  /**
   * The exchange traded instrument associated with a Corporation object. The tickerSymbol is
   * expressed as an exchange and an instrument name separated by a space character. For the
   * exchange component of the tickerSymbol attribute, we reccommend using the controlled vocaulary
   * of Market Identifier Codes (MIC) specified in ISO15022.
   * @return value or {@code null} for none
   */
  public java.lang.String getTickerSymbol() {
    return tickerSymbol;
  }

  /**
   * The exchange traded instrument associated with a Corporation object. The tickerSymbol is
   * expressed as an exchange and an instrument name separated by a space character. For the
   * exchange component of the tickerSymbol attribute, we reccommend using the controlled vocaulary
   * of Market Identifier Codes (MIC) specified in ISO15022.
   * @param tickerSymbol tickerSymbol or {@code null} for none
   */
  public ItemScope setTickerSymbol(java.lang.String tickerSymbol) {
    this.tickerSymbol = tickerSymbol;
    return this;
  }

  /**
   * The schema.org URL that best describes the referenced target and matches the type of moment.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The schema.org URL that best describes the referenced target and matches the type of moment.
   * @param type type or {@code null} for none
   */
  public ItemScope setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * The URL that points to the result object. For example, a permalink directly to a restaurant
   * reviewer's comment.
   * @return value or {@code null} for none
   */
  public java.lang.String getUrl() {
    return url;
  }

  /**
   * The URL that points to the result object. For example, a permalink directly to a restaurant
   * reviewer's comment.
   * @param url url or {@code null} for none
   */
  public ItemScope setUrl(java.lang.String url) {
    this.url = url;
    return this;
  }

  /**
   * The width of the media object.
   * @return value or {@code null} for none
   */
  public java.lang.String getWidth() {
    return width;
  }

  /**
   * The width of the media object.
   * @param width width or {@code null} for none
   */
  public ItemScope setWidth(java.lang.String width) {
    this.width = width;
    return this;
  }

  /**
   * Worst possible rating value that a result might obtain. This property defines the lower bound
   * for the ratingValue.
   * @return value or {@code null} for none
   */
  public java.lang.String getWorstRating() {
    return worstRating;
  }

  /**
   * Worst possible rating value that a result might obtain. This property defines the lower bound
   * for the ratingValue.
   * @param worstRating worstRating or {@code null} for none
   */
  public ItemScope setWorstRating(java.lang.String worstRating) {
    this.worstRating = worstRating;
    return this;
  }

  @Override
  public ItemScope set(String fieldName, Object value) {
    return (ItemScope) super.set(fieldName, value);
  }

  @Override
  public ItemScope clone() {
    return (ItemScope) super.clone();
  }

}
