/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.html.types;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.html.types.SafeScript;
import com.google.appengine.repackaged.com.google.common.html.types.SafeScriptProto;
import com.google.appengine.repackaged.com.google.common.io.Resources;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CheckReturnValue;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CompileTimeConstant;
import java.io.IOException;
import java.nio.charset.Charset;

@CheckReturnValue
@GwtCompatible(emulated=true)
public final class SafeScripts {
    private SafeScripts() {
    }

    public static SafeScript fromConstant(@CompileTimeConstant String script) {
        if (script.length() == 0) {
            return SafeScript.EMPTY;
        }
        return SafeScripts.create(script);
    }

    @GwtIncompatible(value="Resources")
    public static SafeScript fromResource(@CompileTimeConstant String resourceName, Charset charset) throws IOException {
        return SafeScripts.create(Resources.toString(Resources.getResource(resourceName), charset));
    }

    @GwtIncompatible(value="Resources")
    public static SafeScript fromResource(Class<?> contextClass, @CompileTimeConstant String resourceName, Charset charset) throws IOException {
        return SafeScripts.create(Resources.toString(Resources.getResource(contextClass, resourceName), charset));
    }

    public static SafeScript immediatelyInvokedFunctionExpression(SafeScript contents) {
        return SafeScripts.create("(function(){" + contents.getSafeScriptString() + "})();");
    }

    public static SafeScript fromProto(SafeScriptProto proto) {
        return SafeScripts.create(proto.getPrivateDoNotAccessOrElseSafeScriptWrappedValue());
    }

    public static SafeScriptProto toProto(SafeScript script) {
        return SafeScriptProto.newBuilder().setPrivateDoNotAccessOrElseSafeScriptWrappedValue(script.getSafeScriptString()).build();
    }

    static SafeScript create(String script) {
        return new SafeScript(script);
    }
}

