/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.html.types;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.flags.Flag;
import com.google.appengine.repackaged.com.google.common.html.types.TrustedResourceUrl;
import com.google.appengine.repackaged.com.google.common.html.types.TrustedResourceUrls;
import com.google.appengine.repackaged.com.google.common.net.UrlEscapers;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CheckReturnValue;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CompileTimeConstant;
import com.google.security.types.common.TrustedString;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@CheckReturnValue
@NotThreadSafe
@GwtCompatible(emulated=true)
public final class TrustedResourceUrlBuilder {
    private final StringBuilder url = new StringBuilder();
    private static final String BASE_URL_REGEX = "^((https:)?//[0-9A-Za-z.:\\[\\]-]+/|/[^/\\\\]|[^:/\\\\]+/|[^:/\\\\]*[?#]|about:blank#).*";

    public TrustedResourceUrlBuilder(@CompileTimeConstant String string) {
        TrustedResourceUrlBuilder.checkBaseUrl(string);
        this.url.append(string);
    }

    public TrustedResourceUrlBuilder(TrustedResourceUrl trustedResourceUrl) {
        String urlString = trustedResourceUrl.getTrustedResourceUrlString();
        TrustedResourceUrlBuilder.checkBaseUrl(urlString);
        this.url.append(urlString);
    }

    private TrustedResourceUrlBuilder() {
    }

    @Deprecated
    @GoogleInternal
    @GwtIncompatible(value="Flag")
    public TrustedResourceUrlBuilder(Flag<String> flag) {
        this.url.append(flag.get());
    }

    @GoogleInternal
    @GwtIncompatible(value="Flag")
    public static TrustedResourceUrlBuilder fromFlag(Flag<?> flag) {
        TrustedResourceUrlBuilder builder = new TrustedResourceUrlBuilder();
        String value = flag.parsableStringValue();
        TrustedResourceUrlBuilder.checkBaseUrl(value);
        builder.url.append(value);
        return builder;
    }

    @CanIgnoreReturnValue
    public TrustedResourceUrlBuilder append(@CompileTimeConstant String string) {
        this.url.append(string);
        return this;
    }

    @GwtIncompatible(value="TrustedString")
    public static TrustedResourceUrlBuilder fromTrustedString(TrustedString string) {
        TrustedResourceUrlBuilder.checkBaseUrl(string.toString());
        return new TrustedResourceUrlBuilder().append(string);
    }

    @CanIgnoreReturnValue
    @GwtIncompatible(value="TrustedString")
    public TrustedResourceUrlBuilder append(TrustedString string) {
        this.url.append(string.toString());
        return this;
    }

    @CanIgnoreReturnValue
    public TrustedResourceUrlBuilder appendEncoded(String string) {
        TrustedResourceUrlBuilder.checkBaseUrl(this.url.toString());
        this.url.append(UrlEscapers.urlFormParameterEscaper().escape(string));
        return this;
    }

    @CanIgnoreReturnValue
    public TrustedResourceUrlBuilder appendQueryParam(String name, String value) {
        if (this.url.indexOf("#") >= 0) {
            throw new IllegalStateException("Cannot add query parameters after a fragment was added, URL: " + this.url.toString());
        }
        int qmark = this.url.indexOf("?");
        if (qmark < 0) {
            this.url.append('?');
        } else if (qmark + 1 != this.url.length()) {
            this.url.append('&');
        }
        this.url.append(UrlEscapers.urlFormParameterEscaper().escape(name));
        this.url.append('=');
        this.url.append(UrlEscapers.urlFormParameterEscaper().escape(value));
        return this;
    }

    private static void checkBaseUrl(@Nullable String baseUrl) {
        if (!Preconditions.checkNotNull(baseUrl).matches(BASE_URL_REGEX)) {
            throw new IllegalArgumentException("TrustedResourceUrls must have a prefix that sets the scheme and origin, e.g. \"//google.com/\" or \"/path\", got:" + baseUrl);
        }
    }

    public TrustedResourceUrl build() {
        return TrustedResourceUrls.create(this.url.toString());
    }
}

