/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.xml;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.xml.XPathFinder;
import java.util.AbstractList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@GoogleInternal
@GwtIncompatible
public final class XPathFinders {
    private XPathFinders() {
    }

    public static XPathFinder compile(String expression) {
        Preconditions.checkNotNull(expression);
        return new Finder(expression, null);
    }

    public static XPathFinder compile(String expression, XPath xpath) {
        Preconditions.checkNotNull(expression);
        Preconditions.checkNotNull(xpath);
        return new Finder(expression, xpath);
    }

    public static XPathFinder synchronizedFinder(XPathFinder finder) {
        Preconditions.checkNotNull(finder);
        return new SynchronizedFinder(finder);
    }

    public static XPathFinder threadLocalFinder(XPathFinder finder) {
        Preconditions.checkNotNull(finder);
        return new ThreadLocalFinder(finder);
    }

    private static final class Finder
    implements XPathFinder {
        private final String string;
        private final XPathExpression expression;
        private final XPath xpath;

        public Finder(String expression, @Nullable XPath xpath) {
            Preconditions.checkNotNull(expression);
            this.string = expression;
            this.xpath = xpath;
            try {
                this.expression = (xpath == null ? XPathFactory.newInstance().newXPath() : xpath).compile(expression);
            }
            catch (XPathExpressionException e) {
                throw new IllegalArgumentException(expression, e);
            }
        }

        @Override
        public boolean find(Node node) throws XPathExpressionException {
            Preconditions.checkNotNull(node);
            return (Boolean)this.expression.evaluate(node, XPathConstants.BOOLEAN);
        }

        @Override
        public String findString(Node node) throws XPathExpressionException {
            Preconditions.checkNotNull(node);
            return (String)this.expression.evaluate(node, XPathConstants.STRING);
        }

        @Override
        public List<String> findStrings(Node node) throws XPathExpressionException {
            Preconditions.checkNotNull(node);
            final NodeList list = (NodeList)this.expression.evaluate(node, XPathConstants.NODESET);
            return new AbstractList<String>(this){

                @Override
                public int size() {
                    return list.getLength();
                }

                @Override
                public String get(int index) {
                    return list.item(index).getTextContent();
                }
            };
        }

        @Override
        public Node findNode(Node node) throws XPathExpressionException {
            Preconditions.checkNotNull(node);
            return (Node)this.expression.evaluate(node, XPathConstants.NODE);
        }

        @Override
        public List<Node> findNodes(Node node) throws XPathExpressionException {
            Preconditions.checkNotNull(node);
            final NodeList list = (NodeList)this.expression.evaluate(node, XPathConstants.NODESET);
            return new AbstractList<Node>(this){

                @Override
                public int size() {
                    return list.getLength();
                }

                @Override
                public Node get(int index) {
                    return list.item(index);
                }
            };
        }

        @Override
        public Finder recompile() {
            return new Finder(this.string, this.xpath);
        }

        @Override
        public String toString() {
            return this.string;
        }

        @Override
        public int hashCode() {
            return this.string.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof XPathFinder)) {
                return false;
            }
            return this.string.equals(o.toString());
        }

        @Override
        public int compareTo(XPathFinder o) {
            return this.string.compareTo(o.toString());
        }
    }

    private static final class SynchronizedFinder
    implements XPathFinder {
        private final XPathFinder delegate;

        public SynchronizedFinder(XPathFinder delegate) {
            Preconditions.checkNotNull(delegate);
            this.delegate = delegate;
        }

        @Override
        public synchronized boolean find(Node node) throws XPathExpressionException {
            return this.delegate.find(node);
        }

        @Override
        public synchronized String findString(Node node) throws XPathExpressionException {
            return this.delegate.findString(node);
        }

        @Override
        public synchronized List<String> findStrings(Node node) throws XPathExpressionException {
            return this.delegate.findStrings(node);
        }

        @Override
        public synchronized Node findNode(Node node) throws XPathExpressionException {
            return this.delegate.findNode(node);
        }

        @Override
        public synchronized List<Node> findNodes(Node node) throws XPathExpressionException {
            return this.delegate.findNodes(node);
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        @Override
        public SynchronizedFinder recompile() {
            return this;
        }

        @Override
        public int compareTo(XPathFinder o) {
            return this.delegate.compareTo(o);
        }
    }

    private static final class ThreadLocalFinder
    implements XPathFinder {
        private final ThreadLocal<XPathFinder> delegates;

        public ThreadLocalFinder(final XPathFinder delegate) {
            Preconditions.checkNotNull(delegate);
            this.delegates = new ThreadLocal<XPathFinder>(this){

                @Override
                protected synchronized XPathFinder initialValue() {
                    return delegate.recompile();
                }
            };
            this.delegates.set(delegate);
        }

        @Override
        public boolean find(Node node) throws XPathExpressionException {
            return this.delegates.get().find(node);
        }

        @Override
        public String findString(Node node) throws XPathExpressionException {
            return this.delegates.get().findString(node);
        }

        @Override
        public List<String> findStrings(Node node) throws XPathExpressionException {
            return this.delegates.get().findStrings(node);
        }

        @Override
        public Node findNode(Node node) throws XPathExpressionException {
            return this.delegates.get().findNode(node);
        }

        @Override
        public List<Node> findNodes(Node node) throws XPathExpressionException {
            return this.delegates.get().findNodes(node);
        }

        @Override
        public String toString() {
            return this.delegates.get().toString();
        }

        @Override
        public int hashCode() {
            return this.delegates.get().hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return this.delegates.get().equals(o);
        }

        @Override
        public ThreadLocalFinder recompile() {
            return this;
        }

        @Override
        public int compareTo(XPathFinder o) {
            return this.delegates.get().compareTo(o);
        }
    }
}

