/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.repackaged.com.google.common.base.CharMatcher;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.io.BaseEncoding;
import com.google.appengine.repackaged.com.google.common.io.ByteStreams;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Cursor
implements Serializable {
    static final long serialVersionUID = 3515556366838971499L;
    private transient ByteString cursorBytes;

    Cursor() {
        this.cursorBytes = ByteString.EMPTY;
    }

    Cursor(Cursor previousCursor) {
        this(previousCursor.cursorBytes);
    }

    Cursor(ByteString cursorBytes) {
        Preconditions.checkNotNull(cursorBytes);
        this.cursorBytes = cursorBytes;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.write(this.cursorBytes.toByteArray());
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.cursorBytes = ByteString.copyFrom(ByteStreams.toByteArray(in));
    }

    Cursor advance(int n, PreparedQuery query) {
        if (n == 0) {
            return this;
        }
        if (n > 0) {
            return query.asQueryResultIterator(FetchOptions.Builder.withStartCursor(this).offset(n).limit(0)).getCursor();
        }
        throw new IllegalArgumentException("Unable to offset cursor by " + n + " results.");
    }

    @Deprecated
    public Cursor reverse() {
        return this;
    }

    public String toWebSafeString() {
        return BaseEncoding.base64Url().omitPadding().encode(this.cursorBytes.toByteArray());
    }

    public static Cursor fromWebSafeString(String encodedCursor) {
        Preconditions.checkNotNull(encodedCursor, "encodedCursor must not be null");
        try {
            return new Cursor(ByteString.copyFrom(BaseEncoding.base64Url().decode(CharMatcher.whitespace().removeFrom(encodedCursor))));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unable to decode provided cursor.", e);
        }
    }

    ByteString toByteString() {
        return ByteString.copyFrom(this.cursorBytes.toByteArray());
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        return this.cursorBytes.equals(((Cursor)obj).cursorBytes);
    }

    public int hashCode() {
        return this.cursorBytes.hashCode();
    }

    public String toString() {
        return this.cursorBytes.toString();
    }
}

