/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionStack;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Future;

class TransactionStackImpl
implements TransactionStack {
    private final ThreadLocalTransactionStack stack;

    public TransactionStackImpl() {
        this(new ThreadLocalTransactionStack.StaticMember());
    }

    TransactionStackImpl(ThreadLocalTransactionStack stack) {
        this.stack = stack;
    }

    @Override
    public void push(Transaction txn) {
        if (txn == null) {
            throw new NullPointerException("txn cannot be null");
        }
        this.getStack().txns.addFirst(txn);
    }

    Transaction pop() {
        try {
            Transaction txn = this.getStack().txns.removeFirst();
            this.getStack().txnIdToTransactionData.remove(txn.getId());
            return txn;
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void remove(Transaction txn) {
        if (!this.getStack().txns.remove(txn)) {
            throw new IllegalStateException("Attempted to deregister a transaction that is not currently registered.");
        }
        this.getStack().txnIdToTransactionData.remove(txn.getId());
    }

    @Override
    public Transaction peek() {
        try {
            return this.getStack().txns.getFirst();
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Transaction peek(Transaction returnedIfNoTxn) {
        LinkedList<Transaction> txns = this.getStack().txns;
        Transaction txn = txns.isEmpty() ? null : txns.peek();
        return txn == null ? returnedIfNoTxn : txn;
    }

    @Override
    public Collection<Transaction> getAll() {
        return new ArrayList<Transaction>(this.getStack().txns);
    }

    TransactionDataMap getStack() {
        return this.stack.get();
    }

    @Override
    public void clearAll() {
        this.getStack().clear();
    }

    @Override
    public void addFuture(Transaction txn, Future<?> future) {
        this.getFutures(txn).add(future);
    }

    private TransactionData getTransactionData(Transaction txn) {
        TransactionDataMap txnDataMap = this.getStack();
        TransactionData data = txnDataMap.txnIdToTransactionData.get(txn.getId());
        if (data == null) {
            data = new TransactionData();
            txnDataMap.txnIdToTransactionData.put(txn.getId(), data);
        }
        return data;
    }

    @Override
    public LinkedHashSet<Future<?>> getFutures(Transaction txn) {
        return this.getTransactionData((Transaction)txn).futures;
    }

    @Override
    public void addPutEntities(Transaction txn, List<Entity> putEntities) {
        this.getTransactionData((Transaction)txn).puts.addAll(putEntities);
    }

    @Override
    public void addDeletedKeys(Transaction txn, List<Key> deletedKeys) {
        this.getTransactionData((Transaction)txn).deletes.addAll(deletedKeys);
    }

    @Override
    public List<Entity> getPutEntities(Transaction txn) {
        return this.getTransactionData((Transaction)txn).puts;
    }

    @Override
    public List<Key> getDeletedKeys(Transaction txn) {
        return this.getTransactionData((Transaction)txn).deletes;
    }

    static interface ThreadLocalTransactionStack {
        public TransactionDataMap get();

        public static class StaticMember
        implements ThreadLocalTransactionStack {
            private static final ThreadLocal<TransactionDataMap> STACK = new ThreadLocal<TransactionDataMap>(){

                @Override
                protected TransactionDataMap initialValue() {
                    return new TransactionDataMap();
                }
            };

            @Override
            public TransactionDataMap get() {
                return STACK.get();
            }
        }
    }

    static final class TransactionDataMap {
        final LinkedList<Transaction> txns = new LinkedList();
        final Map<String, TransactionData> txnIdToTransactionData = new HashMap<String, TransactionData>();

        TransactionDataMap() {
        }

        void clear() {
            this.txns.clear();
            this.txnIdToTransactionData.clear();
        }
    }

    static final class TransactionData {
        final LinkedHashSet<Future<?>> futures = new LinkedHashSet();
        final List<Key> deletes = Lists.newArrayList();
        final List<Entity> puts = Lists.newArrayList();

        TransactionData() {
        }
    }
}

