/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.utils.ee10;

import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMultipart;

public class HttpRequestParser {
    protected static MimeMultipart parseMultipartRequest(HttpServletRequest req) throws IOException, MessagingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ServletInputStream inputStream = req.getInputStream();
        HttpRequestParser.copy((InputStream)inputStream, baos);
        if (baos.size() == 0) {
            throw new IllegalStateException("Input stream already read, or empty.");
        }
        return new MimeMultipart(new StaticDataSource(req.getContentType(), baos.toByteArray()));
    }

    protected static String getFieldName(BodyPart part) throws MessagingException {
        String[] values = part.getHeader("Content-Disposition");
        String name = null;
        if (values != null && values.length > 0) {
            name = new ContentDisposition(values[0]).getParameter("name");
        }
        return name != null ? name : "unknown";
    }

    protected static String getTextContent(BodyPart part) throws MessagingException, IOException {
        ContentType contentType = new ContentType(part.getContentType());
        String charset = contentType.getParameter("charset");
        if (charset == null) {
            charset = "ISO-8859-1";
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        HttpRequestParser.copy(part.getInputStream(), baos);
        try {
            return new String(baos.toByteArray(), charset);
        }
        catch (UnsupportedEncodingException ex) {
            return new String(baos.toByteArray());
        }
    }

    private static void copy(InputStream from, OutputStream to) throws IOException {
        int r;
        if (from == null) {
            throw new NullPointerException();
        }
        if (to == null) {
            throw new NullPointerException();
        }
        byte[] buf = new byte[8192];
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
        }
    }

    protected static class StaticDataSource
    implements DataSource {
        private final String contentType;
        private final byte[] bytes;

        public StaticDataSource(String contentType, byte[] bytes) {
            this.contentType = contentType;
            this.bytes = bytes;
        }

        public String getContentType() {
            return this.contentType;
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.bytes);
        }

        public OutputStream getOutputStream() {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            return "request";
        }
    }
}

