/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flags;

import com.google.appengine.repackaged.com.google.common.flags.FlagDescription;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.nullness.Nullable;

public final class FlagValues {
    private final Map<String, String> values;

    public FlagValues() {
        this.values = new LinkedHashMap<String, String>();
    }

    public FlagValues(FlagValues other) {
        this.values = new LinkedHashMap<String, String>(other.values);
    }

    public void addFlag(String flag, String value) {
        FlagDescription.checkNotNull(flag);
        FlagDescription.checkNotNull(value);
        this.values.put(flag, value);
    }

    public void addAll(FlagValues flagValues) {
        this.values.putAll(flagValues.values);
    }

    public @Nullable String getFlagValue(String flag) {
        FlagDescription.checkNotNull(flag);
        return this.values.get(flag);
    }

    public String[] getAllFlagsAsStringArray() {
        String[] flags = new String[this.values.size()];
        int i = 0;
        for (String flagName : this.values.keySet()) {
            String flagValue = this.values.get(flagName);
            flags[i] = "--" + flagName + ("".equals(flagValue) ? "" : "=" + flagValue);
            ++i;
        }
        return flags;
    }
}

