/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.datastore.v1.client;

import com.google.appengine.repackaged.com.google.datastore.v1.AllocateIdsRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.AllocateIdsResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.ReserveIdsRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.ReserveIdsResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.RunAggregationQueryRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.RunAggregationQueryResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.client.DatastoreException;
import com.google.appengine.repackaged.com.google.datastore.v1.client.RemoteRpc;
import com.google.appengine.repackaged.com.google.rpc.Code;
import java.io.IOException;
import java.io.InputStream;

public class Datastore {
    final RemoteRpc remoteRpc;

    Datastore(RemoteRpc remoteRpc) {
        this.remoteRpc = remoteRpc;
    }

    public void resetRpcCount() {
        this.remoteRpc.resetRpcCount();
    }

    public int getRpcCount() {
        return this.remoteRpc.getRpcCount();
    }

    private DatastoreException invalidResponseException(String method, IOException exception) {
        return RemoteRpc.makeException(this.remoteRpc.getUrl(), method, Code.UNAVAILABLE, "Invalid response", exception);
    }

    public AllocateIdsResponse allocateIds(AllocateIdsRequest request) throws DatastoreException {
        AllocateIdsResponse allocateIdsResponse;
        block8: {
            InputStream is = this.remoteRpc.call("allocateIds", request, request.getProjectId(), request.getDatabaseId());
            try {
                allocateIdsResponse = AllocateIdsResponse.parseFrom(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw this.invalidResponseException("allocateIds", exception);
                }
            }
            is.close();
        }
        return allocateIdsResponse;
    }

    public BeginTransactionResponse beginTransaction(BeginTransactionRequest request) throws DatastoreException {
        BeginTransactionResponse beginTransactionResponse;
        block8: {
            InputStream is = this.remoteRpc.call("beginTransaction", request, request.getProjectId(), request.getDatabaseId());
            try {
                beginTransactionResponse = BeginTransactionResponse.parseFrom(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw this.invalidResponseException("beginTransaction", exception);
                }
            }
            is.close();
        }
        return beginTransactionResponse;
    }

    public CommitResponse commit(CommitRequest request) throws DatastoreException {
        CommitResponse commitResponse;
        block8: {
            InputStream is = this.remoteRpc.call("commit", request, request.getProjectId(), request.getDatabaseId());
            try {
                commitResponse = CommitResponse.parseFrom(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw this.invalidResponseException("commit", exception);
                }
            }
            is.close();
        }
        return commitResponse;
    }

    public LookupResponse lookup(LookupRequest request) throws DatastoreException {
        LookupResponse lookupResponse;
        block8: {
            InputStream is = this.remoteRpc.call("lookup", request, request.getProjectId(), request.getDatabaseId());
            try {
                lookupResponse = LookupResponse.parseFrom(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw this.invalidResponseException("lookup", exception);
                }
            }
            is.close();
        }
        return lookupResponse;
    }

    public ReserveIdsResponse reserveIds(ReserveIdsRequest request) throws DatastoreException {
        ReserveIdsResponse reserveIdsResponse;
        block8: {
            InputStream is = this.remoteRpc.call("reserveIds", request, request.getProjectId(), request.getDatabaseId());
            try {
                reserveIdsResponse = ReserveIdsResponse.parseFrom(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw this.invalidResponseException("reserveIds", exception);
                }
            }
            is.close();
        }
        return reserveIdsResponse;
    }

    public RollbackResponse rollback(RollbackRequest request) throws DatastoreException {
        RollbackResponse rollbackResponse;
        block8: {
            InputStream is = this.remoteRpc.call("rollback", request, request.getProjectId(), request.getDatabaseId());
            try {
                rollbackResponse = RollbackResponse.parseFrom(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw this.invalidResponseException("rollback", exception);
                }
            }
            is.close();
        }
        return rollbackResponse;
    }

    public RunQueryResponse runQuery(RunQueryRequest request) throws DatastoreException {
        RunQueryResponse runQueryResponse;
        block8: {
            InputStream is = this.remoteRpc.call("runQuery", request, request.getProjectId(), request.getDatabaseId());
            try {
                runQueryResponse = RunQueryResponse.parseFrom(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw this.invalidResponseException("runQuery", exception);
                }
            }
            is.close();
        }
        return runQueryResponse;
    }

    public RunAggregationQueryResponse runAggregationQuery(RunAggregationQueryRequest request) throws DatastoreException {
        RunAggregationQueryResponse runAggregationQueryResponse;
        block8: {
            InputStream is = this.remoteRpc.call("runAggregationQuery", request, request.getProjectId(), request.getDatabaseId());
            try {
                runAggregationQueryResponse = RunAggregationQueryResponse.parseFrom(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw this.invalidResponseException("runAggregationQuery", exception);
                }
            }
            is.close();
        }
        return runAggregationQueryResponse;
    }
}

