/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.datastore.v1.client;

import com.google.appengine.repackaged.com.google.api.client.util.Preconditions;
import com.google.appengine.repackaged.com.google.datastore.v1.client.Datastore;
import com.google.appengine.repackaged.com.google.datastore.v1.client.DatastoreEmulatorException;
import com.google.appengine.repackaged.com.google.datastore.v1.client.DatastoreEmulatorOptions;
import com.google.appengine.repackaged.com.google.datastore.v1.client.RemoteRpc;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class DatastoreEmulator
extends Datastore {
    private static final int STARTUP_TIMEOUT_SECS = 30;
    private final String host;
    private final DatastoreEmulatorOptions options;
    private volatile State state = State.NEW;
    private File projectDirectory;

    DatastoreEmulator(RemoteRpc rpc, String localHost, DatastoreEmulatorOptions options) {
        super(rpc);
        this.host = "http://" + localHost;
        this.options = options;
    }

    public void clear() throws DatastoreEmulatorException {
        this.sendEmptyRequest("/reset", "POST");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public synchronized void start(String emulatorDir, String projectId, String ... commandLineOptions) throws DatastoreEmulatorException {
        Preconditions.checkNotNull(emulatorDir, "emulatorDir cannot be null");
        Preconditions.checkNotNull(projectId, "projectId cannot be null");
        Preconditions.checkState(this.state == State.NEW, "Cannot call start() more than once.");
        try {
            this.startEmulatorInternal(emulatorDir + "/cloud_datastore_emulator", projectId, Arrays.asList(commandLineOptions));
            this.state = State.STARTED;
        }
        finally {
            if (this.state != State.STARTED) {
                this.state = State.STOPPED;
            }
        }
    }

    public synchronized void start() throws DatastoreEmulatorException {
        Preconditions.checkState(this.state == State.NEW, "Cannot call start() more than once.");
        try {
            this.startEmulatorInternal(this.options.getCmd(), this.options.getProjectId(), this.options.getCmdLineOptions());
            this.state = State.STARTED;
        }
        finally {
            if (this.state != State.STARTED) {
                this.state = State.STOPPED;
            }
        }
    }

    void startEmulatorInternal(String emulatorCmd, String projectId, List<String> commandLineOptions) throws DatastoreEmulatorException {
        Process emulatorStartProcess;
        this.projectDirectory = this.createProjectDirectory(emulatorCmd, projectId);
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(emulatorCmd, "start", "--testing"));
        cmd.addAll(commandLineOptions);
        cmd.add(this.projectDirectory.getPath());
        try {
            emulatorStartProcess = this.newEmulatorProcess(cmd).start();
        }
        catch (IOException e) {
            throw new DatastoreEmulatorException("Could not start emulator", e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                emulatorStartProcess.destroy();
            }
        });
        StartupMonitor monitor = new StartupMonitor(emulatorStartProcess.getInputStream());
        try {
            monitor.start();
            if (!monitor.startupCompleteLatch.await(30L, TimeUnit.SECONDS)) {
                throw new DatastoreEmulatorException("Emulator did not start within 30 seconds");
            }
            if (!monitor.success) {
                throw new DatastoreEmulatorException("Emulator did not start normally");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DatastoreEmulatorException("Received an interrupt", e);
        }
    }

    private File createProjectDirectory(String emulatorCmd, String projectId) throws DatastoreEmulatorException {
        File projectDirectory;
        try {
            projectDirectory = Files.createTempDirectory("datastore-emulator", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new DatastoreEmulatorException("Could not create temporary project directory", e);
        }
        List<String> cmd = Arrays.asList(emulatorCmd, "create", "--project_id=" + projectId, projectDirectory.getPath());
        try {
            int retCode = this.newEmulatorProcess(cmd).start().waitFor();
            if (retCode != 0) {
                throw new DatastoreEmulatorException(String.format("Could not create project (retcode=%d)", retCode));
            }
        }
        catch (IOException e) {
            throw new DatastoreEmulatorException("Could not create project", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DatastoreEmulatorException("Received an interrupt", e);
        }
        return projectDirectory;
    }

    private ProcessBuilder newEmulatorProcess(List<String> cmd) {
        ProcessBuilder builder = new ProcessBuilder(cmd);
        builder.redirectErrorStream(true);
        builder.environment().putAll(this.options.getEnvVars());
        return builder;
    }

    public synchronized void stop() throws DatastoreEmulatorException {
        this.stopEmulatorInternal();
        if (this.state != State.STOPPED) {
            this.state = State.STOPPED;
            if (this.projectDirectory != null) {
                try {
                    Process process = new ProcessBuilder("rm", "-r", this.projectDirectory.getAbsolutePath()).start();
                    if (process.waitFor() != 0) {
                        throw new IOException("Temporary project directory deletion exited with " + process.exitValue());
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not delete temporary project directory", e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException("Could not delete temporary project directory", e);
                }
            }
        }
    }

    protected void stopEmulatorInternal() throws DatastoreEmulatorException {
        this.sendEmptyRequest("/shutdown", "POST");
    }

    public synchronized File getProjectDirectory() {
        Preconditions.checkState(this.state == State.STARTED);
        return this.projectDirectory;
    }

    private void sendEmptyRequest(String path, String method) throws DatastoreEmulatorException {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(this.host + path);
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod(method);
            connection.getOutputStream().close();
            if (connection.getResponseCode() != 200) {
                throw new DatastoreEmulatorException(String.format("%s request to %s returned HTTP status %s", method, path, connection.getResponseCode()));
            }
        }
        catch (IOException e) {
            throw new DatastoreEmulatorException(String.format("Exception connecting to emulator on %s request to %s", method, path), e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    static enum State {
        NEW,
        STARTED,
        STOPPED;

    }

    static class StartupMonitor
    extends Thread {
        private final InputStream inputStream;
        private volatile boolean success = false;
        private final CountDownLatch startupCompleteLatch = new CountDownLatch(1);

        StartupMonitor(InputStream inputStream) {
            this.inputStream = inputStream;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(this.inputStream));
                while ((line = br.readLine()) != null) {
                    System.out.println(line);
                    if (this.success || !line.contains("Dev App Server is now running")) continue;
                    this.success = true;
                    this.startupCompleteLatch.countDown();
                }
            }
            catch (IOException ioe) {
                if (!this.success) {
                    System.err.println("Received an IOException before emulator startup completed. Emulator is in an unknown state.");
                } else {
                    System.err.println("Received an exception handling output from the emulator. Logging will stop but the emulator is probably ok.");
                }
                ioe.printStackTrace();
            }
            finally {
                if (!this.success) {
                    this.startupCompleteLatch.countDown();
                }
            }
        }
    }
}

