/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.setup;

import com.google.appengine.setup.ApiProxyDelegate;
import com.google.appengine.setup.ApiProxyEnvironment;
import com.google.appengine.setup.LazyApiProxyEnvironment;
import com.google.appengine.setup.TimerImpl;
import com.google.appengine.setup.utils.http.HttpRequest;
import com.google.apphosting.api.ApiProxy;
import java.util.HashMap;

public class ApiProxySetupUtil {
    public static void registerAPIProxy(HttpRequest request) {
        ApiProxy.setDelegate(new ApiProxyDelegate());
        boolean isProduction = System.getenv().containsKey("GAE_DEPLOYMENT_ID");
        ApiProxy.setEnvironmentForCurrentThread(isProduction ? ApiProxySetupUtil.getProdEnvironment(request) : ApiProxySetupUtil.getLocalEnvironment());
    }

    private static ApiProxy.Environment getLocalEnvironment() {
        return new LazyApiProxyEnvironment(() -> new ApiProxyEnvironment("localhost:8089", null, "dummy-appId", "dummy-module", "dummy-majorVersion", "dummy-instance", "dummy-email", true, "dummy-authDomain", new TimerImpl(), 1000L, new HashMap<String, Object>()));
    }

    private static ApiProxy.Environment getProdEnvironment(HttpRequest request) {
        return new LazyApiProxyEnvironment(() -> ApiProxyEnvironment.createFromHeaders(System.getenv(), request, "169.254.169.253:10001", new TimerImpl(), 1000L));
    }
}

