/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.servlet;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Transaction;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class TransactionCleanupFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(TransactionCleanupFilter.class.getName());
    private DatastoreService datastoreService;

    public void init(FilterConfig filterConfig) {
        this.datastoreService = this.getDatastoreService();
    }

    public void destroy() {
        this.datastoreService = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
        }
        finally {
            this.handleAbandonedTxns(this.datastoreService.getActiveTransactions());
        }
    }

    private void handleAbandonedTxns(Collection<Transaction> txns) {
        for (Transaction txn : txns) {
            String txnId;
            try {
                txnId = txn.getId();
            }
            catch (Exception e) {
                txnId = "[unknown]";
            }
            logger.warning("Request completed without committing or rolling back transaction with id " + txnId + ".  Transaction will be rolled back.");
            try {
                txn.rollback();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Swallowing an exception we received while trying to rollback abandoned transaction.", e);
            }
        }
    }

    DatastoreService getDatastoreService() {
        return DatastoreServiceFactory.getDatastoreService();
    }
}

