/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.users.dev;

import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.apphosting.api.UserServicePb;
import com.google.auto.service.AutoService;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

@AutoService(value={LocalRpcService.class})
public final class LocalUserService
extends AbstractLocalRpcService {
    private static final String LOGIN_URL = "/_ah/login";
    private static final String LOGOUT_URL = "/_ah/logout";
    public static final String OAUTH_CONSUMER_KEY_PROPERTY = "oauth.consumer_key";
    public static final String OAUTH_EMAIL_PROPERTY = "oauth.email";
    public static final String OAUTH_USER_ID_PROPERTY = "oauth.user_id";
    public static final String OAUTH_AUTH_DOMAIN_PROPERTY = "oauth.auth_domain";
    public static final String OAUTH_IS_ADMIN_PROPERTY = "oauth.is_admin";
    private String oauthEmail = "example@example.com";
    private String oauthUserId = "0";
    private String oauthAuthDomain = "gmail.com";
    private boolean oauthIsAdmin = false;
    public static final String PACKAGE = "user";

    public UserServicePb.CreateLoginURLResponse createLoginURL(LocalRpcService.Status status, UserServicePb.CreateLoginURLRequest request) {
        return UserServicePb.CreateLoginURLResponse.newBuilder().setLoginUrl("/_ah/login?continue=" + LocalUserService.encode(request.getDestinationUrl())).build();
    }

    public UserServicePb.CreateLogoutURLResponse createLogoutURL(LocalRpcService.Status status, UserServicePb.CreateLogoutURLRequest request) {
        return UserServicePb.CreateLogoutURLResponse.newBuilder().setLogoutUrl("/_ah/logout?continue=" + LocalUserService.encode(request.getDestinationUrl())).build();
    }

    public UserServicePb.GetOAuthUserResponse getOAuthUser(LocalRpcService.Status status, UserServicePb.GetOAuthUserRequest request) {
        return UserServicePb.GetOAuthUserResponse.newBuilder().setEmail(this.oauthEmail).setUserId(this.oauthUserId).setAuthDomain(this.oauthAuthDomain).setIsAdmin(this.oauthIsAdmin).build();
    }

    @Override
    public String getPackage() {
        return PACKAGE;
    }

    @Override
    public void init(LocalServiceContext context, Map<String, String> properties) {
        String oauthIsAdminProp;
        String oauthAuthDomainProp;
        String oauthUserIdProp;
        String oauthEmailProp = properties.get(OAUTH_EMAIL_PROPERTY);
        if (oauthEmailProp != null) {
            this.oauthEmail = oauthEmailProp;
        }
        if ((oauthUserIdProp = properties.get(OAUTH_USER_ID_PROPERTY)) != null) {
            this.oauthUserId = oauthUserIdProp;
        }
        if ((oauthAuthDomainProp = properties.get(OAUTH_AUTH_DOMAIN_PROPERTY)) != null) {
            this.oauthAuthDomain = oauthAuthDomainProp;
        }
        if ((oauthIsAdminProp = properties.get(OAUTH_IS_ADMIN_PROPERTY)) != null) {
            this.oauthIsAdmin = Boolean.parseBoolean(oauthIsAdminProp);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    private static String encode(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Could not find UTF-8 encoding", ex);
        }
    }
}

