/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.index;

import com.google.appengine.repackaged.org.apache.lucene.index.IndexCommit;
import com.google.appengine.repackaged.org.apache.lucene.index.IndexCommitPoint;
import com.google.appengine.repackaged.org.apache.lucene.index.IndexDeletionPolicy;
import com.google.appengine.repackaged.org.apache.lucene.store.Directory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SnapshotDeletionPolicy
implements IndexDeletionPolicy {
    private IndexCommit lastCommit;
    private IndexDeletionPolicy primary;
    private String snapshot;

    public SnapshotDeletionPolicy(IndexDeletionPolicy primary) {
        this.primary = primary;
    }

    public synchronized void onInit(List commits) throws IOException {
        this.primary.onInit(this.wrapCommits(commits));
        this.lastCommit = (IndexCommit)commits.get(commits.size() - 1);
    }

    public synchronized void onCommit(List commits) throws IOException {
        this.primary.onCommit(this.wrapCommits(commits));
        this.lastCommit = (IndexCommit)commits.get(commits.size() - 1);
    }

    public synchronized IndexCommitPoint snapshot() {
        if (this.lastCommit == null) {
            throw new IllegalStateException("no index commits to snapshot !");
        }
        if (this.snapshot != null) {
            throw new IllegalStateException("snapshot is already set; please call release() first");
        }
        this.snapshot = this.lastCommit.getSegmentsFileName();
        return this.lastCommit;
    }

    public synchronized void release() {
        if (this.snapshot == null) {
            throw new IllegalStateException("snapshot was not set; please call snapshot() first");
        }
        this.snapshot = null;
    }

    private List wrapCommits(List commits) {
        int count = commits.size();
        ArrayList<MyCommitPoint> myCommits = new ArrayList<MyCommitPoint>(count);
        for (int i = 0; i < count; ++i) {
            myCommits.add(new MyCommitPoint((IndexCommit)commits.get(i)));
        }
        return myCommits;
    }

    private class MyCommitPoint
    extends IndexCommit {
        IndexCommit cp;

        MyCommitPoint(IndexCommit cp) {
            this.cp = cp;
        }

        public String toString() {
            return "SnapshotDeletionPolicy.SnapshotCommitPoint(" + this.cp + ")";
        }

        public String getSegmentsFileName() {
            return this.cp.getSegmentsFileName();
        }

        public Collection getFileNames() throws IOException {
            return this.cp.getFileNames();
        }

        public Directory getDirectory() {
            return this.cp.getDirectory();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete() {
            SnapshotDeletionPolicy snapshotDeletionPolicy = SnapshotDeletionPolicy.this;
            synchronized (snapshotDeletionPolicy) {
                if (SnapshotDeletionPolicy.this.snapshot == null || !SnapshotDeletionPolicy.this.snapshot.equals(this.getSegmentsFileName())) {
                    this.cp.delete();
                }
            }
        }

        public boolean isDeleted() {
            return this.cp.isDeleted();
        }

        public long getVersion() {
            return this.cp.getVersion();
        }

        public long getGeneration() {
            return this.cp.getGeneration();
        }

        public Map getUserData() throws IOException {
            return this.cp.getUserData();
        }

        public boolean isOptimized() {
            return this.cp.isOptimized();
        }
    }
}

