/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.appengv3;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.storage.onestore.v3.OnestoreEntity;

public class ReferenceValues {
    private ReferenceValues() {
    }

    public static OnestoreEntity.Reference toReference(OnestoreEntity.PropertyValue.ReferenceValue ref) {
        OnestoreEntity.Reference key = new OnestoreEntity.Reference();
        if (ref.hasApp()) {
            key.setAppAsBytes(ref.getAppAsBytes());
        }
        if (ref.hasDatabaseId()) {
            key.setDatabaseIdAsBytes(ref.getDatabaseIdAsBytes());
        }
        if (ref.hasNameSpace()) {
            key.setNameSpaceAsBytes(ref.getNameSpaceAsBytes());
        }
        for (OnestoreEntity.PropertyValue.ReferenceValuePathElement refElem : ref.pathElements()) {
            OnestoreEntity.Path.Element keyElem = key.getMutablePath().addElement();
            if (refElem.hasType()) {
                keyElem.setTypeAsBytes(refElem.getTypeAsBytes());
            }
            if (refElem.hasId()) {
                keyElem.setId(refElem.getId());
            }
            if (!refElem.hasName()) continue;
            keyElem.setNameAsBytes(refElem.getNameAsBytes());
        }
        return key;
    }

    public static OnestoreEntity.Reference toReference(OnestoreEntity.PropertyValue value) {
        Preconditions.checkArgument((boolean)value.hasReferenceValue());
        return ReferenceValues.toReference(value.getReferenceValue());
    }

    public static OnestoreEntity.PropertyValue toReferenceProperty(OnestoreEntity.Reference key) {
        OnestoreEntity.PropertyValue prop = new OnestoreEntity.PropertyValue();
        OnestoreEntity.PropertyValue.ReferenceValue ref = prop.getMutableReferenceValue();
        if (key.hasApp()) {
            ref.setAppAsBytes(key.getAppAsBytes());
        }
        if (key.hasDatabaseId()) {
            ref.setDatabaseIdAsBytes(key.getDatabaseIdAsBytes());
        }
        if (key.hasNameSpace()) {
            ref.setNameSpaceAsBytes(key.getNameSpaceAsBytes());
        }
        for (OnestoreEntity.Path.Element keyElem : key.getPath().elements()) {
            OnestoreEntity.PropertyValue.ReferenceValuePathElement refElem = ref.addPathElement();
            if (keyElem.hasType()) {
                refElem.setTypeAsBytes(keyElem.getTypeAsBytes());
            }
            if (keyElem.hasId()) {
                refElem.setId(keyElem.getId());
            }
            if (!keyElem.hasName()) continue;
            refElem.setNameAsBytes(keyElem.getNameAsBytes());
        }
        return prop;
    }
}

