/*
 * Decompiled with CFR 0.152.
 */
package mediautil.test;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Random;
import mediautil.gen.directio.InStreamFromIterativeWriter;
import mediautil.test.TestWriterCode;

public class InStreamFromIterativeWriterTester
extends InStreamFromIterativeWriter {
    public static void main(String[] args) throws Exception {
        int actualRead;
        File finfo = new File(args[0]);
        int size = (int)finfo.length();
        FileInputStream fip = new FileInputStream(finfo);
        TestWriterCode.fileArr = new byte[size];
        int readLen = fip.read(TestWriterCode.fileArr);
        fip.close();
        int skipProb = 5;
        int maxBuf = 200;
        InStreamFromIterativeWriter sip = new InStreamFromIterativeWriter(32, 7, 8, 8);
        TestWriterCode.r = new Random(555L);
        TestWriterCode tc = new TestWriterCode(sip.getWriterOutputStream(), maxBuf, 3);
        sip.setIterativeWriter(tc);
        PrintStream refOp = new PrintStream(new BufferedOutputStream(new FileOutputStream("D:/work/deldir/main_ref.txt"), 100000));
        PrintStream sipOp = new PrintStream(new BufferedOutputStream(new FileOutputStream("D:/work/deldir/main_sip.txt"), 100000));
        boolean prevShort = false;
        byte[] readBuf = new byte[maxBuf];
        int pos = 0;
        int i = 0;
        do {
            int len = TestWriterCode.r.nextInt(maxBuf) + 1;
            boolean isSkip = TestWriterCode.r.nextInt(16) < skipProb;
            String opMsg = isSkip ? "Skipped " : "Read ";
            TestWriterCode.id = i;
            refOp.println("Trying Id: " + i + ' ' + opMsg + pos + " - " + (pos + len));
            sipOp.println("Trying Id: " + i + ' ' + opMsg + pos + " - " + (pos + len));
            if (TestWriterCode.flush) {
                refOp.flush();
                sipOp.flush();
            }
            if (isSkip) {
                actualRead = (int)sip.skip(len);
            } else {
                int ofs = TestWriterCode.r.nextInt(maxBuf - len + 1);
                actualRead = sip.read(readBuf, ofs, len);
                TestWriterCode.printBytes(refOp, TestWriterCode.fileArr, pos, actualRead);
                TestWriterCode.printBytes(sipOp, readBuf, ofs, actualRead);
            }
            if (actualRead > 0) {
                if (actualRead < len) {
                    prevShort = true;
                }
                refOp.println("Id: " + i + ' ' + opMsg + pos + " - " + (pos + actualRead));
                sipOp.println("Id: " + i + ' ' + opMsg + pos + " - " + (pos + actualRead));
            } else {
                refOp.println("Id: " + i + " End Of Stream actualRead = " + actualRead);
                sipOp.println("Id: " + i + " End Of Stream actualRead = " + actualRead);
            }
            if (TestWriterCode.flush) {
                refOp.flush();
                sipOp.flush();
            }
            if (actualRead > 0) {
                pos += actualRead;
            }
            ++i;
        } while (actualRead >= 0);
        refOp.close();
        sipOp.close();
        System.out.println("Max Buf Size = " + sip.getMaxBufSize());
        tc.closeFiles();
        tc = null;
        TestWriterCode.fileArr = null;
    }
}

