// Copyright 2011 Google Inc. All Rights Reserved.

package com.google.appengine.tools.pipeline;

/**
 * An Exception that indicates that the object with the specified key has been
 * orphaned. Orphaned objects may be generated by the Pipeline framework if an
 * error occurs during the running of a job. The orphaned objects will be safely
 * cleaned up when the Pipeline is deleted, but they will not take part in
 * any Pipeline processing and should not be used.
 *
 * @author rudominer@google.com (Mitch Rudominer)
 */
public class OrphanedObjectException extends Exception {
  private static final long serialVersionUID = 149320669328554627L;

  public OrphanedObjectException(String key) {
    super(key);
  }

  public OrphanedObjectException(String key, Throwable cause) {
    super(key, cause);
  }
}
