/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.factory.processor;

import com.google.auto.common.MoreTypes;
import com.google.auto.factory.AutoFactory;
import com.google.auto.factory.Provided;
import com.google.auto.factory.processor.AutoFactoryDeclaration;
import com.google.auto.factory.processor.Elements2;
import com.google.auto.factory.processor.FactoryDescriptor;
import com.google.auto.factory.processor.FactoryDescriptorGenerator;
import com.google.auto.factory.processor.FactoryMethodDescriptor;
import com.google.auto.factory.processor.FactoryWriter;
import com.google.auto.factory.processor.ImplementationMethodDescriptor;
import com.google.auto.factory.processor.InjectApi;
import com.google.auto.factory.processor.PackageAndClass;
import com.google.auto.factory.processor.Parameter;
import com.google.auto.factory.processor.ProvidedChecker;
import com.google.auto.service.AutoService;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import net.ltgt.gradle.incap.IncrementalAnnotationProcessor;
import net.ltgt.gradle.incap.IncrementalAnnotationProcessorType;
import org.checkerframework.checker.nullness.qual.Nullable;

@SupportedOptions(value={"com.google.auto.factory.InjectApi"})
@IncrementalAnnotationProcessor(value=IncrementalAnnotationProcessorType.ISOLATING)
@AutoService(value={Processor.class})
public final class AutoFactoryProcessor
extends AbstractProcessor {
    static final String INJECT_API_OPTION = "com.google.auto.factory.InjectApi";
    private static final ImmutableSet<String> INJECT_APIS = ImmutableSet.of((Object)"jakarta", (Object)"javax");
    private FactoryDescriptorGenerator factoryDescriptorGenerator;
    private AutoFactoryDeclaration.Factory declarationFactory;
    private ProvidedChecker providedChecker;
    private Messager messager;
    private Elements elements;
    private Types types;
    private InjectApi injectApi;
    private @Nullable Consumer<@Nullable Element> errorFunction;
    private static final Comparator<AnnotationMirror> ANNOTATION_COMPARATOR = Comparator.comparing(mirror -> mirror.getAnnotationType().toString());

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.elements = processingEnv.getElementUtils();
        this.types = processingEnv.getTypeUtils();
        this.messager = processingEnv.getMessager();
        String api = processingEnv.getOptions().get(INJECT_API_OPTION);
        if (api != null && !INJECT_APIS.contains((Object)api)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Usage: -Acom.google.auto.factory.InjectApi=<api>, where <api> is " + String.join((CharSequence)" or ", INJECT_APIS));
            this.errorFunction = unused -> {};
            return;
        }
        try {
            this.injectApi = InjectApi.from(this.elements, api);
        }
        catch (IllegalStateException e) {
            this.errorFunction = element -> {
                this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage(), (Element)element);
                this.errorFunction = unused -> {};
            };
            return;
        }
        this.providedChecker = new ProvidedChecker(this.messager);
        this.declarationFactory = new AutoFactoryDeclaration.Factory(this.elements, this.messager);
        this.factoryDescriptorGenerator = new FactoryDescriptorGenerator(this.messager, this.types, this.declarationFactory, this.injectApi);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.errorFunction != null) {
            Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(AutoFactory.class);
            Element anElement = elements.isEmpty() ? null : elements.iterator().next();
            this.errorFunction.accept(anElement);
            return false;
        }
        try {
            this.doProcess(roundEnv);
        }
        catch (Throwable e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Failed to process @AutoFactory annotations:\n" + Throwables.getStackTraceAsString((Throwable)e));
        }
        return false;
    }

    private void doProcess(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Provided.class)) {
            this.providedChecker.checkProvidedParameter(element);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(AutoFactory.AnnotationsToApply.class)) {
            this.checkAnnotationsToApply(element);
        }
        ImmutableListMultimap.Builder indexedMethodsBuilder = ImmutableListMultimap.builder();
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (Element element : roundEnv.getElementsAnnotatedWith(AutoFactory.class)) {
            Optional<AutoFactoryDeclaration> declaration = this.declarationFactory.createIfValid(element);
            if (declaration.isPresent()) {
                PackageAndClass factoryName2 = declaration.get().getFactoryName();
                TypeElement extendingType = declaration.get().extendingType();
                builder.putAll((Object)factoryName2, this.implementationMethods(extendingType, element));
                for (TypeElement implementingType : declaration.get().implementingTypes()) {
                    builder.putAll((Object)factoryName2, this.implementationMethods(implementingType, element));
                }
            }
            ImmutableSet<FactoryMethodDescriptor> descriptors = this.factoryDescriptorGenerator.generateDescriptor(element);
            for (FactoryMethodDescriptor descriptor : descriptors) {
                indexedMethodsBuilder.put((Object)descriptor.factoryName(), (Object)descriptor);
            }
        }
        ImmutableSetMultimap implementationMethodDescriptors = builder.build();
        ImmutableListMultimap immutableListMultimap = indexedMethodsBuilder.build();
        ImmutableSetMultimap<String, PackageAndClass> factoriesBeingCreated = AutoFactoryProcessor.simpleNamesToNames((ImmutableSet<PackageAndClass>)immutableListMultimap.keySet());
        FactoryWriter factoryWriter = new FactoryWriter(this.processingEnv, this.injectApi, factoriesBeingCreated);
        immutableListMultimap.asMap().forEach((factoryName, methodDescriptors) -> {
            if (methodDescriptors.isEmpty()) {
                return;
            }
            ImmutableSortedSet.Builder annotationsBuilder = ImmutableSortedSet.orderedBy(ANNOTATION_COMPARATOR);
            ImmutableSortedSet.Builder<TypeMirror> extending = AutoFactoryProcessor.newTypeSetBuilder();
            ImmutableSortedSet.Builder<TypeMirror> implementing = AutoFactoryProcessor.newTypeSetBuilder();
            boolean publicType = false;
            HashSet<Boolean> allowSubclassesSet = new HashSet<Boolean>();
            boolean skipCreation = false;
            for (FactoryMethodDescriptor methodDescriptor : methodDescriptors) {
                annotationsBuilder.addAll(methodDescriptor.declaration().annotations());
                extending.add((Object)methodDescriptor.declaration().extendingType().asType());
                for (TypeElement implementingType : methodDescriptor.declaration().implementingTypes()) {
                    implementing.add((Object)implementingType.asType());
                }
                publicType |= methodDescriptor.publicMethod();
                allowSubclassesSet.add(methodDescriptor.declaration().allowSubclasses());
                if (allowSubclassesSet.size() <= 1) continue;
                skipCreation = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Cannot mix allowSubclasses=true and allowSubclasses=false in one factory.", methodDescriptor.declaration().target(), methodDescriptor.declaration().mirror(), (AnnotationValue)methodDescriptor.declaration().valuesMap().get((Object)"allowSubclasses"));
            }
            boolean allowSubclasses = (Boolean)allowSubclassesSet.iterator().next();
            if (!skipCreation) {
                try {
                    factoryWriter.writeFactory(FactoryDescriptor.create(factoryName, (ImmutableSet<AnnotationMirror>)annotationsBuilder.build(), (TypeMirror)Iterables.getOnlyElement((Iterable)extending.build()), (ImmutableSet<TypeMirror>)implementing.build(), publicType, (ImmutableSet<FactoryMethodDescriptor>)ImmutableSet.copyOf((Collection)methodDescriptors), (ImmutableSet<ImplementationMethodDescriptor>)implementationMethodDescriptors.get(factoryName), allowSubclasses));
                }
                catch (IOException e) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "failed: " + e);
                }
            }
        });
    }

    private ImmutableSet<ImplementationMethodDescriptor> implementationMethods(TypeElement supertype, Element autoFactoryElement) {
        ImmutableSet.Builder implementationMethodsBuilder = ImmutableSet.builder();
        for (ExecutableElement implementationMethod : ElementFilter.methodsIn(this.elements.getAllMembers(supertype))) {
            if (!implementationMethod.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            ExecutableType methodType = Elements2.getExecutableElementAsMemberOf(this.types, implementationMethod, supertype);
            ImmutableSet<Parameter> passedParameters = Parameter.forParameterList(implementationMethod.getParameters(), methodType.getParameterTypes(), this.types, this.injectApi);
            implementationMethodsBuilder.add((Object)ImplementationMethodDescriptor.builder().name(implementationMethod.getSimpleName().toString()).returnType(this.getAnnotatedType(autoFactoryElement)).publicMethod().passedParameters((Iterable<Parameter>)passedParameters).isVarArgs(implementationMethod.isVarArgs()).exceptions(implementationMethod.getThrownTypes()).build());
        }
        return implementationMethodsBuilder.build();
    }

    private TypeMirror getAnnotatedType(Element element) {
        Object types = ImmutableList.of();
        while (types.isEmpty()) {
            types = ElementFilter.typesIn(Arrays.asList(element));
            element = element.getEnclosingElement();
        }
        return ((TypeElement)Iterables.getOnlyElement((Iterable)types)).asType();
    }

    private static ImmutableSetMultimap<String, PackageAndClass> simpleNamesToNames(ImmutableSet<PackageAndClass> names) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (PackageAndClass name : names) {
            builder.put((Object)name.className(), (Object)name);
        }
        return builder.build();
    }

    private static ImmutableSortedSet.Builder<TypeMirror> newTypeSetBuilder() {
        return ImmutableSortedSet.orderedBy(Comparator.comparing(t -> MoreTypes.asTypeElement((TypeMirror)t).getQualifiedName().toString()));
    }

    private void checkAnnotationsToApply(Element annotation) {
        if (!annotation.getKind().equals((Object)ElementKind.ANNOTATION_TYPE)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "@" + AutoFactory.AnnotationsToApply.class.getSimpleName() + " must be applied to an annotation type declaration.", annotation);
        }
        HashSet<TypeElement> seenAnnotations = new HashSet<TypeElement>();
        for (ExecutableElement annotationMember : ElementFilter.methodsIn(annotation.getEnclosedElements())) {
            boolean isAnnotation;
            TypeMirror memberType = annotationMember.getReturnType();
            boolean bl = isAnnotation = memberType.getKind().equals((Object)TypeKind.DECLARED) && MoreTypes.asElement((TypeMirror)memberType).getKind().equals((Object)ElementKind.ANNOTATION_TYPE);
            if (!isAnnotation && !memberType.getKind().equals((Object)TypeKind.ERROR)) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Members of an @" + AutoFactory.AnnotationsToApply.class.getSimpleName() + " annotation must themselves be annotations; " + annotationMember.getSimpleName() + " has type " + memberType, annotationMember);
                continue;
            }
            TypeElement annotationElement = MoreTypes.asTypeElement((TypeMirror)memberType);
            if (seenAnnotations.add(annotationElement)) continue;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "More than one @" + annotationElement + " in " + annotation, annotation);
        }
    }

    public ImmutableSet<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)AutoFactory.class.getCanonicalName(), (Object)Provided.class.getCanonicalName(), (Object)AutoFactory.AnnotationsToApply.class.getCanonicalName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

