/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.factory.processor;

import com.google.auto.common.AnnotationMirrors;
import com.google.auto.common.MoreElements;
import com.google.auto.common.MoreStreams;
import com.google.auto.common.MoreTypes;
import com.google.auto.factory.processor.AutoValue_Parameter;
import com.google.auto.factory.processor.InjectApi;
import com.google.auto.factory.processor.Key;
import com.google.auto.factory.processor.Mirrors;
import com.google.auto.value.AutoValue;
import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

@AutoValue
abstract class Parameter {
    Parameter() {
    }

    abstract Equivalence.Wrapper<TypeMirror> type();

    boolean isPrimitive() {
        return ((TypeMirror)this.type().get()).getKind().isPrimitive();
    }

    abstract String name();

    abstract Key key();

    abstract ImmutableList<Equivalence.Wrapper<AnnotationMirror>> annotationWrappers();

    ImmutableList<AnnotationMirror> annotations() {
        return (ImmutableList)this.annotationWrappers().stream().map(Equivalence.Wrapper::get).collect(MoreStreams.toImmutableList());
    }

    abstract Optional<Equivalence.Wrapper<AnnotationMirror>> nullableWrapper();

    Optional<AnnotationMirror> nullable() {
        return Mirrors.unwrapOptionalEquivalence(this.nullableWrapper());
    }

    private static Parameter forVariableElement(VariableElement variable, TypeMirror type, Types types, InjectApi injectApi) {
        ImmutableList allAnnotations = (ImmutableList)Stream.of(variable.getAnnotationMirrors(), type.getAnnotationMirrors()).flatMap(Collection::stream).collect(MoreStreams.toImmutableList());
        Optional<AnnotationMirror> nullable = allAnnotations.stream().filter(Parameter::isNullable).findFirst();
        Key key = Key.create(type, (Collection<AnnotationMirror>)allAnnotations, types, injectApi);
        ImmutableSet typeAnnotationWrappers = (ImmutableSet)type.getAnnotationMirrors().stream().map(arg_0 -> ((Equivalence)AnnotationMirrors.equivalence()).wrap(arg_0)).collect(MoreStreams.toImmutableSet());
        ImmutableList parameterAnnotationWrappers = (ImmutableList)variable.getAnnotationMirrors().stream().map(arg_0 -> ((Equivalence)AnnotationMirrors.equivalence()).wrap(arg_0)).filter(annotation -> !typeAnnotationWrappers.contains(annotation)).collect(MoreStreams.toImmutableList());
        return new AutoValue_Parameter((Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)type), variable.getSimpleName().toString(), key, (ImmutableList<Equivalence.Wrapper<AnnotationMirror>>)parameterAnnotationWrappers, Mirrors.wrapOptionalInEquivalence(AnnotationMirrors.equivalence(), nullable));
    }

    private static boolean isNullable(AnnotationMirror annotation) {
        TypeElement annotationType = MoreElements.asType((Element)annotation.getAnnotationType().asElement());
        return annotationType.getSimpleName().contentEquals("Nullable") || annotationType.getQualifiedName().toString().startsWith("org.checkerframework.checker.nullness.compatqual.Nullable");
    }

    static ImmutableSet<Parameter> forParameterList(List<? extends VariableElement> variables, List<? extends TypeMirror> variableTypes, Types types, InjectApi injectApi) {
        Preconditions.checkArgument((variables.size() == variableTypes.size() ? 1 : 0) != 0);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        HashSet names = Sets.newHashSetWithExpectedSize((int)variables.size());
        for (int i = 0; i < variables.size(); ++i) {
            Parameter parameter = Parameter.forVariableElement(variables.get(i), variableTypes.get(i), types, injectApi);
            Preconditions.checkArgument((boolean)names.add(parameter.name()), (String)"Duplicate parameter name: %s", (Object)parameter.name());
            builder.add((Object)parameter);
        }
        ImmutableSet parameters = builder.build();
        Preconditions.checkArgument((variables.size() == parameters.size() ? 1 : 0) != 0);
        return parameters;
    }

    static ImmutableSet<Parameter> forParameterList(List<? extends VariableElement> variables, Types types, InjectApi injectApi) {
        ArrayList variableTypes = Lists.newArrayListWithExpectedSize((int)variables.size());
        for (VariableElement variableElement : variables) {
            variableTypes.add(variableElement.asType());
        }
        return Parameter.forParameterList(variables, variableTypes, types, injectApi);
    }
}

