package com.google.cloud.hadoop.fs.gcs;

import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_VectoredReadOptions extends VectoredReadOptions {

  private final int minSeekVectoredReadSize;

  private final int mergeRangeMaxSize;

  private final int readThreads;

  private AutoValue_VectoredReadOptions(
      int minSeekVectoredReadSize,
      int mergeRangeMaxSize,
      int readThreads) {
    this.minSeekVectoredReadSize = minSeekVectoredReadSize;
    this.mergeRangeMaxSize = mergeRangeMaxSize;
    this.readThreads = readThreads;
  }

  @Override
  public int getMinSeekVectoredReadSize() {
    return minSeekVectoredReadSize;
  }

  @Override
  public int getMergeRangeMaxSize() {
    return mergeRangeMaxSize;
  }

  @Override
  public int getReadThreads() {
    return readThreads;
  }

  @Override
  public String toString() {
    return "VectoredReadOptions{"
        + "minSeekVectoredReadSize=" + minSeekVectoredReadSize + ", "
        + "mergeRangeMaxSize=" + mergeRangeMaxSize + ", "
        + "readThreads=" + readThreads
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof VectoredReadOptions) {
      VectoredReadOptions that = (VectoredReadOptions) o;
      return this.minSeekVectoredReadSize == that.getMinSeekVectoredReadSize()
          && this.mergeRangeMaxSize == that.getMergeRangeMaxSize()
          && this.readThreads == that.getReadThreads();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= minSeekVectoredReadSize;
    h$ *= 1000003;
    h$ ^= mergeRangeMaxSize;
    h$ *= 1000003;
    h$ ^= readThreads;
    return h$;
  }

  @Override
  public VectoredReadOptions.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends VectoredReadOptions.Builder {
    private int minSeekVectoredReadSize;
    private int mergeRangeMaxSize;
    private int readThreads;
    private byte set$0;
    Builder() {
    }
    private Builder(VectoredReadOptions source) {
      this.minSeekVectoredReadSize = source.getMinSeekVectoredReadSize();
      this.mergeRangeMaxSize = source.getMergeRangeMaxSize();
      this.readThreads = source.getReadThreads();
      set$0 = (byte) 7;
    }
    @Override
    public VectoredReadOptions.Builder setMinSeekVectoredReadSize(int minSeekVectoredReadSize) {
      this.minSeekVectoredReadSize = minSeekVectoredReadSize;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public VectoredReadOptions.Builder setMergeRangeMaxSize(int mergeRangeMaxSize) {
      this.mergeRangeMaxSize = mergeRangeMaxSize;
      set$0 |= (byte) 2;
      return this;
    }
    @Override
    public VectoredReadOptions.Builder setReadThreads(int readThreads) {
      this.readThreads = readThreads;
      set$0 |= (byte) 4;
      return this;
    }
    @Override
    public VectoredReadOptions build() {
      if (set$0 != 7) {
        StringBuilder missing = new StringBuilder();
        if ((set$0 & 1) == 0) {
          missing.append(" minSeekVectoredReadSize");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" mergeRangeMaxSize");
        }
        if ((set$0 & 4) == 0) {
          missing.append(" readThreads");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_VectoredReadOptions(
          this.minSeekVectoredReadSize,
          this.mergeRangeMaxSize,
          this.readThreads);
    }
  }

}
