/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpResponseException;
import com.google.cloud.hadoop.fs.gcs.GhfsGlobalStorageStatistics;
import com.google.cloud.hadoop.util.GcsRequestExecutionEvent;
import com.google.common.eventbus.Subscribe;
import io.grpc.Status;
import java.io.IOException;
import javax.annotation.Nonnull;

public class GoogleCloudStorageEventSubscriber {
    private static GhfsGlobalStorageStatistics storageStatistics;

    public GoogleCloudStorageEventSubscriber(GhfsGlobalStorageStatistics storageStatistics) {
        GoogleCloudStorageEventSubscriber.storageStatistics = storageStatistics;
    }

    @Subscribe
    private void subscriberOnHttpResponseException(@Nonnull HttpResponseException responseException) {
        this.updateGcsIOSpecificStatistics(responseException.getStatusCode());
    }

    @Subscribe
    private void subscriberOnGoogleJsonResponseException(@Nonnull GoogleJsonResponseException responseException) {
        this.updateGcsIOSpecificStatistics(responseException.getStatusCode());
    }

    @Subscribe
    private void subscriberOnHttpResponseStatus(@Nonnull Integer responseStatus) {
        this.updateGcsIOSpecificStatistics(responseStatus);
        this.incrementStatusCode(responseStatus);
    }

    @Subscribe
    private void subscriberOnGcsRequest(@Nonnull GcsRequestExecutionEvent event) {
        storageStatistics.incrementGcsTotalRequestCount();
    }

    @Subscribe
    private void subscriberOnGrpcStatus(@Nonnull Status status) {
        this.updateGcsIOSpecificStatistics(this.grpcToHttpStatusCodeMapping(status));
    }

    @Subscribe
    private void subscriberOnException(IOException exception) {
        storageStatistics.incrementGcsExceptionCount();
    }

    protected void updateGcsIOSpecificStatistics(int statusCode) {
        if (statusCode >= 400 && statusCode < 500) {
            storageStatistics.incrementGcsClientSideCounter();
            if (statusCode == 429) {
                storageStatistics.incrementRateLimitingCounter();
            }
        }
        if (statusCode >= 500 && statusCode < 600) {
            storageStatistics.incrementGcsServerSideCounter();
        }
    }

    private int grpcToHttpStatusCodeMapping(Status grpcStatusCode) {
        switch (grpcStatusCode.getCode()) {
            case OK: {
                return 200;
            }
            case CANCELLED: {
                return 499;
            }
            case INVALID_ARGUMENT: 
            case FAILED_PRECONDITION: 
            case OUT_OF_RANGE: {
                return 400;
            }
            case DEADLINE_EXCEEDED: {
                return 504;
            }
            case NOT_FOUND: {
                return 404;
            }
            case ALREADY_EXISTS: 
            case ABORTED: {
                return 409;
            }
            case PERMISSION_DENIED: {
                return 403;
            }
            case RESOURCE_EXHAUSTED: {
                return 429;
            }
            case UNIMPLEMENTED: {
                return 501;
            }
            case UNAVAILABLE: {
                return 503;
            }
            case UNAUTHENTICATED: {
                return 401;
            }
        }
        return 500;
    }

    private void incrementStatusCode(int statusCode) {
        switch (statusCode) {
            case 400: {
                storageStatistics.incrementGcsClientBadRequestCount();
                break;
            }
            case 401: {
                storageStatistics.incrementGcsClientUnauthorizedResponseCount();
                break;
            }
            case 404: {
                storageStatistics.incrementGcsClientNotFoundResponseCount();
                break;
            }
            case 408: {
                storageStatistics.incrementGcsClientRequestTimeoutCount();
                break;
            }
            case 410: {
                storageStatistics.incrementGcsClientGoneResponseCount();
                break;
            }
            case 412: {
                storageStatistics.incrementGcsClientPreconditionFailedResponseCount();
                break;
            }
            case 416: {
                storageStatistics.incrementGcsClientRequestedRangeNotSatisfiableCount();
                break;
            }
            case 500: {
                storageStatistics.incrementGcsServerInternalErrorCount();
                break;
            }
            case 502: {
                storageStatistics.incrementGcsServerBadGatewayCount();
                break;
            }
            case 503: {
                storageStatistics.incrementGcsServerServiceUnavailableCount();
                break;
            }
            case 504: {
                storageStatistics.incrementGcsServerTimeoutCount();
            }
        }
    }
}

