/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.hadoop.fs.gcs.GhfsGlobalStorageStatistics;
import com.google.cloud.hadoop.fs.gcs.GhfsInstrumentation;
import com.google.cloud.hadoop.fs.gcs.GhfsStatistic;
import com.google.cloud.hadoop.fs.gcs.GhfsStorageStatistics;
import com.google.cloud.hadoop.fs.gcs.GoogleCloudStorageEventSubscriber;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFSInputStream;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileStatus;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemConfiguration;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopOutputStream;
import com.google.cloud.hadoop.fs.gcs.InMemoryGlobberFileSystem;
import com.google.cloud.hadoop.fs.gcs.VectoredIOImpl;
import com.google.cloud.hadoop.fs.gcs.auth.GcsDelegationTokens;
import com.google.cloud.hadoop.gcsio.CreateFileOptions;
import com.google.cloud.hadoop.gcsio.FileInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.ListFileOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.UpdatableItemInfo;
import com.google.cloud.hadoop.gcsio.UriPaths;
import com.google.cloud.hadoop.util.AccessTokenProvider;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.google.cloud.hadoop.util.GoogleCloudStorageEventBus;
import com.google.cloud.hadoop.util.HadoopCredentialsConfiguration;
import com.google.cloud.hadoop.util.ITraceFactory;
import com.google.cloud.hadoop.util.PropertyUtil;
import com.google.cloud.hadoop.util.TraceFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.flogger.GoogleLogger;
import com.google.common.flogger.LazyArgs;
import com.google.common.io.BaseEncoding;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryNotEmptyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.GlobPattern;
import org.apache.hadoop.fs.GlobalStorageStatistics;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.StorageStatistics;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.impl.AbstractFSBuilderImpl;
import org.apache.hadoop.fs.impl.OpenFileParameters;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.ProviderUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.hadoop.util.LambdaUtils;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.functional.CallableRaisingIOE;

public class GoogleHadoopFileSystem
extends FileSystem
implements IOStatisticsSource {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final String SCHEME = "gs";
    static final short REPLICATION_FACTOR_DEFAULT = 3;
    private static final PathFilter DEFAULT_FILTER = path -> true;
    private static final String PROPERTIES_FILE = "gcs.properties";
    private static final String VERSION_PROPERTY = "gcs.connector.version";
    static final String UNKNOWN_VERSION = "0.0.0";
    private static final String OBJECT_FIELDS = "bucket,name,size,updated";
    private static final ListFileOptions LIST_OPTIONS = ListFileOptions.DEFAULT.toBuilder().setFields("bucket,name,size,updated").build();
    private static final String XATTR_KEY_PREFIX = "GHFS_XATTR_";
    private static final byte[] XATTR_NULL_VALUE = new byte[0];
    private static final ThreadFactory DAEMON_THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("ghfs-thread-%d").setDaemon(true).build();
    static final String VERSION = PropertyUtil.getPropertyOrDefault(GoogleHadoopFileSystem.class, (String)"gcs.properties", (String)"gcs.connector.version", (String)"0.0.0");
    static final String GHFS_ID;
    URI initUri;
    GcsDelegationTokens delegationTokens = null;
    private long defaultBlockSize = (Long)GoogleHadoopFileSystemConfiguration.BLOCK_SIZE.getDefault();
    @VisibleForTesting
    GlobAlgorithm globAlgorithm = (GlobAlgorithm)((Object)GoogleHadoopFileSystemConfiguration.GCS_GLOB_ALGORITHM.getDefault());
    private Path fsRoot;
    private GhfsInstrumentation instrumentation;
    private GhfsGlobalStorageStatistics globalStorageStatistics;
    private GhfsStorageStatistics storageStatistics;
    private ExecutorService backgroundTasksThreadPool = Executors.newCachedThreadPool(DAEMON_THREAD_FACTORY);
    private GcsFileChecksumType checksumType = (GcsFileChecksumType)((Object)GoogleHadoopFileSystemConfiguration.GCS_FILE_CHECKSUM_TYPE.getDefault());
    private Supplier<GoogleCloudStorageFileSystem> gcsFsSupplier;
    private Supplier<VectoredIOImpl> vectoredIOSupplier;
    private boolean gcsFsInitialized = false;
    private boolean vectoredIOInitialized = false;
    private Path workingDirectory;
    private FsPermission reportedPermissions;
    private ITraceFactory traceFactory = TraceFactory.get((boolean)false);

    ITraceFactory getTraceFactory() {
        return this.traceFactory;
    }

    public GoogleHadoopFileSystem() {
        StorageStatistics globalStats = GlobalStorageStatistics.INSTANCE.put("GhfsStorageStatistics", () -> new GhfsGlobalStorageStatistics());
        if (GhfsGlobalStorageStatistics.class.isAssignableFrom(globalStats.getClass())) {
            this.globalStorageStatistics = (GhfsGlobalStorageStatistics)globalStats;
        } else {
            ((GoogleLogger.Api)logger.atWarning()).log("Encountered an error while registering to GlobalStorageStatistics. Some of the GCS connector metrics will not be reported to metrics sinks. globalStatsClassLoader=<%s>; classLoader=<%s>", (Object)globalStats.getClass().getClassLoader(), (Object)GhfsGlobalStorageStatistics.class.getClassLoader());
            this.globalStorageStatistics = GhfsGlobalStorageStatistics.DUMMY_INSTANCE;
        }
        GoogleCloudStorageEventBus.register((Object)new GoogleCloudStorageEventSubscriber(this.globalStorageStatistics));
    }

    @VisibleForTesting
    GoogleHadoopFileSystem(GoogleCloudStorageFileSystem gcsfs) {
        this();
        Preconditions.checkNotNull((Object)gcsfs, (Object)"gcsFs must not be null");
        this.initializeGcsFs(gcsfs);
    }

    public void initialize(URI path, Configuration config) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("initialize(path: %s, config: %s)", (Object)path, (Object)config);
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path must not be null");
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"config must not be null");
        Preconditions.checkArgument((path.getScheme() != null ? 1 : 0) != 0, (Object)"scheme of path must not be null");
        Preconditions.checkArgument((boolean)path.getScheme().equals(this.getScheme()), (String)"URI scheme not supported: %s", (Object)path);
        config = ProviderUtils.excludeIncompatibleCredentialProviders((Configuration)config, GoogleHadoopFileSystem.class);
        super.initialize(path, config);
        this.initUri = path;
        this.setConf(config);
        this.globAlgorithm = (GlobAlgorithm)((Object)GoogleHadoopFileSystemConfiguration.GCS_GLOB_ALGORITHM.get(config, (arg_0, arg_1) -> ((Configuration)config).getEnum(arg_0, arg_1)));
        this.checksumType = (GcsFileChecksumType)((Object)GoogleHadoopFileSystemConfiguration.GCS_FILE_CHECKSUM_TYPE.get(config, (arg_0, arg_1) -> ((Configuration)config).getEnum(arg_0, arg_1)));
        this.defaultBlockSize = (Long)GoogleHadoopFileSystemConfiguration.BLOCK_SIZE.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1));
        this.reportedPermissions = new FsPermission((String)GoogleHadoopFileSystemConfiguration.PERMISSIONS_TO_REPORT.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1)));
        this.initializeFsRoot();
        this.initializeWorkingDirectory(config);
        this.initializeDelegationTokenSupport(config);
        this.instrumentation = new GhfsInstrumentation(this.initUri);
        this.storageStatistics = (GhfsStorageStatistics)GlobalStorageStatistics.INSTANCE.put("GhfsFileSystemBasedStorageStatistics", () -> new GhfsStorageStatistics((IOStatistics)this.instrumentation.getIOStatistics()));
        this.initializeVectoredIO(config, this.globalStorageStatistics, this.statistics);
        this.initializeGcsFs(config);
        this.traceFactory = TraceFactory.get((boolean)((Boolean)GoogleHadoopFileSystemConfiguration.GCS_OPERATION_TRACE_LOG_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))));
    }

    private void initializeFsRoot() {
        String rootBucket = this.initUri.getAuthority();
        Preconditions.checkArgument((rootBucket != null ? 1 : 0) != 0, (String)"No bucket specified in GCS URI: %s", (Object)this.initUri);
        URI rootUri = UriPaths.fromStringPathComponents((String)rootBucket, null, (boolean)true);
        this.fsRoot = new Path(rootUri);
        ((GoogleLogger.Api)logger.atFiner()).log("Configured FS root: '%s'", (Object)this.fsRoot);
    }

    private void initializeWorkingDirectory(Configuration config) {
        String configWorkingDirectory = (String)GoogleHadoopFileSystemConfiguration.GCS_WORKING_DIRECTORY.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1));
        if (Strings.isNullOrEmpty((String)configWorkingDirectory)) {
            ((GoogleLogger.Api)logger.atWarning()).log("No working directory configured, using default: '%s'", (Object)this.workingDirectory);
        }
        this.setWorkingDirectory(Strings.isNullOrEmpty((String)configWorkingDirectory) ? this.fsRoot : new Path(configWorkingDirectory));
        ((GoogleLogger.Api)logger.atFiner()).log("Configured working directory: %s = %s", (Object)GoogleHadoopFileSystemConfiguration.GCS_WORKING_DIRECTORY.getKey(), (Object)this.getWorkingDirectory());
    }

    private void initializeDelegationTokenSupport(Configuration config) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("initializeDelegationTokenSupport(config: %s)", (Object)config);
        if (Strings.isNullOrEmpty((String)((String)GoogleHadoopFileSystemConfiguration.DELEGATION_TOKEN_BINDING_CLASS.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1))))) {
            return;
        }
        GcsDelegationTokens dts = new GcsDelegationTokens();
        Text service = new Text(this.fsRoot.toString());
        dts.bindToFileSystem(this, service);
        dts.init(config);
        dts.start();
        this.delegationTokens = dts;
        if (this.delegationTokens.isBoundToDT()) {
            ((GoogleLogger.Api)logger.atFine()).log("initializeDelegationTokenSupport(config: %s): using existing delegation token", (Object)config);
        }
    }

    private synchronized void initializeGcsFs(Configuration config) throws IOException {
        if (this.gcsFsSupplier == null) {
            if (((Boolean)GoogleHadoopFileSystemConfiguration.GCS_LAZY_INITIALIZATION_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).booleanValue()) {
                this.gcsFsSupplier = Suppliers.memoize(() -> {
                    try {
                        GoogleCloudStorageFileSystem gcsFs = this.createGcsFs(config);
                        this.gcsFsInitialized = true;
                        return gcsFs;
                    }
                    catch (IOException e) {
                        GoogleCloudStorageEventBus.postOnException();
                        throw new RuntimeException("Failed to create GCS FS", e);
                    }
                });
            } else {
                this.initializeGcsFs(this.createGcsFs(config));
            }
        }
    }

    private synchronized void initializeVectoredIO(Configuration config, GhfsGlobalStorageStatistics globalStorageStatistics, FileSystem.Statistics statistics) throws IOException {
        if (this.vectoredIOSupplier == null) {
            this.vectoredIOSupplier = Suppliers.memoize(() -> {
                try {
                    VectoredIOImpl vectoredIO = new VectoredIOImpl(GoogleHadoopFileSystemConfiguration.getVectoredReadOptionBuilder(config).build(), globalStorageStatistics);
                    this.vectoredIOInitialized = true;
                    return vectoredIO;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failure initializing vectoredIO", e);
                }
            });
        }
    }

    private void initializeGcsFs(GoogleCloudStorageFileSystem gcsFs) {
        this.gcsFsSupplier = Suppliers.ofInstance((Object)gcsFs);
        this.gcsFsInitialized = true;
    }

    private GoogleCloudStorageFileSystem createGcsFs(Configuration config) throws IOException {
        GoogleCloudStorageFileSystemOptions gcsFsOptions = GoogleHadoopFileSystemConfiguration.getGcsFsOptionsBuilder(config).build();
        GoogleCredentials credentials = this.getCredentials(config);
        AccessTokenProvider accessTokenProvider = credentials instanceof HadoopCredentialsConfiguration.AccessTokenProviderCredentials ? ((HadoopCredentialsConfiguration.AccessTokenProviderCredentials)credentials).getAccessTokenProvider() : null;
        return accessTokenProvider != null && accessTokenProvider.getAccessTokenType() == AccessTokenProvider.AccessTokenType.DOWNSCOPED ? new GoogleCloudStorageFileSystemImpl(null, accessBoundaries -> accessTokenProvider.getAccessToken(accessBoundaries).getToken(), gcsFsOptions) : new GoogleCloudStorageFileSystemImpl((Credentials)credentials, null, gcsFsOptions);
    }

    private GoogleCredentials getCredentials(Configuration config) throws IOException {
        AccessTokenProvider delegationAccessTokenProvider = this.getDelegationAccessTokenProvider(config);
        GoogleCredentials credentials = delegationAccessTokenProvider == null ? HadoopCredentialsConfiguration.getCredentials((Configuration)config, (String[])new String[]{"fs.gs"}) : new HadoopCredentialsConfiguration.AccessTokenProviderCredentials(delegationAccessTokenProvider).createScoped(new String[]{"https://www.googleapis.com/auth/cloud-platform"});
        return Optional.ofNullable(HadoopCredentialsConfiguration.getImpersonatedCredentials((Configuration)config, (GoogleCredentials)credentials, (String[])new String[]{"fs.gs"})).orElse(credentials);
    }

    private static boolean isImplicitDirectory(FileStatus curr) {
        return curr.isDirectory() && curr.getModificationTime() == 0L;
    }

    private static String getUgiUserName() throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        return ugi.getShortUserName();
    }

    private static String fileStatusToString(FileStatus fileStatus) {
        Preconditions.checkNotNull((Object)fileStatus, (Object)"fileStatus should not be null");
        return String.format("path: %s, isDir: %s, len: %d, owner: %s", fileStatus.getPath(), fileStatus.isDirectory(), fileStatus.getLen(), fileStatus.getOwner());
    }

    private static FileChecksum getFileChecksum(GcsFileChecksumType type, FileInfo fileInfo) throws IOException {
        switch (type) {
            case NONE: {
                return null;
            }
            case CRC32C: {
                return new GcsFileChecksum(type, fileInfo.getCrc32cChecksum());
            }
            case MD5: {
                return new GcsFileChecksum(type, fileInfo.getMd5Checksum());
            }
        }
        GoogleCloudStorageEventBus.postOnException();
        throw new IOException("Unrecognized GcsFileChecksumType: " + type);
    }

    protected void checkPath(Path path) {
        ((GoogleLogger.Api)logger.atFiner()).log("checkPath(path: %s)", (Object)path);
        URI uri = path.toUri();
        String scheme = uri.getScheme();
        if (scheme != null && !scheme.equalsIgnoreCase(this.getScheme())) {
            GoogleCloudStorageEventBus.postOnException();
            throw new IllegalArgumentException(String.format("Wrong scheme: %s, in path: %s, expected scheme: %s", scheme, path, this.getScheme()));
        }
        String bucket = uri.getAuthority();
        String rootBucket = this.fsRoot.toUri().getAuthority();
        if (bucket == null || bucket.equals(rootBucket)) {
            return;
        }
        GoogleCloudStorageEventBus.postOnException();
        throw new IllegalArgumentException(String.format("Wrong bucket: %s, in path: %s, expected bucket: %s", bucket, path, rootBucket));
    }

    Path getHadoopPath(URI gcsPath) {
        ((GoogleLogger.Api)logger.atFiner()).log("getHadoopPath(gcsPath: %s)", (Object)gcsPath);
        if (gcsPath.equals(this.getGcsPath(this.fsRoot))) {
            return this.fsRoot;
        }
        StorageResourceId resourceId = StorageResourceId.fromUriPath((URI)gcsPath, (boolean)true);
        Preconditions.checkArgument((!resourceId.isRoot() ? 1 : 0) != 0, (String)"Missing authority in gcsPath '%s'", (Object)gcsPath);
        String rootBucket = this.fsRoot.toUri().getAuthority();
        Preconditions.checkArgument((boolean)resourceId.getBucketName().equals(rootBucket), (String)"Authority of URI '%s' doesn't match root bucket '%s'", (Object)resourceId.getBucketName(), (Object)rootBucket);
        Path hadoopPath = new Path(this.fsRoot, new Path(null, null, resourceId.getObjectName()));
        ((GoogleLogger.Api)logger.atFiner()).log("getHadoopPath(gcsPath: %s): %s", (Object)gcsPath, (Object)hadoopPath);
        return hadoopPath;
    }

    URI getGcsPath(Path hadoopPath) {
        ((GoogleLogger.Api)logger.atFiner()).log("getGcsPath(hadoopPath: %s)", (Object)hadoopPath);
        Path resolvedPath = this.makeQualified(hadoopPath);
        String objectName = resolvedPath.toUri().getPath();
        if (objectName != null && resolvedPath.isAbsolute()) {
            objectName = objectName.substring(1);
        }
        String rootBucket = this.fsRoot.toUri().getAuthority();
        URI gcsPath = UriPaths.fromStringPathComponents((String)rootBucket, (String)objectName, (boolean)true);
        ((GoogleLogger.Api)logger.atFiner()).log("getGcsPath(hadoopPath: %s): %s", (Object)hadoopPath, (Object)gcsPath);
        return gcsPath;
    }

    public String getScheme() {
        return SCHEME;
    }

    public FSDataInputStream open(Path hadoopPath, int bufferSize) throws IOException {
        return (FSDataInputStream)this.trackDurationWithTracing(this.instrumentation, this.globalStorageStatistics, GhfsStatistic.INVOCATION_OPEN, hadoopPath, this.traceFactory, () -> {
            Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
            this.checkOpen();
            ((GoogleLogger.Api)logger.atFiner()).log("open(hadoopPath: %s, bufferSize: %d [ignored])", (Object)hadoopPath, bufferSize);
            URI gcsPath = this.getGcsPath(hadoopPath);
            return new FSDataInputStream((InputStream)((Object)GoogleHadoopFSInputStream.create(this, gcsPath, this.statistics)));
        });
    }

    public FSDataOutputStream create(Path hadoopPath, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return (FSDataOutputStream)this.trackDurationWithTracing(this.instrumentation, this.globalStorageStatistics, GhfsStatistic.INVOCATION_CREATE, hadoopPath, this.traceFactory, () -> {
            Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
            Preconditions.checkArgument((replication > 0 ? 1 : 0) != 0, (String)"replication must be a positive integer: %s", (int)replication);
            Preconditions.checkArgument((blockSize > 0L ? 1 : 0) != 0, (String)"blockSize must be a positive integer: %s", (long)blockSize);
            this.checkOpen();
            ((GoogleLogger.Api)logger.atFiner()).log("create(hadoopPath: %s, overwrite: %b, bufferSize: %d [ignored])", (Object)hadoopPath, (Object)overwrite, (Object)bufferSize);
            FSDataOutputStream response = new FSDataOutputStream((OutputStream)new GoogleHadoopOutputStream(this, this.getGcsPath(hadoopPath), CreateFileOptions.builder().setWriteMode(overwrite ? CreateFileOptions.WriteMode.OVERWRITE : CreateFileOptions.WriteMode.CREATE_NEW).setMinSyncInterval(GoogleHadoopFileSystemConfiguration.GCS_OUTPUT_STREAM_SYNC_MIN_INTERVAL.getTimeDuration(this.getConf())).build(), this.statistics), this.statistics);
            this.incrementStatistic(GhfsStatistic.FILES_CREATED);
            return response;
        });
    }

    public FSDataOutputStream createNonRecursive(Path hadoopPath, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return (FSDataOutputStream)this.trackDurationWithTracing(this.instrumentation, this.globalStorageStatistics, GhfsStatistic.INVOCATION_CREATE_NON_RECURSIVE, hadoopPath, this.traceFactory, () -> {
            URI gcsPath = this.getGcsPath((Path)Preconditions.checkNotNull((Object)hadoopPath, (Object)"hadoopPath must not be null"));
            URI parentGcsPath = UriPaths.getParentPath((URI)gcsPath);
            if (!this.getGcsFs().getFileInfo(parentGcsPath).exists()) {
                GoogleCloudStorageEventBus.postOnException();
                throw new FileNotFoundException(String.format("Can not create '%s' file, because parent folder does not exist: %s", gcsPath, parentGcsPath));
            }
            return this.create(hadoopPath, permission, flags.contains(CreateFlag.OVERWRITE), bufferSize, replication, blockSize, progress);
        });
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return (Boolean)this.trackDurationWithTracing(this.instrumentation, this.globalStorageStatistics, GhfsStatistic.INVOCATION_RENAME, String.format("rename(%s -> %s)", src, dst), this.traceFactory, () -> {
            Preconditions.checkArgument((src != null ? 1 : 0) != 0, (Object)"src must not be null");
            Preconditions.checkArgument((dst != null ? 1 : 0) != 0, (Object)"dst must not be null");
            if (this.makeQualified(src).equals((Object)this.fsRoot)) {
                ((GoogleLogger.Api)logger.atFiner()).log("rename(src: %s, dst: %s): false [src is a root]", (Object)src, (Object)dst);
                return false;
            }
            try {
                this.renameInternal(src, dst);
            }
            catch (IOException e) {
                GoogleCloudStorageEventBus.postOnException();
                if (ApiErrorExtractor.INSTANCE.requestFailure(e)) {
                    throw e;
                }
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFiner()).withCause((Throwable)e)).log("rename(src: %s, dst: %s): false [failed]", (Object)src, (Object)dst);
                return false;
            }
            return true;
        });
    }

    private <B> B trackDurationWithTracing(DurationTrackerFactory factory, @Nonnull GhfsGlobalStorageStatistics stats, GhfsStatistic statistic, Object context, ITraceFactory traceFactory, CallableRaisingIOE<B> operation) throws IOException {
        return GhfsGlobalStorageStatistics.trackDuration(factory, stats, statistic, context, traceFactory, operation);
    }

    public boolean delete(Path hadoopPath, boolean recursive) throws IOException {
        return (Boolean)this.trackDurationWithTracing(this.instrumentation, this.globalStorageStatistics, GhfsStatistic.INVOCATION_DELETE, hadoopPath, this.traceFactory, () -> {
            boolean response;
            try {
                boolean result = true;
                Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
                this.checkOpen();
                URI gcsPath = this.getGcsPath(hadoopPath);
                try {
                    this.getGcsFs().delete(gcsPath, recursive);
                }
                catch (DirectoryNotEmptyException e) {
                    throw e;
                }
                catch (IOException e) {
                    GoogleCloudStorageEventBus.postOnException();
                    if (ApiErrorExtractor.INSTANCE.requestFailure(e)) {
                        throw e;
                    }
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFiner()).withCause((Throwable)e)).log("delete(hadoopPath: %s, recursive: %b): false [failed]", (Object)hadoopPath, recursive);
                    result = false;
                }
                if (result) {
                    ((GoogleLogger.Api)logger.atFiner()).log("delete(hadoopPath: %s, recursive: %b): true", (Object)hadoopPath, recursive);
                }
                response = result;
                this.incrementStatistic(GhfsStatistic.FILES_DELETED);
            }
            catch (IOException e) {
                GoogleCloudStorageEventBus.postOnException();
                this.incrementStatistic(GhfsStatistic.FILES_DELETE_REJECTED);
                throw e;
            }
            return response;
        });
    }

    public FileStatus[] listStatus(Path hadoopPath) throws IOException {
        return (FileStatus[])this.trackDurationWithTracing(this.instrumentation, this.globalStorageStatistics, GhfsStatistic.INVOCATION_LIST_STATUS, hadoopPath, this.traceFactory, () -> {
            ArrayList<GoogleHadoopFileStatus> status;
            Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
            this.checkOpen();
            ((GoogleLogger.Api)logger.atFiner()).log("listStatus(hadoopPath: %s)", (Object)hadoopPath);
            URI gcsPath = this.getGcsPath(hadoopPath);
            try {
                List fileInfos = this.getGcsFs().listFileInfo(gcsPath, LIST_OPTIONS);
                status = new ArrayList<GoogleHadoopFileStatus>(fileInfos.size());
                String userName = GoogleHadoopFileSystem.getUgiUserName();
                for (FileInfo fileInfo : fileInfos) {
                    status.add(this.getGoogleHadoopFileStatus(fileInfo, userName));
                }
            }
            catch (FileNotFoundException fnfe) {
                GoogleCloudStorageEventBus.postOnException();
                throw (FileNotFoundException)new FileNotFoundException(String.format("listStatus(hadoopPath: %s): '%s' does not exist.", hadoopPath, gcsPath)).initCause(fnfe);
            }
            this.incrementStatistic(GhfsStatistic.INVOCATION_LIST_STATUS_RESULT_SIZE, status.size());
            return status.toArray(new FileStatus[0]);
        });
    }

    public boolean mkdirs(Path hadoopPath, FsPermission permission) throws IOException {
        return (Boolean)this.trackDurationWithTracing(this.instrumentation, this.globalStorageStatistics, GhfsStatistic.INVOCATION_MKDIRS, hadoopPath, this.traceFactory, () -> {
            Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
            this.checkOpen();
            URI gcsPath = this.getGcsPath(hadoopPath);
            try {
                this.getGcsFs().mkdirs(gcsPath);
            }
            catch (java.nio.file.FileAlreadyExistsException faee) {
                GoogleCloudStorageEventBus.postOnException();
                throw (FileAlreadyExistsException)new FileAlreadyExistsException(String.format("mkdirs(hadoopPath: %s, permission: %s): failed", hadoopPath, permission)).initCause((Throwable)faee);
            }
            ((GoogleLogger.Api)logger.atFiner()).log("mkdirs(hadoopPath: %s, permission: %s): true", (Object)hadoopPath, (Object)permission);
            boolean response = true;
            this.incrementStatistic(GhfsStatistic.DIRECTORIES_CREATED);
            return response;
        });
    }

    public FileStatus getFileStatus(Path hadoopPath) throws IOException {
        return (FileStatus)this.trackDurationWithTracing(this.instrumentation, this.globalStorageStatistics, GhfsStatistic.INVOCATION_GET_FILE_STATUS, hadoopPath, this.traceFactory, () -> {
            Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
            this.checkOpen();
            URI gcsPath = this.getGcsPath(hadoopPath);
            FileInfo fileInfo = this.getGcsFs().getFileInfo(gcsPath);
            if (!fileInfo.exists()) {
                GoogleCloudStorageEventBus.postOnException();
                throw new FileNotFoundException(String.format("%s not found: %s", fileInfo.isDirectory() ? "Directory" : "File", hadoopPath));
            }
            String userName = GoogleHadoopFileSystem.getUgiUserName();
            return this.getGoogleHadoopFileStatus(fileInfo, userName);
        });
    }

    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        this.incrementStatistic(GhfsStatistic.INVOCATION_GLOB_STATUS);
        this.checkOpen();
        ((GoogleLogger.Api)logger.atFiner()).log("globStatus(pathPattern: %s, filter: %s)", (Object)pathPattern, (Object)filter);
        Path encodedPath = new Path(pathPattern.toUri().toString());
        Path encodedFixedPath = this.getHadoopPath(this.getGcsPath(encodedPath));
        Path fixedPath = new Path(URI.create(encodedFixedPath.toString()));
        ((GoogleLogger.Api)logger.atFiner()).log("fixed path pattern: %s => %s", (Object)pathPattern, (Object)fixedPath);
        if (this.globAlgorithm == GlobAlgorithm.CONCURRENT && this.couldUseFlatGlob(fixedPath)) {
            return this.concurrentGlobInternal(fixedPath, filter);
        }
        if (this.globAlgorithm == GlobAlgorithm.FLAT && this.couldUseFlatGlob(fixedPath)) {
            return this.flatGlobInternal(fixedPath, filter);
        }
        return super.globStatus(fixedPath, filter);
    }

    public Token<?> getDelegationToken(String renewer) throws IOException {
        this.incrementStatistic(GhfsStatistic.INVOCATION_GET_DELEGATION_TOKEN);
        Token<DelegationTokenIdentifier> result = null;
        if (this.delegationTokens != null) {
            result = this.delegationTokens.getBoundOrNewDT(renewer);
        }
        ((GoogleLogger.Api)logger.atFiner()).log("getDelegationToken(renewer: %s): %s", (Object)renewer, result);
        return result;
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path[] srcs, Path dst) throws IOException {
        this.incrementStatistic(GhfsStatistic.INVOCATION_COPY_FROM_LOCAL_FILE);
        ((GoogleLogger.Api)logger.atFiner()).log("copyFromLocalFile(delSrc: %b, overwrite: %b, %d srcs, dst: %s)", (Object)delSrc, (Object)overwrite, (Object)srcs.length, (Object)dst);
        super.copyFromLocalFile(delSrc, overwrite, srcs, dst);
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        this.incrementStatistic(GhfsStatistic.INVOCATION_COPY_FROM_LOCAL_FILE);
        ((GoogleLogger.Api)logger.atFiner()).log("copyFromLocalFile(delSrc: %b, overwrite: %b, src: %s, dst: %s)", (Object)delSrc, (Object)overwrite, (Object)src, (Object)dst);
        super.copyFromLocalFile(delSrc, overwrite, src, dst);
    }

    public FileChecksum getFileChecksum(Path hadoopPath) throws IOException {
        this.incrementStatistic(GhfsStatistic.INVOCATION_GET_FILE_CHECKSUM);
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        this.checkOpen();
        URI gcsPath = this.getGcsPath(hadoopPath);
        FileInfo fileInfo = this.getGcsFs().getFileInfo(gcsPath);
        if (!fileInfo.exists()) {
            throw new FileNotFoundException(String.format("%s not found: %s", fileInfo.isDirectory() ? "Directory" : "File", hadoopPath));
        }
        FileChecksum checksum = GoogleHadoopFileSystem.getFileChecksum(this.checksumType, fileInfo);
        ((GoogleLogger.Api)logger.atFiner()).log("getFileChecksum(hadoopPath: %s [gcsPath: %s]): %s", (Object)hadoopPath, (Object)gcsPath, (Object)checksum);
        return checksum;
    }

    public boolean exists(Path f) throws IOException {
        this.incrementStatistic(GhfsStatistic.INVOCATION_EXISTS);
        return super.exists(f);
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws IOException {
        this.incrementStatistic(GhfsStatistic.INVOCATION_LIST_LOCATED_STATUS);
        return super.listLocatedStatus(f);
    }

    public byte[] getXAttr(Path path, String name) throws IOException {
        return (byte[])this.trackDurationWithTracing(this.instrumentation, this.globalStorageStatistics, GhfsStatistic.INVOCATION_XATTR_GET_NAMED, path, this.traceFactory, () -> {
            Preconditions.checkNotNull((Object)path, (Object)"path should not be null");
            Preconditions.checkNotNull((Object)name, (Object)"name should not be null");
            Map attributes = this.getGcsFs().getFileInfo(this.getGcsPath(path)).getAttributes();
            String xAttrKey = this.getXAttrKey(name);
            byte[] xAttr = attributes.containsKey(xAttrKey) ? this.getXAttrValue((byte[])attributes.get(xAttrKey)) : null;
            ((GoogleLogger.Api)logger.atFiner()).log("getXAttr(path: %s, name: %s): %s", (Object)path, (Object)name, (Object)LazyArgs.lazy(() -> xAttr == null ? "<null>" : new String(xAttr, StandardCharsets.UTF_8)));
            return xAttr;
        });
    }

    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        return (Map)this.trackDurationWithTracing(this.instrumentation, this.globalStorageStatistics, GhfsStatistic.INVOCATION_XATTR_GET_MAP, path, this.traceFactory, () -> {
            Preconditions.checkNotNull((Object)path, (Object)"path should not be null");
            FileInfo fileInfo = this.getGcsFs().getFileInfo(this.getGcsPath(path));
            Map xAttrs = fileInfo.getAttributes().entrySet().stream().filter(a -> this.isXAttr((String)a.getKey())).collect(HashMap::new, (m, a) -> m.put(this.getXAttrName((String)a.getKey()), this.getXAttrValue((byte[])a.getValue())), Map::putAll);
            ((GoogleLogger.Api)logger.atFiner()).log("getXAttrs(path: %s): %s", (Object)path, (Object)xAttrs);
            return xAttrs;
        });
    }

    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        return (Map)this.trackDurationWithTracing(this.instrumentation, this.globalStorageStatistics, GhfsStatistic.INVOCATION_XATTR_GET_NAMED_MAP, path, this.traceFactory, () -> {
            Map xAttrs;
            Preconditions.checkNotNull((Object)path, (Object)"path should not be null");
            Preconditions.checkNotNull((Object)names, (Object)"names should not be null");
            if (names.isEmpty()) {
                xAttrs = new HashMap();
            } else {
                HashSet namesSet = new HashSet(names);
                xAttrs = this.getXAttrs(path).entrySet().stream().filter(a -> namesSet.contains(a.getKey())).collect(HashMap::new, (m, a) -> m.put((String)a.getKey(), (byte[])a.getValue()), Map::putAll);
            }
            ((GoogleLogger.Api)logger.atFiner()).log("getXAttrs(path: %s, names: %s): %s", (Object)path, (Object)names, xAttrs);
            return xAttrs;
        });
    }

    public List<String> listXAttrs(Path path) throws IOException {
        return (List)this.trackDurationWithTracing(this.instrumentation, this.globalStorageStatistics, GhfsStatistic.INVOCATION_OP_XATTR_LIST, path, this.traceFactory, () -> {
            Preconditions.checkNotNull((Object)path, (Object)"path should not be null");
            List xAttrs = this.getGcsFs().getFileInfo(this.getGcsPath(path)).getAttributes().keySet().stream().filter(this::isXAttr).map(this::getXAttrName).collect(Collectors.toCollection(ArrayList::new));
            ((GoogleLogger.Api)logger.atFiner()).log("listXAttrs(path: %s): %s", (Object)path, (Object)xAttrs);
            return xAttrs;
        });
    }

    private void incrementStatistic(GhfsStatistic statistic) {
        this.incrementStatistic(statistic, 1L);
    }

    private void incrementStatistic(GhfsStatistic statistic, long count) {
        if (this.isClosed()) {
            return;
        }
        this.instrumentation.incrementCounter(statistic, count);
        this.globalStorageStatistics.incrementCounter(statistic, count);
    }

    public GhfsGlobalStorageStatistics getGlobalGcsStorageStatistics() {
        return this.globalStorageStatistics;
    }

    public GhfsStorageStatistics getStorageStatistics() {
        return this.storageStatistics;
    }

    public IOStatistics getIOStatistics() {
        if (this.instrumentation == null) {
            return null;
        }
        this.setHttpStatistics();
        return this.instrumentation.getIOStatistics();
    }

    public GhfsInstrumentation getInstrumentation() {
        return this.instrumentation;
    }

    private void setHttpStatistics() {
        try {
            this.getGcsFs().getGcs().getStatistics().forEach((k, v) -> {
                GhfsStatistic statisticKey = GhfsStatistic.fromSymbol("ACTION_" + k);
                Preconditions.checkNotNull((Object)((Object)statisticKey), (String)"statistic key for %s must not be null", (Object)k);
                this.clearStats(statisticKey.getSymbol());
                this.incrementStatistic(statisticKey, (long)v);
            });
        }
        catch (Exception e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause((Throwable)e)).log("Error while getting GCS statistics");
        }
    }

    private void clearStats(String key) {
        this.instrumentation.getIOStatistics().getCounterReference(key).set(0L);
    }

    public Path makeQualified(Path path) {
        Path qualifiedPath = super.makeQualified(path);
        URI uri = qualifiedPath.toUri();
        Preconditions.checkState(("".equals(uri.getPath()) || qualifiedPath.isAbsolute() ? 1 : 0) != 0, (String)"Path '%s' must be fully qualified.", (Object)qualifiedPath);
        String upath = uri.getPath();
        int i = 0;
        while (upath.startsWith("/../", i)) {
            i += 3;
        }
        Path result = i == upath.length() || upath.substring(i).equals("/..") ? new Path(uri.getScheme(), uri.getAuthority(), "/") : (i == 0 ? qualifiedPath : new Path(uri.getScheme(), uri.getAuthority(), upath.substring(i)));
        ((GoogleLogger.Api)logger.atFiner()).log("makeQualified(path: %s): %s", (Object)path, (Object)result);
        return result;
    }

    public URI getUri() {
        return this.fsRoot.toUri();
    }

    protected int getDefaultPort() {
        int result = -1;
        ((GoogleLogger.Api)logger.atFiner()).log("getDefaultPort(): %d", result);
        return result;
    }

    public boolean hasPathCapability(Path path, String capability) {
        Preconditions.checkNotNull((Object)path, (Object)"path must not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)capability) ? 1 : 0) != 0, (String)"capability must not be null or empty string for %s", (Object)path);
        switch (Ascii.toLowerCase((String)capability)) {
            case "fs.capability.paths.append": 
            case "fs.capability.paths.concat": {
                return true;
            }
        }
        return false;
    }

    public CompletableFuture<FSDataInputStream> openFileWithOptions(Path hadoopPath, OpenFileParameters parameters) throws IOException {
        FileInfo fileInfo;
        Preconditions.checkNotNull((Object)hadoopPath, (Object)"hadoopPath should not be null");
        this.checkOpen();
        ((GoogleLogger.Api)logger.atFiner()).log("Path to be opened: %s, parameters: %s ", (Object)hadoopPath, (Object)parameters);
        URI gcsPath = this.getGcsPath(hadoopPath);
        AbstractFSBuilderImpl.rejectUnknownMandatoryKeys((Set)parameters.getMandatoryKeys(), (Collection)Options.OpenFileOptions.FS_OPTION_OPENFILE_STANDARD_OPTIONS, (String)("for " + gcsPath));
        FileStatus fileStatus = parameters.getStatus();
        FileInfo fileInfo2 = fileInfo = fileStatus instanceof GoogleHadoopFileStatus ? ((GoogleHadoopFileStatus)fileStatus).getFileInfo() : null;
        if (fileInfo == null) {
            return super.openFileWithOptions(hadoopPath, parameters);
        }
        CompletableFuture<FSDataInputStream> result = new CompletableFuture<FSDataInputStream>();
        this.backgroundTasksThreadPool.submit(() -> LambdaUtils.eval((CompletableFuture)result, () -> new FSDataInputStream((InputStream)((Object)GoogleHadoopFSInputStream.create(this, fileInfo, this.statistics)))));
        return result;
    }

    public FSDataOutputStream append(Path hadoopPath, int bufferSize, Progressable progress) throws IOException {
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        ((GoogleLogger.Api)logger.atFiner()).log("append(hadoopPath: %s, bufferSize: %d [ignored])", (Object)hadoopPath, bufferSize);
        URI filePath = this.getGcsPath(hadoopPath);
        return new FSDataOutputStream((OutputStream)new GoogleHadoopOutputStream(this, filePath, CreateFileOptions.builder().setWriteMode(CreateFileOptions.WriteMode.APPEND).setMinSyncInterval(GoogleHadoopFileSystemConfiguration.GCS_OUTPUT_STREAM_SYNC_MIN_INTERVAL.getTimeDuration(this.getConf())).build(), this.statistics), this.statistics);
    }

    public void concat(Path tgt, Path[] srcs) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("concat(tgt: %s, srcs: %s)", (Object)tgt, (Object)LazyArgs.lazy(() -> Arrays.toString(srcs)));
        Preconditions.checkArgument((srcs.length > 0 ? 1 : 0) != 0, (Object)"srcs must have at least one source");
        URI tgtPath = this.getGcsPath(tgt);
        List srcPaths = (List)Arrays.stream(srcs).map(this::getGcsPath).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument((!srcPaths.contains(tgtPath) ? 1 : 0) != 0, (Object)"target must not be contained in sources");
        List partitions = Lists.partition((List)srcPaths, (int)31);
        ((GoogleLogger.Api)logger.atFiner()).log("concat(tgt: %s, %d partitions: %s)", (Object)tgt, (Object)partitions.size(), (Object)partitions);
        for (List partition : partitions) {
            ArrayList sources = Lists.newArrayList((Object[])new URI[]{tgtPath});
            sources.addAll(partition);
            this.getGcsFs().compose((List)sources, tgtPath, CreateFileOptions.DEFAULT.getContentType());
        }
    }

    void renameInternal(Path src, Path dst) throws IOException {
        Preconditions.checkArgument((src != null ? 1 : 0) != 0, (Object)"src must not be null");
        Preconditions.checkArgument((dst != null ? 1 : 0) != 0, (Object)"dst must not be null");
        this.checkOpen();
        URI srcPath = this.getGcsPath(src);
        URI dstPath = this.getGcsPath(dst);
        this.getGcsFs().rename(srcPath, dstPath);
        ((GoogleLogger.Api)logger.atFiner()).log("rename(src: %s, dst: %s): true", (Object)src, (Object)dst);
    }

    public Path getWorkingDirectory() {
        ((GoogleLogger.Api)logger.atFiner()).log("getWorkingDirectory(): %s", (Object)this.workingDirectory);
        return this.workingDirectory;
    }

    public short getDefaultReplication() {
        return 3;
    }

    private GoogleHadoopFileStatus getGoogleHadoopFileStatus(FileInfo fileInfo, String userName) {
        Preconditions.checkNotNull((Object)fileInfo, (Object)"fileInfo should not be null");
        GoogleHadoopFileStatus status = new GoogleHadoopFileStatus(fileInfo, this.getHadoopPath(fileInfo.getPath()), 3, this.defaultBlockSize, this.reportedPermissions, userName);
        ((GoogleLogger.Api)logger.atFiner()).log("getGoogleHadoopFileStatus(path: %s, userName: %s): %s", (Object)fileInfo.getPath(), (Object)userName, (Object)LazyArgs.lazy(() -> GoogleHadoopFileSystem.fileStatusToString(status)));
        return status;
    }

    @VisibleForTesting
    boolean couldUseFlatGlob(Path fixedPath) {
        if (!this.getUri().getScheme().equals(SCHEME)) {
            ((GoogleLogger.Api)logger.atFine()).log("Flat glob is on, but doesn't work for scheme '%s', using default behavior.", (Object)this.getUri().getScheme());
            return false;
        }
        GlobPattern fullPattern = new GlobPattern(fixedPath.toString());
        if (!fullPattern.hasWildcard()) {
            ((GoogleLogger.Api)logger.atFine()).log("Flat glob is on, but Path '%s' has no wildcard, using default behavior.", (Object)fixedPath);
            return false;
        }
        if (Strings.isNullOrEmpty((String)fixedPath.toUri().getAuthority())) {
            ((GoogleLogger.Api)logger.atFine()).log("Flat glob is on, but Path '%s' has a empty authority, using default behavior.", (Object)fixedPath);
            return false;
        }
        GlobPattern authorityPattern = new GlobPattern(fixedPath.toUri().getAuthority());
        if (authorityPattern.hasWildcard()) {
            ((GoogleLogger.Api)logger.atFine()).log("Flat glob is on, but Path '%s' has a wildcard authority, using default behavior.", (Object)fixedPath);
            return false;
        }
        return true;
    }

    @VisibleForTesting
    String trimToPrefixWithoutGlob(String path) {
        char[] wildcardChars = "*?{[".toCharArray();
        int trimIndex = path.length();
        for (char wildcard : wildcardChars) {
            int wildcardIndex = path.indexOf(wildcard);
            if (wildcardIndex < 0 || wildcardIndex >= trimIndex) continue;
            trimIndex = wildcardIndex;
        }
        return path.substring(0, trimIndex);
    }

    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        return this.globStatus(pathPattern, DEFAULT_FILTER);
    }

    private FileStatus[] concurrentGlobInternal(Path fixedPath, PathFilter filter) throws IOException {
        try {
            return (FileStatus[])this.backgroundTasksThreadPool.invokeAny(ImmutableList.of(() -> this.flatGlobInternal(fixedPath, filter), () -> super.globStatus(fixedPath, filter)));
        }
        catch (InterruptedException e) {
            GoogleCloudStorageEventBus.postOnException();
            Thread.currentThread().interrupt();
            throw new IOException(String.format("Concurrent glob execution failed: %s", e), e);
        }
        catch (ExecutionException e) {
            GoogleCloudStorageEventBus.postOnException();
            throw new IOException(String.format("Concurrent glob execution failed: %s", e.getCause()), e);
        }
    }

    private FileStatus[] flatGlobInternal(Path fixedPath, PathFilter filter) throws IOException {
        GoogleCloudStorage.ListPage infoPage;
        String pathString = fixedPath.toString();
        String prefixString = this.trimToPrefixWithoutGlob(pathString);
        Path prefixPath = new Path(prefixString);
        URI prefixUri = this.getGcsPath(prefixPath);
        if (prefixString.endsWith("/") && !prefixPath.toString().endsWith("/")) {
            prefixUri = UriPaths.toDirectory((URI)prefixUri);
        }
        ((GoogleLogger.Api)logger.atFiner()).log("Listing everything with '%s' prefix", (Object)prefixUri);
        ArrayList<FileStatus> matchedStatuses = null;
        String pageToken = null;
        do {
            infoPage = this.getGcsFs().listFileInfoForPrefixPage(prefixUri, LIST_OPTIONS, pageToken);
            Collection<FileStatus> statusPage = this.toFileStatusesWithImplicitDirectories(infoPage.getItems());
            FileSystem helperFileSystem = InMemoryGlobberFileSystem.createInstance(this.getConf(), this.getWorkingDirectory(), statusPage);
            FileStatus[] matchedStatusPage = helperFileSystem.globStatus(fixedPath, filter);
            if (matchedStatusPage == null) continue;
            Collections.addAll(matchedStatuses == null ? new ArrayList<FileStatus>() : matchedStatuses, matchedStatusPage);
        } while ((pageToken = infoPage.getNextPageToken()) != null);
        if (matchedStatuses == null || matchedStatuses.isEmpty()) {
            return matchedStatuses == null ? null : new FileStatus[]{};
        }
        matchedStatuses.sort(Comparator.naturalOrder().thenComparingInt(f -> GoogleHadoopFileSystem.isImplicitDirectory(f) ? 1 : 0));
        ArrayList<FileStatus> filteredStatuses = new ArrayList<FileStatus>(matchedStatuses.size());
        FileStatus lastAdded = null;
        for (FileStatus fileStatus : matchedStatuses) {
            if (lastAdded != null && lastAdded.compareTo(fileStatus) == 0) continue;
            filteredStatuses.add(fileStatus);
            lastAdded = fileStatus;
        }
        return filteredStatuses.toArray(new FileStatus[0]);
    }

    private Collection<FileStatus> toFileStatusesWithImplicitDirectories(Collection<FileInfo> fileInfos) throws IOException {
        ArrayList<FileStatus> fileStatuses = new ArrayList<FileStatus>(fileInfos.size());
        HashSet filePaths = Sets.newHashSetWithExpectedSize((int)fileInfos.size());
        String userName = GoogleHadoopFileSystem.getUgiUserName();
        for (FileInfo fileInfo : fileInfos) {
            filePaths.add(fileInfo.getPath());
            fileStatuses.add(this.getGoogleHadoopFileStatus(fileInfo, userName));
        }
        for (FileInfo fileInfo : fileInfos) {
            URI parentPath = UriPaths.getParentPath((URI)fileInfo.getPath());
            while (parentPath != null && !parentPath.equals(GoogleCloudStorageFileSystem.GCS_ROOT)) {
                if (!filePaths.contains(parentPath)) {
                    ((GoogleLogger.Api)logger.atFiner()).log("Adding fake entry for missing parent path '%s'", (Object)parentPath);
                    StorageResourceId id = StorageResourceId.fromUriPath((URI)parentPath, (boolean)true);
                    GoogleCloudStorageItemInfo fakeItemInfo = GoogleCloudStorageItemInfo.createInferredDirectory((StorageResourceId)id);
                    FileInfo fakeFileInfo = FileInfo.fromItemInfo((GoogleCloudStorageItemInfo)fakeItemInfo);
                    filePaths.add(parentPath);
                    fileStatuses.add(this.getGoogleHadoopFileStatus(fakeFileInfo, userName));
                }
                parentPath = UriPaths.getParentPath((URI)parentPath);
            }
        }
        return fileStatuses;
    }

    public Path getHomeDirectory() {
        Path result = new Path(this.fsRoot, "user/" + System.getProperty("user.name"));
        ((GoogleLogger.Api)logger.atFiner()).log("getHomeDirectory(): %s", (Object)result);
        return result;
    }

    public String getCanonicalServiceName() {
        String result = this.delegationTokens == null ? null : this.delegationTokens.getService().toString();
        ((GoogleLogger.Api)logger.atFiner()).log("getCanonicalServiceName(): %s", (Object)result);
        return result;
    }

    public GoogleCloudStorageFileSystem getGcsFs() {
        return this.gcsFsSupplier.get();
    }

    public Supplier<VectoredIOImpl> getVectoredIOSupplier() {
        return this.vectoredIOSupplier;
    }

    private AccessTokenProvider getDelegationAccessTokenProvider(Configuration config) {
        AccessTokenProvider accessTokenProvider;
        AccessTokenProvider accessTokenProvider2 = accessTokenProvider = this.delegationTokens == null ? null : this.delegationTokens.getAccessTokenProvider();
        if (accessTokenProvider != null) {
            accessTokenProvider.setConf(config);
        }
        return accessTokenProvider;
    }

    private void checkOpen() throws IOException {
        if (this.isClosed()) {
            GoogleCloudStorageEventBus.postOnException();
            throw new IOException("GoogleHadoopFileSystem has been closed or not initialized.");
        }
    }

    boolean isClosed() {
        return this.gcsFsSupplier == null || this.gcsFsSupplier.get() == null;
    }

    public boolean deleteOnExit(Path f) throws IOException {
        this.checkOpen();
        boolean result = super.deleteOnExit(f);
        ((GoogleLogger.Api)logger.atFiner()).log("deleteOnExit(path: %s): %b", (Object)f, result);
        return result;
    }

    protected void processDeleteOnExit() {
        ((GoogleLogger.Api)logger.atFiner()).log("processDeleteOnExit()");
        super.processDeleteOnExit();
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        ContentSummary result = super.getContentSummary(f);
        ((GoogleLogger.Api)logger.atFiner()).log("getContentSummary(path: %s): %b", (Object)f, (Object)result);
        return result;
    }

    public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("copyToLocalFile(delSrc: %b, src: %s, dst: %s)", (Object)delSrc, (Object)src, (Object)dst);
        super.copyToLocalFile(delSrc, src, dst);
    }

    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        Path result = super.startLocalOutput(fsOutputFile, tmpLocalFile);
        ((GoogleLogger.Api)logger.atFiner()).log("startLocalOutput(fsOutputFile: %s, tmpLocalFile: %s): %s", (Object)fsOutputFile, (Object)tmpLocalFile, (Object)result);
        return result;
    }

    public void completeLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("startLocalOutput(fsOutputFile: %s, tmpLocalFile: %s)", (Object)fsOutputFile, (Object)tmpLocalFile);
        super.completeLocalOutput(fsOutputFile, tmpLocalFile);
    }

    public void close() throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("close()");
        super.close();
        if (this.gcsFsSupplier != null) {
            if (this.gcsFsInitialized) {
                this.getGcsFs().close();
            }
            this.gcsFsSupplier = null;
        }
        if (this.delegationTokens != null) {
            try {
                this.delegationTokens.close();
            }
            catch (IOException e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause((Throwable)e)).log("Failed to stop delegation tokens support");
            }
        }
        if (this.vectoredIOSupplier != null && this.vectoredIOInitialized) {
            try {
                this.vectoredIOSupplier.get().close();
            }
            catch (Exception e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause((Throwable)e)).log("Failed to close the underneath vectoredIO implementation");
            }
            finally {
                this.vectoredIOSupplier = null;
                this.vectoredIOInitialized = false;
            }
        }
        this.backgroundTasksThreadPool.shutdown();
        this.backgroundTasksThreadPool = null;
    }

    public long getUsed() throws IOException {
        long result = super.getUsed();
        ((GoogleLogger.Api)logger.atFiner()).log("getUsed(): %s", result);
        return result;
    }

    public long getDefaultBlockSize() {
        ((GoogleLogger.Api)logger.atFiner()).log("getDefaultBlockSize(): %d", this.defaultBlockSize);
        return this.defaultBlockSize;
    }

    public void setWorkingDirectory(Path hadoopPath) {
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        URI gcsPath = UriPaths.toDirectory((URI)this.getGcsPath(hadoopPath));
        this.workingDirectory = this.getHadoopPath(gcsPath);
        ((GoogleLogger.Api)logger.atFiner()).log("setWorkingDirectory(hadoopPath: %s): %s", (Object)hadoopPath, (Object)this.workingDirectory);
    }

    public void setVerifyChecksum(boolean verifyChecksum) {
        ((GoogleLogger.Api)logger.atFiner()).log("setVerifyChecksum(verifyChecksum: %s)", (Object)verifyChecksum);
        super.setVerifyChecksum(verifyChecksum);
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("setPermission(path: %s, permission: %s)", (Object)p, (Object)permission);
        super.setPermission(p, permission);
    }

    public void setOwner(Path p, String username, String groupname) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("setOwner(path: %s, username: %s, groupname: %s)", (Object)p, (Object)username, (Object)groupname);
        super.setOwner(p, username, groupname);
    }

    public void setTimes(Path p, long mtime, long atime) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("setTimes(path: %s, mtime: %d, atime: %d)", (Object)p, (Object)mtime, (Object)atime);
        super.setTimes(p, mtime, atime);
    }

    public void setXAttr(Path path, String name, byte[] value, EnumSet<XAttrSetFlag> flags) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("setXAttr(path: %s, name: %s, value %s, flags %s", (Object)path, (Object)name, (Object)LazyArgs.lazy(() -> new String(value, StandardCharsets.UTF_8)), flags);
        Preconditions.checkNotNull((Object)path, (Object)"path should not be null");
        Preconditions.checkNotNull((Object)name, (Object)"name should not be null");
        Preconditions.checkArgument((flags != null && !flags.isEmpty() ? 1 : 0) != 0, (Object)"flags should not be null or empty");
        FileInfo fileInfo = this.getGcsFs().getFileInfo(this.getGcsPath(path));
        String xAttrKey = this.getXAttrKey(name);
        Map attributes = fileInfo.getAttributes();
        if (attributes.containsKey(xAttrKey) && !flags.contains(XAttrSetFlag.REPLACE)) {
            GoogleCloudStorageEventBus.postOnException();
            throw new IOException(String.format("REPLACE flag must be set to update XAttr (name='%s', value='%s') for '%s'", name, new String(value, StandardCharsets.UTF_8), path));
        }
        if (!attributes.containsKey(xAttrKey) && !flags.contains(XAttrSetFlag.CREATE)) {
            GoogleCloudStorageEventBus.postOnException();
            throw new IOException(String.format("CREATE flag must be set to create XAttr (name='%s', value='%s') for '%s'", name, new String(value, StandardCharsets.UTF_8), path));
        }
        UpdatableItemInfo updateInfo = new UpdatableItemInfo(StorageResourceId.fromUriPath((URI)fileInfo.getPath(), (boolean)false), (Map)ImmutableMap.of((Object)xAttrKey, (Object)this.getXAttrValue(value)));
        this.getGcsFs().getGcs().updateItems((List)ImmutableList.of((Object)updateInfo));
    }

    public void removeXAttr(Path path, String name) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("removeXAttr(path: %s, name: %s)", (Object)path, (Object)name);
        Preconditions.checkNotNull((Object)path, (Object)"path should not be null");
        Preconditions.checkNotNull((Object)name, (Object)"name should not be null");
        FileInfo fileInfo = this.getGcsFs().getFileInfo(this.getGcsPath(path));
        HashMap<String, Object> xAttrToRemove = new HashMap<String, Object>();
        xAttrToRemove.put(this.getXAttrKey(name), null);
        UpdatableItemInfo updateInfo = new UpdatableItemInfo(StorageResourceId.fromUriPath((URI)fileInfo.getPath(), (boolean)false), xAttrToRemove);
        this.getGcsFs().getGcs().updateItems((List)ImmutableList.of((Object)updateInfo));
    }

    private boolean isXAttr(String key) {
        return key != null && key.startsWith(XATTR_KEY_PREFIX);
    }

    private String getXAttrKey(String name) {
        return XATTR_KEY_PREFIX + name;
    }

    private String getXAttrName(String key) {
        return key.substring(XATTR_KEY_PREFIX.length());
    }

    private byte[] getXAttrValue(byte[] value) {
        return value == null ? XATTR_NULL_VALUE : value;
    }

    static {
        ((GoogleLogger.Api)logger.atFine()).log("GHFS version: %s", (Object)VERSION);
        GHFS_ID = String.format("GHFS/%s", VERSION);
    }

    private static class GcsFileChecksum
    extends FileChecksum {
        private final GcsFileChecksumType checksumType;
        private final byte[] bytes;

        public GcsFileChecksum(GcsFileChecksumType checksumType, byte[] bytes) {
            this.checksumType = checksumType;
            this.bytes = bytes;
            Preconditions.checkState((bytes == null || bytes.length == checksumType.getByteLength() ? 1 : 0) != 0, (String)"Checksum value length (%s) should be equal to the algorithm byte length (%s)", (int)checksumType.getByteLength(), bytes == null ? null : Integer.valueOf(bytes.length));
        }

        public String getAlgorithmName() {
            return this.checksumType.getAlgorithmName();
        }

        public int getLength() {
            return this.checksumType.getByteLength();
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public void readFields(DataInput in) throws IOException {
            in.readFully(this.bytes);
        }

        public void write(DataOutput out) throws IOException {
            out.write(this.bytes);
        }

        public String toString() {
            return String.format("%s: %s", this.getAlgorithmName(), this.bytes == null ? null : BaseEncoding.base16().encode(this.bytes));
        }
    }

    public static enum GlobAlgorithm {
        CONCURRENT,
        DEFAULT,
        FLAT;

    }

    public static enum GcsFileChecksumType {
        NONE(null, 0),
        CRC32C("COMPOSITE-CRC32C", 4),
        MD5("MD5", 16);

        private final String algorithmName;
        private final int byteLength;

        private GcsFileChecksumType(String algorithmName, int byteLength) {
            this.algorithmName = algorithmName;
            this.byteLength = byteLength;
        }

        public String getAlgorithmName() {
            return this.algorithmName;
        }

        public int getByteLength() {
            return this.byteLength;
        }
    }
}

