/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemImpl;
import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class BatchExecutor {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final ExecutorService requestsExecutor;
    private final Queue<Future<Void>> responseFutures = new ConcurrentLinkedQueue<Future<Void>>();

    public BatchExecutor(int numThreads) {
        this.requestsExecutor = numThreads == 0 ? MoreExecutors.newDirectExecutorService() : BatchExecutor.newRequestExecutor(numThreads);
    }

    private static ExecutorService newRequestExecutor(int numThreads) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(numThreads, numThreads, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(numThreads * 20), new ThreadFactoryBuilder().setNameFormat("gcs-manual-batching-pool-%d").setDaemon(true).build());
        executor.allowCoreThreadTimeOut(true);
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        return executor;
    }

    public <T> void queue(Callable<T> task, FutureCallback<T> callback) {
        Preconditions.checkState((!this.requestsExecutor.isShutdown() && !this.requestsExecutor.isTerminated() ? 1 : 0) != 0, (Object)"requestExecutor should not be terminated to queue request");
        this.responseFutures.add(this.requestsExecutor.submit(() -> {
            BatchExecutor.execute(task, callback);
            return null;
        }));
    }

    private static <T> void execute(Callable<T> task, FutureCallback<T> callback) {
        Preconditions.checkArgument((callback != null ? 1 : 0) != 0, (String)"FutureCallBack cannot be null : %s", callback);
        try {
            T result = task.call();
            callback.onSuccess(result);
        }
        catch (Throwable throwable) {
            callback.onFailure(throwable);
        }
    }

    public void shutdown() throws IOException {
        try {
            this.awaitRequestsCompletion();
            Preconditions.checkState((boolean)this.responseFutures.isEmpty(), (Object)"responseFutures should be empty after flush");
        }
        finally {
            this.requestsExecutor.shutdown();
            try {
                if (!this.requestsExecutor.awaitTermination(1L, TimeUnit.MINUTES)) {
                    ((GoogleLogger.Api)logger.atWarning()).log("Forcibly shutting down manual batching thread pool.");
                    this.requestsExecutor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withCause((Throwable)e)).log("Failed to await termination: forcibly shutting down manual batching thread pool.");
                this.requestsExecutor.shutdownNow();
            }
        }
    }

    private void awaitRequestsCompletion() throws IOException {
        while (!this.responseFutures.isEmpty()) {
            GoogleCloudStorageFileSystemImpl.getFromFuture(this.responseFutures.remove());
        }
    }
}

