/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.gcsio.AutoValue_CreateFileOptions;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.util.Map;
import javax.annotation.Nullable;

@AutoValue
public abstract class CreateFileOptions {
    public static final CreateFileOptions DEFAULT = CreateFileOptions.builder().build();

    public static Builder builder() {
        return new AutoValue_CreateFileOptions.Builder().setAttributes((Map<String, byte[]>)ImmutableMap.of()).setContentType(CreateObjectOptions.DEFAULT_OVERWRITE.getContentType()).setEnsureNoDirectoryConflict(true).setMinSyncInterval(Duration.ZERO).setOverwriteGenerationId(-1L).setWriteMode(WriteMode.CREATE_NEW);
    }

    public abstract Builder toBuilder();

    public abstract ImmutableMap<String, byte[]> getAttributes();

    @Nullable
    public abstract String getContentType();

    public abstract Duration getMinSyncInterval();

    public abstract boolean isEnsureNoDirectoryConflict();

    public abstract WriteMode getWriteMode();

    public abstract long getOverwriteGenerationId();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setAttributes(Map<String, byte[]> var1);

        public abstract Builder setContentType(String var1);

        public abstract Builder setEnsureNoDirectoryConflict(boolean var1);

        public abstract Builder setMinSyncInterval(Duration var1);

        public abstract Builder setOverwriteGenerationId(long var1);

        public abstract Builder setWriteMode(WriteMode var1);

        abstract CreateFileOptions autoBuild();

        public CreateFileOptions build() {
            CreateFileOptions options = this.autoBuild();
            Preconditions.checkArgument((!options.getAttributes().containsKey((Object)"Content-Type") ? 1 : 0) != 0, (Object)"The Content-Type attribute must be set via the contentType option");
            if (options.getWriteMode() != WriteMode.OVERWRITE) {
                Preconditions.checkArgument((options.getOverwriteGenerationId() == -1L ? 1 : 0) != 0, (String)"overwriteGenerationId is set to %s but it can be set only in OVERWRITE mode", (long)options.getOverwriteGenerationId());
            }
            return options;
        }
    }

    public static enum WriteMode {
        APPEND,
        CREATE_NEW,
        OVERWRITE;

    }
}

