/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.UriPaths;
import com.google.cloud.hadoop.gcsio.VerificationAttributes;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FileInfo {
    public static final FileInfo ROOT_INFO = new FileInfo(GoogleCloudStorageFileSystem.GCS_ROOT, GoogleCloudStorageItemInfo.ROOT_INFO);
    private final URI path;
    private final GoogleCloudStorageItemInfo itemInfo;

    private FileInfo(URI path, GoogleCloudStorageItemInfo itemInfo) {
        this.itemInfo = itemInfo;
        this.path = path;
    }

    public URI getPath() {
        return this.path;
    }

    public boolean isDirectory() {
        return this.itemInfo.isDirectory();
    }

    public boolean isInferredDirectory() {
        return this.itemInfo.isInferredDirectory();
    }

    public boolean isGlobalRoot() {
        return this.itemInfo.isGlobalRoot();
    }

    public long getCreationTime() {
        return this.itemInfo.getCreationTime();
    }

    public long getSize() {
        return this.itemInfo.getSize();
    }

    public long getModificationTime() {
        return this.itemInfo.getModificationTime();
    }

    public Map<String, byte[]> getAttributes() {
        return this.itemInfo.getMetadata();
    }

    public boolean exists() {
        return this.itemInfo.exists();
    }

    public byte[] getCrc32cChecksum() {
        VerificationAttributes verificationAttributes = this.itemInfo.getVerificationAttributes();
        return verificationAttributes == null ? null : verificationAttributes.getCrc32c();
    }

    public byte[] getMd5Checksum() {
        VerificationAttributes verificationAttributes = this.itemInfo.getVerificationAttributes();
        return verificationAttributes == null ? null : verificationAttributes.getMd5hash();
    }

    GoogleCloudStorageItemInfo getItemInfo() {
        return this.itemInfo;
    }

    public String toString() {
        return this.getPath() + (String)(this.exists() ? ": created on: " + Instant.ofEpochMilli(this.getCreationTime()) : ": exists: no");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileInfo)) {
            return false;
        }
        FileInfo fileInfo = (FileInfo)o;
        return Objects.equals(this.path, fileInfo.path) && Objects.equals(this.itemInfo, fileInfo.itemInfo);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.itemInfo);
    }

    public static FileInfo fromItemInfo(GoogleCloudStorageItemInfo itemInfo) {
        if (itemInfo.isRoot()) {
            return ROOT_INFO;
        }
        URI path = UriPaths.fromResourceId(itemInfo.getResourceId(), true);
        return new FileInfo(path, itemInfo);
    }

    public static List<FileInfo> fromItemInfos(List<GoogleCloudStorageItemInfo> itemInfos) {
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>(itemInfos.size());
        for (GoogleCloudStorageItemInfo itemInfo : itemInfos) {
            fileInfos.add(FileInfo.fromItemInfo(itemInfo));
        }
        return fileInfos;
    }
}

